-- MariaDB dump 10.19  Distrib 10.11.6-MariaDB, for debian-linux-gnu (x86_64)
--
-- Host: 10.123.25.254    Database: kimai3
-- ------------------------------------------------------
-- Server version	10.11.9-MariaDB-0+deb12u1

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `kimai2_activities`
--

DROP TABLE IF EXISTS `kimai2_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `kimai2_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` int(11) DEFAULT NULL,
  `name` varchar(150) NOT NULL,
  `comment` text DEFAULT NULL,
  `visible` tinyint(1) NOT NULL,
  `color` varchar(7) DEFAULT NULL,
  `time_budget` int(11) NOT NULL DEFAULT 0,
  `budget` double NOT NULL DEFAULT 0,
  `budget_type` varchar(10) DEFAULT NULL,
  `billable` tinyint(1) NOT NULL DEFAULT 1,
  `invoice_text` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_8811FE1C166D1F9C` (`project_id`),
  KEY `IDX_8811FE1C7AB0E859166D1F9C` (`visible`,`project_id`),
  KEY `IDX_8811FE1C7AB0E859166D1F9C5E237E06` (`visible`,`project_id`,`name`),
  KEY `IDX_8811FE1C7AB0E8595E237E06` (`visible`,`name`),
  CONSTRAINT `FK_8811FE1C166D1F9C` FOREIGN KEY (`project_id`) REFERENCES `kimai2_projects` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `kimai2_activities`
--

LOCK TABLES `kimai2_activities` WRITE;
/*!40000 ALTER TABLE `kimai2_activities` DISABLE KEYS */;
INSERT INTO `kimai2_activities` VALUES
(1,NULL,'Intervento Remoto','Assistenza remota software',1,'#d2d6de',0,0,NULL,1,NULL),
(2,NULL,'Intervento dal Cliente','Interventi nella sede del cliente Hardware e Software',1,NULL,0,0,NULL,1,NULL),
(3,112,'Personale',NULL,1,'#ff0000',0,0,NULL,1,NULL),
(4,NULL,'Intervento in Laboratorio',NULL,1,NULL,0,0,NULL,1,NULL),
(6,NULL,'Intervento Telefonico',NULL,1,NULL,0,0,NULL,1,NULL);
/*!40000 ALTER TABLE `kimai2_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `kimai2_activities_meta`
--

DROP TABLE IF EXISTS `kimai2_activities_meta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `kimai2_activities_meta` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `activity_id` int(11) NOT NULL,
  `name` varchar(50) NOT NULL,
  `value` text DEFAULT NULL,
  `visible` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_A7C0A43D81C060965E237E06` (`activity_id`,`name`),
  KEY `IDX_A7C0A43D81C06096` (`activity_id`),
  CONSTRAINT `FK_A7C0A43D81C06096` FOREIGN KEY (`activity_id`) REFERENCES `kimai2_activities` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `kimai2_activities_meta`
--

LOCK TABLES `kimai2_activities_meta` WRITE;
/*!40000 ALTER TABLE `kimai2_activities_meta` DISABLE KEYS */;
/*!40000 ALTER TABLE `kimai2_activities_meta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `kimai2_activities_rates`
--

DROP TABLE IF EXISTS `kimai2_activities_rates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `kimai2_activities_rates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `activity_id` int(11) DEFAULT NULL,
  `rate` double NOT NULL,
  `fixed` tinyint(1) NOT NULL,
  `internal_rate` double DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_4A7F11BEA76ED39581C06096` (`user_id`,`activity_id`),
  KEY `IDX_4A7F11BEA76ED395` (`user_id`),
  KEY `IDX_4A7F11BE81C06096` (`activity_id`),
  CONSTRAINT `FK_4A7F11BE81C06096` FOREIGN KEY (`activity_id`) REFERENCES `kimai2_activities` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_4A7F11BEA76ED395` FOREIGN KEY (`user_id`) REFERENCES `kimai2_users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `kimai2_activities_rates`
--

LOCK TABLES `kimai2_activities_rates` WRITE;
/*!40000 ALTER TABLE `kimai2_activities_rates` DISABLE KEYS */;
/*!40000 ALTER TABLE `kimai2_activities_rates` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `kimai2_activities_teams`
--

DROP TABLE IF EXISTS `kimai2_activities_teams`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `kimai2_activities_teams` (
  `activity_id` int(11) NOT NULL,
  `team_id` int(11) NOT NULL,
  PRIMARY KEY (`activity_id`,`team_id`),
  KEY `IDX_986998DA81C06096` (`activity_id`),
  KEY `IDX_986998DA296CD8AE` (`team_id`),
  CONSTRAINT `FK_986998DA296CD8AE` FOREIGN KEY (`team_id`) REFERENCES `kimai2_teams` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_986998DA81C06096` FOREIGN KEY (`activity_id`) REFERENCES `kimai2_activities` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `kimai2_activities_teams`
--

LOCK TABLES `kimai2_activities_teams` WRITE;
/*!40000 ALTER TABLE `kimai2_activities_teams` DISABLE KEYS */;
/*!40000 ALTER TABLE `kimai2_activities_teams` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `kimai2_bookmarks`
--

DROP TABLE IF EXISTS `kimai2_bookmarks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `kimai2_bookmarks` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `content` longtext NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_4016EF25A76ED3955E237E06` (`user_id`,`name`),
  KEY `IDX_4016EF25A76ED395` (`user_id`),
  CONSTRAINT `FK_4016EF25A76ED395` FOREIGN KEY (`user_id`) REFERENCES `kimai2_users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `kimai2_bookmarks`
--

LOCK TABLES `kimai2_bookmarks` WRITE;
/*!40000 ALTER TABLE `kimai2_bookmarks` DISABLE KEYS */;
INSERT INTO `kimai2_bookmarks` VALUES
(1,1,'columns','export','{\"avatar\":true,\"project\":true,\"description\":true,\"duration\":true}'),
(3,3,'columns','timesheet_mobile','{\"duration\":true,\"customer\":true,\"actions\":true}'),
(4,1,'columns','timesheet','{\"starttime\":true,\"endtime\":true,\"duration\":true,\"customer\":true,\"activity\":true,\"description\":true,\"tags\":true,\"actions\":true}'),
(6,2,'columns','timesheet_admin','{\"starttime\":true,\"endtime\":true,\"duration\":true,\"customer\":true,\"project\":true,\"activity\":true,\"description\":true,\"username\":true,\"actions\":true}'),
(7,2,'columns','export','{\"avatar\":true,\"project\":true,\"activity\":true,\"description\":true,\"duration\":true}'),
(8,3,'columns','timesheet','{\"starttime\":true,\"endtime\":true,\"customer\":true,\"project\":true,\"activity\":true,\"description\":true,\"actions\":true}'),
(9,2,'search-default','ExportQuery','{\"searchTerm\":\"\",\"daterange\":\"01\\/01\\/2024 - 31\\/12\\/2025\",\"customers\":[\"6\"],\"projects\":[\"6\"],\"activities\":[],\"tags\":[],\"users\":[],\"exported\":\"5\",\"state\":\"1\",\"billable\":\"0\",\"renderer\":\"\",\"markAsExported\":\"0\"}');
/*!40000 ALTER TABLE `kimai2_bookmarks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `kimai2_configuration`
--

DROP TABLE IF EXISTS `kimai2_configuration`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `kimai2_configuration` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `value` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_1C5D63D85E237E06` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `kimai2_configuration`
--

LOCK TABLES `kimai2_configuration` WRITE;
/*!40000 ALTER TABLE `kimai2_configuration` DISABLE KEYS */;
INSERT INTO `kimai2_configuration` VALUES
(1,'timesheet.rounding.default.mode','default'),
(2,'timesheet.rounding.default.begin','0'),
(3,'timesheet.rounding.default.end','0'),
(4,'timesheet.rounding.default.duration','0'),
(5,'timesheet.rounding.default.days','monday,tuesday,wednesday,thursday,friday,saturday,sunday'),
(6,'timesheet.mode','default'),
(7,'timesheet.default_begin','now'),
(8,'timesheet.rules.allow_future_times','1'),
(9,'timesheet.rules.allow_overlapping_records','1'),
(10,'timesheet.rules.allow_overbooking_budget','1'),
(11,'timesheet.rules.lockdown_period_start',NULL),
(12,'timesheet.rules.lockdown_period_end',NULL),
(13,'timesheet.rules.lockdown_grace_period',NULL),
(14,'timesheet.active_entries.hard_limit','1'),
(16,'timesheet.time_increment',NULL),
(17,'timesheet.duration_increment',NULL),
(18,'defaults.customer.timezone','Europe/Rome'),
(19,'defaults.customer.country','IT'),
(20,'defaults.customer.currency','EUR'),
(21,'defaults.user.timezone','Europe/Rome'),
(22,'defaults.user.language','it'),
(23,'defaults.user.theme','default'),
(24,'defaults.user.currency','EUR'),
(25,'calendar.week_numbers','1'),
(26,'calendar.weekends','1'),
(27,'calendar.businessHours.begin','08:30'),
(28,'calendar.businessHours.end','18:30'),
(29,'calendar.visibleHours.begin','07:00'),
(30,'calendar.visibleHours.end','23:59'),
(31,'calendar.slot_duration','00:30:00'),
(32,'activity.choice_pattern','{name}{spacer}{comment}');
/*!40000 ALTER TABLE `kimai2_configuration` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `kimai2_customers`
--

DROP TABLE IF EXISTS `kimai2_customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `kimai2_customers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(150) NOT NULL,
  `number` varchar(50) DEFAULT NULL,
  `comment` text DEFAULT NULL,
  `visible` tinyint(1) NOT NULL,
  `company` varchar(100) DEFAULT 'NULL',
  `contact` varchar(100) DEFAULT 'NULL',
  `address` text DEFAULT NULL,
  `country` varchar(2) NOT NULL,
  `currency` varchar(3) NOT NULL,
  `phone` varchar(30) DEFAULT 'NULL',
  `fax` varchar(30) DEFAULT 'NULL',
  `mobile` varchar(30) DEFAULT 'NULL',
  `email` varchar(75) DEFAULT 'NULL',
  `homepage` varchar(100) DEFAULT 'NULL',
  `timezone` varchar(64) NOT NULL,
  `color` varchar(7) DEFAULT NULL,
  `time_budget` int(11) NOT NULL DEFAULT 0,
  `budget` double NOT NULL DEFAULT 0,
  `vat_id` varchar(50) DEFAULT NULL,
  `budget_type` varchar(10) DEFAULT NULL,
  `billable` tinyint(1) NOT NULL DEFAULT 1,
  `invoice_template_id` int(11) DEFAULT NULL,
  `invoice_text` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_5A9760447AB0E859` (`visible`),
  KEY `IDX_5A97604412946D8B` (`invoice_template_id`),
  CONSTRAINT `FK_5A97604412946D8B` FOREIGN KEY (`invoice_template_id`) REFERENCES `kimai2_invoice_templates` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=144 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `kimai2_customers`
--

LOCK TABLES `kimai2_customers` WRITE;
/*!40000 ALTER TABLE `kimai2_customers` DISABLE KEYS */;
INSERT INTO `kimai2_customers` VALUES
(1,'Aldo Rapallo',NULL,NULL,1,NULL,'Fabrizio Bodrato','Via Al Molo Giano','IT','EUR','010255154',NULL,NULL,'fabrizio.bodrato@aldorapallo.it',NULL,'Europe/Rome','#d2d6de',0,0,'02216960100',NULL,1,NULL,NULL),
(2,'Cristallina Water',NULL,NULL,1,NULL,NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome','#d2d6de',0,0,NULL,NULL,1,NULL,NULL),
(3,'Laboratorio',NULL,'Interventi laboratorio',1,NULL,NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome','#0000ff',0,0,NULL,NULL,1,NULL,NULL),
(4,'AbVolt','abvolt',NULL,1,'AbVolt',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(5,'Acier Steel',NULL,NULL,1,'Acier Steel',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(6,'Acli',NULL,NULL,1,'Acli',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(7,'All3',NULL,NULL,1,'All3',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(8,'Amm. Berruti',NULL,NULL,1,'Amm. Berruti',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(9,'Amw',NULL,NULL,1,'Amw',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(10,'Andi',NULL,NULL,1,'Andi',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(11,'Architetto Luciano Fratini',NULL,NULL,1,'Architetto Luciano Fratini',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(12,'Art Design',NULL,NULL,1,'Art Design',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(13,'Avv. Blengino Tiziana',NULL,NULL,1,'Avv. Blengino Tiziana',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(14,'Avv. Giovanna Raffo',NULL,NULL,1,'Avv. Giovanna Raffo',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(15,'Avv. Gronò',NULL,NULL,1,'Avv. Gronò',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(16,'Axel Industry',NULL,NULL,1,'Axel Industry',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(17,'Ballerini',NULL,NULL,1,'Ballerini',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(18,'Balostro Autotrasporti',NULL,NULL,1,'Balostro Autotrasporti',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(19,'Bdf',NULL,NULL,1,'Bdf',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(20,'Belgioia (ex Viotti)',NULL,NULL,1,'Belgioia (ex Viotti)',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(21,'BM Ricambi',NULL,NULL,1,'BM Ricambi',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(22,'Boccaleri',NULL,NULL,1,'Boccaleri',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(23,'Brancato',NULL,NULL,1,'Brancato',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(24,'Carrozzeria KF',NULL,NULL,1,'Carrozzeria KF',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(25,'Casale Informatica',NULL,NULL,1,'Casale Informatica',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(26,'Confindustria Liguria',NULL,NULL,1,'Confindustria Liguria',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(27,'Conzi&Minetti',NULL,NULL,1,'Conzi&Minetti',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(28,'Coop Il Sole',NULL,NULL,1,'Coop Il Sole',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(29,'Cuneo Poli',NULL,NULL,1,'Cuneo Poli',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(30,'Curto e Ghio',NULL,NULL,1,'Curto e Ghio',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(31,'D\'angelo Portaccio',NULL,NULL,1,'D\'angelo Portaccio',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(32,'Daca',NULL,NULL,1,'Daca',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(33,'Damast',NULL,NULL,1,'Damast',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(34,'DE.FI.ME',NULL,NULL,1,'DE.FI.ME',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(35,'DexM',NULL,NULL,1,'DexM',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(36,'Digitech',NULL,NULL,1,'Digitech',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(37,'Dipartimento Chimica',NULL,NULL,1,'Dipartimento Chimica',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(38,'Dott. Rivara',NULL,NULL,1,'Dott. Rivara',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(39,'Duemila Caffè',NULL,NULL,1,'Duemila Caffè',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(40,'Dufour',NULL,NULL,1,'Dufour',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(41,'Ecologital',NULL,NULL,1,'Ecologital',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(42,'Edilbottani',NULL,NULL,1,'Edilbottani',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(43,'Ellebi Assemblaggi',NULL,NULL,1,'Ellebi Assemblaggi',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(44,'Emme Gas',NULL,NULL,1,'Emme Gas',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(45,'Estimo',NULL,NULL,1,'Estimo',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(46,'Factory',NULL,NULL,1,'Factory',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(47,'FB-Steel',NULL,NULL,1,'FB-Steel',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(48,'Fercos',NULL,NULL,1,'Fercos',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(49,'Ferrero',NULL,NULL,1,'Ferrero',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(50,'First',NULL,NULL,1,'First',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(51,'FremsLife',NULL,NULL,1,'FremsLife',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(52,'Gasparini',NULL,NULL,1,'Gasparini',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(53,'Gba',NULL,NULL,1,'Gba',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(54,'Grac',NULL,NULL,1,'Grac',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(55,'Il Libro',NULL,NULL,1,'Il Libro',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(56,'Imp Servizi',NULL,NULL,1,'Imp Servizi',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(57,'Istologia',NULL,NULL,1,'Istologia',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(58,'Job Service',NULL,NULL,1,'Job Service',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(59,'La Ligure',NULL,NULL,1,'La Ligure',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(60,'Lanzilotta',NULL,NULL,1,'Lanzilotta',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(61,'Lega Navale',NULL,NULL,1,'Lega Navale',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(62,'Linea Grafica',NULL,NULL,1,'Linea Grafica',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(63,'Logos',NULL,NULL,1,'Logos',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(64,'Mabie',NULL,NULL,1,'Mabie',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(65,'Massimo Reggio',NULL,NULL,1,'Massimo Reggio',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(66,'MebSprint',NULL,NULL,1,'MebSprint',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(67,'Mediamax',NULL,NULL,1,'Mediamax',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(68,'Nibbles',NULL,NULL,1,'Nibbles',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(69,'NorthSails',NULL,NULL,1,'NorthSails',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(70,'Nuova Automeccanica',NULL,NULL,1,'Nuova Automeccanica',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(71,'Odontoiatria Legale',NULL,NULL,1,'Odontoiatria Legale',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(72,'Officina Fiumara',NULL,NULL,1,'Officina Fiumara',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(73,'Officina Prefumo',NULL,NULL,1,'Officina Prefumo',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(74,'Omp',NULL,NULL,1,'Omp',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(75,'Orion',NULL,NULL,1,'Orion',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(76,'Ortopedia&Sanitari',NULL,NULL,1,'Ortopedia&Sanitari',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(77,'Ottonelli',NULL,NULL,1,'Ottonelli',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(78,'Parodi ex MacPar',NULL,NULL,1,'Parodi ex MacPar',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(79,'Parodi Nutra',NULL,NULL,1,'Parodi Nutra',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(80,'Parodi srl',NULL,NULL,1,'Parodi srl',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(81,'Pellini',NULL,NULL,1,'Pellini',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(82,'Pneus Gomme',NULL,NULL,1,'Pneus Gomme',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(83,'Proba',NULL,NULL,1,'Proba',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(84,'Proff. Rui',NULL,NULL,1,'Proff. Rui',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(85,'Rellecati',NULL,NULL,1,'Rellecati',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(86,'Roland School',NULL,NULL,1,'Roland School',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(87,'Salsi Alvarino',NULL,NULL,1,'Salsi Alvarino',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(88,'Softability',NULL,NULL,1,'Softability',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(89,'Somigli',NULL,NULL,1,'Somigli',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(90,'Stegeo',NULL,NULL,1,'Stegeo',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(91,'Studio Arnera',NULL,NULL,1,'Studio Arnera',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(92,'Studio Borasio',NULL,NULL,1,'Studio Borasio',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(93,'Studio D\'Angelo',NULL,NULL,1,'Studio D\'Angelo',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(94,'Studio Dulio',NULL,NULL,1,'Studio Dulio',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(95,'Studio Emme',NULL,NULL,1,'Studio Emme',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(96,'Studio Gandolfo',NULL,NULL,1,'Studio Gandolfo',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(97,'Studio Modugno',NULL,NULL,1,'Studio Modugno',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(98,'Studio odontoiatrico Borasio',NULL,NULL,1,'Studio odontoiatrico Borasio',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(99,'Studio Polo',NULL,NULL,1,'Studio Polo',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(100,'Studio Sirotti',NULL,NULL,1,'Studio Sirotti',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(101,'Studio Vigo',NULL,NULL,1,'Studio Vigo',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(102,'Studio Viotti',NULL,NULL,1,'Studio Viotti',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(103,'TMS',NULL,NULL,1,'TMS',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(104,'Trado',NULL,NULL,1,'Trado',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(105,'Tuttogas',NULL,NULL,1,'Tuttogas',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(106,'Velotti Latticini',NULL,NULL,1,'Velotti Latticini',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(107,'Verardo Giampietro',NULL,NULL,1,'Verardo Giampietro',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(108,'Villa Serra',NULL,NULL,1,'Villa Serra',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(109,'Willis Towers Watson',NULL,NULL,1,'Willis Towers Watson',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(110,'Xplored',NULL,NULL,1,'Xplored',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(111,'Yacth Club Sestri Levante',NULL,NULL,1,'Yacth Club Sestri Levante',NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(112,'Personale',NULL,NULL,1,NULL,NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome','#ff0000',0,0,NULL,NULL,1,NULL,NULL),
(113,'Baglietto e figlio',NULL,NULL,1,NULL,NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(114,'Inkout',NULL,NULL,1,NULL,NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(115,'Liguria Fumi',NULL,NULL,1,NULL,NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(116,'Cirillo',NULL,NULL,1,NULL,NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,45,NULL,NULL,1,NULL,NULL),
(117,'Acli Service',NULL,NULL,1,NULL,NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,45,NULL,NULL,1,NULL,NULL),
(118,'Battistini',NULL,NULL,1,NULL,NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(119,'Chiara Persi',NULL,NULL,1,NULL,NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(120,'BcStudio',NULL,NULL,1,NULL,NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(121,'Ristagno Vril',NULL,NULL,1,NULL,NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(122,'CristinaMusso',NULL,NULL,1,NULL,NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(123,'TNI',NULL,NULL,1,NULL,NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(124,'Sibe',NULL,NULL,1,NULL,NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(125,'casanuda',NULL,NULL,1,NULL,NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(126,'Studio Carlini',NULL,NULL,1,NULL,NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(128,'CroceRossaCampomorone',NULL,NULL,1,NULL,NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(129,'M.A.C.','0128',NULL,1,NULL,NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome','#ff00ff',0,0,NULL,NULL,1,NULL,NULL),
(130,'Siba','0129',NULL,1,NULL,NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome','#ff00ff',0,0,NULL,NULL,1,NULL,NULL),
(131,'Studio Antognozzi','0130',NULL,1,NULL,NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(132,'Interpakaging','0131',NULL,1,NULL,NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(133,'Crucitti','0132',NULL,1,NULL,NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(134,'Dr Sola','0133',NULL,1,NULL,NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(135,'AZ Servizi','0134',NULL,1,NULL,NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(136,'Agenzia Il Mattone','0135',NULL,1,NULL,NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(137,'Colture di Casa','0136',NULL,1,NULL,NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(139,'Coop. Ponteggiatori','0137',NULL,1,NULL,NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(140,'Davide Dimensione Gomme','0138',NULL,1,NULL,NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(141,'Studio Bondelli','0139',NULL,1,NULL,NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(142,'B.M. Service','0140',NULL,1,NULL,NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL),
(143,'Hotel Miramare','0141',NULL,1,NULL,NULL,NULL,'IT','EUR',NULL,NULL,NULL,NULL,NULL,'Europe/Rome',NULL,0,0,NULL,NULL,1,NULL,NULL);
/*!40000 ALTER TABLE `kimai2_customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `kimai2_customers_comments`
--

DROP TABLE IF EXISTS `kimai2_customers_comments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `kimai2_customers_comments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `customer_id` int(11) NOT NULL,
  `created_by_id` int(11) NOT NULL,
  `message` longtext NOT NULL,
  `created_at` datetime NOT NULL COMMENT '(DC2Type:datetime)',
  `pinned` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `IDX_A5B142D99395C3F3` (`customer_id`),
  KEY `IDX_A5B142D9B03A8386` (`created_by_id`),
  CONSTRAINT `FK_A5B142D99395C3F3` FOREIGN KEY (`customer_id`) REFERENCES `kimai2_customers` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_A5B142D9B03A8386` FOREIGN KEY (`created_by_id`) REFERENCES `kimai2_users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `kimai2_customers_comments`
--

LOCK TABLES `kimai2_customers_comments` WRITE;
/*!40000 ALTER TABLE `kimai2_customers_comments` DISABLE KEYS */;
/*!40000 ALTER TABLE `kimai2_customers_comments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `kimai2_customers_meta`
--

DROP TABLE IF EXISTS `kimai2_customers_meta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `kimai2_customers_meta` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `customer_id` int(11) NOT NULL,
  `name` varchar(50) NOT NULL,
  `value` text DEFAULT NULL,
  `visible` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_A48A760F9395C3F35E237E06` (`customer_id`,`name`),
  KEY `IDX_A48A760F9395C3F3` (`customer_id`),
  CONSTRAINT `FK_A48A760F9395C3F3` FOREIGN KEY (`customer_id`) REFERENCES `kimai2_customers` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `kimai2_customers_meta`
--

LOCK TABLES `kimai2_customers_meta` WRITE;
/*!40000 ALTER TABLE `kimai2_customers_meta` DISABLE KEYS */;
/*!40000 ALTER TABLE `kimai2_customers_meta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `kimai2_customers_rates`
--

DROP TABLE IF EXISTS `kimai2_customers_rates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `kimai2_customers_rates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `customer_id` int(11) DEFAULT NULL,
  `rate` double NOT NULL,
  `fixed` tinyint(1) NOT NULL,
  `internal_rate` double DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_82AB0AECA76ED3959395C3F3` (`user_id`,`customer_id`),
  KEY `IDX_82AB0AECA76ED395` (`user_id`),
  KEY `IDX_82AB0AEC9395C3F3` (`customer_id`),
  CONSTRAINT `FK_82AB0AEC9395C3F3` FOREIGN KEY (`customer_id`) REFERENCES `kimai2_customers` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_82AB0AECA76ED395` FOREIGN KEY (`user_id`) REFERENCES `kimai2_users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `kimai2_customers_rates`
--

LOCK TABLES `kimai2_customers_rates` WRITE;
/*!40000 ALTER TABLE `kimai2_customers_rates` DISABLE KEYS */;
/*!40000 ALTER TABLE `kimai2_customers_rates` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `kimai2_customers_teams`
--

DROP TABLE IF EXISTS `kimai2_customers_teams`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `kimai2_customers_teams` (
  `customer_id` int(11) NOT NULL,
  `team_id` int(11) NOT NULL,
  PRIMARY KEY (`customer_id`,`team_id`),
  KEY `IDX_50BD83889395C3F3` (`customer_id`),
  KEY `IDX_50BD8388296CD8AE` (`team_id`),
  CONSTRAINT `FK_50BD8388296CD8AE` FOREIGN KEY (`team_id`) REFERENCES `kimai2_teams` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_50BD83889395C3F3` FOREIGN KEY (`customer_id`) REFERENCES `kimai2_customers` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `kimai2_customers_teams`
--

LOCK TABLES `kimai2_customers_teams` WRITE;
/*!40000 ALTER TABLE `kimai2_customers_teams` DISABLE KEYS */;
/*!40000 ALTER TABLE `kimai2_customers_teams` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `kimai2_invoice_templates`
--

DROP TABLE IF EXISTS `kimai2_invoice_templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `kimai2_invoice_templates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(60) NOT NULL,
  `title` varchar(255) NOT NULL,
  `company` varchar(255) NOT NULL,
  `address` text DEFAULT NULL,
  `due_days` int(11) NOT NULL,
  `vat` double DEFAULT 0,
  `calculator` varchar(20) NOT NULL,
  `number_generator` varchar(20) NOT NULL,
  `renderer` varchar(20) NOT NULL,
  `payment_terms` text DEFAULT NULL,
  `vat_id` varchar(50) DEFAULT NULL,
  `contact` longtext DEFAULT NULL,
  `payment_details` longtext DEFAULT NULL,
  `language` varchar(6) NOT NULL DEFAULT 'NULL',
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_1626CFE95E237E06` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `kimai2_invoice_templates`
--

LOCK TABLES `kimai2_invoice_templates` WRITE;
/*!40000 ALTER TABLE `kimai2_invoice_templates` DISABLE KEYS */;
INSERT INTO `kimai2_invoice_templates` VALUES
(1,'Blue Byte di Polverini Ciro','.','Blue Byte di Polverini Ciro','Via San Quirico 251R',30,22,'default','default','default',NULL,NULL,'Ciro Polverini',NULL,'it');
/*!40000 ALTER TABLE `kimai2_invoice_templates` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `kimai2_invoices`
--

DROP TABLE IF EXISTS `kimai2_invoices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `kimai2_invoices` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `customer_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `invoice_number` varchar(50) NOT NULL,
  `created_at` datetime NOT NULL COMMENT '(DC2Type:datetime)',
  `timezone` varchar(64) NOT NULL,
  `total` double NOT NULL,
  `tax` double NOT NULL,
  `currency` varchar(3) NOT NULL,
  `status` varchar(20) NOT NULL,
  `due_days` int(11) NOT NULL,
  `vat` double NOT NULL,
  `invoice_filename` varchar(150) NOT NULL,
  `payment_date` date DEFAULT NULL,
  `comment` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_76C38E372DA68207` (`invoice_number`),
  UNIQUE KEY `UNIQ_76C38E372323B33D` (`invoice_filename`),
  KEY `IDX_76C38E37A76ED395` (`user_id`),
  KEY `IDX_76C38E379395C3F3` (`customer_id`),
  CONSTRAINT `FK_76C38E379395C3F3` FOREIGN KEY (`customer_id`) REFERENCES `kimai2_customers` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_76C38E37A76ED395` FOREIGN KEY (`user_id`) REFERENCES `kimai2_users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `kimai2_invoices`
--

LOCK TABLES `kimai2_invoices` WRITE;
/*!40000 ALTER TABLE `kimai2_invoices` DISABLE KEYS */;
INSERT INTO `kimai2_invoices` VALUES
(1,3,2,'2021/001','2021-06-03 10:20:45','Europe/Rome',347.7,62.7,'EUR','new',30,22,'2021-001-Laboratorio.pdf',NULL,NULL),
(2,3,1,'2021/002','2021-06-03 10:20:53','Europe/Rome',347.7,62.7,'EUR','new',30,22,'2021-002-Laboratorio.pdf',NULL,NULL),
(3,2,1,'2021/003','2021-06-03 10:26:30','Europe/Rome',13.73,2.48,'EUR','new',30,22,'2021-003-Cristallina_Water.pdf',NULL,NULL),
(4,79,2,'2021/004','2021-07-05 06:48:54','Europe/Rome',104.31,18.81,'EUR','new',30,22,'2021-004-Parodi_Nutra.pdf',NULL,NULL);
/*!40000 ALTER TABLE `kimai2_invoices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `kimai2_invoices_meta`
--

DROP TABLE IF EXISTS `kimai2_invoices_meta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `kimai2_invoices_meta` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `invoice_id` int(11) NOT NULL,
  `name` varchar(50) NOT NULL,
  `value` text DEFAULT NULL,
  `visible` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_7EDC37D92989F1FD5E237E06` (`invoice_id`,`name`),
  KEY `IDX_7EDC37D92989F1FD` (`invoice_id`),
  CONSTRAINT `FK_7EDC37D92989F1FD` FOREIGN KEY (`invoice_id`) REFERENCES `kimai2_invoices` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `kimai2_invoices_meta`
--

LOCK TABLES `kimai2_invoices_meta` WRITE;
/*!40000 ALTER TABLE `kimai2_invoices_meta` DISABLE KEYS */;
/*!40000 ALTER TABLE `kimai2_invoices_meta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `kimai2_projects`
--

DROP TABLE IF EXISTS `kimai2_projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `kimai2_projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `customer_id` int(11) NOT NULL,
  `name` varchar(150) NOT NULL,
  `order_number` tinytext DEFAULT NULL,
  `comment` text DEFAULT NULL,
  `visible` tinyint(1) NOT NULL,
  `budget` double NOT NULL DEFAULT 0,
  `color` varchar(7) DEFAULT NULL,
  `time_budget` int(11) NOT NULL DEFAULT 0,
  `order_date` datetime DEFAULT NULL COMMENT '(DC2Type:datetime)',
  `start` datetime DEFAULT NULL COMMENT '(DC2Type:datetime)',
  `end` datetime DEFAULT NULL COMMENT '(DC2Type:datetime)',
  `timezone` varchar(64) DEFAULT NULL,
  `budget_type` varchar(10) DEFAULT NULL,
  `billable` tinyint(1) NOT NULL DEFAULT 1,
  `invoice_text` longtext DEFAULT NULL,
  `global_activities` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `IDX_407F12069395C3F3` (`customer_id`),
  KEY `IDX_407F12069395C3F37AB0E8595E237E06` (`customer_id`,`visible`,`name`),
  KEY `IDX_407F12069395C3F37AB0E859BF396750` (`customer_id`,`visible`,`id`),
  CONSTRAINT `FK_407F12069395C3F3` FOREIGN KEY (`customer_id`) REFERENCES `kimai2_customers` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=144 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `kimai2_projects`
--

LOCK TABLES `kimai2_projects` WRITE;
/*!40000 ALTER TABLE `kimai2_projects` DISABLE KEYS */;
INSERT INTO `kimai2_projects` VALUES
(1,1,'Assistenza',NULL,'Interventi software e hardware',1,45,'#c0c0c0',0,NULL,NULL,NULL,'UTC',NULL,1,NULL,1),
(2,2,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(3,3,'Assistenza',NULL,'Interventi Laboratorio',1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(4,4,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(5,5,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(6,6,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(7,7,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(8,8,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(9,9,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(10,10,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(11,11,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(12,12,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(13,13,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(14,14,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(15,15,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(16,16,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(17,17,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(18,18,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(19,19,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(20,20,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(21,21,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(22,22,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(23,23,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(24,24,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(25,25,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(26,26,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(27,27,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(28,28,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(29,29,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(30,30,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(31,31,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(32,32,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(33,33,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(34,34,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(35,35,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(36,36,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(37,37,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(38,38,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(39,39,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(40,40,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(41,41,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(42,42,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(43,43,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(44,44,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(45,45,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(46,46,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(47,47,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(48,48,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(49,49,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(50,50,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(51,51,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(52,52,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(53,53,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(54,54,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(55,55,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(56,56,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(57,57,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(58,58,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(59,59,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(60,60,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(61,61,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(62,62,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(63,63,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(64,64,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(65,65,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(66,66,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(67,67,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(68,68,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(69,69,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(70,70,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(71,71,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(72,72,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(73,73,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(74,74,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(75,75,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(76,76,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(77,77,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(78,78,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(79,79,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(80,80,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(81,81,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(82,82,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(83,83,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(84,84,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(85,85,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(86,86,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(87,87,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(88,88,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(89,89,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(90,90,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(91,91,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(92,92,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(93,93,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(94,94,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(95,95,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(96,96,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(97,97,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(98,98,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(99,99,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(100,100,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(101,101,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(102,102,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(103,103,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(104,104,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(105,105,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(106,106,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(107,107,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(108,108,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(109,109,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(110,110,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(111,111,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(112,112,'Personale',NULL,NULL,1,0,'#ff0000',0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(113,113,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(114,114,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(115,115,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(116,116,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(117,117,'Assistenza',NULL,NULL,1,45,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(118,118,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(119,119,'Assistenza',NULL,NULL,1,45,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(120,120,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(121,121,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(122,122,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(123,123,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(124,124,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(125,125,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(126,126,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(128,128,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(129,129,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(130,130,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(131,131,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(132,132,'Assistenza',NULL,NULL,1,0,'#ee82ee',0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(133,133,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(134,134,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(135,135,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(136,136,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(137,137,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(139,139,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(140,140,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(141,141,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(142,142,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1),
(143,143,'Assistenza',NULL,NULL,1,0,NULL,0,NULL,NULL,NULL,'Europe/Rome',NULL,1,NULL,1);
/*!40000 ALTER TABLE `kimai2_projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `kimai2_projects_comments`
--

DROP TABLE IF EXISTS `kimai2_projects_comments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `kimai2_projects_comments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` int(11) NOT NULL,
  `created_by_id` int(11) NOT NULL,
  `message` longtext NOT NULL,
  `created_at` datetime NOT NULL COMMENT '(DC2Type:datetime)',
  `pinned` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `IDX_29A23638166D1F9C` (`project_id`),
  KEY `IDX_29A23638B03A8386` (`created_by_id`),
  CONSTRAINT `FK_29A23638166D1F9C` FOREIGN KEY (`project_id`) REFERENCES `kimai2_projects` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_29A23638B03A8386` FOREIGN KEY (`created_by_id`) REFERENCES `kimai2_users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `kimai2_projects_comments`
--

LOCK TABLES `kimai2_projects_comments` WRITE;
/*!40000 ALTER TABLE `kimai2_projects_comments` DISABLE KEYS */;
/*!40000 ALTER TABLE `kimai2_projects_comments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `kimai2_projects_meta`
--

DROP TABLE IF EXISTS `kimai2_projects_meta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `kimai2_projects_meta` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` int(11) NOT NULL,
  `name` varchar(50) NOT NULL,
  `value` text DEFAULT NULL,
  `visible` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_50536EF2166D1F9C5E237E06` (`project_id`,`name`),
  KEY `IDX_50536EF2166D1F9C` (`project_id`),
  CONSTRAINT `FK_50536EF2166D1F9C` FOREIGN KEY (`project_id`) REFERENCES `kimai2_projects` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `kimai2_projects_meta`
--

LOCK TABLES `kimai2_projects_meta` WRITE;
/*!40000 ALTER TABLE `kimai2_projects_meta` DISABLE KEYS */;
/*!40000 ALTER TABLE `kimai2_projects_meta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `kimai2_projects_rates`
--

DROP TABLE IF EXISTS `kimai2_projects_rates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `kimai2_projects_rates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `project_id` int(11) DEFAULT NULL,
  `rate` double NOT NULL,
  `fixed` tinyint(1) NOT NULL,
  `internal_rate` double DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_41535D55A76ED395166D1F9C` (`user_id`,`project_id`),
  KEY `IDX_41535D55A76ED395` (`user_id`),
  KEY `IDX_41535D55166D1F9C` (`project_id`),
  CONSTRAINT `FK_41535D55166D1F9C` FOREIGN KEY (`project_id`) REFERENCES `kimai2_projects` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_41535D55A76ED395` FOREIGN KEY (`user_id`) REFERENCES `kimai2_users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `kimai2_projects_rates`
--

LOCK TABLES `kimai2_projects_rates` WRITE;
/*!40000 ALTER TABLE `kimai2_projects_rates` DISABLE KEYS */;
INSERT INTO `kimai2_projects_rates` VALUES
(1,1,2,45,0,NULL);
/*!40000 ALTER TABLE `kimai2_projects_rates` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `kimai2_projects_teams`
--

DROP TABLE IF EXISTS `kimai2_projects_teams`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `kimai2_projects_teams` (
  `project_id` int(11) NOT NULL,
  `team_id` int(11) NOT NULL,
  PRIMARY KEY (`project_id`,`team_id`),
  KEY `IDX_9345D431166D1F9C` (`project_id`),
  KEY `IDX_9345D431296CD8AE` (`team_id`),
  CONSTRAINT `FK_9345D431166D1F9C` FOREIGN KEY (`project_id`) REFERENCES `kimai2_projects` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_9345D431296CD8AE` FOREIGN KEY (`team_id`) REFERENCES `kimai2_teams` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `kimai2_projects_teams`
--

LOCK TABLES `kimai2_projects_teams` WRITE;
/*!40000 ALTER TABLE `kimai2_projects_teams` DISABLE KEYS */;
/*!40000 ALTER TABLE `kimai2_projects_teams` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `kimai2_roles`
--

DROP TABLE IF EXISTS `kimai2_roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `kimai2_roles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `roles_name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `kimai2_roles`
--

LOCK TABLES `kimai2_roles` WRITE;
/*!40000 ALTER TABLE `kimai2_roles` DISABLE KEYS */;
INSERT INTO `kimai2_roles` VALUES
(3,'ROLE_ADMIN'),
(4,'ROLE_SUPER_ADMIN'),
(2,'ROLE_TEAMLEAD'),
(1,'ROLE_USER');
/*!40000 ALTER TABLE `kimai2_roles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `kimai2_roles_permissions`
--

DROP TABLE IF EXISTS `kimai2_roles_permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `kimai2_roles_permissions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `role_id` int(11) NOT NULL,
  `permission` varchar(50) NOT NULL,
  `allowed` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `role_permission` (`role_id`,`permission`),
  KEY `IDX_D263A3B8D60322AC` (`role_id`),
  CONSTRAINT `FK_D263A3B8D60322AC` FOREIGN KEY (`role_id`) REFERENCES `kimai2_roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `kimai2_roles_permissions`
--

LOCK TABLES `kimai2_roles_permissions` WRITE;
/*!40000 ALTER TABLE `kimai2_roles_permissions` DISABLE KEYS */;
INSERT INTO `kimai2_roles_permissions` VALUES
(1,3,'view_user',1),
(2,2,'create_customer',1),
(3,2,'create_project',1);
/*!40000 ALTER TABLE `kimai2_roles_permissions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `kimai2_sessions`
--

DROP TABLE IF EXISTS `kimai2_sessions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `kimai2_sessions` (
  `id` varchar(128) NOT NULL,
  `data` blob NOT NULL,
  `time` int(10) unsigned NOT NULL,
  `lifetime` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `kimai2_sessions`
--

LOCK TABLES `kimai2_sessions` WRITE;
/*!40000 ALTER TABLE `kimai2_sessions` DISABLE KEYS */;
INSERT INTO `kimai2_sessions` VALUES
('04qjsfadha6ik2jvgoasvvtr0d','_sf2_attributes|a:5:{s:12:\"_csrf/logout\";s:43:\"2lcZPzuUrxHaY6HUXOJWi6SgIHS2yiA8K2YJNdl1Dm4\";s:12:\"_csrf/search\";s:43:\"bd-A3tw7d1YA0HT2Nj4HENf2qSzvn7gKDGDA2JkgG2A\";s:22:\"_csrf/datatable_update\";s:43:\"h-tG0LevtrJSAT2XdKWzhhquGiWsNV0aG1-dYSSCqbo\";s:26:\"_csrf/entities_multiupdate\";s:43:\"eDeEFRwVbgSBaHWF-xKdBuRlI4Wni1QA2KygzzlKcsc\";s:22:\"_security_secured_area\";s:452:\"O:68:\"Symfony\\Component\\Security\\Core\\Authentication\\Token\\RememberMeToken\":3:{i:0;s:31:\"change_this_to_something_unique\";i:1;s:12:\"secured_area\";i:2;a:5:{i:0;O:15:\"App\\Entity\\User\":5:{s:2:\"id\";i:3;s:8:\"username\";s:8:\"federico\";s:7:\"enabled\";b:1;s:5:\"email\";s:21:\"federico@blue-byte.it\";s:8:\"password\";s:60:\"$2y$13$GnyT37bDhQgaAdlOHxO16OSpOV50uC8WuOY/qSGZJtjeTJzzjcRRi\";}i:1;b:1;i:2;N;i:3;a:0:{}i:4;a:2:{i:0;s:13:\"ROLE_TEAMLEAD\";i:1;s:9:\"ROLE_USER\";}}}\";}_sf2_meta|a:3:{s:1:\"u\";i:1739173227;s:1:\"c\";i:1739173227;s:1:\"l\";i:0;}',1739173262,1739174702),
('09h79s1gho4sepohe6ljjfribf','_sf2_attributes|a:7:{s:22:\"_security_secured_area\";s:452:\"O:68:\"Symfony\\Component\\Security\\Core\\Authentication\\Token\\RememberMeToken\":3:{i:0;s:31:\"change_this_to_something_unique\";i:1;s:12:\"secured_area\";i:2;a:5:{i:0;O:15:\"App\\Entity\\User\":5:{s:2:\"id\";i:3;s:8:\"username\";s:8:\"federico\";s:7:\"enabled\";b:1;s:5:\"email\";s:21:\"federico@blue-byte.it\";s:8:\"password\";s:60:\"$2y$13$GnyT37bDhQgaAdlOHxO16OSpOV50uC8WuOY/qSGZJtjeTJzzjcRRi\";}i:1;b:1;i:2;N;i:3;a:0:{}i:4;a:2:{i:0;s:13:\"ROLE_TEAMLEAD\";i:1;s:9:\"ROLE_USER\";}}}\";s:12:\"_csrf/logout\";s:43:\"zUYe_VvA_rBEXnZgjksE7_pJIxTROuzNu8el6ucswCs\";s:12:\"_csrf/search\";s:43:\"I6IqUMPsgBeYVuP8viXr0eQCYGR7ulAMzblz-jwy74g\";s:22:\"_csrf/datatable_update\";s:43:\"DaaUd9B-rlQfSQpPtLPglJIqiiG5qItG3hzmqLpO1U0\";s:26:\"_csrf/entities_multiupdate\";s:43:\"DhljAlx6qe0X8OZgoFmL6CjoOs7VntioiJ2D-cyrV9Q\";s:20:\"_csrf/timesheet_edit\";s:43:\"GYGgoZeQa4L2Cyw_Qpmbo7eWpiaPP66FTAU0W_3lGr0\";s:21:\"search_MyTimesListing\";a:13:{s:10:\"searchTerm\";s:0:\"\";s:9:\"daterange\";s:0:\"\";s:9:\"customers\";a:0:{}s:8:\"projects\";a:0:{}s:10:\"activities\";a:0:{}s:4:\"tags\";a:0:{}s:5:\"state\";s:1:\"1\";s:8:\"billable\";s:1:\"0\";s:8:\"exported\";s:1:\"1\";s:8:\"pageSize\";s:2:\"50\";s:4:\"page\";s:1:\"1\";s:5:\"order\";s:4:\"DESC\";s:7:\"orderBy\";s:5:\"begin\";}}_sf2_meta|a:3:{s:1:\"u\";i:1739197992;s:1:\"c\";i:1739197933;s:1:\"l\";i:0;}',1739197992,1739199432),
('0od8ottg4li7d2aorpc0oiankr','_sf2_attributes|a:7:{s:12:\"_csrf/logout\";s:43:\"k_wzYF9nAyHarY8-AXwB1fPB2HDfQJkHwZHA0tkqMhA\";s:12:\"_csrf/search\";s:43:\"u-Zurm-NvIxMUpCPEXXmj7ZWTXVJd_C6d9umHmAEvMQ\";s:22:\"_csrf/datatable_update\";s:43:\"8fHJSqvdPYF1Dbd1h3B0fDHcyVwniUzWubNw-XJXEIw\";s:26:\"_csrf/entities_multiupdate\";s:43:\"RtA3OTFVkF9PB-8YXd5RSIyHicoKE6mpSwSdpC-hBh4\";s:22:\"_security_secured_area\";s:453:\"O:68:\"Symfony\\Component\\Security\\Core\\Authentication\\Token\\RememberMeToken\":3:{i:0;s:31:\"change_this_to_something_unique\";i:1;s:12:\"secured_area\";i:2;a:5:{i:0;O:15:\"App\\Entity\\User\":5:{s:2:\"id\";i:1;s:8:\"username\";s:7:\"claudio\";s:7:\"enabled\";b:1;s:5:\"email\";s:20:\"claudio@blue-byte.it\";s:8:\"password\";s:60:\"$2y$13$n6HH5Y6sJgN4T4g.LavsDOLwOnaQdZgcoMyfb73zs6jPn9/O/SoO6\";}i:1;b:1;i:2;N;i:3;a:0:{}i:4;a:2:{i:0;s:16:\"ROLE_SUPER_ADMIN\";i:1;s:9:\"ROLE_USER\";}}}\";s:20:\"_csrf/timesheet_edit\";s:43:\"IEYmDKVo6BcnJUKB2kwNGkQWUOaVAxRZqevjBVomsjQ\";s:21:\"search_MyTimesListing\";a:13:{s:10:\"searchTerm\";s:0:\"\";s:9:\"daterange\";s:0:\"\";s:9:\"customers\";a:0:{}s:8:\"projects\";a:0:{}s:10:\"activities\";a:0:{}s:4:\"tags\";a:0:{}s:5:\"state\";s:1:\"1\";s:8:\"billable\";s:1:\"0\";s:8:\"exported\";s:1:\"1\";s:8:\"pageSize\";s:2:\"50\";s:4:\"page\";s:1:\"1\";s:5:\"order\";s:4:\"DESC\";s:7:\"orderBy\";s:5:\"begin\";}}_sf2_meta|a:3:{s:1:\"u\";i:1739292458;s:1:\"c\";i:1739292397;s:1:\"l\";i:0;}',1739292458,1739293898),
('1sk28pnv4836i0k10ml61506je','_sf2_attributes|a:7:{s:22:\"_security_secured_area\";s:452:\"O:68:\"Symfony\\Component\\Security\\Core\\Authentication\\Token\\RememberMeToken\":3:{i:0;s:31:\"change_this_to_something_unique\";i:1;s:12:\"secured_area\";i:2;a:5:{i:0;O:15:\"App\\Entity\\User\":5:{s:2:\"id\";i:3;s:8:\"username\";s:8:\"federico\";s:7:\"enabled\";b:1;s:5:\"email\";s:21:\"federico@blue-byte.it\";s:8:\"password\";s:60:\"$2y$13$GnyT37bDhQgaAdlOHxO16OSpOV50uC8WuOY/qSGZJtjeTJzzjcRRi\";}i:1;b:1;i:2;N;i:3;a:0:{}i:4;a:2:{i:0;s:13:\"ROLE_TEAMLEAD\";i:1;s:9:\"ROLE_USER\";}}}\";s:12:\"_csrf/logout\";s:43:\"khI9dPmCtlSpJmctBtQZXU0Tr3MkO6iyr4Opo1siFfE\";s:12:\"_csrf/search\";s:43:\"GeQ5N7vJZZ0fP-d6W85xYyHUJMvDSr8hnJB8jUs89hc\";s:22:\"_csrf/datatable_update\";s:43:\"s83PfXhlePbs5H4DRFnlTTLsNrp6r0z3mOfWI0-_jjc\";s:26:\"_csrf/entities_multiupdate\";s:43:\"yvqEjk-PCQC8qU5CNF14xt9c9yMtHmKkj9L0_xpjtoY\";s:20:\"_csrf/timesheet_edit\";s:43:\"XaEuB2oOoJUbMZZKA8M5bDswFSgyx6kxt9ZKivT8xrw\";s:21:\"search_MyTimesListing\";a:13:{s:10:\"searchTerm\";s:0:\"\";s:9:\"daterange\";s:0:\"\";s:9:\"customers\";a:0:{}s:8:\"projects\";a:0:{}s:10:\"activities\";a:0:{}s:4:\"tags\";a:0:{}s:5:\"state\";s:1:\"1\";s:8:\"billable\";s:1:\"0\";s:8:\"exported\";s:1:\"1\";s:8:\"pageSize\";s:2:\"50\";s:4:\"page\";s:1:\"1\";s:5:\"order\";s:4:\"DESC\";s:7:\"orderBy\";s:5:\"begin\";}}_sf2_meta|a:3:{s:1:\"u\";i:1738838490;s:1:\"c\";i:1738836962;s:1:\"l\";i:0;}',1738838490,1738839930),
('2httb8u5amme8stj6qmvjq2p6r','_sf2_attributes|a:6:{s:22:\"_security_secured_area\";s:466:\"O:68:\"Symfony\\Component\\Security\\Core\\Authentication\\Token\\RememberMeToken\":3:{i:0;s:31:\"change_this_to_something_unique\";i:1;s:12:\"secured_area\";i:2;a:5:{i:0;O:15:\"App\\Entity\\User\":5:{s:2:\"id\";i:2;s:8:\"username\";s:4:\"ciro\";s:7:\"enabled\";b:1;s:5:\"email\";s:17:\"ciro@blue-byte.it\";s:8:\"password\";s:60:\"$2y$13$eCHpio9nWxEEZyNxJQRjLeP2v8TrHLwbZ4dkFtYx15W6bTsMA5062\";}i:1;b:1;i:2;N;i:3;a:0:{}i:4;a:3:{i:0;s:13:\"ROLE_TEAMLEAD\";i:1;s:10:\"ROLE_ADMIN\";i:2;s:9:\"ROLE_USER\";}}}\";s:18:\"search_ExportQuery\";a:12:{s:10:\"searchTerm\";s:0:\"\";s:9:\"daterange\";s:23:\"27/01/2024 - 27/12/2025\";s:9:\"customers\";a:0:{}s:8:\"projects\";a:0:{}s:10:\"activities\";a:0:{}s:4:\"tags\";a:0:{}s:5:\"users\";a:0:{}s:8:\"exported\";s:1:\"5\";s:5:\"state\";s:1:\"1\";s:8:\"billable\";s:1:\"0\";s:8:\"renderer\";s:0:\"\";s:14:\"markAsExported\";s:1:\"0\";}s:12:\"_csrf/logout\";s:43:\"Ahp2I4GGS2eGr8yIAwQGWyDz16Kc81YuMXcHl6oiIn0\";s:22:\"_csrf/datatable_update\";s:43:\"F50MCFNJzg57VtN7EgYZMSMumBCTDay7YFkLtB8pwk8\";s:12:\"_csrf/search\";s:43:\"aSSUzfKDdaaexqemnkheftiWjZNI03J1kVYoxIZisko\";s:20:\"_csrf/timesheet_edit\";s:43:\"oIeUHIp70p3sw-5xpcljOy5tq-3a3uLWz5wveE7_skU\";}_sf2_meta|a:3:{s:1:\"u\";i:1738667209;s:1:\"c\";i:1738664999;s:1:\"l\";i:0;}',1738667209,1738668649),
('2rqsl37p1m0qcvsehu5rtfds36','_sf2_attributes|a:5:{s:18:\"search_ExportQuery\";a:12:{s:10:\"searchTerm\";s:0:\"\";s:9:\"daterange\";s:23:\"27/01/2024 - 27/12/2025\";s:9:\"customers\";a:1:{i:0;s:2:\"87\";}s:8:\"projects\";a:0:{}s:10:\"activities\";a:0:{}s:4:\"tags\";a:0:{}s:5:\"users\";a:0:{}s:8:\"exported\";s:1:\"5\";s:5:\"state\";s:1:\"1\";s:8:\"billable\";s:1:\"0\";s:8:\"renderer\";s:0:\"\";s:14:\"markAsExported\";s:1:\"0\";}s:12:\"_csrf/logout\";s:43:\"htROKTuDtlbjDltSBx4uUpvNUQGPc4iH9ZINhHax-pk\";s:22:\"_csrf/datatable_update\";s:43:\"CMYp5sp4q1GModedQFDRV8TjtncX955q_xP6alUowZc\";s:12:\"_csrf/search\";s:43:\"d1taUtb8G2OZOZ65J7P3ootuLI0bhWSjEQKcXUbwcCY\";s:22:\"_security_secured_area\";s:466:\"O:68:\"Symfony\\Component\\Security\\Core\\Authentication\\Token\\RememberMeToken\":3:{i:0;s:31:\"change_this_to_something_unique\";i:1;s:12:\"secured_area\";i:2;a:5:{i:0;O:15:\"App\\Entity\\User\":5:{s:2:\"id\";i:2;s:8:\"username\";s:4:\"ciro\";s:7:\"enabled\";b:1;s:5:\"email\";s:17:\"ciro@blue-byte.it\";s:8:\"password\";s:60:\"$2y$13$eCHpio9nWxEEZyNxJQRjLeP2v8TrHLwbZ4dkFtYx15W6bTsMA5062\";}i:1;b:1;i:2;N;i:3;a:0:{}i:4;a:3:{i:0;s:13:\"ROLE_TEAMLEAD\";i:1;s:10:\"ROLE_ADMIN\";i:2;s:9:\"ROLE_USER\";}}}\";}_sf2_meta|a:3:{s:1:\"u\";i:1738836461;s:1:\"c\";i:1738836461;s:1:\"l\";i:0;}',1738836470,1738837910),
('3ius60p9k41e8aalbkscr8btbm','_sf2_attributes|a:6:{s:22:\"_security_secured_area\";s:453:\"O:68:\"Symfony\\Component\\Security\\Core\\Authentication\\Token\\RememberMeToken\":3:{i:0;s:31:\"change_this_to_something_unique\";i:1;s:12:\"secured_area\";i:2;a:5:{i:0;O:15:\"App\\Entity\\User\":5:{s:2:\"id\";i:1;s:8:\"username\";s:7:\"claudio\";s:7:\"enabled\";b:1;s:5:\"email\";s:20:\"claudio@blue-byte.it\";s:8:\"password\";s:60:\"$2y$13$n6HH5Y6sJgN4T4g.LavsDOLwOnaQdZgcoMyfb73zs6jPn9/O/SoO6\";}i:1;b:1;i:2;N;i:3;a:0:{}i:4;a:2:{i:0;s:16:\"ROLE_SUPER_ADMIN\";i:1;s:9:\"ROLE_USER\";}}}\";s:21:\"search_MyTimesListing\";a:13:{s:10:\"searchTerm\";s:0:\"\";s:9:\"daterange\";s:0:\"\";s:9:\"customers\";a:0:{}s:8:\"projects\";a:0:{}s:10:\"activities\";a:0:{}s:4:\"tags\";a:0:{}s:5:\"state\";s:1:\"1\";s:8:\"billable\";s:1:\"0\";s:8:\"exported\";s:1:\"1\";s:8:\"pageSize\";s:2:\"50\";s:4:\"page\";s:1:\"1\";s:5:\"order\";s:4:\"DESC\";s:7:\"orderBy\";s:5:\"begin\";}s:12:\"_csrf/logout\";s:43:\"gDopSzrs9eBTvHMWrpDo06cND9UWfSJgAzFyho0es_0\";s:12:\"_csrf/search\";s:43:\"4dqaTKjHLHCBE22xfCVIrpZBKqsXQugTIxB7vVM4d-s\";s:22:\"_csrf/datatable_update\";s:43:\"cYsiu0SuFr1xcHhYLh7jemMAybYmombqif_AfzZNRSs\";s:26:\"_csrf/entities_multiupdate\";s:43:\"KjrMfqIq6JtbJMBXNrTIii_b39oHWiiwmTC2Zy-0gd4\";}_sf2_meta|a:3:{s:1:\"u\";i:1738857140;s:1:\"c\";i:1738857137;s:1:\"l\";i:0;}',1738857144,1738858584),
('3kqtffsa5h0mtus4v06egkamg7','_sf2_attributes|a:7:{s:22:\"_security_secured_area\";s:453:\"O:68:\"Symfony\\Component\\Security\\Core\\Authentication\\Token\\RememberMeToken\":3:{i:0;s:31:\"change_this_to_something_unique\";i:1;s:12:\"secured_area\";i:2;a:5:{i:0;O:15:\"App\\Entity\\User\":5:{s:2:\"id\";i:1;s:8:\"username\";s:7:\"claudio\";s:7:\"enabled\";b:1;s:5:\"email\";s:20:\"claudio@blue-byte.it\";s:8:\"password\";s:60:\"$2y$13$n6HH5Y6sJgN4T4g.LavsDOLwOnaQdZgcoMyfb73zs6jPn9/O/SoO6\";}i:1;b:1;i:2;N;i:3;a:0:{}i:4;a:2:{i:0;s:16:\"ROLE_SUPER_ADMIN\";i:1;s:9:\"ROLE_USER\";}}}\";s:12:\"_csrf/logout\";s:43:\"ReoyTD38jA8ZTs5cA4smGo-KT7c1n0JFmUAS4pkZuJk\";s:12:\"_csrf/search\";s:43:\"1yT4hIWrLvAnMVzLacy3FsHDy5k_qpX9KFZF7R1WGHI\";s:22:\"_csrf/datatable_update\";s:43:\"aRmEu4-NXaATKlaGSOp2eEzjpze4tsepwVv2n4XcP6k\";s:26:\"_csrf/entities_multiupdate\";s:43:\"Dxy1B9N5nhCX7Fu074D8l2xzaJTlU7C8uMnFFbjHEOU\";s:20:\"_csrf/timesheet_edit\";s:43:\"ZzUTlCkEq7k1K8cOqqtUresrKTADA5NqZQMgylS9Qs0\";s:21:\"search_MyTimesListing\";a:13:{s:10:\"searchTerm\";s:0:\"\";s:9:\"daterange\";s:0:\"\";s:9:\"customers\";a:0:{}s:8:\"projects\";a:0:{}s:10:\"activities\";a:0:{}s:4:\"tags\";a:0:{}s:5:\"state\";s:1:\"1\";s:8:\"billable\";s:1:\"0\";s:8:\"exported\";s:1:\"1\";s:8:\"pageSize\";s:2:\"50\";s:4:\"page\";s:1:\"1\";s:5:\"order\";s:4:\"DESC\";s:7:\"orderBy\";s:5:\"begin\";}}_sf2_meta|a:3:{s:1:\"u\";i:1738687994;s:1:\"c\";i:1738687235;s:1:\"l\";i:0;}',1738687994,1738689434),
('414g3nitui2n5upu7a913ssjtg','_sf2_attributes|a:1:{s:18:\"_csrf/authenticate\";s:43:\"2j8aX3HpVG5u7ePs_LcZ_PB_AGz-p4yDuzKnoRT7RxA\";}_sf2_meta|a:3:{s:1:\"u\";i:1738779598;s:1:\"c\";i:1738779598;s:1:\"l\";i:0;}',1738779598,1738781038),
('6erq6v1cflphcofhho3dueicff','_sf2_attributes|a:7:{s:12:\"_csrf/logout\";s:43:\"hNDslLEy_aJvF_X9qv7mMbmlfzD0SSm13UElIPTXPX4\";s:12:\"_csrf/search\";s:43:\"AfyPVbvjqMwhITsk_XhJbh-O_mItHpKRenImmIdUPls\";s:22:\"_csrf/datatable_update\";s:43:\"TkqyXD3GWhmBbSiwuu9D_Jzd8b7LOCI38aJI5lOYXL0\";s:26:\"_csrf/entities_multiupdate\";s:43:\"sCJ5nUp-chy3AHQlvkgOSjfbBQDCZzlognDlmbKbBcM\";s:22:\"_security_secured_area\";s:453:\"O:68:\"Symfony\\Component\\Security\\Core\\Authentication\\Token\\RememberMeToken\":3:{i:0;s:31:\"change_this_to_something_unique\";i:1;s:12:\"secured_area\";i:2;a:5:{i:0;O:15:\"App\\Entity\\User\":5:{s:2:\"id\";i:1;s:8:\"username\";s:7:\"claudio\";s:7:\"enabled\";b:1;s:5:\"email\";s:20:\"claudio@blue-byte.it\";s:8:\"password\";s:60:\"$2y$13$n6HH5Y6sJgN4T4g.LavsDOLwOnaQdZgcoMyfb73zs6jPn9/O/SoO6\";}i:1;b:1;i:2;N;i:3;a:0:{}i:4;a:2:{i:0;s:16:\"ROLE_SUPER_ADMIN\";i:1;s:9:\"ROLE_USER\";}}}\";s:20:\"_csrf/timesheet_edit\";s:43:\"8Gv-aACTAQvKHVMYvm95DtIxwN_VGT12Lb0NvOY-lsc\";s:21:\"search_MyTimesListing\";a:13:{s:10:\"searchTerm\";s:0:\"\";s:9:\"daterange\";s:0:\"\";s:9:\"customers\";a:0:{}s:8:\"projects\";a:0:{}s:10:\"activities\";a:0:{}s:4:\"tags\";a:0:{}s:5:\"state\";s:1:\"1\";s:8:\"billable\";s:1:\"0\";s:8:\"exported\";s:1:\"1\";s:8:\"pageSize\";s:2:\"50\";s:4:\"page\";s:1:\"1\";s:5:\"order\";s:4:\"DESC\";s:7:\"orderBy\";s:5:\"begin\";}}_sf2_meta|a:3:{s:1:\"u\";i:1738778687;s:1:\"c\";i:1738778404;s:1:\"l\";i:0;}',1738778687,1738780127),
('84tbplsnbqfpt928q6jk1u79sk','_sf2_attributes|a:7:{s:20:\"_csrf/timesheet_edit\";s:43:\"gasLzhx_5NQFYDZmBGAzHEldc4MztGkWMSmkcqEQhL4\";s:22:\"_security_secured_area\";s:453:\"O:68:\"Symfony\\Component\\Security\\Core\\Authentication\\Token\\RememberMeToken\":3:{i:0;s:31:\"change_this_to_something_unique\";i:1;s:12:\"secured_area\";i:2;a:5:{i:0;O:15:\"App\\Entity\\User\":5:{s:2:\"id\";i:1;s:8:\"username\";s:7:\"claudio\";s:7:\"enabled\";b:1;s:5:\"email\";s:20:\"claudio@blue-byte.it\";s:8:\"password\";s:60:\"$2y$13$n6HH5Y6sJgN4T4g.LavsDOLwOnaQdZgcoMyfb73zs6jPn9/O/SoO6\";}i:1;b:1;i:2;N;i:3;a:0:{}i:4;a:2:{i:0;s:16:\"ROLE_SUPER_ADMIN\";i:1;s:9:\"ROLE_USER\";}}}\";s:12:\"_csrf/logout\";s:43:\"XQjPN8i4HALEnG7618XFbjWq-XaOR_T8Ur6OeDSHQUw\";s:12:\"_csrf/search\";s:43:\"qLBN7me5LfXpK15obUsJkSErih7H6ZVoDQ8ryr4jBtI\";s:22:\"_csrf/datatable_update\";s:43:\"hxqb_RK6K8zrwpjlI7bLsb5maFnGdjQjBV1WPTAY27s\";s:26:\"_csrf/entities_multiupdate\";s:43:\"L336vrliK7yCTMA-ZSBKTv8OlzzIxJ5zDKIPk9P28BQ\";s:21:\"search_MyTimesListing\";a:13:{s:10:\"searchTerm\";s:0:\"\";s:9:\"daterange\";s:0:\"\";s:9:\"customers\";a:0:{}s:8:\"projects\";a:0:{}s:10:\"activities\";a:0:{}s:4:\"tags\";a:0:{}s:5:\"state\";s:1:\"1\";s:8:\"billable\";s:1:\"0\";s:8:\"exported\";s:1:\"1\";s:8:\"pageSize\";s:2:\"50\";s:4:\"page\";s:1:\"1\";s:5:\"order\";s:4:\"DESC\";s:7:\"orderBy\";s:5:\"begin\";}}_sf2_meta|a:3:{s:1:\"u\";i:1738944346;s:1:\"c\";i:1738943527;s:1:\"l\";i:0;}',1738944346,1738945786),
('88ussgldff27pmfjbr01a56a9u','_sf2_attributes|a:1:{s:34:\"_security.secured_area.target_path\";s:40:\"http://kimai.blue-byte.it/en_US/homepage\";}_sf2_meta|a:3:{s:1:\"u\";i:1738932984;s:1:\"c\";i:1738932984;s:1:\"l\";i:0;}',1738932984,1738934424),
('8logaq4o5nkblra16konl59emg','_sf2_attributes|a:7:{s:12:\"_csrf/logout\";s:43:\"wLj5JE0kCXGgD6ixd58ubVg4jgO5-lLfXebcXH60FoE\";s:12:\"_csrf/search\";s:43:\"yqOofxQIVDylqrwjuGqVhQeg1qSdQBRLpIRMWIAKa3U\";s:22:\"_csrf/datatable_update\";s:43:\"rWHlGP_KkqbyEWQ5MSA8TCPNxFJXLg9O2O9hjKtrAr0\";s:26:\"_csrf/entities_multiupdate\";s:43:\"2iUyg1D_FamdVzB7PuAGyt9hwaeuoZLreJaytFNGJcc\";s:22:\"_security_secured_area\";s:453:\"O:68:\"Symfony\\Component\\Security\\Core\\Authentication\\Token\\RememberMeToken\":3:{i:0;s:31:\"change_this_to_something_unique\";i:1;s:12:\"secured_area\";i:2;a:5:{i:0;O:15:\"App\\Entity\\User\":5:{s:2:\"id\";i:1;s:8:\"username\";s:7:\"claudio\";s:7:\"enabled\";b:1;s:5:\"email\";s:20:\"claudio@blue-byte.it\";s:8:\"password\";s:60:\"$2y$13$n6HH5Y6sJgN4T4g.LavsDOLwOnaQdZgcoMyfb73zs6jPn9/O/SoO6\";}i:1;b:1;i:2;N;i:3;a:0:{}i:4;a:2:{i:0;s:16:\"ROLE_SUPER_ADMIN\";i:1;s:9:\"ROLE_USER\";}}}\";s:20:\"_csrf/timesheet_edit\";s:43:\"77Xg-53ouVcckuRdUhSCwq3uxNZmt-_13mWm_fwC9Uo\";s:21:\"search_MyTimesListing\";a:13:{s:10:\"searchTerm\";s:0:\"\";s:9:\"daterange\";s:0:\"\";s:9:\"customers\";a:0:{}s:8:\"projects\";a:0:{}s:10:\"activities\";a:0:{}s:4:\"tags\";a:0:{}s:5:\"state\";s:1:\"1\";s:8:\"billable\";s:1:\"0\";s:8:\"exported\";s:1:\"1\";s:8:\"pageSize\";s:2:\"50\";s:4:\"page\";s:1:\"1\";s:5:\"order\";s:4:\"DESC\";s:7:\"orderBy\";s:5:\"begin\";}}_sf2_meta|a:3:{s:1:\"u\";i:1739021041;s:1:\"c\";i:1739021006;s:1:\"l\";i:0;}',1739021041,1739022481),
('8nu8g7430fctr011oublc1ui5s','_sf2_attributes|a:7:{s:12:\"_csrf/logout\";s:43:\"PVmMOzzeXmdwBPlnTReE8-kiYNM4DCnxJCMS5U3hrNA\";s:12:\"_csrf/search\";s:43:\"jXlCC2chRGkdw0FZ0qWTsyzmtBnvSrd9XYyxPS078iE\";s:22:\"_csrf/datatable_update\";s:43:\"VcKS0EBEYcqsm0extPqCBfb68TmpFxXJFHgQyfVe-zE\";s:26:\"_csrf/entities_multiupdate\";s:43:\"RCokeP9ex0wPaU2AxYF-HR_QXHL9r32fpcXffImZr_o\";s:22:\"_security_secured_area\";s:453:\"O:68:\"Symfony\\Component\\Security\\Core\\Authentication\\Token\\RememberMeToken\":3:{i:0;s:31:\"change_this_to_something_unique\";i:1;s:12:\"secured_area\";i:2;a:5:{i:0;O:15:\"App\\Entity\\User\":5:{s:2:\"id\";i:1;s:8:\"username\";s:7:\"claudio\";s:7:\"enabled\";b:1;s:5:\"email\";s:20:\"claudio@blue-byte.it\";s:8:\"password\";s:60:\"$2y$13$n6HH5Y6sJgN4T4g.LavsDOLwOnaQdZgcoMyfb73zs6jPn9/O/SoO6\";}i:1;b:1;i:2;N;i:3;a:0:{}i:4;a:2:{i:0;s:16:\"ROLE_SUPER_ADMIN\";i:1;s:9:\"ROLE_USER\";}}}\";s:20:\"_csrf/timesheet_edit\";s:43:\"aLIZENpl6BHQByrGni67ZcRkj0ppJmW3XzcsBzduZDo\";s:21:\"search_MyTimesListing\";a:13:{s:10:\"searchTerm\";s:0:\"\";s:9:\"daterange\";s:0:\"\";s:9:\"customers\";a:0:{}s:8:\"projects\";a:0:{}s:10:\"activities\";a:0:{}s:4:\"tags\";a:0:{}s:5:\"state\";s:1:\"1\";s:8:\"billable\";s:1:\"0\";s:8:\"exported\";s:1:\"1\";s:8:\"pageSize\";s:2:\"50\";s:4:\"page\";s:1:\"1\";s:5:\"order\";s:4:\"DESC\";s:7:\"orderBy\";s:5:\"begin\";}}_sf2_meta|a:3:{s:1:\"u\";i:1738682974;s:1:\"c\";i:1738682943;s:1:\"l\";i:0;}',1738682974,1738684414),
('94liur5r11ql5btlf42k3shvtl','_sf2_attributes|a:7:{s:20:\"_csrf/timesheet_edit\";s:43:\"4OpuQlsgD3Ky6neKgXDTC_5HaMGNBuOb9i8QOGya1G0\";s:22:\"_security_secured_area\";s:452:\"O:68:\"Symfony\\Component\\Security\\Core\\Authentication\\Token\\RememberMeToken\":3:{i:0;s:31:\"change_this_to_something_unique\";i:1;s:12:\"secured_area\";i:2;a:5:{i:0;O:15:\"App\\Entity\\User\":5:{s:2:\"id\";i:3;s:8:\"username\";s:8:\"federico\";s:7:\"enabled\";b:1;s:5:\"email\";s:21:\"federico@blue-byte.it\";s:8:\"password\";s:60:\"$2y$13$GnyT37bDhQgaAdlOHxO16OSpOV50uC8WuOY/qSGZJtjeTJzzjcRRi\";}i:1;b:1;i:2;N;i:3;a:0:{}i:4;a:2:{i:0;s:13:\"ROLE_TEAMLEAD\";i:1;s:9:\"ROLE_USER\";}}}\";s:12:\"_csrf/logout\";s:43:\"mrAi0Odf_KO47rTb-2p09ss9eC4qNUgfg-J6L8Cww-k\";s:12:\"_csrf/search\";s:43:\"KrKHMdFP2Xer6LPgt2ceiFxLVYxVKJdTMVp_HoWW6Qc\";s:22:\"_csrf/datatable_update\";s:43:\"ivQWWKz8H61b9SH_7za6uFQmMOtO5c_SBBmEpNVIXF0\";s:26:\"_csrf/entities_multiupdate\";s:43:\"sXhs14yz7hRU1g5KBjjzUBOwhr47yrE51QFPqhjhcak\";s:21:\"search_MyTimesListing\";a:13:{s:10:\"searchTerm\";s:0:\"\";s:9:\"daterange\";s:0:\"\";s:9:\"customers\";a:0:{}s:8:\"projects\";a:0:{}s:10:\"activities\";a:0:{}s:4:\"tags\";a:0:{}s:5:\"state\";s:1:\"1\";s:8:\"billable\";s:1:\"0\";s:8:\"exported\";s:1:\"1\";s:8:\"pageSize\";s:2:\"50\";s:4:\"page\";s:1:\"1\";s:5:\"order\";s:4:\"DESC\";s:7:\"orderBy\";s:5:\"begin\";}}_sf2_meta|a:3:{s:1:\"u\";i:1738855976;s:1:\"c\";i:1738855927;s:1:\"l\";i:0;}',1738855976,1738857416),
('95hmm8jqum726l740i1ukkjtaq','_sf2_attributes|a:1:{s:34:\"_security.secured_area.target_path\";s:40:\"http://kimai.blue-byte.it/en_US/homepage\";}_sf2_meta|a:3:{s:1:\"u\";i:1738932968;s:1:\"c\";i:1738932968;s:1:\"l\";i:0;}',1738932968,1738934408),
('9pc25ci9v8mjchsrbopj84p572','_sf2_attributes|a:10:{s:22:\"_security_secured_area\";s:421:\"O:74:\"Symfony\\Component\\Security\\Core\\Authentication\\Token\\UsernamePasswordToken\":3:{i:0;N;i:1;s:12:\"secured_area\";i:2;a:5:{i:0;O:15:\"App\\Entity\\User\":5:{s:2:\"id\";i:3;s:8:\"username\";s:8:\"federico\";s:7:\"enabled\";b:1;s:5:\"email\";s:21:\"federico@blue-byte.it\";s:8:\"password\";s:60:\"$2y$13$GnyT37bDhQgaAdlOHxO16OSpOV50uC8WuOY/qSGZJtjeTJzzjcRRi\";}i:1;b:1;i:2;N;i:3;a:0:{}i:4;a:2:{i:0;s:13:\"ROLE_TEAMLEAD\";i:1;s:9:\"ROLE_USER\";}}}\";s:23:\"_security.last_username\";s:8:\"federico\";s:12:\"_csrf/logout\";s:43:\"31HBSu-CdCIPl450iIjngXefA0GaQNU57if3UcEIcZg\";s:12:\"_csrf/search\";s:43:\"ULUHXXzSmHJCBLszn3w99AN_AoKF78Zdwl3pIZOLbkc\";s:22:\"_csrf/datatable_update\";s:43:\"fNGNYfzjMQDgmqboFRCbOowC_7F_BnakggeJ981VNpw\";s:23:\"_csrf/project.duplicate\";s:43:\"hkIaX8nu2HGtXCOhOkg1VSx0pAtFqx3pc0rpKBTa51Q\";s:24:\"_csrf/admin_project_edit\";s:43:\"kXG25MKNawyo6q2e6MDOX822Axt6jmdMHjPYJeZZiEE\";s:20:\"_csrf/timesheet_edit\";s:43:\"mGVT6UkNk2eVx9cFgkj6Js_YRxD-uJF-4qJzNua_Gws\";s:26:\"_csrf/entities_multiupdate\";s:43:\"Vn9uH0qdazkkCqj-iH5xJOk3J8tZF1ch2tGsFQSIjIg\";s:21:\"search_MyTimesListing\";a:13:{s:10:\"searchTerm\";s:0:\"\";s:9:\"daterange\";s:0:\"\";s:9:\"customers\";a:0:{}s:8:\"projects\";a:0:{}s:10:\"activities\";a:0:{}s:4:\"tags\";a:0:{}s:5:\"state\";s:1:\"1\";s:8:\"billable\";s:1:\"0\";s:8:\"exported\";s:1:\"1\";s:8:\"pageSize\";s:2:\"50\";s:4:\"page\";s:1:\"1\";s:5:\"order\";s:4:\"DESC\";s:7:\"orderBy\";s:5:\"begin\";}}_sf2_meta|a:3:{s:1:\"u\";i:1738776457;s:1:\"c\";i:1738776358;s:1:\"l\";i:0;}',1738776457,1738777897),
('9tafc3s6rvhj587q3lqc78pi5q','_sf2_attributes|a:5:{s:22:\"_security_secured_area\";s:466:\"O:68:\"Symfony\\Component\\Security\\Core\\Authentication\\Token\\RememberMeToken\":3:{i:0;s:31:\"change_this_to_something_unique\";i:1;s:12:\"secured_area\";i:2;a:5:{i:0;O:15:\"App\\Entity\\User\":5:{s:2:\"id\";i:2;s:8:\"username\";s:4:\"ciro\";s:7:\"enabled\";b:1;s:5:\"email\";s:17:\"ciro@blue-byte.it\";s:8:\"password\";s:60:\"$2y$13$eCHpio9nWxEEZyNxJQRjLeP2v8TrHLwbZ4dkFtYx15W6bTsMA5062\";}i:1;b:1;i:2;N;i:3;a:0:{}i:4;a:3:{i:0;s:13:\"ROLE_TEAMLEAD\";i:1;s:10:\"ROLE_ADMIN\";i:2;s:9:\"ROLE_USER\";}}}\";s:18:\"search_ExportQuery\";a:12:{s:10:\"searchTerm\";s:0:\"\";s:9:\"daterange\";s:23:\"27/01/2024 - 27/12/2025\";s:9:\"customers\";a:1:{i:0;s:2:\"43\";}s:8:\"projects\";a:1:{i:0;s:2:\"43\";}s:10:\"activities\";a:0:{}s:4:\"tags\";a:0:{}s:5:\"users\";a:0:{}s:8:\"exported\";s:1:\"5\";s:5:\"state\";s:1:\"1\";s:8:\"billable\";s:1:\"0\";s:8:\"renderer\";s:0:\"\";s:14:\"markAsExported\";s:1:\"0\";}s:12:\"_csrf/logout\";s:43:\"Fh8ud_HoRzbygdMDdP-M5D1rbIlj90omZqtopKzZUOM\";s:22:\"_csrf/datatable_update\";s:43:\"LaiasYqF6gU8UbhJbwEXAL9y-PNxjmScntXjPGnDH8s\";s:12:\"_csrf/search\";s:43:\"XjMvi2-rTk4JJ5obP8IXMDNxMAEDXpbVBZ6MXDK27_Q\";}_sf2_meta|a:3:{s:1:\"u\";i:1738681864;s:1:\"c\";i:1738681378;s:1:\"l\";i:0;}',1738681864,1738683304),
('9uf016cde1ca6vmlbhni1rpgsl','_sf2_attributes|a:7:{s:12:\"_csrf/logout\";s:43:\"9TAedy22XrBp-5LJeDOGPzrlIMsFxR_fliY6OPcD8vk\";s:12:\"_csrf/search\";s:43:\"aZnBLluNL5sUrfyrPCd_O3NqITkLeWG5mgkogczVYh4\";s:22:\"_csrf/datatable_update\";s:43:\"9JNaVAyGR8woQA0u7H92e_MMdWdfWQggp0TBa633nOI\";s:26:\"_csrf/entities_multiupdate\";s:43:\"-08p79fRn-xIEmjPD9nktjxsuG_OGzc7hgQJHnQ2PVU\";s:22:\"_security_secured_area\";s:452:\"O:68:\"Symfony\\Component\\Security\\Core\\Authentication\\Token\\RememberMeToken\":3:{i:0;s:31:\"change_this_to_something_unique\";i:1;s:12:\"secured_area\";i:2;a:5:{i:0;O:15:\"App\\Entity\\User\":5:{s:2:\"id\";i:3;s:8:\"username\";s:8:\"federico\";s:7:\"enabled\";b:1;s:5:\"email\";s:21:\"federico@blue-byte.it\";s:8:\"password\";s:60:\"$2y$13$GnyT37bDhQgaAdlOHxO16OSpOV50uC8WuOY/qSGZJtjeTJzzjcRRi\";}i:1;b:1;i:2;N;i:3;a:0:{}i:4;a:2:{i:0;s:13:\"ROLE_TEAMLEAD\";i:1;s:9:\"ROLE_USER\";}}}\";s:20:\"_csrf/timesheet_edit\";s:43:\"SdGOJbJUPcV_ygVttlNfkLhF80LiGepsvMKOkQStuCw\";s:21:\"search_MyTimesListing\";a:13:{s:10:\"searchTerm\";s:0:\"\";s:9:\"daterange\";s:0:\"\";s:9:\"customers\";a:0:{}s:8:\"projects\";a:0:{}s:10:\"activities\";a:0:{}s:4:\"tags\";a:0:{}s:5:\"state\";s:1:\"1\";s:8:\"billable\";s:1:\"0\";s:8:\"exported\";s:1:\"1\";s:8:\"pageSize\";s:2:\"50\";s:4:\"page\";s:1:\"1\";s:5:\"order\";s:4:\"DESC\";s:7:\"orderBy\";s:5:\"begin\";}}_sf2_meta|a:3:{s:1:\"u\";i:1739207181;s:1:\"c\";i:1739207077;s:1:\"l\";i:0;}',1739207181,1739208621),
('auti6r01kbercb4bdvhtuo5a93','_sf2_attributes|a:5:{s:18:\"search_ExportQuery\";a:12:{s:10:\"searchTerm\";s:0:\"\";s:9:\"daterange\";s:23:\"01/01/2024 - 31/12/2025\";s:9:\"customers\";a:1:{i:0;s:3:\"108\";}s:8:\"projects\";a:0:{}s:10:\"activities\";a:0:{}s:4:\"tags\";a:0:{}s:5:\"users\";a:0:{}s:8:\"exported\";s:1:\"5\";s:5:\"state\";s:1:\"1\";s:8:\"billable\";s:1:\"0\";s:8:\"renderer\";s:0:\"\";s:14:\"markAsExported\";s:1:\"0\";}s:12:\"_csrf/logout\";s:43:\"KSIg1cWNgdDKgrFzarWS8eTe1yj5YD05zJUslzgHYG0\";s:22:\"_csrf/datatable_update\";s:43:\"HznU7Udr8dnvE8gBcEq4wfI3XLBQPxEEeRqo-kXqabE\";s:12:\"_csrf/search\";s:43:\"mAdC3GAIEdjVCr-bCZZPt8Lb0BGFsYCnpC8Z_GncO3A\";s:22:\"_security_secured_area\";s:466:\"O:68:\"Symfony\\Component\\Security\\Core\\Authentication\\Token\\RememberMeToken\":3:{i:0;s:31:\"change_this_to_something_unique\";i:1;s:12:\"secured_area\";i:2;a:5:{i:0;O:15:\"App\\Entity\\User\":5:{s:2:\"id\";i:2;s:8:\"username\";s:4:\"ciro\";s:7:\"enabled\";b:1;s:5:\"email\";s:17:\"ciro@blue-byte.it\";s:8:\"password\";s:60:\"$2y$13$eCHpio9nWxEEZyNxJQRjLeP2v8TrHLwbZ4dkFtYx15W6bTsMA5062\";}i:1;b:1;i:2;N;i:3;a:0:{}i:4;a:3:{i:0;s:13:\"ROLE_TEAMLEAD\";i:1;s:10:\"ROLE_ADMIN\";i:2;s:9:\"ROLE_USER\";}}}\";}_sf2_meta|a:3:{s:1:\"u\";i:1738941597;s:1:\"c\";i:1738941597;s:1:\"l\";i:0;}',1738941597,1738943037),
('bdtgp8ni94bav4kaqohu5tgu3d','_sf2_attributes|a:1:{s:34:\"_security.secured_area.target_path\";s:37:\"http://kimai.blue-byte.it/en/homepage\";}_sf2_meta|a:3:{s:1:\"u\";i:1738779570;s:1:\"c\";i:1738779570;s:1:\"l\";i:0;}',1738779570,1738781010),
('bfmuoa10pabecni2io8gu3ehav','_sf2_attributes|a:7:{s:20:\"_csrf/timesheet_edit\";s:43:\"5OhUPQsyS-_mRUpg3xPSR1fFZV8O7nr8nP20pKD2clI\";s:22:\"_security_secured_area\";s:453:\"O:68:\"Symfony\\Component\\Security\\Core\\Authentication\\Token\\RememberMeToken\":3:{i:0;s:31:\"change_this_to_something_unique\";i:1;s:12:\"secured_area\";i:2;a:5:{i:0;O:15:\"App\\Entity\\User\":5:{s:2:\"id\";i:1;s:8:\"username\";s:7:\"claudio\";s:7:\"enabled\";b:1;s:5:\"email\";s:20:\"claudio@blue-byte.it\";s:8:\"password\";s:60:\"$2y$13$n6HH5Y6sJgN4T4g.LavsDOLwOnaQdZgcoMyfb73zs6jPn9/O/SoO6\";}i:1;b:1;i:2;N;i:3;a:0:{}i:4;a:2:{i:0;s:16:\"ROLE_SUPER_ADMIN\";i:1;s:9:\"ROLE_USER\";}}}\";s:12:\"_csrf/logout\";s:43:\"9_fEX1LMvp_nJTkjyO-fdLYcIQdBR09A9JtsdSoNwb0\";s:12:\"_csrf/search\";s:43:\"jF59Yl2wgNrFwgdFLoiY1xwLJC6s_QxI-C2zuNfPG34\";s:22:\"_csrf/datatable_update\";s:43:\"yqn8kJXsq05xNWiw9bodo-AAnJUsV5wy4I4V6BTWjFA\";s:26:\"_csrf/entities_multiupdate\";s:43:\"xGmoNCgQ72qb0jhMJ7ZTrepPIQW4PAPEz7oYgNGBogI\";s:21:\"search_MyTimesListing\";a:13:{s:10:\"searchTerm\";s:0:\"\";s:9:\"daterange\";s:0:\"\";s:9:\"customers\";a:0:{}s:8:\"projects\";a:0:{}s:10:\"activities\";a:0:{}s:4:\"tags\";a:0:{}s:5:\"state\";s:1:\"1\";s:8:\"billable\";s:1:\"0\";s:8:\"exported\";s:1:\"1\";s:8:\"pageSize\";s:2:\"50\";s:4:\"page\";s:1:\"1\";s:5:\"order\";s:4:\"DESC\";s:7:\"orderBy\";s:5:\"begin\";}}_sf2_meta|a:3:{s:1:\"u\";i:1739295595;s:1:\"c\";i:1739295448;s:1:\"l\";i:0;}',1739295595,1739297035),
('c73egcn0s269dr93g2rmpnuegn','_sf2_attributes|a:5:{s:12:\"_csrf/logout\";s:43:\"T2MO9XnlaRr2kD5WlOYDGH7mp8ZDKs9vqgpFcf2XBfs\";s:12:\"_csrf/search\";s:43:\"ad3oYH_1Eb9T2U0UQB0sqKPrrejAwjVGkOtwkDgABoA\";s:22:\"_csrf/datatable_update\";s:43:\"lPRPACRoC4sTwr9BJfNYEJzg61-oCeMTiSl9MDmp5hE\";s:26:\"_csrf/entities_multiupdate\";s:43:\"CS0YCjmoztPkSIz0TMg8vbpR-Jp9tQYTC_W-QyTFLN8\";s:22:\"_security_secured_area\";s:453:\"O:68:\"Symfony\\Component\\Security\\Core\\Authentication\\Token\\RememberMeToken\":3:{i:0;s:31:\"change_this_to_something_unique\";i:1;s:12:\"secured_area\";i:2;a:5:{i:0;O:15:\"App\\Entity\\User\":5:{s:2:\"id\";i:1;s:8:\"username\";s:7:\"claudio\";s:7:\"enabled\";b:1;s:5:\"email\";s:20:\"claudio@blue-byte.it\";s:8:\"password\";s:60:\"$2y$13$n6HH5Y6sJgN4T4g.LavsDOLwOnaQdZgcoMyfb73zs6jPn9/O/SoO6\";}i:1;b:1;i:2;N;i:3;a:0:{}i:4;a:2:{i:0;s:16:\"ROLE_SUPER_ADMIN\";i:1;s:9:\"ROLE_USER\";}}}\";}_sf2_meta|a:3:{s:1:\"u\";i:1739194925;s:1:\"c\";i:1739194608;s:1:\"l\";i:0;}',1739194925,1739196365),
('ceq9b3ktmnmuf2e66lan5gskng','_sf2_attributes|a:5:{s:22:\"_security_secured_area\";s:466:\"O:68:\"Symfony\\Component\\Security\\Core\\Authentication\\Token\\RememberMeToken\":3:{i:0;s:31:\"change_this_to_something_unique\";i:1;s:12:\"secured_area\";i:2;a:5:{i:0;O:15:\"App\\Entity\\User\":5:{s:2:\"id\";i:2;s:8:\"username\";s:4:\"ciro\";s:7:\"enabled\";b:1;s:5:\"email\";s:17:\"ciro@blue-byte.it\";s:8:\"password\";s:60:\"$2y$13$eCHpio9nWxEEZyNxJQRjLeP2v8TrHLwbZ4dkFtYx15W6bTsMA5062\";}i:1;b:1;i:2;N;i:3;a:0:{}i:4;a:3:{i:0;s:13:\"ROLE_TEAMLEAD\";i:1;s:10:\"ROLE_ADMIN\";i:2;s:9:\"ROLE_USER\";}}}\";s:18:\"search_ExportQuery\";a:12:{s:10:\"searchTerm\";s:0:\"\";s:9:\"daterange\";s:23:\"27/01/2024 - 27/12/2025\";s:9:\"customers\";a:1:{i:0;s:1:\"2\";}s:8:\"projects\";a:1:{i:0;s:1:\"2\";}s:10:\"activities\";a:0:{}s:4:\"tags\";a:0:{}s:5:\"users\";a:0:{}s:8:\"exported\";s:1:\"5\";s:5:\"state\";s:1:\"1\";s:8:\"billable\";s:1:\"0\";s:8:\"renderer\";s:0:\"\";s:14:\"markAsExported\";s:1:\"0\";}s:12:\"_csrf/logout\";s:43:\"gauEIvYXY6qVIZkf5nhB6JCmc-wJx_-Urq5jLb5tWOo\";s:22:\"_csrf/datatable_update\";s:43:\"AR06cXYkoW4LqUwDsXCE-cdJJ3X9nz0_HqGVs9pz2tA\";s:12:\"_csrf/search\";s:43:\"3Pd8N63YV1lIJiy_68mEth0wiADaMU1RpLJsef8cN80\";}_sf2_meta|a:3:{s:1:\"u\";i:1738860863;s:1:\"c\";i:1738860847;s:1:\"l\";i:0;}',1738860869,1738862309),
('cndbf7sjn3t4vs22kr44oh4app','_sf2_attributes|a:5:{s:18:\"search_ExportQuery\";a:12:{s:10:\"searchTerm\";s:0:\"\";s:9:\"daterange\";s:23:\"01/01/2024 - 31/12/2025\";s:9:\"customers\";a:1:{i:0;s:3:\"108\";}s:8:\"projects\";a:0:{}s:10:\"activities\";a:0:{}s:4:\"tags\";a:0:{}s:5:\"users\";a:0:{}s:8:\"exported\";s:1:\"5\";s:5:\"state\";s:1:\"1\";s:8:\"billable\";s:1:\"0\";s:8:\"renderer\";s:0:\"\";s:14:\"markAsExported\";s:1:\"0\";}s:12:\"_csrf/logout\";s:43:\"IyfbW1R0MReoeXCGANvJwxvkHqQQYa4bpkQidpgyoTo\";s:22:\"_csrf/datatable_update\";s:43:\"r0zUxmgLIT5uOtgQjr9EWGdBSMrDhG-vDCX3uBW_cqo\";s:12:\"_csrf/search\";s:43:\"z0U7Cqzw_9xwHcxoJXaape9e5PxlBH6UxiuiAXKiEGg\";s:22:\"_security_secured_area\";s:466:\"O:68:\"Symfony\\Component\\Security\\Core\\Authentication\\Token\\RememberMeToken\":3:{i:0;s:31:\"change_this_to_something_unique\";i:1;s:12:\"secured_area\";i:2;a:5:{i:0;O:15:\"App\\Entity\\User\":5:{s:2:\"id\";i:2;s:8:\"username\";s:4:\"ciro\";s:7:\"enabled\";b:1;s:5:\"email\";s:17:\"ciro@blue-byte.it\";s:8:\"password\";s:60:\"$2y$13$eCHpio9nWxEEZyNxJQRjLeP2v8TrHLwbZ4dkFtYx15W6bTsMA5062\";}i:1;b:1;i:2;N;i:3;a:0:{}i:4;a:3:{i:0;s:13:\"ROLE_TEAMLEAD\";i:1;s:10:\"ROLE_ADMIN\";i:2;s:9:\"ROLE_USER\";}}}\";}_sf2_meta|a:3:{s:1:\"u\";i:1738746209;s:1:\"c\";i:1738746209;s:1:\"l\";i:0;}',1738746212,1738747652),
('e64vm5n74n4decps2ev557mj3o','_sf2_attributes|a:1:{s:22:\"_security_secured_area\";s:453:\"O:68:\"Symfony\\Component\\Security\\Core\\Authentication\\Token\\RememberMeToken\":3:{i:0;s:31:\"change_this_to_something_unique\";i:1;s:12:\"secured_area\";i:2;a:5:{i:0;O:15:\"App\\Entity\\User\":5:{s:2:\"id\";i:1;s:8:\"username\";s:7:\"claudio\";s:7:\"enabled\";b:1;s:5:\"email\";s:20:\"claudio@blue-byte.it\";s:8:\"password\";s:60:\"$2y$13$n6HH5Y6sJgN4T4g.LavsDOLwOnaQdZgcoMyfb73zs6jPn9/O/SoO6\";}i:1;b:1;i:2;N;i:3;a:0:{}i:4;a:2:{i:0;s:16:\"ROLE_SUPER_ADMIN\";i:1;s:9:\"ROLE_USER\";}}}\";}_sf2_meta|a:3:{s:1:\"u\";i:1739292397;s:1:\"c\";i:1739292397;s:1:\"l\";i:0;}',1739292398,1739293838),
('e6d79ur072cf2pmuenntfqevee','_sf2_attributes|a:7:{s:12:\"_csrf/logout\";s:43:\"YXTEFVg5wYoer3MifWmGGX3tgL53I8c08KlNaEoLG9E\";s:12:\"_csrf/search\";s:43:\"_KhtCebgjS0vSNxGqBlend1WFTbWFl_d0msRizoU7Gk\";s:22:\"_csrf/datatable_update\";s:43:\"3K_gvG6ZvKO0ZYTZ_ZuqmqTrxpEER5mHoKWlfS4ghs4\";s:26:\"_csrf/entities_multiupdate\";s:43:\"yoGelE62kjsUICwLjYeD15NsM4FC5H8HmktPujaSZWk\";s:22:\"_security_secured_area\";s:452:\"O:68:\"Symfony\\Component\\Security\\Core\\Authentication\\Token\\RememberMeToken\":3:{i:0;s:31:\"change_this_to_something_unique\";i:1;s:12:\"secured_area\";i:2;a:5:{i:0;O:15:\"App\\Entity\\User\":5:{s:2:\"id\";i:3;s:8:\"username\";s:8:\"federico\";s:7:\"enabled\";b:1;s:5:\"email\";s:21:\"federico@blue-byte.it\";s:8:\"password\";s:60:\"$2y$13$GnyT37bDhQgaAdlOHxO16OSpOV50uC8WuOY/qSGZJtjeTJzzjcRRi\";}i:1;b:1;i:2;N;i:3;a:0:{}i:4;a:2:{i:0;s:13:\"ROLE_TEAMLEAD\";i:1;s:9:\"ROLE_USER\";}}}\";s:20:\"_csrf/timesheet_edit\";s:43:\"KYRK1IjpGYiKe6dMouYqUu1jZRTeFcwLSHKxlIUQTTk\";s:21:\"search_MyTimesListing\";a:13:{s:10:\"searchTerm\";s:0:\"\";s:9:\"daterange\";s:0:\"\";s:9:\"customers\";a:0:{}s:8:\"projects\";a:0:{}s:10:\"activities\";a:0:{}s:4:\"tags\";a:0:{}s:5:\"state\";s:1:\"1\";s:8:\"billable\";s:1:\"0\";s:8:\"exported\";s:1:\"1\";s:8:\"pageSize\";s:2:\"50\";s:4:\"page\";s:1:\"1\";s:5:\"order\";s:4:\"DESC\";s:7:\"orderBy\";s:5:\"begin\";}}_sf2_meta|a:3:{s:1:\"u\";i:1738862865;s:1:\"c\";i:1738862624;s:1:\"l\";i:0;}',1738862865,1738864305),
('ed1roqjts90ooh5ko1rg83dmbh','_sf2_attributes|a:1:{s:22:\"_security_secured_area\";s:466:\"O:68:\"Symfony\\Component\\Security\\Core\\Authentication\\Token\\RememberMeToken\":3:{i:0;s:31:\"change_this_to_something_unique\";i:1;s:12:\"secured_area\";i:2;a:5:{i:0;O:15:\"App\\Entity\\User\":5:{s:2:\"id\";i:2;s:8:\"username\";s:4:\"ciro\";s:7:\"enabled\";b:1;s:5:\"email\";s:17:\"ciro@blue-byte.it\";s:8:\"password\";s:60:\"$2y$13$eCHpio9nWxEEZyNxJQRjLeP2v8TrHLwbZ4dkFtYx15W6bTsMA5062\";}i:1;b:1;i:2;N;i:3;a:0:{}i:4;a:3:{i:0;s:13:\"ROLE_TEAMLEAD\";i:1;s:10:\"ROLE_ADMIN\";i:2;s:9:\"ROLE_USER\";}}}\";}_sf2_meta|a:3:{s:1:\"u\";i:1738836461;s:1:\"c\";i:1738836461;s:1:\"l\";i:0;}',1738836465,1738837905),
('g3um9snhd8jjd8upscb7ht8d2g','_sf2_attributes|a:7:{s:20:\"_csrf/timesheet_edit\";s:43:\"oM4TFumqdbqYT5l9P59lFNEtc5S2bQYjLGzjurR_yaA\";s:22:\"_security_secured_area\";s:452:\"O:68:\"Symfony\\Component\\Security\\Core\\Authentication\\Token\\RememberMeToken\":3:{i:0;s:31:\"change_this_to_something_unique\";i:1;s:12:\"secured_area\";i:2;a:5:{i:0;O:15:\"App\\Entity\\User\":5:{s:2:\"id\";i:3;s:8:\"username\";s:8:\"federico\";s:7:\"enabled\";b:1;s:5:\"email\";s:21:\"federico@blue-byte.it\";s:8:\"password\";s:60:\"$2y$13$GnyT37bDhQgaAdlOHxO16OSpOV50uC8WuOY/qSGZJtjeTJzzjcRRi\";}i:1;b:1;i:2;N;i:3;a:0:{}i:4;a:2:{i:0;s:13:\"ROLE_TEAMLEAD\";i:1;s:9:\"ROLE_USER\";}}}\";s:12:\"_csrf/logout\";s:43:\"KvzcpDhY6fmdWumdxYesysblCGVuHS4zLgtcVB9oC9k\";s:12:\"_csrf/search\";s:43:\"6q4DBetYrcErGeGwaBpjl6D_NkqsRFK5VP70NeAKGx4\";s:22:\"_csrf/datatable_update\";s:43:\"ixcqSA3jr1o6Khc2X7DvBXWtXbv2K1uQW-TeW3EKpUg\";s:26:\"_csrf/entities_multiupdate\";s:43:\"wRKeLZBBJ1Hp0lsZ9Eai0qERjS1uKLcI_FPQCH651lU\";s:21:\"search_MyTimesListing\";a:13:{s:10:\"searchTerm\";s:0:\"\";s:9:\"daterange\";s:0:\"\";s:9:\"customers\";a:0:{}s:8:\"projects\";a:0:{}s:10:\"activities\";a:0:{}s:4:\"tags\";a:0:{}s:5:\"state\";s:1:\"1\";s:8:\"billable\";s:1:\"0\";s:8:\"exported\";s:1:\"1\";s:8:\"pageSize\";s:2:\"50\";s:4:\"page\";s:1:\"1\";s:5:\"order\";s:4:\"DESC\";s:7:\"orderBy\";s:5:\"begin\";}}_sf2_meta|a:3:{s:1:\"u\";i:1738690343;s:1:\"c\";i:1738690314;s:1:\"l\";i:0;}',1738690343,1738691783),
('g46jg54tojj9hatemgsjt0r5hc','_sf2_attributes|a:5:{s:12:\"_csrf/logout\";s:43:\"17I7Wte9PbO3h1hwr2OXXCXPxv5kfdbXH5zx1L4JxIg\";s:12:\"_csrf/search\";s:43:\"WvenRNDZvRDfDabKFUSMV5uRRuL3jFgWMvRFKcG9nbQ\";s:22:\"_csrf/datatable_update\";s:43:\"R2fN6qe79Z3iup9-hK7sf6chuaUXbhLgQIswf_MhhBE\";s:26:\"_csrf/entities_multiupdate\";s:43:\"2BWrfMPdQwQTEqoThPCTwwgYT1VfHzFo0UiBmGHN1_0\";s:22:\"_security_secured_area\";s:452:\"O:68:\"Symfony\\Component\\Security\\Core\\Authentication\\Token\\RememberMeToken\":3:{i:0;s:31:\"change_this_to_something_unique\";i:1;s:12:\"secured_area\";i:2;a:5:{i:0;O:15:\"App\\Entity\\User\":5:{s:2:\"id\";i:3;s:8:\"username\";s:8:\"federico\";s:7:\"enabled\";b:1;s:5:\"email\";s:21:\"federico@blue-byte.it\";s:8:\"password\";s:60:\"$2y$13$GnyT37bDhQgaAdlOHxO16OSpOV50uC8WuOY/qSGZJtjeTJzzjcRRi\";}i:1;b:1;i:2;N;i:3;a:0:{}i:4;a:2:{i:0;s:13:\"ROLE_TEAMLEAD\";i:1;s:9:\"ROLE_USER\";}}}\";}_sf2_meta|a:3:{s:1:\"u\";i:1739173227;s:1:\"c\";i:1739173227;s:1:\"l\";i:0;}',1739173262,1739174702),
('g5lcm9trvdsqhmsvqa43he998j','_sf2_attributes|a:7:{s:12:\"_csrf/logout\";s:43:\"mJNWA8Af6-eyUrB48BKx0ZxYrQmoJfJkR0VY42eVTow\";s:12:\"_csrf/search\";s:43:\"dBupSqrIWPKk_r0wyuyigPA4_P4HJWeogxWNMkiBo8c\";s:22:\"_csrf/datatable_update\";s:43:\"f8hxTH6FxWOhgzdObFYlyIS7dxO_gmcYRLOHVKkgteo\";s:26:\"_csrf/entities_multiupdate\";s:43:\"bYete4qwSHBifXKSGtWDYyP3w38xHpxO4f_ZgLlHP64\";s:22:\"_security_secured_area\";s:453:\"O:68:\"Symfony\\Component\\Security\\Core\\Authentication\\Token\\RememberMeToken\":3:{i:0;s:31:\"change_this_to_something_unique\";i:1;s:12:\"secured_area\";i:2;a:5:{i:0;O:15:\"App\\Entity\\User\":5:{s:2:\"id\";i:1;s:8:\"username\";s:7:\"claudio\";s:7:\"enabled\";b:1;s:5:\"email\";s:20:\"claudio@blue-byte.it\";s:8:\"password\";s:60:\"$2y$13$n6HH5Y6sJgN4T4g.LavsDOLwOnaQdZgcoMyfb73zs6jPn9/O/SoO6\";}i:1;b:1;i:2;N;i:3;a:0:{}i:4;a:2:{i:0;s:16:\"ROLE_SUPER_ADMIN\";i:1;s:9:\"ROLE_USER\";}}}\";s:20:\"_csrf/timesheet_edit\";s:43:\"4I2l1eUW4ySnCbOB7TrL--WGri1CCFB0esztlcB1NmY\";s:21:\"search_MyTimesListing\";a:13:{s:10:\"searchTerm\";s:0:\"\";s:9:\"daterange\";s:0:\"\";s:9:\"customers\";a:0:{}s:8:\"projects\";a:0:{}s:10:\"activities\";a:0:{}s:4:\"tags\";a:0:{}s:5:\"state\";s:1:\"1\";s:8:\"billable\";s:1:\"0\";s:8:\"exported\";s:1:\"1\";s:8:\"pageSize\";s:2:\"50\";s:4:\"page\";s:1:\"1\";s:5:\"order\";s:4:\"DESC\";s:7:\"orderBy\";s:5:\"begin\";}}_sf2_meta|a:3:{s:1:\"u\";i:1739179466;s:1:\"c\";i:1739177063;s:1:\"l\";i:0;}',1739179466,1739180906),
('h568tf5apsebb2fn7lrplo99ql','_sf2_attributes|a:7:{s:12:\"_csrf/logout\";s:43:\"hTPo6YmlaayAsmNjhXeGvbaz09lHHmSWWETCI41s6EQ\";s:12:\"_csrf/search\";s:43:\"68_pxzxSQKqAsd7UYwIU-W0FftGOorN6V9BIqqZlYaw\";s:22:\"_csrf/datatable_update\";s:43:\"NXwJnN1QiMtObViaYTODLKiF0x_ycV7MzuUmCDt7YsE\";s:26:\"_csrf/entities_multiupdate\";s:43:\"aHW7_hDJBwIoNrjYJQkPrvNYsuNG2V11897rMAeb-EA\";s:22:\"_security_secured_area\";s:453:\"O:68:\"Symfony\\Component\\Security\\Core\\Authentication\\Token\\RememberMeToken\":3:{i:0;s:31:\"change_this_to_something_unique\";i:1;s:12:\"secured_area\";i:2;a:5:{i:0;O:15:\"App\\Entity\\User\":5:{s:2:\"id\";i:1;s:8:\"username\";s:7:\"claudio\";s:7:\"enabled\";b:1;s:5:\"email\";s:20:\"claudio@blue-byte.it\";s:8:\"password\";s:60:\"$2y$13$n6HH5Y6sJgN4T4g.LavsDOLwOnaQdZgcoMyfb73zs6jPn9/O/SoO6\";}i:1;b:1;i:2;N;i:3;a:0:{}i:4;a:2:{i:0;s:16:\"ROLE_SUPER_ADMIN\";i:1;s:9:\"ROLE_USER\";}}}\";s:20:\"_csrf/timesheet_edit\";s:43:\"thOu0FUX2_dTZar0zCxEiCxAnc7rEbDrNTmKfVkrdow\";s:21:\"search_MyTimesListing\";a:13:{s:10:\"searchTerm\";s:0:\"\";s:9:\"daterange\";s:0:\"\";s:9:\"customers\";a:0:{}s:8:\"projects\";a:0:{}s:10:\"activities\";a:0:{}s:4:\"tags\";a:0:{}s:5:\"state\";s:1:\"1\";s:8:\"billable\";s:1:\"0\";s:8:\"exported\";s:1:\"1\";s:8:\"pageSize\";s:2:\"50\";s:4:\"page\";s:1:\"1\";s:5:\"order\";s:4:\"DESC\";s:7:\"orderBy\";s:5:\"begin\";}}_sf2_meta|a:3:{s:1:\"u\";i:1739290079;s:1:\"c\";i:1739289490;s:1:\"l\";i:0;}',1739290079,1739291519),
('hgcrkh51964ejf0bpv9gva8j24','_sf2_attributes|a:7:{s:22:\"_security_secured_area\";s:453:\"O:68:\"Symfony\\Component\\Security\\Core\\Authentication\\Token\\RememberMeToken\":3:{i:0;s:31:\"change_this_to_something_unique\";i:1;s:12:\"secured_area\";i:2;a:5:{i:0;O:15:\"App\\Entity\\User\":5:{s:2:\"id\";i:1;s:8:\"username\";s:7:\"claudio\";s:7:\"enabled\";b:1;s:5:\"email\";s:20:\"claudio@blue-byte.it\";s:8:\"password\";s:60:\"$2y$13$n6HH5Y6sJgN4T4g.LavsDOLwOnaQdZgcoMyfb73zs6jPn9/O/SoO6\";}i:1;b:1;i:2;N;i:3;a:0:{}i:4;a:2:{i:0;s:16:\"ROLE_SUPER_ADMIN\";i:1;s:9:\"ROLE_USER\";}}}\";s:12:\"_csrf/logout\";s:43:\"k9VySD6tEtQvF7lPbfIVKlQqfYt0utn6FjVXryOi_1g\";s:12:\"_csrf/search\";s:43:\"bXojXClcO7MHkqTv_hsENJ2-r_kbhOlzVvy9NeSLxqs\";s:22:\"_csrf/datatable_update\";s:43:\"a3GPWDostp_E-OowhamRgBw8jvJNxZc6xN1uXeavmrw\";s:26:\"_csrf/entities_multiupdate\";s:43:\"qHRUvX57NkWuznD5hnUZSUYP-9E2w8D7FfMKsXaDLFk\";s:20:\"_csrf/timesheet_edit\";s:43:\"m3TexGc6btIE1CHhUwoIz4VBUE2zZ2dSjIFWXX8gPIE\";s:21:\"search_MyTimesListing\";a:13:{s:10:\"searchTerm\";s:0:\"\";s:9:\"daterange\";s:0:\"\";s:9:\"customers\";a:0:{}s:8:\"projects\";a:0:{}s:10:\"activities\";a:0:{}s:4:\"tags\";a:0:{}s:5:\"state\";s:1:\"1\";s:8:\"billable\";s:1:\"0\";s:8:\"exported\";s:1:\"1\";s:8:\"pageSize\";s:2:\"50\";s:4:\"page\";s:1:\"1\";s:5:\"order\";s:4:\"DESC\";s:7:\"orderBy\";s:5:\"begin\";}}_sf2_meta|a:3:{s:1:\"u\";i:1738690899;s:1:\"c\";i:1738690275;s:1:\"l\";i:0;}',1738690899,1738692339),
('i0hv1ebog0al8gfcnhtni5l13r','_sf2_attributes|a:7:{s:12:\"_csrf/logout\";s:43:\"sfS43zbDQTI7MFn_31tTaIU4DSph-0Go8-p8uhK3xoc\";s:12:\"_csrf/search\";s:43:\"PuTUdqPmja_I4Wflxx2uyCKgrntVqfd7eLQ11KVopu4\";s:22:\"_csrf/datatable_update\";s:43:\"0JUg0oGfeIfaXBpR2Ba9Kg0npq-IEzt9VqO9iiJAsRE\";s:26:\"_csrf/entities_multiupdate\";s:43:\"xod6ztFGIZRI2B0eBsH8MnIlNEq2WmQEEksAnWfTOsk\";s:22:\"_security_secured_area\";s:453:\"O:68:\"Symfony\\Component\\Security\\Core\\Authentication\\Token\\RememberMeToken\":3:{i:0;s:31:\"change_this_to_something_unique\";i:1;s:12:\"secured_area\";i:2;a:5:{i:0;O:15:\"App\\Entity\\User\":5:{s:2:\"id\";i:1;s:8:\"username\";s:7:\"claudio\";s:7:\"enabled\";b:1;s:5:\"email\";s:20:\"claudio@blue-byte.it\";s:8:\"password\";s:60:\"$2y$13$n6HH5Y6sJgN4T4g.LavsDOLwOnaQdZgcoMyfb73zs6jPn9/O/SoO6\";}i:1;b:1;i:2;N;i:3;a:0:{}i:4;a:2:{i:0;s:16:\"ROLE_SUPER_ADMIN\";i:1;s:9:\"ROLE_USER\";}}}\";s:20:\"_csrf/timesheet_edit\";s:43:\"YAaKRA4c1LTyrlGgdeFDRJSPRKYMgntvGbRqwB3Jzww\";s:21:\"search_MyTimesListing\";a:13:{s:10:\"searchTerm\";s:0:\"\";s:9:\"daterange\";s:0:\"\";s:9:\"customers\";a:0:{}s:8:\"projects\";a:0:{}s:10:\"activities\";a:0:{}s:4:\"tags\";a:0:{}s:5:\"state\";s:1:\"1\";s:8:\"billable\";s:1:\"0\";s:8:\"exported\";s:1:\"1\";s:8:\"pageSize\";s:2:\"50\";s:4:\"page\";s:1:\"1\";s:5:\"order\";s:4:\"DESC\";s:7:\"orderBy\";s:5:\"begin\";}}_sf2_meta|a:3:{s:1:\"u\";i:1738855662;s:1:\"c\";i:1738855570;s:1:\"l\";i:0;}',1738855662,1738857102),
('ji15ebdfps9orrdgrmuncem4i4','_sf2_attributes|a:4:{s:22:\"_security_secured_area\";s:422:\"O:74:\"Symfony\\Component\\Security\\Core\\Authentication\\Token\\UsernamePasswordToken\":3:{i:0;N;i:1;s:12:\"secured_area\";i:2;a:5:{i:0;O:15:\"App\\Entity\\User\":5:{s:2:\"id\";i:1;s:8:\"username\";s:7:\"claudio\";s:7:\"enabled\";b:1;s:5:\"email\";s:20:\"claudio@blue-byte.it\";s:8:\"password\";s:60:\"$2y$13$n6HH5Y6sJgN4T4g.LavsDOLwOnaQdZgcoMyfb73zs6jPn9/O/SoO6\";}i:1;b:1;i:2;N;i:3;a:0:{}i:4;a:2:{i:0;s:16:\"ROLE_SUPER_ADMIN\";i:1;s:9:\"ROLE_USER\";}}}\";s:23:\"_security.last_username\";s:7:\"claudio\";s:32:\"_csrf/edit_system_configurations\";s:43:\"ysTZDb5T0TtoCD2OMr6FDXUPwLiHHRj93zwCkHVU8ng\";s:12:\"_csrf/logout\";s:43:\"ndkDTkifHDRbFF9NKXb1GDIxY62utgBdgaJpCWTxG2Y\";}_sf2_meta|a:3:{s:1:\"u\";i:1739309641;s:1:\"c\";i:1739309312;s:1:\"l\";i:0;}',1739309641,1739311081),
('lpu9jh5kufolojn0bcbs8qjunj','_sf2_attributes|a:1:{s:18:\"_csrf/authenticate\";s:43:\"TbvTNEqNg_M8WDKLabwBEIaEORTEqPyz-p5oa8-2oRU\";}_sf2_meta|a:3:{s:1:\"u\";i:1738932969;s:1:\"c\";i:1738932969;s:1:\"l\";i:0;}',1738932970,1738934410),
('mhdrfosnqibma7ccc2j7sqrqei','_sf2_attributes|a:7:{s:12:\"_csrf/logout\";s:43:\"1Tf5TLjxBKJsx_MkKm0MOCUo0wv4rwD0SXHikN3Tcz0\";s:12:\"_csrf/search\";s:43:\"UXOJ7EsThTtyzbEF4aXLvIGy2KxougOZYlDDTmSfKaY\";s:22:\"_csrf/datatable_update\";s:43:\"3AmXajbTZe5MHFMkCBqKiPSqvTyK1x05giORcD7pcGA\";s:26:\"_csrf/entities_multiupdate\";s:43:\"u_ZfV9uria2Gkorl4W8-rBiSNEkyc26yGlpWXatalXI\";s:22:\"_security_secured_area\";s:453:\"O:68:\"Symfony\\Component\\Security\\Core\\Authentication\\Token\\RememberMeToken\":3:{i:0;s:31:\"change_this_to_something_unique\";i:1;s:12:\"secured_area\";i:2;a:5:{i:0;O:15:\"App\\Entity\\User\":5:{s:2:\"id\";i:1;s:8:\"username\";s:7:\"claudio\";s:7:\"enabled\";b:1;s:5:\"email\";s:20:\"claudio@blue-byte.it\";s:8:\"password\";s:60:\"$2y$13$n6HH5Y6sJgN4T4g.LavsDOLwOnaQdZgcoMyfb73zs6jPn9/O/SoO6\";}i:1;b:1;i:2;N;i:3;a:0:{}i:4;a:2:{i:0;s:16:\"ROLE_SUPER_ADMIN\";i:1;s:9:\"ROLE_USER\";}}}\";s:20:\"_csrf/timesheet_edit\";s:43:\"zldgIHaUwcKbw163ZWIioB6RjBHsgRy4-Qq2yl-jnIo\";s:21:\"search_MyTimesListing\";a:13:{s:10:\"searchTerm\";s:0:\"\";s:9:\"daterange\";s:0:\"\";s:9:\"customers\";a:0:{}s:8:\"projects\";a:0:{}s:10:\"activities\";a:0:{}s:4:\"tags\";a:0:{}s:5:\"state\";s:1:\"1\";s:8:\"billable\";s:1:\"0\";s:8:\"exported\";s:1:\"1\";s:8:\"pageSize\";s:2:\"50\";s:4:\"page\";s:1:\"1\";s:5:\"order\";s:4:\"DESC\";s:7:\"orderBy\";s:5:\"begin\";}}_sf2_meta|a:3:{s:1:\"u\";i:1738951661;s:1:\"c\";i:1738950819;s:1:\"l\";i:0;}',1738951661,1738953101),
('moavn841np9d21tffjiheoo1jj','_sf2_attributes|a:1:{s:18:\"_csrf/authenticate\";s:43:\"ZlWTh9IZYQ_YCLkP1wQ7F0HS5x8Kad-wRNZr7oG6NCQ\";}_sf2_meta|a:3:{s:1:\"u\";i:1738725170;s:1:\"c\";i:1738725170;s:1:\"l\";i:0;}',1738725170,1738726610),
('net4e3c7sukg0hdq9qeuel6p7g','_sf2_attributes|a:7:{s:20:\"_csrf/timesheet_edit\";s:43:\"IG4ZhvrkfchN27EllBuPmBd7RtutJcy_WqT7QyOoR34\";s:22:\"_security_secured_area\";s:452:\"O:68:\"Symfony\\Component\\Security\\Core\\Authentication\\Token\\RememberMeToken\":3:{i:0;s:31:\"change_this_to_something_unique\";i:1;s:12:\"secured_area\";i:2;a:5:{i:0;O:15:\"App\\Entity\\User\":5:{s:2:\"id\";i:3;s:8:\"username\";s:8:\"federico\";s:7:\"enabled\";b:1;s:5:\"email\";s:21:\"federico@blue-byte.it\";s:8:\"password\";s:60:\"$2y$13$GnyT37bDhQgaAdlOHxO16OSpOV50uC8WuOY/qSGZJtjeTJzzjcRRi\";}i:1;b:1;i:2;N;i:3;a:0:{}i:4;a:2:{i:0;s:13:\"ROLE_TEAMLEAD\";i:1;s:9:\"ROLE_USER\";}}}\";s:12:\"_csrf/logout\";s:43:\"al3z0i2pFcuFmA35pYlwc20K5zghv62cXFlBhDz8uvg\";s:12:\"_csrf/search\";s:43:\"pOyz9Vz4WBvO8slDFMVFf8AdWghY0vOVP58bE6VREc0\";s:22:\"_csrf/datatable_update\";s:43:\"Y19FfRBZOX4Hv7bZKMWTFFSxLECQ4vT6qhpN2OkzHQU\";s:26:\"_csrf/entities_multiupdate\";s:43:\"WnQQo79geT3Y6a20nxHS0UCtZYJ5aIyi5bmau_NMRpo\";s:21:\"search_MyTimesListing\";a:13:{s:10:\"searchTerm\";s:0:\"\";s:9:\"daterange\";s:0:\"\";s:9:\"customers\";a:0:{}s:8:\"projects\";a:0:{}s:10:\"activities\";a:0:{}s:4:\"tags\";a:0:{}s:5:\"state\";s:1:\"1\";s:8:\"billable\";s:1:\"0\";s:8:\"exported\";s:1:\"1\";s:8:\"pageSize\";s:2:\"50\";s:4:\"page\";s:1:\"1\";s:5:\"order\";s:4:\"DESC\";s:7:\"orderBy\";s:5:\"begin\";}}_sf2_meta|a:3:{s:1:\"u\";i:1738680134;s:1:\"c\";i:1738680076;s:1:\"l\";i:0;}',1738680134,1738681574),
('ni2seum9brfpqioovik0i95hqs','_sf2_attributes|a:1:{s:34:\"_security.secured_area.target_path\";s:37:\"http://kimai.blue-byte.it/en/homepage\";}_sf2_meta|a:3:{s:1:\"u\";i:1738725164;s:1:\"c\";i:1738725164;s:1:\"l\";i:0;}',1738725164,1738726604),
('obps6ggj95d9nb9cck9o2is1q5','_sf2_attributes|a:5:{s:22:\"_security_secured_area\";s:466:\"O:68:\"Symfony\\Component\\Security\\Core\\Authentication\\Token\\RememberMeToken\":3:{i:0;s:31:\"change_this_to_something_unique\";i:1;s:12:\"secured_area\";i:2;a:5:{i:0;O:15:\"App\\Entity\\User\":5:{s:2:\"id\";i:2;s:8:\"username\";s:4:\"ciro\";s:7:\"enabled\";b:1;s:5:\"email\";s:17:\"ciro@blue-byte.it\";s:8:\"password\";s:60:\"$2y$13$eCHpio9nWxEEZyNxJQRjLeP2v8TrHLwbZ4dkFtYx15W6bTsMA5062\";}i:1;b:1;i:2;N;i:3;a:0:{}i:4;a:3:{i:0;s:13:\"ROLE_TEAMLEAD\";i:1;s:10:\"ROLE_ADMIN\";i:2;s:9:\"ROLE_USER\";}}}\";s:18:\"search_ExportQuery\";a:12:{s:10:\"searchTerm\";s:0:\"\";s:9:\"daterange\";s:23:\"27/01/2024 - 27/12/2025\";s:9:\"customers\";a:0:{}s:8:\"projects\";a:0:{}s:10:\"activities\";a:0:{}s:4:\"tags\";a:0:{}s:5:\"users\";a:0:{}s:8:\"exported\";s:1:\"5\";s:5:\"state\";s:1:\"1\";s:8:\"billable\";s:1:\"0\";s:8:\"renderer\";s:0:\"\";s:14:\"markAsExported\";s:1:\"0\";}s:12:\"_csrf/logout\";s:43:\"c85PdPO_qzmvev2Pd40Keh46o9y7Zmxl8sfEIqM998M\";s:22:\"_csrf/datatable_update\";s:43:\"aB9xLdRE-0DkTa6ssC8EbPxL5T3eD44xeAJBk-Sg9PY\";s:12:\"_csrf/search\";s:43:\"M3DA5DjHVG7Nqa51Fjx1vo4awMwblO9R8sJ1JAB0DoM\";}_sf2_meta|a:3:{s:1:\"u\";i:1738688202;s:1:\"c\";i:1738684523;s:1:\"l\";i:0;}',1738688203,1738689643),
('oe495emp21o1n3u1vcsuq13v0u','_sf2_attributes|a:5:{s:18:\"search_ExportQuery\";a:12:{s:10:\"searchTerm\";s:0:\"\";s:9:\"daterange\";s:23:\"27/01/2024 - 27/12/2025\";s:9:\"customers\";a:1:{i:0;s:2:\"87\";}s:8:\"projects\";a:0:{}s:10:\"activities\";a:0:{}s:4:\"tags\";a:0:{}s:5:\"users\";a:0:{}s:8:\"exported\";s:1:\"5\";s:5:\"state\";s:1:\"1\";s:8:\"billable\";s:1:\"0\";s:8:\"renderer\";s:0:\"\";s:14:\"markAsExported\";s:1:\"0\";}s:12:\"_csrf/logout\";s:43:\"c625UgPUbjLbXSCSiMHjgRe8-U5Ro8wjUfVnheukF4M\";s:22:\"_csrf/datatable_update\";s:43:\"HkqadMqJrMr9OZbvv8RYMSJkVCkHsz3duKrp5Tcw_FA\";s:12:\"_csrf/search\";s:43:\"jWgHisb4NVl71WQKvaQRO2IUmPuUgnRPTfYO10gvIyA\";s:22:\"_security_secured_area\";s:466:\"O:68:\"Symfony\\Component\\Security\\Core\\Authentication\\Token\\RememberMeToken\":3:{i:0;s:31:\"change_this_to_something_unique\";i:1;s:12:\"secured_area\";i:2;a:5:{i:0;O:15:\"App\\Entity\\User\":5:{s:2:\"id\";i:2;s:8:\"username\";s:4:\"ciro\";s:7:\"enabled\";b:1;s:5:\"email\";s:17:\"ciro@blue-byte.it\";s:8:\"password\";s:60:\"$2y$13$eCHpio9nWxEEZyNxJQRjLeP2v8TrHLwbZ4dkFtYx15W6bTsMA5062\";}i:1;b:1;i:2;N;i:3;a:0:{}i:4;a:3:{i:0;s:13:\"ROLE_TEAMLEAD\";i:1;s:10:\"ROLE_ADMIN\";i:2;s:9:\"ROLE_USER\";}}}\";}_sf2_meta|a:3:{s:1:\"u\";i:1738836461;s:1:\"c\";i:1738836461;s:1:\"l\";i:0;}',1738836470,1738837910),
('pknhmbmcc4f3j7kip5fbkqgpc2','_sf2_attributes|a:7:{s:22:\"_security_secured_area\";s:453:\"O:68:\"Symfony\\Component\\Security\\Core\\Authentication\\Token\\RememberMeToken\":3:{i:0;s:31:\"change_this_to_something_unique\";i:1;s:12:\"secured_area\";i:2;a:5:{i:0;O:15:\"App\\Entity\\User\":5:{s:2:\"id\";i:1;s:8:\"username\";s:7:\"claudio\";s:7:\"enabled\";b:1;s:5:\"email\";s:20:\"claudio@blue-byte.it\";s:8:\"password\";s:60:\"$2y$13$n6HH5Y6sJgN4T4g.LavsDOLwOnaQdZgcoMyfb73zs6jPn9/O/SoO6\";}i:1;b:1;i:2;N;i:3;a:0:{}i:4;a:2:{i:0;s:16:\"ROLE_SUPER_ADMIN\";i:1;s:9:\"ROLE_USER\";}}}\";s:21:\"search_MyTimesListing\";a:13:{s:10:\"searchTerm\";s:0:\"\";s:9:\"daterange\";s:0:\"\";s:9:\"customers\";a:0:{}s:8:\"projects\";a:0:{}s:10:\"activities\";a:0:{}s:4:\"tags\";a:0:{}s:5:\"state\";s:1:\"1\";s:8:\"billable\";s:1:\"0\";s:8:\"exported\";s:1:\"1\";s:8:\"pageSize\";s:2:\"50\";s:4:\"page\";s:1:\"1\";s:5:\"order\";s:4:\"DESC\";s:7:\"orderBy\";s:5:\"begin\";}s:12:\"_csrf/logout\";s:43:\"gIMLGyzFu5PEKCRenJhOWJ2DPcAsu1BTboM44uAPbiE\";s:12:\"_csrf/search\";s:43:\"l6UyGRetnDpnElR5WKcpavDhtbVEW4MIPFsscTH5UIk\";s:22:\"_csrf/datatable_update\";s:43:\"FRnpECDzoindoWk6NixO_Wt5o62wr9Z7CFL-MlApRUw\";s:26:\"_csrf/entities_multiupdate\";s:43:\"b5EKvKD2n4fA3mSCVRXtjZAwdcIo3mdM08m5E2ouMN4\";s:20:\"_csrf/timesheet_edit\";s:43:\"mo-ntzf45dQSzgFDQQUE_0W1HHGirI9SszbNHS_XfnA\";}_sf2_meta|a:3:{s:1:\"u\";i:1739206212;s:1:\"c\";i:1739204434;s:1:\"l\";i:0;}',1739206212,1739207652),
('q30l2ad0aqe0oc5mn8sqtbqe01','_sf2_attributes|a:5:{s:18:\"search_ExportQuery\";a:12:{s:10:\"searchTerm\";s:0:\"\";s:9:\"daterange\";s:23:\"01/01/2024 - 31/12/2024\";s:9:\"customers\";a:1:{i:0;s:2:\"81\";}s:8:\"projects\";a:1:{i:0;s:2:\"81\";}s:10:\"activities\";a:0:{}s:4:\"tags\";a:0:{}s:5:\"users\";a:0:{}s:8:\"exported\";s:1:\"5\";s:5:\"state\";s:1:\"1\";s:8:\"billable\";s:1:\"0\";s:8:\"renderer\";s:0:\"\";s:14:\"markAsExported\";s:1:\"0\";}s:12:\"_csrf/logout\";s:43:\"3mjf886Mh6z2kjBzcYEhGe6HJWnzjnLc49iLTYFUkbA\";s:22:\"_csrf/datatable_update\";s:43:\"Q5NMtgQ18xxU9W9-LdwCPCHPBPisZdfuKZx4eHBIIl8\";s:12:\"_csrf/search\";s:43:\"3QaeGwwBscom1b7nB0I5Qz5qhuw6KP8vL1fQZf7fYhA\";s:22:\"_security_secured_area\";s:466:\"O:68:\"Symfony\\Component\\Security\\Core\\Authentication\\Token\\RememberMeToken\":3:{i:0;s:31:\"change_this_to_something_unique\";i:1;s:12:\"secured_area\";i:2;a:5:{i:0;O:15:\"App\\Entity\\User\":5:{s:2:\"id\";i:2;s:8:\"username\";s:4:\"ciro\";s:7:\"enabled\";b:1;s:5:\"email\";s:17:\"ciro@blue-byte.it\";s:8:\"password\";s:60:\"$2y$13$eCHpio9nWxEEZyNxJQRjLeP2v8TrHLwbZ4dkFtYx15W6bTsMA5062\";}i:1;b:1;i:2;N;i:3;a:0:{}i:4;a:3:{i:0;s:13:\"ROLE_TEAMLEAD\";i:1;s:10:\"ROLE_ADMIN\";i:2;s:9:\"ROLE_USER\";}}}\";}_sf2_meta|a:3:{s:1:\"u\";i:1738838734;s:1:\"c\";i:1738838734;s:1:\"l\";i:0;}',1738838736,1738840176),
('rg02hkenh0udbv75aardap6vlk','_sf2_attributes|a:7:{s:22:\"_security_secured_area\";s:453:\"O:68:\"Symfony\\Component\\Security\\Core\\Authentication\\Token\\RememberMeToken\":3:{i:0;s:31:\"change_this_to_something_unique\";i:1;s:12:\"secured_area\";i:2;a:5:{i:0;O:15:\"App\\Entity\\User\":5:{s:2:\"id\";i:1;s:8:\"username\";s:7:\"claudio\";s:7:\"enabled\";b:1;s:5:\"email\";s:20:\"claudio@blue-byte.it\";s:8:\"password\";s:60:\"$2y$13$n6HH5Y6sJgN4T4g.LavsDOLwOnaQdZgcoMyfb73zs6jPn9/O/SoO6\";}i:1;b:1;i:2;N;i:3;a:0:{}i:4;a:2:{i:0;s:16:\"ROLE_SUPER_ADMIN\";i:1;s:9:\"ROLE_USER\";}}}\";s:21:\"search_MyTimesListing\";a:13:{s:10:\"searchTerm\";s:0:\"\";s:9:\"daterange\";s:0:\"\";s:9:\"customers\";a:0:{}s:8:\"projects\";a:0:{}s:10:\"activities\";a:0:{}s:4:\"tags\";a:0:{}s:5:\"state\";s:1:\"1\";s:8:\"billable\";s:1:\"0\";s:8:\"exported\";s:1:\"1\";s:8:\"pageSize\";s:2:\"50\";s:4:\"page\";s:1:\"1\";s:5:\"order\";s:4:\"DESC\";s:7:\"orderBy\";s:5:\"begin\";}s:12:\"_csrf/logout\";s:43:\"aUaPBVlVTlliYc9cm58QTKfXplJZPyXDRblWNsGSK6M\";s:12:\"_csrf/search\";s:43:\"nycgAqWUv2JpK-RHy9U3D2mJMzRNJCj0wFJLL5zVS3E\";s:22:\"_csrf/datatable_update\";s:43:\"is88uVzdlsezjKqIBgwzMN8b-gervkwn-0LZQnMOPZA\";s:26:\"_csrf/entities_multiupdate\";s:43:\"RRBA8nnU_1q6_kNwhtWtFpS-iCExX1M2I13aUoXbMG8\";s:20:\"_csrf/timesheet_edit\";s:43:\"2ib75DjX2dNAF8k47PUsdBmaan1EfhLKXb_kZTGmjUs\";}_sf2_meta|a:3:{s:1:\"u\";i:1738947065;s:1:\"c\";i:1738946303;s:1:\"l\";i:0;}',1738947065,1738948505),
('rh142lub209otltec94trp2ej7','_sf2_attributes|a:7:{s:12:\"_csrf/logout\";s:43:\"gI_Y_YJ17NbrC0k07lq3nUWc0uDxivm5El-IX7Z7WmU\";s:12:\"_csrf/search\";s:43:\"K88rbdEMGCmNVtQuOw1lIcmoNEZcL7s6SPowAzTdrdI\";s:22:\"_csrf/datatable_update\";s:43:\"-FV_8rmCY0VSgPrQaAnEVIyXlRNTI6GAZUpjNSP09hY\";s:26:\"_csrf/entities_multiupdate\";s:43:\"GvOtspQFCuuNQVCXrCGyFgJ6QQPjRXue1fMf8ZdHDJQ\";s:22:\"_security_secured_area\";s:453:\"O:68:\"Symfony\\Component\\Security\\Core\\Authentication\\Token\\RememberMeToken\":3:{i:0;s:31:\"change_this_to_something_unique\";i:1;s:12:\"secured_area\";i:2;a:5:{i:0;O:15:\"App\\Entity\\User\":5:{s:2:\"id\";i:1;s:8:\"username\";s:7:\"claudio\";s:7:\"enabled\";b:1;s:5:\"email\";s:20:\"claudio@blue-byte.it\";s:8:\"password\";s:60:\"$2y$13$n6HH5Y6sJgN4T4g.LavsDOLwOnaQdZgcoMyfb73zs6jPn9/O/SoO6\";}i:1;b:1;i:2;N;i:3;a:0:{}i:4;a:2:{i:0;s:16:\"ROLE_SUPER_ADMIN\";i:1;s:9:\"ROLE_USER\";}}}\";s:20:\"_csrf/timesheet_edit\";s:43:\"7ARw9HITqlTsFcShBr97pIFilxWjuogxmbN1kG_gtPU\";s:21:\"search_MyTimesListing\";a:13:{s:10:\"searchTerm\";s:0:\"\";s:9:\"daterange\";s:0:\"\";s:9:\"customers\";a:0:{}s:8:\"projects\";a:0:{}s:10:\"activities\";a:0:{}s:4:\"tags\";a:0:{}s:5:\"state\";s:1:\"1\";s:8:\"billable\";s:1:\"0\";s:8:\"exported\";s:1:\"1\";s:8:\"pageSize\";s:2:\"50\";s:4:\"page\";s:1:\"1\";s:5:\"order\";s:4:\"DESC\";s:7:\"orderBy\";s:5:\"begin\";}}_sf2_meta|a:3:{s:1:\"u\";i:1738941955;s:1:\"c\";i:1738941085;s:1:\"l\";i:0;}',1738941955,1738943395),
('ser960evi3lo2aonj9s3fqvb5g','_sf2_attributes|a:7:{s:12:\"_csrf/logout\";s:43:\"HjNPB5nWJUyaSEoRsv_8KShjOdn1AHYa39LUXHmdNtg\";s:12:\"_csrf/search\";s:43:\"MMieOLR0IB5pvI5R8Me3OSHB8PvxaSKO5946jSh0c4A\";s:22:\"_csrf/datatable_update\";s:43:\"paiG1M_w-Uluw7_JBhn8PaUjIBsnNC6Zws0uqP5klBs\";s:26:\"_csrf/entities_multiupdate\";s:43:\"zO4jhTk1qIqwOgWMJbK1dhdg-gftMwRknHvhzpIoBZc\";s:22:\"_security_secured_area\";s:452:\"O:68:\"Symfony\\Component\\Security\\Core\\Authentication\\Token\\RememberMeToken\":3:{i:0;s:31:\"change_this_to_something_unique\";i:1;s:12:\"secured_area\";i:2;a:5:{i:0;O:15:\"App\\Entity\\User\":5:{s:2:\"id\";i:3;s:8:\"username\";s:8:\"federico\";s:7:\"enabled\";b:1;s:5:\"email\";s:21:\"federico@blue-byte.it\";s:8:\"password\";s:60:\"$2y$13$GnyT37bDhQgaAdlOHxO16OSpOV50uC8WuOY/qSGZJtjeTJzzjcRRi\";}i:1;b:1;i:2;N;i:3;a:0:{}i:4;a:2:{i:0;s:13:\"ROLE_TEAMLEAD\";i:1;s:9:\"ROLE_USER\";}}}\";s:20:\"_csrf/timesheet_edit\";s:43:\"twFOpsNdrskTTTgR80zJftrE9c0ecZnOg5gkdcPmwTw\";s:21:\"search_MyTimesListing\";a:13:{s:10:\"searchTerm\";s:0:\"\";s:9:\"daterange\";s:0:\"\";s:9:\"customers\";a:0:{}s:8:\"projects\";a:0:{}s:10:\"activities\";a:0:{}s:4:\"tags\";a:0:{}s:5:\"state\";s:1:\"1\";s:8:\"billable\";s:1:\"0\";s:8:\"exported\";s:1:\"1\";s:8:\"pageSize\";s:2:\"50\";s:4:\"page\";s:1:\"1\";s:5:\"order\";s:4:\"DESC\";s:7:\"orderBy\";s:5:\"begin\";}}_sf2_meta|a:3:{s:1:\"u\";i:1739294469;s:1:\"c\";i:1739294306;s:1:\"l\";i:0;}',1739294469,1739295909),
('skaeorkuumdc4mrcrou9gpeofu','_sf2_attributes|a:7:{s:12:\"_csrf/logout\";s:43:\"9zyiLSWUzchZRQIFOLLkVzSH7OiY_PCGRjSbcF4Bf8M\";s:12:\"_csrf/search\";s:43:\"F_CYlwt-Q5SmSi_nmLBhZQKVGxqqry3V0Dz3-jtc3W8\";s:22:\"_csrf/datatable_update\";s:43:\"OZ4noNJqEw900E8REbXyWlYKq_ApORZIKLLNIQ9QO8s\";s:26:\"_csrf/entities_multiupdate\";s:43:\"dQ_7tT3t2fRhs2bmNw1w8KYiGsvqfADdvOBHO-GzBJw\";s:22:\"_security_secured_area\";s:452:\"O:68:\"Symfony\\Component\\Security\\Core\\Authentication\\Token\\RememberMeToken\":3:{i:0;s:31:\"change_this_to_something_unique\";i:1;s:12:\"secured_area\";i:2;a:5:{i:0;O:15:\"App\\Entity\\User\":5:{s:2:\"id\";i:3;s:8:\"username\";s:8:\"federico\";s:7:\"enabled\";b:1;s:5:\"email\";s:21:\"federico@blue-byte.it\";s:8:\"password\";s:60:\"$2y$13$GnyT37bDhQgaAdlOHxO16OSpOV50uC8WuOY/qSGZJtjeTJzzjcRRi\";}i:1;b:1;i:2;N;i:3;a:0:{}i:4;a:2:{i:0;s:13:\"ROLE_TEAMLEAD\";i:1;s:9:\"ROLE_USER\";}}}\";s:20:\"_csrf/timesheet_edit\";s:43:\"bn9wDHg8Zg01h1U2Aj_AmBWRKvcSC1B2s3n7RiPMNFk\";s:21:\"search_MyTimesListing\";a:13:{s:10:\"searchTerm\";s:0:\"\";s:9:\"daterange\";s:0:\"\";s:9:\"customers\";a:0:{}s:8:\"projects\";a:0:{}s:10:\"activities\";a:0:{}s:4:\"tags\";a:0:{}s:5:\"state\";s:1:\"1\";s:8:\"billable\";s:1:\"0\";s:8:\"exported\";s:1:\"1\";s:8:\"pageSize\";s:2:\"50\";s:4:\"page\";s:1:\"1\";s:5:\"order\";s:4:\"DESC\";s:7:\"orderBy\";s:5:\"begin\";}}_sf2_meta|a:3:{s:1:\"u\";i:1738950210;s:1:\"c\";i:1738948863;s:1:\"l\";i:0;}',1738950210,1738951650),
('sruog6mv47rndkg7g8hsd24qlt','_sf2_attributes|a:5:{s:12:\"_csrf/logout\";s:43:\"AF7teY6PBhjq5MUgfcV8MSAFNNaNdmHSPsppzDWkIz0\";s:12:\"_csrf/search\";s:43:\"efZ1xjEpZa7bD5PA3SeZYbDhffDpDpE-7JkwpMaNBh4\";s:22:\"_csrf/datatable_update\";s:43:\"J73eGfgNuqKFQ2Fb1C7574jr5Lkcmt1jkSQhOkPFUcE\";s:26:\"_csrf/entities_multiupdate\";s:43:\"Kp_ZNimB_zXB5Pi31_8SHlQwL2MgtIR3QFaY2Z3VtBk\";s:22:\"_security_secured_area\";s:452:\"O:68:\"Symfony\\Component\\Security\\Core\\Authentication\\Token\\RememberMeToken\":3:{i:0;s:31:\"change_this_to_something_unique\";i:1;s:12:\"secured_area\";i:2;a:5:{i:0;O:15:\"App\\Entity\\User\":5:{s:2:\"id\";i:3;s:8:\"username\";s:8:\"federico\";s:7:\"enabled\";b:1;s:5:\"email\";s:21:\"federico@blue-byte.it\";s:8:\"password\";s:60:\"$2y$13$GnyT37bDhQgaAdlOHxO16OSpOV50uC8WuOY/qSGZJtjeTJzzjcRRi\";}i:1;b:1;i:2;N;i:3;a:0:{}i:4;a:2:{i:0;s:13:\"ROLE_TEAMLEAD\";i:1;s:9:\"ROLE_USER\";}}}\";}_sf2_meta|a:3:{s:1:\"u\";i:1738771015;s:1:\"c\";i:1738771015;s:1:\"l\";i:0;}',1738771016,1738772456),
('tb8pudg6siljein5o7hoaip7mc','_sf2_attributes|a:7:{s:12:\"_csrf/logout\";s:43:\"D0FFQ79USsIVdsKphCqte987I-mGQ4bH2lWOrFZi1y8\";s:12:\"_csrf/search\";s:43:\"t8B1YK7Xzv0QMjl3-8YnLXyqnsUeqwqGk8GEwE2q9io\";s:22:\"_csrf/datatable_update\";s:43:\"jgB1zC7Ump1f2VWWKn2cwjku1h4Ng5-DoVI3X6XHwME\";s:26:\"_csrf/entities_multiupdate\";s:43:\"ml73OsEWgf67UwTo8quatUZe7mwML-ZLs8F0Oc9yU3Q\";s:22:\"_security_secured_area\";s:453:\"O:68:\"Symfony\\Component\\Security\\Core\\Authentication\\Token\\RememberMeToken\":3:{i:0;s:31:\"change_this_to_something_unique\";i:1;s:12:\"secured_area\";i:2;a:5:{i:0;O:15:\"App\\Entity\\User\":5:{s:2:\"id\";i:1;s:8:\"username\";s:7:\"claudio\";s:7:\"enabled\";b:1;s:5:\"email\";s:20:\"claudio@blue-byte.it\";s:8:\"password\";s:60:\"$2y$13$n6HH5Y6sJgN4T4g.LavsDOLwOnaQdZgcoMyfb73zs6jPn9/O/SoO6\";}i:1;b:1;i:2;N;i:3;a:0:{}i:4;a:2:{i:0;s:16:\"ROLE_SUPER_ADMIN\";i:1;s:9:\"ROLE_USER\";}}}\";s:20:\"_csrf/timesheet_edit\";s:43:\"jQ6OjldiNLMMKFsiFMV50j8yQc6HeSzXCtwl5KEDLs0\";s:21:\"search_MyTimesListing\";a:13:{s:10:\"searchTerm\";s:0:\"\";s:9:\"daterange\";s:0:\"\";s:9:\"customers\";a:0:{}s:8:\"projects\";a:0:{}s:10:\"activities\";a:0:{}s:4:\"tags\";a:0:{}s:5:\"state\";s:1:\"1\";s:8:\"billable\";s:1:\"0\";s:8:\"exported\";s:1:\"1\";s:8:\"pageSize\";s:2:\"50\";s:4:\"page\";s:1:\"1\";s:5:\"order\";s:4:\"DESC\";s:7:\"orderBy\";s:5:\"begin\";}}_sf2_meta|a:3:{s:1:\"u\";i:1739200623;s:1:\"c\";i:1739200316;s:1:\"l\";i:0;}',1739200624,1739202064),
('tb9intj5r3buqoq4f5ikghilcs','_sf2_attributes|a:1:{s:22:\"_security_secured_area\";s:466:\"O:68:\"Symfony\\Component\\Security\\Core\\Authentication\\Token\\RememberMeToken\":3:{i:0;s:31:\"change_this_to_something_unique\";i:1;s:12:\"secured_area\";i:2;a:5:{i:0;O:15:\"App\\Entity\\User\":5:{s:2:\"id\";i:2;s:8:\"username\";s:4:\"ciro\";s:7:\"enabled\";b:1;s:5:\"email\";s:17:\"ciro@blue-byte.it\";s:8:\"password\";s:60:\"$2y$13$eCHpio9nWxEEZyNxJQRjLeP2v8TrHLwbZ4dkFtYx15W6bTsMA5062\";}i:1;b:1;i:2;N;i:3;a:0:{}i:4;a:3:{i:0;s:13:\"ROLE_TEAMLEAD\";i:1;s:10:\"ROLE_ADMIN\";i:2;s:9:\"ROLE_USER\";}}}\";}_sf2_meta|a:3:{s:1:\"u\";i:1738746209;s:1:\"c\";i:1738746209;s:1:\"l\";i:0;}',1738746210,1738747650);
/*!40000 ALTER TABLE `kimai2_sessions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `kimai2_tags`
--

DROP TABLE IF EXISTS `kimai2_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `kimai2_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `color` varchar(7) DEFAULT NULL,
  `visible` tinyint(1) DEFAULT 1,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_27CAF54C5E237E06` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `kimai2_tags`
--

LOCK TABLES `kimai2_tags` WRITE;
/*!40000 ALTER TABLE `kimai2_tags` DISABLE KEYS */;
INSERT INTO `kimai2_tags` VALUES
(1,'Personale','#ff0000',1);
/*!40000 ALTER TABLE `kimai2_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `kimai2_teams`
--

DROP TABLE IF EXISTS `kimai2_teams`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `kimai2_teams` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `color` varchar(7) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_3BEDDC7F5E237E06` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `kimai2_teams`
--

LOCK TABLES `kimai2_teams` WRITE;
/*!40000 ALTER TABLE `kimai2_teams` DISABLE KEYS */;
/*!40000 ALTER TABLE `kimai2_teams` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `kimai2_timesheet`
--

DROP TABLE IF EXISTS `kimai2_timesheet`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `kimai2_timesheet` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` int(11) NOT NULL,
  `activity_id` int(11) NOT NULL,
  `project_id` int(11) NOT NULL,
  `start_time` datetime NOT NULL,
  `end_time` datetime DEFAULT NULL,
  `duration` int(11) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `rate` double NOT NULL,
  `fixed_rate` double DEFAULT NULL,
  `hourly_rate` double DEFAULT NULL,
  `exported` tinyint(1) NOT NULL DEFAULT 0,
  `timezone` varchar(64) NOT NULL,
  `internal_rate` double DEFAULT NULL,
  `billable` tinyint(1) DEFAULT 1,
  `category` varchar(10) NOT NULL DEFAULT 'work',
  `modified_at` datetime DEFAULT NULL COMMENT '(DC2Type:datetime)',
  `date_tz` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_4F60C6B18D93D649` (`user`),
  KEY `IDX_4F60C6B181C06096` (`activity_id`),
  KEY `IDX_4F60C6B1166D1F9C` (`project_id`),
  KEY `IDX_4F60C6B18D93D649502DF587` (`user`,`start_time`),
  KEY `IDX_4F60C6B1502DF587` (`start_time`),
  KEY `IDX_4F60C6B1502DF58741561401` (`start_time`,`end_time`),
  KEY `IDX_4F60C6B1502DF587415614018D93D649` (`start_time`,`end_time`,`user`),
  KEY `IDX_4F60C6B1BDF467148D93D649` (`date_tz`,`user`),
  KEY `IDX_4F60C6B1415614018D93D649` (`end_time`,`user`),
  KEY `IDX_TIMESHEET_TICKTAC` (`end_time`,`user`,`start_time`),
  KEY `IDX_TIMESHEET_RECENT_ACTIVITIES` (`user`,`project_id`,`activity_id`),
  KEY `IDX_TIMESHEET_RESULT_STATS` (`user`,`id`,`duration`),
  CONSTRAINT `FK_4F60C6B1166D1F9C` FOREIGN KEY (`project_id`) REFERENCES `kimai2_projects` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_4F60C6B181C06096` FOREIGN KEY (`activity_id`) REFERENCES `kimai2_activities` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_4F60C6B18D93D649` FOREIGN KEY (`user`) REFERENCES `kimai2_users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=8805 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `kimai2_timesheet`
--

LOCK TABLES `kimai2_timesheet` WRITE;
/*!40000 ALTER TABLE `kimai2_timesheet` DISABLE KEYS */;
INSERT INTO `kimai2_timesheet` VALUES
(7,1,1,3,'2021-06-01 12:50:00','2021-06-01 15:08:00',8280,'Configurazione vm kimai2',103.5,NULL,45,1,'Europe/Rome',103.5,1,'work','2021-07-05 14:10:38','2021-06-01'),
(8,1,1,2,'2021-06-01 15:10:00','2021-06-01 15:25:00',900,'Configurazione stampanti Pc Cevasco',11.25,NULL,45,1,'Europe/Rome',11.25,1,'work','2021-07-06 16:25:16','2021-06-01'),
(9,1,1,3,'2021-06-01 07:15:00','2021-06-01 08:20:00',3900,'Fogli',48.75,NULL,45,1,'Europe/Rome',48.75,1,'work','2021-07-05 14:10:35','2021-06-01'),
(10,1,1,1,'2021-06-01 08:22:00','2021-06-01 08:41:00',1140,'problemi telefono forse risolto',14.25,NULL,45,1,'Europe/Rome',14.25,1,'work','2021-07-05 14:23:39','2021-06-01'),
(11,1,1,3,'2021-06-01 08:52:00','2021-06-01 10:23:00',5460,'Cercate info su controller per server alex',68.25,NULL,45,1,'Europe/Rome',68.25,1,'work','2021-07-05 14:10:37','2021-06-01'),
(12,1,1,3,'2021-06-01 15:34:00','2021-06-01 16:27:00',3180,'configurazione vm kimai2',39.75,NULL,45,1,'Europe/Rome',39.75,1,'work','2021-07-05 14:10:39','2021-06-01'),
(13,1,1,3,'2021-06-03 06:31:00','2021-06-03 07:43:00',4320,'Test kimai2 per esportazione',54,NULL,45,1,'Europe/Rome',54,1,'work','2021-07-05 14:10:41','2021-06-03'),
(14,1,3,112,'2021-06-03 12:30:00','2021-06-03 14:40:00',7800,NULL,97.5,NULL,45,1,'Europe/Rome',97.5,0,'work','2021-07-06 16:26:55','2021-06-03'),
(15,3,2,43,'2021-06-01 06:30:00','2021-06-01 07:45:00',4500,'Consegna e configurazione nuovo pc client Luca\r\nRitirato vecchio PC per assistenza\r\nAssistenza su stampante Epson',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-07-05 14:10:11','2021-06-01'),
(16,3,2,104,'2021-06-01 13:20:00','2021-06-01 14:00:00',2400,'Consegna toner Brother\r\nAssistenza su stampante Samsung\r\nAssistenza su pc client Daniele\r\nRiconsegnato portatile agente dopo sostituzione monitor',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-07-05 08:26:00','2021-06-01'),
(17,3,1,96,'2021-06-01 14:20:00','2021-06-01 14:45:00',1500,'Assistenza su pc client Federica per creazione pdf/a',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-07-05 15:15:33','2021-06-01'),
(18,3,1,87,'2021-06-03 07:20:00','2021-06-03 07:35:00',900,'Installata 1 licenza aggiornamento su 2 pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-07-05 15:47:16','2021-06-03'),
(19,3,1,59,'2021-06-03 07:40:00','2021-06-03 07:50:00',600,'Installata 1 licenza aggiornamento su 2 pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-07-05 15:19:41','2021-06-03'),
(20,3,1,50,'2021-06-03 13:35:00','2021-06-03 13:45:00',600,'Installata 1 licenza aggiornamento su 1 pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-07-09 15:49:33','2021-06-03'),
(21,3,1,26,'2021-06-03 12:40:00','2021-06-03 13:25:00',2700,'Assistenza su pc client Banci per problemi ricezione posta, problematica a cui sta lavorandoi claudio',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-07-07 12:21:07','2021-06-03'),
(22,1,1,55,'2021-06-03 14:50:00','2021-06-03 16:30:00',6000,'Spostamento vm da hd a ssd per velocizzare amicowin che nonostante i miglioramenti dsc suggeriva per un\'ulteriore boost',75,NULL,45,1,'Europe/Rome',75,1,'work','2021-07-06 17:24:13','2021-06-03'),
(23,1,1,55,'2021-06-04 09:43:00','2021-06-04 09:58:00',900,'Test con floriana di velocità dopo migrazione a ssd',11.25,NULL,45,1,'Europe/Rome',11.25,1,'work','2021-07-06 17:24:14','2021-06-04'),
(24,1,3,112,'2021-06-04 06:30:00','2021-06-04 09:40:00',11400,'Donazione sangue tutto il giorno',142.5,NULL,45,1,'Europe/Rome',142.5,1,'work','2021-07-06 16:26:56','2021-06-04'),
(25,1,1,50,'2021-06-03 07:55:00','2021-06-03 10:22:00',8820,'Test nextcloud per scopi francesco',110.25,NULL,45,1,'Europe/Rome',110.25,1,'work','2021-07-14 08:59:41','2021-06-03'),
(26,1,1,3,'2021-06-04 12:21:00','2021-06-04 13:10:00',2940,'Foglio ore',36.75,NULL,45,1,'Europe/Rome',36.75,0,'work','2021-07-05 14:10:41','2021-06-04'),
(27,3,1,61,'2021-06-04 08:30:00','2021-06-04 09:00:00',1800,'Assistenza per problemi posta elettronica',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-10 09:10:41','2021-06-04'),
(28,3,1,96,'2021-06-04 09:10:00','2021-06-04 09:20:00',600,'Assistenza su pc client Anna',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-07-06 17:26:25','2021-06-04'),
(29,3,2,29,'2021-06-04 13:00:00','2021-06-04 15:45:00',9900,'Pulizia periodica Server e tutti i pc client\r\nAggiornamento sistema operativo da Windows 7 a Windows 10 su pc client Radiografie\r\nAssistenza su stampante HP\r\nSostituzione disco 2tb bk con disco 4tb su server',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-07-06 17:32:29','2021-06-04'),
(30,1,1,29,'2021-06-05 08:52:00','2021-06-05 09:06:30',870,'Problemi giano dopo intervento di aggiornamento',10.88,NULL,45,1,'Europe/Rome',10.88,1,'work','2021-07-06 17:32:30','2021-06-05'),
(31,1,3,112,'2021-06-07 07:20:00','2021-06-07 09:10:00',6600,NULL,82.5,NULL,45,1,'Europe/Rome',82.5,1,'work','2021-07-06 16:26:57','2021-06-07'),
(32,1,1,55,'2021-06-07 06:40:00','2021-06-07 07:14:00',2040,'verifica per prep migrazione',25.5,NULL,45,1,'Europe/Rome',25.5,1,'work','2021-07-06 17:24:16','2021-06-07'),
(33,1,1,81,'2021-06-07 13:10:00','2021-06-07 14:54:00',6240,'problema ricezione mail',78,NULL,45,1,'Europe/Rome',78,1,'work','2021-09-10 09:15:08','2021-06-07'),
(34,1,1,22,'2021-06-07 14:55:00','2021-06-07 15:30:00',2100,'problema instal autocad su nuovo pc',26.25,NULL,45,1,'Europe/Rome',26.25,1,'work','2021-10-22 07:34:17','2021-06-07'),
(35,3,1,103,'2021-06-07 06:40:00','2021-06-07 07:00:00',1200,'Assistenza su pc client Traverso per problemi posta elettronica',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-07-06 17:36:48','2021-06-07'),
(36,3,1,64,'2021-06-07 09:50:00','2021-06-07 10:05:00',900,'Assistenza su pc client Mirella',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-07-06 17:47:36','2021-06-07'),
(37,1,1,55,'2021-06-08 06:45:00','2021-06-08 09:00:00',8100,'test carico amico win mentre ci lavorano, floriana segnala problemi su 3 pc che dsc sta provando a sistemare',101.25,NULL,45,1,'Europe/Rome',101.25,1,'work','2021-07-06 17:24:17','2021-06-08'),
(38,1,1,2,'2021-06-08 09:02:00','2021-06-08 10:31:00',5340,'Cambio config dns',66.75,NULL,45,1,'Europe/Rome',66.75,1,'work','2021-07-06 16:25:17','2021-06-08'),
(39,1,1,108,'2021-06-08 12:33:00','2021-06-08 12:49:46',1006,'problema desktop sparito',12.58,NULL,45,1,'Europe/Rome',12.58,1,'work','2022-02-22 10:20:14','2021-06-08'),
(40,1,3,112,'2021-06-08 12:50:00','2021-06-08 13:14:00',1440,'contatore gas',18,NULL,45,1,'Europe/Rome',18,1,'work','2021-07-06 16:26:58','2021-06-08'),
(41,1,1,79,'2021-06-08 14:49:00','2021-06-08 16:26:00',5820,'problemi outlook pc roberto',72.75,NULL,45,1,'Europe/Rome',72.75,1,'work','2021-07-05 08:19:58','2021-06-08'),
(42,1,1,81,'2021-06-08 13:23:00','2021-06-08 14:38:00',4500,'problema antiviurs falsi positivi su posta',56.25,NULL,45,1,'Europe/Rome',56.25,1,'work','2021-09-10 09:15:10','2021-06-08'),
(43,1,1,50,'2021-06-09 10:08:00','2021-06-09 10:32:00',1440,'Telefonata con commerciale software fascicolazione',18,NULL,45,1,'Europe/Rome',18,1,'work','2021-07-09 15:49:40','2021-06-09'),
(44,1,1,90,'2021-06-09 14:35:00','2021-06-09 15:06:17',1877,'Disabilitazione spegnimento pc via rdp',23.46,NULL,45,1,'Europe/Rome',23.46,1,'work','2021-07-08 09:29:42','2021-06-09'),
(45,3,1,41,'2021-06-08 12:50:00','2021-06-08 13:20:00',1800,'Assistenza su pc client Francesca per problemi posta elettronica (aveva account pieno)',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-07-07 12:37:04','2021-06-08'),
(46,3,1,50,'2021-06-08 14:15:00','2021-06-08 14:30:00',900,'Assistenza su portatile Filippo per problema salvataggio posta inviata',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-07-09 15:49:35','2021-06-08'),
(47,3,1,96,'2021-06-08 14:50:00','2021-06-08 15:30:00',2400,'Assistenza per problemi stampante Antonella casa al Wifi, da risentire per eventuale intervento in loco',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-07-05 15:15:35','2021-06-08'),
(48,3,1,103,'2021-06-09 08:30:00','2021-06-09 08:45:00',900,'Assistenza su pc client Tiziana per problema con firma digitale',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-07-06 17:36:49','2021-06-09'),
(49,3,2,87,'2021-06-09 10:10:00','2021-06-09 10:30:00',1200,'Riconsegnato pc client Alvarino dopo sostituzione ssd samsung 1 tb e clonazione s.o',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-07-05 15:47:18','2021-06-09'),
(50,3,2,41,'2021-06-09 06:30:00','2021-06-09 08:00:00',5400,'Tentativo pulizia box manutenzione stampante Epson Cinzia\r\nInstallazione 2 licenze nod32 su 4 pc client\r\nAssistenza su pc client Luana e Gabriele',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-07-07 12:37:05','2021-06-09'),
(51,3,2,87,'2021-06-08 09:50:00','2021-06-08 10:20:00',1800,'Verificato e ritirato pc client Alvarino per probabile disco danneggiato',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-07-05 15:54:33','2021-06-08'),
(52,3,4,87,'2021-06-08 15:30:00','2021-06-08 16:30:00',3600,'Clonazione sistema operativo + verifiche su pc client Alvarino\r\nUtilizzato: SSD Samsung 1TB',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-07-05 15:47:17','2021-06-08'),
(53,1,1,79,'2021-06-10 13:04:00','2021-06-10 13:21:00',1020,'Problemi visualizzazione schermo a risoluzione errata pc Andrea, risolto aggiornando i driver schermo e vga',12.75,NULL,45,1,'Europe/Rome',12.75,1,'work','2021-07-05 08:20:04','2021-06-10'),
(54,1,1,2,'2021-06-10 13:25:00','2021-06-10 14:57:00',5520,'Problemi su nostro server linux a gestire permalink wordpress studio problema e risoluzione',69,NULL,45,1,'Europe/Rome',69,1,'work','2021-07-06 16:25:22','2021-06-10'),
(55,1,1,2,'2021-06-10 09:56:00','2021-06-10 11:00:00',3840,'Problemi su nostro server linux a gestire permalink wordpress studio problema e risoluzione',48,NULL,45,1,'Europe/Rome',48,1,'work','2021-07-06 16:25:21','2021-06-10'),
(56,1,1,4,'2021-06-10 06:35:00','2021-06-10 07:25:00',3000,'problemi vm danea con aggiornamento incastrato',37.5,NULL,45,1,'Europe/Rome',37.5,1,'work','2021-07-06 17:53:12','2021-06-10'),
(57,1,3,112,'2021-06-10 07:26:00','2021-06-10 09:55:00',8940,'festa asilo greta',111.75,NULL,45,1,'Europe/Rome',111.75,1,'work','2021-07-06 16:26:59','2021-06-10'),
(58,1,1,2,'2021-06-09 15:15:00','2021-06-09 16:30:00',4500,'Problemi su nostro server linux a gestire permalink wordpress studio problema e risoluzione',56.25,NULL,45,1,'Europe/Rome',56.25,1,'work','2021-07-06 16:25:18','2021-06-09'),
(59,1,1,2,'2021-06-09 12:43:00','2021-06-09 14:19:00',5760,'Problemi su nostro server linux a gestire permalink wordpress studio problema e risoluzione',72,NULL,45,1,'Europe/Rome',72,1,'work','2021-07-06 16:25:18','2021-06-09'),
(60,3,1,4,'2021-06-10 07:20:00','2021-06-10 07:30:00',600,'Assistenza per problema collegamento VM Danea EasyFatt',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-07-06 17:53:13','2021-06-10'),
(61,3,1,4,'2021-06-10 16:10:00','2021-06-10 16:50:00',2400,'Assistenza per problema collegamento VM Danea EasyFatt',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-07-06 17:53:14','2021-06-10'),
(62,1,1,4,'2021-06-10 16:05:00','2021-06-10 16:33:00',1680,'ancora aggiornamento vm crea problemi, configurato orario aggiornamenti',21,NULL,45,1,'Europe/Rome',21,1,'work','2021-07-06 17:53:14','2021-06-10'),
(63,1,3,112,'2021-06-11 06:30:00','2021-06-11 08:45:00',8100,'vaccino',101.25,NULL,45,1,'Europe/Rome',101.25,1,'work','2021-07-06 16:27:00','2021-06-11'),
(64,1,1,26,'2021-06-11 12:34:00','2021-06-11 13:40:00',3960,'Propblema mail che spariscon banci',49.5,NULL,45,1,'Europe/Rome',49.5,1,'work','2021-07-07 12:21:08','2021-06-11'),
(65,1,1,4,'2021-06-11 08:55:00','2021-06-11 10:10:00',4500,'Verifca stato vm dopo problemi di ieri',56.25,NULL,45,1,'Europe/Rome',56.25,1,'work','2021-07-06 17:53:15','2021-06-11'),
(66,1,6,45,'2021-06-11 13:52:00','2021-06-11 13:53:27',87,'problemi connessione un pc',1.09,NULL,45,1,'Europe/Rome',1.09,1,'work','2021-07-09 16:04:59','2021-06-11'),
(67,3,1,88,'2021-06-11 07:15:00','2021-06-11 07:35:00',1200,'Assistenza su pc client per problema lentezza sistema operativo',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-07-05 09:00:34','2021-06-11'),
(68,3,1,50,'2021-06-11 08:40:00','2021-06-11 09:00:00',1200,'Assistenza su pc client Pietro per problemi invio pdf',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-07-09 15:49:43','2021-06-11'),
(69,3,2,41,'2021-06-11 09:15:00','2021-06-11 09:30:00',900,'Consegna e installazione box manutenzione stampante Epson Cinzia',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-07-07 12:37:06','2021-06-11'),
(70,3,2,54,'2021-06-11 13:20:00','2021-06-11 14:20:00',3600,'Riconsegnato pc client dopo reinstallazione + configurazione \r\nCablata rete internet con cavi\r\nUtilizzato: switch gigabit 5 porte (43628, 1 cavo d rete da 5 mt e 1 cavo di rete da 3 mt',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-07-06 17:52:44','2021-06-11'),
(71,3,2,88,'2021-06-11 14:40:00','2021-06-11 16:00:00',4800,'Assistenza su pc client con problemi di lentezza  sistema operativo\r\nMontati 2 banchi da 8 gb ddr3',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-07-05 09:00:36','2021-06-11'),
(72,3,2,12,'2021-06-11 16:10:00','2021-06-11 16:30:00',1200,'Verifica e ritiro pc client per assistenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-07-07 12:45:13','2021-06-11'),
(73,1,6,79,'2021-06-14 07:05:00','2021-06-14 07:18:30',810,'problemi con mouse pc andrea parodi',10.13,NULL,45,1,'Europe/Rome',10.13,1,'work','2021-07-02 15:21:58','2021-06-14'),
(74,1,1,4,'2021-06-14 07:21:00','2021-06-14 08:45:00',5040,'di nuovo problemi vm',63,NULL,45,1,'Europe/Rome',63,1,'work','2021-07-06 17:53:17','2021-06-14'),
(75,3,2,95,'2021-06-14 07:50:00','2021-06-14 08:10:00',1200,'Verrifica funzionamento servizi dopo che è mancata la corrente',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-21 15:29:17','2021-06-14'),
(76,3,1,90,'2021-06-14 07:00:00','2021-06-14 07:30:00',1800,'Assistenza su pc client Donatella per problemi funzionamento Ufficius',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-07-08 09:29:44','2021-06-14'),
(77,3,1,88,'2021-06-14 13:20:00','2021-06-14 13:40:00',1200,'Assistenza su pc client Cristina per verifica upgrade ram',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-07-05 09:00:38','2021-06-14'),
(78,1,1,2,'2021-06-14 15:00:00','2021-06-14 16:43:49',6229,'Installazione server ftp e configurazione utente per accesso a cartella www per la gestion del sito web',77.86,NULL,45,1,'Europe/Rome',77.86,1,'work','2021-07-06 16:25:46','2021-06-14'),
(79,1,1,3,'2021-06-14 09:00:00','2021-06-14 10:30:00',5400,'test proxmox',67.5,NULL,45,1,'Europe/Rome',67.5,1,'work','2021-07-05 14:10:42','2021-06-14'),
(80,1,4,108,'2021-06-15 07:15:00','2021-06-15 07:30:00',900,'Verifica indirizzi email presenti su loro server per riorganizzazione',11.25,NULL,45,1,'Europe/Rome',11.25,1,'work','2022-02-22 10:20:16','2021-06-15'),
(81,1,4,2,'2021-06-15 07:33:00','2021-06-15 07:50:00',1020,'Verifica ups segnalato guasto batterie, ripristino password di accesso powerchute',12.75,NULL,45,1,'Europe/Rome',12.75,1,'work','2021-07-06 16:25:24','2021-06-15'),
(82,1,4,87,'2021-06-15 09:10:00','2021-06-15 09:14:50',290,'problema apertuera wri',3.63,NULL,45,1,'Europe/Rome',3.63,1,'work','2022-02-10 13:18:49','2021-06-15'),
(83,3,4,12,'2021-06-14 15:00:00','2021-06-14 16:00:00',3600,'Assistenza su pc client per problemi all\'avvio',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-07-07 12:45:14','2021-06-14'),
(84,3,1,83,'2021-06-15 06:45:00','2021-06-15 06:55:00',600,'Assistenza per problema collegamento stampanti, devono contattare assistenza Arca',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-10-22 09:54:57','2021-06-15'),
(85,3,2,12,'2021-06-15 10:05:00','2021-06-15 10:20:00',900,'Riconsegnato pc client dopo assistenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-07-07 12:45:15','2021-06-15'),
(86,3,2,67,'2021-06-15 08:00:00','2021-06-15 10:00:00',7200,'Consegna e configurazione nuovo pc client Sabrina\r\nAvviata copia dati da vecchio disco danneggiato, da verificare remotamente',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-07-08 10:21:12','2021-06-15'),
(87,1,2,58,'2021-06-16 07:30:00','2021-06-16 08:15:00',2700,'in carcere per incontro con tecnico non arrivato, rimandato meeting via web alle 11',33.75,NULL,45,1,'Europe/Rome',33.75,1,'work','2021-07-07 13:51:12','2021-06-16'),
(88,1,1,58,'2021-06-16 09:00:00','2021-06-16 09:25:06',1506,'meeting con tecnico carcere',18.83,NULL,45,1,'Europe/Rome',18.83,1,'work','2021-07-07 13:51:13','2021-06-16'),
(89,1,1,51,'2021-06-16 12:56:00','2021-06-16 13:05:00',540,'problema portatile con usb e jack audio non funzionanti, consigliato di portarcelo per verificare connessioni interne.',6.75,NULL,45,1,'Europe/Rome',6.75,1,'work','2021-09-16 14:27:33','2021-06-16'),
(90,1,1,41,'2021-06-17 09:19:00','2021-06-17 11:01:38',6158,'Verifica server windows',76.98,NULL,45,1,'Europe/Rome',76.98,1,'work','2021-07-07 12:37:09','2021-06-17'),
(91,3,1,79,'2021-06-16 09:10:00','2021-06-16 09:20:00',600,'Configurata pec su pc client Matteo',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-07-05 08:20:05','2021-06-16'),
(92,3,1,79,'2021-06-16 12:35:00','2021-06-16 13:15:00',2400,'Assistenza su pc client Paolo per problemi avvio Outlook',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-07-05 08:20:10','2021-06-16'),
(93,3,2,1,'2021-06-17 14:00:00','2021-06-17 15:10:00',4200,'Verificate porte di rete\r\nAssistenza su pc client Andrea\r\nAssistenza su pc client Alberto',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-07-05 15:05:24','2021-06-17'),
(94,3,2,1,'2021-06-17 13:20:00','2021-06-17 13:50:00',1800,'Verificate e segnate tutte le strumentazioni da spostare in porto per trasloco sede',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-07-05 15:05:23','2021-06-17'),
(95,3,2,67,'2021-06-17 12:50:00','2021-06-17 13:00:00',600,'Ritirato disco danneggiato per recupero dati',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-07-05 09:46:28','2021-06-17'),
(96,3,2,41,'2021-06-17 09:10:00','2021-06-17 11:00:00',6600,'Consegna, installazione e configurazione stampante ad aghi Epson LX 350\r\nUtilizzato cavo usbda 2 mt',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-07-07 12:37:08','2021-06-17'),
(97,1,1,4,'2021-06-11 14:00:00','2021-06-11 15:14:00',4440,'ottimizzazione vm',55.5,NULL,45,1,'Europe/Rome',55.5,1,'work','2021-07-06 17:53:16','2021-06-11'),
(98,1,1,2,'2021-06-11 15:19:00','2021-06-11 16:26:00',4020,'problemi sitio cambio link',50.25,NULL,45,1,'Europe/Rome',50.25,1,'work','2021-07-06 16:25:21','2021-06-11'),
(99,1,1,3,'2021-06-14 12:42:00','2021-06-14 14:49:00',7620,'test proxmox',95.25,NULL,45,1,'Europe/Rome',95.25,1,'work','2021-07-05 14:10:43','2021-06-14'),
(100,1,4,3,'2021-06-15 06:30:00','2021-06-15 07:15:00',2700,NULL,33.75,NULL,45,1,'Europe/Rome',33.75,1,'work','2021-07-05 14:10:43','2021-06-15'),
(101,1,4,3,'2021-06-15 09:23:00','2021-06-15 10:30:00',4020,NULL,50.25,NULL,45,1,'Europe/Rome',50.25,1,'work','2021-07-05 14:10:44','2021-06-15'),
(102,1,2,113,'2021-06-15 11:50:00','2021-06-15 12:40:00',3000,'Sopraluogo per preventivo wifi e altre attrezzature',37.5,NULL,45,1,'Europe/Rome',37.5,1,'work','2021-07-09 16:03:54','2021-06-15'),
(103,1,1,113,'2021-06-15 13:50:00','2021-06-15 14:30:00',2400,'Mail per riepilogo',30,NULL,45,1,'Europe/Rome',30,1,'work','2021-07-09 16:03:56','2021-06-15'),
(104,1,1,55,'2021-06-15 14:47:00','2021-06-15 16:18:00',5460,'Agg server',68.25,NULL,45,1,'Europe/Rome',68.25,1,'work','2021-07-06 17:24:18','2021-06-15'),
(105,1,1,50,'2021-06-16 09:40:00','2021-06-16 10:27:00',2820,'per agg template telefoni 3cx',35.25,NULL,45,1,'Europe/Rome',35.25,1,'work','2021-07-09 15:49:46','2021-06-16'),
(106,1,1,3,'2021-06-16 12:30:00','2021-06-16 12:55:00',1500,'test proxmox',18.75,NULL,45,1,'Europe/Rome',18.75,1,'work','2021-07-05 14:10:44','2021-06-16'),
(107,1,1,55,'2021-06-17 06:45:00','2021-06-17 08:13:00',5280,'per connessione lybro a tecnici esterni, aggiornamento vm lybro',66,NULL,45,1,'Europe/Rome',66,1,'work','2021-07-06 17:24:20','2021-06-17'),
(108,1,1,3,'2021-06-17 12:44:00','2021-06-17 16:30:00',13560,'test proxmox',169.5,NULL,45,1,'Europe/Rome',169.5,1,'work','2021-07-05 14:10:52','2021-06-17'),
(109,1,1,41,'2021-06-16 13:24:00','2021-06-16 15:00:00',5760,'Server windows con problemi',72,NULL,45,1,'Europe/Rome',72,1,'work','2021-07-07 12:37:07','2021-06-16'),
(110,1,1,3,'2021-06-16 15:17:00','2021-06-16 16:30:00',4380,'test proxmox',54.75,NULL,45,1,'Europe/Rome',54.75,1,'work','2021-07-05 14:10:56','2021-06-16'),
(111,1,1,3,'2021-06-17 08:27:00','2021-06-17 09:16:00',2940,'problemi controller megaraid su ryzen',36.75,NULL,45,1,'Europe/Rome',36.75,1,'work','2021-07-05 14:10:57','2021-06-17'),
(112,1,1,85,'2021-06-18 08:40:00','2021-06-18 10:30:00',6600,'segnalati problemi spam quando inviano mail',82.5,NULL,45,1,'Europe/Rome',82.5,1,'work','2021-09-15 15:52:31','2021-06-18'),
(113,1,6,22,'2021-06-18 08:27:00','2021-06-18 08:37:00',600,'varie domande',7.5,NULL,45,1,'Europe/Rome',7.5,1,'work','2021-09-10 15:17:34','2021-06-18'),
(114,1,1,3,'2021-06-18 14:50:00','2021-06-18 14:50:00',0,'fogli',0,NULL,45,1,'Europe/Rome',0,1,'work','2021-07-05 14:10:52','2021-06-18'),
(115,1,1,3,'2021-06-18 06:47:00','2021-06-18 08:15:00',5280,'test proxmox su macchina fisica',66,NULL,45,1,'Europe/Rome',66,1,'work','2021-07-05 14:10:45','2021-06-18'),
(116,1,1,3,'2021-06-18 12:43:00','2021-06-18 14:40:00',7020,'test proxmox',87.75,NULL,45,1,'Europe/Rome',87.75,1,'work','2021-07-05 14:10:55','2021-06-18'),
(117,3,4,54,'2021-06-10 15:00:00','2021-06-10 16:00:00',3600,'Reinstallazione sistema operativo su pc client \r\nUtilizzato: ssd 480gb WD green\r\n            4gb ram ddr4',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-07-06 17:52:43','2021-06-10'),
(118,3,4,79,'2021-06-18 06:50:00','2021-06-18 07:00:00',600,'Assistenza su iphone Andrea per problemi certificato posta',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-07-05 08:20:11','2021-06-18'),
(119,3,1,101,'2021-06-18 07:10:00','2021-06-18 08:10:00',3600,'Installata e configurata vpn su portatile Mina\r\nInstallata e configurata vpn su mac Simone\r\nAssistenza su pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-07-09 16:17:18','2021-06-18'),
(120,3,1,88,'2021-06-18 12:40:00','2021-06-18 12:50:00',600,'Assistenza su portatile Garozzo per problemi collegamento cartella server in vpn',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-07-05 09:00:44','2021-06-18'),
(121,3,1,96,'2021-06-18 14:10:00','2021-06-18 14:30:00',1200,'Assistenza su pc client Antonella',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-07-05 15:15:36','2021-06-18'),
(122,3,2,79,'2021-06-18 09:10:00','2021-06-18 09:30:00',1200,'Verifica per installazione wifi Reception',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-07-05 08:20:12','2021-06-18'),
(123,1,1,3,'2021-06-18 15:00:00','2021-06-18 16:30:00',5400,'problemi spam mail su gmail',67.5,NULL,45,1,'Europe/Rome',67.5,1,'work','2021-07-05 14:10:55','2021-06-18'),
(124,1,1,3,'2021-06-21 06:44:00','2021-06-21 10:30:00',13560,'problemi spam mail su gmail',169.5,NULL,45,1,'Europe/Rome',169.5,1,'work','2021-07-05 14:10:59','2021-06-21'),
(125,1,1,3,'2021-06-21 12:45:00','2021-06-21 14:48:00',7380,'problemi spam mail su gmail',92.25,NULL,45,1,'Europe/Rome',92.25,1,'work','2021-07-06 16:26:01','2021-06-21'),
(126,3,1,83,'2021-06-21 09:15:00','2021-06-21 09:25:00',600,'Assistenza su pc client Roberta',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-10-22 10:01:04','2021-06-21'),
(127,3,1,87,'2021-06-21 09:25:00','2021-06-21 10:05:00',2400,'Assistenza su pc client Salsi per recupero vecchie pec',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-07-05 15:47:20','2021-06-21'),
(128,3,2,96,'2021-06-21 13:05:00','2021-06-21 13:55:00',3000,'Assistenza su pc client ex Valeria',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-07-05 15:15:37','2021-06-21'),
(129,3,2,40,'2021-06-21 14:10:00','2021-06-21 14:45:00',2100,'Assistenza su pc client, sostituzione ventola dissipatore con dissipatore universale',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-07-09 16:14:40','2021-06-21'),
(130,3,2,88,'2021-06-21 15:00:00','2021-06-21 16:00:00',3600,'Installazione e verifica 2 banchi 8 gb ram ddr3 su pc client Cristina\r\nAssistenza su pc client Cristina\r\nAssistenza su pc client Maura\r\nFissare ad inizio luglio installazione ssd su pc client Cristina',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-07-05 09:00:41','2021-06-21'),
(131,1,3,112,'2021-06-22 15:40:00','2021-06-22 16:10:00',1800,NULL,22.5,NULL,45,1,'Europe/Rome',22.5,1,'work','2021-07-06 16:27:01','2021-06-22'),
(132,1,1,3,'2021-06-21 15:03:00','2021-06-21 16:30:00',5220,'proxmox su debian puro',65.25,NULL,45,1,'Europe/Rome',65.25,1,'work','2021-07-05 14:10:54','2021-06-21'),
(133,1,1,3,'2021-06-22 06:45:00','2021-06-22 10:26:00',13260,'proxmox su debian puro',165.75,NULL,45,1,'Europe/Rome',165.75,1,'work','2021-07-05 14:10:54','2021-06-22'),
(134,1,1,3,'2021-06-22 12:40:00','2021-06-22 15:40:00',10800,'proxmox su debian puro con export e import vdi da vm abvolt',135,NULL,45,1,'Europe/Rome',135,1,'work','2021-07-05 14:10:48','2021-06-22'),
(135,3,2,64,'2021-06-22 09:00:00','2021-06-22 09:20:00',1200,'Sostituzione disco di sistema su server\r\nUtilizzato: disco 2tb WD Red pro',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-07-06 17:47:38','2021-06-22'),
(136,3,2,4,'2021-06-22 10:15:00','2021-06-22 10:30:00',900,'Collegata usb 128gb per copia VM',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-07-06 17:53:18','2021-06-22'),
(137,3,2,4,'2021-06-22 12:40:00','2021-06-22 13:25:00',2700,'Ripresa usb 128gb con copia VM\r\nVerifica funzionamento Danea',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-07-06 17:53:19','2021-06-22'),
(138,3,1,40,'2021-06-22 14:10:00','2021-06-22 14:25:00',900,'Provata vpn dopo modifiche fatte dalla Wind sul router, non funziona',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-07-09 16:13:43','2021-06-22'),
(139,3,1,18,'2021-06-22 15:50:00','2021-06-22 16:05:00',900,'Assistenza su pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-06 09:07:35','2021-06-22'),
(140,1,1,55,'2021-06-23 07:35:00','2021-06-23 07:56:46',1306,'config mail telefono luca tarò',16.33,NULL,45,1,'Europe/Rome',16.33,1,'work','2021-07-06 17:24:21','2021-06-23'),
(141,1,1,2,'2021-06-23 13:10:00','2021-06-23 13:40:00',1800,'fede li per problemi telecamere e spostamento fax e pc',22.5,NULL,45,1,'Europe/Rome',22.5,1,'work','2021-07-06 16:25:20','2021-06-23'),
(142,1,1,50,'2021-06-23 08:10:00','2021-06-23 10:30:00',8400,'Installazione e configurazione vm windows 2019',105,NULL,45,1,'Europe/Rome',105,1,'work','2021-09-10 15:23:06','2021-06-23'),
(143,1,1,4,'2021-06-23 06:40:00','2021-06-23 07:23:00',2580,'Ultimi test vm proxmox',32.25,NULL,45,1,'Europe/Rome',32.25,1,'work','2021-07-06 17:53:20','2021-06-23'),
(144,1,1,50,'2021-06-23 12:30:00','2021-06-23 13:04:00',2040,'Installazione e configurazione vm windows 2019\r\n\r\n1 win2k19 standard',25.5,NULL,45,1,'Europe/Rome',25.5,1,'work','2021-09-10 15:23:08','2021-06-23'),
(145,1,1,22,'2021-06-23 14:05:00','2021-06-23 15:18:33',4413,'problòema aruba key',55.16,NULL,45,1,'Europe/Rome',55.16,1,'work','2021-10-22 07:34:18','2021-06-23'),
(146,1,1,50,'2021-06-23 15:19:00','2021-06-23 16:23:41',3881,'modifiche al centralino\r\nSeguito Sig. Rebuffo per il collegamento al nuovo server virtuale',48.51,NULL,45,1,'Europe/Rome',48.51,1,'work','2021-09-10 15:23:14','2021-06-23'),
(147,3,1,103,'2021-06-23 07:45:00','2021-06-23 08:10:00',1500,'Recupero e ripristino backupc  della cartella Tmsprg',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-07-06 17:36:50','2021-06-23'),
(148,3,2,2,'2021-06-23 12:30:00','2021-06-23 14:00:00',5400,'Assistenza  per spostamento fax, cassa e nuova postazione client\r\nVerifica e ritiro pc per assistenza\r\nAssistenza su Iphone Cevasco\r\nUtilizzato: cavo di rete 5mt, cavo VGA',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-07-06 16:25:24','2021-06-23'),
(149,1,1,1,'2021-06-25 06:45:00','2021-06-25 10:30:00',13500,'Fede li per traslocco, aiutato per configurazione firewall e test sistemi. riconfigurazione centralino',168.75,NULL,45,1,'Europe/Rome',168.75,1,'work','2021-07-05 15:05:26','2021-06-25'),
(150,1,1,2,'2021-06-28 14:00:00','2021-06-28 15:29:50',5390,'backup fatel pre aggiornamento',67.38,NULL,45,1,'Europe/Rome',67.38,1,'work','2021-07-06 16:25:26','2021-06-28'),
(151,1,1,1,'2021-06-28 06:44:00','2021-06-28 09:10:00',8760,'problemi spamlist',109.5,NULL,45,1,'Europe/Rome',109.5,1,'work','2021-07-05 15:05:29','2021-06-28'),
(152,1,1,88,'2021-06-28 09:13:00','2021-06-28 09:30:00',1020,'problemi ssl',12.75,NULL,45,1,'Europe/Rome',12.75,1,'work','2021-07-05 09:00:46','2021-06-28'),
(153,1,1,24,'2021-06-28 12:45:00','2021-06-28 14:00:00',4500,'problemi ricezione spam',56.25,NULL,45,1,'Europe/Rome',56.25,1,'work','2021-07-09 10:27:25','2021-06-28'),
(154,1,1,2,'2021-06-28 16:01:00','2021-06-28 16:35:00',2040,'installazione desktop telematico su pc laura',25.5,NULL,45,1,'Europe/Rome',25.5,1,'work','2021-07-06 16:25:27','2021-06-28'),
(155,3,2,1,'2021-06-25 06:45:00','2021-06-25 11:00:00',15300,'Montato server e firewall della sede in succursale. Configurazione server e firewall\r\nConfigurazione pc client, telefoni, wifi e stampanti\r\nUtilizzato: switch gigabit 5 porte 435813, cavo di rete da 5mt',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-07-05 15:05:25','2021-06-25'),
(156,3,2,4,'2021-06-25 11:10:00','2021-06-25 12:10:00',3600,'Collegato cavo di rete al controller areca + verifiche dopo riavvio server\r\nUtilizzato: cavo di rete da 2mt',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-07-06 17:53:21','2021-06-25'),
(157,3,1,1,'2021-06-25 13:30:00','2021-06-25 14:30:00',3600,'Assistenza su pc client Alessio sede Borzoli per problema collegamento db gestionale\r\nConfigurazione stampante su pc Alessio',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-07-05 15:05:27','2021-06-25'),
(158,3,2,26,'2021-06-28 13:30:00','2021-06-28 14:30:00',3600,'Consegnato e affiancato nuovo server al vecchio',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-07-06 16:28:24','2021-06-28'),
(159,3,1,1,'2021-06-28 06:50:00','2021-06-28 07:10:00',1200,'Assistenza su pc Alessio sede Borzoli per problema stampa gestionale',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-07-05 15:05:30','2021-06-28'),
(160,3,1,1,'2021-06-28 15:30:00','2021-06-28 15:50:00',1200,'Assistenza su pc client Alessio sede Borzoli per problema salvataggio pdf da gestionale',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-07-05 15:05:31','2021-06-28'),
(161,3,1,50,'2021-06-28 16:00:00','2021-06-28 16:10:00',600,'Assistenza su pc client Filippo per aggiornamenti stampante Brother',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-07-09 15:49:53','2021-06-28'),
(162,1,1,3,'2021-06-29 12:42:00','2021-06-29 14:13:00',5460,'Backup, e aggiornamento mac di privato',68.25,NULL,45,1,'Europe/Rome',68.25,1,'work','2021-07-06 16:26:03','2021-06-29'),
(163,1,1,50,'2021-06-29 06:38:00','2021-06-29 09:00:00',8520,'problema telefoni non squillano problema firmware',106.5,NULL,45,1,'Europe/Rome',106.5,1,'work','2021-07-09 15:49:56','2021-06-29'),
(164,1,1,50,'2021-06-29 14:14:00','2021-06-29 14:29:00',900,'problema telefoni non squillano problema firmware',11.25,NULL,45,1,'Europe/Rome',11.25,1,'work','2021-07-09 15:50:01','2021-06-29'),
(165,1,1,24,'2021-06-28 15:30:00','2021-06-28 16:00:00',1800,'problema spam',22.5,NULL,45,1,'Europe/Rome',22.5,1,'work','2021-07-09 10:27:26','2021-06-28'),
(166,1,1,24,'2021-06-28 09:35:00','2021-06-28 10:30:00',3300,'problema spam',41.25,NULL,45,1,'Europe/Rome',41.25,1,'work','2021-07-09 09:56:27','2021-06-28'),
(167,1,1,24,'2021-06-29 09:08:00','2021-06-29 10:23:00',4500,'problema spam',56.25,NULL,45,1,'Europe/Rome',56.25,1,'work','2021-07-09 10:27:27','2021-06-29'),
(168,1,3,112,'2021-06-30 12:30:00','2021-06-30 13:10:00',2400,NULL,30,NULL,45,1,'Europe/Rome',30,1,'work','2021-07-06 16:27:01','2021-06-30'),
(169,1,1,3,'2021-06-29 14:42:00','2021-06-29 16:30:00',6480,'studio rspamd',81,NULL,45,1,'Europe/Rome',81,1,'work','2021-07-05 14:10:59','2021-06-29'),
(170,1,1,3,'2021-06-30 06:42:00','2021-06-30 08:10:00',5280,'studio rspamd',66,NULL,45,1,'Europe/Rome',66,1,'work','2021-07-05 14:10:53','2021-06-30'),
(171,1,1,1,'2021-06-30 13:14:00','2021-06-30 13:52:25',2305,'lamentano problemi velocità mail, ricerca libretto isturzioni telefono',28.81,NULL,45,1,'Europe/Rome',28.81,1,'work','2021-07-05 15:05:38','2021-06-30'),
(172,1,1,51,'2021-06-30 13:53:00','2021-06-30 16:08:42',8142,'Studio per collegamento remoto a tablet android via vnc',101.78,NULL,45,1,'Europe/Rome',101.78,1,'work','2021-09-16 15:26:41','2021-06-30'),
(173,1,1,2,'2021-06-30 16:09:00','2021-06-30 16:30:00',1260,'Problemi mail server troppe connessioni',15.75,NULL,45,1,'Europe/Rome',15.75,1,'work','2021-07-06 16:25:32','2021-06-30'),
(174,1,1,2,'2021-06-30 08:19:00','2021-06-30 10:25:00',7560,'manutenzione su segnalazione cevasco che non elimina file',94.5,NULL,45,1,'Europe/Rome',94.5,1,'work','2021-07-06 16:25:28','2021-06-30'),
(175,1,1,1,'2021-06-25 12:43:00','2021-06-25 15:00:00',8220,'problemi di port forwarding per centralino, configurazione reverse mx per server posta, problemi blacklist',102.75,NULL,45,1,'Europe/Rome',102.75,1,'work','2021-07-05 15:05:28','2021-06-25'),
(176,1,1,4,'2021-06-25 15:10:00','2021-06-25 16:30:00',4800,'problemi accesso controller. fede li per collegare cavo direttamente a controller',60,NULL,45,1,'Europe/Rome',60,1,'work','2021-07-06 17:53:21','2021-06-25'),
(177,1,1,3,'2021-06-01 06:46:00','2021-06-01 07:05:00',1140,'ultime sistemazioni kimai2',14.25,NULL,45,1,'Europe/Rome',14.25,1,'work','2021-07-05 14:10:34','2021-06-01'),
(178,1,1,29,'2021-06-04 15:10:00','2021-06-04 16:30:00',4800,'Tentativo di sistemazione backup remotro',60,NULL,45,1,'Europe/Rome',60,1,'work','2021-07-06 17:27:24','2021-06-04'),
(179,1,1,55,'2021-06-04 13:23:00','2021-06-04 15:00:00',5820,'test dopo migrazione su ssd di amicowin',72.75,NULL,45,1,'Europe/Rome',72.75,1,'work','2021-07-06 17:24:15','2021-06-04'),
(180,1,1,1,'2021-06-07 09:13:00','2021-06-07 10:27:00',4440,'Agg server e 3cx',55.5,NULL,45,1,'Europe/Rome',55.5,1,'work','2021-07-05 15:05:22','2021-06-07'),
(181,1,1,3,'2021-06-07 12:40:00','2021-06-07 13:00:00',1200,'test import kimai1 al 2',15,NULL,45,1,'Europe/Rome',15,1,'work','2021-07-05 14:10:50','2021-06-07'),
(182,1,1,81,'2021-06-07 15:48:00','2021-06-07 16:24:00',2160,'problema falsi positivi antivirus',27,NULL,45,1,'Europe/Rome',27,1,'work','2021-09-10 09:15:09','2021-06-07'),
(183,1,1,81,'2021-06-09 06:40:00','2021-06-09 08:00:00',4800,'problema falsi positivi',60,NULL,45,1,'Europe/Rome',60,1,'work','2021-09-10 09:15:11','2021-06-09'),
(184,1,1,4,'2021-06-09 08:10:00','2021-06-09 09:48:00',5880,'vm lenta',73.5,NULL,45,1,'Europe/Rome',73.5,1,'work','2021-07-06 17:53:11','2021-06-09'),
(185,1,1,3,'2021-06-22 16:12:00','2021-06-22 16:30:00',1080,'test proxmox',13.5,NULL,45,1,'Europe/Rome',13.5,1,'work','2021-07-05 14:10:54','2021-06-22'),
(186,1,1,3,'2021-07-01 06:41:00','2021-07-01 07:36:00',3300,'controllo fogli',41.25,NULL,45,1,'Europe/Rome',41.25,1,'work','2021-09-10 15:25:16','2021-07-01'),
(187,1,1,2,'2021-07-01 07:48:00','2021-07-01 08:00:24',744,'cancellazione file roaming',9.3,NULL,45,1,'Europe/Rome',9.3,1,'work','2021-11-17 14:37:59','2021-07-01'),
(188,1,6,51,'2021-07-01 08:06:00','2021-07-01 08:08:00',120,'per spiegazione collegamento vnc',1.5,NULL,45,1,'Europe/Rome',1.5,1,'work','2021-09-16 14:24:18','2021-07-01'),
(189,1,1,3,'2021-07-01 09:00:00','2021-07-01 10:30:00',5400,'Corso sicurezza',67.5,NULL,45,1,'Europe/Rome',67.5,1,'work','2021-09-10 15:25:17','2021-07-01'),
(190,1,1,3,'2021-07-01 12:00:00','2021-07-01 16:07:04',14824,'Corso sicurezza',185.3,NULL,45,1,'Europe/Rome',185.3,1,'work','2021-09-10 15:25:18','2021-07-01'),
(191,3,2,50,'2021-06-29 09:15:00','2021-06-29 09:30:00',900,'Consegna toner  + assistenza su portatile Giuseppe',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-07-09 15:49:58','2021-06-29'),
(192,3,2,1,'2021-06-29 09:40:00','2021-06-29 10:20:00',2400,'Verifica e ritiro pc client Fabrizio per assistenza\r\nConfigurata mail su pc client Roberta, Andrea e Alberto',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-07-05 15:05:34','2021-06-29'),
(193,3,4,59,'2021-06-29 08:00:00','2021-06-29 09:00:00',3600,'Passaggio dati da vecchio cellulare Android a nuovo iPhone',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-07-05 15:19:42','2021-06-29'),
(194,3,1,1,'2021-06-29 07:50:00','2021-06-29 08:00:00',600,'Assistenza su pc client Alessio Borzoli',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-07-05 15:05:32','2021-06-29'),
(195,3,1,96,'2021-06-29 13:00:00','2021-06-29 13:30:00',1800,'Assistenza su pc client Stefano, configurata vpn su portatile Stefano',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-07-05 15:15:38','2021-06-29'),
(196,3,4,1,'2021-06-29 14:00:00','2021-06-29 15:00:00',3600,'Reinstallato pc client Fabrizio per problema s.o\r\nUtilizzato: SSD 240 gb + HHD 2tb',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-07-05 15:05:33','2021-06-29'),
(197,3,4,2,'2021-06-29 15:00:00','2021-06-29 16:00:00',3600,'Aggiornamento sistema operativo a Windows 10 + assistenza \r\nUtilizzato: batteria BIOS',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-07-06 16:25:28','2021-06-29'),
(198,3,2,24,'2021-06-30 07:25:00','2021-06-30 07:55:00',1800,'Verificato e ritirato pc client Gommista',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-07-09 10:27:28','2021-06-30'),
(199,3,2,1,'2021-06-30 09:05:00','2021-06-30 10:15:00',4200,'Riconsegnato e configurato pc client Fabrizio dopo reinstallazione sistema operativo',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-07-05 15:05:36','2021-06-30'),
(200,3,2,2,'2021-06-30 10:35:00','2021-06-30 11:25:00',3000,'Riconsegnato e configurato pc client dopo aggiornamento a Windows 10',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-07-06 16:25:29','2021-06-30'),
(201,3,2,24,'2021-07-01 08:15:00','2021-07-01 08:25:00',600,'Riconsegnato pc client dopo assistenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-07-09 10:27:29','2021-07-01'),
(202,3,2,32,'2021-07-01 08:35:00','2021-07-01 09:05:00',1800,'Assistenza su pc client per problemi di posta e collegamento al gestionale',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-22 10:18:26','2021-07-01'),
(203,3,1,2,'2021-06-30 12:40:00','2021-06-30 12:55:00',900,'Assistenza su pc client Alessia per configurazione gestionale Bollicine',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-07-06 16:25:30','2021-06-30'),
(204,3,1,1,'2021-06-30 13:05:00','2021-06-30 14:05:00',3600,'Assistenza su pc client Fabrizio per problema scaricamento posta \r\nAssistenza su pc client Andrea per problema spazio disco',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-07-05 15:05:37','2021-06-30'),
(205,3,2,24,'2021-06-30 14:15:00','2021-06-30 15:15:00',3600,'Assistenza su pc client Gomme1\r\nUtilizzato: supporto ssd, ssd 480gb S3+, 4gb DDR3 RAM usata',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-07-09 09:46:36','2021-06-30'),
(206,3,1,2,'2021-06-30 15:45:00','2021-06-30 16:30:00',2700,'Assistenza su pc client Alessia per configurazione posta e stampanti',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-07-06 16:25:31','2021-06-30'),
(207,3,1,108,'2021-07-01 07:20:00','2021-07-01 07:30:00',600,'Assistenza su pc client Alessia per software etichette',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-22 10:20:17','2021-07-01'),
(208,3,1,1,'2021-07-01 10:00:00','2021-07-01 10:30:00',1800,'Assistenza su pc client Roberta per problemi spazio disco',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-21 10:47:01','2021-07-01'),
(209,3,1,1,'2021-07-01 15:10:00','2021-07-01 16:00:00',3000,'Assistenza su pc client Roberta per problemi spazio disco, spostata posta elettronica',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-21 10:47:02','2021-07-01'),
(210,3,1,41,'2021-07-01 09:30:00','2021-07-01 10:00:00',1800,'Assistenza su pc client Luana per problemi collegamento con stampante ad aghi',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-16 14:21:06','2021-07-01'),
(211,1,1,55,'2021-07-01 16:13:00','2021-07-01 16:32:00',1140,'problema coedit segnalato da marika',14.25,NULL,45,1,'Europe/Rome',14.25,1,'work','2021-09-22 15:31:16','2021-07-01'),
(212,1,1,2,'2021-07-02 09:13:00','2021-07-02 10:26:00',4380,'Problemi profilo roaming cevasco',54.75,NULL,45,1,'Europe/Rome',54.75,1,'work','2021-11-17 14:38:01','2021-07-02'),
(213,1,1,108,'2021-07-02 07:35:00','2021-07-02 09:09:00',5640,'problemi centralino cercati manuali e contatti con battistini, valutato passaggio a 3cx',70.5,NULL,45,1,'Europe/Rome',70.5,1,'work','2022-02-22 10:20:19','2021-07-02'),
(214,1,1,108,'2021-07-02 06:47:00','2021-07-02 07:27:00',2400,'studio per cambio config server di posta',30,NULL,45,1,'Europe/Rome',30,1,'work','2022-02-22 10:20:18','2021-07-02'),
(215,1,1,90,'2021-07-02 13:16:00','2021-07-02 13:41:00',1500,'creazione file vpn e config vpn su pc del figlio di campodoni',18.75,NULL,45,1,'Europe/Rome',18.75,1,'work','2021-07-08 09:29:45','2021-07-02'),
(216,1,1,2,'2021-07-02 12:30:00','2021-07-02 13:15:00',2700,'Installazione roundcube webmail e passati i dati a laura per accesso da cellulare',33.75,NULL,45,1,'Europe/Rome',33.75,1,'work','2021-11-17 14:38:02','2021-07-02'),
(217,1,4,3,'2021-07-02 14:30:00','2021-07-02 16:10:00',6000,'Aiutato ciro nell\'apprendimento dell\'uso del kimai2\r\nvisionato tablet privato che lamenta uso batteria alto dopo sostituzione',75,NULL,45,1,'Europe/Rome',75,1,'work','2021-09-10 15:25:20','2021-07-02'),
(218,1,1,2,'2021-07-02 13:47:00','2021-07-02 14:11:00',1440,'Installazione roundcube webmail e passati i dati a laura per accesso da cellulare',18,NULL,45,1,'Europe/Rome',18,1,'work','2021-11-17 14:38:03','2021-07-02'),
(219,1,1,41,'2021-07-05 07:33:00','2021-07-05 08:12:00',2340,'problema ip francesca',29.25,NULL,45,1,'Europe/Rome',29.25,1,'work','2021-09-15 16:22:40','2021-07-05'),
(220,1,1,4,'2021-07-05 09:16:00','2021-07-05 10:31:30',4530,'lamentano lentezxza danea',56.63,NULL,45,1,'Europe/Rome',56.63,1,'work','2021-09-14 09:22:45','2021-07-05'),
(221,1,1,103,'2021-07-05 15:15:00','2021-07-05 16:27:00',4320,'problema spazio su disco server linux',54,NULL,45,1,'Europe/Rome',54,1,'work','2021-09-23 15:02:15','2021-07-05'),
(222,1,1,3,'2021-07-05 06:40:00','2021-07-05 07:30:00',3000,'studio printnightmare baco su tutti i sistemi operativi',37.5,NULL,45,1,'Europe/Rome',37.5,1,'work','2021-09-10 15:25:21','2021-07-05'),
(223,1,1,3,'2021-07-05 08:20:00','2021-07-05 09:10:00',3000,'studio printnightmare baco su tutti i sistemi operativi',37.5,NULL,45,1,'Europe/Rome',37.5,1,'work','2021-09-10 15:25:22','2021-07-05'),
(224,3,2,79,'2021-07-02 09:00:00','2021-07-02 09:35:00',2100,'Consegnato e configurato nuovo unifi in reception',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-23 13:51:29','2021-07-02'),
(225,3,2,41,'2021-07-02 09:55:00','2021-07-02 10:45:00',3000,'Assistenza su pc client Luana per stampante ad aghi\r\nConfigurazione stampante su pc Luana e Paola',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-16 14:21:08','2021-07-02'),
(226,3,1,1,'2021-07-05 07:10:00','2021-07-05 07:30:00',1200,'Assistenza su pc client Alessio sede Borzoli',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-21 10:47:03','2021-07-05'),
(227,3,1,41,'2021-07-05 07:35:00','2021-07-05 07:45:00',600,'Verifica problemi di rete su pc client Francesca, risolto poi da Claudio',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-15 16:22:51','2021-07-05'),
(228,3,1,88,'2021-07-05 08:00:00','2021-07-05 09:15:00',4500,'Configurazione nuovo pc client Piazza',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-05 11:21:26','2021-07-05'),
(229,3,1,41,'2021-07-05 09:30:00','2021-07-05 10:05:00',2100,'Assistenza su pc client Fucilli per collegamento stampante ad aghi',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-16 14:21:11','2021-07-05'),
(230,3,1,4,'2021-07-05 10:20:00','2021-07-05 10:30:00',600,'Verifica funzionamento Danea EasyFatt dopo modifiche vm fatte da Claudio',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-14 09:22:47','2021-07-05'),
(231,3,1,41,'2021-07-05 13:40:00','2021-07-05 13:50:00',600,'Assistenza su pc client Fucilli',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-16 14:21:09','2021-07-05'),
(232,3,1,51,'2021-07-05 14:20:00','2021-07-05 14:40:00',1200,'Installata 1 licenza nod32 aggiornamento su 2 pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-16 15:26:42','2021-07-05'),
(233,3,1,24,'2021-07-05 15:30:00','2021-07-05 15:40:00',600,'Installata 1 licenza nod32 aggiornamento su 2 pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-07-09 10:27:30','2021-07-05'),
(234,3,1,88,'2021-07-05 14:45:00','2021-07-05 15:05:00',1200,'Assistenza per passaggio rubrica da vecchio a nuovo pc client Piazza',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-05 11:21:27','2021-07-05'),
(235,1,1,50,'2021-07-06 12:40:00','2021-07-06 14:30:00',6600,'Configurazioni richieste da rebuffo per il gestionare arxivar',82.5,NULL,45,1,'Europe/Rome',82.5,1,'work','2021-09-10 15:23:17','2021-07-06'),
(236,1,1,41,'2021-07-06 08:16:00','2021-07-06 09:07:00',3060,'problemi server dhcp',38.25,NULL,45,1,'Europe/Rome',38.25,1,'work','2021-09-15 16:23:13','2021-07-06'),
(237,3,1,41,'2021-07-06 07:15:00','2021-07-06 07:25:00',600,'Assistenza su pc client Luana per problemi stampante',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-16 14:21:12','2021-07-06'),
(238,3,1,1,'2021-07-06 07:40:00','2021-07-06 08:00:00',1200,'Assistenza su pc client Andrea e Roberta per scaricamento posta elettronica',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-21 10:47:04','2021-07-06'),
(239,3,1,41,'2021-07-06 08:15:00','2021-07-06 08:45:00',1800,'Assistenza su pc client Franca per problemi con indirizzo ip',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-15 16:23:06','2021-07-06'),
(240,3,2,41,'2021-07-06 12:30:00','2021-07-06 13:10:00',2400,'Assistenza su pc client Simona \r\nVerifica stampante Epson WF-4730\r\nOffrire nuova stampante',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-16 14:21:12','2021-07-06'),
(241,3,2,32,'2021-07-06 13:15:00','2021-07-06 13:25:00',600,'Ritirato pc client Daniela per assistenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-22 09:50:09','2021-07-06'),
(242,3,1,41,'2021-07-06 13:35:00','2021-07-06 13:45:00',600,'Assistenza su pc client Fucilli per problemi con stampanti',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-16 14:21:13','2021-07-06'),
(243,1,1,58,'2021-07-07 07:21:00','2021-07-07 10:00:00',9540,'Intervento carcere per meeting',119.25,NULL,45,1,'Europe/Rome',119.25,1,'work','2021-07-07 13:51:14','2021-07-07'),
(244,1,1,58,'2021-07-07 12:40:00','2021-07-07 13:18:00',2280,'Spiegazione su come avviare meeting',28.5,NULL,45,1,'Europe/Rome',28.5,1,'work','2021-07-07 13:51:16','2021-07-07'),
(245,1,1,50,'2021-07-07 10:23:00','2021-07-07 10:45:00',1320,'problemi configurazione https proxy su server win',16.5,NULL,45,1,'Europe/Rome',16.5,1,'work','2021-09-10 15:23:20','2021-07-07'),
(246,1,3,112,'2021-07-08 09:08:00','2021-07-08 10:21:18',4398,NULL,54.98,NULL,45,1,'Europe/Rome',54.98,1,'work','2021-09-22 09:44:25','2021-07-08'),
(247,1,1,4,'2021-07-08 06:44:00','2021-07-08 09:00:00',8160,'problemi danea',102,NULL,45,1,'Europe/Rome',102,1,'work','2021-09-14 09:22:50','2021-07-08'),
(248,1,1,4,'2021-07-08 10:25:00','2021-07-08 11:32:00',4020,'problemi danea',50.25,NULL,45,1,'Europe/Rome',50.25,1,'work','2021-09-14 09:22:52','2021-07-08'),
(249,1,1,4,'2021-07-08 12:20:00','2021-07-08 12:33:00',780,'problemi danea',9.75,NULL,45,1,'Europe/Rome',9.75,1,'work','2021-09-14 09:22:53','2021-07-08'),
(250,1,6,90,'2021-07-08 12:42:00','2021-07-08 13:12:00',1800,'problema saltata corrente riaccensione server',22.5,NULL,45,1,'Europe/Rome',22.5,1,'work','2021-09-23 16:13:22','2021-07-08'),
(251,1,1,50,'2021-07-07 13:33:00','2021-07-07 14:30:00',3420,'problema apache proxy',42.75,NULL,45,1,'Europe/Rome',42.75,1,'work','2021-09-10 15:23:21','2021-07-07'),
(252,1,2,3,'2021-07-07 14:35:00','2021-07-07 17:00:00',8700,'da first alla festa',108.75,NULL,45,1,'Europe/Rome',108.75,1,'work','2021-09-10 15:25:24','2021-07-07'),
(253,1,1,88,'2021-07-08 13:41:00','2021-07-08 13:54:43',823,'problema accesso share vpn',10.29,NULL,45,1,'Europe/Rome',10.29,1,'work','2021-10-29 16:35:14','2021-07-08'),
(254,1,1,55,'2021-07-08 14:47:00','2021-07-08 15:25:00',2280,'problema coedit',28.5,NULL,45,1,'Europe/Rome',28.5,1,'work','2021-09-22 15:31:14','2021-07-08'),
(255,1,1,4,'2021-07-08 15:40:00','2021-07-08 16:20:00',2400,'deframmentazione vm',30,NULL,45,1,'Europe/Rome',30,1,'work','2021-09-14 09:22:55','2021-07-08'),
(256,3,2,41,'2021-07-07 08:20:00','2021-07-07 09:40:00',4800,'Assistenza per problemi collegamento a wintolip e chiamate interne\r\nVerificato armadio rack',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-16 14:21:14','2021-07-07'),
(257,3,1,1,'2021-07-07 06:55:00','2021-07-07 08:05:00',4200,'Assistenza su pc client Roberta e Andrea per problema scaricamento mail',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-21 10:47:05','2021-07-07'),
(258,3,4,32,'2021-07-07 12:30:00','2021-07-07 13:30:00',3600,'Assistenza su pc client Daniela, lo riportano per upgrade sistema operativo dopo 16/07',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-22 10:18:27','2021-07-07'),
(259,3,1,41,'2021-07-07 13:35:00','2021-07-07 14:15:00',2400,'Assistenza su pc client Fucilli per recupero file cancellato',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-16 14:21:15','2021-07-07'),
(260,3,1,1,'2021-07-07 14:15:00','2021-07-07 14:30:00',900,'Assistenza su pc client Fabrizio per problemi collegamento ad un sito',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-21 10:47:06','2021-07-07'),
(261,3,2,32,'2021-07-07 14:45:00','2021-07-07 14:55:00',600,'Assistenza su pc client Daniela per problemi accensione monitor',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-22 10:18:28','2021-07-07'),
(262,3,1,88,'2021-07-07 15:00:00','2021-07-07 16:00:00',3600,'Installata vpn su vecchio pc Piazza, lavoro da finire',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-05 11:21:28','2021-07-07'),
(263,3,4,43,'2021-07-07 16:00:00','2021-07-07 17:00:00',3600,'Reinstallata sistema operativo su vecchio pc client Luca',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-15 15:57:10','2021-07-07'),
(264,3,2,56,'2021-07-08 08:30:00','2021-07-08 09:40:00',4200,'Verificato e ritirato pc client per assistenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-23 15:36:31','2021-07-08'),
(265,3,2,90,'2021-07-08 13:30:00','2021-07-08 14:10:00',2400,'Verificato e sostituito ups con APC 1400, riavviato server e firewall e verificato funzionamento servizi',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-23 16:13:23','2021-07-08'),
(266,3,4,56,'2021-07-08 15:00:00','2021-07-08 16:00:00',3600,'Aggiornamento hardware e software su pc client ritirato\r\nUtilizzato: MB Asus Prime H510M-A, 8gb ddr4, cpu intel i3 e sk video 1gb',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-23 15:36:28','2021-07-08'),
(267,1,1,58,'2021-07-09 09:51:00','2021-07-09 10:04:00',780,'caricamento dati su mysql',9.75,NULL,45,1,'Europe/Rome',9.75,1,'work','2021-09-24 15:32:59','2021-07-09'),
(268,1,3,112,'2021-07-09 07:15:00','2021-07-09 08:15:00',3600,NULL,45,NULL,45,1,'Europe/Rome',45,1,'work','2021-09-22 09:44:26','2021-07-09'),
(269,1,1,3,'2021-07-09 06:33:00','2021-07-09 07:10:00',2220,'riportato tel a fede e verificato pc imp che non si aggiorna a 10',27.75,NULL,45,1,'Europe/Rome',27.75,1,'work','2021-09-10 15:25:24','2021-07-09'),
(270,1,1,32,'2021-07-09 12:38:00','2021-07-09 13:27:29',2969,'Problemi servizio rdp sparito da pc daniela',37.11,NULL,45,1,'Europe/Rome',37.11,1,'work','2021-09-22 10:18:30','2021-07-09'),
(271,1,4,56,'2021-07-09 13:28:00','2021-07-09 14:19:00',3060,'problema pc in lab',38.25,NULL,45,1,'Europe/Rome',38.25,1,'work','2021-09-23 15:37:03','2021-07-09'),
(272,1,1,4,'2021-07-09 14:24:00','2021-07-09 17:16:00',10320,'migrazione vm su ssd',129,NULL,45,1,'Europe/Rome',129,1,'work','2021-09-14 09:22:59','2021-07-09'),
(273,3,2,41,'2021-07-09 07:35:00','2021-07-09 08:35:00',3600,'Verifica problemi di rete su pc client Franca\r\nIdentificato e scollegato possibile dispositivo DHCP\r\nAssistenza su pc client Paola',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-15 16:23:28','2021-07-09'),
(274,3,2,32,'2021-07-09 08:45:00','2021-07-09 10:45:00',7200,'Assistenza su pc client Daniela per problemi collegamento remoto, installato momentaneamente Anydesk',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-22 10:18:29','2021-07-09'),
(275,3,2,4,'2021-07-09 13:45:00','2021-07-09 14:15:00',1800,'Consegna e installazione 2 ssd Samsung da 512gb',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-14 09:22:57','2021-07-09'),
(276,3,1,79,'2021-07-09 12:40:00','2021-07-09 12:50:00',600,'Installata 1 licenza nod32 aggiornamento su pc client Andrea',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-23 13:51:30','2021-07-09'),
(277,1,1,58,'2021-07-12 09:13:00','2021-07-12 10:16:00',3780,'problemi avvio meeting in carcere',47.25,NULL,45,1,'Europe/Rome',47.25,1,'work','2021-09-24 15:33:00','2021-07-12'),
(278,1,1,41,'2021-07-12 06:50:00','2021-07-12 08:50:00',7200,'problemi dhcp via secca \r\nproblemi di rete via vaghner',90,NULL,45,1,'Europe/Rome',90,1,'work','2021-09-16 14:21:16','2021-07-12'),
(279,1,3,112,'2021-07-12 06:30:00','2021-07-12 06:48:00',1080,NULL,13.5,NULL,45,1,'Europe/Rome',13.5,1,'work','2021-09-22 09:44:27','2021-07-12'),
(280,1,1,41,'2021-07-12 10:17:00','2021-07-12 10:54:00',2220,'problemi disconnessione rdp su server windows via vaghner, segnalano che video collegato al server non funziona',27.75,NULL,45,1,'Europe/Rome',27.75,1,'work','2021-09-16 14:21:18','2021-07-12'),
(281,1,1,4,'2021-07-09 20:11:00','2021-07-09 21:40:00',5340,'installazione vm windows server 2019',66.75,NULL,45,1,'Europe/Rome',66.75,1,'work','2021-09-14 09:22:59','2021-07-09'),
(282,1,1,4,'2021-07-09 08:20:00','2021-07-09 09:33:00',4380,'problemi su vm danea',54.75,NULL,45,1,'Europe/Rome',54.75,1,'work','2021-09-14 09:22:56','2021-07-09'),
(283,1,1,2,'2021-07-12 12:43:00','2021-07-12 15:10:00',8820,'problemi accesso share pc nicolò (permessi non corretti 99 su 100 fede quando ha messo il nuovo client li ha sbagliati)\r\nproblemi di lentezza client laura fatta pulizia e appurato che ha bisogno di altri 4 gb di ram',110.25,NULL,45,1,'Europe/Rome',110.25,1,'work','2021-11-17 14:38:05','2021-07-12'),
(284,3,2,41,'2021-07-12 08:00:00','2021-07-12 08:30:00',1800,'Assistenza per problemi sulla rete nella Sede di via Wagner',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-16 14:21:17','2021-07-12'),
(285,3,2,103,'2021-07-12 10:40:00','2021-07-12 11:10:00',1800,'Riconsegnato firewall dopo sostituzione alimentatore 700 W\r\nSostituzione HHD sistema con WD Red Pro da 2 tb\r\nSostituzione HHD backup con Seagate da 2 tb',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-23 15:03:38','2021-07-12'),
(286,3,4,56,'2021-07-12 13:55:00','2021-07-12 14:15:00',1200,'Riconsegnato pc client dopo assistenza e verificato app\r\nDa aggiungere in fattura sk di rete gigabit',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-23 15:37:01','2021-07-12'),
(287,3,2,73,'2021-07-12 15:40:00','2021-07-12 15:50:00',600,'Installata 1 licenza nod32 aggiornamento su 2 pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-10-29 16:45:59','2021-07-12'),
(288,3,1,10,'2021-07-12 06:45:00','2021-07-12 07:00:00',900,'Assistenza per problema linea dati',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-10-08 14:53:53','2021-07-12'),
(289,3,1,41,'2021-07-12 07:05:00','2021-07-12 07:15:00',600,'Assistenza su pc client Franca per problemi su indirizzo IP',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-15 16:23:49','2021-07-12'),
(290,3,2,104,'2021-07-12 07:15:00','2021-07-12 07:40:00',1500,'Assistenza per problemi collegamento in rdp al gestionale',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-22 14:47:13','2021-07-12'),
(291,3,1,50,'2021-07-12 09:25:00','2021-07-12 09:35:00',600,'Assistenza su pc client Loretta per problemi posta',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-07-14 08:57:53','2021-07-12'),
(292,3,1,50,'2021-07-12 15:10:00','2021-07-12 15:25:00',900,'Assistenza per recupero cartella su Condivisi',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-07-14 08:57:56','2021-07-12'),
(293,1,3,112,'2021-07-13 06:30:00','2021-07-13 06:40:00',600,NULL,7.5,NULL,45,1,'Europe/Rome',7.5,1,'work','2021-09-22 09:44:28','2021-07-13'),
(294,1,1,95,'2021-07-13 06:45:00','2021-07-13 07:24:00',2340,'problemi login anna',29.25,NULL,45,1,'Europe/Rome',29.25,1,'work','2021-09-21 15:29:18','2021-07-13'),
(295,1,1,90,'2021-07-13 07:30:00','2021-07-13 08:00:00',1800,'problemi certificati ssl',22.5,NULL,45,1,'Europe/Rome',22.5,1,'work','2021-09-23 15:52:10','2021-07-13'),
(296,1,1,95,'2021-07-13 08:02:53','2021-07-13 08:22:21',1168,'problemi login anna',14.6,NULL,45,1,'Europe/Rome',14.6,1,'work','2021-09-21 15:29:19','2021-07-13'),
(297,1,1,4,'2021-07-12 15:20:00','2021-07-12 16:29:00',4140,'aggiornamento nuova vm',51.75,NULL,45,1,'Europe/Rome',51.75,1,'work','2021-09-14 09:23:00','2021-07-12'),
(298,1,1,4,'2021-07-13 08:31:00','2021-07-13 10:30:00',7140,'Spostamento easyfat da vecchia vm a nuova windows server 2019, configurati backup e client.',89.25,NULL,45,1,'Europe/Rome',89.25,1,'work','2021-09-14 09:23:02','2021-07-13'),
(299,1,1,2,'2021-07-13 15:43:00','2021-07-13 16:13:59',1859,'Installazione office su pc di nicolo\r\n\r\n1 office 2019 standard',23.24,NULL,45,1,'Europe/Rome',23.24,1,'work','2021-11-17 14:38:06','2021-07-13'),
(300,1,1,4,'2021-07-13 12:40:00','2021-07-13 13:25:00',2700,'Spostamento easyfat da vecchia vm a nuova windows server 2019, configurati backup e client.',33.75,NULL,45,1,'Europe/Rome',33.75,1,'work','2021-09-14 09:23:03','2021-07-13'),
(301,1,1,50,'2021-07-13 13:41:00','2021-07-13 15:28:00',6420,'software gestionale su windowss',80.25,NULL,45,1,'Europe/Rome',80.25,1,'work','2021-09-10 15:23:23','2021-07-13'),
(302,3,2,6,'2021-07-13 09:25:00','2021-07-13 10:45:00',4800,'Assistenza e verifiche su pc client Amministrazione\r\nValutare upgrade hw in futuro',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-13 16:47:19','2021-07-13'),
(303,3,2,50,'2021-07-13 12:15:00','2021-07-13 12:45:00',1800,'Consegna toner\r\nAssistenza su pc client Loretta',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-07-14 08:57:58','2021-07-13'),
(304,3,2,43,'2021-07-13 06:40:00','2021-07-13 06:50:00',600,'Riconsegnato vecchio pc client Luca dopo reinstallazione',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-15 15:57:11','2021-07-13'),
(305,3,1,10,'2021-07-13 07:55:00','2021-07-13 08:05:00',600,'Assistenza Francesca per problemi Zoom',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-10-08 14:53:53','2021-07-13'),
(306,3,1,50,'2021-07-13 13:45:00','2021-07-13 14:00:00',900,'Configurata mail su nuovo PC Pierluigi Ferrari',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-07-14 08:58:18','2021-07-13'),
(307,3,1,97,'2021-07-13 14:05:00','2021-07-13 14:25:00',1200,'Assistenza per problemi su posta elettronica',0,NULL,0,0,'Europe/Rome',0,1,'work','2021-07-13 16:51:55','2021-07-13'),
(308,1,1,55,'2021-07-14 14:31:00','2021-07-14 15:34:14',3794,'configurazione backup remoto amico win',47.43,NULL,45,1,'Europe/Rome',47.43,1,'work','2021-09-03 13:11:15','2021-07-14'),
(309,1,4,3,'2021-07-14 12:30:00','2021-07-14 14:11:00',6060,'vari per backup',75.75,NULL,45,1,'Europe/Rome',75.75,1,'work','2021-09-10 15:25:28','2021-07-14'),
(310,1,3,112,'2021-07-14 09:45:00','2021-07-14 10:30:00',2700,NULL,33.75,NULL,45,1,'Europe/Rome',33.75,1,'work','2021-09-22 09:44:30','2021-07-14'),
(311,1,3,112,'2021-07-14 06:30:00','2021-07-14 06:45:00',900,NULL,11.25,NULL,45,1,'Europe/Rome',11.25,1,'work','2021-09-22 09:44:29','2021-07-14'),
(312,1,1,50,'2021-07-14 06:54:00','2021-07-14 07:49:00',3300,'per certificati',41.25,NULL,45,1,'Europe/Rome',41.25,1,'work','2021-09-10 15:23:24','2021-07-14'),
(313,1,1,29,'2021-07-14 15:35:00','2021-07-14 17:03:00',5280,'backup remoto',66,NULL,45,1,'Europe/Rome',66,1,'work','2021-09-27 13:37:58','2021-07-14'),
(314,3,2,26,'2021-07-14 08:15:00','2021-07-14 10:15:00',7200,'Montanto e configurato nuovo server, verificato funzionamento tutti i servizi \r\nMontato nuovo switch 24 porte gigabit',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-10-25 15:49:55','2021-07-14'),
(315,3,2,67,'2021-07-14 12:30:00','2021-07-14 12:40:00',600,'Riconsegnato disco danneggiato pc client Sabrina',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-27 10:20:59','2021-07-14'),
(316,3,2,26,'2021-07-14 12:50:00','2021-07-14 15:30:00',9600,'Passaggi dati e configurazione da vecchio Ipad a nuovo ipad dott. Sola\r\nAssistenza su pc client Sola\r\nAssistenza su pc client Banci\r\nAssistenza su pc client Simona',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-10-31 11:40:31','2021-07-14'),
(317,1,4,3,'2021-07-14 07:50:00','2021-07-14 09:40:00',6600,'vari per backup',82.5,NULL,45,1,'Europe/Rome',82.5,1,'work','2021-09-10 15:25:25','2021-07-14'),
(318,1,1,50,'2021-07-15 09:00:00','2021-07-15 10:40:00',6000,'problemi certificati e prozy ssl su server windows',75,NULL,45,1,'Europe/Rome',75,1,'work','2021-09-10 15:23:25','2021-07-15'),
(319,1,1,50,'2021-07-15 12:46:00','2021-07-15 13:51:00',3900,'problemi certificati e prozy ssl su server windows',48.75,NULL,45,1,'Europe/Rome',48.75,1,'work','2021-09-10 15:23:26','2021-07-15'),
(320,1,1,50,'2021-07-15 15:39:00','2021-07-15 16:39:00',3600,'problemi certificati e prozy ssl su server windows',45,NULL,45,1,'Europe/Rome',45,1,'work','2021-09-10 15:23:27','2021-07-15'),
(321,1,1,3,'2021-07-15 06:43:00','2021-07-15 08:48:00',7500,'backup remoti',93.75,NULL,45,1,'Europe/Rome',93.75,1,'work','2021-09-10 15:25:29','2021-07-15'),
(322,1,1,5,'2021-07-15 14:01:00','2021-07-15 15:31:00',5400,'backup remoto problema',67.5,NULL,45,1,'Europe/Rome',67.5,1,'work','2021-10-21 09:01:11','2021-07-15'),
(323,1,1,88,'2021-07-16 07:42:00','2021-07-16 08:27:52',2752,'problema di ricezione mail interna',34.4,NULL,45,1,'Europe/Rome',34.4,1,'work','2021-11-05 09:08:52','2021-07-16'),
(324,1,1,90,'2021-07-16 08:54:00','2021-07-16 09:01:47',467,'problema giotto',5.84,NULL,45,1,'Europe/Rome',5.84,1,'work','2021-09-23 16:13:24','2021-07-16'),
(325,1,1,2,'2021-07-16 14:50:00','2021-07-16 17:00:00',7800,'Creazione nuovo utente per laura per sostituire utente cinzia',97.5,NULL,45,1,'Europe/Rome',97.5,1,'work','2021-11-17 14:38:08','2021-07-16'),
(326,3,2,79,'2021-07-15 08:30:00','2021-07-15 14:15:00',20700,'Assistenza su pc client Andrea\r\nConsegnato e configurato nuovo pc client Paolo\r\nRitirato vecchio pc client Paolo per reinstallazione',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-23 13:51:31','2021-07-15'),
(327,3,1,96,'2021-07-15 15:15:00','2021-07-15 15:30:00',900,'Assistenza su pc utilizzato per video conferenze, da verificare in loco',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-01 15:32:05','2021-07-15'),
(328,3,2,7,'2021-07-15 18:00:00','2021-07-15 20:30:00',9000,'Consegna e installazione nuovo server Venus1\r\nRitirato server Saturno2',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-17 14:52:59','2021-07-15'),
(329,3,2,2,'2021-07-16 07:30:00','2021-07-16 08:10:00',2400,'Consegnata e montata ram DDR3 su pc client Laura \r\nAssistenza su pc cliet Laura',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-17 14:38:06','2021-07-16'),
(330,3,2,76,'2021-07-16 09:10:00','2021-07-16 11:10:00',7200,'Consegnato e configurato nuovo portatile Acer',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-15 16:04:02','2021-07-16'),
(331,3,4,76,'2021-07-16 12:45:00','2021-07-16 13:00:00',900,'Scaricato e testato software gestionale',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-15 16:07:13','2021-07-16'),
(332,3,1,79,'2021-07-16 13:00:00','2021-07-16 13:20:00',1200,'Assistenza su pc client Paolo per recupero configurazione Skype',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-23 13:51:33','2021-07-16'),
(333,3,1,26,'2021-07-16 13:25:00','2021-07-16 13:35:00',600,'Assistenza per verifica funzionamento portatili dopo cambio server',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-10-31 11:40:32','2021-07-16'),
(334,1,1,3,'2021-07-19 14:18:00','2021-07-19 15:33:00',4500,'portatile privato con problemi hdmi',56.25,NULL,45,1,'Europe/Rome',56.25,1,'work','2021-09-10 15:25:33','2021-07-19'),
(335,1,1,41,'2021-07-19 15:40:00','2021-07-19 16:50:00',4200,'fede li per montare dischi e controller seguito via tel e configurazione raid e riconfigurazione backup',52.5,NULL,45,1,'Europe/Rome',52.5,1,'work','2021-09-16 14:21:20','2021-07-19'),
(336,1,3,112,'2021-07-20 06:30:00','2021-07-20 07:58:00',5280,NULL,66,NULL,45,1,'Europe/Rome',66,1,'work','2021-09-22 09:44:31','2021-07-20'),
(337,1,1,2,'2021-07-19 06:42:00','2021-07-19 08:41:00',7140,'manutenzione per nuovi utenti',89.25,NULL,45,1,'Europe/Rome',89.25,1,'work','2021-11-17 14:38:08','2021-07-19'),
(338,1,1,29,'2021-07-19 08:52:00','2021-07-19 10:23:00',5460,'studio per copia programmata remota',68.25,NULL,45,1,'Europe/Rome',68.25,1,'work','2021-09-27 13:43:24','2021-07-19'),
(339,3,2,32,'2021-07-19 06:40:00','2021-07-19 06:50:00',600,'Ritirato pc client Daniela per agg sistema operativo',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-22 09:50:06','2021-07-19'),
(340,3,2,24,'2021-07-19 09:25:00','2021-07-19 09:35:00',600,'Consegna cartuccia Epson',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-22 08:17:04','2021-07-19'),
(341,3,2,76,'2021-07-19 09:55:00','2021-07-19 10:15:00',1200,'Consegna e installazione software EasyCad',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-15 16:07:14','2021-07-19'),
(342,3,2,41,'2021-07-19 14:55:00','2021-07-19 16:35:00',6000,'Consegna e installazione nuova stampante Epson WF 4830\r\nSostituzione batteria su UPS APC 700\r\nConsegna e installazione 2 dischi da 4tb su server HP',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-16 14:21:19','2021-07-19'),
(343,3,4,32,'2021-07-19 12:30:00','2021-07-19 14:00:00',5400,'Reinstallazione e configurazione PC client Daniela\r\nUtilizzato: 4gb ram DDR3',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-22 10:18:31','2021-07-19'),
(344,3,2,96,'2021-07-19 08:50:00','2021-07-19 09:05:00',900,'Assistenza su pc client Antonella per problemi posta in uscita',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-01 15:32:06','2021-07-19'),
(345,3,2,32,'2021-07-20 13:00:00','2021-07-20 15:00:00',7200,'Riconsegnato e configurato pc client Daniela dopo aggiornamento s.o, da finire installazione eBridge',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-22 10:18:31','2021-07-20'),
(346,3,1,55,'2021-07-20 07:00:00','2021-07-20 07:40:00',2400,'Assistenza su pc client Otto per problemi lentezza pc',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-22 15:31:14','2021-07-20'),
(347,3,1,24,'2021-07-20 07:40:00','2021-07-20 07:50:00',600,'Assistenza per problemi posta elettronica',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-22 09:31:55','2021-07-20'),
(348,3,1,104,'2021-07-20 09:00:00','2021-07-20 09:25:00',1500,'Creata e configurata nuova mail',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-22 14:47:13','2021-07-20'),
(349,3,1,50,'2021-07-20 09:50:00','2021-07-20 10:10:00',1200,'Assistenza su Mac Elisabetta per problemi lentezza',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-07-28 09:02:29','2021-07-20'),
(350,1,4,3,'2021-07-21 06:38:00','2021-07-21 07:12:00',2040,'riportato pc portatile privata',25.5,NULL,45,1,'Europe/Rome',25.5,1,'work','2021-09-10 15:25:40','2021-07-21'),
(351,1,1,2,'2021-07-21 07:31:00','2021-07-21 08:31:00',3600,'pc laura guasto, riconfigurato pc mauro con profilo laura per permettergli di lavorare nel mentre',45,NULL,45,1,'Europe/Rome',45,1,'work','2021-11-17 14:38:09','2021-07-21'),
(352,1,1,3,'2021-07-20 13:32:00','2021-07-20 14:50:00',4680,'portatiel privata',58.5,NULL,45,1,'Europe/Rome',58.5,1,'work','2021-09-10 15:25:32','2021-07-20'),
(353,1,3,112,'2021-07-20 12:30:00','2021-07-20 13:30:00',3600,NULL,45,NULL,45,1,'Europe/Rome',45,1,'work','2021-09-22 09:44:32','2021-07-20'),
(354,1,1,50,'2021-07-20 14:56:00','2021-07-20 16:30:00',5640,'problema certificati ssl',70.5,NULL,45,1,'Europe/Rome',70.5,1,'work','2021-09-10 15:23:29','2021-07-20'),
(355,1,1,50,'2021-07-20 08:11:00','2021-07-20 10:30:00',8340,'problema certificati ssl',104.25,NULL,45,1,'Europe/Rome',104.25,1,'work','2021-09-10 15:23:28','2021-07-20'),
(356,1,1,95,'2021-07-21 08:34:00','2021-07-21 09:13:00',2340,'problemi posta porcile',29.25,NULL,45,1,'Europe/Rome',29.25,1,'work','2021-09-21 15:29:20','2021-07-21'),
(357,1,1,2,'2021-07-21 09:24:00','2021-07-21 10:30:00',3960,'pc laura guasto, riconfigurato pc mauro con profilo laura per permettergli di lavorare nel mentre problema risoluzione monitor',49.5,NULL,45,1,'Europe/Rome',49.5,1,'work','2021-11-17 14:38:10','2021-07-21'),
(358,1,1,95,'2021-07-21 12:35:00','2021-07-21 14:40:00',7500,'problemi posta porcile',93.75,NULL,45,1,'Europe/Rome',93.75,1,'work','2021-09-21 15:29:21','2021-07-21'),
(359,1,1,50,'2021-07-21 14:50:00','2021-07-21 16:56:54',7614,'problema ssl su sito',95.18,NULL,45,1,'Europe/Rome',95.18,1,'work','2021-09-10 15:23:30','2021-07-21'),
(360,1,1,81,'2021-07-22 07:20:00','2021-07-22 07:31:36',696,'agg software certificati',8.7,NULL,45,1,'Europe/Rome',8.7,1,'work','2021-09-10 09:15:13','2021-07-22'),
(361,1,1,79,'2021-07-22 06:45:00','2021-07-22 07:13:00',1680,'problemi ssl e aggiornamento server di posta configurato restart problemi dopo update da parte di alex',21,NULL,45,1,'Europe/Rome',21,1,'work','2021-09-23 10:00:59','2021-07-22'),
(362,1,1,79,'2021-07-22 07:40:00','2021-07-22 08:40:00',3600,'problemi ssl e aggiornamento server di posta configurato restart problemi dopo update da parte di alex',45,NULL,45,1,'Europe/Rome',45,1,'work','2021-09-23 10:01:01','2021-07-22'),
(363,1,1,52,'2021-07-22 08:50:00','2021-07-22 09:05:00',900,'backup centralino e caricamento su wiki',11.25,NULL,45,1,'Europe/Rome',11.25,1,'work','2021-09-23 16:14:39','2021-07-22'),
(364,3,2,32,'2021-07-21 09:30:00','2021-07-21 11:00:00',5400,'Installazione eBridge con assistenza Buffetti, l\'installazione verrà completata da loro domattina',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-22 10:18:32','2021-07-21'),
(365,3,2,96,'2021-07-21 13:30:00','2021-07-21 14:15:00',2700,'Assistenza su postazione videoconferenza, sostituzione webcam',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-01 15:32:07','2021-07-21'),
(366,3,2,91,'2021-07-21 14:30:00','2021-07-21 15:30:00',3600,'Sostituzione dissipatore su pc client Elisa\r\nVerificata configurazione rete per cambio router\r\nUtilizzato: dissipatore cm h412r',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-17 15:04:26','2021-07-21'),
(367,3,1,95,'2021-07-21 06:40:00','2021-07-21 07:00:00',1200,'Riavviata vm e server Linux per problema collegamento agli share',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-14 09:23:33','2021-07-21'),
(368,3,2,95,'2021-07-21 07:35:00','2021-07-21 08:35:00',3600,'Assistenza su pc client Porcile per problemi su posta, lavoro finito da Claudio',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-21 15:29:19','2021-07-21'),
(369,3,2,81,'2021-07-21 08:50:00','2021-07-21 09:20:00',1800,'Assistenza su pc client per problemi lentezza, pc da ritirare',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-10 09:14:52','2021-07-21'),
(370,3,2,91,'2021-07-22 09:10:00','2021-07-22 10:00:00',3000,'Riconfigurazione firewall dopo passaggio da telecom a fastweb, la linea fastweb non è ancora attiva',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-17 15:04:26','2021-07-22'),
(371,3,2,6,'2021-07-22 10:15:00','2021-07-22 12:00:00',6300,'Assistenza su pc client Presidenza per problemi di lentezza, da proporre upgrade hw a Settembre\r\nAssistenza su portatile Presidenza per problemi con software Audacity',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-13 16:47:20','2021-07-22'),
(372,3,1,79,'2021-07-22 07:00:00','2021-07-22 07:20:00',1200,'Assistenza su pc client Andrea per problema salvataggio posta inviata',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-23 13:51:33','2021-07-22'),
(373,3,1,79,'2021-07-22 13:00:00','2021-07-22 13:40:00',2400,'Assistenza su pc client Paolo per problemi con stampanti',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-23 13:51:35','2021-07-22'),
(374,3,1,41,'2021-07-22 14:40:00','2021-07-22 14:55:00',900,'Assistenza per problemi collegamento al gestionale rifiuti',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-16 14:21:21','2021-07-22'),
(375,1,3,112,'2021-07-23 06:30:00','2021-07-23 08:00:00',5400,NULL,67.5,NULL,45,1,'Europe/Rome',67.5,1,'work','2021-09-22 09:44:32','2021-07-23'),
(376,1,2,81,'2021-07-23 08:26:00','2021-07-23 09:30:00',3840,'sopraluogo nuovo ufficio e ritiro pc guasto',48,NULL,45,1,'Europe/Rome',48,1,'work','2021-09-10 09:14:47','2021-07-23'),
(377,1,2,2,'2021-07-23 09:58:00','2021-07-23 10:48:00',3000,'Consegna pc nuovo laura\r\n1 pc',37.5,NULL,45,1,'Europe/Rome',37.5,1,'work','2021-11-17 14:38:12','2021-07-23'),
(378,1,1,2,'2021-07-23 12:52:00','2021-07-23 15:27:00',9300,'Configurazione pc laura nuovo',116.25,NULL,45,1,'Europe/Rome',116.25,1,'work','2021-11-17 14:38:14','2021-07-23'),
(379,1,3,112,'2021-07-23 12:30:00','2021-07-23 12:45:00',900,NULL,11.25,NULL,45,1,'Europe/Rome',11.25,1,'work','2021-09-22 09:44:33','2021-07-23'),
(380,1,1,51,'2021-07-23 16:08:00','2021-07-23 16:10:59',179,'problema pc casa burdese',2.24,NULL,45,1,'Europe/Rome',2.24,1,'work','2021-09-16 14:42:24','2021-07-23'),
(381,1,1,108,'2021-07-26 06:48:00','2021-07-26 08:23:00',5700,'riconfigurazione email su server',71.25,NULL,45,1,'Europe/Rome',71.25,1,'work','2021-11-17 08:10:00','2021-07-26'),
(382,1,1,41,'2021-07-26 08:31:00','2021-07-26 09:20:07',2947,'spostamento share e cartelle',36.84,NULL,45,1,'Europe/Rome',36.84,1,'work','2021-09-16 14:21:23','2021-07-26'),
(383,1,1,103,'2021-07-26 09:21:00','2021-07-26 10:11:30',3030,'problema ora server sballata',37.88,NULL,45,1,'Europe/Rome',37.88,1,'work','2021-09-23 15:10:56','2021-07-26'),
(384,1,1,22,'2021-07-26 14:11:00','2021-07-26 14:41:58',1858,'configurazione thunderbird su pc sig. boccaleri',23.23,NULL,45,1,'Europe/Rome',23.23,1,'work','2021-10-22 07:34:19','2021-07-26'),
(385,1,1,55,'2021-07-26 14:42:00','2021-07-26 16:40:26',7106,'problema rinnovo certificati ssl',88.83,NULL,45,1,'Europe/Rome',88.83,1,'work','2021-09-22 15:31:13','2021-07-26'),
(386,3,2,41,'2021-07-23 09:55:00','2021-07-23 10:40:00',2700,'Assistenza su pc client Luana\r\nAssistenza su pc client Franca',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-16 14:21:22','2021-07-23'),
(387,3,2,12,'2021-07-23 12:55:00','2021-07-23 13:35:00',2400,'Verificato e ritirato server che non si avvia',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-10-01 15:25:14','2021-07-23'),
(388,3,2,12,'2021-07-23 16:00:00','2021-07-23 16:30:00',1800,'Riconsegnato server linux dopo sostituzione mainboard e dissipatore',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-10-01 15:25:15','2021-07-23'),
(389,3,1,32,'2021-07-23 08:10:00','2021-07-23 08:40:00',1800,'Assistenza per installazione software eBridge insieme a Buffetti',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-22 10:18:33','2021-07-23'),
(390,3,2,104,'2021-07-26 14:20:00','2021-07-26 14:40:00',1200,'Consegna toner compatibili\r\nAssistenza su iphone Daniele per problema telecamere',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-22 14:47:14','2021-07-26'),
(391,3,1,91,'2021-07-26 07:15:00','2021-07-26 07:30:00',900,'Verifica funzionamento linea Fastweb \r\nModifica configurazione dominio arnera.lkj.it',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-17 15:04:28','2021-07-26'),
(392,3,1,101,'2021-07-26 07:35:00','2021-07-26 08:05:00',1800,'Assistenza su pc client Mina per problemi posta\r\nAssistenza per configurazione mail su nuovo cellulare Vigo',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-10-22 09:21:55','2021-07-26'),
(393,3,1,79,'2021-07-26 13:15:00','2021-07-26 13:25:00',600,'Assistenza a Matteo per disdetta vecchie SIM',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-23 10:15:03','2021-07-26'),
(394,3,4,81,'2021-07-26 08:30:00','2021-07-26 09:30:00',3600,'Assistenza su pc client ritirato \r\nUtilizzato: 8gb DDR3 1600',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-10 09:14:47','2021-07-26'),
(395,3,4,62,'2021-07-26 15:30:00','2021-07-26 16:30:00',3600,'Assistenza su mini pc Baruffi per reinstallazione s.o\r\nUtilizzato: S3+ da 240gb',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-17 15:09:51','2021-07-26'),
(396,1,1,108,'2021-07-27 07:22:00','2021-07-27 07:32:32',632,'problemi posta barbara',7.9,NULL,45,1,'Europe/Rome',7.9,1,'work','2022-02-22 10:20:20','2021-07-27'),
(397,1,1,22,'2021-07-27 15:24:00','2021-07-27 15:32:44',524,'problema invio mail da danea',6.55,NULL,45,1,'Europe/Rome',6.55,1,'work','2021-09-10 15:17:43','2021-07-27'),
(398,1,4,3,'2021-07-27 12:30:00','2021-07-27 13:00:00',1800,'ritiro rasp in lab',22.5,NULL,45,1,'Europe/Rome',22.5,1,'work','2021-09-10 15:25:41','2021-07-27'),
(399,1,1,113,'2021-07-27 13:15:00','2021-07-27 14:00:00',2700,'configurazione rasp e install raspbian',33.75,NULL,45,1,'Europe/Rome',33.75,1,'work','2021-10-22 10:09:01','2021-07-27'),
(400,1,1,4,'2021-07-27 06:42:00','2021-07-27 07:14:00',1920,'controllo vm',24,NULL,45,1,'Europe/Rome',24,1,'work','2021-09-14 09:23:05','2021-07-27'),
(401,1,1,24,'2021-07-27 07:36:00','2021-07-27 08:00:00',1440,'verifica ban list manuale',18,NULL,45,1,'Europe/Rome',18,1,'work','2021-09-22 09:31:55','2021-07-27'),
(402,1,1,55,'2021-07-27 08:11:00','2021-07-27 09:23:00',4320,'aggionamento vm posta',54,NULL,45,1,'Europe/Rome',54,1,'work','2021-09-22 15:31:12','2021-07-27'),
(403,1,1,2,'2021-07-27 09:30:00','2021-07-27 10:29:00',3540,'configurazione utente laura permessi',44.25,NULL,45,1,'Europe/Rome',44.25,1,'work','2021-11-17 14:38:14','2021-07-27'),
(404,1,1,29,'2021-07-27 14:11:00','2021-07-27 15:18:00',4020,'studio per script copia per backup remoto',50.25,NULL,45,1,'Europe/Rome',50.25,1,'work','2021-09-27 13:43:26','2021-07-27'),
(405,1,1,22,'2021-07-28 07:09:00','2021-07-28 07:31:39',1359,'config posta pc di casa',16.99,NULL,45,1,'Europe/Rome',16.99,1,'work','2021-10-22 07:34:19','2021-07-28'),
(406,1,1,2,'2021-07-28 07:32:00','2021-07-28 09:40:00',7680,'cartella condivisa\r\nmanutenzione server',96,NULL,45,1,'Europe/Rome',96,1,'work','2021-11-17 14:38:22','2021-07-28'),
(407,3,1,84,'2021-07-27 07:40:00','2021-07-27 08:40:00',3600,'Assistenza per installazione e configurazione Office 365',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-27 16:02:00','2021-07-27'),
(408,3,2,81,'2021-07-27 13:15:00','2021-07-27 13:35:00',1200,'Riconsegnato pc client dopo assistenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-10 09:14:46','2021-07-27'),
(409,3,2,96,'2021-07-27 13:55:00','2021-07-27 14:25:00',1800,'Sostituzione disco spare su Gandolfo1 con wd da 4tb',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-01 15:32:08','2021-07-27'),
(410,3,2,50,'2021-07-27 14:40:00','2021-07-27 15:40:00',3600,'Assistenza su mac Elisabetta\r\nAssistenza su pc client Francesco\r\nAssistenza su pc client Giuseppe',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-07-28 09:02:21','2021-07-27'),
(411,1,1,95,'2021-07-28 09:50:00','2021-07-28 12:08:28',8308,'problemi profilo roaming pc silvia',103.85,NULL,45,1,'Europe/Rome',103.85,1,'work','2021-09-21 15:29:22','2021-07-28'),
(412,1,4,3,'2021-07-28 12:33:00','2021-07-28 14:00:00',5220,'problema pc privato led rgb e rilevazione ventole cpu',65.25,NULL,45,1,'Europe/Rome',65.25,1,'work','2021-09-10 15:25:42','2021-07-28'),
(413,1,1,3,'2021-07-28 15:00:00','2021-07-28 16:04:00',3840,'mepa per villaserra',48,NULL,45,1,'Europe/Rome',48,1,'work','2021-09-10 15:25:35','2021-07-28'),
(414,3,4,79,'2021-07-28 08:00:00','2021-07-28 09:00:00',3600,'Reinstallazione vecchio pc client Paolo',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-23 13:51:37','2021-07-28'),
(415,3,2,79,'2021-07-28 13:40:00','2021-07-28 16:20:00',9600,'Assistenza su pc client Paola\r\nAssistenza su pc client Paolo\r\nAssistenza su pc client Produzione (da proporre  a settembre upgrade hw e office)\r\nRiconsegnato e configurato pc client Magazzino, da finire in remoto',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-23 13:51:37','2021-07-28'),
(416,1,1,3,'2021-07-29 09:20:00','2021-07-29 10:49:00',5340,'configurazione 3ware per invio mail',66.75,NULL,45,1,'Europe/Rome',66.75,1,'work','2021-09-10 15:25:47','2021-07-29'),
(417,3,1,32,'2021-07-29 07:00:00','2021-07-29 07:20:00',1200,'Assistenza su pc client Daniela per problemi con Adobe Reader',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-22 10:18:35','2021-07-29'),
(418,1,1,3,'2021-07-29 06:43:00','2021-07-29 07:00:00',1020,'portato ciro in lab',12.75,NULL,45,1,'Europe/Rome',12.75,1,'work','2021-09-10 15:25:36','2021-07-29'),
(419,1,1,1,'2021-07-29 07:09:00','2021-07-29 08:11:00',3720,'agg server di posta',46.5,NULL,45,1,'Europe/Rome',46.5,1,'work','2021-09-21 10:47:07','2021-07-29'),
(420,1,1,55,'2021-07-29 08:23:00','2021-07-29 09:16:00',3180,'verifica generale prima delle ferie',39.75,NULL,45,1,'Europe/Rome',39.75,1,'work','2021-09-22 15:31:11','2021-07-29'),
(421,3,1,32,'2021-07-29 10:05:00','2021-07-29 10:25:00',1200,'Assistenza su pc client Daniela',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-22 10:18:35','2021-07-29'),
(422,3,1,83,'2021-07-29 13:15:00','2021-07-29 13:35:00',1200,'Assistenza per verifica funzionamento stampanti',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-10-22 10:01:05','2021-07-29'),
(423,1,1,3,'2021-07-29 12:32:00','2021-07-29 16:30:00',14280,'configurazione 3ware per invio mail\r\nproblemi areca invio mail',178.5,NULL,45,1,'Europe/Rome',178.5,1,'work','2021-09-10 15:25:44','2021-07-29'),
(424,3,1,45,'2021-07-29 14:55:00','2021-07-29 15:15:00',1200,'Assistenza per problemi con ip statico Fastweb a casa di Laura',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-15 15:51:32','2021-07-29'),
(425,1,1,2,'2021-07-01 08:14:00','2021-07-01 08:46:00',1920,'profili roaming',24,NULL,45,1,'Europe/Rome',24,1,'work','2021-11-17 14:38:00','2021-07-01'),
(426,1,1,3,'2021-07-05 12:42:00','2021-07-05 15:00:00',8280,'proxmox',103.5,NULL,45,1,'Europe/Rome',103.5,1,'work','2021-09-10 15:25:23','2021-07-05'),
(427,1,1,4,'2021-07-06 06:45:00','2021-07-06 08:08:00',4980,'problema danea',62.25,NULL,45,1,'Europe/Rome',62.25,1,'work','2021-09-14 09:22:49','2021-07-06'),
(428,1,1,51,'2021-07-06 09:15:00','2021-07-06 10:26:00',4260,'manutenzione server',53.25,NULL,45,1,'Europe/Rome',53.25,1,'work','2021-09-16 15:26:43','2021-07-06'),
(429,1,1,55,'2021-07-06 14:48:00','2021-07-06 16:22:00',5640,'agg server',70.5,NULL,45,1,'Europe/Rome',70.5,1,'work','2021-09-22 15:31:15','2021-07-06'),
(430,1,1,3,'2021-07-16 06:42:00','2021-07-16 07:30:00',2880,'fogli',36,NULL,45,1,'Europe/Rome',36,1,'work','2021-09-10 15:25:30','2021-07-16'),
(431,1,1,4,'2021-07-16 09:07:00','2021-07-16 10:29:00',4920,'proxmox',61.5,NULL,45,1,'Europe/Rome',61.5,1,'work','2021-09-14 09:23:04','2021-07-16'),
(432,1,1,3,'2021-07-16 12:44:00','2021-07-16 14:39:00',6900,'backup remoti',86.25,NULL,45,1,'Europe/Rome',86.25,1,'work','2021-09-10 15:25:30','2021-07-16'),
(433,1,1,29,'2021-07-19 12:43:00','2021-07-19 14:00:00',4620,'studio per backup remoto',57.75,NULL,45,1,'Europe/Rome',57.75,1,'work','2021-09-27 13:43:25','2021-07-19'),
(434,1,1,79,'2021-07-22 09:16:00','2021-07-22 10:23:00',4020,'problemi ssl e aggiornamento server di posta configurato restart problemi dopo update da parte di alex',50.25,NULL,45,1,'Europe/Rome',50.25,1,'work','2021-09-23 13:51:34','2021-07-22'),
(435,1,1,3,'2021-07-22 12:43:00','2021-07-22 16:30:00',13620,'completamento backup remoti',170.25,NULL,45,1,'Europe/Rome',170.25,1,'work','2021-09-10 15:25:35','2021-07-22'),
(436,1,1,103,'2021-07-26 12:41:00','2021-07-26 14:00:00',4740,'aggiornamento server',59.25,NULL,45,1,'Europe/Rome',59.25,1,'work','2021-09-23 15:13:58','2021-07-26'),
(437,1,1,41,'2021-07-27 15:41:00','2021-07-27 16:45:00',3840,'spostamento share e cartelle',48,NULL,45,1,'Europe/Rome',48,1,'work','2021-09-16 14:21:24','2021-07-27'),
(438,1,1,41,'2021-07-28 14:05:00','2021-07-28 14:48:00',2580,'sistemazione share',32.25,NULL,45,1,'Europe/Rome',32.25,1,'work','2021-09-16 14:21:25','2021-07-28'),
(439,3,2,41,'2021-07-30 08:25:00','2021-07-30 08:55:00',1800,'Assistenza per problemi navigazione\r\nInstallate 2 licenze nod32 complete su 4 pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-16 14:21:26','2021-07-30'),
(440,3,1,45,'2021-07-30 09:15:00','2021-07-30 09:35:00',1200,'Installata e configurata vpn su nuovo portatile Laura\r\nInstallata 1 licenza completa nod32',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-15 15:51:34','2021-07-30'),
(441,3,1,88,'2021-07-30 09:50:00','2021-07-30 10:00:00',600,'Assistenza su pc client Maura Piazza',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-05 11:21:29','2021-07-30'),
(442,3,2,41,'2021-07-30 12:45:00','2021-07-30 13:35:00',3000,'Assistenza per problemi rete\r\nInstallata 2 licenze nod32 complete su 3 pc client\r\nAssistenza su pc client Marco',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-16 14:21:27','2021-07-30'),
(443,3,1,100,'2021-07-30 13:55:00','2021-07-30 14:05:00',600,'Assistenza per problemi a scaricare posta sull\'Iphone',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-09 11:41:36','2021-07-30'),
(444,3,1,96,'2021-07-30 14:05:00','2021-07-30 14:15:00',600,'Impostato messaggio segreteria per le ferie',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-01 15:32:09','2021-07-30'),
(445,3,1,96,'2021-07-30 14:20:00','2021-07-30 14:30:00',600,'Assistenza su pc client Federica',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-01 15:32:10','2021-07-30'),
(446,3,1,32,'2021-07-30 14:50:00','2021-07-30 15:50:00',3600,'Assistenza per problemi ambiente sicurezza Desktop telematico, da risolvere',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-22 10:18:36','2021-07-30'),
(447,1,1,103,'2021-08-16 09:44:00','2021-08-16 09:51:56',476,'accesso vpn martina',5.95,NULL,45,1,'Europe/Rome',5.95,1,'work','2021-09-23 15:31:39','2021-08-16'),
(448,1,1,103,'2021-08-16 14:05:37','2021-08-16 15:05:00',3563,'accesso vpn martina',44.54,NULL,45,1,'Europe/Rome',44.54,1,'work','2021-09-23 15:31:40','2021-08-16'),
(449,1,2,113,'2021-08-20 06:30:00','2021-08-20 13:40:00',25800,'installazione montaggio wifi',322.5,NULL,45,1,'Europe/Rome',322.5,1,'work','2021-10-22 10:09:02','2021-08-20'),
(450,1,2,41,'2021-08-23 06:24:00','2021-08-23 07:35:00',4260,'problemi di connessione via secca',53.25,NULL,45,1,'Europe/Rome',53.25,1,'work','2021-09-16 14:21:31','2021-08-23'),
(451,1,1,55,'2021-08-23 07:54:00','2021-08-23 09:13:00',4740,'pc luca lento, ripulito un pò',59.25,NULL,45,1,'Europe/Rome',59.25,1,'work','2021-09-22 15:31:11','2021-08-23'),
(452,1,1,2,'2021-08-26 07:22:00','2021-08-26 09:13:00',6660,'firewall bloccato, fatto riavviare. verifiche post riavvio',83.25,NULL,45,1,'Europe/Rome',83.25,1,'work','2021-11-17 14:38:15','2021-08-26'),
(453,3,1,103,'2021-08-02 07:45:00','2021-08-02 08:05:00',1200,'Assistenza per problemi a scaricare posta in arrivo',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-23 15:31:38','2021-08-02'),
(454,3,2,32,'2021-08-02 08:50:00','2021-08-02 09:50:00',3600,'Creato e configurato nuovo Ambiente di Sicurezza in Desktop Telematico',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-22 10:18:37','2021-08-02'),
(455,3,1,60,'2021-08-02 10:45:00','2021-08-02 11:00:00',900,'Assistenza per funzionamento centralino dopo che è mancata la corrente',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-22 10:21:10','2021-08-02'),
(456,3,1,22,'2021-08-02 12:30:00','2021-08-02 12:40:00',600,'Assistenza per problemi su Thunderbird',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-10-22 07:34:20','2021-08-02'),
(457,3,1,51,'2021-08-02 12:50:00','2021-08-02 13:10:00',1200,'Assistenza per problemi accesso su vecchio pc client, da ritirare e reinstallare',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-16 15:26:44','2021-08-02'),
(458,3,2,51,'2021-08-03 06:45:00','2021-08-03 06:55:00',600,'Ritirato portatile per reinstallazione',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-16 15:26:45','2021-08-03'),
(459,3,2,79,'2021-08-03 09:00:00','2021-08-03 09:50:00',3000,'Verificato e ritirato pc client Andrea bloccato',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-23 13:51:39','2021-08-03'),
(460,3,1,67,'2021-08-03 07:45:00','2021-08-03 08:05:00',1200,'Assistenza per problema collegamento a teleselling sulla vm',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-27 13:37:29','2021-08-03'),
(461,3,1,50,'2021-08-03 08:05:00','2021-08-03 08:35:00',1800,'Creati e configurati 2 nuove mail claims e underwriting',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-10 15:23:34','2021-08-03'),
(462,3,1,79,'2021-08-03 10:15:00','2021-08-03 10:30:00',900,'Recuperato e inviato file ad Andrea',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-23 13:51:40','2021-08-03'),
(463,3,4,51,'2021-08-03 13:00:00','2021-08-03 14:00:00',3600,'Reinstallato sistema operativo su portatile ritirato',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-16 15:26:46','2021-08-03'),
(464,3,2,51,'2021-08-03 14:50:00','2021-08-03 15:05:00',900,'Riconsegnato portatile dopo reinstallazione',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-16 15:26:47','2021-08-03'),
(465,3,2,24,'2021-08-03 15:30:00','2021-08-03 15:40:00',600,'Consegnate cartucce Epson 63076, 63172, 63170',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-22 09:27:57','2021-08-03'),
(466,3,1,101,'2021-08-04 10:20:00','2021-08-04 10:45:00',1500,'Assistenza per problemi Outlook su pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-10-22 09:21:56','2021-08-04'),
(467,3,1,26,'2021-08-05 13:00:00','2021-08-05 13:20:00',1200,'Assistenza a Simona per problemi invio mail da cellulare',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-10-31 11:40:33','2021-08-05'),
(468,3,1,9,'2021-08-05 13:25:00','2021-08-05 13:50:00',1500,'Assistenza su portatile per problemi su attacchi usb, probabilmente problema hw',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-06-29 08:16:48','2021-08-05'),
(469,3,4,79,'2021-08-05 14:00:00','2021-08-05 17:00:00',10800,'Assistenza per sostituzione PC client Andrea, provato a clonare s.o su nuovo disco M2 (non riuscito)\r\nHW Utilizzato: Asus Prime A320M-K, 2 banchi da 8gb DDR4, CPU Ryzen 7, SK video da 1 gb, Case cm con vetro e alim. cm MWE 500w',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-23 10:15:49','2021-08-05'),
(470,3,2,79,'2021-08-06 06:45:00','2021-08-06 07:45:00',3600,'Consegnato nuovo pc client Andrea, assistenza su pc client Paolo, assistenza su iPhone Valentina per problemi di posta',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-23 13:51:41','2021-08-06'),
(471,3,1,90,'2021-08-06 08:05:00','2021-08-06 08:20:00',900,'Assistenza per problemi posta in entrata e uscita',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-23 16:13:25','2021-08-06'),
(472,3,1,50,'2021-08-06 09:05:00','2021-08-06 09:25:00',1200,'Assistenza per recupero password mail Francesco, Gigio e Filippo',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-10 15:23:36','2021-08-06'),
(473,3,1,50,'2021-08-06 09:30:00','2021-08-06 10:00:00',1800,'Supporto per configurazione nuove cartelle Archivio su Thunderbird',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-10 15:23:38','2021-08-06'),
(474,3,1,96,'2021-08-09 07:10:00','2021-08-09 07:30:00',1200,'Assistenza su pc client Federica',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-01 15:32:13','2021-08-09'),
(475,3,1,32,'2021-08-09 13:40:00','2021-08-09 14:00:00',1200,'Assistenza su pc client Daniela',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-22 10:18:38','2021-08-09'),
(476,3,1,32,'2021-08-10 13:00:00','2021-08-10 13:30:00',1800,'Assistenza su pc client Daniela',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-22 10:18:39','2021-08-10'),
(477,3,2,110,'2021-08-11 08:20:00','2021-08-11 08:55:00',2100,'Verificato e ritirato UPS rack per sostituzione batterie\r\nInstallato provvisoriamente UPS APC 1400',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-27 13:44:26','2021-08-11'),
(478,3,2,96,'2021-08-12 07:30:00','2021-08-12 08:30:00',3600,'Assistenza su pc client Antonella e Federica per spegnimento durante la notte',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-01 15:32:14','2021-08-12'),
(479,3,1,41,'2021-08-12 08:35:00','2021-08-12 08:55:00',1200,'Assistenza su PC client Roberta per problemi con software WintoLip',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-16 14:21:29','2021-08-12'),
(480,3,2,41,'2021-08-11 09:30:00','2021-08-11 10:00:00',1800,'Assistenza su pc client Francesca per problemi di rete (via Wagner), assistenza su monitor server/telecamere',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-16 14:21:28','2021-08-11'),
(481,3,2,22,'2021-08-13 13:30:00','2021-08-13 15:15:00',6300,'Assistenza per problemi scansione di rete su NAS e indicizzazione file NAS dopo aggiornamento, problema da risolvere',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-10-22 07:34:21','2021-08-13'),
(482,1,1,108,'2021-08-30 12:44:00','2021-08-30 13:51:33',4053,'problemi pc alessia',50.66,NULL,45,1,'Europe/Rome',50.66,1,'work','2022-02-22 10:20:22','2021-08-30'),
(483,3,1,64,'2021-08-30 06:45:00','2021-08-30 07:00:00',900,'Assistenza per problemi con il certificato di posta',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-06 09:48:15','2021-08-30'),
(484,1,1,3,'2021-08-30 06:40:00','2021-08-30 08:00:00',4800,'organizzazione lavori',60,NULL,45,1,'Europe/Rome',60,1,'work','2021-09-10 15:25:48','2021-08-30'),
(485,1,1,55,'2021-08-30 08:13:00','2021-08-30 10:28:00',8100,'spostamento ruoli e gpo per spegnimento vecchio server amico win',101.25,NULL,45,1,'Europe/Rome',101.25,1,'work','2021-09-22 15:31:10','2021-08-30'),
(486,1,1,2,'2021-08-30 14:10:00','2021-08-30 16:30:00',8400,'per nuovo firewall e manutenzione server',105,NULL,45,1,'Europe/Rome',105,1,'work','2021-11-17 14:38:21','2021-08-30'),
(487,1,4,3,'2021-08-31 06:30:00','2021-08-31 06:40:00',600,'in lab',7.5,NULL,45,1,'Europe/Rome',7.5,1,'work','2021-09-10 15:25:37','2021-08-31'),
(488,1,1,103,'2021-08-31 08:37:00','2021-08-31 09:36:00',3540,'problema hanno spostato cartrelle degli share incasinando i programmi',44.25,NULL,45,1,'Europe/Rome',44.25,1,'work','2021-09-23 15:31:40','2021-08-31'),
(489,1,1,50,'2021-08-31 09:40:00','2021-08-31 10:30:00',3000,'problema tastierino numerico e agg centralino',37.5,NULL,45,1,'Europe/Rome',37.5,1,'work','2021-09-10 15:23:42','2021-08-31'),
(490,1,1,67,'2021-08-31 14:49:00','2021-08-31 16:32:05',6185,'probnlwmi teleselling',77.31,NULL,45,1,'Europe/Rome',77.31,1,'work','2021-09-27 13:37:30','2021-08-31'),
(491,3,2,24,'2021-08-31 08:20:00','2021-08-31 08:30:00',600,'Consegna cartucce Canon 62575 e 62582',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-22 09:30:22','2021-08-31'),
(492,3,2,79,'2021-08-31 08:45:00','2021-08-31 09:55:00',4200,'Assistenza su pc client Magazzino per installazione Onda\r\nRitiro vecchio pc Magazzino\r\nAssistenza su pc client Paolo\r\nFare offerta per pc Produzione (base senza mouse, tastiera e monitor) + Office',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-23 13:51:42','2021-08-31'),
(493,3,2,79,'2021-08-31 14:30:00','2021-08-31 14:40:00',600,'Ritiro pc client Andrea per copia disco',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-23 10:16:18','2021-08-31'),
(494,1,1,67,'2021-08-31 20:21:00','2021-08-31 21:30:00',4140,'Espansione disco c del server virtuale da 27 gb a 50 ripartizionamento',51.75,NULL,45,1,'Europe/Rome',51.75,1,'work','2021-09-27 13:37:31','2021-08-31'),
(495,1,1,41,'2021-08-31 07:04:00','2021-08-31 08:26:00',4920,'share',61.5,NULL,45,1,'Europe/Rome',61.5,1,'work','2021-09-16 14:21:33','2021-08-31'),
(496,1,1,1,'2021-08-31 12:46:00','2021-08-31 14:30:00',6240,'agg server',78,NULL,45,1,'Europe/Rome',78,1,'work','2021-09-21 10:47:07','2021-08-31'),
(497,1,1,83,'2021-09-01 08:41:00','2021-09-01 08:50:37',577,'problema stampante',7.21,NULL,45,1,'Europe/Rome',7.21,1,'work','2021-10-22 09:55:05','2021-09-01'),
(498,1,1,67,'2021-09-01 06:44:00','2021-09-01 07:22:00',2280,'test di funzionamento dopo aumento disco',28.5,NULL,45,1,'Europe/Rome',28.5,1,'work','2021-09-27 13:37:32','2021-09-01'),
(499,1,1,3,'2021-09-01 08:10:00','2021-09-01 08:33:00',1380,'info su software davinci per upgrade pc privato',17.25,NULL,45,1,'Europe/Rome',17.25,1,'work','2021-09-10 15:25:44','2021-09-01'),
(500,1,1,79,'2021-09-01 07:30:00','2021-09-01 08:00:00',1800,'clone disco sig parodi',22.5,NULL,45,1,'Europe/Rome',22.5,1,'work','2021-09-24 14:20:22','2021-09-01'),
(501,3,2,6,'2021-09-01 08:15:00','2021-09-01 08:45:00',1800,'Verificato e ritirato pc client Amministrazione per assistenza \r\nRitirato portatile figlia Paolo per assistenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-13 16:46:52','2021-09-01'),
(502,1,1,41,'2021-09-02 06:57:00','2021-09-02 07:45:50',2930,'problema mail commerciale dopo tentativo cambio password',36.63,NULL,45,1,'Europe/Rome',36.63,1,'work','2021-10-21 15:20:58','2021-09-02'),
(503,1,1,79,'2021-09-02 06:40:00','2021-09-02 06:55:00',900,'test riscaldamento minipc',11.25,NULL,45,1,'Europe/Rome',11.25,1,'work','2021-09-22 15:32:18','2021-09-02'),
(504,1,1,79,'2021-09-02 08:02:00','2021-09-02 08:37:00',2100,'test riscaldamento minipc',26.25,NULL,45,1,'Europe/Rome',26.25,1,'work','2021-09-22 15:32:15','2021-09-02'),
(505,1,1,108,'2021-09-02 08:40:00','2021-09-02 10:26:00',6360,'problemi pc ex daniela',79.5,NULL,45,1,'Europe/Rome',79.5,1,'work','2022-02-22 10:20:23','2021-09-02'),
(506,1,4,3,'2021-09-02 12:30:00','2021-09-02 13:30:00',3600,'riprotato in lab pc nutra',45,NULL,45,1,'Europe/Rome',45,1,'work','2021-09-10 15:25:47','2021-09-02'),
(507,1,1,79,'2021-09-01 12:39:00','2021-09-01 15:45:00',11160,'clonazione ssd\r\ntest riscaldamento minipc',139.5,NULL,45,1,'Europe/Rome',139.5,1,'work','2021-09-22 15:32:23','2021-09-01'),
(508,1,1,4,'2021-09-01 09:00:00','2021-09-01 10:27:00',5220,'agg vm',65.25,NULL,45,1,'Europe/Rome',65.25,1,'work','2021-09-14 09:23:08','2021-09-01'),
(509,1,1,5,'2021-09-01 15:58:00','2021-09-01 16:30:00',1920,'agg sevrer',24,NULL,45,1,'Europe/Rome',24,1,'work','2021-10-21 10:39:19','2021-09-01'),
(510,3,4,6,'2021-09-02 06:45:00','2021-09-02 07:45:00',3600,'Assistenza su pc client Amministrazione, montato SSD S3+ da 480gb + 4 gb DDR3 usata\r\nClonazione sistema su nuovo SSD',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-13 16:46:53','2021-09-02'),
(511,3,2,110,'2021-09-02 08:30:00','2021-09-02 08:50:00',1200,'Riconsegnato e montato UPS APC 1500 dopo sostituzione 4 batterie da 9 Ah',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-27 13:44:27','2021-09-02'),
(512,3,2,29,'2021-09-02 08:55:00','2021-09-02 09:05:00',600,'Ritirato disco server da 4tb di backup da sostituire',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-27 13:43:29','2021-09-02'),
(513,3,2,6,'2021-09-02 09:40:00','2021-09-02 10:05:00',1500,'Riconsegnato pc client Amministrazione dopo assistenza e aggiornamento hw\r\nRitirato pc client Presidenza per assistenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-13 16:46:54','2021-09-02'),
(514,3,2,79,'2021-09-02 13:45:00','2021-09-02 14:20:00',2100,'Riconsegnato e provato pc client Andrea',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-24 14:19:27','2021-09-02'),
(515,3,4,6,'2021-09-03 06:45:00','2021-09-03 07:45:00',3600,'Assistenza su pc client Presidenza sostituzione hhd con ssd 480gb crucial, montata 4gb ddr3 usata\r\nClonazione s.o su nuovo ssd',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-13 16:46:55','2021-09-03'),
(516,3,2,6,'2021-09-03 09:40:00','2021-09-03 09:55:00',900,'Riconsegnato pc client Presidenza dopo assistenza\r\nRitirato pc client Pia per assistenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-13 16:46:56','2021-09-03'),
(517,3,1,79,'2021-09-03 13:15:00','2021-09-03 13:25:00',600,'Assistenza su pc client Paolo',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-29 17:01:27','2021-09-03'),
(518,3,2,104,'2021-09-03 13:40:00','2021-09-03 14:00:00',1200,'Assistenza su iPhone Daniele\r\nAssistenza su pc client Denise',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-22 14:47:15','2021-09-03'),
(519,1,1,51,'2021-09-06 10:08:00','2021-09-06 10:25:00',1020,'problema permessi share',12.75,NULL,45,1,'Europe/Rome',12.75,1,'work','2021-09-16 15:26:48','2021-09-06'),
(520,1,1,58,'2021-09-06 10:26:00','2021-09-06 10:35:00',540,'problemi webmeeting',6.75,NULL,45,1,'Europe/Rome',6.75,1,'work','2021-09-24 15:33:01','2021-09-06'),
(521,1,1,3,'2021-09-06 06:30:00','2021-09-06 06:47:00',1020,NULL,12.75,NULL,45,1,'Europe/Rome',12.75,1,'work','2021-09-10 15:25:38','2021-09-06'),
(522,1,1,67,'2021-09-06 07:10:00','2021-09-06 09:45:00',9300,'backup remoto',116.25,NULL,45,1,'Europe/Rome',116.25,1,'work','2021-09-27 10:24:04','2021-09-06'),
(523,3,2,41,'2021-09-06 07:00:00','2021-09-06 07:20:00',1200,'Verificato e ritirato UPS APC 700 per sostituzione batteria',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-10-21 15:20:59','2021-09-06'),
(524,3,2,41,'2021-09-06 07:40:00','2021-09-06 08:20:00',2400,'Assistenza su pc client Giancarlo + sostituzione alim. cm 500\r\nFare offerta PC client base per Roberta\r\nFare offerta per nuova stampante simile a HP PageWide Pro MFP 477dw',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-10-21 15:21:00','2021-09-06'),
(525,3,1,64,'2021-09-06 09:10:00','2021-09-06 09:30:00',1200,'Assistenza per recupero dimensioni cartella Open manager',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-17 15:57:45','2021-09-06'),
(526,3,4,41,'2021-09-06 09:40:00','2021-09-06 09:50:00',600,'Sostituzione  batteria su UPS APC 700',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-10-21 14:25:12','2021-09-06'),
(527,3,1,79,'2021-09-06 12:50:00','2021-09-06 13:05:00',900,'Assistenza su pc client Andrea per problemi su Thunderbird',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-24 14:19:35','2021-09-06'),
(528,3,4,6,'2021-09-06 13:50:00','2021-09-06 14:40:00',3000,'Reinstallato s.o su pc client Pia Perez\r\nUtilizzato SSD 480gb + 4 gb DDR3 usata',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-13 16:46:57','2021-09-06'),
(529,1,2,51,'2021-09-07 08:00:00','2021-09-07 09:24:00',5040,'sopraluogo per test vnc su tablet ecografo',63,NULL,45,1,'Europe/Rome',63,1,'work','2021-09-16 15:26:50','2021-09-07'),
(530,1,1,58,'2021-09-07 10:01:00','2021-09-07 10:20:00',1140,'problemi carcere tentativo di collegamento remoto',14.25,NULL,45,1,'Europe/Rome',14.25,1,'work','2021-09-24 15:33:02','2021-09-07'),
(531,1,4,3,'2021-09-07 14:46:00','2021-09-07 16:30:00',6240,'in lab',78,NULL,45,1,'Europe/Rome',78,1,'work','2021-09-10 15:25:46','2021-09-07'),
(532,1,1,55,'2021-09-07 12:43:00','2021-09-07 14:33:00',6600,'Controlli server e vm',82.5,NULL,45,1,'Europe/Rome',82.5,1,'work','2021-09-22 15:31:36','2021-09-07'),
(533,1,2,55,'2021-09-06 13:49:00','2021-09-06 15:45:00',6960,'per discussione fatture',87,NULL,45,1,'Europe/Rome',87,1,'work','2021-09-22 15:31:09','2021-09-06'),
(534,1,1,51,'2021-09-06 15:50:00','2021-09-06 16:30:00',2400,'problemi permessi share',30,NULL,45,1,'Europe/Rome',30,1,'work','2021-09-16 15:26:49','2021-09-06'),
(535,1,3,112,'2021-09-07 06:30:00','2021-09-07 06:48:00',1080,NULL,13.5,NULL,45,1,'Europe/Rome',13.5,1,'work','2021-09-22 09:44:34','2021-09-07'),
(536,1,1,58,'2021-09-08 07:12:00','2021-09-08 08:44:00',5520,'problemi carcere firewall',69,NULL,45,1,'Europe/Rome',69,1,'work','2021-09-24 15:33:03','2021-09-08'),
(537,1,1,51,'2021-09-08 12:37:00','2021-09-08 13:19:00',2520,'cercato di sistemare problema nfs senza risultato',31.5,NULL,45,1,'Europe/Rome',31.5,1,'work','2021-09-16 15:26:22','2021-09-08'),
(538,1,1,4,'2021-09-08 13:38:00','2021-09-08 16:30:00',10320,'Aggiornamento licenza windows server 2019. sistemato\r\nProblemi dopo agg cdkey avvio windows 2019 sistemato\r\nConfigurazione vm proxmox backup per i backup delle vm proxmox',129,NULL,45,1,'Europe/Rome',129,1,'work','2021-09-14 09:23:10','2021-09-08'),
(539,1,1,58,'2021-09-09 08:32:00','2021-09-09 08:48:00',960,'problemi carcere firewall',12,NULL,45,1,'Europe/Rome',12,1,'work','2021-09-24 15:33:05','2021-09-09'),
(540,1,1,51,'2021-09-09 09:21:00','2021-09-09 10:30:00',4140,'cercato di sistemare problema nfs senza risultato',51.75,NULL,45,1,'Europe/Rome',51.75,1,'work','2021-09-16 15:26:23','2021-09-09'),
(541,1,1,79,'2021-09-09 12:48:00','2021-09-09 15:10:28',8548,'ancora piccoli ritardi su tastiera usb',106.85,NULL,45,1,'Europe/Rome',106.85,1,'work','2021-09-24 14:19:47','2021-09-09'),
(542,1,1,55,'2021-09-10 12:40:00','2021-09-10 14:40:00',7200,'spostamento ultime cose su server nuovo spegnimento vecchio server amico win',90,NULL,45,1,'Europe/Rome',90,1,'work','2021-09-22 15:31:38','2021-09-10'),
(543,1,1,55,'2021-09-10 09:23:00','2021-09-10 10:27:00',3840,'spostamento ultime cose su server nuovo spegnimento vecchio server amico win',48,NULL,45,1,'Europe/Rome',48,1,'work','2021-09-22 15:31:36','2021-09-10'),
(544,1,3,112,'2021-09-10 06:30:00','2021-09-10 06:40:00',600,NULL,7.5,NULL,45,1,'Europe/Rome',7.5,1,'work','2021-09-22 09:44:35','2021-09-10'),
(545,1,1,5,'2021-09-09 06:42:00','2021-09-09 08:12:00',5400,'agg server',67.5,NULL,45,1,'Europe/Rome',67.5,1,'work','2021-10-21 10:39:20','2021-09-09'),
(546,1,1,95,'2021-09-09 15:20:00','2021-09-09 16:30:00',4200,'problemi pc anna al login',52.5,NULL,45,1,'Europe/Rome',52.5,1,'work','2021-09-21 15:29:23','2021-09-09'),
(547,1,1,51,'2021-09-08 08:50:00','2021-09-08 10:29:00',5940,'problema permessi',74.25,NULL,45,1,'Europe/Rome',74.25,1,'work','2021-09-16 15:26:21','2021-09-08'),
(548,1,1,51,'2021-09-10 06:46:00','2021-09-10 09:00:00',8040,'problemi autostart postgreesql',100.5,NULL,45,1,'Europe/Rome',100.5,1,'work','2021-09-16 15:26:24','2021-09-10'),
(549,1,1,90,'2021-09-13 07:18:00','2021-09-13 07:48:00',1800,'problemi certificati ssl',22.5,NULL,45,1,'Europe/Rome',22.5,1,'work','2021-09-23 16:13:26','2021-09-13'),
(550,1,1,2,'2021-09-13 08:30:00','2021-09-13 09:14:58',2698,'sistemazione problemi segnalati da laura su posta',33.73,NULL,45,1,'Europe/Rome',33.73,1,'work','2021-11-17 14:38:17','2021-09-13'),
(551,1,1,41,'2021-09-13 09:15:00','2021-09-13 10:12:00',3420,'problema apertura file',42.75,NULL,45,1,'Europe/Rome',42.75,1,'work','2021-10-21 15:21:06','2021-09-13'),
(552,1,1,5,'2021-09-13 12:51:00','2021-09-13 13:22:31',1891,'problemi onedrive',23.64,NULL,45,1,'Europe/Rome',23.64,1,'work','2021-10-21 10:39:23','2021-09-13'),
(553,3,2,6,'2021-09-07 13:00:00','2021-09-07 14:00:00',3600,'Riconsegnato e configurato PC client Pia Perez\r\nRitirato pc client ingresso per assistenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-13 16:46:58','2021-09-07'),
(554,3,4,6,'2021-09-08 12:45:00','2021-09-08 13:45:00',3600,'Assistenza su pc client Ingresso\r\nUtilizzato: SSD 480gb + 4gb DDR3 usata\r\nClonazione sistema operativo su nuovo ssd',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-13 16:46:59','2021-09-08'),
(555,3,2,6,'2021-09-09 09:10:00','2021-09-09 09:40:00',1800,'Riconsegnato pc client Ingresso dopo assistenza\r\nSostituzione 2 batterie su UPS APC 1400\r\nRitiro PC client per assistenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-13 16:47:00','2021-09-09'),
(556,3,4,6,'2021-09-10 15:20:00','2021-09-10 16:50:00',5400,'Reinstallato sistema operativo su pc client Acli\r\nUtilizzato: ssd 480gb patriot + 4gb ddr3 usata',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-13 16:47:01','2021-09-10'),
(557,3,2,6,'2021-09-13 09:15:00','2021-09-13 09:45:00',1800,'Riconsegnato pc client + configurazione',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-13 16:47:02','2021-09-13'),
(558,3,2,50,'2021-09-07 14:30:00','2021-09-07 15:10:00',2400,'Assistenza su portatile Gigio per configurare firma posta su tutti gli account\r\nAssistenza su pc Giuseppe per problemi con stampanti\r\nAssistenza su pc Francesco per disco pieno (sostituire SSD)',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-17 08:34:55','2021-09-07'),
(559,3,2,76,'2021-09-07 15:30:00','2021-09-07 16:00:00',1800,'Assistenza su portatile per problema di rete',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-15 16:07:15','2021-09-07'),
(560,3,2,24,'2021-09-08 08:30:00','2021-09-08 08:45:00',900,'Assistenza su pc client Monica',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-22 09:31:56','2021-09-08'),
(561,3,2,41,'2021-09-09 10:00:00','2021-09-09 10:40:00',2400,'Assistenza su pc client Luana, consegnato e installato UPS APC dopo cambio batteria\r\nRitirato UPS Gulli per cambio batteria, ritirato pc client Syntex per bk dati\r\nFare offerta personale a Francesca per licenza Office (francemirko@gmail.com)',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-10-21 15:21:01','2021-09-09'),
(562,3,2,41,'2021-09-09 14:30:00','2021-09-09 15:10:00',2400,'Assistenza su pc client per problemi posta elettronica\r\nSopralluogo per passaggio cavo di rete sede Ceranesi',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-10-21 15:21:05','2021-09-09'),
(563,3,1,1,'2021-09-09 07:30:00','2021-09-09 08:30:00',3600,'Assistenza su pc client Alberto per installazione software Dylog in locale',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-21 10:47:08','2021-09-09'),
(564,3,1,83,'2021-09-09 12:50:00','2021-09-09 13:00:00',600,'Verificata versione SQL per futuro aggiornamento',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-10-22 10:01:06','2021-09-09'),
(565,3,4,41,'2021-09-09 13:10:00','2021-09-09 14:10:00',3600,'Assistenza su pc client Syntex per clonazione sistema operativo\r\nUtilizzato hhd da 2tb usato',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-10-21 15:21:03','2021-09-09'),
(566,3,2,79,'2021-09-10 07:30:00','2021-09-10 10:45:00',11700,'Reinstallato sistema operativo su pc client Andrea + configurazione \r\nUtilizzato: ssd 500gb patriot',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-24 14:19:48','2021-09-10'),
(567,3,2,5,'2021-09-10 12:35:00','2021-09-10 13:15:00',2400,'Assistenza su pc client Contabilità, fissare ritiro in futuro per agg hw',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-10-21 10:39:21','2021-09-10'),
(568,3,2,41,'2021-09-10 13:45:00','2021-09-10 14:00:00',900,'Riconsegnato pc client Syntex\r\nRiconsegnato UPS APC Gulli\r\nUtilizzata batteria apc 4,5 Ah',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-10-21 15:21:04','2021-09-10'),
(569,3,2,104,'2021-09-10 14:45:00','2021-09-10 15:15:00',1800,'Consegna e installazione nuova stampante Brother \r\nConsegna e installazione 2 tamburi Brother',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-22 14:47:16','2021-09-10'),
(570,3,2,5,'2021-09-13 10:15:00','2021-09-13 10:25:00',600,'Ritirato pc client Contabilità per assistenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-10-21 10:39:22','2021-09-13'),
(571,3,1,41,'2021-09-13 13:10:00','2021-09-13 13:40:00',1800,'Assistenza su pc client Linda per problemi posta elettronica',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-10-21 15:21:07','2021-09-13'),
(572,3,1,96,'2021-09-13 13:50:00','2021-09-13 14:50:00',3600,'Assistenza su pc client Antonella per problemi posta elettronica',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-23 08:36:27','2021-09-13'),
(573,3,4,5,'2021-09-13 15:00:00','2021-09-13 16:00:00',3600,'Assistenza su pc client Contabilità, clonazione s.o su ssd\r\nUtilizzato: SSD 1tb Crucial',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-10-21 10:39:24','2021-09-13'),
(574,1,3,112,'2021-09-14 06:30:00','2021-09-14 07:30:00',3600,NULL,45,NULL,45,1,'Europe/Rome',45,1,'work','2021-09-22 09:44:36','2021-09-14'),
(575,1,4,3,'2021-09-14 07:34:00','2021-09-14 08:25:00',3060,'per notebook acli',38.25,NULL,45,1,'Europe/Rome',38.25,1,'work','2021-10-22 09:27:18','2021-09-14'),
(576,1,1,2,'2021-09-14 09:05:00','2021-09-14 09:35:00',1800,'problemi mail nicolò',22.5,NULL,45,1,'Europe/Rome',22.5,1,'work','2021-11-17 14:38:21','2021-09-14'),
(577,3,1,32,'2021-09-14 08:20:00','2021-09-14 08:45:00',1500,'Assistenza su pc client Daniela per problimi posta elettronica',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-22 10:18:40','2021-09-14'),
(578,3,1,95,'2021-09-14 08:50:00','2021-09-14 09:00:00',600,'Installate 2 licenze nod32 aggiornamento su 4 pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-21 15:29:24','2021-09-14'),
(579,3,1,51,'2021-09-14 09:05:00','2021-09-14 09:25:00',1200,'Installate 2 licenze nod32 aggiornamento su 4 pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-16 15:26:25','2021-09-14'),
(580,3,1,24,'2021-09-14 09:30:00','2021-09-14 09:40:00',600,'Installata 1 licenza nod32 aggiornamento su 2 pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-22 09:31:57','2021-09-14'),
(581,1,1,22,'2021-09-14 12:42:00','2021-09-14 14:34:00',6720,'vpn e indicizzazione file',84,NULL,45,1,'Europe/Rome',84,1,'work','2021-10-22 07:34:22','2021-09-14'),
(582,1,3,112,'2021-09-14 14:35:00','2021-09-14 15:00:00',1500,NULL,18.75,NULL,45,1,'Europe/Rome',18.75,1,'work','2021-09-22 09:44:37','2021-09-14'),
(583,3,1,96,'2021-09-14 10:15:00','2021-09-14 10:30:00',900,'Assistenza su pc client Antonella',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-23 08:36:28','2021-09-14'),
(584,3,1,64,'2021-09-14 16:15:00','2021-09-14 16:35:00',1200,'Fatto e inviato backup software OSM',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-17 15:57:46','2021-09-14'),
(585,1,3,112,'2021-09-15 06:30:00','2021-09-15 08:13:00',6180,NULL,77.25,NULL,45,1,'Europe/Rome',77.25,1,'work','2021-09-22 09:44:38','2021-09-15'),
(586,3,2,104,'2021-09-15 07:00:00','2021-09-15 07:40:00',2400,'Assistenza su server per problemi posta elettronica, sostituzione batteria controller 3ware su server\r\nAssistenza su pc client Denise',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-22 14:47:17','2021-09-15'),
(587,3,2,104,'2021-09-15 08:00:00','2021-09-15 08:20:00',1200,'Assistenza su Vodafone station che navigava in 4g',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-22 14:47:19','2021-09-15'),
(588,3,1,41,'2021-09-15 08:30:00','2021-09-15 08:50:00',1200,'Assistenza su pc client Luana per archiviazione  posta',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-10-21 15:21:08','2021-09-15'),
(589,3,1,45,'2021-09-15 08:55:00','2021-09-15 09:15:00',1200,'Installate 2 licenze nod32 aggiornamento su 4 pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-15 15:51:35','2021-09-15'),
(590,3,1,79,'2021-09-15 09:25:00','2021-09-15 10:25:00',3600,'Fatto schema per relazione ISO',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-29 17:01:29','2021-09-15'),
(591,1,1,22,'2021-09-15 08:30:00','2021-09-15 08:49:00',1140,'per vpn',14.25,NULL,45,1,'Europe/Rome',14.25,1,'work','2021-10-22 07:34:23','2021-09-15'),
(592,1,1,22,'2021-09-15 09:00:00','2021-09-15 10:43:00',6180,'per ricerca non funzionante e indicizzazione',77.25,NULL,45,1,'Europe/Rome',77.25,1,'work','2021-10-22 07:34:25','2021-09-15'),
(593,1,2,26,'2021-09-15 13:04:00','2021-09-15 14:32:00',5280,'per ritiro ipad e iphone da configurare',66,NULL,45,1,'Europe/Rome',66,1,'work','2021-10-31 11:09:13','2021-09-15'),
(594,1,1,26,'2021-09-15 14:57:00','2021-09-15 17:10:00',7980,'configurazione ipad e iphone per banci',99.75,NULL,45,1,'Europe/Rome',99.75,1,'work','2021-10-31 11:40:34','2021-09-15'),
(595,1,1,96,'2021-09-16 14:43:00','2021-09-16 15:48:00',3900,'problemi posta',48.75,NULL,45,1,'Europe/Rome',48.75,1,'work','2021-09-23 08:17:25','2021-09-16'),
(596,1,1,79,'2021-09-16 06:37:00','2021-09-16 07:31:00',3240,'problemi vm dopo salto corrente',40.5,NULL,45,1,'Europe/Rome',40.5,1,'work','2021-11-29 17:01:35','2021-09-16'),
(597,1,1,26,'2021-09-16 07:51:00','2021-09-16 10:30:00',9540,'configurazione ipad e iphone simona',119.25,NULL,45,1,'Europe/Rome',119.25,1,'work','2021-10-31 11:40:35','2021-09-16'),
(598,3,2,56,'2021-09-16 08:05:00','2021-09-16 08:35:00',1800,'Sostituzione batteria su UPS APC 500',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-23 15:47:06','2021-09-16'),
(599,3,2,50,'2021-09-16 08:55:00','2021-09-16 09:10:00',900,'Ritiro portatile Francesco per clonazione e sostituzione SSD',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-17 08:34:56','2021-09-16'),
(600,3,2,79,'2021-09-16 12:40:00','2021-09-16 12:50:00',600,'Consegna cartucce Epson',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-24 14:19:58','2021-09-16'),
(601,3,2,50,'2021-09-16 13:30:00','2021-09-16 14:00:00',1800,'Riconsegnato portatile Francesco dopo assistenza \r\nAssistenza su portatile Loretta\r\nRitirato portatile Francesco casa per assistenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-17 08:34:58','2021-09-16'),
(602,3,2,80,'2021-09-16 14:35:00','2021-09-16 15:10:00',2100,'Assistenza su server per problemi navigazione\r\nAssistenza su pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-06 11:08:09','2021-09-16'),
(603,3,1,79,'2021-09-16 06:45:00','2021-09-16 07:00:00',900,'Assistenza per riavvio vm dopo mancanza corrente',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-29 17:01:31','2021-09-16'),
(604,3,4,50,'2021-09-16 09:40:00','2021-09-16 10:40:00',3600,'Clonato s.o portatile Francesco su nuovo SSD\r\nUtilizzato: SSD 1 tb Crucial',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-17 08:34:57','2021-09-16'),
(605,3,4,50,'2021-09-16 16:00:00','2021-09-16 16:30:00',1800,'Aggiunto SSD 1 tb WD Blue + spostamento dati su portatile Francesco casa',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-17 08:34:59','2021-09-16'),
(606,1,2,26,'2021-09-17 07:10:00','2021-09-17 09:14:00',7440,'riconsegna iphone e ipad configurati,  ultimatel e ultime configurazioni',93,NULL,45,1,'Europe/Rome',93,1,'work','2021-10-31 11:40:37','2021-09-17'),
(607,1,2,50,'2021-09-17 09:40:00','2021-09-17 10:13:00',1980,'riconsegna portatile francesco, problemi pc loretta',24.75,NULL,45,1,'Europe/Rome',24.75,1,'work','2021-11-17 17:15:34','2021-09-17'),
(608,1,1,3,'2021-09-16 15:50:00','2021-09-16 16:49:00',3540,'ricerca virus per test mail',44.25,NULL,45,1,'Europe/Rome',44.25,1,'work','2021-10-22 09:27:19','2021-09-16'),
(609,1,1,90,'2021-09-17 12:47:00','2021-09-17 13:10:00',1380,'problemi visualizzazione immagini e pdf flavio',17.25,NULL,45,1,'Europe/Rome',17.25,1,'work','2021-09-23 16:13:27','2021-09-17'),
(610,1,1,87,'2021-09-17 13:54:00','2021-09-17 15:01:16',4036,'problema posta pc Chiara',50.45,NULL,45,1,'Europe/Rome',50.45,1,'work','2022-02-10 13:19:02','2021-09-17'),
(611,3,2,1,'2021-09-17 13:25:00','2021-09-17 13:40:00',900,'Ritirato PC client  Alberto per assistenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-21 10:47:09','2021-09-17'),
(612,3,1,61,'2021-09-17 07:35:00','2021-09-17 07:45:00',600,'Installata 1 licenza nod32 aggiornamento su 1 pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-21 15:42:01','2021-09-17'),
(613,3,1,101,'2021-09-17 08:30:00','2021-09-17 09:15:00',2700,'Assistenza per problemi mail inviate che finiscono in spam\r\nCreata e configurata nuova mail',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-10-22 09:21:57','2021-09-17'),
(614,1,2,3,'2021-09-20 07:15:00','2021-09-20 10:00:00',9900,'riconsegna pc aldo rapallo\r\nincontro da abvolt per problemi avuti nei mesi scorsi',123.75,NULL,45,1,'Europe/Rome',123.75,1,'work','2021-10-22 09:27:19','2021-09-20'),
(615,1,1,50,'2021-09-20 14:00:00','2021-09-20 16:02:00',7320,'analisi nextcloud per degoogle tel francesco, e per spazio cloud interno\r\nrecupero file per elisabetta\r\nrecupero dropbox francesco cancellato per errore il 18-9',91.5,NULL,45,1,'Europe/Rome',91.5,1,'work','2021-11-17 17:15:33','2021-09-20'),
(616,1,4,3,'2021-09-20 13:16:00','2021-09-20 13:45:00',1740,NULL,21.75,NULL,45,1,'Europe/Rome',21.75,1,'work','2021-10-22 09:27:20','2021-09-20'),
(617,1,1,103,'2021-09-20 16:04:00','2021-09-20 16:26:00',1320,'rimozione blacklist',16.5,NULL,45,1,'Europe/Rome',16.5,1,'work','2021-12-03 17:12:46','2021-09-20'),
(618,3,4,1,'2021-09-20 06:30:00','2021-09-20 08:00:00',5400,'Assistenza su pc client Alberto per problemi schermata blu\r\nClonato s.o su nuovo SSD\r\nUtilizzato: SSD 480gb crucial + 8 gb DDR4 usata',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-21 10:47:10','2021-09-20'),
(619,3,1,96,'2021-09-20 08:10:00','2021-09-20 08:25:00',900,'Assistenza per collegare cavi al pc causa UPS',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-23 08:25:49','2021-09-20'),
(620,3,2,95,'2021-09-20 10:20:00','2021-09-20 10:30:00',600,'Consegna e installazione 2 mouse wireless 840545',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-21 15:29:25','2021-09-20'),
(621,3,1,24,'2021-09-20 09:40:00','2021-09-20 09:50:00',600,'Assistenza per problemi con certificato di posta',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-22 09:31:59','2021-09-20'),
(622,3,1,41,'2021-09-20 15:20:00','2021-09-20 16:20:00',3600,'Installazione office 2019 su pc client Cinzia',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-10-21 15:21:09','2021-09-20'),
(623,1,1,2,'2021-09-21 06:48:00','2021-09-21 08:36:00',6480,'manutenzione server e ups',81,NULL,45,1,'Europe/Rome',81,1,'work','2021-11-17 14:38:20','2021-09-21'),
(624,1,1,4,'2021-09-21 08:53:00','2021-09-21 09:30:00',2220,'inizio mappa rete',27.75,NULL,45,1,'Europe/Rome',27.75,1,'work','2021-09-23 06:18:46','2021-09-21'),
(625,1,1,90,'2021-09-21 09:42:00','2021-09-21 10:26:00',2640,'agg server',33,NULL,45,1,'Europe/Rome',33,1,'work','2021-09-23 16:13:28','2021-09-21'),
(626,1,1,90,'2021-09-21 12:43:00','2021-09-21 13:08:00',1500,'agg server',18.75,NULL,45,1,'Europe/Rome',18.75,1,'work','2021-09-23 16:13:30','2021-09-21'),
(627,1,6,51,'2021-09-21 13:21:00','2021-09-21 15:00:00',5940,'per collegamneto remoto',74.25,NULL,45,1,'Europe/Rome',74.25,1,'work','2021-11-17 17:12:22','2021-09-21'),
(628,1,1,3,'2021-09-21 15:13:00','2021-09-21 15:45:00',1920,'openvpn gui web',24,NULL,45,1,'Europe/Rome',24,1,'work','2021-10-22 09:27:20','2021-09-21'),
(629,1,1,81,'2021-09-21 15:48:00','2021-09-21 16:40:39',3159,'configurazioni traslocco linea',39.49,NULL,45,1,'Europe/Rome',39.49,1,'work','2021-09-22 14:57:34','2021-09-21'),
(630,3,2,104,'2021-09-21 07:15:00','2021-09-21 07:45:00',1800,'Assistenza su pc client Sandro per problemi driver scheda video',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-22 14:47:20','2021-09-21'),
(631,3,2,10,'2021-09-21 13:00:00','2021-09-21 13:30:00',1800,'Sopralluogo per verificare come predisporre nuova postazione corsi\r\nModifiche da fare entro il 19/10',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-10-08 14:53:54','2021-09-21'),
(632,3,2,81,'2021-09-21 13:50:00','2021-09-21 14:50:00',3600,'Ricollegati tutti i dispositivi nel nuovo ufficio, da testare dopo configurazione nuovo router da parte dell\'operatore',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-22 14:57:33','2021-09-21'),
(633,3,2,96,'2021-09-21 15:15:00','2021-09-21 17:30:00',8100,'Consegna toner per stampante HP\r\nSostituzione batteria UPS Federica\r\nSostituzione batteria controller su server Gandolfo1 e Gandolfo2',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-23 08:36:29','2021-09-21'),
(634,1,1,58,'2021-09-22 07:38:00','2021-09-22 08:07:00',1740,'webmeet carcere',21.75,NULL,45,1,'Europe/Rome',21.75,1,'work','2021-09-24 15:33:06','2021-09-22'),
(635,3,1,26,'2021-09-22 07:45:00','2021-09-22 07:55:00',600,'Assistenza per recupero password wifi ospiti',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-10-25 15:50:25','2021-09-22'),
(636,3,1,96,'2021-09-22 08:50:00','2021-09-22 09:20:00',1800,'Assistenza su pc client Gandolfo per problemi con stampante Epson\r\nDa verificare in loco',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-23 08:36:30','2021-09-22'),
(637,3,4,104,'2021-09-22 09:30:00','2021-09-22 10:00:00',1800,'Assistenza su portatile Agente \r\nUtilizzato: alimentatore non originale',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-09-22 14:47:21','2021-09-22'),
(638,3,1,32,'2021-09-22 13:00:00','2021-09-22 13:20:00',1200,'Assistenza su pc client Sara per problemi posta (devono contattare Tiscali)',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-06 16:36:54','2021-09-22'),
(639,1,2,41,'2021-09-23 06:40:00','2021-09-23 07:06:00',1560,'sopraluogo per spostamento server in armadio',19.5,NULL,45,1,'Europe/Rome',19.5,1,'work','2021-10-21 15:21:10','2021-09-23'),
(640,1,1,50,'2021-09-23 07:17:00','2021-09-23 07:25:00',480,'problemi spazio disco server',6,NULL,45,1,'Europe/Rome',6,1,'work','2021-11-17 17:15:20','2021-09-23'),
(641,1,1,96,'2021-09-21 16:41:00','2021-09-21 16:58:00',1020,'fede li dopo sostituzione batteria controller problemi con servizi',12.75,NULL,45,1,'Europe/Rome',12.75,1,'work','2021-09-23 08:17:22','2021-09-21'),
(642,1,1,108,'2021-09-23 12:48:00','2021-09-23 13:07:01',1141,'problema stampa biglietteria',14.26,NULL,45,1,'Europe/Rome',14.26,1,'work','2022-02-22 10:20:25','2021-09-23'),
(643,1,6,51,'2021-09-23 13:07:06','2021-09-23 13:15:53',527,'per collegamneto remoto',6.59,NULL,45,1,'Europe/Rome',6.59,1,'work','2021-11-17 17:00:15','2021-09-23'),
(644,1,1,67,'2021-09-02 14:01:00','2021-09-02 16:24:00',8580,'manutenzione dopo aumento disco per backup remoto non funzionante',107.25,NULL,45,1,'Europe/Rome',107.25,1,'work','2021-09-27 10:24:03','2021-09-02'),
(645,1,1,81,'2021-09-03 06:42:00','2021-09-03 08:00:00',4680,'agg server',58.5,NULL,45,1,'Europe/Rome',58.5,1,'work','2021-11-03 17:21:40','2021-09-03'),
(646,1,1,3,'2021-09-03 08:14:00','2021-09-03 09:00:00',2760,'nas rosario',34.5,NULL,45,1,'Europe/Rome',34.5,1,'work','2021-10-22 09:27:16','2021-09-03'),
(647,1,1,64,'2021-09-03 09:17:00','2021-09-03 09:49:00',1920,'per openstamanager',24,NULL,45,1,'Europe/Rome',24,1,'work','2021-11-17 15:57:43','2021-09-03'),
(648,1,1,5,'2021-09-03 10:00:00','2021-09-03 10:30:00',1800,'agg hyper-v per gestione win2k',22.5,NULL,45,1,'Europe/Rome',22.5,1,'work','2021-10-21 10:39:20','2021-09-03'),
(649,1,1,51,'2021-09-03 12:40:00','2021-09-03 15:00:00',8400,'problemi permessi share \r\nagg win server',105,NULL,45,1,'Europe/Rome',105,1,'work','2021-11-17 17:11:03','2021-09-03'),
(650,1,1,2,'2021-09-03 15:14:00','2021-09-03 16:23:00',4140,'problemi sito',51.75,NULL,45,1,'Europe/Rome',51.75,1,'work','2021-11-17 14:38:16','2021-09-03'),
(651,1,1,58,'2021-09-23 07:38:00','2021-09-23 08:00:00',1320,'problemi webmeet carcere',16.5,NULL,45,1,'Europe/Rome',16.5,1,'work','2021-09-24 15:33:07','2021-09-23'),
(652,1,1,50,'2021-09-23 08:07:00','2021-09-23 10:15:00',7680,'problemi spazio disco server',96,NULL,45,1,'Europe/Rome',96,1,'work','2021-11-17 17:15:32','2021-09-23'),
(653,3,2,95,'2021-09-23 07:50:00','2021-09-23 08:20:00',1800,'Verificato e ritirato pc client Anna per assistenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-10-21 08:49:52','2021-09-23'),
(654,3,4,95,'2021-09-23 13:00:00','2021-09-23 14:00:00',3600,'Assistenza su pc client Anna\r\nUtilizzato: hhd 2tb + 4 gb ddr3 usata',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-10-21 08:49:53','2021-09-23'),
(655,3,2,95,'2021-09-23 15:00:00','2021-09-23 15:40:00',2400,'Riconsegnato pc client Anna\r\nVerificato problema su pc client Silvia',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-10-21 08:49:54','2021-09-23'),
(656,1,1,95,'2021-09-24 09:20:00','2021-09-24 10:29:00',4140,'problemi profilo silvia',51.75,NULL,45,1,'Europe/Rome',51.75,1,'work','2021-10-21 08:49:54','2021-09-24'),
(657,3,1,64,'2021-09-24 06:30:00','2021-09-24 06:45:00',900,'Assistenza per collegare direttamente il server a corrente causa UPS da rigenerare',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-17 15:57:46','2021-09-24'),
(658,3,1,81,'2021-09-24 06:45:00','2021-09-24 07:15:00',1800,'Assistenza per problemi ricezione posta alias',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-03 17:21:41','2021-09-24'),
(659,3,1,17,'2021-09-24 14:15:00','2021-09-24 15:15:00',3600,'Assistenza per problemi collegamento in rdp utilizzando la VPN, problema da risolvere',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-10-20 16:21:48','2021-09-24'),
(660,3,1,96,'2021-09-24 15:30:00','2021-09-24 15:45:00',900,'Assistenza per problemi collegamento al MIP',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-17 17:33:09','2021-09-24'),
(661,3,2,79,'2021-09-24 07:30:00','2021-09-24 10:30:00',10800,'Scalare ore',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-24 16:51:05','2021-09-24'),
(662,1,1,5,'2021-09-27 07:43:00','2021-09-27 08:45:55',3775,'per macchinare con upload su cloud',47.19,NULL,45,1,'Europe/Rome',47.19,1,'work','2021-10-21 10:39:24','2021-09-27'),
(663,1,1,50,'2021-09-27 06:45:00','2021-09-27 07:00:00',900,'degoogled android studio',11.25,NULL,45,1,'Europe/Rome',11.25,1,'work','2021-11-17 17:15:31','2021-09-27'),
(664,1,1,50,'2021-09-27 09:01:00','2021-09-27 09:22:00',1260,'degoogled android studio',15.75,NULL,45,1,'Europe/Rome',15.75,1,'work','2021-11-17 17:15:18','2021-09-27'),
(665,1,3,112,'2021-09-27 10:15:00','2021-09-27 10:30:00',900,NULL,11.25,NULL,45,1,'Europe/Rome',11.25,1,'work','2021-11-22 10:35:41','2021-09-27'),
(666,1,1,5,'2021-09-27 09:35:00','2021-09-27 10:10:00',2100,'problemik dopo abilitazione onedrive su software di taglio',26.25,NULL,45,1,'Europe/Rome',26.25,1,'work','2021-10-21 10:39:25','2021-09-27'),
(667,1,1,104,'2021-09-27 07:00:00','2021-09-27 07:23:00',1380,'problemi posta',17.25,NULL,45,1,'Europe/Rome',17.25,1,'work','2021-11-03 10:46:17','2021-09-27'),
(668,1,1,50,'2021-09-27 07:30:00','2021-09-27 07:42:00',720,'degoogled android studio',9,NULL,45,1,'Europe/Rome',9,1,'work','2021-11-17 17:15:30','2021-09-27'),
(669,1,1,96,'2021-09-28 07:30:00','2021-09-28 07:45:35',935,'problema apertura pdf',11.69,NULL,45,1,'Europe/Rome',11.69,1,'work','2021-11-17 17:33:10','2021-09-28'),
(670,3,2,64,'2021-09-27 07:55:00','2021-09-27 08:25:00',1800,'Sostituzione 2 batterie su UPS APC 1400',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-17 15:57:48','2021-09-27'),
(671,3,1,104,'2021-09-27 07:15:00','2021-09-27 07:25:00',600,'Assistenza per problema navigazione con USB Vodafone',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-10 10:24:33','2021-09-27'),
(672,3,1,24,'2021-09-27 07:30:00','2021-09-27 07:45:00',900,'Assistenza per problema vm Oltre3d spenta',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-02 10:55:04','2021-09-27'),
(673,3,1,41,'2021-09-27 08:45:00','2021-09-27 09:10:00',1500,'Configurazione nuovo indirizzo mail su pc client Ilaria',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-10-21 15:21:12','2021-09-27'),
(674,3,2,41,'2021-09-27 12:30:00','2021-09-27 12:50:00',1200,'Sopralluogo con gli elettricisti presso la sede di Ceranesi',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-10-21 14:19:15','2021-09-27'),
(675,3,2,24,'2021-09-28 06:30:00','2021-09-28 06:45:00',900,'Consegna e installazione box manutenzione su stampante Epson',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-02 14:42:19','2021-09-28'),
(676,3,2,41,'2021-09-28 08:35:00','2021-09-28 09:05:00',1800,'Assistenza su pc client Syntex per collegamento disco di backup\r\nAssistenza su pc client Franca\r\nRitirato vecchio pc client Gulli per prove con Autocad',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-10-21 15:21:13','2021-09-28'),
(677,3,2,1,'2021-09-28 13:00:00','2021-09-28 15:45:00',9900,'Configurato pc client casa Roberta per essere utilizzato in ufficio da Andrea (finire in remoto config posta)\r\nSostituzione batteria controller su server',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-06 11:04:00','2021-09-28'),
(678,1,1,67,'2021-09-29 13:02:00','2021-09-29 14:48:00',6360,'backuyp remoto',79.5,NULL,45,1,'Europe/Rome',79.5,1,'work','2021-11-04 15:37:57','2021-09-29'),
(679,1,1,3,'2021-09-29 14:49:00','2021-09-29 16:40:00',6660,'pulizia nostri share',83.25,NULL,45,1,'Europe/Rome',83.25,1,'work','2021-10-22 09:27:24','2021-09-29'),
(680,1,1,22,'2021-09-30 07:52:00','2021-09-30 10:32:38',9638,'sistemazione vpn con irideos',120.48,NULL,45,1,'Europe/Rome',120.48,1,'work','2021-10-22 07:34:25','2021-09-30'),
(681,1,1,3,'2021-09-29 06:45:00','2021-09-29 10:28:00',13380,'proxmox backup server e zfs',167.25,NULL,45,1,'Europe/Rome',167.25,1,'work','2021-10-22 09:27:22','2021-09-29'),
(682,1,1,22,'2021-09-30 12:40:00','2021-09-30 13:01:00',1260,'sistemazione vpn con irideos\r\nconfigurazione vpn su pc di casa',15.75,NULL,45,1,'Europe/Rome',15.75,1,'work','2021-10-22 07:34:26','2021-09-30'),
(683,1,1,95,'2021-09-30 14:36:00','2021-09-30 16:30:00',6840,'agg server problemi di posta post aggiornamento',85.5,NULL,45,1,'Europe/Rome',85.5,1,'work','2021-10-21 07:37:14','2021-09-30'),
(684,1,1,67,'2021-09-22 08:11:00','2021-09-22 09:29:00',4680,'problema backup remoto',58.5,NULL,45,1,'Europe/Rome',58.5,1,'work','2021-11-04 15:37:55','2021-09-22'),
(685,1,1,26,'2021-09-22 09:42:00','2021-09-22 10:28:00',2760,'problemi wifi ospiti',34.5,NULL,45,1,'Europe/Rome',34.5,1,'work','2021-10-31 11:40:38','2021-09-22'),
(686,1,1,103,'2021-09-22 12:44:00','2021-09-22 14:27:00',6180,'blackilist su 3 liste',77.25,NULL,45,1,'Europe/Rome',77.25,1,'work','2021-12-03 17:12:47','2021-09-22'),
(687,3,2,43,'2021-09-29 07:25:00','2021-09-29 07:55:00',1800,'Assistenza su pc client Romina bloccato, problema dovuto ad aggiornamenti, risolto',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-10-14 15:00:34','2021-09-29'),
(688,1,4,3,'2021-09-22 06:30:00','2021-09-22 06:47:00',1020,NULL,12.75,NULL,45,1,'Europe/Rome',12.75,1,'work','2021-10-22 09:27:20','2021-09-22'),
(689,1,1,3,'2021-09-22 14:41:00','2021-09-22 16:23:00',6120,'proxmox backup server',76.5,NULL,45,1,'Europe/Rome',76.5,1,'work','2021-10-22 09:27:21','2021-09-22'),
(690,3,1,43,'2021-09-29 09:00:00','2021-09-29 09:15:00',900,'Assistenza  su pc client Romina per problemi con Firefox',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-10-14 15:00:36','2021-09-29'),
(691,3,1,6,'2021-09-29 09:50:00','2021-09-29 10:00:00',600,'Assistenza su pc client Pia per problemi scansione di rete',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-23 16:48:38','2021-09-29'),
(692,3,1,95,'2021-09-29 10:00:00','2021-09-29 10:30:00',1800,'Assistenza su pc client Anna per problemi posta elettronica',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-10-21 08:49:55','2021-09-29'),
(693,1,1,24,'2021-09-23 13:35:00','2021-09-23 15:13:00',5880,'agg centralino e vm',73.5,NULL,45,1,'Europe/Rome',73.5,1,'work','2021-12-02 10:55:05','2021-09-23'),
(694,3,1,24,'2021-09-29 12:40:00','2021-09-29 12:50:00',600,'Assistenza su pc client Monica',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-02 14:42:19','2021-09-29'),
(695,1,1,3,'2021-09-23 15:30:00','2021-09-23 16:30:00',3600,'proxmox backup server',45,NULL,45,1,'Europe/Rome',45,1,'work','2021-10-22 09:27:26','2021-09-23'),
(696,1,1,50,'2021-09-24 06:45:00','2021-09-24 09:09:00',8640,'problemi backup\r\ne backup vm proxmox',108,NULL,45,1,'Europe/Rome',108,1,'work','2021-11-17 17:15:39','2021-09-24'),
(697,3,1,95,'2021-09-29 12:50:00','2021-09-29 13:10:00',1200,'Assistenza su pc client Anna per problemi posta elettronica',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-10-21 08:49:57','2021-09-29'),
(698,1,1,3,'2021-09-24 15:50:00','2021-09-24 16:30:00',2400,'varie al tel con te',30,NULL,45,1,'Europe/Rome',30,1,'work','2021-10-22 09:27:21','2021-09-24'),
(699,3,1,17,'2021-09-29 14:55:00','2021-09-29 15:55:00',3600,'Assistenza su pc client Semino per problemi di collegamento da remoto, PC da ritirare',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-10-20 16:21:49','2021-09-29'),
(700,1,1,41,'2021-09-24 12:52:00','2021-09-24 15:17:00',8700,'agg server e spostamento alcune cartelle su altro share',108.75,NULL,45,1,'Europe/Rome',108.75,1,'work','2021-10-21 15:21:10','2021-09-24'),
(701,1,1,75,'2021-09-24 15:24:00','2021-09-24 15:46:00',1320,'agg nas',16.5,NULL,45,1,'Europe/Rome',16.5,1,'work','2021-11-29 15:39:42','2021-09-24'),
(702,3,1,75,'2021-09-29 16:20:00','2021-09-29 16:50:00',1800,'Spostata posta su pc client Oneto per problemi spazio partizione C',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-29 15:39:43','2021-09-29'),
(703,1,3,112,'2021-10-01 10:15:00','2021-10-01 10:30:00',900,NULL,11.25,NULL,45,1,'Europe/Rome',11.25,1,'work','2021-11-22 10:35:42','2021-10-01'),
(704,3,2,17,'2021-09-30 10:30:00','2021-09-30 10:40:00',600,'Ritirato pc client Semino per assistenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-10-20 16:21:50','2021-09-30'),
(705,1,3,112,'2021-10-01 12:30:00','2021-10-01 13:00:00',1800,NULL,22.5,NULL,45,1,'Europe/Rome',22.5,1,'work','2021-11-22 10:35:43','2021-10-01'),
(706,3,1,1,'2021-09-30 07:20:00','2021-09-30 08:50:00',5400,'Assistenza su pc client Francesco e Alessio per problema con stampante condivisa\r\nAssistenza per problema salvataggio PDF su Open manager',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-06 11:04:01','2021-09-30'),
(707,3,1,6,'2021-09-30 09:00:00','2021-09-30 09:15:00',900,'Assistenza su pc client Presidenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-23 16:48:39','2021-09-30'),
(708,1,4,3,'2021-09-28 12:30:00','2021-09-28 14:45:00',8100,'rimontaghgio e test su server jupiter, installato debian 11',101.25,NULL,45,1,'Europe/Rome',101.25,1,'work','2021-10-22 09:27:27','2021-09-28'),
(709,1,1,3,'2021-09-28 06:40:00','2021-09-28 07:15:00',2100,'problemi 3cx lab',26.25,NULL,45,1,'Europe/Rome',26.25,1,'work','2021-10-22 09:27:21','2021-09-28'),
(710,3,1,79,'2021-09-30 13:30:00','2021-09-30 13:50:00',1200,'Assistenza su pc client Andrea per problema download PDF',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-29 17:01:37','2021-09-30'),
(711,1,1,4,'2021-09-28 07:53:00','2021-09-28 09:00:00',4020,'raccolta dati per relazione',50.25,NULL,45,1,'Europe/Rome',50.25,1,'work','2021-12-06 16:37:31','2021-09-28'),
(712,3,1,10,'2021-09-30 15:00:00','2021-09-30 16:00:00',3600,'Assistenza per recupero cartella cancellata su Outlook',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-10-08 14:53:37','2021-09-30'),
(713,3,2,79,'2021-10-01 09:10:00','2021-10-01 10:30:00',4800,'Assistenza su stampante Samsung, da sostituire\r\nAssistenza su pc client Paolo per problemi con pst Outlook',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-29 17:01:31','2021-10-01'),
(714,1,1,1,'2021-09-28 15:30:00','2021-09-28 16:30:00',3600,'fede li, seguito io spegnimento e intanto agg vm 3cx verifica dopo riaccensione',45,NULL,45,1,'Europe/Rome',45,1,'work','2021-12-06 09:52:15','2021-09-28'),
(715,3,2,24,'2021-10-01 12:30:00','2021-10-01 12:55:00',1500,'Assistenza su stampante Epson Monica bloccata',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-02 14:42:20','2021-10-01'),
(716,1,1,5,'2021-09-28 15:01:00','2021-09-28 15:26:00',1500,'per dropbox remoto software di taglio',18.75,NULL,45,1,'Europe/Rome',18.75,1,'work','2021-10-21 10:39:27','2021-09-28'),
(717,1,1,5,'2021-09-28 09:14:00','2021-09-28 10:30:00',4560,'per dropbox remoto software taglio',57,NULL,45,1,'Europe/Rome',57,1,'work','2021-10-21 10:39:26','2021-09-28'),
(718,3,1,67,'2021-10-01 13:10:00','2021-10-01 13:20:00',600,'Assistenza per modifiche sulla posta',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-04 15:38:27','2021-10-01'),
(719,1,1,3,'2021-09-30 06:42:00','2021-09-30 07:37:00',3300,'fogli',41.25,NULL,45,1,'Europe/Rome',41.25,1,'work','2021-10-22 09:27:22','2021-09-30'),
(720,1,1,103,'2021-09-30 13:15:00','2021-09-30 13:32:00',1020,'verifica blacklist',12.75,NULL,45,1,'Europe/Rome',12.75,1,'work','2021-12-03 17:12:47','2021-09-30'),
(721,1,1,3,'2021-09-30 13:41:00','2021-09-30 14:28:00',2820,'proxmox backup server',35.25,NULL,45,1,'Europe/Rome',35.25,1,'work','2021-10-22 09:27:24','2021-09-30'),
(722,1,1,50,'2021-10-01 06:51:00','2021-10-01 10:01:00',11400,'problema vm windows spenta al mattino non sempre ma spesso',142.5,NULL,45,1,'Europe/Rome',142.5,1,'work','2021-11-17 17:15:30','2021-10-01'),
(723,1,1,50,'2021-10-01 14:14:00','2021-10-01 16:00:00',6360,'problema vm windows spenta al mattino non sempre ma spesso',79.5,NULL,45,1,'Europe/Rome',79.5,1,'work','2021-11-17 17:15:10','2021-10-01'),
(724,1,1,5,'2021-10-01 13:11:00','2021-10-01 14:00:00',2940,'problem dropbox remoto',36.75,NULL,45,1,'Europe/Rome',36.75,1,'work','2021-10-21 10:39:28','2021-10-01'),
(725,1,1,95,'2021-10-01 16:00:00','2021-10-01 17:12:00',4320,'problema popsta anna dopo intervento fede',54,NULL,45,1,'Europe/Rome',54,1,'work','2021-10-21 08:49:58','2021-10-01'),
(726,1,1,22,'2021-10-04 12:33:00','2021-10-04 12:43:28',628,'port forwarding',7.85,NULL,45,1,'Europe/Rome',7.85,1,'work','2021-10-22 07:34:28','2021-10-04'),
(727,1,1,55,'2021-10-04 13:09:00','2021-10-04 14:12:08',3788,'aggiornamento aquila 15',47.35,NULL,45,1,'Europe/Rome',47.35,1,'work','2021-12-28 16:26:30','2021-10-04'),
(728,1,1,4,'2021-10-04 14:24:00','2021-10-04 16:09:09',6309,'relazione',78.86,NULL,45,1,'Europe/Rome',78.86,1,'work','2021-12-06 16:37:33','2021-10-04'),
(729,1,1,3,'2021-10-04 06:44:00','2021-10-04 09:34:00',10200,'aggiornamento 3cx debian 9 a debian 10',127.5,NULL,45,1,'Europe/Rome',127.5,1,'work','2021-10-22 09:27:27','2021-10-04'),
(730,3,1,96,'2021-09-06 08:50:00','2021-09-06 09:05:00',900,'Assistenza su pc client Antonella per salvataggio mail',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-04 09:42:52','2021-09-06'),
(731,3,2,79,'2021-09-14 13:45:00','2021-09-14 14:30:00',2700,'Consegna e installazione licenza Win 10 su PC client Andrea\r\nInstallate 2 licenze NOD32 aggiornamento su 4 PC client\r\nVerifica tastiera wireless Andrea\r\nVerifica tutti dispositivi hw per relazione ISO',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-29 17:01:28','2021-09-14'),
(732,3,2,104,'2021-10-04 07:00:00','2021-10-04 07:20:00',1200,'Assistenza per problemi posta elettronica, il server era spento',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-03 10:46:18','2021-10-04'),
(733,3,1,103,'2021-10-04 07:25:00','2021-10-04 07:35:00',600,'Assistenza per problemi posta elettronica, riavviati servizi di posta su server',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-03 16:47:41','2021-10-04'),
(734,3,1,17,'2021-10-04 09:35:00','2021-10-04 09:55:00',1200,'Assistenza su portatile Semino per collegamento stampanti e Condivisi',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-10-20 16:21:51','2021-10-04'),
(735,3,1,26,'2021-10-04 10:00:00','2021-10-04 10:30:00',1800,'Assistenza su portatile casa Banci per problemi con antivirus e Outlook',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-10-31 11:40:39','2021-10-04'),
(736,3,4,17,'2021-10-04 12:30:00','2021-10-04 14:00:00',5400,'Reinstallato s.o su pc client Semino + ripristino Office e backup\r\nUtilizzato: SSD 480ghb S3+',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-10-20 16:21:52','2021-10-04'),
(737,3,1,26,'2021-10-04 14:20:00','2021-10-04 15:00:00',2400,'Assistenza su portatile casa Banci per Outlook bloccato',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-10-31 11:40:40','2021-10-04'),
(738,3,1,10,'2021-10-04 15:00:00','2021-10-04 15:30:00',1800,'Assistenza su pc client Francesca per recupero mail cancellate',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-10-08 14:53:38','2021-10-04'),
(739,1,1,58,'2021-10-05 06:44:00','2021-10-05 08:22:00',5880,'problemi in carcere di navigazione su azienda-online',73.5,NULL,45,1,'Europe/Rome',73.5,1,'work','2022-05-04 14:34:12','2021-10-05'),
(740,1,1,2,'2021-10-05 08:23:00','2021-10-05 08:27:39',279,'pdfsam',3.49,NULL,45,1,'Europe/Rome',3.49,1,'work','2021-11-17 14:38:25','2021-10-05'),
(741,1,1,1,'2021-09-10 15:02:00','2021-09-10 16:28:00',5160,'agg antismpa antivirus e hmail',64.5,NULL,45,1,'Europe/Rome',64.5,1,'work','2021-12-06 11:03:59','2021-09-10'),
(742,1,1,3,'2021-09-13 13:45:00','2021-09-13 16:23:00',9480,'proxmox',118.5,NULL,45,1,'Europe/Rome',118.5,1,'work','2021-10-22 09:27:17','2021-09-13'),
(743,1,1,2,'2021-09-14 15:09:00','2021-09-14 16:28:00',4740,'problemi segnalati nicolò',59.25,NULL,45,1,'Europe/Rome',59.25,1,'work','2021-11-17 14:38:24','2021-09-14'),
(744,1,1,26,'2021-09-16 12:52:00','2021-09-16 14:19:00',5220,'configurazione ipad',65.25,NULL,45,1,'Europe/Rome',65.25,1,'work','2021-10-31 11:40:36','2021-09-16'),
(745,1,1,87,'2021-09-17 15:17:00','2021-09-17 16:28:00',4260,'agg prog pc chiara',53.25,NULL,45,1,'Europe/Rome',53.25,1,'work','2022-02-10 13:19:01','2021-09-17'),
(746,1,1,67,'2021-09-27 12:48:00','2021-09-27 15:00:00',7920,'problemi backup remoto',99,NULL,45,1,'Europe/Rome',99,1,'work','2021-11-04 15:37:56','2021-09-27'),
(748,1,1,3,'2021-09-27 15:13:00','2021-09-27 16:22:00',4140,'proxmox',51.75,NULL,45,1,'Europe/Rome',51.75,1,'work','2021-10-22 09:27:32','2021-09-27'),
(749,1,1,3,'2021-10-05 08:41:00','2021-10-05 10:30:00',6540,'egroup copia su doku, test nextcloud, vm per backup egroup.',81.75,NULL,45,1,'Europe/Rome',81.75,1,'work','2021-10-22 09:27:24','2021-10-05'),
(750,1,1,3,'2021-10-05 12:43:00','2021-10-05 16:30:00',13620,'egroup copia su doku, test nextcloud, vm per backup egroup.\r\nfogli',170.25,NULL,45,1,'Europe/Rome',170.25,1,'work','2021-10-22 09:27:23','2021-10-05'),
(751,1,1,3,'2021-10-06 06:42:00','2021-10-06 09:29:00',10020,'problema aggiornamenti 3cx su vm lxc debian',125.25,NULL,45,1,'Europe/Rome',125.25,1,'work','2021-10-22 09:27:23','2021-10-06'),
(752,1,1,5,'2021-10-06 09:49:00','2021-10-06 10:50:00',3660,'problemi con sincro creazioens cript e prove',45.75,NULL,45,1,'Europe/Rome',45.75,1,'work','2021-10-21 10:39:29','2021-10-06'),
(753,1,3,112,'2021-10-06 12:30:00','2021-10-06 12:52:00',1320,NULL,16.5,NULL,45,1,'Europe/Rome',16.5,1,'work','2021-11-22 10:35:44','2021-10-06'),
(754,1,1,50,'2021-10-06 12:54:00','2021-10-06 15:02:16',7696,'problema vm arxivar spenta',96.2,NULL,45,1,'Europe/Rome',96.2,1,'work','2021-11-17 17:15:29','2021-10-06'),
(755,1,1,108,'2021-10-06 15:06:00','2021-10-06 16:54:00',6480,'prob pc alòessia\r\npulizia disco vm pieno',81,NULL,45,1,'Europe/Rome',81,1,'work','2022-02-22 10:20:28','2021-10-06'),
(756,1,1,108,'2021-10-07 13:08:00','2021-10-07 13:26:00',1080,'problemi posta certificata barbara',13.5,NULL,45,1,'Europe/Rome',13.5,1,'work','2022-02-22 10:20:34','2021-10-07'),
(757,1,6,50,'2021-10-07 13:33:00','2021-10-07 14:45:00',4320,'con enrico arxivar per problema servizio',54,NULL,45,1,'Europe/Rome',54,1,'work','2021-11-17 17:15:28','2021-10-07'),
(758,1,1,5,'2021-10-08 07:22:00','2021-10-08 08:31:09',4149,'script per copia file cloud',51.86,NULL,45,1,'Europe/Rome',51.86,1,'work','2021-10-21 10:39:30','2021-10-08'),
(759,1,1,1,'2021-10-08 08:43:00','2021-10-08 10:25:54',6174,'cancellata cartella mail',77.18,NULL,45,1,'Europe/Rome',77.18,1,'work','2021-12-06 11:04:04','2021-10-08'),
(760,1,1,50,'2021-10-08 16:00:00','2021-10-08 17:00:28',3628,'problema neido',45.35,NULL,45,1,'Europe/Rome',45.35,1,'work','2021-11-17 17:15:17','2021-10-08'),
(761,3,2,17,'2021-10-05 08:15:00','2021-10-05 08:15:00',0,'Riconsegnato e configurato pc client  Semino dopo reinstallazione',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-10-20 16:21:54','2021-10-05'),
(762,3,2,96,'2021-10-05 09:45:00','2021-10-05 10:30:00',2700,'Assistenza su stampante HP Gandolfo\r\nAssistenza su pc client Anna per problemi con pdf/a',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-17 17:33:11','2021-10-05'),
(763,3,2,1,'2021-10-05 10:40:00','2021-10-05 10:50:00',600,'Ritirato vecchio pc client Andrea',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-06 11:04:02','2021-10-05'),
(764,3,1,41,'2021-10-05 07:05:00','2021-10-05 07:15:00',600,'Assistenza su pc client Luana per problemi con stampante ad aghi',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-10-21 15:21:14','2021-10-05'),
(765,3,2,22,'2021-10-06 08:20:00','2021-10-06 09:00:00',2400,'Assistenza su pc client Stefano per problemi aggiornamento a Win 11, il pc andrà reinstallato',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-10-22 07:34:29','2021-10-06'),
(766,3,2,24,'2021-10-06 09:40:00','2021-10-06 09:50:00',600,'Ritirata stampante Epson per assistenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-02 14:42:21','2021-10-06'),
(767,3,2,108,'2021-10-06 15:50:00','2021-10-06 16:00:00',600,'Ritirato pc client per assistenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-22 10:20:30','2021-10-06'),
(768,3,1,41,'2021-10-06 07:05:00','2021-10-06 07:50:00',2700,'Assistenza su pc  client Paolo',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-10-21 15:21:15','2021-10-06'),
(769,3,4,41,'2021-10-06 13:00:00','2021-10-06 14:00:00',3600,'Reinstallazione vecchio pc client Gulli e installazione AutoCAD',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-10-21 15:21:16','2021-10-06'),
(770,3,1,96,'2021-10-07 07:20:00','2021-10-07 08:00:00',2400,'Assistenza per problemi collegamento alla vm di AGO',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-04 08:52:43','2021-10-07'),
(771,3,1,79,'2021-10-07 09:30:00','2021-10-07 09:40:00',600,'Assistenza su pc client Elena per problemi con file excel',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-29 17:01:39','2021-10-07'),
(772,3,4,108,'2021-10-07 12:30:00','2021-10-07 13:30:00',3600,'Assistenza su pc client Daniela\r\nUtilizzato: ssd 480 gb s3+',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-22 10:20:33','2021-10-07'),
(773,3,2,6,'2021-10-08 07:35:00','2021-10-08 08:10:00',2100,'Assistenza su pc client Amministrazione',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-23 16:48:39','2021-10-08'),
(774,3,2,41,'2021-10-08 09:50:00','2021-10-08 10:00:00',600,'Riconsegnato vecchio pc client Gulli dopo reinstallazione',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-10-21 14:18:47','2021-10-08'),
(775,3,2,108,'2021-10-08 10:15:00','2021-10-08 10:30:00',900,'Riconsegnato pc client dopo assistenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-22 10:20:35','2021-10-08'),
(776,3,1,83,'2021-10-08 09:00:00','2021-10-08 09:40:00',2400,'Assistenza su pc client Roberta e Orietta per problemi su stampante Epson ad aghi condivisa',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-10-22 10:01:07','2021-10-08'),
(777,3,1,10,'2021-10-08 13:00:00','2021-10-08 13:15:00',900,'Assistenza su server per liberare spazio partizione D',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-22 15:33:37','2021-10-08'),
(778,3,1,26,'2021-10-08 15:35:00','2021-10-08 15:45:00',600,'Assistenza su pc client Banci',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-10-31 11:40:41','2021-10-08'),
(779,1,1,1,'2021-10-12 06:38:00','2021-10-12 08:45:00',7620,'cancellata cartella mail su publica\r\nproblemi su borzoli sessione bloccata\r\ninfo su centralino',95.25,NULL,45,1,'Europe/Rome',95.25,1,'work','2021-12-06 11:04:07','2021-10-12'),
(780,1,1,1,'2021-10-12 12:30:00','2021-10-12 12:51:00',1260,'problemi posta borzoli',15.75,NULL,45,1,'Europe/Rome',15.75,1,'work','2021-12-06 11:04:08','2021-10-12'),
(781,1,1,1,'2021-10-11 14:08:00','2021-10-11 16:30:00',8520,'recupero mail cancellate',106.5,NULL,45,1,'Europe/Rome',106.5,1,'work','2021-12-06 11:04:06','2021-10-11'),
(782,1,1,1,'2021-10-13 07:00:00','2021-10-13 07:32:00',1920,'problemi di connessione al manager',24,NULL,45,1,'Europe/Rome',24,1,'work','2021-12-06 11:04:09','2021-10-13'),
(783,3,1,50,'2021-10-11 08:50:00','2021-10-11 09:00:00',600,'Assistenza su stampante Brother per aggiornamento firmware',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-17 17:15:17','2021-10-11'),
(784,3,1,75,'2021-10-11 13:40:00','2021-10-11 14:10:00',1800,'Assistenza su portatile di casa Gianfranco Figari',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-29 15:39:44','2021-10-11'),
(785,3,2,24,'2021-10-12 09:50:00','2021-10-12 10:10:00',1200,'Sostituzione 2 batterie su UPS APC 1400',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-02 14:42:22','2021-10-12'),
(786,3,2,43,'2021-10-12 10:25:00','2021-10-12 10:35:00',600,'Ritirato pc client Romina per assistenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-10-14 15:00:38','2021-10-12'),
(787,3,1,79,'2021-10-12 08:35:00','2021-10-12 08:45:00',600,'Assistenza su pc client Elena per problemi archiviazione posta',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-29 17:01:34','2021-10-12'),
(788,3,1,43,'2021-10-12 07:10:00','2021-10-12 08:30:00',4800,'Assistenza su pc client Romina per problemi con virus, pc da ritirare',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-10-14 15:00:37','2021-10-12'),
(789,3,1,79,'2021-10-12 12:30:00','2021-10-12 12:50:00',1200,'Assistenza su pc client Elena per problemi ricezione posta su Outlook',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-29 17:01:40','2021-10-12'),
(790,1,1,24,'2021-10-13 09:12:00','2021-10-13 09:33:43',1303,'aggiornamento centralino so e 3cx',16.29,NULL,45,1,'Europe/Rome',16.29,1,'work','2021-12-02 11:06:33','2021-10-13'),
(791,1,1,1,'2021-10-13 09:33:45','2021-10-13 10:49:29',4544,'problemi di connessione al manager',56.8,NULL,45,1,'Europe/Rome',56.8,1,'work','2021-12-06 11:04:11','2021-10-13'),
(792,3,2,43,'2021-10-13 14:30:00','2021-10-13 15:00:00',1800,'Riconsegnato e configurato pc client Romina',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-10-14 15:00:41','2021-10-13'),
(793,3,1,1,'2021-10-13 07:00:00','2021-10-13 07:15:00',900,'Assistenza per problemi collegamento ad Open Manager',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-06 11:04:10','2021-10-13'),
(794,3,4,43,'2021-10-13 07:30:00','2021-10-13 08:30:00',3600,'Reinstallazione pc client Romina per problema con virus, ripristino backup dati 70gb\r\nInstallata 1 licenza nod32 completa',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-10-14 15:00:39','2021-10-13'),
(795,1,1,1,'2021-10-14 06:30:00','2021-10-14 07:10:00',2400,'problemi connessione a internet router bloccato',30,NULL,45,1,'Europe/Rome',30,1,'work','2021-12-06 11:04:12','2021-10-14'),
(796,1,1,3,'2021-10-14 07:30:00','2021-10-14 09:48:00',8280,'test agg vm lxc 3cx',103.5,NULL,45,1,'Europe/Rome',103.5,1,'work','2021-10-22 09:27:15','2021-10-14'),
(797,1,1,50,'2021-10-14 10:00:00','2021-10-14 10:30:00',1800,'installazione nuova vm lxc per agg 3cx',22.5,NULL,45,1,'Europe/Rome',22.5,1,'work','2021-11-17 17:15:09','2021-10-14'),
(798,1,1,50,'2021-10-14 12:48:17','2021-10-14 13:15:18',1621,'installazione nuova vm lxc per agg 3cx',20.26,NULL,45,1,'Europe/Rome',20.26,1,'work','2021-11-17 17:15:27','2021-10-14'),
(799,1,1,96,'2021-10-14 13:49:00','2021-10-14 16:14:00',8700,'aggiornamento vm 3cx e 3cx\r\nproblemi /var del server gandolfo1 e conseguente blocco mail\r\npulito e poi alex ha espanso la partizione',108.75,NULL,45,1,'Europe/Rome',108.75,1,'work','2021-11-04 08:43:37','2021-10-14'),
(800,3,2,104,'2021-10-14 07:00:00','2021-10-14 07:10:00',600,'Ritirata stampante Samsung per sostituzione rullo prelievo',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-03 09:55:33','2021-10-14'),
(801,3,2,6,'2021-10-14 09:20:00','2021-10-14 09:35:00',900,'Ritirato pc client Amministrazione per assistenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-23 16:48:40','2021-10-14'),
(802,3,2,108,'2021-10-14 10:25:00','2021-10-14 10:55:00',1800,'Assistenza su server per problemi navigazione',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-22 10:20:36','2021-10-14'),
(803,3,2,95,'2021-10-14 12:55:00','2021-10-14 13:30:00',2100,'Assistenza su pc client Porcile per problemi spegnimento, pulizia polvere da processore e alim + pasta termica',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-30 17:26:25','2021-10-14'),
(804,3,1,1,'2021-10-14 07:40:00','2021-10-14 08:10:00',1800,'Installata e configurata vpn su portatile Andrea, configurata posta e collegamento a Open Manager',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-06 11:03:58','2021-10-14'),
(805,3,1,2,'2021-10-14 08:20:00','2021-10-14 08:30:00',600,'Installata 1 licenza nod32 aggiornamento su 2 pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-17 14:38:40','2021-10-14'),
(806,3,1,101,'2021-10-14 13:45:00','2021-10-14 13:55:00',600,'Recuperate password nuove mail',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-03 17:25:29','2021-10-14'),
(807,1,1,96,'2021-10-15 07:11:00','2021-10-15 07:56:00',2700,'aggiornamento vm 3cx e 3cx\r\nproblemi /var del server gandolfo1 e conseguente blocco mail\r\npulito e poi alex ha espanso la partizione',33.75,NULL,45,1,'Europe/Rome',33.75,1,'work','2021-11-04 08:43:32','2021-10-15'),
(808,1,1,50,'2021-10-15 07:56:04','2021-10-15 08:34:39',2315,'installazione nuova vm lxc per agg 3cx',28.94,NULL,45,1,'Europe/Rome',28.94,1,'work','2021-11-17 17:15:08','2021-10-15'),
(809,1,1,104,'2021-10-15 06:32:00','2021-10-15 06:45:00',780,'problema raggiungibilità server',9.75,NULL,45,1,'Europe/Rome',9.75,1,'work','2021-11-03 10:46:19','2021-10-15'),
(810,1,2,2,'2021-10-15 13:02:00','2021-10-15 14:48:00',6360,'preventivo server',79.5,NULL,45,1,'Europe/Rome',79.5,1,'work','2021-11-17 11:26:02','2021-10-15'),
(811,1,4,3,'2021-10-15 12:40:00','2021-10-15 13:00:00',1200,'portatile sireci non si accende',15,NULL,45,1,'Europe/Rome',15,1,'work','2021-10-22 09:27:28','2021-10-15'),
(812,1,1,110,'2021-10-15 08:49:00','2021-10-15 10:24:00',5700,'migrazione centralino a nuova vm debian',71.25,NULL,45,1,'Europe/Rome',71.25,1,'work','2021-12-06 17:36:21','2021-10-15'),
(813,1,1,2,'2021-10-15 15:10:00','2021-10-15 16:42:00',5520,'ottimizzazione pc francesca',69,NULL,45,1,'Europe/Rome',69,1,'work','2021-11-17 14:38:26','2021-10-15'),
(814,3,2,104,'2021-10-15 06:50:00','2021-10-15 07:40:00',3000,'Assistenza su server per problemi spegnimento, sostituzione alim (395654), pulizia plvere, installazione ventole\r\nAssistenza su pc client Sandro per problemi spazio pec',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-03 10:46:20','2021-10-15'),
(815,3,2,95,'2021-10-15 10:25:00','2021-10-15 10:45:00',1200,'Sostituzione alimentatore su pc client Porcile',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-30 17:26:26','2021-10-15'),
(816,3,2,87,'2021-10-15 16:10:00','2021-10-15 16:30:00',1200,'Sostituzione alimentatore su pc client Alvarino',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-09 11:47:33','2021-10-15'),
(817,3,1,104,'2021-10-15 08:45:00','2021-10-15 08:55:00',600,'Assistenza per problemi posta in uscita',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-03 10:46:21','2021-10-15'),
(818,3,1,50,'2021-10-15 09:20:00','2021-10-15 09:50:00',1800,'Assistenza su pc client Filippo per problemi invio allegato p7m, da risolvere',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-17 17:15:16','2021-10-15'),
(819,3,4,104,'2021-10-15 10:05:00','2021-10-15 10:20:00',900,'Resettato contatori stampante Samsung M4070',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-03 09:34:15','2021-10-15'),
(820,3,1,104,'2021-10-15 12:50:00','2021-10-15 13:15:00',1500,'Assistenza per problemi su server di posta',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-03 10:46:22','2021-10-15'),
(821,3,1,50,'2021-10-15 13:40:00','2021-10-15 13:55:00',900,'Assistenza su pc client Loretta per problemi su Outlook',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-17 17:15:13','2021-10-15'),
(822,3,4,6,'2021-10-15 14:00:00','2021-10-15 15:30:00',5400,'Reinstallazione sistema operativo su pc client Amministrazione + sostituzione SSD in garanzia',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-23 16:48:42','2021-10-15'),
(823,3,2,104,'2021-10-18 06:40:00','2021-10-18 07:20:00',2400,'Assistenza per problemi su firewall trovato spento',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-03 10:46:23','2021-10-18'),
(824,3,2,104,'2021-10-18 10:00:00','2021-10-18 10:15:00',900,'Riconsegnata stampante Samsung dopo assistenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-03 10:09:21','2021-10-18'),
(825,3,2,6,'2021-10-18 13:00:00','2021-10-18 13:50:00',3000,'Riconsegnato e configurato pc client Amministrazione dopo reinstallazione s.o',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-23 16:48:43','2021-10-18'),
(826,3,2,1,'2021-10-18 14:10:00','2021-10-18 14:40:00',1800,'Assistenza su pc client Alberto per problemi spazio disco C\r\nRitirato vecchio firewall + centralino + UPS APC',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-06 11:04:13','2021-10-18'),
(827,1,1,1,'2021-10-19 12:35:00','2021-10-19 13:34:00',3540,'problemi configurazione account 3cx su smartphone',44.25,NULL,45,1,'Europe/Rome',44.25,1,'work','2021-12-06 11:04:13','2021-10-19'),
(828,1,1,2,'2021-10-18 06:54:00','2021-10-18 09:28:00',9240,'per nuovo server con dataflow.\r\nManutenzione server',115.5,NULL,45,1,'Europe/Rome',115.5,1,'work','2021-11-17 14:38:27','2021-10-18'),
(829,1,1,110,'2021-10-19 06:50:00','2021-10-19 08:00:00',4200,'problemi configurazione nuova vm lxc con centralino',52.5,NULL,45,1,'Europe/Rome',52.5,1,'work','2021-12-06 17:36:22','2021-10-19'),
(830,1,3,112,'2021-10-19 13:47:00','2021-10-19 15:24:56',5876,NULL,73.45,NULL,45,1,'Europe/Rome',73.45,1,'work','2021-11-22 10:35:45','2021-10-19'),
(831,3,2,24,'2021-10-19 06:40:00','2021-10-19 06:50:00',600,'Riconsegnate cartucce stampante  Epson dismessa',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-02 11:06:42','2021-10-19'),
(832,3,1,6,'2021-10-19 07:30:00','2021-10-19 07:50:00',1200,'Assistenza su pc client Amministrazione',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-23 16:48:45','2021-10-19'),
(833,3,1,1,'2021-10-19 09:40:00','2021-10-19 10:10:00',1800,'Assistenza su pc client Alberto per problemi su Thunderbird',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-06 11:03:57','2021-10-19'),
(834,3,1,45,'2021-10-19 10:15:00','2021-10-19 10:35:00',1200,'Assistenza su pc client Laura',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-30 17:28:22','2021-10-19'),
(835,1,1,110,'2021-10-19 15:30:00','2021-10-19 16:41:00',4260,'problemi configurazione nuova vm lxc con centralino',53.25,NULL,45,1,'Europe/Rome',53.25,1,'work','2021-12-06 17:36:22','2021-10-19'),
(836,1,1,101,'2021-10-20 13:37:00','2021-10-20 14:11:00',2040,'problema pc segnala virus',25.5,NULL,45,1,'Europe/Rome',25.5,1,'work','2021-11-03 17:25:30','2021-10-20'),
(837,1,1,50,'2021-10-20 16:05:00','2021-10-20 16:47:00',2520,'problema telefono francesco',31.5,NULL,45,1,'Europe/Rome',31.5,1,'work','2021-11-17 17:15:27','2021-10-20'),
(838,1,1,96,'2021-10-20 14:28:00','2021-10-20 15:49:00',4860,'problemi tel federica,\r\nproblemi pc antonella',60.75,NULL,45,1,'Europe/Rome',60.75,1,'work','2021-11-04 08:43:19','2021-10-20'),
(839,1,1,3,'2021-10-20 06:30:00','2021-10-20 10:30:00',14400,'install server ballerini, problemi server tms, saldato connettore portatile privato, rimontaggio portatile privato',180,NULL,45,1,'Europe/Rome',180,1,'work','2021-10-22 09:27:13','2021-10-20'),
(840,1,1,1,'2021-10-21 09:35:00','2021-10-21 10:19:00',2640,'problema posta in arrivo alberto bodrato',33,NULL,45,1,'Europe/Rome',33,1,'work','2021-12-06 11:03:55','2021-10-21'),
(841,1,1,96,'2021-10-21 06:35:00','2021-10-21 07:00:00',1500,'problema telefono federica',18.75,NULL,45,1,'Europe/Rome',18.75,1,'work','2021-11-04 08:43:18','2021-10-21'),
(842,1,1,51,'2021-10-21 07:00:00','2021-10-21 08:00:00',3600,'problemi spegnimento server',45,NULL,45,1,'Europe/Rome',45,1,'work','2021-11-17 17:12:23','2021-10-21'),
(843,1,1,41,'2021-10-21 10:32:00','2021-10-21 10:56:37',1477,'problemi stampa',18.46,NULL,45,1,'Europe/Rome',18.46,1,'work','2021-10-29 15:54:16','2021-10-21'),
(844,1,1,50,'2021-10-21 12:48:00','2021-10-21 16:30:00',13320,'problema vm spenta dopo backup fallito\r\nproblema dopo ultimo spegnimento database saltato recovery',166.5,NULL,45,1,'Europe/Rome',166.5,1,'work','2021-11-17 17:15:40','2021-10-21'),
(845,1,1,50,'2021-10-21 20:30:00','2021-10-21 21:48:00',4680,'problema vm spenta dopo backup fallito\r\nproblema dopo ultimo spegnimento database saltato recovery',58.5,NULL,45,1,'Europe/Rome',58.5,1,'work','2021-11-17 17:15:15','2021-10-21'),
(846,3,2,59,'2021-10-20 09:50:00','2021-10-20 10:30:00',2400,'Verificato pc client con problemi durante l\'avvio, da ritirare in un secondo momento',0,NULL,0,0,'Europe/Rome',0,1,'work','2021-10-22 07:00:05','2021-10-20'),
(847,3,2,41,'2021-10-20 13:00:00','2021-10-20 13:45:00',2700,'Riconsegnata e configurata stampante HP dopo assistenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-10-29 15:54:14','2021-10-20'),
(848,3,2,56,'2021-10-20 16:00:00','2021-10-20 16:40:00',2400,'Assistenza su Firewall per problemi connessione, sostituzione alimentatore 500w\r\nPulizia polvere su Firewall',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-30 17:34:37','2021-10-20'),
(849,3,1,81,'2021-10-20 07:30:00','2021-10-20 07:40:00',600,'Assistenza su posta dopo aggiornamento certificato',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-03 17:21:42','2021-10-20'),
(850,3,1,96,'2021-10-20 08:15:00','2021-10-20 08:30:00',900,'Assistenza per problemi collegamento ad ago',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-04 08:52:39','2021-10-20'),
(851,3,1,45,'2021-10-20 09:00:00','2021-10-20 09:35:00',2100,'Assistenza su pc client Laura per spostamento utente su partizione D',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-30 17:28:23','2021-10-20'),
(852,3,1,41,'2021-10-20 15:00:00','2021-10-20 15:15:00',900,'Assistenza su pc client ex Lucilla',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-10-29 15:54:15','2021-10-20'),
(853,3,2,6,'2021-10-21 08:30:00','2021-10-21 09:40:00',4200,'Assistenza su pc client Amministrazione, reinstallazione e attivazione Office 2013 su pc client Amministrazione\r\nDa fare su altri pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-23 16:48:45','2021-10-21'),
(854,3,2,100,'2021-10-21 10:00:00','2021-10-21 10:35:00',2100,'Sostituzione ventola controller Areca su server, installata ventola per raffreddamento su server.\r\nAssistenza su pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-09 11:41:37','2021-10-21'),
(855,3,2,17,'2021-10-21 10:50:00','2021-10-21 11:00:00',600,'Ritiro ups apc client Enrica per sostituzione batteria\r\nOrdinare nuovo ups per pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-10-27 09:09:52','2021-10-21'),
(856,3,2,81,'2021-10-21 11:20:00','2021-10-21 11:40:00',1200,'Installata ventola per raffreddamento Server \r\nPulizia polvere da server',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-03 17:21:43','2021-10-21'),
(857,3,1,17,'2021-10-21 14:50:00','2021-10-21 15:10:00',1200,'Assistenza su pc client Semino per problemi di stampa da remoto',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-16 14:46:13','2021-10-21'),
(858,1,1,50,'2021-10-22 06:48:00','2021-10-22 08:08:00',4800,'problemi backup vm, test proxmox',60,NULL,45,1,'Europe/Rome',60,1,'work','2021-11-17 17:15:06','2021-10-22'),
(859,1,3,112,'2021-10-22 08:10:00','2021-10-22 10:30:00',8400,NULL,105,NULL,45,1,'Europe/Rome',105,1,'work','2021-11-22 10:35:46','2021-10-22'),
(860,1,1,3,'2021-10-22 10:40:00','2021-10-22 12:15:00',5700,'configurazione nuovo server ballerini',71.25,NULL,45,1,'Europe/Rome',71.25,1,'work','2021-10-29 15:58:51','2021-10-22'),
(861,1,1,1,'2021-10-25 09:06:00','2021-10-25 10:17:00',4260,'problemi stampa borzoli e molo giano',53.25,NULL,45,1,'Europe/Rome',53.25,1,'work','2021-12-06 11:04:14','2021-10-25'),
(862,1,1,41,'2021-10-26 06:55:00','2021-10-26 07:12:00',1020,'problemi pc franca, dhcp server non gli rilascia l\'ip',12.75,NULL,45,1,'Europe/Rome',12.75,1,'work','2021-10-29 15:54:20','2021-10-26'),
(863,3,1,10,'2021-10-22 09:30:00','2021-10-22 10:20:00',3000,'Tentativo recupero posta in arrivo PEC andi Liguria',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-22 15:33:38','2021-10-22'),
(864,3,1,100,'2021-10-22 10:25:00','2021-10-22 10:45:00',1200,'Assistenza su PC client per collegamento a share',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-09 11:41:39','2021-10-22'),
(865,3,1,100,'2021-10-22 15:00:00','2021-10-22 15:20:00',1200,'Assistenza su pc client per collegamento a share',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-09 11:41:40','2021-10-22'),
(866,3,1,41,'2021-10-22 14:10:00','2021-10-22 14:30:00',1200,'Reidirect indirizzo mail omologa',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-10-29 15:54:16','2021-10-22'),
(867,3,2,41,'2021-10-25 06:45:00','2021-10-25 07:45:00',3600,'Assistenza in sede via wagner per problemi collegamento vpn fra le tre sedi\r\nAssistenza su stampante HP con problemi calibrazione',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-10-29 15:54:17','2021-10-25'),
(868,3,2,41,'2021-10-25 08:35:00','2021-10-25 09:25:00',3000,'Spostata ex postazione Lucilla più configurazione\r\nAssistenza su pc client Linda',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-10-29 15:54:18','2021-10-25'),
(869,3,1,104,'2021-10-25 13:05:00','2021-10-25 13:15:00',600,'Verificato corretto funzionamento Vodafone Station',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-10 13:16:50','2021-10-25'),
(870,3,1,41,'2021-10-25 13:50:00','2021-10-25 14:40:00',3000,'Assistenza su pc client Cinzia per problemi con file excel',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-10-29 15:54:20','2021-10-25'),
(871,3,2,79,'2021-10-26 12:50:00','2021-10-26 16:30:00',13200,'Consegnato e configurato nuovo pc client Valentina\r\nConsegnata e configurata nuova stampante Xerox per Valentina\r\nVerificate licenze nod32 (no agg.), assistenza su Iphone Andrea\r\nConfigurata vecchia stampante Valentina in Produzione',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-29 17:01:42','2021-10-26'),
(872,3,1,88,'2021-10-26 08:00:00','2021-10-26 08:20:00',1200,'Assistenza per problemi ricezione posta elettronica dopo aggiornamento certificato',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-05 08:40:33','2021-10-26'),
(873,3,1,10,'2021-10-26 08:25:00','2021-10-26 08:45:00',1200,'Assistenza per editing video',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-22 15:33:38','2021-10-26'),
(874,3,1,96,'2021-10-26 08:50:00','2021-10-26 09:05:00',900,'Assistenza su pc client Antonella per problemi su file pdf',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-17 17:33:12','2021-10-26'),
(875,3,1,100,'2021-10-26 09:10:00','2021-10-26 09:30:00',1200,'Assistenza per modifica utente Condivisi',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-09 11:41:41','2021-10-26'),
(876,3,1,50,'2021-10-26 09:50:00','2021-10-26 10:00:00',600,'Assistenza per recupero file eliminato',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-17 17:15:25','2021-10-26'),
(877,3,1,41,'2021-10-27 07:10:00','2021-10-27 07:25:00',900,'Modifiche su Aruba mail',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-10-29 15:54:21','2021-10-27'),
(878,1,1,3,'2021-10-27 06:33:00','2021-10-27 07:38:00',3900,'montaggio nuovo server cristallina',48.75,NULL,45,1,'Europe/Rome',48.75,1,'work','2021-10-29 15:58:53','2021-10-27'),
(879,1,1,2,'2021-10-27 08:00:00','2021-10-27 10:30:00',9000,'installazione nuovo server',112.5,NULL,45,1,'Europe/Rome',112.5,1,'work','2021-10-29 16:28:07','2021-10-27'),
(880,1,1,17,'2021-10-27 13:25:00','2021-10-27 16:28:00',10980,'fede li,\r\nsostituzione firewall con nuovo server',137.25,NULL,45,1,'Europe/Rome',137.25,1,'work','2021-12-16 14:18:05','2021-10-27'),
(881,1,4,3,'2021-10-26 06:30:00','2021-10-26 06:55:00',1500,NULL,18.75,NULL,45,1,'Europe/Rome',18.75,1,'work','2021-10-29 15:58:52','2021-10-26'),
(882,1,1,2,'2021-10-27 12:44:00','2021-10-27 13:19:00',2100,'installazione nuovo server',26.25,NULL,45,1,'Europe/Rome',26.25,1,'work','2021-10-29 16:28:16','2021-10-27'),
(883,1,1,110,'2021-10-28 14:26:00','2021-10-28 15:33:13',4033,'problema ricezione chiamate',50.41,NULL,45,1,'Europe/Rome',50.41,1,'work','2021-12-06 17:36:24','2021-10-28'),
(884,1,4,3,'2021-10-28 06:30:00','2021-10-28 06:56:00',1560,NULL,19.5,NULL,45,1,'Europe/Rome',19.5,1,'work','2021-10-29 15:58:55','2021-10-28'),
(885,3,2,17,'2021-10-27 13:00:00','2021-10-27 15:00:00',7200,'Consegna e configurazione nuovo firewall, ritirato vecchio firewall\r\nRiconsegna UPS APC dopo sostituzione batteria 4.5 Ah\r\nConsegna e installazione nuovo UPS APC 700',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-16 14:18:02','2021-10-27'),
(886,3,2,12,'2021-10-27 15:40:00','2021-10-27 16:10:00',1800,'Verifica pc client collegato al plotter, sostituzione sk video con una presente in ufficio',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-23 17:19:14','2021-10-27'),
(887,3,2,6,'2021-10-28 09:00:00','2021-10-28 10:15:00',4500,'Reinstallazione e attivazione Office 2013 su tutti pc client  + assistenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-23 16:48:47','2021-10-28'),
(888,3,2,41,'2021-10-28 14:50:00','2021-10-28 15:50:00',3600,'Consegna e installazione nuova stampante Epson 4830\r\nInstallate 2 licenze NOD32 complete su 4 pc client\r\nAssistenza su pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-10-29 15:54:22','2021-10-28'),
(889,3,1,83,'2021-10-28 12:55:00','2021-10-28 13:40:00',2700,'Assistenza su pc client Orietta e Roberta per problema su stampanti condivise dopo agg. Windows',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-28 15:45:05','2021-10-28'),
(890,3,1,85,'2021-10-28 13:45:00','2021-10-28 14:05:00',1200,'Configurazione 2 account mail su nuovo Mac Giacomo',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-04 08:21:14','2021-10-28'),
(891,1,2,2,'2021-10-29 07:30:00','2021-10-29 08:20:00',3000,'consegna e isntallazione nuovo server',37.5,NULL,45,1,'Europe/Rome',37.5,1,'work','2021-10-29 16:28:23','2021-10-29'),
(892,1,6,53,'2021-10-29 09:55:00','2021-10-29 10:28:00',1980,'rest router collegamento anydesk per riconfigurazione',24.75,NULL,45,1,'Europe/Rome',24.75,1,'work','2022-02-10 14:14:04','2021-10-29'),
(893,1,1,2,'2021-10-29 09:00:00','2021-10-29 09:48:00',2880,'collegamento remoto dataflow, inserimento su dominio delle vm',36,NULL,45,1,'Europe/Rome',36,1,'work','2021-11-17 14:38:18','2021-10-29'),
(894,1,1,2,'2021-10-29 12:50:00','2021-10-29 14:50:00',7200,'collegamento remoto dataflow, inserimento su dominio delle vm\r\ninizio copia file da vecchio server',90,NULL,45,1,'Europe/Rome',90,1,'work','2021-11-17 14:38:19','2021-10-29'),
(895,3,1,41,'2021-10-29 07:20:00','2021-10-29 07:35:00',900,'Assistenza su pc client Paolo per problemi di stampa',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-06 17:35:15','2021-10-29'),
(896,3,1,41,'2021-10-29 08:00:00','2021-10-29 08:20:00',1200,'Assistenza per problemi navigazionen causa firewall spento in via Wagner',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-06 17:35:16','2021-10-29'),
(897,3,1,41,'2021-10-29 08:50:00','2021-10-29 09:05:00',900,'Assistenza sui pc client Luana per problemi scansione su nuova stampante Epson',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-06 17:35:17','2021-10-29'),
(898,3,1,95,'2021-10-29 10:10:00','2021-10-29 10:30:00',1200,'Assistenza su pc client Mara per problema apertura file in Word',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-30 17:26:28','2021-10-29'),
(899,3,1,26,'2021-10-29 12:35:00','2021-10-29 13:05:00',1800,'Assistenza su pc client Banci per recupero mail cartella posta inviata',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-10-31 11:40:42','2021-10-29'),
(900,3,1,101,'2021-10-29 13:10:00','2021-10-29 13:30:00',1200,'Assistenza su Mac per collegamento remoto in VPN a pc client ufficio',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-03 17:25:31','2021-10-29'),
(901,3,1,88,'2021-10-29 13:50:00','2021-10-29 14:15:00',1500,'Assistenza su pc client per configurazione nuova mail',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-05 11:21:30','2021-10-29'),
(902,3,1,26,'2021-10-29 14:25:00','2021-10-29 14:55:00',1800,'Assistenza su pc client Banci per indicizzazione cartella posta inviata',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-10-31 11:40:43','2021-10-29'),
(903,1,1,51,'2021-11-02 08:33:00','2021-11-02 08:45:36',756,'problemi mac burdese',9.45,NULL,45,1,'Europe/Rome',9.45,1,'work','2021-11-17 17:12:24','2021-11-02'),
(904,3,1,96,'2021-11-02 07:50:00','2021-11-02 08:05:00',900,'Assistenza per problemi collegamento ad AGO',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-04 08:52:37','2021-11-02'),
(905,3,1,75,'2021-11-02 09:50:00','2021-11-02 10:10:00',1200,'Assistenza su pc client Oneto per problemi su cartella Documenti',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-29 15:39:46','2021-11-02'),
(906,3,1,32,'2021-11-02 16:20:00','2021-11-02 17:00:00',2400,'Assistenza su pc client Luca per problema aggiornamento Desktop Telematico',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-06 16:36:55','2021-11-02'),
(907,3,1,32,'2021-11-02 17:30:00','2021-11-02 17:50:00',1200,'Assistenza su pc client Luca per problemi Desktop Telematico',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-06 16:36:55','2021-11-02'),
(908,1,2,41,'2021-10-08 12:40:00','2021-10-08 13:22:00',2520,'sopraluogo',31.5,NULL,45,1,'Europe/Rome',31.5,1,'work','2021-12-06 17:01:44','2021-10-08'),
(909,1,1,1,'2021-10-08 14:00:00','2021-10-08 15:40:00',6000,'cancellazione cartella mail',75,NULL,45,1,'Europe/Rome',75,1,'work','2021-12-06 11:04:05','2021-10-08'),
(910,1,1,4,'2021-10-04 09:45:00','2021-10-04 10:30:00',2700,'relazione',33.75,NULL,45,1,'Europe/Rome',33.75,1,'work','2021-12-06 16:37:32','2021-10-04'),
(911,1,1,108,'2021-10-07 07:00:00','2021-10-07 08:28:00',5280,'vm piena pulizia',66,NULL,45,1,'Europe/Rome',66,1,'work','2022-02-22 10:20:32','2021-10-07'),
(912,1,1,3,'2021-10-07 08:46:00','2021-10-07 10:27:00',6060,'proxmox problema backup',75.75,NULL,45,1,'Europe/Rome',75.75,1,'work','2021-11-22 10:34:38','2021-10-07'),
(913,1,1,41,'2021-10-07 14:56:00','2021-10-07 16:22:00',5160,'sistemazione backup',64.5,NULL,45,1,'Europe/Rome',64.5,1,'work','2021-12-06 17:35:13','2021-10-07'),
(914,1,2,103,'2021-10-11 12:43:00','2021-10-11 13:12:00',1740,'per preventivo nuovo firewall',21.75,NULL,45,1,'Europe/Rome',21.75,1,'work','2021-12-03 16:47:23','2021-10-11'),
(915,1,1,3,'2021-10-11 06:48:00','2021-10-11 10:00:00',11520,'proxmox problema backup',144,NULL,45,1,'Europe/Rome',144,1,'work','2021-11-22 10:34:39','2021-10-11'),
(916,1,1,3,'2021-10-12 09:05:00','2021-10-12 10:28:00',4980,'3cx agg debian 10',62.25,NULL,45,1,'Europe/Rome',62.25,1,'work','2021-11-22 10:34:53','2021-10-12'),
(917,1,1,2,'2021-10-12 13:03:00','2021-10-12 15:17:00',8040,'agg nas e telecamere',100.5,NULL,45,1,'Europe/Rome',100.5,1,'work','2021-11-17 14:38:20','2021-10-12'),
(918,1,1,50,'2021-10-12 15:28:00','2021-10-12 16:26:00',3480,'problema interni centralino',43.5,NULL,45,1,'Europe/Rome',43.5,1,'work','2021-11-17 17:15:28','2021-10-12'),
(919,1,1,3,'2021-10-13 14:00:00','2021-10-13 15:00:00',3600,'problemi nostri siti',45,NULL,45,1,'Europe/Rome',45,1,'work','2021-11-22 10:34:51','2021-10-13'),
(920,1,1,79,'2021-10-13 07:52:00','2021-10-13 09:00:00',4080,'certificati',51,NULL,45,1,'Europe/Rome',51,1,'work','2021-11-29 17:01:41','2021-10-13'),
(921,1,1,3,'2021-10-13 15:16:00','2021-10-13 16:29:00',4380,'fine lavori per spegnimento egroupware e riapertura esterna nostri siti',54.75,NULL,45,1,'Europe/Rome',54.75,1,'work','2021-11-22 10:34:59','2021-10-13'),
(922,1,1,51,'2021-10-13 12:49:00','2021-10-13 13:48:00',3540,'controloo sahre e vm',44.25,NULL,45,1,'Europe/Rome',44.25,1,'work','2021-11-17 17:12:22','2021-10-13'),
(923,1,1,5,'2021-10-18 09:57:00','2021-10-18 10:22:00',1500,'agg nas',18.75,NULL,45,1,'Europe/Rome',18.75,1,'work','2021-12-28 14:50:43','2021-10-18'),
(924,1,1,3,'2021-10-18 12:49:00','2021-10-18 16:24:00',12900,'proxmox backup e vm 3cx',161.25,NULL,45,1,'Europe/Rome',161.25,1,'work','2021-11-22 10:34:47','2021-10-18'),
(925,1,1,75,'2021-10-19 08:29:00','2021-10-19 10:20:00',6660,'agg nas, e config security',83.25,NULL,45,1,'Europe/Rome',83.25,1,'work','2021-11-29 15:39:45','2021-10-19'),
(926,1,1,3,'2021-10-20 12:42:00','2021-10-20 13:21:00',2340,'ipmi server tms',29.25,NULL,45,1,'Europe/Rome',29.25,1,'work','2021-11-22 10:34:46','2021-10-20'),
(927,1,1,50,'2021-10-21 08:13:00','2021-10-21 09:27:00',4440,'casino con vm spenta amle',55.5,NULL,45,1,'Europe/Rome',55.5,1,'work','2021-11-17 17:15:26','2021-10-21'),
(928,1,1,41,'2021-10-22 13:07:00','2021-10-22 14:55:00',6480,'agg server',81,NULL,45,1,'Europe/Rome',81,1,'work','2021-12-06 17:35:14','2021-10-22'),
(929,1,3,112,'2021-10-22 12:30:00','2021-10-22 13:00:00',1800,NULL,22.5,NULL,45,1,'Europe/Rome',22.5,1,'work','2021-11-22 10:35:47','2021-10-22'),
(930,1,1,3,'2021-10-22 15:04:00','2021-10-22 16:30:00',5160,'prxomox problema backup',64.5,NULL,45,1,'Europe/Rome',64.5,1,'work','2021-11-22 10:34:41','2021-10-22'),
(931,1,1,3,'2021-10-25 06:48:00','2021-10-25 09:00:00',7920,'problema uefi e controller megaraid su servert tms nuovo',99,NULL,45,1,'Europe/Rome',99,1,'work','2021-11-22 10:34:46','2021-10-25'),
(932,1,1,3,'2021-10-25 12:46:00','2021-10-25 14:00:00',4440,'install debian e config su server tms',55.5,NULL,45,1,'Europe/Rome',55.5,1,'work','2021-11-22 10:34:48','2021-10-25'),
(933,1,1,81,'2021-10-25 14:12:00','2021-10-25 15:29:00',4620,'agg server, iniziato per migrazione nuovo agg windows',57.75,NULL,45,1,'Europe/Rome',57.75,1,'work','2021-11-03 17:21:43','2021-10-25'),
(934,1,1,4,'2021-10-25 15:46:00','2021-10-25 16:30:00',2640,'agg server vm',33,NULL,45,1,'Europe/Rome',33,1,'work','2021-12-06 16:37:37','2021-10-25'),
(935,1,1,3,'2021-10-26 07:15:00','2021-10-26 08:00:00',2700,'in lab',33.75,NULL,45,1,'Europe/Rome',33.75,1,'work','2021-11-22 10:35:00','2021-10-26'),
(936,1,1,3,'2021-10-26 08:22:00','2021-10-26 10:30:00',7680,'proxmox backup',96,NULL,45,1,'Europe/Rome',96,1,'work','2021-11-22 10:34:42','2021-10-26'),
(937,1,1,108,'2021-10-26 12:51:00','2021-10-26 14:00:00',4140,'agg nas',51.75,NULL,45,1,'Europe/Rome',51.75,1,'work','2022-02-22 10:20:37','2021-10-26'),
(938,1,1,67,'2021-10-26 14:18:00','2021-10-26 16:25:00',7620,'vm perso disco',95.25,NULL,45,1,'Europe/Rome',95.25,1,'work','2021-11-04 15:38:28','2021-10-26'),
(939,1,1,3,'2021-10-28 07:21:00','2021-10-28 10:30:00',11340,'proxmox backuip',141.75,NULL,45,1,'Europe/Rome',141.75,1,'work','2021-11-22 10:34:51','2021-10-28'),
(940,1,1,50,'2021-10-28 12:50:00','2021-10-28 14:17:00',5220,'backup manuale per verifica non inchiodamento e messa in sicurezza dati',65.25,NULL,45,1,'Europe/Rome',65.25,1,'work','2021-11-17 17:15:25','2021-10-28'),
(941,1,1,50,'2021-10-28 15:54:00','2021-10-28 16:27:00',1980,'backup mahuale per problemi proxmox',24.75,NULL,45,1,'Europe/Rome',24.75,1,'work','2021-11-17 17:15:24','2021-10-28'),
(942,1,1,3,'2021-10-29 15:15:00','2021-10-29 16:19:00',3840,'proxmox bakcup',48,NULL,45,1,'Europe/Rome',48,1,'work','2021-11-22 10:34:49','2021-10-29'),
(943,1,1,3,'2021-11-03 08:15:00','2021-11-03 09:38:00',4980,'fogli',62.25,NULL,45,1,'Europe/Rome',62.25,1,'work','2021-11-24 15:55:55','2021-11-03'),
(944,1,1,1,'2021-11-02 09:00:00','2021-11-02 10:10:00',4200,'verifica ibox ex succursale',52.5,NULL,45,1,'Europe/Rome',52.5,1,'work','2021-12-06 11:03:55','2021-11-02'),
(945,1,1,17,'2021-11-04 15:16:00','2021-11-04 17:30:00',8040,'fede li sincro dati per cambio server',100.5,NULL,45,1,'Europe/Rome',100.5,1,'work','2021-12-16 14:18:15','2021-11-04'),
(946,3,2,17,'2021-11-04 14:55:00','2021-11-04 16:25:00',5400,'Sistemata postazione nuovo server, mappatura nuovi percorsi cartella condivisa su tutti pc client.\r\nAssistenza su pc client Semino',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-16 14:18:09','2021-11-04'),
(947,3,1,96,'2021-11-03 08:10:00','2021-11-03 08:35:00',1500,'Assistenza per problemi collegamento ad AGO, devono sentire Zucchetti per risolvere il problema',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-17 17:26:43','2021-11-03'),
(948,3,1,104,'2021-11-03 09:30:00','2021-11-03 09:40:00',600,'Assistenza per verifica corretto funzionamento rete internet',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-10 13:16:52','2021-11-03'),
(949,3,1,50,'2021-11-03 10:20:00','2021-11-03 10:35:00',900,'Assistenza su mac Gigio',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-17 17:15:06','2021-11-03'),
(950,3,1,1,'2021-11-03 10:50:00','2021-11-03 11:20:00',1800,'Assistenza su pc client Alessio per problema stampante condivisa dopo aggiornamento Windows',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-10 17:22:48','2021-11-03'),
(951,3,1,56,'2021-11-03 16:00:00','2021-11-03 16:20:00',1200,'Assistenza su pc client per problema con driver, il pc è da aggiornare a Windows 10',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-30 17:34:38','2021-11-03'),
(952,3,1,1,'2021-11-04 07:55:00','2021-11-04 08:40:00',2700,'Installazione OpenManager in locale su pc client Bancone',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-10 17:22:50','2021-11-04'),
(953,3,1,67,'2021-11-04 08:50:00','2021-11-04 09:20:00',1800,'Assistenza su pc client Serra per problemi lentezza, il pc sarebbe da aggiornare o sostituire',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-09 11:05:32','2021-11-04'),
(954,3,1,1,'2021-11-04 09:20:00','2021-11-04 09:50:00',1800,'Assistenza su pc client Bancone per problema invio mail da OpenManager',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-10 15:12:19','2021-11-04'),
(955,3,1,1,'2021-11-04 10:35:00','2021-11-04 11:35:00',3600,'Assistenza su pc client Bancone per problema invio mail da OpenManager',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-10 15:13:34','2021-11-04'),
(956,3,1,1,'2021-11-04 13:30:00','2021-11-04 13:45:00',900,'Assistenza su pc client Bancone  per problema invio mail da OpenManager, devono contattare assistenza per fare aggiornamento',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-10 15:13:38','2021-11-04'),
(957,3,1,12,'2021-11-04 17:10:00','2021-11-04 17:40:00',1800,'Assistenza per problema stampante condivisa su pc client Claudio',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-23 17:19:15','2021-11-04'),
(958,3,1,96,'2021-11-05 08:00:00','2021-11-05 08:15:00',900,'Assistenza  per problema collegamento ad AGO causa errore tomcat',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-17 17:26:27','2021-11-05'),
(959,3,1,55,'2021-11-05 09:10:00','2021-11-05 09:20:00',600,'Installata 1 licenza nod32 aggiornamento su 2 pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-24 14:43:19','2021-11-05'),
(960,3,1,12,'2021-11-05 09:30:00','2021-11-05 10:30:00',3600,'Risolto problema stampante condivisa dopo aggiornamento Windows su 2 pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-23 17:19:16','2021-11-05'),
(961,3,1,12,'2021-11-05 13:45:00','2021-11-05 15:15:00',5400,'Verificato problema stampante condivisa dopo aggiornamento Windows su un terzo pc client, problema da risolvere, verificare se offrire nuova stampante di rete',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-23 17:19:16','2021-11-05'),
(962,3,1,59,'2021-11-05 15:20:00','2021-11-05 15:30:00',600,'Installata 1 licenza nod32 aggiornamento su 2 pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-24 09:57:30','2021-11-05'),
(963,3,1,96,'2021-11-05 15:45:00','2021-11-05 16:00:00',900,'Assistenza su pc client Antonella',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-17 17:33:13','2021-11-05'),
(964,1,1,41,'2021-11-08 10:30:00','2021-11-08 11:30:00',3600,'oriblemi centralino fede li',45,NULL,45,1,'Europe/Rome',45,1,'work','2021-12-06 17:20:58','2021-11-08'),
(965,1,1,41,'2021-11-08 13:47:00','2021-11-08 16:23:00',9360,'problemi centralino',117,NULL,45,1,'Europe/Rome',117,1,'work','2021-12-06 17:35:21','2021-11-08'),
(966,3,2,41,'2021-11-08 08:30:00','2021-11-08 11:10:00',9600,'Assistenza su pc client  Franca per problemi navigazione.\r\nAssistenza su stampante Cinzia, Ilaria e Franca. Assistenza su pc client  Ilaria e Luana\r\nVerificato come ricollegare vecchia linea telefonica, da tornare con alim. per telefoni voip\r\nUtilizzato switch 16 porte provvisorio',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-06 17:35:19','2021-11-08'),
(967,3,2,41,'2021-11-08 13:30:00','2021-11-08 15:00:00',5400,'Verificato e ritirato apparecchiature per funzionamento vecchia linea telefonica',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-06 17:35:20','2021-11-08'),
(968,3,1,10,'2021-11-08 15:25:00','2021-11-08 15:35:00',600,'Assistenza su pc client Francesca',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-22 15:33:39','2021-11-08'),
(969,3,1,88,'2021-11-08 15:40:00','2021-11-08 16:10:00',1800,'Assistenza  su pc client Maura, sostituire sk video in loco',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-29 16:01:25','2021-11-08'),
(970,3,2,79,'2021-11-09 15:45:00','2021-11-09 17:20:00',5700,'Assistenza su pc client Paolo e Elena per condivisione file excel\r\nConsegna e configurazione vecchio pc client Valentina nella postazione Produzione',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-29 17:01:25','2021-11-09'),
(971,3,1,96,'2021-11-09 08:10:00','2021-11-09 08:50:00',2400,'Assistenza per problema collegamento ad AGO, deve farci sapere l\' assistenza di Zucchetti',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-17 17:27:15','2021-11-09'),
(972,3,1,88,'2021-11-09 09:30:00','2021-11-09 09:45:00',900,'Inibito accesso vpn ad utente Matteo Castaldi',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-24 10:10:48','2021-11-09'),
(973,3,1,2,'2021-11-09 10:50:00','2021-11-09 11:05:00',900,'Assistenza su pc client Andrea per problema invio mail da Bollicine',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-10 14:51:46','2021-11-09'),
(974,3,4,79,'2021-11-09 09:50:00','2021-11-09 10:50:00',3600,'Reinstallazione vecchio pc client Valentina da sostituire nella postazione Produzione',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-29 17:01:45','2021-11-09'),
(975,3,1,32,'2021-11-09 14:25:00','2021-11-09 14:55:00',1800,'Assistenza su pc client Luca per problemi con Java, da richiamare per finire lavoro',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-06 16:36:56','2021-11-09'),
(976,1,1,2,'2021-11-09 07:48:00','2021-11-09 10:10:00',8520,'preparazione per migrazione server',106.5,NULL,45,1,'Europe/Rome',106.5,1,'work','2022-02-10 14:51:47','2021-11-09'),
(977,1,3,112,'2021-11-09 10:19:00','2021-11-09 11:30:00',4260,NULL,53.25,NULL,45,1,'Europe/Rome',53.25,1,'work','2021-11-22 10:35:47','2021-11-09'),
(978,1,2,2,'2021-11-09 12:45:00','2021-11-09 15:00:00',8100,'configurazione client per puntamento bollicine e share nuovo server',101.25,NULL,45,1,'Europe/Rome',101.25,1,'work','2022-02-10 14:51:41','2021-11-09'),
(979,1,1,2,'2021-11-09 15:35:00','2021-11-09 17:30:00',6900,'migrazione profili roaming',86.25,NULL,45,1,'Europe/Rome',86.25,1,'work','2022-02-10 14:51:44','2021-11-09'),
(980,1,3,112,'2021-11-10 09:00:00','2021-11-10 11:10:00',7800,NULL,97.5,NULL,45,1,'Europe/Rome',97.5,1,'work','2021-11-22 10:35:48','2021-11-10'),
(981,1,1,50,'2021-11-10 13:45:00','2021-11-10 14:55:44',4244,'problemi tel elisabetta',53.05,NULL,45,1,'Europe/Rome',53.05,1,'work','2021-11-17 17:15:05','2021-11-10'),
(982,1,1,2,'2021-11-10 07:40:00','2021-11-10 08:47:00',4020,'configurazione replica agg nas e iniziato lavoro per backup remoto',50.25,NULL,45,1,'Europe/Rome',50.25,1,'work','2022-02-10 14:52:05','2021-11-10'),
(983,1,1,2,'2021-11-10 11:11:00','2021-11-10 13:40:00',8940,'configurazione replica agg nas e iniziato lavoro per backup remoto',111.75,NULL,45,1,'Europe/Rome',111.75,1,'work','2022-02-10 14:52:04','2021-11-10'),
(984,1,1,32,'2021-11-10 16:08:00','2021-11-10 16:23:42',942,'problemi java pc luca',11.78,NULL,45,1,'Europe/Rome',11.78,1,'work','2021-12-06 16:36:58','2021-11-10'),
(985,1,1,90,'2021-11-11 08:57:00','2021-11-11 09:44:00',2820,'problemi ssl\r\nproblemi monito manuela\r\nproblemi cyclone',35.25,NULL,45,1,'Europe/Rome',35.25,1,'work','2022-03-01 14:58:47','2021-11-11'),
(986,1,1,96,'2021-11-11 07:40:00','2021-11-11 08:40:00',3600,'problema ago',45,NULL,45,1,'Europe/Rome',45,1,'work','2021-11-17 17:33:13','2021-11-11'),
(987,1,1,3,'2021-11-11 15:03:00','2021-11-11 17:48:00',9900,'vm lxc bullseye, config lxc su firewall ecologital',123.75,NULL,45,1,'Europe/Rome',123.75,1,'work','2021-11-22 10:34:43','2021-11-11'),
(988,3,2,67,'2021-11-10 15:00:00','2021-11-10 18:40:00',13200,'Consegna e configurazione nuovo pc client Massimo Serra, da finire.\r\nSostituzione dissipatore su PC client Pino, utilizzato Cooler Master H412R',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-24 15:56:22','2021-11-10'),
(989,3,4,51,'2021-11-10 07:45:00','2021-11-10 08:15:00',1800,'Assistenza su Mac Burdese per problema ventole',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-17 17:12:25','2021-11-10'),
(990,3,1,96,'2021-11-10 08:15:00','2021-11-10 08:35:00',1200,'Assistenza per problemi collegamento ad AGO',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-17 17:26:21','2021-11-10'),
(991,3,1,96,'2021-11-10 08:50:00','2021-11-10 09:05:00',900,'Chiamato assistenza Zucchetti per problemi collegamento ad AGO studio Gandolfo',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-17 17:26:24','2021-11-10'),
(992,3,1,79,'2021-11-10 09:10:00','2021-11-10 09:35:00',1500,'Assistenza su pc client Valentina  e Paola  per problemi su file excel condivisi',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-04 18:21:18','2021-11-10'),
(993,3,4,104,'2021-11-10 09:45:00','2021-11-10 10:00:00',900,'Sostituzione batteria su portatile Agente',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-10 11:45:41','2021-11-10'),
(994,3,1,50,'2021-11-10 10:35:00','2021-11-10 10:55:00',1200,'Assistenza su telefono voip Elisabetta',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-17 17:15:22','2021-11-10'),
(995,3,1,108,'2021-11-10 11:05:00','2021-11-10 11:20:00',900,'Assistenza su pc client Alessia',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-22 10:20:38','2021-11-10'),
(996,3,2,67,'2021-11-11 08:10:00','2021-11-11 10:05:00',6900,'Finita configurazione nuovo pc client Massimo Serra',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-24 15:56:23','2021-11-11'),
(997,3,2,88,'2021-11-11 10:15:00','2021-11-11 10:40:00',1500,'Sostituzione sk video su pc client Maura, utilizzata msi GT710 1gb\r\nData vecchia sk video 29-01-2020',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-24 10:11:13','2021-11-11'),
(998,3,2,56,'2021-11-11 11:00:00','2021-11-11 11:25:00',1500,'Sostituzione sk video su pc client Federica, utilizzata asus GT710 1gb + cavo hdmi \r\nData vecchia sk video 08/06/21',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-30 17:34:39','2021-11-11'),
(999,3,2,26,'2021-11-11 11:45:00','2021-11-11 12:15:00',1800,'Risolto problema su stampanti HP Color LaserJet CP3525dn + ordinare toner nero compatibile oltre a quello  già ordinati',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-17 16:43:40','2021-11-11'),
(1000,3,2,96,'2021-11-11 12:40:00','2021-11-11 13:10:00',1800,'Verificata stampante HP Federica per problemi inceppamento, fare offerta per nuova stampante laser',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-17 17:33:14','2021-11-11'),
(1001,3,2,65,'2021-11-11 13:30:00','2021-11-11 14:30:00',3600,'Spostata postazione client da vecchio ufficio al nuovo. Utilizzato: 1 cavo di rete da 5mt e 1 cavo USB\r\nDa offrire tamburo per stampante Brother HL-3140CW + mouse wireless + toner ciano',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-22 10:34:10','2021-11-11'),
(1002,3,1,22,'2021-11-11 16:00:00','2021-11-11 16:15:00',900,'Assistenza su pc client Boccaleri per problema apertura PDF',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-16 11:15:27','2021-11-11'),
(1003,1,1,3,'2021-11-12 07:41:00','2021-11-12 10:17:00',9360,'studio configurazione wireshark',117,NULL,45,1,'Europe/Rome',117,1,'work','2021-11-22 10:34:43','2021-11-12'),
(1004,1,1,81,'2021-11-12 10:25:00','2021-11-12 11:30:00',3900,'confiogurazione vpn wireshark su server windows',48.75,NULL,45,1,'Europe/Rome',48.75,1,'work','2021-12-07 09:49:04','2021-11-12'),
(1005,3,2,41,'2021-11-12 08:15:00','2021-11-12 11:40:00',12300,'Assistenza per problema navigazione su pc client Francesca, assistenza su pc client Paola.\r\nInstallata e configurata nuova stampante ad aghi nella postazione di Gulli',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-30 07:59:59','2021-11-12'),
(1006,3,1,75,'2021-11-12 13:35:00','2021-11-12 14:15:00',2400,'Verifica problemi lentezza pc client Erica, da verificare quando si può ritirare per aggiornamento',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-29 15:39:46','2021-11-12'),
(1007,3,1,67,'2021-11-12 14:35:00','2021-11-12 15:05:00',1800,'Assistenza su nuovo pc client Massimo Serra per configurazione ODBC per software Sigla',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-24 15:56:23','2021-11-12'),
(1008,1,2,41,'2021-11-15 10:45:00','2021-11-15 11:30:00',2700,'per config centralino intervento annullato dal cliente',33.75,NULL,45,1,'Europe/Rome',33.75,1,'work','2021-12-30 08:00:03','2021-11-15'),
(1009,1,1,81,'2021-11-15 16:42:00','2021-11-15 17:24:00',2520,'config vpn, e test post configurazione',31.5,NULL,45,1,'Europe/Rome',31.5,1,'work','2021-12-07 09:49:05','2021-11-15'),
(1010,3,2,96,'2021-11-15 16:20:00','2021-11-15 17:00:00',2400,'Consegna e installazione nuova stampante Brother per Federica, ritirata vecchia stampante HP\r\nAssistenza su pc client Antonella',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-17 17:33:16','2021-11-15'),
(1011,3,1,41,'2021-11-15 08:20:00','2021-11-15 08:40:00',1200,'Assistenza su pc client Paola e Franc a per problemi di stampa',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-30 08:00:02','2021-11-15'),
(1012,3,1,67,'2021-11-15 09:50:00','2021-11-15 10:00:00',600,'Assistenza per creazione nuovo indirizzo di posta',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-24 15:19:29','2021-11-15'),
(1013,3,1,85,'2021-11-15 13:35:00','2021-11-15 13:45:00',600,'Assistenza per aumento spazio casella posta Giacomo',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-16 15:21:04','2021-11-15'),
(1014,3,1,96,'2021-11-15 14:10:00','2021-11-15 14:20:00',600,'Assistenza su pc client Antonella per problemi sulla posta',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-17 17:33:15','2021-11-15'),
(1015,3,1,12,'2021-11-15 14:25:00','2021-11-15 14:40:00',900,'Assistenza su nuovo portatile casa Nadia per configurazione vpn',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-23 17:19:18','2021-11-15'),
(1016,3,1,22,'2021-11-15 14:50:00','2021-11-15 15:05:00',900,'Assistenza su pc client Stefano per recupero dati dal bk del Nas',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-16 11:15:28','2021-11-15'),
(1017,1,1,1,'2021-11-16 08:30:00','2021-11-16 08:54:00',1440,'problemi stampe Borzoli, inserita chiave di registro per PrintNightmare da rimuovere appena fatto lavoro di installazione server e nuova stampante',18,NULL,45,1,'Europe/Rome',18,1,'work','2022-02-10 17:22:52','2021-11-16'),
(1018,1,1,1,'2021-11-16 09:51:00','2021-11-16 11:09:32',4712,'problemi stampe Borzoli, inserita chiave di registro per PrintNightmare da rimuovere appena fatto lavoro di installazione server e nuova stampante',58.9,NULL,45,1,'Europe/Rome',58.9,1,'work','2022-02-10 17:22:53','2021-11-16'),
(1019,1,1,5,'2021-11-16 11:14:00','2021-11-16 11:30:00',960,'problemi script upload',12,NULL,45,1,'Europe/Rome',12,1,'work','2021-12-28 14:50:44','2021-11-16'),
(1020,1,1,3,'2021-11-16 13:31:00','2021-11-16 14:28:00',3420,'segutio fede nell\'installazione cavi ups da cristallina e illlibro e attivazione ipmi da cristallina',42.75,NULL,45,1,'Europe/Rome',42.75,1,'work','2021-11-22 10:35:01','2021-11-16'),
(1021,1,1,2,'2021-11-16 14:35:00','2021-11-16 15:10:00',2100,'configurazione powerchute apc su nuovo server',26.25,NULL,45,1,'Europe/Rome',26.25,1,'work','2022-02-10 14:51:51','2021-11-16'),
(1022,1,1,55,'2021-11-16 15:16:00','2021-11-16 17:30:00',8040,'aggiornamenti server windows e virtual machine',100.5,NULL,45,1,'Europe/Rome',100.5,1,'work','2021-12-28 16:26:32','2021-11-16'),
(1023,1,1,55,'2021-11-16 09:04:00','2021-11-16 09:38:00',2040,'aggiornamenti server windows e virtual machine',25.5,NULL,45,1,'Europe/Rome',25.5,1,'work','2021-12-28 16:26:31','2021-11-16'),
(1024,1,1,55,'2021-11-16 07:45:00','2021-11-16 08:17:00',1920,'aggiornamenti server windows e virtual machine',24,NULL,45,1,'Europe/Rome',24,1,'work','2021-12-28 16:26:31','2021-11-16'),
(1025,3,2,67,'2021-11-16 09:45:00','2021-11-16 10:30:00',2700,'Concluso lavoro configurazione software Sigla su nuovo pc client Massimo Serrra',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-24 15:56:24','2021-11-16'),
(1026,3,2,6,'2021-11-16 10:45:00','2021-11-16 10:55:00',600,'Riconsegnato portatile figlia Paolo',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-19 09:23:26','2021-11-16'),
(1027,3,2,2,'2021-11-16 13:00:00','2021-11-16 14:15:00',4500,'Collegato UPS a nuovo server, collegato ipmi vecchio server.\r\nAssistenza su pc client Cevasco\r\nUtilizzato cavo di rete da 2mt',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-10 14:52:16','2021-11-16'),
(1028,3,2,55,'2021-11-16 14:25:00','2021-11-16 14:55:00',1800,'Collegamento ups a nuovo server, da tornare con cavo corretto',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-24 10:41:49','2021-11-16'),
(1029,3,2,50,'2021-11-16 15:45:00','2021-11-16 17:45:00',7200,'Consegna e configurazione nuovo mac Elisabetta\r\nConsegna e installazione nuovo monitor',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-17 17:15:01','2021-11-16'),
(1030,3,2,1,'2021-11-17 09:00:00','2021-11-17 11:40:00',9600,'Consegna e configurazione nuovo firewall presso la sede di Borzoli, cablata rete dopo installazione firewall.\r\nConsegna e installazione nuova stampante HP, utilizzato: 1 switch 8 porte giga, 1 cavo di rete da 10mt',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-10 17:22:54','2021-11-17'),
(1031,3,1,24,'2021-11-17 08:10:00','2021-11-17 08:20:00',600,'Assistenza per problemi di posta dopo aggiornamento certificato',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-02 11:06:49','2021-11-17'),
(1032,3,1,85,'2021-11-17 13:50:00','2021-11-17 14:00:00',600,'Assistenza su Mac Luca',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-16 15:21:13','2021-11-17'),
(1033,3,1,83,'2021-11-17 16:00:00','2021-11-17 16:15:00',900,'Assistenza su pc client Ennio per problemi allegati mail',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-28 15:45:06','2021-11-17'),
(1034,3,4,64,'2021-11-17 16:30:00','2021-11-17 17:00:00',1800,'Assistenza su tablet Valentina',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-23 15:58:15','2021-11-17'),
(1035,1,1,1,'2021-11-17 16:14:00','2021-11-17 17:30:00',4560,'firewall in succursale problemi di vpn e collegamento al server',57,NULL,45,1,'Europe/Rome',57,1,'work','2022-02-10 15:07:50','2021-11-17'),
(1036,1,1,1,'2021-11-17 09:48:00','2021-11-17 11:30:00',6120,'firewall in succursale configurazione, fede li',76.5,NULL,45,1,'Europe/Rome',76.5,1,'work','2022-02-10 17:22:55','2021-11-17'),
(1037,1,1,55,'2021-11-18 10:10:00','2021-11-18 11:12:02',3722,'installazione e configurazione software apc ups',46.53,NULL,45,1,'Europe/Rome',46.53,1,'work','2021-11-24 10:41:44','2021-11-18'),
(1038,1,1,3,'2021-11-18 07:45:00','2021-11-18 09:16:00',5460,'test configurazione proxmox backup su pc temporaneo lab',68.25,NULL,45,1,'Europe/Rome',68.25,1,'work','2021-11-22 10:34:52','2021-11-18'),
(1039,1,1,50,'2021-11-18 09:20:00','2021-11-18 10:00:00',2400,'configurazione backup remoto su proxmox backup',30,NULL,45,1,'Europe/Rome',30,1,'work','2021-11-29 17:03:40','2021-11-18'),
(1040,1,1,1,'2021-11-18 14:52:00','2021-11-18 15:35:01',2581,'problemi stampa alessio',32.26,NULL,45,1,'Europe/Rome',32.26,1,'work','2022-02-10 17:22:56','2021-11-18'),
(1041,1,1,1,'2021-11-18 15:38:00','2021-11-18 16:02:00',1440,'problemi stampa alessio',18,NULL,45,1,'Europe/Rome',18,1,'work','2022-02-10 17:22:57','2021-11-18'),
(1042,3,2,55,'2021-11-18 09:55:00','2021-11-18 10:10:00',900,'Collegamento UPS su nuovo server, utilizzato: cavo usb 1,8 mt doppio attacco piatto',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-24 10:41:46','2021-11-18'),
(1043,3,2,75,'2021-11-18 10:45:00','2021-11-18 11:05:00',1200,'Assistenza su portatile Erica, ritirato pc fisso Erica per assistenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-29 15:39:47','2021-11-18'),
(1044,3,2,65,'2021-11-18 15:10:00','2021-11-18 15:30:00',1200,'Consegna e installazione tamburo e toner per stampante Brother\r\nConsegna e installazione mouse wireless',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-22 10:34:12','2021-11-18'),
(1045,3,2,90,'2021-11-18 15:40:00','2021-11-18 18:00:00',8400,'Consegna e installazione 2 dischi da 8tb su pc client Manuela, clonato dischi da 2tb su nuovi dischi da 8tb',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-01 14:58:48','2021-11-18'),
(1046,3,2,17,'2021-11-18 09:10:00','2021-11-18 09:20:00',600,'Assistenza su portatile casa Enrica per collegamento a nuovo server',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-16 14:18:48','2021-11-18'),
(1047,3,1,22,'2021-11-18 14:15:00','2021-11-18 14:25:00',600,'Assistenza su pc client Boccaleri padre',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-16 11:15:28','2021-11-18'),
(1048,1,1,90,'2021-11-19 08:00:00','2021-11-19 08:20:00',1200,'problema dopo clone dischi non reimpostata la lettera corretta',15,NULL,45,1,'Europe/Rome',15,1,'work','2022-03-01 14:58:49','2021-11-19'),
(1049,3,2,79,'2021-11-19 13:40:00','2021-11-19 14:10:00',1800,'Consegna toner per Xerox, collegamento UPS su server con cavo USB\r\nAssistenza su pc client Elena',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-04 18:21:19','2021-11-19'),
(1050,3,1,64,'2021-11-19 08:00:00','2021-11-19 08:10:00',600,'Assistenza per problemi navigazione',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-23 15:58:16','2021-11-19'),
(1051,3,1,4,'2021-11-19 08:10:00','2021-11-19 09:25:00',4500,'Assistenza su pc client Corrado per problemi su Outlook',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-28 11:50:48','2021-11-19'),
(1052,3,1,18,'2021-11-19 09:35:00','2021-11-19 09:55:00',1200,'Assistenza su pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-06 09:07:36','2021-11-19'),
(1053,3,1,10,'2021-11-19 10:10:00','2021-11-19 10:30:00',1200,'Installate 3 licenze nod32 aggiornamento su 6 pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-22 15:33:40','2021-11-19'),
(1054,3,4,75,'2021-11-19 15:00:00','2021-11-19 16:00:00',3600,'Aggiornamento hw su pc client Erica, clonato s.o + assistenza\r\nUtilizzato: SSD 480gb',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-29 15:39:48','2021-11-19'),
(1055,1,1,1,'2021-11-19 15:34:00','2021-11-19 17:30:00',6960,'agg centraluino',87,NULL,45,1,'Europe/Rome',87,1,'work','2022-01-18 15:48:02','2021-11-19'),
(1056,1,1,3,'2021-11-19 13:37:00','2021-11-19 15:00:00',4980,'in lab',62.25,NULL,45,1,'Europe/Rome',62.25,1,'work','2021-11-22 10:34:37','2021-11-19'),
(1057,1,1,90,'2021-11-19 08:42:00','2021-11-19 11:21:00',9540,'agg server',119.25,NULL,45,1,'Europe/Rome',119.25,1,'work','2022-03-01 14:58:50','2021-11-19'),
(1058,1,3,112,'2021-11-22 09:48:00','2021-11-22 11:03:29',4529,NULL,56.61,NULL,45,1,'Europe/Rome',56.61,1,'work','2021-11-29 17:03:13','2021-11-22'),
(1059,1,1,1,'2021-11-22 11:04:00','2021-11-22 11:22:00',1080,'config stampante bancone, test dopo agg 3cx',13.5,NULL,45,1,'Europe/Rome',13.5,1,'work','2022-01-18 15:48:19','2021-11-22'),
(1060,1,1,1,'2021-11-22 07:33:00','2021-11-22 09:29:00',6960,'test agg 3cx',87,NULL,45,1,'Europe/Rome',87,1,'work','2022-01-18 15:48:06','2021-11-22'),
(1061,1,1,81,'2021-11-22 13:43:00','2021-11-22 15:03:00',4800,'problemi connessione vpn',60,NULL,45,1,'Europe/Rome',60,1,'work','2021-12-07 09:45:41','2021-11-22'),
(1062,1,3,112,'2021-11-22 15:05:00','2021-11-22 15:50:00',2700,NULL,33.75,NULL,45,1,'Europe/Rome',33.75,1,'work','2021-11-29 17:03:12','2021-11-22'),
(1063,3,2,41,'2021-11-22 09:15:00','2021-11-22 12:05:00',10200,'Assistenza su pc client Gulli per problemi sulla stampante ad aghi, consegna e installazione nuovo nastro inchiostro, devono sentire Byte per verificare eventuali problemi sul loro gestionale',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-29 16:03:12','2021-11-22'),
(1064,3,1,29,'2021-11-22 16:00:00','2021-11-22 16:20:00',1200,'Installate 3 licenze nod32 aggiornamento su 6 pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-16 16:25:28','2021-11-22'),
(1065,3,1,26,'2021-11-22 16:25:00','2021-11-22 16:35:00',600,'Installate 1 licenza nod32 aggiornamento su 2 pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-17 16:43:42','2021-11-22'),
(1066,3,2,26,'2021-11-23 10:40:00','2021-11-23 11:40:00',3600,'Consegna toner e cartucce \r\nAssistenza su PC client Sola\r\nAssistenza su PC client Simona',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-17 16:43:44','2021-11-23'),
(1067,3,2,17,'2021-11-23 12:05:00','2021-11-23 12:25:00',1200,'Ritirato vecchio PC usato da server per assistenza \r\nAssistenza su PC client Semino',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-16 14:46:13','2021-11-23'),
(1068,1,1,4,'2021-11-23 14:10:00','2021-11-23 15:34:00',5040,'assegnazione ip e routing porte nuovo pc gestionale\r\n15:34 16:34 agg vm server',63,NULL,45,1,'Europe/Rome',63,1,'work','2021-12-06 16:39:17','2021-11-23'),
(1069,1,1,3,'2021-11-23 07:30:00','2021-11-23 08:25:00',3300,'per test fibra',41.25,NULL,45,1,'Europe/Rome',41.25,1,'work','2021-12-28 14:55:45','2021-11-23'),
(1070,1,1,88,'2021-11-23 15:44:00','2021-11-23 17:48:00',7440,'problemi pc dove è stata sostiutita vga per problemi di memoria',93,NULL,45,1,'Europe/Rome',93,1,'work','2021-12-30 16:52:07','2021-11-23'),
(1071,1,1,90,'2021-11-23 08:47:00','2021-11-23 10:00:00',4380,'agg server',54.75,NULL,45,1,'Europe/Rome',54.75,1,'work','2022-03-01 14:58:51','2021-11-23'),
(1072,1,1,1,'2021-11-23 10:10:00','2021-11-23 11:29:00',4740,'3cx problemi',59.25,NULL,45,1,'Europe/Rome',59.25,1,'work','2022-02-10 15:07:55','2021-11-23'),
(1073,1,1,4,'2021-11-24 08:47:00','2021-11-24 10:04:21',4641,'vm danea bloccata su aggiornamento',58.01,NULL,45,1,'Europe/Rome',58.01,1,'work','2021-12-06 16:37:50','2021-11-24'),
(1074,1,1,2,'2021-11-02 07:46:00','2021-11-02 08:15:00',1740,'server nuovo',21.75,NULL,45,1,'Europe/Rome',21.75,1,'work','2022-02-10 14:51:49','2021-11-02'),
(1075,1,1,2,'2021-11-02 10:15:00','2021-11-02 11:28:00',4380,'server nuovo',54.75,NULL,45,1,'Europe/Rome',54.75,1,'work','2022-02-10 14:51:48','2021-11-02'),
(1076,1,1,2,'2021-11-02 13:49:00','2021-11-02 17:30:00',13260,'Backup locali e remoti del nuovo server',165.75,NULL,45,1,'Europe/Rome',165.75,1,'work','2022-02-10 14:37:41','2021-11-02'),
(1077,1,1,53,'2021-11-03 07:43:00','2021-11-03 08:00:00',1020,'riavvio copia',12.75,NULL,45,1,'Europe/Rome',12.75,1,'work','2022-02-10 14:14:05','2021-11-03'),
(1078,1,1,1,'2021-11-03 09:47:00','2021-11-03 11:30:00',6180,'firewall per borzoli agg bulseye e problmi lan',77.25,NULL,45,1,'Europe/Rome',77.25,1,'work','2022-01-18 16:01:05','2021-11-03'),
(1079,1,1,1,'2021-11-03 13:46:00','2021-11-03 15:40:00',6840,'firewall per borzoli agg bulseye e problmi lan',85.5,NULL,45,1,'Europe/Rome',85.5,1,'work','2022-01-18 16:01:11','2021-11-03'),
(1080,1,1,45,'2021-11-03 16:44:00','2021-11-03 17:30:00',2760,'problemi server si riavvia',34.5,NULL,45,1,'Europe/Rome',34.5,1,'work','2021-12-30 17:28:24','2021-11-03'),
(1081,1,1,50,'2021-11-03 16:01:00','2021-11-03 16:40:00',2340,'problemi backup proxmox',29.25,NULL,45,1,'Europe/Rome',29.25,1,'work','2021-11-29 17:03:34','2021-11-03'),
(1082,1,4,3,'2021-11-04 07:30:00','2021-11-04 08:13:00',2580,NULL,32.25,NULL,45,1,'Europe/Rome',32.25,1,'work','2021-12-28 14:55:38','2021-11-04'),
(1083,1,1,1,'2021-11-04 08:30:00','2021-11-04 09:27:00',3420,'test scheda rete firewall borzoli',42.75,NULL,45,1,'Europe/Rome',42.75,1,'work','2022-02-10 17:22:51','2021-11-04'),
(1084,1,1,50,'2021-11-04 09:46:00','2021-11-04 11:30:00',6240,'proxmox problemi backup',78,NULL,45,1,'Europe/Rome',78,1,'work','2021-11-29 17:03:35','2021-11-04'),
(1085,1,1,90,'2021-11-04 13:46:00','2021-11-04 14:08:00',1320,'verifica per montaggio dischi nuovui',16.5,NULL,45,1,'Europe/Rome',16.5,1,'work','2022-03-01 14:58:45','2021-11-04'),
(1086,1,1,50,'2021-11-04 14:10:00','2021-11-04 15:00:00',3000,'proxmox problema bakcuop',37.5,NULL,45,1,'Europe/Rome',37.5,1,'work','2021-11-29 17:03:36','2021-11-04'),
(1087,1,1,96,'2021-11-05 07:47:00','2021-11-05 09:48:00',7260,'risoluzione problema di servizi ago bloccati al mattino',90.75,NULL,45,1,'Europe/Rome',90.75,1,'work','2021-12-13 17:24:01','2021-11-05'),
(1088,1,2,41,'2021-11-05 14:30:00','2021-11-05 16:50:00',8400,'sistemazione armadio con ciro',105,NULL,45,1,'Europe/Rome',105,1,'work','2021-12-06 17:35:17','2021-11-05'),
(1089,1,1,41,'2021-11-05 10:19:00','2021-11-05 11:19:00',3600,'preparazione per lavoro del pomeriggio',45,NULL,45,1,'Europe/Rome',45,1,'work','2021-12-06 17:02:04','2021-11-05'),
(1090,1,1,41,'2021-11-08 07:42:00','2021-11-08 08:10:00',1680,'problemi centralino vecchio dopo nostro lavoro',21,NULL,45,1,'Europe/Rome',21,1,'work','2021-12-06 17:35:18','2021-11-08'),
(1091,1,1,51,'2021-11-08 10:06:00','2021-11-08 10:24:00',1080,'problema stamapnte',13.5,NULL,45,1,'Europe/Rome',13.5,1,'work','2022-03-07 14:39:57','2021-11-08'),
(1092,1,1,50,'2021-11-08 08:38:00','2021-11-08 10:00:00',4920,'proxmox backup',61.5,NULL,45,1,'Europe/Rome',61.5,1,'work','2021-11-29 17:03:37','2021-11-08'),
(1093,1,1,2,'2021-11-08 16:52:00','2021-11-08 17:26:00',2040,'server nuovo',25.5,NULL,45,1,'Europe/Rome',25.5,1,'work','2022-02-10 14:52:15','2021-11-08'),
(1094,1,1,50,'2021-11-10 15:12:00','2021-11-10 16:00:00',2880,'proxmox backup',36,NULL,45,1,'Europe/Rome',36,1,'work','2021-11-29 17:03:38','2021-11-10'),
(1095,1,1,50,'2021-11-10 16:40:00','2021-11-10 17:25:00',2700,'proxmox backup',33.75,NULL,45,1,'Europe/Rome',33.75,1,'work','2021-11-29 17:03:39','2021-11-10'),
(1096,1,1,104,'2021-11-11 14:27:00','2021-11-11 14:49:00',1320,'verifica controller che ha dato errore',16.5,NULL,45,1,'Europe/Rome',16.5,1,'work','2022-02-10 11:45:50','2021-11-11'),
(1097,1,1,3,'2021-11-11 09:50:00','2021-11-11 11:30:00',6000,'lxc studio',75,NULL,45,1,'Europe/Rome',75,1,'work','2021-12-28 14:55:39','2021-11-11'),
(1098,1,1,2,'2021-11-11 13:40:00','2021-11-11 14:17:00',2220,'backup vm su nas',27.75,NULL,45,1,'Europe/Rome',27.75,1,'work','2022-02-10 14:52:04','2021-11-11'),
(1099,1,1,50,'2021-11-12 13:40:00','2021-11-12 15:35:00',6900,'ancora problemi dopo backup proxmox',86.25,NULL,45,1,'Europe/Rome',86.25,1,'work','2021-11-29 17:03:40','2021-11-12'),
(1100,1,1,2,'2021-11-12 15:48:00','2021-11-12 17:30:00',6120,'backup vm su nas',76.5,NULL,45,1,'Europe/Rome',76.5,1,'work','2022-02-10 14:51:54','2021-11-12'),
(1101,3,4,17,'2021-11-24 08:30:00','2021-11-24 10:00:00',5400,'Reinstallazione sistema operativo su pc client che veniva utilizzato come Server\r\nUtilizzato: ssd 480gb Crucial',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-16 14:46:14','2021-11-24'),
(1102,3,1,24,'2021-11-24 10:50:00','2021-11-24 11:00:00',600,'Assistenza su pc client Monica',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-02 14:42:23','2021-11-24'),
(1103,3,1,79,'2021-11-24 14:55:00','2021-11-24 15:15:00',1200,'Assistenza su pc client Andrea Parodi',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-04 18:21:20','2021-11-24'),
(1104,3,1,1,'2021-11-24 16:15:00','2021-11-24 16:55:00',2400,'Assistenza su pc client Francesco sede Borzoli per problemi a stampare dal gestionale',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-10 17:22:58','2021-11-24'),
(1105,1,1,5,'2021-11-25 08:14:00','2021-11-25 09:50:44',5804,'ottimizzazione script per upload remoto del file industry40.xml',72.55,NULL,45,1,'Europe/Rome',72.55,1,'work','2021-12-28 14:50:45','2021-11-25'),
(1106,1,6,83,'2021-11-25 09:53:00','2021-11-25 10:05:00',720,'Per itnervento sulle stampanti e aggiornamento gestionale',9,NULL,45,1,'Europe/Rome',9,1,'work','2021-12-28 15:20:40','2021-11-25'),
(1107,3,2,17,'2021-11-25 10:15:00','2021-11-25 12:15:00',7200,'Riconsegna e configurazione vecchio PC client usato come server',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-16 14:46:15','2021-11-25'),
(1108,3,2,12,'2021-11-25 12:45:00','2021-11-25 13:25:00',2400,'Verificato e ritirato pc client Valentina per assistenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-28 11:14:25','2021-11-25'),
(1109,3,2,91,'2021-11-25 13:45:00','2021-11-25 14:15:00',1800,'Assistenza su PC client Raffaele per problemi con microfono',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-02 10:44:45','2021-11-25'),
(1110,1,1,95,'2021-11-25 15:33:00','2021-11-25 16:28:00',3300,'collegamento remoto mara',41.25,NULL,45,1,'Europe/Rome',41.25,1,'work','2021-12-30 17:26:29','2021-11-25'),
(1111,3,1,61,'2021-11-25 08:50:00','2021-11-25 09:05:00',900,'Assistenza su pc client per problemi posta elettronica',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-28 11:24:23','2021-11-25'),
(1112,1,1,79,'2021-11-25 10:14:00','2021-11-25 11:22:00',4080,'prolbema ssl cercato di risolvere',51,NULL,45,1,'Europe/Rome',51,1,'work','2022-03-04 18:21:21','2021-11-25'),
(1113,1,1,4,'2021-11-25 16:32:00','2021-11-25 17:23:00',3060,'Prima config per accesso remoto a nuovo pc per trasferimento dati',38.25,NULL,45,1,'Europe/Rome',38.25,1,'work','2021-12-28 11:50:49','2021-11-25'),
(1114,1,1,103,'2021-11-26 08:48:00','2021-11-26 11:19:00',9060,'Ora indietro di 10 min sul server, questo imedisce ai client di accedere a servizi certificati',113.25,NULL,45,1,'Europe/Rome',113.25,1,'work','2021-12-03 16:47:54','2021-11-26'),
(1115,3,2,83,'2021-11-26 10:00:00','2021-11-26 11:45:00',6300,'Assistenza su stampanti condivise per problemi dopo aggiornamenti Windows \r\nAssistenza su PC client\r\nSentita Assistenza Arca per pianificare lavoro aggiornamento sql su loro Server (lo fanno loro)\r\nFare offerta per un Netserver',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-28 15:45:06','2021-11-26'),
(1116,1,1,66,'2021-11-26 15:01:00','2021-11-26 15:38:00',2220,'agg nas backup',27.75,NULL,45,1,'Europe/Rome',27.75,1,'work','2021-12-28 11:01:55','2021-11-26'),
(1117,3,2,66,'2021-11-26 14:00:00','2021-11-26 17:30:00',12600,'Assistenza e aggiornamenti su NAS\r\nFatto backup completo del PC sul NAS\r\nAssistenza su PC client\r\nPulizia polvere su PC client',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-28 11:01:53','2021-11-26'),
(1118,1,1,4,'2021-11-26 16:37:00','2021-11-26 17:28:00',3060,'trasferimento dati da vecchio pc alessandra',38.25,NULL,45,1,'Europe/Rome',38.25,1,'work','2021-12-28 11:50:50','2021-11-26'),
(1119,1,1,2,'2021-11-26 13:40:00','2021-11-26 14:13:00',1980,'baco ora di windows server',24.75,NULL,45,1,'Europe/Rome',24.75,1,'work','2022-02-10 14:52:03','2021-11-26'),
(1120,1,1,5,'2021-11-26 14:20:00','2021-11-26 14:56:00',2160,'baco ora windows server',27,NULL,45,1,'Europe/Rome',27,1,'work','2021-12-28 14:50:46','2021-11-26'),
(1121,1,1,100,'2021-11-26 15:44:00','2021-11-26 16:16:00',1920,'tentativo di pulizia disco. avvisati di cancellare file',24,NULL,45,1,'Europe/Rome',24,1,'work','2022-01-31 14:44:36','2021-11-26'),
(1122,3,1,61,'2021-11-26 08:00:00','2021-11-26 08:30:00',1800,'Assistenza per problemi posta elettronica su Outlook',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-28 11:24:24','2021-11-26'),
(1123,3,1,79,'2021-11-26 08:35:00','2021-11-26 08:45:00',600,'Assistenza su PC client Silvia',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-04 18:21:22','2021-11-26'),
(1124,3,4,12,'2021-11-26 08:50:00','2021-11-26 09:50:00',3600,'Assistenza su PC client Valentina per reinstallazione sistema operativo \r\nUtilizzatto: ssd 480gb',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-28 11:14:27','2021-11-26'),
(1125,3,2,108,'2021-11-29 08:50:00','2021-11-29 09:20:00',1800,'Assistenza su server per problemi avvio dopo spegnimento improvviso causa temporale',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-22 10:20:40','2021-11-29'),
(1126,1,3,112,'2021-11-29 07:30:00','2021-11-29 09:00:00',5400,NULL,67.5,NULL,45,1,'Europe/Rome',67.5,1,'work','2021-11-29 17:03:11','2021-11-29'),
(1127,1,1,90,'2021-11-29 09:52:00','2021-11-29 10:25:00',1980,'installazione vm lxc per unifi',24.75,NULL,45,1,'Europe/Rome',24.75,1,'work','2022-03-01 14:58:53','2021-11-29'),
(1128,3,2,75,'2021-11-29 10:35:00','2021-11-29 11:05:00',1800,'Riconsegna pc client Erica dopo assistenza \r\nSopralluogo per lavoro spostamento postazioni client',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-11-29 15:39:49','2021-11-29'),
(1129,1,1,50,'2021-11-29 09:09:00','2021-11-29 09:47:00',2280,'verifica per salto backup remoto',28.5,NULL,45,1,'Europe/Rome',28.5,1,'work','2021-11-29 17:03:41','2021-11-29'),
(1130,3,2,90,'2021-11-29 11:15:00','2021-11-29 12:00:00',2700,'Consegna e configurazione Unifi Obiquity \r\nVerifica funzionamento loro software Cyclone',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-01 14:58:55','2021-11-29'),
(1131,3,1,79,'2021-11-29 07:40:00','2021-11-29 08:10:00',1800,'Assistenza per problema avvio server dopo che è mancata la corrente',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-04 18:21:23','2021-11-29'),
(1132,3,1,108,'2021-11-29 08:10:00','2021-11-29 08:20:00',600,'Assistenza per problema avvio server dopo che è mancata la corrente',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-22 10:20:39','2021-11-29'),
(1133,3,1,67,'2021-11-29 08:20:00','2021-11-29 08:35:00',900,'Assistenza per problemi collegamento al Teleselling',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-07 21:42:34','2021-11-29'),
(1134,3,1,17,'2021-11-29 13:50:00','2021-11-29 14:05:00',900,'Assistenza su pc client Enrica per problemi collegamento alla stampante',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-16 14:46:16','2021-11-29'),
(1135,3,1,61,'2021-11-29 15:50:00','2021-11-29 16:40:00',3000,'Assistenza su pc client Cristina per problemi sulla rubrica di Outlook',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-28 11:24:25','2021-11-29'),
(1136,1,1,51,'2021-11-30 08:32:00','2021-11-30 09:00:00',1680,'problema browser safari',21,NULL,45,1,'Europe/Rome',21,1,'work','2022-03-07 14:39:59','2021-11-30'),
(1137,3,2,12,'2021-11-30 09:25:00','2021-11-30 10:25:00',3600,'Riconsegna e configurazione PC client Valentina dopo reinstallazione sistema operativo \r\nAssistenza su PC client Lavanda',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-28 11:14:27','2021-11-30'),
(1138,1,4,3,'2021-11-30 07:30:00','2021-11-30 08:30:00',3600,'sistemato server tms PIEDINI SOCKET CPU PIEGATI',45,NULL,45,1,'Europe/Rome',45,1,'work','2021-12-28 14:55:47','2021-11-30'),
(1139,1,4,3,'2021-11-30 09:01:00','2021-11-30 11:40:00',9540,'sistemato server tms PIEDINI SOCKET CPU PIEGATI',119.25,NULL,45,1,'Europe/Rome',119.25,1,'work','2021-12-28 14:55:48','2021-11-30'),
(1140,1,2,41,'2021-11-30 13:20:00','2021-11-30 17:15:00',14100,'con te per consegna e installazione armadio',176.25,NULL,45,1,'Europe/Rome',176.25,1,'work','2021-12-30 08:00:04','2021-11-30'),
(1141,3,1,10,'2021-11-30 07:40:00','2021-11-30 07:55:00',900,'Assistenza sul server per liberare spazio su cartella Condivisi',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-28 11:17:27','2021-11-30'),
(1142,3,1,51,'2021-11-30 08:00:00','2021-11-30 08:10:00',600,'Assistenza su mac Burdese per problemi accesso a Mexal utilizzando Chrome',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-07 14:39:58','2021-11-30'),
(1143,3,1,88,'2021-11-30 13:40:00','2021-11-30 14:00:00',1200,'Modifica configurazione ricezione telefoni su centralino 3cx',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-28 16:27:29','2021-11-30'),
(1144,3,1,18,'2021-11-30 14:10:00','2021-11-30 14:25:00',900,'Assistenza su pc client per problemi con posta elettronica',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-06 09:07:37','2021-11-30'),
(1145,1,1,103,'2021-12-01 08:28:00','2021-12-01 09:14:00',2760,'pc martina ha tolto l\'accesso a C: all\'utente',34.5,NULL,45,1,'Europe/Rome',34.5,1,'work','2021-12-03 17:12:48','2021-12-01'),
(1146,3,2,103,'2021-12-01 10:45:00','2021-12-01 11:45:00',3600,'Verificato e ritirato pc client Martina che non accede più al disco C',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-03 17:12:49','2021-12-01'),
(1147,3,4,103,'2021-12-01 13:45:00','2021-12-01 14:45:00',3600,'Reinstallazione sistema operativo su pc client Martina',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-03 17:12:50','2021-12-01'),
(1148,3,2,103,'2021-12-02 07:40:00','2021-12-02 09:05:00',5100,'Riconsegna e configurazione PC client Martina dopo reinstallazione sistema operativo',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-03 17:12:51','2021-12-02'),
(1149,1,1,2,'2021-12-02 08:56:00','2021-12-02 09:29:05',1985,'problemi pc francesca',24.81,NULL,45,1,'Europe/Rome',24.81,1,'work','2022-02-10 14:52:02','2021-12-02'),
(1150,1,1,81,'2021-12-02 10:45:00','2021-12-02 11:15:00',1800,'problemi vpn risolti',22.5,NULL,45,1,'Europe/Rome',22.5,1,'work','2021-12-07 09:45:42','2021-12-02'),
(1151,3,2,1,'2021-12-02 11:40:00','2021-12-02 12:20:00',2400,'Risolto problema su PC client Alberto \r\nRigenerato e collegato ups a PC client Alberto\r\nUtilizzato: 1 batteria UPS, 2 cavi alim ups',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-10 17:23:00','2021-12-02'),
(1152,3,2,17,'2021-12-02 12:35:00','2021-12-02 13:00:00',1500,'Verifica e sostituzione alimentatore su pc client Dino\r\nUtilizzato: alim. Cm 395638',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-16 14:46:17','2021-12-02'),
(1153,3,2,96,'2021-12-02 13:00:00','2021-12-02 13:40:00',2400,'Verificato e ritirato ups Antonella\r\nDa portare 2 tastiere usb',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-13 17:24:01','2021-12-02'),
(1154,1,3,112,'2021-12-02 13:30:00','2021-12-02 15:06:00',5760,NULL,72,NULL,45,1,'Europe/Rome',72,1,'work','2021-12-28 14:52:09','2021-12-02'),
(1155,1,1,88,'2021-12-02 07:51:00','2021-12-02 08:19:00',1680,'varie richieste',21,NULL,45,1,'Europe/Rome',21,1,'work','2021-12-30 16:52:09','2021-12-02'),
(1156,1,1,88,'2021-12-02 15:55:00','2021-12-02 17:12:00',4620,'varie richieste',57.75,NULL,45,1,'Europe/Rome',57.75,1,'work','2021-12-30 16:52:10','2021-12-02'),
(1157,3,1,100,'2021-12-02 10:00:00','2021-12-02 10:10:00',600,'Assistenza per problemi ricezione posta su iphone',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-01-31 14:59:38','2021-12-02'),
(1158,3,2,84,'2021-12-02 10:30:00','2021-12-02 11:10:00',2400,'Assistenza su pc client per problemi con Office 2007, da offrire nuova licenza di Office 2021',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-27 16:02:01','2021-12-02'),
(1159,3,2,64,'2021-12-03 08:35:00','2021-12-03 09:35:00',3600,'Consegna e configurazione 2 nuovi portatili Valentina e Alessandro \r\nDa fare lavoro vpn su portatile Valentina',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-28 10:56:29','2021-12-03'),
(1160,3,2,17,'2021-12-03 16:00:00','2021-12-03 16:20:00',1200,'Verificate e ritirate 2 stampanti Epson WF 5620 per assistenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-16 14:46:18','2021-12-03'),
(1161,3,2,96,'2021-12-03 16:40:00','2021-12-03 17:15:00',2100,'Consegna e installazione nuovo PC Antonella \r\nConsegna 2 tastiere USB\r\nSpostato unifi obiquity\r\nConfigurato messaggio segr. Telefonica',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-13 17:24:02','2021-12-03'),
(1162,3,1,12,'2021-12-03 18:00:00','2021-12-03 18:20:00',1200,'installata e configurata vpn su ma casa Camilla Corsi',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-28 11:14:28','2021-12-03'),
(1163,3,2,1,'2021-12-03 13:35:00','2021-12-03 13:45:00',600,'Consegnati 5 KMV Switch in sede a Borzoli',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-30 17:36:18','2021-12-03'),
(1164,1,3,112,'2021-11-15 07:30:00','2021-11-15 08:45:00',4500,NULL,56.25,NULL,45,1,'Europe/Rome',56.25,1,'work','2021-12-28 14:51:17','2021-11-15'),
(1165,1,1,41,'2021-11-15 08:51:00','2021-11-15 10:20:00',5340,'prep per installa patton e centralino nuovo',66.75,NULL,45,1,'Europe/Rome',66.75,1,'work','2021-12-30 08:00:03','2021-11-15'),
(1166,1,6,50,'2021-11-15 14:00:00','2021-11-15 14:00:00',0,'per spegnimenti vari di domani',0,NULL,45,1,'Europe/Rome',0,1,'work','2021-12-28 15:19:56','2021-11-15'),
(1167,1,1,29,'2021-11-15 14:10:00','2021-11-15 16:19:00',7740,'agg backuppc su nas',96.75,NULL,45,1,'Europe/Rome',96.75,1,'work','2021-12-16 16:25:28','2021-11-15'),
(1168,1,1,3,'2021-11-17 07:48:00','2021-11-17 09:28:00',6000,'proxmox test',75,NULL,45,1,'Europe/Rome',75,1,'work','2021-12-28 14:55:40','2021-11-17'),
(1169,1,1,2,'2021-11-17 13:53:00','2021-11-17 16:00:00',7620,'backup remoti',95.25,NULL,45,1,'Europe/Rome',95.25,1,'work','2022-02-10 14:34:47','2021-11-17'),
(1170,1,1,3,'2021-11-18 13:43:00','2021-11-18 14:42:00',3540,'nextclouid per interventi e attività',44.25,NULL,45,1,'Europe/Rome',44.25,1,'work','2021-12-28 14:55:40','2021-11-18'),
(1171,1,1,24,'2021-11-18 16:17:00','2021-11-18 17:30:00',4380,'agg windows centralino',54.75,NULL,45,1,'Europe/Rome',54.75,1,'work','2021-12-28 14:52:43','2021-11-18'),
(1172,1,1,3,'2021-11-22 16:00:00','2021-11-22 17:29:00',5340,'ripristino kimai su vm per ipotetiche necessità',66.75,NULL,45,1,'Europe/Rome',66.75,1,'work','2021-12-28 14:55:44','2021-11-22'),
(1173,1,1,3,'2021-11-24 07:30:00','2021-11-24 08:27:00',3420,'fogli',42.75,NULL,45,1,'Europe/Rome',42.75,1,'work','2021-12-28 14:55:46','2021-11-24'),
(1174,1,1,50,'2021-11-24 10:17:00','2021-11-24 11:26:00',4140,'agg firmware telefoni',51.75,NULL,45,1,'Europe/Rome',51.75,1,'work','2021-12-28 15:19:57','2021-11-24'),
(1175,1,1,50,'2021-11-24 13:41:00','2021-11-24 14:16:00',2100,'agg firmware telefoni',26.25,NULL,45,1,'Europe/Rome',26.25,1,'work','2021-12-28 15:19:58','2021-11-24'),
(1176,1,1,58,'2021-11-24 14:30:00','2021-11-24 16:00:00',5400,'preparazione aggiornamento centralino senza bloccare dealer',67.5,NULL,45,1,'Europe/Rome',67.5,1,'work','2022-05-04 14:34:13','2021-11-24'),
(1177,1,1,3,'2021-11-24 16:12:00','2021-11-24 17:20:00',4080,'fogli',51,NULL,45,1,'Europe/Rome',51,1,'work','2021-12-28 14:55:41','2021-11-24'),
(1178,1,1,2,'2021-11-25 13:48:00','2021-11-25 15:13:00',5100,'server nuovo',63.75,NULL,45,1,'Europe/Rome',63.75,1,'work','2022-02-10 14:51:51','2021-11-25'),
(1179,1,3,112,'2021-11-26 07:30:00','2021-11-26 08:00:00',1800,NULL,22.5,NULL,45,1,'Europe/Rome',22.5,1,'work','2021-12-28 14:51:18','2021-11-26'),
(1180,1,1,90,'2021-11-29 10:50:00','2021-11-29 11:23:00',1980,'agg nextclodu parziale',24.75,NULL,45,1,'Europe/Rome',24.75,1,'work','2022-03-01 14:58:52','2021-11-29'),
(1181,1,1,96,'2021-11-29 13:40:00','2021-11-29 15:19:00',5940,'3cx agg firmware',74.25,NULL,45,1,'Europe/Rome',74.25,1,'work','2021-12-13 16:51:57','2021-11-29'),
(1182,1,1,1,'2021-11-29 15:43:00','2021-11-29 17:23:00',6000,'agg firmware telefoni e sempre problemi passaggio chiamata',75,NULL,45,1,'Europe/Rome',75,1,'work','2021-12-30 17:36:40','2021-11-29'),
(1183,1,1,50,'2021-10-08 06:45:00','2021-10-08 07:20:00',2100,'problema backup vm neido',26.25,NULL,45,1,'Europe/Rome',26.25,1,'work','2021-12-28 15:19:55','2021-10-08'),
(1184,3,2,41,'2021-12-06 07:45:00','2021-12-06 09:15:00',5400,'Iniziato lavoro sostituzione PC client Roberta, ritirato vecchio PC per ultimare lavoro in Lab.',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-30 08:00:05','2021-12-06'),
(1185,3,2,108,'2021-12-06 11:00:00','2021-12-06 11:45:00',2700,'Verificato vecchi PC client/stampanti da smaltire\r\nRitirato vecchio PC client per verificare contenuto',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-22 10:20:42','2021-12-06'),
(1186,3,2,103,'2021-12-06 14:35:00','2021-12-06 15:35:00',3600,'Consegnato e collegato nuovo server per allineamento e test configurazione \r\nConsegnato e installato nuovo ups su PC client Martina\r\nSostituzione disco da 2 tb BAD sul NAS con disco da 4tb',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-16 16:28:47','2021-12-06'),
(1187,3,1,10,'2021-12-06 10:35:00','2021-12-06 10:45:00',600,'Assistenza su pc client Carmen',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-28 11:17:28','2021-12-06'),
(1188,3,2,41,'2021-12-07 08:10:00','2021-12-07 09:25:00',4500,'Consegna e configurazione nuovo PC client Roberta\r\nCollegamento usb stampante HP al server\r\nRitirato dispositivo Buffalo + 3 ups da verificare\r\nUtilizzato: prolunga usb da 5mt',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-30 08:00:08','2021-12-07'),
(1189,3,2,83,'2021-12-07 11:20:00','2021-12-07 13:00:00',6000,'Consegna, installazione e configurazione printer server su stampante usb ad aghi\r\nSentire Arca per risolvere problematiche su 2 PC client',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-28 15:45:08','2021-12-07'),
(1190,1,3,112,'2021-12-07 10:25:00','2021-12-07 11:30:00',3900,NULL,48.75,NULL,45,1,'Europe/Rome',48.75,1,'work','2021-12-28 14:52:10','2021-12-07'),
(1191,1,3,112,'2021-12-07 13:30:00','2021-12-07 14:00:00',1800,NULL,22.5,NULL,45,1,'Europe/Rome',22.5,1,'work','2021-12-28 14:52:11','2021-12-07'),
(1192,1,1,2,'2021-12-07 07:50:00','2021-12-07 08:28:00',2280,'problema telecamere',28.5,NULL,45,1,'Europe/Rome',28.5,1,'work','2022-02-10 14:51:39','2021-12-07'),
(1193,1,1,41,'2021-12-06 13:38:00','2021-12-06 15:00:00',4920,'analisi server wagner switch managed e configurazione 4 schede di rete',61.5,NULL,45,1,'Europe/Rome',61.5,1,'work','2021-12-30 08:00:07','2021-12-06'),
(1194,1,1,103,'2021-12-06 15:10:00','2021-12-06 17:30:00',8400,'reinstalazione nuovo server e copia dati',105,NULL,45,1,'Europe/Rome',105,1,'work','2021-12-16 16:28:48','2021-12-06'),
(1195,1,1,41,'2021-12-06 10:01:00','2021-12-06 11:26:00',5100,'analisi server wagner switch managed e configurazione 4 schede di rete',63.75,NULL,45,1,'Europe/Rome',63.75,1,'work','2021-12-30 08:00:06','2021-12-06'),
(1196,3,1,41,'2021-12-07 10:20:00','2021-12-07 10:50:00',1800,'Assistenza su nuovo pc client Roberta',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-30 08:00:09','2021-12-07'),
(1197,3,1,79,'2021-12-07 10:50:00','2021-12-07 11:10:00',1200,'Assistenza su su pc client Elena per problemi spazio su disco C',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-04 18:21:24','2021-12-07'),
(1198,3,1,55,'2021-12-07 13:35:00','2021-12-07 14:00:00',1500,'Assistenza su pc client Floriana per problemi con Adobe Reader',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-28 16:26:33','2021-12-07'),
(1199,3,2,79,'2021-12-07 14:00:00','2021-12-07 14:25:00',1500,'Assistenza su pc client Elena per problama su file pst danneggiato',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-04 18:21:25','2021-12-07'),
(1200,3,1,79,'2021-12-07 14:45:00','2021-12-07 14:55:00',600,'Assistenza su pc client Matteo',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-04 18:21:26','2021-12-07'),
(1201,3,1,32,'2021-12-07 15:15:00','2021-12-07 15:45:00',1800,'Assistenza su pc client Luca per problemi con gli agg di eBridge',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-01-20 15:47:34','2021-12-07'),
(1202,1,1,81,'2021-12-07 17:38:00','2021-12-07 17:58:00',1200,'configurazione vpn su portatile nuovo',15,NULL,45,1,'Europe/Rome',15,1,'work','2021-12-16 14:06:06','2021-12-07'),
(1203,1,1,103,'2021-12-07 15:58:00','2021-12-07 17:30:00',5520,'copia configurazioni firewall vpn isc dhcp',69,NULL,45,1,'Europe/Rome',69,1,'work','2021-12-16 16:28:49','2021-12-07'),
(1204,1,1,2,'2021-12-07 14:10:00','2021-12-07 15:42:00',5520,'agg nas telecamere problemi invio segnalazioni telecamera',69,NULL,45,1,'Europe/Rome',69,1,'work','2022-02-10 14:51:39','2021-12-07'),
(1205,1,1,3,'2021-12-07 08:42:00','2021-12-07 10:21:00',5940,'vm per invio virus',74.25,NULL,45,1,'Europe/Rome',74.25,1,'work','2021-12-28 14:55:48','2021-12-07'),
(1206,3,2,83,'2021-12-09 09:00:00','2021-12-09 09:35:00',2100,'Assistenza su PC client Luigi per sistema operativo bloccato',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-28 15:45:08','2021-12-09'),
(1207,3,2,90,'2021-12-09 10:25:00','2021-12-09 10:45:00',1200,'Sostituzione disco da 4tb WD red su server Linux',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-01 14:58:54','2021-12-09'),
(1208,3,2,29,'2021-12-09 14:15:00','2021-12-09 15:40:00',5100,'Verifica e pulizia periodica su tutti i PC client\r\nVerifica e pulizia periodica sul Server + rimontato hhd da 4tb di backup',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-16 16:25:29','2021-12-09'),
(1209,1,1,4,'2021-12-09 16:17:00','2021-12-09 17:30:00',4380,'migrazione nuovo pc',54.75,NULL,45,1,'Europe/Rome',54.75,1,'work','2021-12-28 11:50:51','2021-12-09'),
(1210,3,1,18,'2021-12-09 08:15:00','2021-12-09 08:35:00',1200,'Assistenza su pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-24 16:03:13','2021-12-09'),
(1211,3,1,10,'2021-12-10 09:40:00','2021-12-10 10:00:00',1200,'Assistenza su pc client Francesca per problemi con PrimoPDF',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-28 11:17:28','2021-12-10'),
(1212,3,1,64,'2021-12-10 10:25:00','2021-12-10 10:40:00',900,'Verificato e configurato router Tim per installazione VPN',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-28 10:56:30','2021-12-10'),
(1213,3,1,32,'2021-12-10 11:05:00','2021-12-10 11:20:00',900,'Assistenza su pc client Sara per problemi con tastiera',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-01-20 15:47:35','2021-12-10'),
(1214,1,1,95,'2021-12-13 07:40:00','2021-12-13 08:07:35',1655,'problema certificati ssl',20.69,NULL,45,1,'Europe/Rome',20.69,1,'work','2021-12-30 16:52:28','2021-12-13'),
(1215,1,3,112,'2021-12-13 09:30:00','2021-12-13 11:28:00',7080,NULL,88.5,NULL,45,1,'Europe/Rome',88.5,1,'work','2022-01-03 15:11:40','2021-12-13'),
(1216,3,2,81,'2021-12-13 11:00:00','2021-12-13 11:25:00',1500,'Consegna nuovo portatile HP + configurazione',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-16 14:06:07','2021-12-13'),
(1217,3,2,79,'2021-12-13 14:15:00','2021-12-13 14:40:00',1500,'Sostituzione 2 batterie su UPS APC 1400 PC client Roberto',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-04 18:21:27','2021-12-13'),
(1218,3,2,96,'2021-12-13 15:45:00','2021-12-13 16:05:00',1200,'Consegna e installazione toner HP',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-13 17:24:04','2021-12-13'),
(1219,3,2,81,'2021-12-13 16:20:00','2021-12-13 16:35:00',900,'Verificato funzionamento wifi su nuovo portatile HP',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-16 14:06:08','2021-12-13'),
(1220,3,2,12,'2021-12-13 17:00:00','2021-12-13 18:15:00',4500,'Configurazione printer server su stampante di rete, non riuscita bisogna tornare \r\nRitirato pc client Valentina per assistenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-28 11:14:29','2021-12-13'),
(1221,3,2,83,'2021-12-14 08:15:00','2021-12-14 09:35:00',4800,'Assistenza per problemi allineamento stampante ad aghi, l\'assistenza di Arca deve ancora risolvere il problema',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-28 15:45:09','2021-12-14'),
(1222,3,2,75,'2021-12-14 16:25:00','2021-12-14 17:15:00',3000,'Spostamento postazione client Franco Oneto più verifica vecchio materiale da tenere/buttare',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-28 10:50:07','2021-12-14'),
(1223,3,2,41,'2021-12-14 10:55:00','2021-12-14 11:35:00',2400,'Assistenza su stampante ad aghi PC client Gulli, recuperata configurazione Epson LX350 in via Wagner',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-24 11:23:49','2021-12-14'),
(1224,3,2,41,'2021-12-14 13:20:00','2021-12-14 15:30:00',7800,'Assistenza su stampante ad aghi PC client Gulli per problemi di formattazione, problema da risolvere con Assistenza WinToLip',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-24 11:23:50','2021-12-14'),
(1225,3,1,41,'2021-12-14 09:50:00','2021-12-14 10:10:00',1200,'Assistenza su pc client Roberta per problemi su Outlook',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-24 11:23:49','2021-12-14'),
(1226,3,1,101,'2021-12-14 10:10:00','2021-12-14 10:40:00',1800,'Assistenza su portatile casa Paola per problemi collegamento pc in ufficio',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-27 14:39:41','2021-12-14'),
(1227,3,1,26,'2021-12-14 18:10:00','2021-12-14 18:30:00',1200,'Verificato invio posta (non salvata in Posta inviata) Simona Bertetto.',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-17 16:43:43','2021-12-14'),
(1228,3,2,17,'2021-12-15 10:20:00','2021-12-15 11:30:00',4200,'Riconsegna e collegamento Epson WF5620 \r\nAssistenza su PC client Enrica, Mihai e Dino',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-16 14:46:19','2021-12-15'),
(1229,3,2,12,'2021-12-15 16:45:00','2021-12-15 17:15:00',1800,'Riconsegna e configurazione PC client Camilla dopo assistenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-28 11:14:31','2021-12-15'),
(1230,3,4,12,'2021-12-15 08:00:00','2021-12-15 09:00:00',3600,'Assistenza su pc client Camilla',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-28 11:14:30','2021-12-15'),
(1231,3,1,101,'2021-12-15 15:10:00','2021-12-15 15:30:00',1200,'Configurata mail paghe@studiovigo.eu su 3 pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-27 14:39:41','2021-12-15'),
(1232,3,1,24,'2021-12-16 10:15:00','2021-12-16 10:30:00',900,'Assistenza su pc client Gommista per problemi apertura Gestionale Zucchetti',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-01 11:38:37','2021-12-16'),
(1233,3,2,50,'2021-12-16 11:40:00','2021-12-16 11:50:00',600,'Consegna 2 toner compatibili',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-28 15:19:59','2021-12-16'),
(1234,3,2,83,'2021-12-16 16:15:00','2021-12-16 16:40:00',1500,'Sostituzione 2 batterie su ups apc 1400',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-28 15:45:10','2021-12-16'),
(1235,3,2,24,'2021-12-16 16:45:00','2021-12-16 16:55:00',600,'Consegna cartucce originali per stampante Epson',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-28 14:52:50','2021-12-16'),
(1236,1,1,2,'2021-12-17 07:57:00','2021-12-17 08:53:17',3377,'problema login pc cevasco',42.21,NULL,45,1,'Europe/Rome',42.21,1,'work','2022-02-10 14:51:58','2021-12-17'),
(1237,1,1,90,'2021-12-17 14:43:00','2021-12-17 15:08:00',1500,'problema lincese server leica',18.75,NULL,45,1,'Europe/Rome',18.75,1,'work','2022-03-01 14:58:56','2021-12-17'),
(1238,3,1,6,'2021-12-17 08:00:00','2021-12-17 08:10:00',600,'Assistenza per problemi di rete, fatto riavviare switch gigabit 24 porte',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-16 17:57:39','2021-12-17'),
(1239,3,1,64,'2021-12-17 08:15:00','2021-12-17 09:45:00',5400,'Pravata a configurare vpn su nuovo portatile casa Valentina, riscontrate difficoltà con la versione di Windows 10 Enterprise, da finire',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-28 10:56:31','2021-12-17'),
(1240,3,1,96,'2021-12-17 11:00:00','2021-12-17 11:15:00',900,'Liberato spazio su Server che era al 92%',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-08 17:14:59','2021-12-17'),
(1241,3,1,79,'2021-12-17 11:35:00','2021-12-17 11:50:00',900,'Assistenza su pc client Roberto per problemi con indirizzo pec dopo cambio password',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-04 18:21:28','2021-12-17'),
(1242,1,1,90,'2021-12-17 16:08:15','2021-12-17 16:25:25',1030,'problema lincese server leica',12.88,NULL,45,1,'Europe/Rome',12.88,1,'work','2022-03-01 14:58:57','2021-12-17'),
(1243,1,1,1,'2021-12-17 16:30:00','2021-12-17 17:30:00',3600,'problemi centralino',45,NULL,45,1,'Europe/Rome',45,1,'work','2021-12-30 17:36:14','2021-12-17'),
(1244,1,1,1,'2021-12-17 15:11:00','2021-12-17 16:00:00',2940,'problemi centralino',36.75,NULL,45,1,'Europe/Rome',36.75,1,'work','2021-12-30 17:36:08','2021-12-17'),
(1245,3,2,79,'2021-12-20 09:10:00','2021-12-20 09:25:00',900,'Assistenza su PC client Valentina',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-04 18:22:05','2021-12-20'),
(1246,1,4,3,'2021-12-20 07:30:00','2021-12-20 08:15:00',2700,'per server spento o irraggiungibile',33.75,NULL,45,1,'Europe/Rome',33.75,1,'work','2021-12-28 14:55:51','2021-12-20'),
(1247,1,1,4,'2021-12-20 09:02:00','2021-12-20 09:45:00',2580,'problema outlook pc giorgio',32.25,NULL,45,1,'Europe/Rome',32.25,1,'work','2021-12-28 11:50:52','2021-12-20'),
(1248,1,1,1,'2021-12-20 10:00:00','2021-12-20 11:23:00',4980,'config 3cx telefoni',62.25,NULL,45,1,'Europe/Rome',62.25,1,'work','2021-12-30 17:36:22','2021-12-20'),
(1249,3,2,12,'2021-12-20 11:05:00','2021-12-20 12:35:00',5400,'Consegna, installazione e configurazione printer server su stampante Canon A3',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-28 11:14:32','2021-12-20'),
(1250,1,1,75,'2021-12-20 14:15:00','2021-12-20 14:42:47',1667,'problema invio posta su portatile bagnasco',20.84,NULL,45,1,'Europe/Rome',20.84,1,'work','2021-12-28 10:50:09','2021-12-20'),
(1251,3,2,67,'2021-12-20 14:15:00','2021-12-20 14:45:00',1800,'Assistenza su portatile Massimo per problema collegamento a Sigla',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-07 21:42:35','2021-12-20'),
(1252,3,1,17,'2021-12-20 15:50:00','2021-12-20 16:30:00',2400,'Assistenza su pc client Dino per problema con stampante e stampa mail',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-01 15:22:52','2021-12-20'),
(1253,3,1,103,'2021-12-20 16:40:00','2021-12-20 16:55:00',900,'Installata vpn su portatile casa Tiziana',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-28 10:38:02','2021-12-20'),
(1254,3,2,41,'2021-12-21 08:15:00','2021-12-21 12:05:00',13800,'Consegna e configurazione nuovo PC client, assistenza su stampante ad aghi, da tornare con modello diverso di Printer Server.\r\nRecuperato nostro switch 16 porte, Utilizzato: Ciabatta elettrica, ritirati vecchi dispositivi per verifica',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-24 11:23:51','2021-12-21'),
(1255,3,2,101,'2021-12-21 17:30:00','2021-12-21 18:00:00',1800,'Sostituzione 1 batteria su ups apc',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-27 14:39:44','2021-12-21'),
(1256,3,2,108,'2021-12-22 08:15:00','2021-12-22 09:15:00',3600,'Copiati dati vecchio PC client dismesso su PC client Barbara, assistenza per sistemazione cavi postazione Barbara',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-22 10:20:12','2021-12-22'),
(1257,3,2,41,'2021-12-22 09:40:00','2021-12-22 09:55:00',900,'Aggiunta una cartella condivisa + configurato account posta logistica su nuovo pc client Nicolò in Lungo Torrente Secca',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-24 11:23:51','2021-12-22'),
(1258,1,1,81,'2021-12-22 09:06:00','2021-12-22 09:43:00',2220,'problemi vpn dopo salto corrente',27.75,NULL,45,1,'Europe/Rome',27.75,1,'work','2022-03-17 16:05:25','2021-12-22'),
(1259,3,1,64,'2021-12-22 10:25:00','2021-12-22 11:05:00',2400,'Assistenza su pc client Gloria per provare a recuperare file excel',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-28 10:56:32','2021-12-22'),
(1260,3,2,91,'2021-12-23 10:40:00','2021-12-23 11:10:00',1800,'Risolto problema collegamento alle stampanti di rete',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-28 09:49:30','2021-12-23'),
(1261,1,1,1,'2021-12-22 15:42:00','2021-12-22 17:44:00',7320,'problema telefoni',91.5,NULL,45,1,'Europe/Rome',91.5,1,'work','2021-12-30 17:36:27','2021-12-22'),
(1262,1,1,1,'2021-12-23 15:44:00','2021-12-23 17:29:00',6300,'problema telefoni',78.75,NULL,45,1,'Europe/Rome',78.75,1,'work','2021-12-30 17:36:25','2021-12-23'),
(1263,1,1,2,'2021-12-22 13:44:00','2021-12-22 15:27:00',6180,'problemi server vecchio ipmi',77.25,NULL,45,1,'Europe/Rome',77.25,1,'work','2022-02-10 14:51:38','2021-12-22'),
(1264,1,1,103,'2021-12-22 07:45:00','2021-12-22 09:00:00',4500,'migrazione firewall',56.25,NULL,45,1,'Europe/Rome',56.25,1,'work','2021-12-28 09:51:54','2021-12-22'),
(1265,1,1,103,'2021-12-20 15:06:00','2021-12-20 17:20:00',8040,'migrazione firewall',100.5,NULL,45,1,'Europe/Rome',100.5,1,'work','2021-12-28 09:51:56','2021-12-20'),
(1266,1,1,2,'2021-12-22 09:57:00','2021-12-22 11:24:00',5220,'probemi ipmi vecchio server',65.25,NULL,45,1,'Europe/Rome',65.25,1,'work','2022-02-10 14:51:38','2021-12-22'),
(1267,3,2,53,'2021-12-23 16:15:00','2021-12-23 16:35:00',1200,'Ritirato Nas per copia dati + nostri dispositivi',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-10 14:13:47','2021-12-23'),
(1268,3,1,17,'2021-12-23 07:50:00','2021-12-23 08:00:00',600,'Assistenza su portatile Semino casa',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-01 15:22:56','2021-12-23'),
(1269,3,1,64,'2021-12-23 08:20:00','2021-12-23 09:20:00',3600,'Prove per configurazione vpn su portatile casa Valentina, portatile da ritirare',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-28 10:56:33','2021-12-23'),
(1270,3,1,84,'2021-12-23 13:40:00','2021-12-23 14:10:00',1800,'Installazione Office 2021',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-27 16:02:03','2021-12-23'),
(1271,3,2,41,'2021-12-24 09:00:00','2021-12-24 09:30:00',1800,'Riconsegnato e verificato NAS Buffalo per backup gestionale WinToLip',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-24 11:23:52','2021-12-24'),
(1272,3,2,101,'2021-12-24 10:55:00','2021-12-24 11:30:00',2100,'Assistenza su server Linux per problemi avvio sistema con nuovo kernel',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-27 14:30:33','2021-12-24'),
(1273,3,2,96,'2021-12-27 10:05:00','2021-12-27 10:35:00',1800,'Consegna toner compatibile per Brother Federica\r\nConfigurati 2 account mail su cellulare\r\nRegistrato messaggio segreteria per Ferie natalizie',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-10 10:20:37','2021-12-27'),
(1274,3,2,88,'2021-12-27 11:00:00','2021-12-27 11:30:00',1800,'Ritirato pc client Maura per upgrade hw\r\nAssistenza per problemi ricezione posta su cellulare Mauro Piazza',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-29 16:01:29','2021-12-27'),
(1275,1,1,41,'2021-12-09 10:10:00','2021-12-09 11:28:00',4680,'problemi outlook\r\ngestione share',58.5,NULL,45,1,'Europe/Rome',58.5,1,'work','2021-12-30 08:00:10','2021-12-09'),
(1276,1,1,1,'2021-12-09 07:45:00','2021-12-09 10:00:00',8100,'problema telefoni',101.25,NULL,45,1,'Europe/Rome',101.25,1,'work','2021-12-30 17:36:10','2021-12-09'),
(1277,1,1,32,'2021-12-09 13:50:00','2021-12-09 16:00:00',7800,'Aggiornamento vm windows',97.5,NULL,45,1,'Europe/Rome',97.5,1,'work','2021-12-28 10:51:42','2021-12-09'),
(1278,1,1,3,'2021-12-10 07:49:00','2021-12-10 10:00:00',7860,'backup remoti',98.25,NULL,45,1,'Europe/Rome',98.25,1,'work','2021-12-28 14:55:50','2021-12-10'),
(1279,1,4,3,'2021-12-10 13:30:00','2021-12-10 14:22:00',3120,'in lab',39,NULL,45,1,'Europe/Rome',39,1,'work','2021-12-28 14:55:50','2021-12-10'),
(1280,1,1,2,'2021-12-10 10:17:00','2021-12-10 11:22:00',3900,'server vecchio',48.75,NULL,45,1,'Europe/Rome',48.75,1,'work','2022-02-10 14:52:10','2021-12-10'),
(1281,1,1,2,'2021-12-10 15:01:00','2021-12-10 17:27:00',8760,'server vecchio e nuovo',109.5,NULL,45,1,'Europe/Rome',109.5,1,'work','2022-02-10 14:51:39','2021-12-10'),
(1282,1,4,3,'2021-12-21 07:30:00','2021-12-21 10:00:00',9000,'in lab, backup remoti, 1 privato lasciato 10 euro su scrivania ciro, pulizia db wiki',112.5,NULL,45,1,'Europe/Rome',112.5,1,'work','2021-12-28 14:55:43','2021-12-21'),
(1283,1,1,1,'2021-12-21 10:35:00','2021-12-21 11:28:00',3180,'problemi telefoni passaggio chiaamte',39.75,NULL,45,1,'Europe/Rome',39.75,1,'work','2021-12-30 17:36:29','2021-12-21'),
(1284,1,1,103,'2021-12-21 15:12:00','2021-12-21 17:23:00',7860,'migrazione server',98.25,NULL,45,1,'Europe/Rome',98.25,1,'work','2021-12-28 09:51:53','2021-12-21'),
(1285,1,1,103,'2021-12-21 13:40:00','2021-12-21 15:00:00',4800,'aggiornamento server windows e vvm',60,NULL,45,1,'Europe/Rome',60,1,'work','2021-12-28 10:38:01','2021-12-21'),
(1286,1,3,112,'2021-12-23 11:00:00','2021-12-23 11:30:00',1800,NULL,22.5,NULL,45,1,'Europe/Rome',22.5,1,'work','2021-12-28 14:52:13','2021-12-23'),
(1287,1,1,5,'2021-12-23 13:48:00','2021-12-23 15:29:00',6060,'agg server',75.75,NULL,45,1,'Europe/Rome',75.75,1,'work','2021-12-28 14:50:48','2021-12-23'),
(1288,1,1,3,'2021-12-23 07:48:00','2021-12-23 09:00:00',4320,'agg 3cx 18 problemi',54,NULL,45,1,'Europe/Rome',54,1,'work','2021-12-28 14:55:52','2021-12-23'),
(1289,1,1,75,'2021-12-23 09:11:00','2021-12-23 10:00:00',2940,'agg nas',36.75,NULL,45,1,'Europe/Rome',36.75,1,'work','2021-12-28 10:50:10','2021-12-23'),
(1290,1,1,5,'2021-12-23 10:13:00','2021-12-23 10:51:00',2280,'agg nas',28.5,NULL,45,1,'Europe/Rome',28.5,1,'work','2021-12-28 14:50:47','2021-12-23'),
(1291,1,3,112,'2021-12-24 16:17:00','2021-12-24 17:30:00',4380,NULL,54.75,NULL,45,1,'Europe/Rome',54.75,1,'work','2021-12-28 14:52:13','2021-12-24'),
(1292,1,1,53,'2021-12-24 15:16:00','2021-12-24 16:15:00',3540,'inizio copia dati pc lab',44.25,NULL,45,1,'Europe/Rome',44.25,1,'work','2022-02-10 14:13:46','2021-12-24'),
(1293,1,1,1,'2021-12-24 07:46:00','2021-12-24 09:36:00',6600,'problema cordless',82.5,NULL,45,1,'Europe/Rome',82.5,1,'work','2021-12-30 17:36:24','2021-12-24'),
(1294,1,1,101,'2021-12-24 09:55:00','2021-12-24 10:16:00',1260,'firewall bloccato',15.75,NULL,45,1,'Europe/Rome',15.75,1,'work','2022-03-17 16:50:19','2021-12-24'),
(1295,1,1,41,'2021-12-24 10:30:00','2021-12-24 11:30:00',3600,'gestione share',45,NULL,45,1,'Europe/Rome',45,1,'work','2022-02-24 11:24:08','2021-12-24'),
(1296,1,1,2,'2021-12-24 13:42:00','2021-12-24 15:00:00',4680,'server vecchio preparazione reinstall linux',58.5,NULL,45,1,'Europe/Rome',58.5,1,'work','2022-02-10 14:51:59','2021-12-24'),
(1297,3,1,41,'2021-12-27 08:20:00','2021-12-27 08:30:00',600,'Assistenza su pc client Fucilli',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-24 11:24:05','2021-12-27'),
(1298,3,1,43,'2021-12-27 16:35:00','2021-12-27 17:05:00',1800,'Assistenza sul pc casa Romina, ce lo deve portare per configurazione posta',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-17 16:53:55','2021-12-27'),
(1299,3,1,41,'2021-12-28 09:20:00','2021-12-28 09:30:00',600,'Assistenza su pc client Nicolò',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-24 11:24:06','2021-12-28'),
(1300,3,1,41,'2021-12-28 10:25:00','2021-12-28 10:40:00',900,'Assistenza per liberare spazio account impianto@ecologitalmaneco.it',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-24 11:24:03','2021-12-28'),
(1301,1,1,53,'2021-12-28 07:48:00','2021-12-28 08:14:00',1560,'cartella hm con nome file lunghi',19.5,NULL,45,1,'Europe/Rome',19.5,1,'work','2022-02-10 14:15:05','2021-12-28'),
(1302,1,1,53,'2021-12-27 14:42:00','2021-12-27 17:00:00',8280,'cartella hm e gba con nome file lunghi',103.5,NULL,45,1,'Europe/Rome',103.5,1,'work','2022-02-10 14:15:03','2021-12-27'),
(1303,1,1,17,'2021-12-28 14:38:00','2021-12-28 15:42:00',3840,'sistemazione backup su nas',48,NULL,45,1,'Europe/Rome',48,1,'work','2022-03-01 15:22:53','2021-12-28'),
(1304,1,1,57,'2021-12-28 16:12:00','2021-12-28 16:47:00',2100,'recupero file cancellato',26.25,NULL,45,1,'Europe/Rome',26.25,1,'work','2022-03-08 22:18:32','2021-12-28'),
(1305,3,2,41,'2021-12-28 16:15:00','2021-12-28 17:30:00',4500,'Sistemazione cavi di rete nell\'armadio rack in lungo torrente secca\r\nUtilizzato: 39 prolunghe di rete + 39 cavi rete da 1mt + 1 ripiano bianco per armadio rack',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-24 11:24:02','2021-12-28'),
(1306,1,1,41,'2021-12-29 07:50:00','2021-12-29 09:15:44',5144,'problemi dhcp dopo sistemazione cavi di rete, riconfigurata stampante che rubava ip a pc francesca, condivisa altra stampatne',64.3,NULL,45,1,'Europe/Rome',64.3,1,'work','2022-02-24 11:24:02','2021-12-29'),
(1307,3,1,18,'2021-12-29 09:05:00','2021-12-29 09:20:00',900,'Assistenza su pc client per problemi posta elettronica',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-24 16:03:14','2021-12-29'),
(1308,3,4,88,'2021-12-28 13:30:00','2021-12-28 14:30:00',3600,'Upgrade hw pc client Maura + verifiche su sistema operativo.\r\nUtilizzato: Mainboard AsRock , CPU Intel i7, 32 gb DDR4 RAM. Alim. Cooler Master 500 W, Sk Video GTX 1050 e adattatore DPort to VGA',0,NULL,0,1,'Europe/Rome',0,1,'work','2021-12-29 16:01:29','2021-12-28'),
(1309,3,2,41,'2021-12-29 10:15:00','2021-12-29 10:45:00',1800,'Assistenza per problemi di rete su PC client Paolo e Aldo\r\nAssistenza su PC client Nicolò',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-24 11:24:01','2021-12-29'),
(1310,1,1,41,'2021-12-30 15:57:00','2021-12-30 16:13:00',960,'problemi dopo salto correte',12,NULL,45,1,'Europe/Rome',12,1,'work','2022-02-24 11:24:00','2021-12-30'),
(1311,1,1,24,'2021-12-30 16:14:00','2021-12-30 17:17:00',3780,'configurazione nuovo dvr (non riuscito)',47.25,NULL,45,1,'Europe/Rome',47.25,1,'work','2022-03-01 11:17:11','2021-12-30'),
(1312,1,1,53,'2021-12-30 07:47:00','2021-12-30 08:17:00',1800,'copia cartelle tino e contabilita per permettergli di lavorare',22.5,NULL,45,1,'Europe/Rome',22.5,1,'work','2022-02-10 14:14:09','2021-12-30'),
(1313,1,1,3,'2021-12-28 08:17:00','2021-12-28 09:20:00',3780,'fogli',47.25,NULL,45,1,'Europe/Rome',47.25,1,'work','2022-02-23 10:56:44','2021-12-28'),
(1314,1,1,3,'2021-12-27 07:51:00','2021-12-27 11:19:00',12480,'backup remoti',156,NULL,45,1,'Europe/Rome',156,1,'work','2022-02-23 10:56:43','2021-12-27'),
(1315,1,1,2,'2021-12-27 13:39:00','2021-12-27 14:25:00',2760,'backup su nas',34.5,NULL,45,1,'Europe/Rome',34.5,1,'work','2022-02-10 14:52:00','2021-12-27'),
(1316,1,1,3,'2021-12-28 09:41:00','2021-12-28 11:23:00',6120,'server test lab con problemi standby',76.5,NULL,45,1,'Europe/Rome',76.5,1,'work','2022-02-23 10:56:45','2021-12-28'),
(1317,1,1,29,'2021-12-28 13:33:00','2021-12-28 14:24:00',3060,'problemi connessione nas da remoto (non risolto',38.25,NULL,45,1,'Europe/Rome',38.25,1,'work','2022-05-04 14:38:41','2021-12-28'),
(1318,1,1,50,'2021-12-28 17:00:00','2021-12-28 17:29:00',1740,'agg unifi',21.75,NULL,45,1,'Europe/Rome',21.75,1,'work','2022-02-16 16:12:33','2021-12-28'),
(1319,1,1,2,'2021-12-29 09:33:00','2021-12-29 10:19:00',2760,'agg unifi',34.5,NULL,45,1,'Europe/Rome',34.5,1,'work','2022-02-10 14:52:06','2021-12-29'),
(1320,1,1,53,'2021-12-29 10:34:00','2021-12-29 11:20:00',2760,'copia cartella nome file lungo',34.5,NULL,45,1,'Europe/Rome',34.5,1,'work','2022-02-10 14:14:09','2021-12-29'),
(1321,1,1,1,'2021-12-30 13:43:00','2021-12-30 15:30:00',6420,'tentativo di contatto irideos problemi di port forwarding su router e numero privato in uscita',80.25,NULL,45,1,'Europe/Rome',80.25,1,'work','2022-01-18 15:58:49','2021-12-30'),
(1322,1,1,51,'2021-12-29 13:47:00','2021-12-29 15:49:00',7320,'agg uniif e server',91.5,NULL,45,1,'Europe/Rome',91.5,1,'work','2022-03-07 14:40:00','2021-12-29'),
(1323,1,1,79,'2021-12-29 16:03:00','2021-12-29 16:24:00',1260,'agg unifi',15.75,NULL,45,1,'Europe/Rome',15.75,1,'work','2022-03-17 17:38:52','2021-12-29'),
(1324,1,1,41,'2021-12-29 16:40:00','2021-12-29 17:30:00',3000,'agg unifi e gewstione server',37.5,NULL,45,1,'Europe/Rome',37.5,1,'work','2022-02-24 11:24:00','2021-12-29'),
(1325,1,1,90,'2021-12-30 08:39:00','2021-12-30 09:12:00',1980,'agg unifi',24.75,NULL,45,1,'Europe/Rome',24.75,1,'work','2022-03-01 14:58:58','2021-12-30'),
(1326,1,1,10,'2021-12-30 09:26:00','2021-12-30 10:13:00',2820,'agg server posta',35.25,NULL,45,1,'Europe/Rome',35.25,1,'work','2022-03-18 13:50:31','2021-12-30'),
(1327,1,1,103,'2021-12-30 10:30:00','2021-12-30 11:24:00',3240,'verifica patch print nightmare su vm gestionale',40.5,NULL,45,1,'Europe/Rome',40.5,1,'work','2022-01-18 10:55:06','2021-12-30'),
(1328,3,1,88,'2022-01-03 08:55:00','2022-01-03 09:15:00',1200,'Assistenza su pc client Maura per problemi monitor sfocato, da verificare in loco',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-01-31 15:02:39','2022-01-03'),
(1329,3,2,88,'2022-01-03 10:25:00','2022-01-03 10:55:00',1800,'Assistenza su PC client Maura per problemi su monitor sfocato',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-01-31 15:02:38','2022-01-03'),
(1330,1,1,3,'2021-12-01 07:43:00','2021-12-01 08:20:00',2220,'backup remoti',27.75,NULL,45,1,'Europe/Rome',27.75,1,'work','2022-02-23 10:56:40','2021-12-01'),
(1331,1,1,103,'2021-12-01 09:42:00','2021-12-01 11:19:00',5820,'firewall nuovo',72.75,NULL,45,1,'Europe/Rome',72.75,1,'work','2022-01-18 10:55:04','2021-12-01'),
(1332,1,1,3,'2021-12-01 13:57:00','2021-12-01 15:24:00',5220,'riceca kvm particolare\r\nfogli',65.25,NULL,45,1,'Europe/Rome',65.25,1,'work','2022-02-23 10:56:41','2021-12-01'),
(1333,1,1,81,'2021-12-01 15:49:00','2021-12-01 16:09:00',1200,'lamenta problemi vpn wireguard',15,NULL,45,1,'Europe/Rome',15,1,'work','2022-03-17 16:05:24','2021-12-01'),
(1334,1,1,2,'2021-12-01 16:09:00','2021-12-01 17:27:00',4680,'agg server',58.5,NULL,45,1,'Europe/Rome',58.5,1,'work','2022-02-10 14:52:02','2021-12-01'),
(1335,1,1,41,'2021-12-03 07:43:00','2021-12-03 08:27:00',2640,'problemi stampe via wagner',33,NULL,45,1,'Europe/Rome',33,1,'work','2022-02-24 11:23:47','2021-12-03'),
(1336,1,1,3,'2021-12-03 13:44:00','2021-12-03 17:26:00',13320,'fogli\r\nbackup remoti\r\nproxmox zfs',166.5,NULL,45,1,'Europe/Rome',166.5,1,'work','2022-02-23 10:56:42','2021-12-03'),
(1337,1,1,103,'2021-12-03 09:04:00','2021-12-03 11:23:00',8340,'agg server',104.25,NULL,45,1,'Europe/Rome',104.25,1,'work','2022-01-18 10:55:05','2021-12-03'),
(1338,1,1,1,'2021-12-06 07:44:00','2021-12-06 09:44:00',7200,'agg server',90,NULL,45,1,'Europe/Rome',90,1,'work','2022-02-10 17:23:01','2021-12-06'),
(1339,1,1,24,'2021-12-13 08:26:00','2021-12-13 09:13:00',2820,'agg centr',35.25,NULL,45,1,'Europe/Rome',35.25,1,'work','2022-03-01 09:44:30','2021-12-13'),
(1340,1,1,24,'2021-12-13 16:00:00','2021-12-13 17:19:00',4740,'agg centralino problemi windows',59.25,NULL,45,1,'Europe/Rome',59.25,1,'work','2022-03-01 09:44:29','2021-12-13'),
(1341,1,2,2,'2021-12-13 14:02:00','2021-12-13 15:40:00',5880,'installazione ram su server nuovo e su nas\r\n\r\n32 gb ram ecc per server\r\n8 gb ram per nas sodim ddr3',73.5,NULL,45,1,'Europe/Rome',73.5,1,'work','2022-02-10 14:52:07','2021-12-13'),
(1342,1,6,22,'2021-12-31 07:53:00','2021-12-31 08:05:00',720,'per problemi linea a casa',9,NULL,45,1,'Europe/Rome',9,1,'work','2022-03-16 11:15:29','2021-12-31'),
(1343,1,1,3,'2021-12-31 08:30:00','2021-12-31 09:17:00',2820,'fogli',35.25,NULL,45,1,'Europe/Rome',35.25,1,'work','2022-02-23 10:56:45','2021-12-31'),
(1344,1,1,3,'2021-12-31 09:30:00','2021-12-31 11:30:00',7200,'proxmox zfs',90,NULL,45,1,'Europe/Rome',90,1,'work','2022-02-23 10:56:46','2021-12-31'),
(1345,1,1,50,'2021-12-31 13:39:00','2021-12-31 14:48:00',4140,'agg template telefoni dopo studio aldo',51.75,NULL,45,1,'Europe/Rome',51.75,1,'work','2022-02-16 16:12:43','2021-12-31'),
(1346,1,1,2,'2021-12-31 14:59:00','2021-12-31 16:40:00',6060,'backup su nas e patch sicurezza windows',75.75,NULL,45,1,'Europe/Rome',75.75,1,'work','2022-02-10 14:51:37','2021-12-31'),
(1347,1,1,53,'2021-12-31 17:00:00','2021-12-31 17:22:00',1320,'copia cart3elle',16.5,NULL,45,1,'Europe/Rome',16.5,1,'work','2022-02-10 14:14:11','2021-12-31'),
(1348,3,1,79,'2022-01-04 08:45:00','2022-01-04 09:00:00',900,'Assistenza su PC client Silvia per problemi su pec',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-04 18:22:06','2022-01-04'),
(1349,3,1,1,'2022-01-04 09:20:00','2022-01-04 10:20:00',3600,'Assistenza su server per problemi spazio disco C',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-10 17:23:03','2022-01-04'),
(1350,3,2,95,'2022-01-04 14:15:00','2022-01-04 14:35:00',1200,'Consegna e installazione nuovo monitor Philips 21,5\"',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-01-14 09:05:01','2022-01-04'),
(1351,3,2,1,'2022-01-10 08:45:00','2022-01-10 09:25:00',2400,'Sostituzione 2 batterie su ups apc 1400 + verifica funzionamento dopo riavvio server',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-10 17:23:04','2022-01-10'),
(1352,3,2,5,'2022-01-10 09:35:00','2022-01-10 10:25:00',3000,'Assistenza su PC client Alessandra in corto, verificata ram e sostituzione alimentatore \r\nUtilizzato: Alim CM 500 W',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-18 13:55:13','2022-01-10'),
(1353,1,1,90,'2022-01-10 07:47:00','2022-01-10 09:29:00',6120,'problema certifciati ssl',76.5,NULL,45,1,'Europe/Rome',76.5,1,'work','2022-03-01 14:58:59','2022-01-10'),
(1354,1,1,103,'2022-01-10 09:47:00','2022-01-10 11:11:00',5040,'sincro file per cambio firewall e cotnrolli alex',63,NULL,45,1,'Europe/Rome',63,1,'work','2022-01-18 10:55:06','2022-01-10'),
(1355,1,1,90,'2022-01-10 11:14:00','2022-01-10 11:26:00',720,'problema agg server, spostamento letsencyrpt per dominio stegeo.lkj.it su server windows',9,NULL,45,1,'Europe/Rome',9,1,'work','2022-03-01 14:59:00','2022-01-10'),
(1356,1,1,90,'2022-01-10 13:46:00','2022-01-10 15:21:00',5700,'problema agg server, spostamento letsencyrpt per dominio stegeo.lkj.it su server windows',71.25,NULL,45,1,'Europe/Rome',71.25,1,'work','2022-03-01 14:59:01','2022-01-10'),
(1357,1,1,26,'2022-01-10 15:30:00','2022-01-10 17:21:00',6660,'per ricerca mail banci',83.25,NULL,45,1,'Europe/Rome',83.25,1,'work','2022-03-17 16:43:45','2022-01-10'),
(1358,3,2,41,'2022-01-10 15:40:00','2022-01-10 17:00:00',4800,'Consegna e installazione nuovo printer server Digitus DN 1303-2, risolto problema stampante ad aghi\r\nInstallazione Thunderbird su PC client Gulli',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-24 11:23:59','2022-01-10'),
(1359,3,1,50,'2022-01-10 13:35:00','2022-01-10 13:55:00',1200,'Assistenza su pc client Francesco per problema apertura file pdf',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-01-14 11:28:31','2022-01-10'),
(1360,3,1,32,'2022-01-10 14:00:00','2022-01-10 14:10:00',600,'Installata 1 licenza agg nod32 su 2 pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-01-20 15:47:36','2022-01-10'),
(1361,3,1,62,'2022-01-10 15:15:00','2022-01-10 15:25:00',600,'Installata 1 licenza agg nod32 su 2 pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-10-04 14:51:35','2022-01-10'),
(1362,3,1,26,'2022-01-10 14:15:00','2022-01-10 15:15:00',3600,'Assistenza su pc client Banci per problemi indicizzazione su Outlook, problema da risolvere',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-17 16:43:46','2022-01-10'),
(1363,3,2,79,'2022-01-11 08:15:00','2022-01-11 08:55:00',2400,'Assistenza su stampante Epson magazzino per problemi stampa e scansione',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-04 18:22:07','2022-01-11'),
(1364,1,1,1,'2022-01-11 07:44:00','2022-01-11 10:10:00',8760,'problemi centralino risolti',109.5,NULL,45,1,'Europe/Rome',109.5,1,'work','2022-01-18 15:50:12','2022-01-11'),
(1365,3,2,67,'2022-01-11 10:45:00','2022-01-11 12:25:00',6000,'Assistenza su PC client Massimo Serra per problema posta inviata mancante, da verificare dopo fine indicizzazione Outlook',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-07 21:43:33','2022-01-11'),
(1366,3,2,12,'2022-01-11 12:40:00','2022-01-11 13:30:00',3000,'Consegna e configurazione nuovo printer server\r\nRitirato vecchio printer server\r\nConfigurazione stampante a3 su tutti i PC client',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-18 14:02:10','2022-01-11'),
(1367,3,2,103,'2022-01-11 15:10:00','2022-01-11 15:45:00',2100,'Sostituzione 1 batteria su ups apc 650 \r\nInstallate 4 licenze nod32 aggiornamento su 8 PC client',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-01-18 10:55:08','2022-01-11'),
(1368,3,1,105,'2022-01-11 09:15:00','2022-01-11 09:25:00',600,'Installata 1 licenza nod32 aggiornamento su 2 pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-01-18 11:02:39','2022-01-11'),
(1369,3,2,104,'2022-01-11 09:30:00','2022-01-11 10:05:00',2100,'Assistenza per problemi invio mail, stavano navigando con la chiavetta',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-10 13:16:52','2022-01-11'),
(1370,3,1,100,'2022-01-11 14:10:00','2022-01-11 14:40:00',1800,'Installata e configurata vpn su pc casa Veronica Papetti e Cecilia Seronello',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-01-31 14:59:40','2022-01-11'),
(1371,3,2,6,'2022-01-12 09:20:00','2022-01-12 09:50:00',1800,'Assistenza su PC client Pia e Presidente  per problemi di navigazione',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-16 17:57:40','2022-01-12'),
(1372,3,2,10,'2022-01-12 10:10:00','2022-01-12 11:10:00',3600,'Assistenza su PC client Carmen per problemi su Outlook',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-18 13:50:32','2022-01-12'),
(1373,3,2,26,'2022-01-12 11:20:00','2022-01-12 11:30:00',600,'Consegna e installazione vaschetta recupero toner stampante HP',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-17 16:43:47','2022-01-12'),
(1374,1,3,112,'2022-01-12 07:30:00','2022-01-12 09:15:00',6300,NULL,78.75,NULL,45,1,'Europe/Rome',78.75,1,'work','2022-02-24 16:04:05','2022-01-12'),
(1375,1,3,112,'2022-01-12 13:30:00','2022-01-12 13:50:00',1200,NULL,15,NULL,45,1,'Europe/Rome',15,1,'work','2022-02-24 16:04:06','2022-01-12'),
(1376,1,1,60,'2022-01-12 10:37:00','2022-01-12 11:30:00',3180,'problemi chiamate voip dall\'esterno',39.75,NULL,45,1,'Europe/Rome',39.75,1,'work','2022-02-22 10:21:11','2022-01-12'),
(1377,1,1,103,'2022-01-11 13:52:00','2022-01-11 17:30:00',13080,'fine verifiche con alex',163.5,NULL,45,1,'Europe/Rome',163.5,1,'work','2022-02-02 10:32:19','2022-01-11'),
(1378,1,1,90,'2022-01-11 10:24:00','2022-01-11 11:30:00',3960,'installazione nuovo software su pc donatella e problemi posta',49.5,NULL,45,1,'Europe/Rome',49.5,1,'work','2022-03-01 14:59:02','2022-01-11'),
(1379,1,1,1,'2022-01-12 14:50:00','2022-01-12 14:58:00',480,'ancora problemi passaggio chiaamta, risolti al volo sbagliato tasto ha cambiato config del softphone',6,NULL,45,1,'Europe/Rome',6,1,'work','2022-01-18 15:43:09','2022-01-12'),
(1380,1,1,60,'2022-01-12 14:00:00','2022-01-12 14:29:00',1740,'problemi chiamate voip dall\'esterno, impossibile collegarsi al centralino via ssh',21.75,NULL,45,1,'Europe/Rome',21.75,1,'work','2022-02-22 10:21:12','2022-01-12'),
(1381,3,1,41,'2022-01-12 13:40:00','2022-01-12 14:20:00',2400,'Assistenza su pc client Roberta via Wagner per problemi con  formule Excel',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-24 11:23:59','2022-01-12'),
(1382,3,1,12,'2022-01-12 14:25:00','2022-01-12 14:35:00',600,'Installata stampante A3 di rete su pc client Camilla e Claudio',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-18 14:02:11','2022-01-12'),
(1383,3,1,79,'2022-01-12 14:45:00','2022-01-12 14:55:00',600,'Assistenza su pc client Andrea',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-04 18:22:08','2022-01-12'),
(1384,3,1,67,'2022-01-12 15:00:00','2022-01-12 15:15:00',900,'Configurato reindirizzamento su account mail',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-07 21:42:38','2022-01-12'),
(1385,3,1,88,'2022-01-12 15:20:00','2022-01-12 15:55:00',2100,'Installata e configurata vpn su portatile Stefania, verificata configurazione hw pc client Cristina per upgrade',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-18 13:36:31','2022-01-12'),
(1386,3,2,43,'2022-01-13 09:15:00','2022-01-13 10:00:00',2700,'Configurazione tutte le mail su nuovo iphone Romina \r\nAssistenza su PC client',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-17 17:11:40','2022-01-13'),
(1387,1,1,4,'2022-01-13 10:20:00','2022-01-13 11:20:01',3601,'problemi su pc nuovo',45.01,NULL,45,1,'Europe/Rome',45.01,1,'work','2022-03-17 17:35:24','2022-01-13'),
(1388,3,2,110,'2022-01-13 12:15:00','2022-01-13 14:00:00',6300,'Assistenza per problema spegnimento server, sostituzione dissipatore con cm Hyper H412R + test verifica corretto funzionamento',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-17 11:09:52','2022-01-13'),
(1389,3,2,41,'2022-01-13 14:35:00','2022-01-13 14:50:00',900,'Assistenza su PC client Nicolò',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-24 11:23:58','2022-01-13'),
(1390,3,1,100,'2022-01-13 15:15:00','2022-01-13 15:30:00',900,'Installata e configurata vpn su portatile Agnese Calissano',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-01-31 14:59:41','2022-01-13'),
(1391,3,1,90,'2022-01-13 15:40:00','2022-01-13 15:55:00',900,'Installate 2 licenze nod32 aggiornamento su 4 pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-01 14:59:03','2022-01-13'),
(1392,1,1,4,'2022-01-13 16:18:00','2022-01-13 17:30:00',4320,'problemi su pc nuovo',54,NULL,45,1,'Europe/Rome',54,1,'work','2022-03-17 17:35:25','2022-01-13'),
(1393,1,1,67,'2022-01-14 09:02:00','2022-01-14 09:21:00',1140,'configurazione posta elettronica su outlook simona ganzaroli',14.25,NULL,45,1,'Europe/Rome',14.25,1,'work','2022-03-07 21:42:40','2022-01-14'),
(1394,1,1,67,'2022-01-14 11:03:13','2022-01-14 11:24:17',1264,'configurazione posta elettronica su outlook simona ganzaroli',15.8,NULL,45,1,'Europe/Rome',15.8,1,'work','2022-03-07 21:42:41','2022-01-14'),
(1395,3,2,90,'2022-01-14 10:15:00','2022-01-14 11:15:00',3600,'Ripuliti ex dischi da 2 tb PC Manuela e installati su PC client Campodoni e Gallarati',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-01 14:59:04','2022-01-14'),
(1396,3,2,104,'2022-01-14 08:55:00','2022-01-14 09:05:00',600,'Ritarata stampante Brother per problemi fogli rovinati durante la stampa',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-10 10:52:19','2022-01-14'),
(1397,3,1,79,'2022-01-14 13:55:00','2022-01-14 14:10:00',900,'Assistenza su pc client Roberto',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-04 18:22:09','2022-01-14'),
(1398,3,1,96,'2022-01-14 14:40:00','2022-01-14 14:55:00',900,'Assistenza su pc client Antonella per problemi certificato posta',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-10 10:20:38','2022-01-14'),
(1399,1,1,90,'2022-01-17 07:45:00','2022-01-17 08:45:00',3600,'problemi avvio ufficius e leonardo',45,NULL,45,1,'Europe/Rome',45,1,'work','2022-03-01 14:59:05','2022-01-17'),
(1400,3,2,6,'2022-01-17 11:00:00','2022-01-17 14:20:00',12000,'Assistenza per problemi su Wifi ufficio',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-16 17:57:41','2022-01-17'),
(1401,1,1,6,'2022-01-17 13:53:00','2022-01-17 14:42:00',2940,'fede li problema con access point',36.75,NULL,45,1,'Europe/Rome',36.75,1,'work','2022-03-08 15:39:29','2022-01-17'),
(1402,3,2,103,'2022-01-17 15:10:00','2022-01-17 17:20:00',7800,'Sostituzione server Linux + configurazione \r\nVerificati pc client + ritiro vecchio server',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-01-18 10:55:09','2022-01-17'),
(1403,3,2,83,'2022-01-17 07:30:00','2022-01-17 08:00:00',1800,'Verificate problematiche centralino + numero e modelli telefoni',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-18 11:13:15','2022-01-17'),
(1404,3,1,24,'2022-01-17 08:40:00','2022-01-17 09:10:00',1800,'Assistenza su pc client Monica e Giovanni per problemi di posta',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-01 11:38:38','2022-01-17'),
(1405,3,1,26,'2022-01-17 09:45:00','2022-01-17 10:10:00',1500,'Assistenza su pc client Banci per problemi con Microsoft Teams',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-17 16:43:49','2022-01-17'),
(1406,1,1,103,'2022-01-17 15:00:00','2022-01-17 17:30:00',9000,'cambio firewall e sistemazione problemi',112.5,NULL,45,1,'Europe/Rome',112.5,1,'work','2022-03-01 13:11:29','2022-01-17'),
(1407,1,3,112,'2022-01-18 07:30:00','2022-01-18 09:30:00',7200,NULL,90,NULL,45,1,'Europe/Rome',90,1,'work','2022-02-24 16:04:07','2022-01-18'),
(1408,1,1,95,'2022-01-18 09:45:00','2022-01-18 11:00:00',4500,'config mail su programma contabile\r\nfastweb dopo config inoltro porte ha fatto casino con gli ip pubblici, risolto',56.25,NULL,45,1,'Europe/Rome',56.25,1,'work','2022-03-18 15:31:09','2022-01-18'),
(1409,1,1,6,'2022-01-18 11:01:00','2022-01-18 11:24:46',1426,'fede li per ancora problemi wifi',17.83,NULL,45,1,'Europe/Rome',17.83,1,'work','2022-03-08 15:39:33','2022-01-18'),
(1410,3,2,6,'2022-01-18 10:20:00','2022-01-18 12:00:00',6000,'Assistenza per problemi navigazione attraverso wifi e pc collegato con cavo LAN presente in altro ufficio, da risolvere',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-16 17:57:42','2022-01-18'),
(1411,1,3,112,'2022-01-18 13:30:00','2022-01-18 14:35:00',3900,NULL,48.75,NULL,45,1,'Europe/Rome',48.75,1,'work','2022-02-24 16:04:08','2022-01-18'),
(1412,1,1,35,'2022-01-18 14:35:00','2022-01-18 15:20:50',2750,'problemi backup su nas',34.38,NULL,45,1,'Europe/Rome',34.38,1,'work','2022-02-23 11:05:49','2022-01-18'),
(1413,1,1,1,'2022-01-13 13:38:00','2022-01-13 16:00:00',8520,'problema spazio c su server',106.5,NULL,45,1,'Europe/Rome',106.5,1,'work','2022-02-10 17:23:05','2022-01-13'),
(1414,3,2,6,'2022-01-18 15:45:00','2022-01-18 16:15:00',1800,'Sostituzione switch e risoluzione problema wifi e pc altro ufficio che non navigava\r\nUtilizzato: Switch 24 porte gigabit Zyxel GS1900',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-16 17:57:43','2022-01-18'),
(1415,1,1,95,'2022-01-18 15:43:00','2022-01-18 18:00:00',8220,'configurazione smtps su 465 ssl, tentativi di configurazione loro gestionale su server di posta.',102.75,NULL,45,1,'Europe/Rome',102.75,1,'work','2022-03-18 15:29:51','2022-01-18'),
(1416,1,1,35,'2022-01-18 19:58:00','2022-01-18 21:38:00',6000,'aggiornamento nas\r\nstudiata config ulteriore per invio mail backuppc da applicare anche agli altri nas con backuppc',75,NULL,45,1,'Europe/Rome',75,1,'work','2022-02-23 11:05:50','2022-01-18'),
(1417,3,1,95,'2022-01-18 08:00:00','2022-01-18 08:15:00',900,'Assistenza su pc client Mara per invio mail da software contabilità',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-18 15:31:08','2022-01-18'),
(1418,3,1,26,'2022-01-18 08:20:00','2022-01-18 08:35:00',900,'Assistenza su pc client Simona per problemi su Microsoft Teams',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-17 16:43:48','2022-01-18'),
(1419,3,1,24,'2022-01-18 08:40:00','2022-01-18 08:50:00',600,'Assistenza per problemi sul certificato di posta',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-01 11:07:31','2022-01-18'),
(1420,3,1,96,'2022-01-18 08:50:00','2022-01-18 09:00:00',600,'Assistenza su pc client Maria per problemi di posta',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-10 10:20:39','2022-01-18'),
(1421,3,1,108,'2022-01-18 09:05:00','2022-01-18 09:15:00',600,'Assistenza su pc client Biglietteria per problemi su software etichette',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-10-04 14:15:05','2022-01-18'),
(1422,3,1,75,'2022-01-18 09:15:00','2022-01-18 09:35:00',1200,'Assistenza su pc client Luca Bagnasco per problemi di lentezza, verificata configurazione hw per possibile upgrade',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-24 16:00:18','2022-01-18'),
(1423,3,1,100,'2022-01-18 13:50:00','2022-01-18 14:25:00',2100,'Installata e configurata vpn su pc casa Claudia Pellerano',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-01-31 14:59:42','2022-01-18'),
(1424,1,1,75,'2022-01-19 09:53:00','2022-01-19 10:12:00',1140,'problemi pec erica',14.25,NULL,45,1,'Europe/Rome',14.25,1,'work','2022-02-24 16:00:59','2022-01-19'),
(1425,1,1,41,'2022-01-19 10:35:00','2022-01-19 11:39:00',3840,'archiviazione posta luana\r\ne francesca da ultimare',48,NULL,45,1,'Europe/Rome',48,1,'work','2022-02-24 11:23:58','2022-01-19'),
(1426,3,2,50,'2022-01-19 09:45:00','2022-01-19 10:45:00',3600,'Consegna batteria portatile figlio Francesco \r\nConsegna e installazione webcam su PC client Filippo\r\nAssistenza su mac Elisabetta per problemi con stampante Xerox',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-16 16:18:39','2022-01-19'),
(1427,3,2,91,'2022-01-19 11:00:00','2022-01-19 11:15:00',900,'Consegna stampante Epson \r\nInstallata 1 licenza agg nod32 su 2 PC client',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-24 15:35:20','2022-01-19'),
(1428,1,3,112,'2022-01-19 15:06:00','2022-01-19 15:44:05',2285,NULL,28.56,NULL,45,1,'Europe/Rome',28.56,1,'work','2022-02-24 16:04:09','2022-01-19'),
(1429,3,1,103,'2022-01-19 08:30:00','2022-01-19 08:40:00',600,'Assistenza su pc client Collaudo per problemi collegamento al server',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-01 13:11:39','2022-01-19'),
(1430,1,1,29,'2022-01-19 15:50:00','2022-01-19 17:30:00',6000,'sistemazione problema porte usb a pc \r\naggiornamento nas\r\nconfigurazione invio mail temporaneo via mio server perchè alex non era disponibile',75,NULL,45,1,'Europe/Rome',75,1,'work','2022-05-04 14:38:42','2022-01-19'),
(1431,3,2,6,'2022-01-20 09:20:00','2022-01-20 10:20:00',3600,'Risolto problemi di rete in tutti gli uffici\r\nUtilizzato: switch 8 porte giga Zyxel GS-108B v3',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-16 17:57:44','2022-01-20'),
(1432,3,2,41,'2022-01-20 11:00:00','2022-01-20 11:30:00',1800,'Consegna e installazione Unfi Pro per collegamento PC in altro ufficio, consegnata usb wifi 150\r\nAssistenza su PC client Francesca\r\nUtilizzati: 2 cavi di rete da 3mt',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-24 11:23:55','2022-01-20'),
(1433,1,1,41,'2022-01-20 14:15:00','2022-01-20 16:17:56',7376,'pulizia posta ierardi',92.2,NULL,45,1,'Europe/Rome',92.2,1,'work','2022-02-24 11:23:53','2022-01-20'),
(1434,1,1,3,'2022-01-20 07:40:00','2022-01-20 09:14:00',5640,'risoluzione problemi invio posta elelttronica da controller e nas attraverso nostro server',70.5,NULL,45,1,'Europe/Rome',70.5,1,'work','2022-02-23 10:56:47','2022-01-20'),
(1435,1,1,41,'2022-01-20 09:33:00','2022-01-20 09:53:00',1200,'installazione vm lxc debina per unifi su ecofire2',15,NULL,45,1,'Europe/Rome',15,1,'work','2022-02-24 11:23:57','2022-01-20'),
(1436,1,1,41,'2022-01-20 10:00:00','2022-01-20 11:18:00',4680,'configurazione e installazione unifi controller fede sta andando li a montare uap ac pro, non avevo terminato perchè non potevo riavviare il firewall\r\nagg su windows server wagner',58.5,NULL,45,1,'Europe/Rome',58.5,1,'work','2022-02-24 11:23:56','2022-01-20'),
(1437,1,6,95,'2022-01-20 17:00:00','2022-01-20 17:17:00',1020,'per invio mail da loro gestionale nuovo',12.75,NULL,45,1,'Europe/Rome',12.75,1,'work','2022-03-18 15:31:10','2022-01-20'),
(1438,3,1,84,'2022-01-20 16:00:00','2022-01-20 16:25:00',1500,'Assistenza su pc client per problemi con utente Skype',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-22 10:18:01','2022-01-20'),
(1439,3,1,43,'2022-01-20 16:30:00','2022-01-20 17:00:00',1800,'Assistenza su pc client Romina per problemi spazio posta esaurito, devono contattare chi gestisce la posta',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-17 17:11:41','2022-01-20'),
(1440,3,2,24,'2022-01-21 10:10:00','2022-01-21 10:35:00',1500,'Consegna cartucce nero e magenta per Epson\r\nRecupero dati dvr telecamere gommista',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-01 11:31:21','2022-01-21'),
(1441,1,1,18,'2022-01-21 14:22:00','2022-01-21 14:32:18',618,'problemi posta',7.73,NULL,45,1,'Europe/Rome',7.73,1,'work','2022-02-24 16:03:15','2022-01-21'),
(1442,1,1,5,'2022-01-21 07:51:00','2022-01-21 09:48:00',7020,'configurazione invio mail qnap, verifica software per backup vm hyperv',87.75,NULL,45,1,'Europe/Rome',87.75,1,'work','2022-03-18 13:51:25','2022-01-21'),
(1443,1,1,103,'2022-01-21 10:02:00','2022-01-21 11:26:00',5040,'problema ftp su nuovo firewall',63,NULL,45,1,'Europe/Rome',63,1,'work','2022-03-01 13:11:48','2022-01-21'),
(1444,1,1,103,'2022-01-21 13:41:00','2022-01-21 14:17:00',2160,'problema ftp su nuovo firewall',27,NULL,45,1,'Europe/Rome',27,1,'work','2022-03-01 13:11:49','2022-01-21'),
(1445,1,1,2,'2022-01-21 14:39:00','2022-01-21 16:00:00',4860,'problema backup remoto',60.75,NULL,45,1,'Europe/Rome',60.75,1,'work','2022-02-10 14:51:36','2022-01-21'),
(1446,3,2,41,'2022-01-21 13:30:00','2022-01-21 17:10:00',13200,'Spostati, collegati e configurati 3 pc client per lavori \r\nSpostata e configurata stampante HP\r\nScollegati e spostati tutti i dispositivi dall\'ufficio per lavori\r\nUtilizzato; 1 usb wifi',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-06 09:13:34','2022-01-21'),
(1447,3,1,103,'2022-01-21 09:15:00','2022-01-21 09:45:00',1800,'Assistenza su pc client Collaudo per problemi posta elettronica dopo cambio server',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-01 13:11:46','2022-01-21'),
(1448,3,2,41,'2022-01-24 09:15:00','2022-01-24 09:35:00',1200,'Assistenza per problemi rete causa firewall scollegato\r\nRitirato ups pc client Roberta da rigenerare',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-06 09:13:36','2022-01-24'),
(1449,3,1,75,'2022-01-24 08:25:00','2022-01-24 08:50:00',1500,'Assistenza su portatile casa Gianfranco Figari per problemi stampa pdf',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-24 16:00:21','2022-01-24'),
(1450,3,1,75,'2022-01-24 10:40:00','2022-01-24 11:00:00',1200,'Assistenza su portatile casa Gianfranco Figari per problemi su Thunderbird',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-24 16:00:22','2022-01-24'),
(1451,3,2,104,'2022-01-24 14:55:00','2022-01-24 15:15:00',1200,'Consegna toner + assistenza su stampante Samsung',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-10 13:16:53','2022-01-24'),
(1452,3,2,41,'2022-01-25 10:10:00','2022-01-25 10:50:00',2400,'Assistenza per problemi su stampante wifi e scansioni, riconsegnato ups funzionante',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-06 09:13:38','2022-01-25'),
(1453,3,2,1,'2022-01-25 11:05:00','2022-01-25 11:25:00',1200,'Verificato e ritirato ex PC client mamma fabrizio per upgrade hw e reinstallazione sistema operativo',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-10 17:23:16','2022-01-25'),
(1454,3,2,1,'2022-01-25 14:25:00','2022-01-25 14:35:00',600,'Consegna nuovo portatile Roberta in porto',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-10 17:23:18','2022-01-25'),
(1455,1,1,10,'2022-01-25 13:46:00','2022-01-25 16:30:00',9840,'problema stampante carmen\r\nmanutenzione posta',123,NULL,45,1,'Europe/Rome',123,1,'work','2022-03-18 13:50:33','2022-01-25'),
(1456,3,2,100,'2022-01-25 15:00:00','2022-01-25 15:35:00',2100,'Consegna e installazione 2 dischi WD da 2 tb sul server, avviata copia sistema e dati',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-01-31 14:45:35','2022-01-25'),
(1457,1,3,112,'2022-01-25 16:31:00','2022-01-25 17:30:00',3540,NULL,44.25,NULL,45,1,'Europe/Rome',44.25,1,'work','2022-02-24 16:04:12','2022-01-25'),
(1458,1,3,112,'2022-01-24 09:08:00','2022-01-24 10:00:00',3120,NULL,39,NULL,45,1,'Europe/Rome',39,1,'work','2022-02-24 16:04:09','2022-01-24'),
(1459,3,1,22,'2022-01-25 08:25:00','2022-01-25 08:35:00',600,'Verificato problema audio su pc client Stefano, da fissare intervento in loco',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-16 11:15:30','2022-01-25'),
(1460,3,1,41,'2022-01-25 08:40:00','2022-01-25 09:20:00',2400,'Assistenza per problemi stampante wifi, problema da risolvere in loco',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-06 09:13:37','2022-01-25'),
(1461,3,1,18,'2022-01-25 13:40:00','2022-01-25 14:00:00',1200,'Assistenza su pc client per problemi posta',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-24 16:03:16','2022-01-25'),
(1462,3,4,64,'2022-01-25 16:30:00','2022-01-25 16:40:00',600,'Configurata mail su nuovo cell Alessandro',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-24 15:32:55','2022-01-25'),
(1463,1,1,3,'2022-01-26 07:41:00','2022-01-26 08:40:00',3540,'info per agg v18',44.25,NULL,45,1,'Europe/Rome',44.25,1,'work','2022-02-24 15:33:43','2022-01-26'),
(1464,1,1,1,'2022-01-26 08:53:00','2022-01-26 09:22:00',1740,'agg v18 3cx',21.75,NULL,45,1,'Europe/Rome',21.75,1,'work','2022-02-10 15:14:27','2022-01-26'),
(1465,1,1,100,'2022-01-26 10:43:00','2022-01-26 11:30:00',2820,'fede li problema cambio dischi',35.25,NULL,45,1,'Europe/Rome',35.25,1,'work','2022-01-31 14:45:22','2022-01-26'),
(1466,1,6,88,'2022-01-26 09:43:00','2022-01-26 10:14:00',1860,'verifica remota hardware parlato con piazza per nuovo centralino',23.25,NULL,45,1,'Europe/Rome',23.25,1,'work','2022-01-31 15:02:22','2022-01-26'),
(1467,1,1,5,'2022-01-26 14:35:00','2022-01-26 16:05:00',5400,'collegamento teamviewer programmatore gestiona,le\r\nagg server',67.5,NULL,45,1,'Europe/Rome',67.5,1,'work','2022-03-18 13:51:33','2022-01-26'),
(1468,1,1,50,'2022-01-26 14:19:00','2022-01-26 14:35:00',960,'fede li prove teams',12,NULL,45,1,'Europe/Rome',12,1,'work','2022-02-16 16:11:32','2022-01-26'),
(1469,1,1,100,'2022-01-26 13:37:00','2022-01-26 14:00:00',1380,'verifica stato array, software areca bloccato',17.25,NULL,45,1,'Europe/Rome',17.25,1,'work','2022-01-31 14:45:24','2022-01-26'),
(1470,3,1,12,'2022-01-26 17:05:00','2022-01-26 17:20:00',900,'Reinstallata vpn su portatile casa Valentina Maffei',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-18 14:02:12','2022-01-26'),
(1471,3,2,100,'2022-01-26 09:00:00','2022-01-26 11:45:00',9900,'Riavviato server dopo sostituzione dischi di sistema, messo a ricostruire raid sistema.',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-01-31 14:45:32','2022-01-26'),
(1472,3,2,100,'2022-01-26 16:10:00','2022-01-26 16:40:00',1800,'Riavviato e verificato server dopo fine ricostruizione raid sistema, messo a ricostruire raid backup',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-01-31 14:45:28','2022-01-26'),
(1473,3,1,1,'2022-01-26 11:50:00','2022-01-26 12:05:00',900,'Assistenza su nuovo portatile Roberta per accesso al gestionale',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-10 17:23:19','2022-01-26'),
(1474,3,2,50,'2022-01-26 13:45:00','2022-01-26 14:45:00',3600,'Assistenza su postazione Videoconferenza per problemi audio/video',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-16 16:12:46','2022-01-26'),
(1475,3,2,41,'2022-01-26 15:10:00','2022-01-26 15:25:00',900,'Assistenza in via Wagner per firewaal spento durante lavori di ristrutturazione',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-06 09:13:39','2022-01-26'),
(1476,1,1,100,'2022-01-26 16:15:00','2022-01-26 16:50:00',2100,'problema dischi',26.25,NULL,45,1,'Europe/Rome',26.25,1,'work','2022-01-31 14:45:29','2022-01-26'),
(1477,1,1,100,'2022-01-27 08:00:00','2022-01-27 08:16:00',960,'problema dischi',12,NULL,45,1,'Europe/Rome',12,1,'work','2022-02-24 15:36:10','2022-01-27'),
(1478,1,4,3,'2022-01-27 07:30:00','2022-01-27 08:00:00',1800,'in lab che fed fuori',22.5,NULL,45,1,'Europe/Rome',22.5,1,'work','2022-02-23 10:56:54','2022-01-27'),
(1479,1,1,17,'2022-01-27 08:43:00','2022-01-27 09:08:00',1500,'tentativo di ripristino vpn su portatile enrica non riuscito per connessione lenta',18.75,NULL,45,1,'Europe/Rome',18.75,1,'work','2022-03-01 15:22:55','2022-01-27'),
(1480,3,2,6,'2022-01-27 08:50:00','2022-01-27 09:20:00',1800,'Assistenza per problemi di rete ufficio interno 9',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-16 17:57:45','2022-01-27'),
(1481,3,2,75,'2022-01-27 09:50:00','2022-01-27 11:00:00',4200,'Spostate e collegate postazioni client Federico e Erica\r\nCollegate nuove porte di rete nell\'armadio rack\r\nRitirato vecchio PC client Federico per verifica upgrade hw per utilizzo a casa\r\nUtilizzato: 5 cavi di rete da 1 mt',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-24 16:00:23','2022-01-27'),
(1482,1,1,96,'2022-01-27 10:04:00','2022-01-27 11:10:00',3960,'server gandolfo1 inchiodato fatto riavviare e verifica',49.5,NULL,45,1,'Europe/Rome',49.5,1,'work','2022-02-08 17:15:40','2022-01-27'),
(1483,3,2,41,'2022-01-27 11:25:00','2022-01-27 11:40:00',900,'Verificato ups che tremava in via Wagner',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-06 09:13:40','2022-01-27'),
(1484,1,1,17,'2022-01-27 15:33:00','2022-01-27 16:51:00',4680,'tentativo di ripristino vpn su portatile enrica non riuscito per connessione lenta',58.5,NULL,45,1,'Europe/Rome',58.5,1,'work','2022-03-01 15:22:54','2022-01-27'),
(1485,1,1,53,'2022-01-27 13:47:00','2022-01-27 14:25:00',2280,'esportazione file non copiati su nas',28.5,NULL,45,1,'Europe/Rome',28.5,1,'work','2022-02-10 14:14:33','2022-01-27'),
(1486,1,3,112,'2022-01-27 11:13:00','2022-01-27 11:30:00',1020,NULL,12.75,NULL,45,1,'Europe/Rome',12.75,1,'work','2022-02-24 16:04:13','2022-01-27'),
(1487,1,1,3,'2022-01-27 08:20:00','2022-01-27 08:40:00',1200,'sistemazione wiki per connessioni vnc a contabo',15,NULL,45,1,'Europe/Rome',15,1,'work','2022-02-23 10:56:55','2022-01-27'),
(1488,1,1,3,'2022-01-27 09:10:00','2022-01-27 10:01:00',3060,'sistemazione wiki per connessioni vnc a contabo',38.25,NULL,45,1,'Europe/Rome',38.25,1,'work','2022-02-23 10:56:56','2022-01-27'),
(1489,1,1,3,'2022-01-27 14:30:00','2022-01-27 15:23:00',3180,'backup remoti',39.75,NULL,45,1,'Europe/Rome',39.75,1,'work','2022-02-23 10:56:57','2022-01-27'),
(1490,1,1,2,'2022-01-27 17:00:00','2022-01-27 17:31:00',1860,'backup su nas\r\nransomware',23.25,NULL,45,1,'Europe/Rome',23.25,1,'work','2022-07-08 10:16:37','2022-01-27'),
(1491,3,1,50,'2022-01-27 14:20:00','2022-01-27 14:45:00',1500,'Fatte videochiamate di prova usando Zoom e Teams',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-16 16:11:35','2022-01-27'),
(1492,3,4,1,'2022-01-27 15:00:00','2022-01-27 16:00:00',3600,'Reinstallato ex pc client mamma Fabrizio per installazione nella sede di Borzoli.\r\nUtilizzato: 4gb ddr3 ram, ssd 480gb S3+ e 1 USB da 32gb',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-10 17:23:20','2022-01-27'),
(1493,1,1,95,'2022-01-28 08:50:00','2022-01-28 09:05:00',900,'problema certificati smart card',11.25,NULL,45,1,'Europe/Rome',11.25,1,'work','2022-03-18 15:31:11','2022-01-28'),
(1494,3,2,2,'2022-01-28 09:35:00','2022-01-28 10:25:00',3000,'Resettate 5 telecamere collegate al NAS',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-08 10:16:39','2022-01-28'),
(1495,3,2,1,'2022-01-28 10:55:00','2022-01-28 11:35:00',2400,'Consegnato e configurato pc client reinstallato \r\nAssistenza su PC client Francesco \r\nUtilizzato: 2 cavi alim ups e 1 cavo di rete da 3 mt',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-10 17:23:21','2022-01-28'),
(1496,1,1,95,'2022-01-28 13:40:00','2022-01-28 14:16:00',2160,'entratel pc anna',27,NULL,45,1,'Europe/Rome',27,1,'work','2022-03-18 15:31:12','2022-01-28'),
(1497,3,2,88,'2022-01-28 14:15:00','2022-01-28 14:25:00',600,'Ritirato pc client Cristina per aggiornamento',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-15 20:26:29','2022-01-28'),
(1498,1,1,75,'2022-01-28 09:43:00','2022-01-28 11:23:00',6000,'problemi accesso nas oneto erika e federico',75,NULL,45,1,'Europe/Rome',75,1,'work','2022-02-24 16:00:27','2022-01-28'),
(1499,3,1,75,'2022-01-28 08:35:00','2022-01-28 08:55:00',1200,'Assistenza su pc client Erica per problemi con Excel',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-24 16:00:26','2022-01-28'),
(1500,3,4,88,'2022-01-28 16:15:00','2022-01-28 17:15:00',3600,'Upgrade hw su pc client Cristina\r\nUtilizzato: Alim. 500W cm, ssd 480gb, 16 gb ram ddr4, cpu Intel i5 10400F, Mb Asus Prime H410M-E',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-15 20:26:34','2022-01-28'),
(1501,1,1,83,'2022-01-28 16:40:00','2022-01-28 17:30:00',3000,'agg nas',37.5,NULL,45,1,'Europe/Rome',37.5,1,'work','2022-03-18 11:13:16','2022-01-28'),
(1502,1,1,55,'2022-01-31 07:42:00','2022-01-31 08:07:00',1500,'problemi rinnovo certificato ssl',18.75,NULL,45,1,'Europe/Rome',18.75,1,'work','2022-03-16 10:37:56','2022-01-31'),
(1503,3,2,22,'2022-01-31 08:45:00','2022-01-31 09:15:00',1800,'Risolto problema utilizzo audio con le casse\r\nPortare usb bluetooth nuova per fare prove',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-16 11:15:31','2022-01-31'),
(1504,1,1,103,'2022-01-31 10:29:00','2022-01-31 11:28:00',3540,'problema certificati',44.25,NULL,45,1,'Europe/Rome',44.25,1,'work','2022-03-01 13:10:49','2022-01-31'),
(1505,3,4,88,'2022-01-31 11:30:00','2022-01-31 11:55:00',1500,'Riconsegnato e collegato PC client Cristina dopo upgrade hardware',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-15 20:26:37','2022-01-31'),
(1506,3,1,103,'2022-01-31 10:00:00','2022-01-31 10:20:00',1200,'Assistenza su pc client Traverso per problemi posta',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-01 13:16:09','2022-01-31'),
(1507,1,1,2,'2022-02-01 08:06:00','2022-02-01 09:39:00',5580,'problema browse file',69.75,NULL,45,1,'Europe/Rome',69.75,1,'work','2022-07-08 10:16:42','2022-02-01'),
(1508,1,1,26,'2022-01-12 09:22:00','2022-01-12 10:13:00',3060,'problemi ricerca outlook 2019',38.25,NULL,45,1,'Europe/Rome',38.25,1,'work','2022-03-17 16:43:47','2022-01-12'),
(1509,1,1,3,'2022-01-12 15:22:00','2022-01-12 17:30:00',7680,'problemi backup remoti, pc temp in lab per backup first',96,NULL,45,1,'Europe/Rome',96,1,'work','2022-02-23 10:56:53','2022-01-12'),
(1510,1,1,103,'2022-01-13 07:46:00','2022-01-13 10:00:00',8040,'verifiche firewall nuovo e sincro dati',100.5,NULL,45,1,'Europe/Rome',100.5,1,'work','2022-03-01 13:11:25','2022-01-13'),
(1511,1,1,26,'2022-01-14 07:44:00','2022-01-14 08:47:00',3780,'problema ricerca mail outlook',47.25,NULL,45,1,'Europe/Rome',47.25,1,'work','2022-03-17 16:43:49','2022-01-14'),
(1512,1,1,67,'2022-01-14 09:38:00','2022-01-14 11:00:00',4920,'installazione nuovo antivirus su vm, agg',61.5,NULL,45,1,'Europe/Rome',61.5,1,'work','2022-03-07 20:54:07','2022-01-14'),
(1513,1,1,3,'2022-01-14 13:42:00','2022-01-14 16:00:00',8280,'Backup remoti',103.5,NULL,45,1,'Europe/Rome',103.5,1,'work','2022-02-23 10:56:51','2022-01-14'),
(1514,1,1,2,'2022-01-14 16:17:00','2022-01-14 17:30:00',4380,'agg server',54.75,NULL,45,1,'Europe/Rome',54.75,1,'work','2022-02-10 14:52:09','2022-01-14'),
(1515,1,1,3,'2022-01-17 09:02:00','2022-01-17 11:29:00',8820,'sistemazioni varie dopo report controlli server',110.25,NULL,45,1,'Europe/Rome',110.25,1,'work','2022-02-23 10:56:51','2022-01-17'),
(1516,1,1,103,'2022-01-19 07:47:00','2022-01-19 09:18:00',5460,'copia dati da vecchio firewall (non copiati durante migrazione)',68.25,NULL,45,1,'Europe/Rome',68.25,1,'work','2022-03-01 13:11:32','2022-01-19'),
(1517,1,1,3,'2022-01-19 13:46:00','2022-01-19 15:00:00',4440,'backup remoit',55.5,NULL,45,1,'Europe/Rome',55.5,1,'work','2022-02-23 10:56:47','2022-01-19'),
(1518,1,1,3,'2022-01-20 13:30:00','2022-01-20 14:14:00',2640,NULL,33,NULL,45,1,'Europe/Rome',33,1,'work','2022-02-24 15:33:42','2022-01-20'),
(1519,1,1,24,'2022-01-21 16:16:00','2022-01-21 17:30:00',4440,'agg centralino',55.5,NULL,45,1,'Europe/Rome',55.5,1,'work','2022-03-01 11:13:57','2022-01-21'),
(1520,1,1,2,'2022-01-24 07:43:00','2022-01-24 09:00:00',4620,'vari server',57.75,NULL,45,1,'Europe/Rome',57.75,1,'work','2022-02-10 14:52:08','2022-01-24'),
(1521,1,1,2,'2022-01-24 10:16:00','2022-01-24 11:23:00',4020,NULL,50.25,NULL,45,1,'Europe/Rome',50.25,1,'work','2022-02-10 14:51:35','2022-01-24'),
(1522,1,1,3,'2022-01-24 13:58:00','2022-01-24 15:00:00',3720,'backup remoti',46.5,NULL,45,1,'Europe/Rome',46.5,1,'work','2022-02-23 10:56:53','2022-01-24'),
(1523,1,3,112,'2022-01-24 15:07:00','2022-01-24 15:44:00',2220,NULL,27.75,NULL,45,1,'Europe/Rome',27.75,1,'work','2022-02-24 16:04:10','2022-01-24'),
(1524,1,1,3,'2022-01-24 16:02:00','2022-01-24 17:30:00',5280,'backup remoti proxmox',66,NULL,45,1,'Europe/Rome',66,1,'work','2022-02-23 10:56:49','2022-01-24'),
(1525,1,3,112,'2022-01-25 09:55:00','2022-01-25 10:25:00',1800,NULL,22.5,NULL,45,1,'Europe/Rome',22.5,1,'work','2022-02-24 16:04:11','2022-01-25'),
(1526,1,1,1,'2022-01-25 07:43:00','2022-01-25 09:37:00',6840,'agg server posta e windows',85.5,NULL,45,1,'Europe/Rome',85.5,1,'work','2022-02-10 17:23:06','2022-01-25'),
(1527,1,1,3,'2022-01-25 10:30:00','2022-01-25 11:30:00',3600,NULL,45,NULL,45,1,'Europe/Rome',45,1,'work','2022-02-23 10:56:49','2022-01-25'),
(1528,1,1,5,'2022-01-26 17:04:00','2022-01-26 17:25:00',1260,'agg server',15.75,NULL,45,1,'Europe/Rome',15.75,1,'work','2022-03-18 13:51:34','2022-01-26'),
(1529,1,1,2,'2022-01-28 14:27:00','2022-01-28 16:36:00',7740,'nas critografato',96.75,NULL,45,1,'Europe/Rome',96.75,1,'work','2022-07-08 10:16:40','2022-01-28'),
(1530,1,1,2,'2022-01-28 07:43:00','2022-01-28 08:38:00',3300,'ripristino telecamere nas',41.25,NULL,45,1,'Europe/Rome',41.25,1,'work','2022-07-08 10:16:38','2022-01-28'),
(1531,1,1,3,'2022-01-31 13:30:00','2022-01-31 17:30:00',14400,'backup first su server temp\r\nproxmox backup per backup host fisici',180,NULL,45,1,'Europe/Rome',180,1,'work','2022-02-23 10:57:05','2022-01-31'),
(1533,1,6,9,'2022-01-31 08:17:00','2022-01-31 08:40:00',1380,'per agg nas',17.25,NULL,45,1,'Europe/Rome',17.25,1,'work','2022-06-29 09:02:08','2022-01-31'),
(1534,1,1,2,'2022-01-31 08:41:00','2022-01-31 10:22:00',6060,'agg server e backup su firewall temp intANTO CHE non riprisdtino il prog sul nas',75.75,NULL,45,1,'Europe/Rome',75.75,1,'work','2022-07-08 10:16:41','2022-01-31'),
(1535,3,2,79,'2022-02-01 14:00:00','2022-02-01 15:40:00',6000,'Consegnata e installata nuovo stampante Magazzino\r\nConfigurata stampante nuova su tutti client\r\nAssistenza su stampanti  varie, Assistenza su PC client Andrea e Michele',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-04-05 15:01:03','2022-02-01'),
(1536,3,2,104,'2022-02-01 16:00:00','2022-02-01 16:15:00',900,'Assistenza per problema server bloccato',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-10 13:16:54','2022-02-01'),
(1537,3,1,1,'2022-02-01 09:55:00','2022-02-01 10:05:00',600,'Configurata cartella Condivisi su portatile che usano da casa',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-10 17:23:22','2022-02-01'),
(1538,1,1,41,'2022-02-02 07:40:00','2022-02-02 09:00:00',4800,'problemi wifi in via wagner pc fucili',60,NULL,45,1,'Europe/Rome',60,1,'work','2022-05-06 09:13:40','2022-02-02'),
(1539,1,1,3,'2022-02-01 13:40:00','2022-02-01 14:22:00',2520,'fogli',31.5,NULL,45,1,'Europe/Rome',31.5,1,'work','2022-02-23 10:56:58','2022-02-01'),
(1540,3,2,41,'2022-02-02 09:40:00','2022-02-02 10:10:00',1800,'Assistenza su PC client Fucilli per problemi connessione, sopralluogo per verifica avanzamento lavori uffici',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-06 09:13:42','2022-02-02'),
(1541,1,1,57,'2022-02-02 15:45:00','2022-02-02 18:00:00',8100,'problema recuperto file da backup',101.25,NULL,45,1,'Europe/Rome',101.25,1,'work','2022-03-08 22:18:33','2022-02-02'),
(1542,3,1,108,'2022-02-02 07:45:00','2022-02-02 08:00:00',900,'Assistenza su pc client Biglietteria per recupero password accesso ad un sito',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-10-04 14:15:06','2022-02-02'),
(1543,3,1,41,'2022-02-02 09:00:00','2022-02-02 09:20:00',1200,'Assistenza su pc client Nicolò per problema spazio mail',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-06 09:13:48','2022-02-02'),
(1544,3,1,41,'2022-02-02 10:30:00','2022-02-02 10:45:00',900,'Assistenza su pc client Luana per problemi indicizzazione Outlook',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-06 09:13:42','2022-02-02'),
(1545,3,2,104,'2022-02-02 15:00:00','2022-02-02 15:20:00',1200,'Assistenza per problema server bloccato',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-10 13:16:55','2022-02-02'),
(1546,3,4,84,'2022-02-02 15:30:00','2022-02-02 17:30:00',7200,'Installato nuovo portatile con windows e ubuntu in dual boot, utilizzato ssd m2 da 1tb e 8 gb ram ddr4',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-22 10:18:02','2022-02-02'),
(1547,1,1,55,'2022-02-01 14:42:00','2022-02-01 17:30:00',10080,'aggiornamenti server e vm',126,NULL,45,1,'Europe/Rome',126,1,'work','2022-03-16 10:37:57','2022-02-01'),
(1548,1,4,3,'2022-02-02 13:15:00','2022-02-02 14:30:00',4500,'portatile rui ssd',56.25,NULL,45,1,'Europe/Rome',56.25,1,'work','2022-02-23 10:57:04','2022-02-02'),
(1549,3,2,84,'2022-02-03 10:20:00','2022-02-03 11:20:00',3600,'Consegnato e configurato nuovo portatile',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-22 10:18:03','2022-02-03'),
(1550,3,2,104,'2022-02-03 07:40:00','2022-02-03 08:00:00',1200,'Assistenza per problema server bloccato',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-10 13:16:56','2022-02-03'),
(1551,1,1,41,'2022-02-03 14:37:00','2022-02-03 14:46:00',540,'problema associazione file',6.75,NULL,45,1,'Europe/Rome',6.75,1,'work','2022-05-06 09:13:53','2022-02-03'),
(1552,3,2,24,'2022-02-03 14:05:00','2022-02-03 14:35:00',1800,'Configurate telecamere gommista su iPhone Giovanni',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-01 11:38:39','2022-02-03'),
(1553,3,2,104,'2022-02-03 14:45:00','2022-02-03 15:00:00',900,'Ritirato server per assistenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-10 11:46:24','2022-02-03'),
(1554,3,2,104,'2022-02-03 17:00:00','2022-02-03 18:00:00',3600,'Riconsegnato e configurato server dopo sostituzione hw\r\nUtilizzato: mb, cpu, ram e ventola usata + ventola nuova',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-10 13:16:58','2022-02-03'),
(1555,3,2,41,'2022-02-04 13:30:00','2022-02-04 16:30:00',10800,'Ricollegate tutte postazioni client + tutti i dispositivi nel nuovo ufficio + verifica funzionamento',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-06 09:13:53','2022-02-04'),
(1556,1,1,3,'2022-02-04 13:34:00','2022-02-04 17:30:00',14160,'ripristino backup remoti cristallina libro e tentativo di attivazione per aldo rapallo.\r\nRipristino backup zfs su macchina temporanea in lab dopo cambio mb',177,NULL,45,1,'Europe/Rome',177,1,'work','2022-02-23 10:56:59','2022-02-04'),
(1557,3,1,75,'2022-02-04 08:25:00','2022-02-04 08:45:00',1200,'Assistenza per problemi navigazione dovuti a Fastweb',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-24 16:00:28','2022-02-04'),
(1558,1,1,64,'2022-02-07 09:48:00','2022-02-07 10:22:00',2040,'riconfigurazione smtp per funzionamento su openstat manager',25.5,NULL,45,1,'Europe/Rome',25.5,1,'work','2022-02-24 15:32:57','2022-02-07'),
(1559,3,2,53,'2022-02-07 14:10:00','2022-02-07 14:40:00',1800,'Riconsegnato e configurato il nas',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-10 14:14:33','2022-02-07'),
(1560,3,2,67,'2022-02-07 15:00:00','2022-02-07 17:45:00',9900,'Assistenza per rumore ventola su Server + pulizia polvere su server, assistenza su database Teleselling per problemi dopo riavvio server',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-07 21:42:42','2022-02-07'),
(1561,3,1,64,'2022-02-07 08:15:00','2022-02-07 10:15:00',7200,'Assistenza su pc client Gloria per problemi invio fatture da gestionale',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-24 15:32:56','2022-02-07'),
(1562,3,1,4,'2022-02-07 10:40:00','2022-02-07 11:00:00',1200,'Assistenza su pc client Arianna per problema visualizzazione Ariel',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-17 17:27:04','2022-02-07'),
(1563,1,1,67,'2022-02-08 08:20:00','2022-02-08 10:24:00',7440,'sistemazione script di backup e selezione db da backuppare',93,NULL,45,1,'Europe/Rome',93,1,'work','2022-03-07 20:54:31','2022-02-08'),
(1564,1,1,67,'2022-02-07 15:50:00','2022-02-07 17:30:00',6000,'casini dopo riavvio server\r\nfede li',75,NULL,45,1,'Europe/Rome',75,1,'work','2022-03-07 20:54:24','2022-02-07'),
(1565,3,1,27,'2022-02-08 08:15:00','2022-02-08 09:30:00',4500,'Assistenza per aggiornamento versione Wordpress e assistenza su pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-24 15:23:51','2022-02-08'),
(1566,3,1,83,'2022-02-08 09:35:00','2022-02-08 09:55:00',1200,'Assistenza su pc client Dalia per problemi con stampante ad aghi',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-18 11:13:17','2022-02-08'),
(1567,3,1,108,'2022-02-08 10:00:00','2022-02-08 10:25:00',1500,'Assistenza su pc client Barbara',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-10-04 14:15:07','2022-02-08'),
(1568,3,4,27,'2022-02-08 10:50:00','2022-02-08 11:30:00',2400,'Assistenza su mac fratello Elisabetta per problemi posta, il mac è troppo vecchio e va sostituito',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-24 15:23:52','2022-02-08'),
(1569,3,1,83,'2022-02-08 13:40:00','2022-02-08 14:05:00',1500,'Assistenza su pc client Dalia e Orietta per problemi allineamento stampante ad aghi',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-18 11:13:18','2022-02-08'),
(1570,3,1,87,'2022-02-08 15:25:00','2022-02-08 15:35:00',600,'Installata 1 licenza agg. su 2 pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-10 13:20:34','2022-02-08'),
(1571,3,1,50,'2022-02-08 15:40:00','2022-02-08 15:50:00',600,'Installata 1 licenza agg. su 2 pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-16 16:18:38','2022-02-08'),
(1572,3,1,2,'2022-02-08 15:50:00','2022-02-08 16:05:00',900,'Installata 1 licenza agg. su 2 pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-24 09:10:59','2022-02-08'),
(1573,1,1,1,'2022-02-09 09:42:00','2022-02-09 10:37:28',3328,'config interno su smartphone',41.6,NULL,45,1,'Europe/Rome',41.6,1,'work','2022-02-10 17:23:24','2022-02-09'),
(1574,1,1,55,'2022-02-09 10:49:00','2022-02-09 11:11:51',1371,'config vpn laura',17.14,NULL,45,1,'Europe/Rome',17.14,1,'work','2022-03-16 10:37:58','2022-02-09'),
(1575,3,2,50,'2022-02-10 08:30:00','2022-02-10 08:50:00',1200,'Consegna toner originale per stampante Brother\r\nAssistenza su stampante Epson',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-16 16:12:06','2022-02-10'),
(1576,3,2,41,'2022-02-10 09:20:00','2022-02-10 09:55:00',2100,'Risolto problema timer su stampante ad aghi in via Wagner, assistenza su PC client Roberta',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-06 09:13:44','2022-02-10'),
(1577,1,1,114,'2022-02-09 13:42:00','2022-02-09 16:00:00',8280,'config firweall',103.5,NULL,45,1,'Europe/Rome',103.5,1,'work','2022-04-01 08:28:22','2022-02-09'),
(1578,1,1,3,'2022-02-10 07:30:00','2022-02-10 10:20:00',10200,'wireguard',127.5,NULL,45,1,'Europe/Rome',127.5,1,'work','2022-02-23 10:57:03','2022-02-10'),
(1579,1,3,112,'2022-02-09 16:00:00','2022-02-09 17:30:00',5400,NULL,67.5,NULL,45,1,'Europe/Rome',67.5,1,'work','2022-02-24 16:04:14','2022-02-09'),
(1580,1,1,3,'2022-02-09 20:43:00','2022-02-09 21:54:00',4260,'wireguard',53.25,NULL,45,1,'Europe/Rome',53.25,1,'work','2022-02-23 10:56:59','2022-02-09'),
(1581,3,4,84,'2022-02-09 08:30:00','2022-02-09 09:30:00',3600,'Montata nuova mb e scocca su portatile Asus + verifica funzionamento',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-22 10:18:04','2022-02-09'),
(1582,3,1,27,'2022-02-09 10:00:00','2022-02-09 11:30:00',5400,'Assistenza su sito dancingcavalierking.it per problemi visualizzazione dopo agg versione WordPress',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-24 15:23:55','2022-02-09'),
(1583,3,1,95,'2022-02-09 16:20:00','2022-02-09 17:20:00',3600,'Assistenza su portatile rag. Porcile',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-18 15:31:13','2022-02-09'),
(1584,3,1,26,'2022-02-10 11:15:00','2022-02-10 11:25:00',600,'Assistenza su pc client Simona per problema di stampa',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-17 16:43:51','2022-02-10'),
(1585,3,1,27,'2022-02-10 17:10:00','2022-02-10 17:30:00',1200,'Assistenza per configurazione mail su nuovo mac',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-17 10:50:10','2022-02-10'),
(1586,1,1,3,'2022-02-10 13:45:00','2022-02-10 16:00:00',8100,'wireguard con shorewall',101.25,NULL,45,1,'Europe/Rome',101.25,1,'work','2022-02-23 10:57:02','2022-02-10'),
(1587,1,6,9,'2022-02-10 16:10:00','2022-02-10 16:30:00',1200,'per preventivo spiegazione',15,NULL,45,1,'Europe/Rome',15,1,'work','2022-06-28 15:22:20','2022-02-10'),
(1588,1,3,112,'2022-02-10 16:30:00','2022-02-10 17:30:00',3600,NULL,45,NULL,45,1,'Europe/Rome',45,1,'work','2022-02-24 16:04:15','2022-02-10'),
(1589,1,1,3,'2022-02-10 10:47:00','2022-02-10 11:30:00',2580,'wireguard',32.25,NULL,45,1,'Europe/Rome',32.25,1,'work','2022-02-23 10:57:00','2022-02-10'),
(1590,3,2,12,'2022-02-11 10:20:00','2022-02-11 10:55:00',2100,'Risolto problema stampa a3 su PC client Claudio e Francesca',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-18 14:02:13','2022-02-11'),
(1591,3,2,84,'2022-02-11 11:10:00','2022-02-11 11:20:00',600,'Riconsegnato portatile dopo sostituzione mb e scocca',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-22 10:18:05','2022-02-11'),
(1592,1,1,55,'2022-02-11 13:44:00','2022-02-11 15:44:00',7200,'fede li per consegnare 2 pc, problema su un pc sull\'utente marika che non loggava correttamente',90,NULL,45,1,'Europe/Rome',90,1,'work','2022-03-16 10:06:07','2022-02-11'),
(1593,1,1,1,'2022-02-11 16:07:00','2022-02-11 16:15:53',533,'problema stampa filiale \"errore carta esaurita\"',6.66,NULL,45,1,'Europe/Rome',6.66,1,'work','2022-05-06 09:46:06','2022-02-11'),
(1594,3,2,55,'2022-02-11 12:30:00','2022-02-11 17:30:00',18000,'Consegna e configurazione 2 nuovi PC client',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-16 10:37:59','2022-02-11'),
(1595,1,1,55,'2022-02-14 10:02:00','2022-02-14 10:20:00',1080,'insdtallazione amico win su nuovo pc marika',13.5,NULL,45,1,'Europe/Rome',13.5,1,'work','2022-03-16 10:38:00','2022-02-14'),
(1596,3,1,79,'2022-02-14 08:00:00','2022-02-14 08:20:00',1200,'Assistenza per problemi su certificato di posta',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-04-05 15:01:06','2022-02-14'),
(1597,3,2,104,'2022-02-14 09:40:00','2022-02-14 09:50:00',600,'Riconsegnata stampante Brother dopo assistenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-23 10:48:01','2022-02-14'),
(1598,3,1,50,'2022-02-14 10:10:00','2022-02-14 10:20:00',600,'Configurata pec su pc client Francesco',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-16 16:12:08','2022-02-14'),
(1599,3,1,85,'2022-02-14 13:40:00','2022-02-14 13:50:00',600,'Aumentato spazio posta account rellecati',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-16 15:21:06','2022-02-14'),
(1600,3,1,10,'2022-02-14 14:10:00','2022-02-14 14:30:00',1200,'Assistenza per creazione QrCode',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-18 13:50:34','2022-02-14'),
(1601,1,1,41,'2022-02-15 13:58:00','2022-02-15 15:17:00',4740,'stampanti via wagner',59.25,NULL,45,1,'Europe/Rome',59.25,1,'work','2022-05-06 09:13:54','2022-02-15'),
(1602,3,2,114,'2022-02-15 14:35:00','2022-02-15 16:45:00',7800,'Consegnato e configurato nuovo firewall presso la sede in Via del Manzasco\r\nUtilizzato: 1 cavo di rete da 2mt',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-04-01 09:18:23','2022-02-15'),
(1603,1,1,114,'2022-02-15 15:29:00','2022-02-15 17:30:00',7260,'fede li a montare inkfire1\r\ntest vpn con client',90.75,NULL,45,1,'Europe/Rome',90.75,1,'work','2022-04-01 08:28:35','2022-02-15'),
(1604,3,1,55,'2022-02-15 07:45:00','2022-02-15 08:00:00',900,'Assistenza su portatile casa Laura per collegamento remoto',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-16 10:38:00','2022-02-15'),
(1605,3,2,41,'2022-02-16 08:45:00','2022-02-16 10:00:00',4500,'Assistenza su stampanti e cellulare Fucilli in via Wagner',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-06 09:13:45','2022-02-16'),
(1606,1,1,79,'2022-02-16 13:48:00','2022-02-16 16:27:00',9540,'problemi elena con la posta',119.25,NULL,45,1,'Europe/Rome',119.25,1,'work','2022-04-05 15:01:11','2022-02-16'),
(1607,1,2,112,'2022-02-16 10:42:00','2022-02-16 11:30:00',2880,NULL,36,NULL,45,1,'Europe/Rome',36,1,'work','2022-02-24 16:04:16','2022-02-16'),
(1608,1,1,41,'2022-02-16 13:00:00','2022-02-16 13:39:00',2340,'agg windows server',29.25,NULL,45,1,'Europe/Rome',29.25,1,'work','2022-05-06 09:13:59','2022-02-16'),
(1609,1,1,41,'2022-02-16 09:16:00','2022-02-16 10:30:00',4440,'agg server windows',55.5,NULL,45,1,'Europe/Rome',55.5,1,'work','2022-05-06 09:13:48','2022-02-16'),
(1610,1,1,2,'2022-02-16 07:44:00','2022-02-16 08:14:00',1800,'agg nas',22.5,NULL,45,1,'Europe/Rome',22.5,1,'work','2022-07-08 10:16:46','2022-02-16'),
(1611,1,1,6,'2022-02-16 08:32:00','2022-02-16 09:04:00',1920,'agg nas',24,NULL,45,1,'Europe/Rome',24,1,'work','2022-03-16 17:57:47','2022-02-16'),
(1612,3,2,27,'2022-02-16 13:45:00','2022-02-16 15:45:00',7200,'Assistenza su Mac e pc client \r\nAssistenza per cambio tutte le password',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-24 15:23:59','2022-02-16'),
(1613,1,1,114,'2022-02-16 16:34:00','2022-02-16 17:18:00',2640,'config unifi su secondo firewall',33,NULL,45,1,'Europe/Rome',33,1,'work','2022-04-01 09:18:40','2022-02-16'),
(1614,3,1,79,'2022-02-16 07:45:00','2022-02-16 08:00:00',900,'Assistenza su pc client Paola',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-04-05 15:01:07','2022-02-16'),
(1615,1,1,1,'2022-02-17 07:50:00','2022-02-17 08:10:00',1200,'problema dopo salto corrente',15,NULL,45,1,'Europe/Rome',15,1,'work','2022-05-06 09:46:07','2022-02-17'),
(1616,1,1,75,'2022-02-17 08:12:00','2022-02-17 08:15:00',180,'problema connessione vpn erika cartosio',2.25,NULL,45,1,'Europe/Rome',2.25,1,'work','2022-02-24 15:39:20','2022-02-17'),
(1617,3,1,96,'2022-02-17 08:15:00','2022-02-17 08:35:00',1200,'Assistenza telefonica per configurazione teams nella postazione Videoconferenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-24 14:57:49','2022-02-17'),
(1618,1,1,96,'2022-02-17 08:53:00','2022-02-17 09:10:00',1020,'problemi con minipc conferenze',12.75,NULL,45,1,'Europe/Rome',12.75,1,'work','2022-02-24 14:57:50','2022-02-17'),
(1619,1,1,114,'2022-02-17 09:16:00','2022-02-17 10:00:00',2640,'fede a consegnare il secondo firewall, saltato internet',33,NULL,45,1,'Europe/Rome',33,1,'work','2022-04-01 08:34:48','2022-02-17'),
(1620,3,2,114,'2022-02-17 08:45:00','2022-02-17 11:20:00',9300,'Consegnato e configurato nuovo Firewall \r\nConsegnato e configurato nuovo Unifi\r\nUtilizzato: 2 cavi di rete da 2mt',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-04-01 09:57:57','2022-02-17'),
(1621,1,1,2,'2022-02-17 13:42:00','2022-02-17 15:51:00',7740,'sistemazione notifiche nas e webmail',96.75,NULL,45,1,'Europe/Rome',96.75,1,'work','2022-07-08 10:18:11','2022-02-17'),
(1622,1,1,114,'2022-02-17 16:05:00','2022-02-17 16:48:16',2596,'config unifi',32.45,NULL,45,1,'Europe/Rome',32.45,1,'work','2022-04-01 08:35:00','2022-02-17'),
(1623,1,1,3,'2022-02-17 17:02:00','2022-02-17 17:30:00',1680,'wireguard su mac',21,NULL,45,1,'Europe/Rome',21,1,'work','2022-02-23 10:57:05','2022-02-17'),
(1624,3,2,114,'2022-02-18 14:15:00','2022-02-18 14:55:00',2400,'Consegnato e configurato nuovo Unifi\r\nUtilizzato: 2 cavi di rete da 2mt',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-04-01 09:57:59','2022-02-18'),
(1625,3,2,101,'2022-02-18 15:15:00','2022-02-18 15:45:00',1800,'Assistenza su Server per problemi con avvio versione 5.9 del kernel',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-17 16:48:35','2022-02-18'),
(1626,3,2,79,'2022-02-18 09:00:00','2022-02-18 09:10:00',600,'Assistenza su pc client Roberto',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-04-05 15:01:08','2022-02-18'),
(1627,3,1,17,'2022-02-18 10:30:00','2022-02-18 10:50:00',1200,'Assistenza su pc client Elena per problemi stampa plotter',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-01 15:22:55','2022-02-18'),
(1628,1,1,55,'2022-02-21 09:50:00','2022-02-21 11:17:00',5220,'cambio pc marika',65.25,NULL,45,1,'Europe/Rome',65.25,1,'work','2022-02-23 10:58:34','2022-02-21'),
(1629,1,1,3,'2022-02-18 13:40:00','2022-02-18 14:43:00',3780,'wireguard su mac e config per inkout',47.25,NULL,45,1,'Europe/Rome',47.25,1,'work','2022-02-23 10:57:01','2022-02-18'),
(1630,1,1,55,'2022-02-18 14:50:00','2022-02-18 15:50:00',3600,'pc nuovo marika si spegne',45,NULL,45,1,'Europe/Rome',45,1,'work','2022-02-23 10:58:27','2022-02-18'),
(1631,1,1,3,'2022-02-18 16:13:00','2022-02-18 17:30:00',4620,'wireguard su mac e config per inkout',57.75,NULL,45,1,'Europe/Rome',57.75,1,'work','2022-02-23 10:57:01','2022-02-18'),
(1632,1,1,3,'2022-02-18 10:04:00','2022-02-18 11:30:00',5160,'wireguard su mac e config per inkout',64.5,NULL,45,1,'Europe/Rome',64.5,1,'work','2022-02-23 10:57:06','2022-02-18'),
(1633,1,4,3,'2022-02-21 13:30:00','2022-02-21 14:16:00',2760,NULL,34.5,NULL,45,1,'Europe/Rome',34.5,1,'work','2022-02-23 10:57:09','2022-02-21'),
(1634,1,6,90,'2022-02-21 14:33:00','2022-02-21 14:35:00',120,'per problemi posta luciano',1.5,NULL,45,1,'Europe/Rome',1.5,1,'work','2022-02-24 16:06:06','2022-02-21'),
(1635,1,1,55,'2022-02-21 14:37:00','2022-02-21 14:42:00',300,'problema task manager remoto laura',3.75,NULL,45,1,'Europe/Rome',3.75,1,'work','2022-03-16 10:38:03','2022-02-21'),
(1636,1,1,2,'2022-02-21 14:53:00','2022-02-21 15:44:00',3060,'problemi scanner laura',38.25,NULL,45,1,'Europe/Rome',38.25,1,'work','2022-07-08 10:16:53','2022-02-21'),
(1637,3,2,55,'2022-02-21 14:15:00','2022-02-21 16:00:00',6300,'Sostituzione e configurazione nuovo PC client Marika difettoso, assistenza su nuovo PC client postazione Amazon, assistenza su PC client Otto.\r\nInstallate 2 licenze nod32 agg su 4 PC client',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-16 10:38:01','2022-02-21'),
(1638,1,1,114,'2022-02-21 16:00:00','2022-02-21 16:57:00',3420,'creazioni chiavi vpn',42.75,NULL,45,1,'Europe/Rome',42.75,1,'work','2022-04-01 09:22:05','2022-02-21'),
(1639,1,1,3,'2022-02-21 07:48:00','2022-02-21 09:37:00',6540,'wireguard gui per client',81.75,NULL,45,1,'Europe/Rome',81.75,1,'work','2022-02-23 10:57:07','2022-02-21'),
(1640,3,1,75,'2022-02-21 07:50:00','2022-02-21 08:20:00',1800,'Assistenza su pc client Oneto e Erika per problema collegamento a cartella condivisa NAS',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-24 16:00:29','2022-02-21'),
(1641,3,4,55,'2022-02-21 08:30:00','2022-02-21 09:30:00',3600,'Preparato nuovo pc client Marika per sostituire suo nuovo pc difettoso',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-23 10:58:31','2022-02-21'),
(1642,1,1,55,'2022-02-22 11:21:00','2022-02-22 11:28:00',420,'problema mail su nuovo pc',5.25,NULL,45,1,'Europe/Rome',5.25,1,'work','2022-03-16 09:21:02','2022-02-22'),
(1643,1,1,3,'2022-02-22 09:14:00','2022-02-22 11:12:00',7080,'problema lettore nfc\r\nzabbix',88.5,NULL,45,1,'Europe/Rome',88.5,1,'work','2022-02-23 10:57:10','2022-02-22'),
(1644,1,1,2,'2022-02-22 07:45:00','2022-02-22 09:00:00',4500,'agg server',56.25,NULL,45,1,'Europe/Rome',56.25,1,'work','2022-05-05 08:04:18','2022-02-22'),
(1645,1,1,24,'2022-02-22 15:25:00','2022-02-22 17:42:00',8220,'vecchio centralino guasto spostato tutto su lxc fede li',102.75,NULL,45,1,'Europe/Rome',102.75,1,'work','2022-03-01 11:16:53','2022-02-22'),
(1646,1,3,112,'2022-02-22 15:05:00','2022-02-22 15:20:00',900,NULL,11.25,NULL,45,1,'Europe/Rome',11.25,1,'work','2022-02-24 16:04:16','2022-02-22'),
(1647,1,1,24,'2022-02-22 14:50:00','2022-02-22 15:05:00',900,'backup vecchio centralino e prep per ripristino fede li',11.25,NULL,45,1,'Europe/Rome',11.25,1,'work','2022-03-01 11:16:50','2022-02-22'),
(1648,3,1,95,'2022-02-22 09:10:00','2022-02-22 09:20:00',600,'Assistenza su pc client Anna',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-18 15:31:20','2022-02-22'),
(1649,1,4,3,'2022-02-22 13:30:00','2022-02-22 14:40:00',4200,'per tuo problema nfc',52.5,NULL,45,1,'Europe/Rome',52.5,1,'work','2022-02-23 10:57:11','2022-02-22'),
(1650,3,2,24,'2022-02-22 14:25:00','2022-02-22 17:35:00',11400,'Assistenza per installazione centralino 3cx su nuova vm lxc su server Linux\r\nRitirato vecchio centralino con problemi alla mb',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-01 11:38:40','2022-02-22'),
(1651,1,1,95,'2022-02-23 07:40:00','2022-02-23 09:22:00',6120,'problemi vm win2k8',76.5,NULL,45,1,'Europe/Rome',76.5,1,'work','2022-02-24 16:40:28','2022-02-23'),
(1652,1,1,96,'2022-02-23 11:17:00','2022-02-23 11:24:00',420,'aiutato fede per test teams da gandolfo',5.25,NULL,45,1,'Europe/Rome',5.25,1,'work','2022-02-24 11:37:12','2022-02-23'),
(1653,1,3,112,'2022-02-23 09:24:00','2022-02-23 10:40:00',4560,NULL,57,NULL,45,1,'Europe/Rome',57,1,'work','2022-02-24 16:04:17','2022-02-23'),
(1654,1,1,95,'2022-02-23 10:40:00','2022-02-23 11:13:00',1980,'ottimizzazione vm windows per evitare blocchi futuri',24.75,NULL,45,1,'Europe/Rome',24.75,1,'work','2022-02-24 16:40:29','2022-02-23'),
(1655,3,2,96,'2022-02-23 10:15:00','2022-02-23 11:30:00',4500,'Assistenza su postazione client Videoconferenza, assistenza su portatile Gandolfo, installate 2 licenze nod32 aggiornamento su 4 PC client',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-02-24 14:57:54','2022-02-23'),
(1656,1,1,104,'2022-02-23 11:25:00','2022-02-23 12:30:00',3900,'problemi collegamento a gemini\r\nproblema di vodafone',48.75,NULL,45,1,'Europe/Rome',48.75,1,'work','2022-03-23 11:02:26','2022-02-23'),
(1657,3,2,12,'2022-02-23 14:00:00','2022-02-23 15:20:00',4800,'Assistenza su mac portatile Camilla, Assistenza su ipad Francesca per collegamento vpn, installata e configurata vpn su ipad Claudio',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-18 14:12:30','2022-02-23'),
(1658,1,1,3,'2022-02-23 15:05:00','2022-02-23 16:19:00',4440,'aruba key tua',55.5,NULL,45,1,'Europe/Rome',55.5,1,'work','2022-02-24 15:33:45','2022-02-23'),
(1659,3,2,24,'2022-02-24 07:40:00','2022-02-24 08:15:00',2100,'Verificato e ritirato pc client Gommista per assistenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-01 11:38:41','2022-02-24'),
(1660,3,1,103,'2022-02-23 07:50:00','2022-02-23 08:30:00',2400,'Assistenza per eliminare ip server di posta da blacklist, assistenza su pc client Martina',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-01 13:16:11','2022-02-23'),
(1661,1,1,114,'2022-02-23 16:33:00','2022-02-23 17:30:00',3420,'fine test vpn',42.75,NULL,45,1,'Europe/Rome',42.75,1,'work','2022-04-01 08:32:54','2022-02-23'),
(1662,1,1,3,'2022-02-23 13:30:00','2022-02-23 14:52:00',4920,'zabbix',61.5,NULL,45,1,'Europe/Rome',61.5,1,'work','2022-02-24 15:33:44','2022-02-23'),
(1663,1,1,114,'2022-02-24 07:43:00','2022-02-24 09:14:00',5460,'guida wireguard per 2 sistemi operativi e invio chiavi al clienite',68.25,NULL,45,1,'Europe/Rome',68.25,1,'work','2022-04-01 09:58:00','2022-02-24'),
(1664,1,1,26,'2022-02-24 15:00:00','2022-02-24 15:36:00',2160,'verifica per webmail',27,NULL,45,1,'Europe/Rome',27,1,'work','2022-03-17 16:43:50','2022-02-24'),
(1665,1,1,3,'2022-02-24 13:30:00','2022-02-24 14:40:00',4200,'taxi e problemi aruba',52.5,NULL,45,1,'Europe/Rome',52.5,1,'work','2022-02-24 15:33:55','2022-02-24'),
(1666,1,1,35,'2022-02-24 15:50:00','2022-02-24 16:38:00',2880,'problema backup su nas, pc cambio ip',36,NULL,45,1,'Europe/Rome',36,1,'work','2022-04-29 07:53:48','2022-02-24'),
(1667,3,1,88,'2022-02-24 08:30:00','2022-02-24 08:40:00',600,'Assistenza per problema con certificato di posta',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-15 20:25:25','2022-02-24'),
(1668,3,1,43,'2022-02-24 08:40:00','2022-02-24 09:15:00',2100,'Assistenza per problema archiviazione posta elettronica',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-17 17:11:42','2022-02-24'),
(1669,3,1,32,'2022-02-24 09:15:00','2022-02-24 09:55:00',2400,'Assistenza su pc client Luca per problemi con software java dell\'Agenzia delle Entrate',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-16 09:19:44','2022-02-24'),
(1670,3,1,50,'2022-02-24 10:00:00','2022-02-24 10:10:00',600,'Assistenza su pc client Filippo',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-07 13:57:17','2022-02-24'),
(1671,3,1,111,'2022-02-24 10:10:00','2022-02-24 11:10:00',3600,'Assistenza per programmazione riunione su zoom',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-15 19:21:13','2022-02-24'),
(1672,1,3,112,'2022-02-25 13:30:00','2022-02-25 15:30:00',7200,NULL,90,NULL,45,1,'Europe/Rome',90,1,'work','2022-03-01 08:49:09','2022-02-25'),
(1673,1,1,55,'2022-02-25 15:54:00','2022-02-25 15:59:00',300,'aquila su pc marika',3.75,NULL,45,1,'Europe/Rome',3.75,1,'work','2022-03-16 09:21:18','2022-02-25'),
(1674,3,4,24,'2022-02-25 07:50:00','2022-02-25 09:20:00',5400,'Assistenza su pc client Gomme2 per problemi avvio s.o. Reinstallato s.o pulito + posta, Office e recupero dati\r\nUtilizzato: HHD 2tb Seagate + 4 gb ddr3 usata',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-01 11:38:42','2022-02-25'),
(1675,3,1,12,'2022-02-25 09:30:00','2022-02-25 10:15:00',2700,'Assistenza su pc client Francesca per problemi collegamento cartella condivisa\r\nAssistenza su pc client Claudio per problemi microfono',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-18 14:12:31','2022-02-25'),
(1676,3,1,111,'2022-02-25 10:30:00','2022-02-25 10:55:00',1500,'Assistenza su pc client per prove su videoconferenza su Zoom',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-15 19:21:15','2022-02-25'),
(1677,3,1,76,'2022-02-25 11:10:00','2022-02-25 11:25:00',900,'Installata 1 licenza aggiornamento nod32 su 2 pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-01 11:54:58','2022-02-25'),
(1678,3,1,55,'2022-02-25 11:30:00','2022-02-25 12:00:00',1800,'Assistenza su pc client Marika per problemi su stampante HP',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-16 09:21:10','2022-02-25'),
(1679,3,2,32,'2022-02-25 15:05:00','2022-02-25 15:25:00',1200,'Assistenza su pc client Luca',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-16 09:19:45','2022-02-25'),
(1680,3,2,24,'2022-02-28 08:00:00','2022-02-28 09:30:00',5400,'Riconsegna e configurazione PC client Gomme2',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-01 11:38:43','2022-02-28'),
(1681,1,1,3,'2022-02-01 07:38:00','2022-02-01 08:00:00',1320,'prob thunderbird nostri',16.5,NULL,45,1,'Europe/Rome',16.5,1,'work','2022-03-17 17:35:47','2022-02-01'),
(1682,1,1,3,'2022-02-01 09:56:00','2022-02-01 10:40:00',2640,'analisi clienti messagenet',33,NULL,45,1,'Europe/Rome',33,1,'work','2022-03-17 17:35:48','2022-02-01'),
(1683,1,1,50,'2022-02-01 10:57:00','2022-02-01 11:30:00',1980,'controllo centralino',24.75,NULL,45,1,'Europe/Rome',24.75,1,'work','2022-03-07 13:57:12','2022-02-01'),
(1684,1,1,9,'2022-02-02 09:13:00','2022-02-02 10:45:00',5520,'preventivo nas',69,NULL,45,1,'Europe/Rome',69,1,'work','2022-06-28 15:22:23','2022-02-02'),
(1685,1,1,88,'2022-02-02 10:50:00','2022-02-02 11:26:00',2160,'prob agg 3cx',27,NULL,45,1,'Europe/Rome',27,1,'work','2022-03-15 20:24:48','2022-02-02'),
(1686,1,1,3,'2022-02-02 14:57:00','2022-02-02 15:33:00',2160,'proxmox',27,NULL,45,1,'Europe/Rome',27,1,'work','2022-03-17 17:36:12','2022-02-02'),
(1687,1,1,57,'2022-02-03 07:44:00','2022-02-03 10:26:00',9720,'problemi recupero file, cercato modo di pianificazione backuop e configurazione',121.5,NULL,45,1,'Europe/Rome',121.5,1,'work','2022-03-08 22:18:35','2022-02-03'),
(1688,1,1,2,'2022-02-03 10:45:00','2022-02-03 11:30:00',2700,'problemai francesca',33.75,NULL,45,1,'Europe/Rome',33.75,1,'work','2022-07-08 10:16:43','2022-02-03'),
(1689,1,1,57,'2022-02-03 13:34:00','2022-02-03 14:30:00',3360,'pianificazione backup',42,NULL,45,1,'Europe/Rome',42,1,'work','2022-03-08 22:18:36','2022-02-03'),
(1690,1,1,104,'2022-02-03 16:55:00','2022-02-03 17:28:00',1980,'FEDE LI PROBLEMI CON LAN',24.75,NULL,45,1,'Europe/Rome',24.75,1,'work','2022-03-23 10:48:02','2022-02-03'),
(1691,1,1,57,'2022-02-03 15:12:00','2022-02-03 15:34:00',1320,'pianificazione bakcup',16.5,NULL,45,1,'Europe/Rome',16.5,1,'work','2022-03-08 22:18:38','2022-02-03'),
(1692,1,1,2,'2022-02-03 15:48:00','2022-02-03 16:46:00',3480,'varie su file server',43.5,NULL,45,1,'Europe/Rome',43.5,1,'work','2022-07-08 10:18:06','2022-02-03'),
(1693,1,1,9,'2022-02-04 10:45:00','2022-02-04 11:23:00',2280,'per nuovo firewall',28.5,NULL,45,1,'Europe/Rome',28.5,1,'work','2022-06-28 15:22:21','2022-02-04'),
(1694,1,1,2,'2022-02-04 07:43:00','2022-02-04 10:00:00',8220,'aggiornamento server',102.75,NULL,45,1,'Europe/Rome',102.75,1,'work','2022-05-05 08:04:17','2022-02-04'),
(1695,1,1,50,'2022-02-04 10:10:00','2022-02-04 10:39:00',1740,'agg centralino',21.75,NULL,45,1,'Europe/Rome',21.75,1,'work','2022-03-07 13:57:13','2022-02-04'),
(1696,1,1,79,'2022-02-07 10:43:00','2022-02-07 11:31:00',2880,'agg vm mail',36,NULL,45,1,'Europe/Rome',36,1,'work','2022-04-05 15:01:05','2022-02-07'),
(1697,1,1,110,'2022-02-07 07:48:00','2022-02-07 09:00:00',4320,'ver agg 3cx per mail messagenet',54,NULL,45,1,'Europe/Rome',54,1,'work','2022-03-17 11:06:13','2022-02-07'),
(1698,1,1,96,'2022-02-07 09:04:00','2022-02-07 09:43:00',2340,'agg 3cx',29.25,NULL,45,1,'Europe/Rome',29.25,1,'work','2022-03-10 11:00:25','2022-02-07'),
(1699,1,1,113,'2022-02-08 07:50:00','2022-02-08 08:17:00',1620,'problema docking station non supporta 2 montior',20.25,NULL,45,1,'Europe/Rome',20.25,1,'work','2022-03-17 11:10:28','2022-02-08'),
(1700,1,1,90,'2022-02-08 10:32:00','2022-02-08 11:28:00',3360,'agg server',42,NULL,45,1,'Europe/Rome',42,1,'work','2022-03-01 14:59:06','2022-02-08'),
(1701,1,1,114,'2022-02-08 13:47:00','2022-02-08 16:00:00',7980,'config wireguard per connessione vpn frà le sedi',99.75,NULL,45,1,'Europe/Rome',99.75,1,'work','2022-04-01 08:28:10','2022-02-08'),
(1702,1,1,103,'2022-02-08 16:13:00','2022-02-08 17:28:00',4500,'agg server, ancora problema ora',56.25,NULL,45,1,'Europe/Rome',56.25,1,'work','2022-03-01 13:11:54','2022-02-08'),
(1703,1,1,114,'2022-02-09 08:00:00','2022-02-09 09:23:00',4980,'wireguard su fire 2',62.25,NULL,45,1,'Europe/Rome',62.25,1,'work','2022-04-01 08:28:13','2022-02-09'),
(1704,1,1,24,'2022-02-11 09:09:00','2022-02-11 09:36:00',1620,'per reinstall centraslino',20.25,NULL,45,1,'Europe/Rome',20.25,1,'work','2022-03-01 11:16:14','2022-02-11'),
(1705,1,1,3,'2022-02-11 07:45:00','2022-02-11 09:00:00',4500,'wireguard gui',56.25,NULL,45,1,'Europe/Rome',56.25,1,'work','2022-03-17 17:36:16','2022-02-11'),
(1706,1,1,3,'2022-02-11 09:50:00','2022-02-11 11:28:00',5880,'wireguard gui',73.5,NULL,45,1,'Europe/Rome',73.5,1,'work','2022-03-17 17:36:04','2022-02-11'),
(1707,1,1,51,'2022-02-11 16:32:00','2022-02-11 17:29:00',3420,'agg server',42.75,NULL,45,1,'Europe/Rome',42.75,1,'work','2022-03-07 14:40:01','2022-02-11'),
(1708,1,3,112,'2022-02-14 13:30:00','2022-02-14 14:00:00',1800,NULL,22.5,NULL,45,1,'Europe/Rome',22.5,1,'work','2022-03-01 08:49:07','2022-02-14'),
(1709,1,1,79,'2022-02-14 08:10:00','2022-02-14 08:50:00',2400,'problemi certificati ssl',30,NULL,45,1,'Europe/Rome',30,1,'work','2022-04-05 15:01:06','2022-02-14'),
(1710,1,1,29,'2022-02-14 08:50:00','2022-02-14 10:00:00',4200,'verifica nas backup remoto',52.5,NULL,45,1,'Europe/Rome',52.5,1,'work','2022-05-04 14:38:43','2022-02-14'),
(1711,1,1,3,'2022-02-14 10:30:00','2022-02-14 11:27:00',3420,'agg wiki',42.75,NULL,45,1,'Europe/Rome',42.75,1,'work','2022-03-17 17:36:04','2022-02-14'),
(1712,1,3,112,'2022-02-14 15:03:00','2022-02-14 15:40:00',2220,'passato a prendere 2 batterie ups che mi cioccava la luce a casa',27.75,NULL,45,1,'Europe/Rome',27.75,1,'work','2022-03-01 08:49:07','2022-02-14'),
(1713,1,1,3,'2022-02-14 16:00:00','2022-02-14 17:30:00',5400,'wireguard gui\r\nagg windows',67.5,NULL,45,1,'Europe/Rome',67.5,1,'work','2022-03-17 17:36:05','2022-02-14'),
(1714,1,1,26,'2022-02-14 14:00:00','2022-02-14 15:00:00',3600,'studio outlook',45,NULL,45,1,'Europe/Rome',45,1,'work','2022-03-17 16:14:33','2022-02-14'),
(1715,1,1,55,'2022-02-15 10:05:00','2022-02-15 11:28:00',4980,'problema cp nuovo marika',62.25,NULL,45,1,'Europe/Rome',62.25,1,'work','2022-03-16 09:20:38','2022-02-15'),
(1716,1,1,3,'2022-02-15 13:30:00','2022-02-15 13:57:00',1620,'portatile nuovo con prob installazione widnows per controller',20.25,NULL,45,1,'Europe/Rome',20.25,1,'work','2022-03-17 17:36:15','2022-02-15'),
(1717,1,1,3,'2022-02-15 07:46:00','2022-02-15 10:00:00',8040,'test patch windows 10:20 \r\nwireguard gui',100.5,NULL,45,1,'Europe/Rome',100.5,1,'work','2022-03-17 17:36:15','2022-02-15'),
(1718,1,1,2,'2022-02-17 10:15:00','2022-02-17 11:29:00',4440,'sistemazione nas backup windows server',55.5,NULL,45,1,'Europe/Rome',55.5,1,'work','2022-07-08 10:16:46','2022-02-17'),
(1719,1,1,3,'2022-02-18 07:52:00','2022-02-18 09:50:00',7080,'wireguard gui funzionante',88.5,NULL,45,1,'Europe/Rome',88.5,1,'work','2022-03-17 17:36:10','2022-02-18'),
(1720,1,1,3,'2022-02-21 17:03:00','2022-02-21 17:30:00',1620,NULL,20.25,NULL,45,1,'Europe/Rome',20.25,1,'work','2022-03-17 17:36:13','2022-02-21'),
(1721,1,1,95,'2022-02-24 09:28:00','2022-02-24 10:15:00',2820,'verifica per agg serev',35.25,NULL,45,1,'Europe/Rome',35.25,1,'work','2022-03-18 15:14:43','2022-02-24'),
(1722,1,1,4,'2022-02-24 10:25:00','2022-02-24 11:30:00',3900,'agg vm',48.75,NULL,45,1,'Europe/Rome',48.75,1,'work','2022-03-16 17:58:36','2022-02-24'),
(1723,1,1,26,'2022-02-24 16:41:00','2022-02-24 17:27:00',2760,'problemi outlook',34.5,NULL,45,1,'Europe/Rome',34.5,1,'work','2022-03-17 16:14:28','2022-02-24'),
(1724,1,1,26,'2022-02-25 16:09:00','2022-02-25 17:26:00',4620,'problemi outlook',57.75,NULL,45,1,'Europe/Rome',57.75,1,'work','2022-03-17 16:14:29','2022-02-25'),
(1725,1,1,67,'2022-02-25 07:50:00','2022-02-25 09:28:00',5880,'verifixa backup reimportato',73.5,NULL,45,1,'Europe/Rome',73.5,1,'work','2022-03-07 20:54:34','2022-02-25'),
(1726,1,1,1,'2022-02-25 09:43:00','2022-02-25 11:27:00',6240,'agg centralino',78,NULL,45,1,'Europe/Rome',78,1,'work','2022-05-06 09:16:59','2022-02-25'),
(1727,1,1,114,'2022-02-28 08:18:00','2022-02-28 08:49:00',1860,'problema su inkfire2',23.25,NULL,45,1,'Europe/Rome',23.25,1,'work','2022-04-01 08:30:01','2022-02-28'),
(1728,1,1,114,'2022-02-28 10:00:00','2022-02-28 12:00:00',7200,'problema vpn inkout2',90,NULL,45,1,'Europe/Rome',90,1,'work','2022-04-01 08:30:04','2022-02-28'),
(1729,1,1,3,'2022-02-28 07:48:00','2022-02-28 08:10:00',1320,'fogli',16.5,NULL,45,1,'Europe/Rome',16.5,1,'work','2022-03-17 17:36:10','2022-02-28'),
(1730,1,1,3,'2022-02-28 09:00:00','2022-02-28 10:00:00',3600,'fogli',45,NULL,45,1,'Europe/Rome',45,1,'work','2022-03-17 17:36:02','2022-02-28'),
(1731,1,3,112,'2022-02-28 13:30:00','2022-02-28 14:00:00',1800,NULL,22.5,NULL,45,1,'Europe/Rome',22.5,1,'work','2022-03-01 08:49:09','2022-02-28'),
(1732,1,1,3,'2022-02-28 14:02:00','2022-02-28 14:36:00',2040,'fogli',25.5,NULL,45,1,'Europe/Rome',25.5,1,'work','2022-03-17 17:36:20','2022-02-28'),
(1733,3,2,27,'2022-02-28 15:35:00','2022-02-28 16:35:00',3600,'Assistenza per problemi navigazione causa reset dispositivo wifi Apple',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-17 11:01:44','2022-02-28'),
(1734,1,1,79,'2022-02-28 14:53:00','2022-02-28 16:00:00',4020,'verifica per spostamento vm su proxmox\r\nsistemazione vm perchè lentissima',50.25,NULL,45,1,'Europe/Rome',50.25,1,'work','2022-03-18 09:06:03','2022-02-28'),
(1735,1,4,3,'2022-02-07 13:30:00','2022-02-07 15:49:00',8340,'pc in staby con proxmox backup',104.25,NULL,45,1,'Europe/Rome',104.25,1,'work','2022-03-17 17:36:12','2022-02-07'),
(1736,1,1,26,'2022-02-28 16:18:00','2022-02-28 17:20:00',3720,'problema outlook',46.5,NULL,45,1,'Europe/Rome',46.5,1,'work','2022-03-17 16:14:30','2022-02-28'),
(1737,1,1,101,'2022-03-01 14:00:00','2022-03-01 15:20:00',4800,'verifica spam mail',60,NULL,45,1,'Europe/Rome',60,1,'work','2022-03-17 16:52:17','2022-03-01'),
(1738,1,4,3,'2022-03-01 15:41:00','2022-03-01 17:29:00',6480,'agg wiki guide',81,NULL,45,1,'Europe/Rome',81,1,'work','2022-04-01 09:05:10','2022-03-01'),
(1739,3,2,26,'2022-03-01 16:20:00','2022-03-01 16:50:00',1800,'Assistenza su stampante HP per stampa sporca, fare offerta per nuova stampante multifunzione',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-04-01 08:21:24','2022-03-01'),
(1740,3,2,96,'2022-03-01 17:10:00','2022-03-01 17:30:00',1200,'Assistenza su PC client Antonella\r\nAssistenza su stampante Brother Federica',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-04-01 16:13:29','2022-03-01'),
(1741,3,2,50,'2022-03-01 17:50:00','2022-03-01 18:05:00',900,'Consegnato cavo vga + adattatore vga / hdmi per Francesco, assistenza su portatile Loretta',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-07 13:57:23','2022-03-01'),
(1742,3,1,4,'2022-02-28 10:05:00','2022-02-28 10:35:00',1800,'Assistenza su pc client Arianna per problemi con Outlook',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-17 17:35:26','2022-02-28'),
(1743,3,2,104,'2022-02-28 10:45:00','2022-02-28 11:30:00',2700,'Assistenza su stampante Brother che stropiccia i fogli, da offrire nuova stampante laser monocromatica per grossa quantità di stampe',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-23 11:02:28','2022-02-28'),
(1744,3,1,55,'2022-03-01 09:00:00','2022-03-01 09:20:00',1200,'Assistenza su portatile casa Laura per problemi di stampa in remoto su DSC',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-16 10:38:04','2022-03-01'),
(1745,3,1,83,'2022-03-01 09:55:00','2022-03-01 10:05:00',600,'Assistenza su pc client Roberta',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-18 11:13:19','2022-03-01'),
(1746,3,1,55,'2022-03-01 10:15:00','2022-03-01 10:30:00',900,'Installate 2 licenze nod32 aggiornamento su 4 pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-16 10:38:05','2022-03-01'),
(1747,3,1,96,'2022-03-02 08:00:00','2022-03-02 08:10:00',600,'Assistenza su pc client Maria',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-04-01 16:13:30','2022-03-02'),
(1748,3,1,111,'2022-03-02 09:55:00','2022-03-02 10:15:00',1200,'Configurata mail su portatile provvisorio',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-15 19:21:16','2022-03-02'),
(1749,3,1,41,'2022-03-02 13:55:00','2022-03-02 14:40:00',2700,'Assistenza per visualizzazione video telecamera salvati su NAS',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-06 09:13:55','2022-03-02'),
(1750,3,2,50,'2022-03-03 09:05:00','2022-03-03 09:25:00',1200,'Consegna toner/cartucce, assistenza su portatile Loretta',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-07 14:00:29','2022-03-03'),
(1751,3,2,114,'2022-03-03 09:50:00','2022-03-03 10:15:00',1500,'Installato loro ups sul firewall',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-04-01 09:58:01','2022-03-03'),
(1752,3,2,96,'2022-03-03 14:15:00','2022-03-03 14:40:00',1500,'Consegna toner originale per stampante Brother\r\nVerifica problema su server Gandolfo2',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-04-01 15:44:39','2022-03-03'),
(1753,3,2,17,'2022-03-03 14:55:00','2022-03-03 15:25:00',1800,'Verificato e ritirato ups apc 1400',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-14 07:12:01','2022-03-03'),
(1754,1,1,1,'2022-03-03 15:52:00','2022-03-03 17:25:00',5580,'problemi navigazione internet succursale\r\nagg centralino',69.75,NULL,45,1,'Europe/Rome',69.75,1,'work','2022-05-06 09:46:08','2022-03-03'),
(1755,1,1,51,'2022-03-04 14:04:00','2022-03-04 14:51:01',2821,'problemi outlook burdese',35.26,NULL,45,1,'Europe/Rome',35.26,1,'work','2022-03-07 14:40:02','2022-03-04'),
(1756,3,2,17,'2022-03-04 14:35:00','2022-03-04 14:55:00',1200,'Consegnato e  installato ups apc 1400 sul server',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-14 07:12:01','2022-03-04'),
(1757,1,1,79,'2022-03-04 15:04:00','2022-03-04 17:25:11',8471,'problemi pc elena spazio su disco',105.89,NULL,45,1,'Europe/Rome',105.89,1,'work','2022-04-05 15:01:09','2022-03-04'),
(1758,3,2,50,'2022-03-04 15:05:00','2022-03-04 15:15:00',600,'Consegna toner Xerox',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-07 14:21:46','2022-03-04'),
(1759,3,2,101,'2022-03-04 17:55:00','2022-03-04 18:35:00',2400,'Assistenza per problemi versione kernel su server, aggiornamento bios mb',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-17 16:48:44','2022-03-04'),
(1760,3,1,22,'2022-03-04 08:00:00','2022-03-04 08:30:00',1800,'Assistenza su PC casa padre',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-09 13:28:01','2022-03-04'),
(1761,1,1,67,'2022-03-07 07:39:00','2022-03-07 09:14:00',5700,'problema posta dopo aggiornamento server',71.25,NULL,45,1,'Europe/Rome',71.25,1,'work','2022-03-07 21:38:34','2022-03-07'),
(1762,3,2,79,'2022-03-07 11:00:00','2022-03-07 11:30:00',1800,'Montati 2 ssd Intel 960gb su Server, utilizzati 2 adattatori ssd per cassetti server, assistenza su cell Valentina',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-18 09:05:53','2022-03-07'),
(1763,3,2,26,'2022-03-07 14:10:00','2022-03-07 15:40:00',5400,'Assistenza su PC fisso, su portatile e cellulare  Simona',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-04-01 08:21:25','2022-03-07'),
(1764,3,2,67,'2022-03-07 15:55:00','2022-03-07 16:15:00',1200,'Verificato collegamento ups apc al server, utilizzato cavo usb da 3mt',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-07 21:42:43','2022-03-07'),
(1765,3,2,95,'2022-03-07 16:45:00','2022-03-07 17:00:00',900,'Montati 2 ssd Intel 960gb su Server, utilizzati 2 adattatori ssd per cassetti server',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-18 15:31:53','2022-03-07'),
(1766,3,2,79,'2022-03-07 18:10:00','2022-03-07 19:00:00',3000,'Verifica collegamento nuovi ssd Intel sul server',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-17 17:41:19','2022-03-07'),
(1767,3,1,10,'2022-03-07 17:10:00','2022-03-07 17:40:00',1800,'Installare 2 licenze Norton Antivirus Plus su 2 PC casa Carmen (paga lei privatamente)',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-09 13:29:20','2022-03-07'),
(1768,3,4,111,'2022-03-08 09:00:00','2022-03-08 10:00:00',3600,'Assistenza su pc client per agg software e hardware, utilizzato ssd 480gb S3+ e 2 banchi da 4gb dd3 ram',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-15 19:21:17','2022-03-08'),
(1769,3,2,104,'2022-03-08 11:15:00','2022-03-08 11:35:00',1200,'Assistenza su stampante Brother, utilizzata una risma di carta\r\nRiconsegnato portatile agente dopo sostituzione batteria',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-23 11:02:29','2022-03-08'),
(1770,1,1,114,'2022-03-09 08:44:00','2022-03-09 11:00:00',8160,'poroblemi col wifi',102,NULL,45,1,'Europe/Rome',102,1,'work','2022-04-01 08:30:13','2022-03-09'),
(1771,1,1,3,'2022-03-09 07:36:00','2022-03-09 08:40:00',3840,'test proxmox lxc',48,NULL,45,1,'Europe/Rome',48,1,'work','2022-03-17 17:36:01','2022-03-09'),
(1772,3,2,111,'2022-03-09 09:15:00','2022-03-09 10:15:00',3600,'Riconsegna e configurazione PC client dopo aggiornamento hw e reinstallazione sistema operativo',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-15 19:21:18','2022-03-09'),
(1773,3,1,50,'2022-03-09 14:35:00','2022-03-09 15:00:00',1500,'Assistenza su pc client Loretta per problemi posta',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-16 08:14:23','2022-03-09'),
(1774,3,1,96,'2022-03-09 15:15:00','2022-03-09 15:30:00',900,'Assistenza su pc client Federica',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-04-01 16:13:31','2022-03-09'),
(1775,3,1,79,'2022-03-09 16:30:00','2022-03-09 17:05:00',2100,'Assistenza su mac casa Matteo Parodi per configurazione vpn',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-04-05 15:01:12','2022-03-09'),
(1776,3,2,96,'2022-03-10 09:20:00','2022-03-10 11:30:00',7800,'Consegna e configurazione PC client usato per nuova dipendente, assistenza per backup iphone Gandolfo\r\nUtilizzato: 1 cavo LAN da 1mt, 1 cavo alim,tastiera usb e mouse usb, monitor Philips',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-04-01 16:13:32','2022-03-10'),
(1777,1,1,3,'2022-03-09 11:00:00','2022-03-09 11:30:00',1800,'proxmox container importazione da lxc debian',22.5,NULL,45,1,'Europe/Rome',22.5,1,'work','2022-03-17 17:36:00','2022-03-09'),
(1778,1,1,3,'2022-03-09 13:47:00','2022-03-09 15:13:00',5160,'proxmox container importazione da lxc debian',64.5,NULL,45,1,'Europe/Rome',64.5,1,'work','2022-03-17 17:36:13','2022-03-09'),
(1779,1,1,26,'2022-03-09 15:19:00','2022-03-09 17:30:00',7860,'outlook problema indicizzazione mail',98.25,NULL,45,1,'Europe/Rome',98.25,1,'work','2022-04-01 08:21:26','2022-03-09'),
(1780,1,1,26,'2022-03-10 07:40:00','2022-03-10 09:00:00',4800,'outlook problema indicizzazione mail',60,NULL,45,1,'Europe/Rome',60,1,'work','2022-04-01 08:21:27','2022-03-10'),
(1781,1,1,3,'2022-03-10 09:03:00','2022-03-10 12:29:00',12360,'proxmox container importazione da lxc debian',154.5,NULL,45,1,'Europe/Rome',154.5,1,'work','2022-03-17 17:36:09','2022-03-10'),
(1782,3,2,111,'2022-03-10 12:25:00','2022-03-10 13:00:00',2100,'Assistenza su PC client per problema avvio sistema operativo',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-15 19:21:20','2022-03-10'),
(1783,1,1,55,'2022-03-10 15:08:00','2022-03-10 15:23:00',900,'coedit nuovo db anno 2022',11.25,NULL,45,1,'Europe/Rome',11.25,1,'work','2022-05-09 15:40:36','2022-03-10'),
(1784,3,2,26,'2022-03-10 14:50:00','2022-03-10 16:20:00',5400,'Consegna, installazione e configurazione nuova stampante Brother',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-04-01 08:21:28','2022-03-10'),
(1785,1,1,79,'2022-03-10 15:26:00','2022-03-10 16:00:00',2040,'problemi backuppc dopo agg alex',25.5,NULL,45,1,'Europe/Rome',25.5,1,'work','2022-03-17 17:40:48','2022-03-10'),
(1786,1,1,79,'2022-03-08 20:30:00','2022-03-08 22:10:00',6000,'spostamento vm tentativo di agg proxmox problemi con lxc',75,NULL,45,1,'Europe/Rome',75,1,'work','2022-03-17 17:41:09','2022-03-08'),
(1787,1,6,96,'2022-03-10 16:37:00','2022-03-10 16:43:00',360,'problemi antonella',4.5,NULL,45,1,'Europe/Rome',4.5,1,'work','2022-04-01 16:13:33','2022-03-10'),
(1788,3,1,79,'2022-03-10 07:55:00','2022-03-10 08:10:00',900,'Assistenza su mac Matteo Parodi',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-04-05 15:01:14','2022-03-10'),
(1789,1,4,3,'2022-03-11 07:47:00','2022-03-11 08:20:00',1980,'assemblaggio centralino piazza',24.75,NULL,45,1,'Europe/Rome',24.75,1,'work','2022-03-17 17:36:16','2022-03-11'),
(1790,1,1,3,'2022-03-11 16:14:00','2022-03-11 17:28:00',4440,'problemi pc per centralino non parte, compatibilità ram',55.5,NULL,45,1,'Europe/Rome',55.5,1,'work','2022-03-17 17:36:21','2022-03-11'),
(1791,3,1,104,'2022-03-11 10:30:00','2022-03-11 10:45:00',900,'Assistenza su pc client Milena',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-23 11:02:30','2022-03-11'),
(1792,3,1,22,'2022-03-11 13:45:00','2022-03-11 14:00:00',900,'Assistenza su pc casa Boccaleri padre',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-09 13:28:03','2022-03-11'),
(1793,3,2,32,'2022-03-14 08:55:00','2022-03-14 09:30:00',2100,'Assistenza su server per problemi con Areca, sostituzione disco di sistema con disco da 2 tb Seagate',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-16 09:19:46','2022-03-14'),
(1794,3,2,114,'2022-03-14 10:00:00','2022-03-14 11:30:00',5400,'Assistenza per problemi navigazione con Unifi, installato switch 8 porte 439390',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-04-01 09:58:02','2022-03-14'),
(1795,1,1,95,'2022-03-14 15:42:00','2022-03-14 16:00:00',1080,'problemi libreoffice pc cucina',13.5,NULL,45,1,'Europe/Rome',13.5,1,'work','2022-09-07 13:18:07','2022-03-14'),
(1796,1,4,3,'2022-03-14 13:30:00','2022-03-14 13:55:00',1500,'riportata mb',18.75,NULL,45,1,'Europe/Rome',18.75,1,'work','2022-03-17 17:36:14','2022-03-14'),
(1797,1,1,83,'2022-03-14 14:17:00','2022-03-14 15:34:00',4620,'config bakcuppc su nas',57.75,NULL,45,1,'Europe/Rome',57.75,1,'work','2022-03-18 11:05:50','2022-03-14'),
(1798,1,1,114,'2022-03-14 10:24:00','2022-03-14 11:30:00',3960,'fede li problemi wifi',49.5,NULL,45,1,'Europe/Rome',49.5,1,'work','2022-04-01 08:30:23','2022-03-14'),
(1799,1,1,88,'2022-03-14 07:49:00','2022-03-14 08:58:00',4140,'installazione 3cx e debian su nuovo centralino',51.75,NULL,45,1,'Europe/Rome',51.75,1,'work','2022-03-15 20:25:24','2022-03-14'),
(1800,3,2,12,'2022-03-14 15:30:00','2022-03-14 17:30:00',7200,'Verificato e ritirato pc client Windows XP a cui è collegato il plotter',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-18 14:12:32','2022-03-14'),
(1801,1,1,79,'2022-03-14 16:06:00','2022-03-14 18:00:00',6840,'mirgazioen su proxmox, andato li dopo casini con interfacce di rete a riavviare',85.5,NULL,45,1,'Europe/Rome',85.5,1,'work','2022-03-17 17:41:02','2022-03-14'),
(1802,1,1,79,'2022-03-14 21:00:00','2022-03-15 01:43:00',16980,'migrazione proxmox',212.25,NULL,45,1,'Europe/Rome',212.25,1,'work','2022-03-18 09:02:49','2022-03-14'),
(1803,1,1,79,'2022-03-15 07:44:00','2022-03-15 08:12:00',1680,'configurazione backup su proxmox',21,NULL,45,1,'Europe/Rome',21,1,'work','2022-03-18 09:02:53','2022-03-15'),
(1804,1,1,3,'2022-03-15 08:20:00','2022-03-15 08:30:00',600,'sistemato unifi lab',7.5,NULL,45,1,'Europe/Rome',7.5,1,'work','2022-03-17 17:36:17','2022-03-15'),
(1805,1,3,112,'2022-03-15 08:32:00','2022-03-15 10:38:27',7587,NULL,94.84,NULL,45,1,'Europe/Rome',94.84,1,'work','2022-03-16 08:14:12','2022-03-15'),
(1806,1,1,79,'2022-03-15 10:44:00','2022-03-15 12:00:00',4560,'problemi posta, segnalati in mail in uscita e problemi in entrata su paolo.lavagetto',57,NULL,45,1,'Europe/Rome',57,1,'work','2022-04-05 15:01:16','2022-03-15'),
(1807,1,1,79,'2022-03-15 13:20:00','2022-03-15 14:00:00',2400,'problemi posta, segnalati in mail in uscita e problemi in entrata su paolo.lavagetto\r\ntrovato inoltro configurato su aruba per l\'account di lavagetto che creava il problema\r\nresettate password',30,NULL,45,1,'Europe/Rome',30,1,'work','2022-04-05 15:01:18','2022-03-15'),
(1808,3,2,83,'2022-03-15 15:30:00','2022-03-15 17:30:00',7200,'Consegna e installazione nuovo NAS QNAP di backup\r\nConsegna e installazione nuovo UPS APC 500\r\nAssistenza su Iphone Ennio, chiamato Irideos per portare forwarding',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-18 10:45:31','2022-03-15'),
(1809,1,1,83,'2022-03-15 16:04:00','2022-03-15 17:00:00',3360,'fede li ha installato nuovo nas, problemi su vecchio nas irraggiungibile da remoto.',42,NULL,45,1,'Europe/Rome',42,1,'work','2022-03-18 10:45:33','2022-03-15'),
(1810,1,1,79,'2022-03-15 17:04:00','2022-03-15 17:20:00',960,'problemi su mail support inoltro su llglobal2016@gmail.com non configurato da loro',12,NULL,45,1,'Europe/Rome',12,1,'work','2022-04-05 15:01:19','2022-03-15'),
(1811,1,1,79,'2022-03-15 14:10:00','2022-03-15 15:44:00',5640,'configurazione backup proxmox, problemi su backup container mail per spazio disco',70.5,NULL,45,1,'Europe/Rome',70.5,1,'work','2022-03-18 09:03:46','2022-03-15'),
(1812,3,4,12,'2022-03-15 08:00:00','2022-03-15 09:00:00',3600,'Installata e configurata VM con Windows XP su portatile ASUS per utilizzo plotter',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-18 14:12:34','2022-03-15'),
(1813,3,1,96,'2022-03-15 09:00:00','2022-03-15 09:15:00',900,'Assistenza su pc client Anna per problemi posta elettronica',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-04-01 16:13:34','2022-03-15'),
(1814,3,1,22,'2022-03-15 09:20:00','2022-03-15 09:30:00',600,'Assistenza su pc casa Boccaleri padre',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-09 13:28:04','2022-03-15'),
(1815,3,1,32,'2022-03-15 09:45:00','2022-03-15 10:00:00',900,'Assistenza su pc client Daniela per problema collegamento da remoto',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-16 09:19:47','2022-03-15'),
(1816,3,1,5,'2022-03-15 10:05:00','2022-03-15 10:20:00',900,'Assistenza per problemi navigazione su pc client, da finire di verificare',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-12 15:03:21','2022-03-15'),
(1817,3,1,79,'2022-03-15 10:55:00','2022-03-15 11:30:00',2100,'Assistenza per problemi posta elettronica Aruba',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-04-05 15:01:17','2022-03-15'),
(1818,1,1,114,'2022-03-16 07:46:00','2022-03-16 08:40:00',3240,'problemi in sede mancanza di connettività lan',40.5,NULL,45,1,'Europe/Rome',40.5,1,'work','2022-04-01 08:32:40','2022-03-16'),
(1819,1,1,79,'2022-03-16 08:45:00','2022-03-16 09:33:00',2880,'problemi posta paolo e elena, fatto caos con password cambiata',36,NULL,45,1,'Europe/Rome',36,1,'work','2022-04-05 15:01:22','2022-03-16'),
(1820,3,2,114,'2022-03-16 09:30:00','2022-03-16 10:30:00',3600,'Consegna e installazione nuovo switch 16 porte (43668), riordinato zona server e verificato corretto funzionamento',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-04-01 09:58:03','2022-03-16'),
(1821,1,1,90,'2022-03-16 09:55:00','2022-03-16 10:28:00',1980,'problema autocad 2013 su pc manuela',24.75,NULL,45,1,'Europe/Rome',24.75,1,'work','2022-05-10 09:28:43','2022-03-16'),
(1822,3,2,88,'2022-03-16 10:50:00','2022-03-16 11:50:00',3600,'Consegnato e configurato nuovo centralino 3cx',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-06 09:51:39','2022-03-16'),
(1823,1,1,90,'2022-03-16 11:05:00','2022-03-16 11:30:00',1500,'problema autocad 2013 su pc manuela',18.75,NULL,45,1,'Europe/Rome',18.75,1,'work','2022-05-10 09:28:44','2022-03-16'),
(1824,1,1,88,'2022-03-16 11:30:00','2022-03-16 12:16:00',2760,'nuovo centralino',34.5,NULL,45,1,'Europe/Rome',34.5,1,'work','2022-05-06 09:51:43','2022-03-16'),
(1825,3,2,12,'2022-03-16 12:00:00','2022-03-16 14:00:00',7200,'Riconsegna e configurazione portatile Asus per fare da server di posta per il plotter',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-18 14:12:35','2022-03-16'),
(1826,3,2,83,'2022-03-16 14:40:00','2022-03-16 15:00:00',1200,'Sostituzione switch armadio rack con nostro switch provvisorio',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-18 11:13:21','2022-03-16'),
(1827,1,2,83,'2022-03-16 13:40:00','2022-03-16 15:10:00',5400,'problemi di connessione interna switch saltato\r\n\r\n1 switch usato temporaneo',67.5,NULL,45,1,'Europe/Rome',67.5,1,'work','2022-03-18 11:13:20','2022-03-16'),
(1828,1,1,83,'2022-03-16 15:25:00','2022-03-16 16:16:26',3086,'config backup su nuovo nas e ricerca switch managed',38.58,NULL,45,1,'Europe/Rome',38.58,1,'work','2022-03-18 10:44:17','2022-03-16'),
(1829,1,1,90,'2022-03-16 16:33:00','2022-03-16 17:30:00',3420,'installazione autocad 2022 su pc manuela',42.75,NULL,45,1,'Europe/Rome',42.75,1,'work','2022-05-10 09:28:45','2022-03-16'),
(1830,1,1,114,'2022-03-16 10:34:00','2022-03-16 11:00:00',1560,'verifica risoluzione problemi',19.5,NULL,45,1,'Europe/Rome',19.5,1,'work','2022-04-01 08:32:26','2022-03-16'),
(1831,3,2,83,'2022-03-16 16:40:00','2022-03-16 17:00:00',1200,'Risolto problema collegamento stampante ad aghi',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-03-18 10:44:18','2022-03-16'),
(1832,3,1,79,'2022-03-16 07:50:00','2022-03-16 08:10:00',1200,'Assistenza su pc client Paola e Paolo per problemi posta elettronica',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-04-05 15:01:21','2022-03-16'),
(1833,3,1,24,'2022-03-16 15:25:00','2022-03-16 16:05:00',2400,'Assistenza su pc client Monica',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-04-26 13:22:25','2022-03-16'),
(1834,1,1,90,'2022-03-17 07:46:00','2022-03-17 07:55:00',540,'installazione autocad 2022 su pc manuela',6.75,NULL,45,1,'Europe/Rome',6.75,1,'work','2022-05-10 09:28:46','2022-03-17'),
(1835,1,1,26,'2022-03-17 13:45:00','2022-03-17 15:13:00',5280,'pc banci indicizzazione mail e controlli vari',66,NULL,45,1,'Europe/Rome',66,1,'work','2022-04-01 08:21:30','2022-03-17'),
(1836,1,1,2,'2022-03-17 08:10:00','2022-03-17 09:40:00',5400,'per config telecamere su cel',67.5,NULL,45,1,'Europe/Rome',67.5,1,'work','2022-07-08 10:16:47','2022-03-17'),
(1837,1,1,55,'2022-03-17 10:05:00','2022-03-17 11:26:00',4860,'server mail agg',60.75,NULL,45,1,'Europe/Rome',60.75,1,'work','2022-05-09 15:55:48','2022-03-17'),
(1838,1,6,5,'2022-03-17 15:25:00','2022-03-17 15:35:00',600,'per analisi file di taglio',7.5,NULL,45,1,'Europe/Rome',7.5,1,'work','2022-03-18 13:51:49','2022-03-17'),
(1839,3,1,75,'2022-03-17 08:20:00','2022-03-17 08:30:00',600,'Assistenza su pc client Federico',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-04-05 14:01:29','2022-03-17'),
(1840,3,1,10,'2022-03-17 15:30:00','2022-03-17 15:45:00',900,'Installato antivirus Norton su pc casa sorella Carmen',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-09 13:29:24','2022-03-17'),
(1841,3,1,5,'2022-03-17 15:50:00','2022-03-17 16:10:00',1200,'Assistenza su pc client Alessandra per problemi navigazione',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-12 15:03:22','2022-03-17'),
(1842,1,1,114,'2022-03-18 13:53:00','2022-03-18 14:25:27',1947,'analisi problemi wifi sede via xx',24.34,NULL,45,1,'Europe/Rome',24.34,1,'work','2022-04-01 08:32:23','2022-03-18'),
(1843,1,1,55,'2022-03-18 07:50:00','2022-03-18 09:39:00',6540,'aggiornamento server e  vm',81.75,NULL,45,1,'Europe/Rome',81.75,1,'work','2022-05-09 15:55:49','2022-03-18'),
(1844,1,1,2,'2022-03-18 14:31:00','2022-03-18 16:37:00',7560,'configurazione ex pc nicolò per uso francesca',94.5,NULL,45,1,'Europe/Rome',94.5,1,'work','2022-07-08 10:16:55','2022-03-18'),
(1845,3,2,22,'2022-03-18 13:30:00','2022-03-18 16:05:00',9300,'Assistenza su PC client Stefano per aggiornamento sistema operativo a Windows 11\r\nAssistenza su pc client per problemi vari',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-09 13:28:05','2022-03-18'),
(1846,3,1,75,'2022-03-18 08:50:00','2022-03-18 09:05:00',900,'Assistenza su pc client Federico',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-04-05 14:01:30','2022-03-18'),
(1847,3,1,96,'2022-03-18 11:00:00','2022-03-18 11:15:00',900,'Assistenza su pc client Antonella',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-04-01 16:13:36','2022-03-18'),
(1848,3,1,101,'2022-03-18 16:20:00','2022-03-18 16:40:00',1200,'Assistenza su pc client per probabile virus, da finire in loco',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-10 09:40:09','2022-03-18'),
(1849,3,1,100,'2022-03-18 16:45:00','2022-03-18 17:15:00',1800,'Assistenza per problemi posta inviata in spam e creazione cestino su server',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-04 15:24:22','2022-03-18'),
(1850,1,1,100,'2022-03-18 16:40:00','2022-03-18 17:12:00',1920,'configurazione cestino di rete samba',24,NULL,45,1,'Europe/Rome',24,1,'work','2022-05-04 15:24:21','2022-03-18'),
(1851,1,1,2,'2022-03-18 17:13:00','2022-03-18 17:25:00',720,'configurazione ex pc nicolò per uso francesca',9,NULL,45,1,'Europe/Rome',9,1,'work','2022-07-08 10:18:13','2022-03-18'),
(1852,3,2,41,'2022-03-21 11:15:00','2022-03-21 12:00:00',2700,'Consegna e installazione stampante termica\r\nConsegna stampante termica per LTS\r\nRitirato ups da verificare',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-06 09:14:00','2022-03-21'),
(1853,3,2,101,'2022-03-21 13:30:00','2022-03-21 15:15:00',6300,'Verificati e ripuliti virus su 3 PC client',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-10 09:40:09','2022-03-21'),
(1854,1,1,100,'2022-03-21 15:54:00','2022-03-21 16:20:00',1560,'problemi cestino di rete su file esistenti',19.5,NULL,45,1,'Europe/Rome',19.5,1,'work','2022-05-04 15:24:24','2022-03-21'),
(1855,1,1,29,'2022-03-21 16:24:00','2022-03-21 17:44:00',4800,'backup remoto affinamento script',60,NULL,45,1,'Europe/Rome',60,1,'work','2022-04-20 16:03:11','2022-03-21'),
(1856,3,2,100,'2022-03-21 15:45:00','2022-03-21 17:00:00',4500,'Assistenza per problemi posta che finisce in spam, verificato funzionamento Cestino sul server (da finire di verificare). Problema sincronizzazione Calendario Iphone (da finire di verificare)',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-04 15:24:23','2022-03-21'),
(1857,3,1,43,'2022-03-21 09:30:00','2022-03-21 09:40:00',600,'Assistenza su pc client Romina',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-03 08:34:49','2022-03-21'),
(1858,3,1,26,'2022-03-21 18:30:00','2022-03-21 18:40:00',600,'Avviata scansione antivirus su pc client Banci',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-04-01 08:21:31','2022-03-21'),
(1859,1,1,29,'2022-03-22 10:47:00','2022-03-22 11:40:00',3180,'problema stampa da xdent',39.75,NULL,45,1,'Europe/Rome',39.75,1,'work','2022-05-04 14:38:46','2022-03-22'),
(1860,1,2,2,'2022-03-22 07:40:00','2022-03-22 09:00:00',4800,'spostamento pc francesca e configurazione telecamere iphone cevasco',60,NULL,45,1,'Europe/Rome',60,1,'work','2022-07-08 10:16:57','2022-03-22'),
(1861,1,1,29,'2022-03-22 14:28:00','2022-03-22 14:44:00',960,'problema rete saltata',12,NULL,45,1,'Europe/Rome',12,1,'work','2022-05-04 14:38:47','2022-03-22'),
(1862,1,1,3,'2022-03-22 13:43:00','2022-03-22 14:13:00',1800,'zfs disk mail',22.5,NULL,45,1,'Europe/Rome',22.5,1,'work','2022-05-04 13:42:47','2022-03-22'),
(1863,1,1,3,'2022-03-22 14:53:00','2022-03-22 17:28:00',9300,'zfs disk mail\r\nscritta guida',116.25,NULL,45,1,'Europe/Rome',116.25,1,'work','2022-05-04 13:42:48','2022-03-22'),
(1864,3,1,22,'2022-03-23 08:45:00','2022-03-23 09:30:00',2700,'Assistenza su pc client Stefano per problemi spazio disco C',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-09 13:28:12','2022-03-23'),
(1865,3,1,1,'2022-03-23 11:00:00','2022-03-23 11:15:00',900,'Assistenza per avvio server Windows dopo che è mancata la corrente',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-06 09:46:10','2022-03-23'),
(1866,3,1,96,'2022-03-23 15:10:00','2022-03-23 15:35:00',1500,'Installata licenza Office 2021 (da fatturare) su ultimo pc client consegnato',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-04-01 16:13:37','2022-03-23'),
(1867,3,2,96,'2022-03-24 10:20:00','2022-03-24 12:00:00',6000,'Assistenza su PC client Anna, da finire remotamente\r\nSpostato e configurato telefono postazione Cristina\r\nAssistenza varia su PC client e telefoni',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-04-01 16:13:38','2022-03-24'),
(1868,1,1,75,'2022-03-24 14:02:00','2022-03-24 14:38:05',2165,'problema mail erika ci ha già lavorato fede',27.06,NULL,45,1,'Europe/Rome',27.06,1,'work','2022-04-05 08:55:26','2022-03-24'),
(1869,1,1,5,'2022-03-24 07:46:00','2022-03-24 08:43:00',3420,'esportazione file xml',42.75,NULL,45,1,'Europe/Rome',42.75,1,'work','2022-05-06 13:42:04','2022-03-24'),
(1870,1,1,2,'2022-03-23 13:50:00','2022-03-23 17:30:00',13200,'Installazione vm windows per lavoro remoto cevasco.\r\nAggiornamenti server, (host da riavviare)',165,NULL,45,1,'Europe/Rome',165,1,'work','2022-07-08 10:16:57','2022-03-23'),
(1871,1,1,50,'2022-03-23 10:01:00','2022-03-23 11:28:00',5220,'verifica problemi virus posta',65.25,NULL,45,1,'Europe/Rome',65.25,1,'work','2022-04-01 12:06:58','2022-03-23'),
(1872,1,1,75,'2022-03-24 09:00:00','2022-03-24 10:08:00',4080,'teantivo trasferimento impostazioni sistema da vecchio nas a nuovo',51,NULL,45,1,'Europe/Rome',51,1,'work','2022-04-05 14:01:31','2022-03-24'),
(1873,1,1,103,'2022-03-23 07:49:00','2022-03-23 09:46:00',7020,'agg server',87.75,NULL,45,1,'Europe/Rome',87.75,1,'work','2022-05-05 09:49:59','2022-03-23'),
(1874,3,1,75,'2022-03-24 08:20:00','2022-03-24 09:20:00',3600,'Assistenza su pc client casa Erica per problemi spazio disco C, spostata cartella Thunderbird su disco D',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-04-05 08:55:22','2022-03-24'),
(1875,3,1,41,'2022-03-24 13:30:00','2022-03-24 13:45:00',900,'Assistenza su pc client Marco per problema utente server bloccato',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-06 09:13:49','2022-03-24'),
(1876,3,1,96,'2022-03-24 14:20:00','2022-03-24 15:20:00',3600,'Assistenza su pc client Anna per problema con software Fedra Plus',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-04-01 16:13:39','2022-03-24'),
(1877,3,2,75,'2022-03-25 08:55:00','2022-03-25 10:25:00',5400,'Consegna e installazione nuovo NAS di backup\r\nConfigurata vpn su PC casa Oneto e Erica\r\nRitirato NAS principale per assistenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-04-05 14:01:32','2022-03-25'),
(1878,3,2,10,'2022-03-25 10:45:00','2022-03-25 10:55:00',600,'Ritirato mac figlia Carmen per assistenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-09 13:29:28','2022-03-25'),
(1879,3,2,83,'2022-03-25 16:35:00','2022-03-25 17:00:00',1500,'Consegna e installazione nuovo switch 24 porte',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-04-12 14:15:24','2022-03-25'),
(1880,1,1,75,'2022-03-28 07:08:00','2022-03-28 07:16:00',480,'nas',6,NULL,45,1,'Europe/Rome',6,1,'work','2022-04-05 13:40:35','2022-03-28'),
(1881,3,2,57,'2022-03-28 06:45:00','2022-03-28 11:45:00',18000,'Assistenza per problemi avvio server dopo aggiornamenti, assistenza su Mac Simona Sivori, agg sistema operativo su Mac Marialla da OS X a OS El Capitan',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-05 13:42:05','2022-03-28'),
(1882,3,1,75,'2022-03-28 13:10:00','2022-03-28 13:40:00',1800,'Assistenza su pc client Stoehr e Gainfranco Figari per problemi collegamento alle cartelle del server',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-04-05 14:01:33','2022-03-28'),
(1883,3,2,41,'2022-03-28 14:50:00','2022-03-28 15:50:00',3600,'Consegnati e installati 2 ups apc 500 + 1 ciabatta ups, assistenza su pc client Fucilli',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-06 09:13:51','2022-03-28'),
(1884,3,1,22,'2022-03-29 07:00:00','2022-03-29 08:00:00',3600,'Assistenza su pc client Boccaleri padre casa per problemi collegamento con vpn, da finire di verificare',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-09 13:28:13','2022-03-29'),
(1885,3,1,51,'2022-03-29 08:35:00','2022-03-29 08:45:00',600,'Assistenza per verifica sostituzione batteria su mac Burdese',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-06 13:41:14','2022-03-29'),
(1886,1,1,75,'2022-03-29 06:48:00','2022-03-29 07:03:00',900,'configurazione vpn pc marisa sacca nuovo nas',11.25,NULL,45,1,'Europe/Rome',11.25,1,'work','2022-04-05 14:01:34','2022-03-29'),
(1887,1,1,3,'2022-03-29 07:05:00','2022-03-29 08:29:00',5040,'problemi kimai',63,NULL,45,1,'Europe/Rome',63,1,'work','2022-05-04 13:43:44','2022-03-29'),
(1888,3,1,41,'2022-03-29 09:20:00','2022-03-29 09:45:00',1500,'Assistenza su pc client Fucilli per problemi stampa da server',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-06-08 13:47:37','2022-03-29'),
(1889,1,1,41,'2022-03-29 08:45:00','2022-03-29 10:28:00',6180,'analisi server ceranesi',77.25,NULL,45,1,'Europe/Rome',77.25,1,'work','2022-06-08 13:47:36','2022-03-29'),
(1890,1,1,41,'2022-03-29 13:00:00','2022-03-29 16:46:00',13560,'verifica share copiati\r\nspostamento backup client su raid dedicato a backup\r\nverifica backup server ceranesi',169.5,NULL,45,1,'Europe/Rome',169.5,1,'work','2022-06-08 13:47:39','2022-03-29'),
(1891,3,2,104,'2022-03-29 09:55:00','2022-03-29 10:15:00',1200,'Assistenza su stampante samsung che stampava un foglio alla volta',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-04 16:14:13','2022-03-29'),
(1892,1,4,3,'2022-03-29 12:30:00','2022-03-29 12:47:00',1020,'verifica mac carmen',12.75,NULL,45,1,'Europe/Rome',12.75,1,'work','2022-05-04 13:43:44','2022-03-29'),
(1893,3,1,96,'2022-03-29 13:50:00','2022-03-29 14:20:00',1800,'Assistenza su pc client Cristina Musso per problemi permissi cartelle server',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-04-01 16:13:39','2022-03-29'),
(1894,3,2,114,'2022-03-30 13:10:00','2022-03-30 13:45:00',2100,'Consegnati e installati 4 banchi di ram da 32gb ddr4\r\nRiavviati firewall 2 sedi dopo agg kernel',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-04-01 09:58:04','2022-03-30'),
(1895,3,2,26,'2022-03-30 14:05:00','2022-03-30 14:45:00',2400,'Consegna toner compatibili per stampante Brother \r\nInstallata 1 licenza nod32 agg su 2 portatili\r\nAssistenza su PC client Sola',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-04-01 08:21:32','2022-03-30'),
(1896,3,2,12,'2022-03-30 14:55:00','2022-03-30 15:10:00',900,'Riconsegna pc xp da smaltire, assistenza su plotter',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-21 07:53:27','2022-03-30'),
(1897,3,1,100,'2022-03-30 06:45:00','2022-03-30 06:55:00',600,'Assistenza per problemi posta elettronica su iphone',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-04 15:24:25','2022-03-30'),
(1898,3,1,114,'2022-03-30 07:35:00','2022-03-30 07:50:00',900,'Assistenza su firewall per problemi navigazione in sede',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-04-01 08:32:18','2022-03-30'),
(1899,3,1,96,'2022-03-30 08:30:00','2022-03-30 09:00:00',1800,'Installata e configurata vpn su pc casa Cristina Musso',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-04-01 16:13:41','2022-03-30'),
(1900,3,1,22,'2022-03-30 09:30:00','2022-03-30 10:00:00',1800,'Assistenza per problemi vpn su pc casa Boccaleri padre',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-09 13:28:12','2022-03-30'),
(1901,3,1,75,'2022-03-30 10:10:00','2022-03-30 10:20:00',600,'Assistenza su portatile casa Gianfranco Figari',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-04-05 14:01:35','2022-03-30'),
(1902,3,2,22,'2022-03-31 08:20:00','2022-03-31 10:00:00',6000,'Assistenza per problemi collegamento vpn dal PC casa Boccaleri padre',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-09 13:28:16','2022-03-31'),
(1903,1,1,3,'2022-03-31 12:46:00','2022-03-31 14:47:00',7260,'backup configurazioni firewall dei nostri clienti',90.75,NULL,45,1,'Europe/Rome',90.75,1,'work','2022-05-10 14:41:29','2022-03-31'),
(1904,1,1,22,'2022-03-31 08:01:00','2022-03-31 09:49:00',6480,'problema vpn e thunderbird peso mail',81,NULL,45,1,'Europe/Rome',81,1,'work','2022-05-09 13:28:17','2022-03-31'),
(1905,1,1,22,'2022-03-30 14:30:00','2022-03-30 16:20:00',6600,'problema vpn',82.5,NULL,45,1,'Europe/Rome',82.5,1,'work','2022-05-09 13:28:15','2022-03-30'),
(1906,1,1,3,'2022-03-01 07:40:00','2022-03-01 08:20:00',2400,'fogli',30,NULL,45,1,'Europe/Rome',30,1,'work','2022-05-04 13:42:10','2022-03-01'),
(1907,1,1,88,'2022-03-01 08:30:00','2022-03-01 09:12:00',2520,'agg centralino disabilitati servizi windows per poca potenza centralino valutare sostituzione',31.5,NULL,45,1,'Europe/Rome',31.5,1,'work','2022-05-06 09:51:31','2022-03-01'),
(1908,1,1,2,'2022-03-01 09:28:00','2022-03-01 10:40:00',4320,'aggiornamenti',54,NULL,45,1,'Europe/Rome',54,1,'work','2022-07-08 10:16:52','2022-03-01'),
(1909,1,1,79,'2022-03-01 10:55:00','2022-03-01 11:28:00',1980,'inizio prep per agg hypervisor',24.75,NULL,45,1,'Europe/Rome',24.75,1,'work','2022-04-05 15:01:10','2022-03-01'),
(1910,1,1,50,'2022-03-02 13:43:00','2022-03-02 17:29:00',13560,'migrazione dischi vm, studio per agg proxmox da 6.4 a 7.2',169.5,NULL,45,1,'Europe/Rome',169.5,1,'work','2022-04-01 12:06:56','2022-03-02'),
(1911,1,1,51,'2022-03-02 07:53:00','2022-03-02 09:12:00',4740,'verifica backup locale e remoto',59.25,NULL,45,1,'Europe/Rome',59.25,1,'work','2022-05-06 13:29:32','2022-03-02'),
(1912,1,1,67,'2022-03-02 09:26:00','2022-03-02 10:50:00',5040,'vm perso disco dati',63,NULL,45,1,'Europe/Rome',63,1,'work','2022-05-06 10:13:43','2022-03-02'),
(1913,1,1,103,'2022-03-02 10:58:00','2022-03-02 11:27:00',1740,'agg server',21.75,NULL,45,1,'Europe/Rome',21.75,1,'work','2022-05-05 09:49:57','2022-03-02'),
(1914,1,1,103,'2022-03-03 09:40:00','2022-03-03 11:24:00',6240,'agg server',78,NULL,45,1,'Europe/Rome',78,1,'work','2022-05-05 09:49:58','2022-03-03'),
(1915,1,1,3,'2022-03-03 07:40:00','2022-03-03 09:28:00',6480,'test zfs debian',81,NULL,45,1,'Europe/Rome',81,1,'work','2022-05-04 13:42:11','2022-03-03'),
(1916,1,1,32,'2022-03-03 13:44:00','2022-03-03 15:36:00',6720,'agg server',84,NULL,45,1,'Europe/Rome',84,1,'work','2022-05-06 13:25:17','2022-03-03'),
(1917,1,1,3,'2022-03-04 07:49:00','2022-03-04 09:00:00',4260,'test zfs',53.25,NULL,45,1,'Europe/Rome',53.25,1,'work','2022-05-04 13:42:12','2022-03-04'),
(1918,1,1,3,'2022-03-04 09:20:00','2022-03-04 11:30:00',7800,'zabbix',97.5,NULL,45,1,'Europe/Rome',97.5,1,'work','2022-05-04 13:42:14','2022-03-04'),
(1919,1,1,3,'2022-03-07 16:50:00','2022-03-07 17:32:00',2520,'problemi ssd installati da fede nutra\r\nconfigurazione ssd installati da fede federlavoro',31.5,NULL,45,1,'Europe/Rome',31.5,1,'work','2022-05-04 13:42:42','2022-03-07'),
(1920,1,1,3,'2022-03-07 09:35:00','2022-03-07 11:32:00',7020,'zfs',87.75,NULL,45,1,'Europe/Rome',87.75,1,'work','2022-05-04 13:42:31','2022-03-07'),
(1921,1,1,1,'2022-03-07 13:47:00','2022-03-07 15:57:00',7800,'agg server mail',97.5,NULL,45,1,'Europe/Rome',97.5,1,'work','2022-05-06 09:46:09','2022-03-07'),
(1922,1,1,6,'2022-03-07 16:08:00','2022-03-07 16:43:00',2100,'agg nas',26.25,NULL,45,1,'Europe/Rome',26.25,1,'work','2022-09-21 09:32:20','2022-03-07'),
(1923,1,1,64,'2022-03-08 07:50:00','2022-03-08 09:00:00',4200,'problemi backup remoto',52.5,NULL,45,1,'Europe/Rome',52.5,1,'work','2022-05-09 14:09:23','2022-03-08'),
(1924,1,1,26,'2022-03-08 09:20:00','2022-03-08 11:24:00',7440,'problemi outlook',93,NULL,45,1,'Europe/Rome',93,1,'work','2022-05-09 14:48:58','2022-03-08'),
(1925,1,1,4,'2022-03-08 13:44:00','2022-03-08 15:13:00',5340,'agg vm',66.75,NULL,45,1,'Europe/Rome',66.75,1,'work','2022-05-04 16:07:57','2022-03-08'),
(1926,1,1,3,'2022-03-08 15:31:00','2022-03-08 17:28:00',7020,'preparazione per agg proxmox',87.75,NULL,45,1,'Europe/Rome',87.75,1,'work','2022-05-04 13:42:44','2022-03-08'),
(1927,1,1,79,'2022-03-10 16:53:00','2022-03-10 17:30:00',2220,'problemi backuppc dopo aggiornamento alex',27.75,NULL,45,1,'Europe/Rome',27.75,1,'work','2022-04-05 15:01:14','2022-03-10'),
(1928,1,1,79,'2022-03-11 08:32:00','2022-03-11 09:10:00',2280,'ancora problemi backuppc dopo agg alex',28.5,NULL,45,1,'Europe/Rome',28.5,1,'work','2022-04-05 15:01:15','2022-03-11'),
(1929,1,1,50,'2022-03-11 09:28:00','2022-03-11 11:30:00',7320,'agg centr e vm',91.5,NULL,45,1,'Europe/Rome',91.5,1,'work','2022-04-01 12:06:57','2022-03-11'),
(1930,1,1,88,'2022-03-11 13:45:00','2022-03-11 15:20:00',5700,'installazione centralino piazza, problemi con ram sostituite con mie',71.25,NULL,45,1,'Europe/Rome',71.25,1,'work','2022-05-06 09:51:35','2022-03-11'),
(1931,1,1,29,'2022-03-11 15:42:00','2022-03-11 16:07:00',1500,'verifica nas aggiornamento',18.75,NULL,45,1,'Europe/Rome',18.75,1,'work','2022-05-04 14:38:44','2022-03-11'),
(1933,1,1,5,'2022-03-17 15:44:00','2022-03-17 17:22:00',5880,'studio estrapolazione dati xml',73.5,NULL,45,1,'Europe/Rome',73.5,1,'work','2022-05-06 13:41:59','2022-03-17'),
(1934,1,3,112,'2022-03-21 07:30:00','2022-03-21 10:40:00',11400,NULL,142.5,NULL,45,1,'Europe/Rome',142.5,1,'work','2022-05-04 10:00:54','2022-03-21'),
(1935,1,1,29,'2022-03-21 10:42:00','2022-03-21 11:28:00',2760,'studio per come effettuare backuo remoto dump xdent',34.5,NULL,45,1,'Europe/Rome',34.5,1,'work','2022-05-04 14:38:45','2022-03-21'),
(1936,1,1,81,'2022-03-21 13:54:00','2022-03-21 15:34:00',6000,'agg server',75,NULL,45,1,'Europe/Rome',75,1,'work','2022-05-10 09:44:32','2022-03-21'),
(1937,1,1,2,'2022-03-22 10:00:00','2022-03-22 10:39:00',2340,'verifica impostazione profili roaming non funzionate',29.25,NULL,45,1,'Europe/Rome',29.25,1,'work','2022-07-08 10:17:02','2022-03-22'),
(1938,1,1,55,'2022-04-01 12:51:00','2022-04-01 13:11:00',1200,'apertura anno contabile 2022 su aquila 15 \r\nda fatturare a coedit',15,NULL,45,1,'Europe/Rome',15,1,'work','2022-05-09 15:40:50','2022-04-01'),
(1939,1,3,112,'2022-04-01 06:30:00','2022-04-01 07:42:00',4320,NULL,54,NULL,45,1,'Europe/Rome',54,1,'work','2022-05-04 10:01:27','2022-04-01'),
(1940,1,1,3,'2022-04-01 07:49:00','2022-04-01 08:15:00',1560,'fogli',19.5,NULL,45,1,'Europe/Rome',19.5,1,'work','2022-05-04 13:43:47','2022-04-01'),
(1941,1,1,2,'2022-04-01 15:01:00','2022-04-01 15:29:00',1680,'problemi nicolò connessione vpn',21,NULL,45,1,'Europe/Rome',21,1,'work','2022-07-08 10:17:03','2022-04-01'),
(1942,3,1,64,'2022-04-01 09:20:00','2022-04-01 09:30:00',600,'Configurata mail info su pc client Gloria',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-09 14:47:58','2022-04-01'),
(1943,3,1,101,'2022-04-01 13:50:00','2022-04-01 14:50:00',3600,'Assistenza su pc casa Ramona Bozzano + installazione e configurazione vpn',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-10 09:40:10','2022-04-01'),
(1944,1,1,79,'2022-04-01 15:31:00','2022-04-01 16:30:00',3540,'Aggiornamento vm a windos 10',44.25,NULL,45,1,'Europe/Rome',44.25,1,'work','2022-04-05 15:01:23','2022-04-01'),
(1945,1,1,3,'2022-04-01 13:31:00','2022-04-01 14:47:00',4560,'disassemblaggio mac carmen andi',57,NULL,45,1,'Europe/Rome',57,1,'work','2022-05-04 13:43:54','2022-04-01'),
(1946,3,2,40,'2022-04-04 07:55:00','2022-04-04 08:15:00',1200,'Consegna e installazione nuovo monitor Samsung\r\nAssistenza su stampante epson + ritiro vecchio monitor per verifiche',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-07 07:13:38','2022-04-04'),
(1947,3,2,75,'2022-04-04 08:30:00','2022-04-04 10:30:00',7200,'Consegna e configurazione nuovo PC client Gianfranco Figari, assistenza su PC client Federico e Stoehr. Riconsegna vecchio PC client Federico per cespite. Verificati vecchi PC client da smaltire',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-04-05 14:01:36','2022-04-04'),
(1948,1,1,100,'2022-04-04 12:46:00','2022-04-04 14:04:00',4680,'problema cestino di rete',58.5,NULL,45,1,'Europe/Rome',58.5,1,'work','2022-05-04 15:24:27','2022-04-04'),
(1949,1,1,3,'2022-04-04 07:03:00','2022-04-04 08:03:00',3600,'mac carmen andi\r\nrimontaggio e reinstallazione ripristino backup\r\n1 ssd 1 tb\r\n2 ram ddr3 8 gb crucial',45,NULL,45,1,'Europe/Rome',45,1,'work','2022-05-04 13:44:06','2022-04-04'),
(1950,1,1,3,'2022-04-04 14:16:00','2022-04-04 16:27:00',7860,'ripristinvo vm egroupware per mancanza pagina su wiki\r\nagg wiki',98.25,NULL,45,1,'Europe/Rome',98.25,1,'work','2022-05-04 13:44:10','2022-04-04'),
(1951,3,2,96,'2022-04-04 16:30:00','2022-04-04 17:30:00',3600,'Copia disco PC client Antonella',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-03 15:52:27','2022-04-04'),
(1952,1,1,3,'2022-03-18 10:00:00','2022-03-18 11:31:00',5460,'zfs avvisi segnalazione disco',68.25,NULL,45,1,'Europe/Rome',68.25,1,'work','2022-05-04 13:42:46','2022-03-18'),
(1953,1,1,3,'2022-03-24 10:22:00','2022-03-24 11:28:00',3960,'backup remoti',49.5,NULL,45,1,'Europe/Rome',49.5,1,'work','2022-05-04 13:42:49','2022-03-24'),
(1954,1,1,29,'2022-03-24 14:41:00','2022-03-24 16:00:00',4740,'affinamento script backup, tentativo di contatto xdent per licenza nuovo server',59.25,NULL,45,1,'Europe/Rome',59.25,1,'work','2022-04-20 16:03:38','2022-03-24'),
(1955,1,1,3,'2022-03-24 16:13:00','2022-03-24 17:30:00',4620,'agg wiki guide',57.75,NULL,45,1,'Europe/Rome',57.75,1,'work','2022-05-04 13:42:50','2022-03-24'),
(1956,1,1,3,'2022-03-25 08:43:00','2022-03-25 09:00:00',1020,'cambio config dns cr-play',12.75,NULL,45,1,'Europe/Rome',12.75,1,'work','2022-05-04 13:42:52','2022-03-25'),
(1957,1,1,3,'2022-03-25 07:43:00','2022-03-25 08:30:00',2820,'certificati vari 3cx',35.25,NULL,45,1,'Europe/Rome',35.25,1,'work','2022-05-04 13:42:50','2022-03-25'),
(1958,1,6,29,'2022-03-25 09:09:00','2022-03-25 09:23:00',840,'teantativo contatto xdent per licenza server',10.5,NULL,45,1,'Europe/Rome',10.5,1,'work','2022-04-20 13:30:04','2022-03-25'),
(1959,1,1,2,'2022-03-25 09:35:00','2022-03-25 11:25:00',6600,'agg server',82.5,NULL,45,1,'Europe/Rome',82.5,1,'work','2022-05-05 08:04:38','2022-03-25'),
(1960,1,1,3,'2022-03-25 13:46:00','2022-03-25 16:50:00',11040,'agg proxmox 6.4 a 7.2 su macchina di prova\r\nTest agg windows server su vm prima di agg quello clienti',138,NULL,45,1,'Europe/Rome',138,1,'work','2022-05-04 13:43:42','2022-03-25'),
(1961,1,1,10,'2022-03-25 17:03:00','2022-03-25 17:30:00',1620,'agg spamassassin e clamv su mail server',20.25,NULL,45,1,'Europe/Rome',20.25,1,'work','2022-05-09 14:08:48','2022-03-25'),
(1962,1,1,57,'2022-03-28 07:26:00','2022-03-28 09:05:00',5940,'agg forzato ipmi per accesso remoto, risoluzione problemi bios',74.25,NULL,45,1,'Europe/Rome',74.25,1,'work','2022-05-05 13:42:06','2022-03-28'),
(1963,1,1,57,'2022-03-27 20:50:00','2022-03-27 21:40:00',3000,'problemi dopo agg kernel server inchiodato tentativi di accesso ipmi',37.5,NULL,45,1,'Europe/Rome',37.5,1,'work','2022-05-05 09:50:30','2022-03-27'),
(1964,1,1,41,'2022-03-28 12:44:00','2022-03-28 13:33:00',2940,'analisi fattura inviata per capiore cosa e se fanno ancora qualcosa vecchi sistemisti',36.75,NULL,45,1,'Europe/Rome',36.75,1,'work','2022-05-06 09:13:50','2022-03-28'),
(1965,1,1,3,'2022-03-28 09:20:00','2022-03-28 10:28:00',4080,'backup remoti',51,NULL,45,1,'Europe/Rome',51,1,'work','2022-05-04 13:43:43','2022-03-28'),
(1966,1,1,1,'2022-03-28 13:48:00','2022-03-28 15:00:00',4320,'agg server e mail server',54,NULL,45,1,'Europe/Rome',54,1,'work','2022-05-06 09:46:11','2022-03-28'),
(1967,1,6,29,'2022-03-28 15:12:00','2022-03-28 15:29:00',1020,'tenativo contatto xdent per licenza server',12.75,NULL,45,1,'Europe/Rome',12.75,1,'work','2022-04-20 13:30:05','2022-03-28'),
(1968,1,1,50,'2022-03-28 15:44:00','2022-03-28 16:27:00',2580,'agg vm qemu guest tools',32.25,NULL,45,1,'Europe/Rome',32.25,1,'work','2022-05-10 09:45:36','2022-03-28'),
(1969,1,1,41,'2022-03-30 06:44:00','2022-03-30 08:00:00',4560,'server ceranesi, contatto loro referente epr segnalazione mancanza lista utenti e uso non adeguato utente administrator',57,NULL,45,1,'Europe/Rome',57,1,'work','2022-06-08 13:47:40','2022-03-30'),
(1970,1,1,5,'2022-03-30 08:13:00','2022-03-30 09:24:00',4260,'agg server',53.25,NULL,45,1,'Europe/Rome',53.25,1,'work','2022-04-05 15:01:47','2022-03-30'),
(1971,1,1,95,'2022-03-30 09:47:00','2022-03-30 10:28:00',2460,'agg server',30.75,NULL,45,1,'Europe/Rome',30.75,1,'work','2022-05-10 08:47:41','2022-03-30'),
(1972,1,1,51,'2022-03-30 12:47:00','2022-03-30 14:13:00',5160,'agg server',64.5,NULL,45,1,'Europe/Rome',64.5,1,'work','2022-05-06 13:41:16','2022-03-30'),
(1973,1,1,3,'2022-03-31 06:45:00','2022-03-31 07:49:00',3840,'backup remoti',48,NULL,45,1,'Europe/Rome',48,1,'work','2022-05-04 13:43:45','2022-03-31'),
(1974,1,6,29,'2022-03-31 10:05:00','2022-03-31 10:16:00',660,'teantivo di contatto xxdent per licenza server',8.25,NULL,45,1,'Europe/Rome',8.25,1,'work','2022-04-20 13:30:06','2022-03-31'),
(1975,1,1,2,'2022-03-31 15:05:00','2022-03-31 16:30:00',5100,'agg nas e sistema backup vm hyperv',63.75,NULL,45,1,'Europe/Rome',63.75,1,'work','2022-07-08 10:18:15','2022-03-31'),
(1976,1,3,112,'2022-03-10 13:30:00','2022-03-10 14:30:00',3600,NULL,45,NULL,45,1,'Europe/Rome',45,1,'work','2022-05-04 10:00:53','2022-03-10'),
(1977,1,1,2,'2022-04-05 08:40:00','2022-04-05 08:44:43',283,'laura vpn casa',3.54,NULL,45,1,'Europe/Rome',3.54,1,'work','2022-07-08 10:16:58','2022-04-05'),
(1978,3,2,5,'2022-04-05 08:10:00','2022-04-05 13:50:00',20400,'Consegna e configurazione 2 nuovi PC cliet Michele e Alessandra, utilizzato 1 adattatore hdmi-vga\r\nRitirato vecchio PC Michele per assistenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-12 15:03:24','2022-04-05'),
(1979,1,1,67,'2022-04-05 15:16:00','2022-04-05 16:29:00',4380,'problema indicizzazione mail massimo serra',54.75,NULL,45,1,'Europe/Rome',54.75,1,'work','2022-05-12 13:52:56','2022-04-05'),
(1980,1,1,96,'2022-04-06 06:47:00','2022-04-06 07:44:00',3420,'ripristino mail antonella su casella temp',42.75,NULL,45,1,'Europe/Rome',42.75,1,'work','2022-05-03 15:52:28','2022-04-06'),
(1981,1,1,3,'2022-04-06 07:45:00','2022-04-06 08:35:30',3030,'taxi per il capo carrozziere',37.88,NULL,45,1,'Europe/Rome',37.88,1,'work','2022-05-04 13:44:13','2022-04-06'),
(1982,1,1,2,'2022-04-06 08:53:00','2022-04-06 10:16:00',4980,'prob excel francesca',62.25,NULL,45,1,'Europe/Rome',62.25,1,'work','2022-07-08 10:16:58','2022-04-06'),
(1983,1,1,95,'2022-04-06 10:19:00','2022-04-06 10:50:00',1860,'migrazione proxmox',23.25,NULL,45,1,'Europe/Rome',23.25,1,'work','2022-05-10 08:46:24','2022-04-06'),
(1984,3,2,88,'2022-04-06 12:55:00','2022-04-06 13:15:00',1200,'Verificato e ritirato telefono snom D710',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-06 09:51:51','2022-04-06'),
(1985,1,1,95,'2022-04-06 12:35:00','2022-04-06 16:26:00',13860,'migrazione proxmox',173.25,NULL,45,1,'Europe/Rome',173.25,1,'work','2022-05-10 08:46:24','2022-04-06'),
(1986,1,1,95,'2022-04-05 20:54:00','2022-04-05 21:42:00',2880,'migrazione proxmox',36,NULL,45,1,'Europe/Rome',36,1,'work','2022-05-10 08:46:23','2022-04-05'),
(1987,3,2,64,'2022-04-07 07:45:00','2022-04-07 08:15:00',1800,'Installazione Office 2021 + assistenza su PC client Mirella, ritirato portatile Valentina',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-09 14:47:59','2022-04-07'),
(1988,3,1,96,'2022-04-06 06:50:00','2022-04-06 07:50:00',3600,'Recuperato vecchio backup posta Antonella e ripristinato su pc client Federica',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-03 15:52:28','2022-04-06'),
(1989,3,1,75,'2022-04-06 07:55:00','2022-04-06 08:10:00',900,'Installato office 2021 su pc client Contabilità',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-10 10:15:57','2022-04-06'),
(1990,3,1,88,'2022-04-06 08:45:00','2022-04-06 09:30:00',2700,'Assistenza su telefono voip Cristina, da verificare in loco',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-06 09:51:50','2022-04-06'),
(1991,3,1,5,'2022-04-06 14:35:00','2022-04-06 14:55:00',1200,'Assistenza su nuovo pc client Alessandra e Michele',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-12 15:03:23','2022-04-06'),
(1992,3,1,5,'2022-04-07 09:00:00','2022-04-07 09:15:00',900,'Assistenza su pc client Alessandra per problema su Ariel',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-12 15:03:28','2022-04-07'),
(1993,3,4,88,'2022-04-07 09:40:00','2022-04-07 10:10:00',1800,'Risolto problema su telefono Snom D710 bloccato',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-06 09:51:52','2022-04-07'),
(1994,3,1,97,'2022-04-07 10:20:00','2022-04-07 10:30:00',600,'Assistenza per recupero password mail',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-11-10 15:09:55','2022-04-07'),
(1995,3,2,75,'2022-04-07 13:55:00','2022-04-07 16:25:00',9000,'Consegnato e configurato nuovo pc client a casa di Federico Figari',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-10 09:51:34','2022-04-07'),
(1996,3,2,88,'2022-04-08 09:55:00','2022-04-08 10:20:00',1500,'Riconsegna e configurazione telefono Snom D710 Cristina',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-06 09:51:54','2022-04-08'),
(1997,3,1,79,'2022-04-08 07:05:00','2022-04-08 07:20:00',900,'Assistenza su posta elettronica Paola Agnoletto',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-10 14:41:01','2022-04-08'),
(1998,3,1,5,'2022-04-08 07:20:00','2022-04-08 07:45:00',1500,'Assistenza su portatile Alessandra per problemi collegamento vpn ad AbVolt',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-12 15:03:25','2022-04-08'),
(1999,3,4,64,'2022-04-08 13:00:00','2022-04-08 14:00:00',3600,'Reinstallazione portatile casa Valentina per problemi collegamento vpn',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-09 14:48:00','2022-04-08'),
(2000,1,1,67,'2022-04-08 12:34:00','2022-04-08 14:45:00',7860,'problemi posta segnalati',98.25,NULL,45,1,'Europe/Rome',98.25,1,'work','2022-05-12 13:52:55','2022-04-08'),
(2001,1,1,2,'2022-04-08 07:10:00','2022-04-08 08:37:00',5220,'agg server',65.25,NULL,45,1,'Europe/Rome',65.25,1,'work','2022-05-05 08:04:38','2022-04-08'),
(2002,1,1,3,'2022-04-08 06:30:00','2022-04-08 06:40:00',600,'ritiro in lab adesivi mac carmen',7.5,NULL,45,1,'Europe/Rome',7.5,1,'work','2022-05-04 13:44:17','2022-04-08'),
(2003,1,1,103,'2022-04-08 08:40:00','2022-04-08 10:25:00',6300,'agg server',78.75,NULL,45,1,'Europe/Rome',78.75,1,'work','2022-05-05 09:50:01','2022-04-08'),
(2004,1,1,5,'2022-04-07 15:01:00','2022-04-07 16:30:00',5340,'agg serrver',66.75,NULL,45,1,'Europe/Rome',66.75,1,'work','2022-05-06 13:42:32','2022-04-07'),
(2005,1,1,96,'2022-04-08 15:00:00','2022-04-08 16:30:00',5400,'recupero dati hd',67.5,NULL,45,1,'Europe/Rome',67.5,1,'work','2022-05-03 15:52:29','2022-04-08'),
(2006,3,1,75,'2022-04-11 06:45:00','2022-04-11 07:00:00',900,'Assistenza su pc client Oneto per problemi ricezione posta',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-10 10:15:58','2022-04-11'),
(2007,3,1,51,'2022-04-11 07:15:00','2022-04-11 07:30:00',900,'Assistenza su mac fisso casa Burdese per configurazione VPN',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-06 13:41:17','2022-04-11'),
(2008,3,1,88,'2022-04-11 07:50:00','2022-04-11 08:30:00',2400,'Assistenza su pc client Maura per problemi accesso alla cartella condivisa sul server',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-06 14:58:36','2022-04-11'),
(2009,3,1,45,'2022-04-11 09:00:00','2022-04-11 09:20:00',1200,'Assistenza su pc client per problemi collegamenti alle cartelle del server',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-14 10:00:47','2022-04-11'),
(2010,3,1,75,'2022-04-11 09:30:00','2022-04-11 09:50:00',1200,'Assistenza per configurazione utenti VPN per Blueteam (Contabilità)',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-10 10:15:59','2022-04-11'),
(2011,3,1,79,'2022-04-11 09:50:00','2022-04-11 10:05:00',900,'Assistenza su pc client Valentina per invio multiplo mail saluti',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-10 14:41:02','2022-04-11'),
(2012,3,2,104,'2022-04-11 10:20:00','2022-04-11 10:35:00',900,'Assistenza su stampante Samsung bloccata',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-04 16:14:14','2022-04-11'),
(2013,3,1,18,'2022-04-11 13:10:00','2022-04-11 13:25:00',900,'Assistenza su pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-07 07:18:34','2022-04-11'),
(2014,3,1,18,'2022-04-11 16:10:00','2022-04-11 16:20:00',600,'Assistenza su pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-07 07:18:35','2022-04-11'),
(2015,3,1,5,'2022-04-11 13:30:00','2022-04-11 13:50:00',1200,'Assistenza su pc client Michele per problemi scansione',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-12 15:03:27','2022-04-11'),
(2016,3,1,50,'2022-04-11 13:50:00','2022-04-11 14:00:00',600,'Assistenza su pc client Loretta per problemi con Chrome',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-10 09:45:46','2022-04-11'),
(2017,3,1,83,'2022-04-11 14:35:00','2022-04-11 14:45:00',600,'Installata 1 licenza nod32 aggiornamento su pc client Luigi',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-04-12 14:15:25','2022-04-11'),
(2018,3,2,41,'2022-04-12 07:45:00','2022-04-12 08:30:00',2700,'Assistenza per ripristino server  dopo problema elettrico',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-06-08 13:47:42','2022-04-12'),
(2019,3,2,41,'2022-04-12 08:55:00','2022-04-12 09:25:00',1800,'Installata 1 licenza nod32 aggiornamento su 2 PC client + verificata presenza switch 10/100 e necessità di switch poe (non serve)',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-06-08 13:47:33','2022-04-12'),
(2020,1,3,112,'2022-04-12 12:30:00','2022-04-12 12:55:00',1500,NULL,18.75,NULL,45,1,'Europe/Rome',18.75,1,'work','2022-05-04 10:01:30','2022-04-12'),
(2021,3,1,18,'2022-04-12 07:10:00','2022-04-12 07:20:00',600,'Assistenza su pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-07 07:18:35','2022-04-12'),
(2022,3,1,79,'2022-04-12 09:35:00','2022-04-12 09:55:00',1200,'Assistenza su pc client Valentina per invio mail saluti',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-10 14:41:02','2022-04-12'),
(2023,3,2,75,'2022-04-13 07:20:00','2022-04-13 07:40:00',1200,'Consegnato e installato nuovo monitor Dell 24\" in casa di Federico Figari',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-10 09:52:39','2022-04-13'),
(2024,3,2,10,'2022-04-13 08:05:00','2022-04-13 08:25:00',1200,'Riconsegna mac casa Carmen dopo assistenza \r\nAssistenza su PC client Francesca',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-09 14:08:49','2022-04-13'),
(2025,3,2,40,'2022-04-13 08:35:00','2022-04-13 08:45:00',600,'Riconsegnato monitor dopo assistenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-07 07:32:25','2022-04-13'),
(2026,3,2,96,'2022-04-13 08:50:00','2022-04-13 09:00:00',600,'Consegna toner compatibile Brother',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-03 15:32:03','2022-04-13'),
(2027,3,2,71,'2022-04-13 09:05:00','2022-04-13 09:35:00',1800,'Incontro con dott. Grimaudo per rifacimento sito',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-08 16:57:01','2022-04-13'),
(2028,1,4,3,'2022-04-12 06:30:00','2022-04-12 07:00:00',1800,'riportato mac in lab',22.5,NULL,45,1,'Europe/Rome',22.5,1,'work','2022-05-04 13:44:24','2022-04-12'),
(2029,1,1,4,'2022-04-12 07:17:00','2022-04-12 08:20:00',3780,'problemi collegamento alex',47.25,NULL,45,1,'Europe/Rome',47.25,1,'work','2022-05-04 15:51:53','2022-04-12'),
(2030,1,1,4,'2022-04-12 13:16:00','2022-04-12 14:07:00',3060,'problemi collegamento alex',38.25,NULL,45,1,'Europe/Rome',38.25,1,'work','2022-05-04 15:51:54','2022-04-12'),
(2031,1,1,3,'2022-04-12 14:31:00','2022-04-12 16:30:00',7140,'antivirus rspamd postfix dkim studio',89.25,NULL,45,1,'Europe/Rome',89.25,1,'work','2022-05-04 13:44:30','2022-04-12'),
(2032,1,1,3,'2022-04-12 08:40:00','2022-04-12 10:30:00',6600,'antivirus rspamd postfix dkim studio',82.5,NULL,45,1,'Europe/Rome',82.5,1,'work','2022-05-04 13:44:27','2022-04-12'),
(2033,1,1,3,'2022-04-13 06:44:00','2022-04-13 10:17:00',12780,'antivirus rspamd postfix dkim studio',159.75,NULL,45,1,'Europe/Rome',159.75,1,'work','2022-05-04 13:44:31','2022-04-13'),
(2034,1,1,2,'2022-04-13 12:43:00','2022-04-13 13:28:00',2700,'reinstallazione pc ex francesca da riportare',33.75,NULL,45,1,'Europe/Rome',33.75,1,'work','2022-07-08 10:17:07','2022-04-13'),
(2035,3,1,41,'2022-04-13 12:40:00','2022-04-13 13:00:00',1200,'Assistenza su pc client Fucilli per problemi stampa Formulari',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-06-08 13:47:43','2022-04-13'),
(2036,3,1,96,'2022-04-13 13:00:00','2022-04-13 13:15:00',900,'Testato collegamento vpn Antonella disabilitato',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-03 15:52:31','2022-04-13'),
(2037,3,2,96,'2022-04-14 09:00:00','2022-04-14 09:35:00',2100,'Consegna e installazione toner originale Brother\r\nAssistenza varia su PC client',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-03 15:52:32','2022-04-14'),
(2038,3,2,64,'2022-04-15 06:40:00','2022-04-15 07:10:00',1800,'Riconsegna portatile casa Valentina dopo assistenza \r\nAssistenza su portatile ufficio Valentina',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-09 14:48:01','2022-04-15'),
(2040,3,1,101,'2022-04-14 13:20:00','2022-04-14 13:30:00',600,'Assistenza per collegamento in rdp su nuovo pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-10 09:40:11','2022-04-14'),
(2041,3,1,104,'2022-04-14 13:40:00','2022-04-14 13:50:00',600,'Riavviati servizi di posta per problemi con certificato',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-04 16:10:37','2022-04-14'),
(2042,3,2,26,'2022-04-15 10:55:00','2022-04-15 11:15:00',1200,'Verificato e ritirato toner compatibile giallo stampante Brother',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-04-20 15:11:52','2022-04-15'),
(2043,3,1,79,'2022-04-15 08:15:00','2022-04-15 08:30:00',900,'Assistenza su pc client Matteo Parodi per problemi ricezione posta',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-10 14:41:03','2022-04-15'),
(2044,3,1,96,'2022-04-15 08:45:00','2022-04-15 09:15:00',1800,'Configurato alias per rigiro posta Antonella su account segreteria@studiongandolfo.it',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-03 15:52:33','2022-04-15'),
(2045,1,1,3,'2022-04-14 12:30:00','2022-04-14 16:30:00',14400,'problema generale nostri utenti mail e gmail',180,NULL,45,1,'Europe/Rome',180,1,'work','2022-05-04 13:44:38','2022-04-14'),
(2046,1,1,3,'2022-04-15 06:30:00','2022-04-15 10:30:00',14400,'in lab fede arriva dopo\r\nproblema generale nostri utenti mail e gmail',180,NULL,45,1,'Europe/Rome',180,1,'work','2022-05-04 13:44:46','2022-04-15'),
(2047,1,1,3,'2022-04-15 12:36:00','2022-04-15 16:30:00',14040,'in lab fede và a una visita\r\nproblema generale nostri utenti mail e gmail',175.5,NULL,45,1,'Europe/Rome',175.5,1,'work','2022-05-04 13:44:47','2022-04-15'),
(2048,3,1,90,'2022-04-19 07:45:00','2022-04-19 07:55:00',600,'Installata 1 licenza nod32 aggiornamento su pc client Campodoni',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-10 09:28:47','2022-04-19'),
(2049,3,2,24,'2022-04-19 14:35:00','2022-04-19 15:05:00',1800,'Assistenza su pc client Giovanni per problemi accensione',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-04-26 13:22:26','2022-04-19'),
(2050,3,1,27,'2022-04-19 15:40:00','2022-04-19 16:10:00',1800,'Assistenza per reidirect dominio .com su dominio .it',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-08 10:44:39','2022-04-19'),
(2051,3,2,26,'2022-04-20 12:55:00','2022-04-20 13:10:00',900,'Consegna 2 toner giallo + 1 toner nero compatibili per stampante Brother',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-04-20 15:11:58','2022-04-20'),
(2052,3,2,50,'2022-04-20 13:30:00','2022-04-20 13:50:00',1200,'Verificata situazione per spostamento postazione Elisabetta + ritiro 2 portatili per assistenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-10 09:45:46','2022-04-20'),
(2053,1,1,58,'2022-04-20 14:26:00','2022-04-20 16:26:39',7239,'agg 3cx v18',90.49,NULL,45,1,'Europe/Rome',90.49,1,'work','2022-05-04 14:34:14','2022-04-20'),
(2054,3,1,90,'2022-04-20 07:10:00','2022-04-20 07:45:00',2100,'Assistenza per problemi avvio software gestionale Ufficius',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-10 09:28:47','2022-04-20'),
(2055,3,1,27,'2022-04-20 07:55:00','2022-04-20 08:05:00',600,'Assistenza per reidirect sitoweb',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-08 10:44:41','2022-04-20'),
(2056,3,1,90,'2022-04-20 09:15:00','2022-04-20 09:35:00',1200,'Assistenza per problemi invio posta elettronica',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-10 09:28:48','2022-04-20'),
(2057,3,1,101,'2022-04-20 14:15:00','2022-04-20 14:45:00',1800,'Assistenza su portatile casa Mina per problemi collegamento al pc dell\'ufficio',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-10 09:40:12','2022-04-20'),
(2058,3,2,104,'2022-04-20 15:00:00','2022-04-20 15:10:00',600,'Consegna toner compatibili',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-04 16:10:38','2022-04-20'),
(2059,3,1,50,'2022-04-20 15:15:00','2022-04-20 15:25:00',600,'Installato nod32 su pc client Giuseppe (licenza da NON fatturare)',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-10 09:45:38','2022-04-20'),
(2060,3,1,41,'2022-04-20 15:30:00','2022-04-20 15:45:00',900,'Assistenza sul server per problema stampa formulari',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-06-08 13:47:45','2022-04-20'),
(2061,3,2,58,'2022-04-21 07:15:00','2022-04-21 09:15:00',7200,'Assistenza sul centralino dopo problemi durante aggiornamento',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-04 14:19:03','2022-04-21'),
(2062,1,1,58,'2022-04-21 07:40:00','2022-04-21 09:46:00',7560,'aggionramento debian da stretch a buster per aggiornamento 3cx fede li perchè durante il tentativo di ieri il server ssh si è bloccato.',94.5,NULL,45,1,'Europe/Rome',94.5,1,'work','2022-05-04 14:34:15','2022-04-21'),
(2063,3,2,96,'2022-04-21 09:45:00','2022-04-21 11:00:00',4500,'Assistenza su ex PC client Antonella + assistenza su PC client Cristina, spostamento e modifiche telefoni vip, testata postazione videoconferenza.\r\nUtilizzato: 1 cavo di rete da 10 mt',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-03 15:52:33','2022-04-21'),
(2064,3,1,83,'2022-04-21 12:40:00','2022-04-21 12:50:00',600,'Assistenza su pc client Roberta per apertura file firmati digitalmente',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-10-04 15:46:05','2022-04-21'),
(2065,3,1,96,'2022-04-21 13:30:00','2022-04-21 13:50:00',1200,'Assistenza su pc client Stefano',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-03 15:52:36','2022-04-21'),
(2066,3,1,79,'2022-04-21 13:50:00','2022-04-21 14:10:00',1200,'Assistenza su pc client Elena per problemi posta in uscita',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-10 14:41:04','2022-04-21'),
(2067,1,1,29,'2022-04-21 19:30:00','2022-04-21 20:45:00',4500,'installazione proxmox da remoto, dovuto interrompere perchè mancava un cavo di rete collegato',56.25,NULL,45,1,'Europe/Rome',56.25,1,'work','2022-05-04 14:38:48','2022-04-21'),
(2068,1,1,79,'2022-04-22 15:00:00','2022-04-22 15:55:19',3319,'conversione video',41.49,NULL,45,1,'Europe/Rome',41.49,1,'work','2022-05-10 14:41:07','2022-04-22'),
(2069,1,1,29,'2022-04-22 08:30:00','2022-04-22 09:30:00',3600,'installazione proxmox da remoto, installazione vm windows',45,NULL,45,1,'Europe/Rome',45,1,'work','2022-05-04 14:38:49','2022-04-22'),
(2070,1,1,3,'2022-04-22 10:02:00','2022-04-22 11:00:00',3480,'studio backup proxmox snapshot',43.5,NULL,45,1,'Europe/Rome',43.5,1,'work','2022-05-04 13:44:50','2022-04-22'),
(2071,1,1,3,'2022-04-22 12:56:00','2022-04-22 14:31:00',5700,'studio backup proxmox snapshot',71.25,NULL,45,1,'Europe/Rome',71.25,1,'work','2022-05-04 13:44:51','2022-04-22'),
(2072,3,1,96,'2022-04-22 06:45:00','2022-04-22 07:10:00',1500,'Assistenza su pc client Maria per problemi a collegarsi ad AGO',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-03 15:52:37','2022-04-22'),
(2073,3,1,5,'2022-04-22 07:45:00','2022-04-22 07:55:00',600,'Assistenza su portatile Alessandra per problemi con vpn',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-12 15:03:26','2022-04-22'),
(2074,3,1,12,'2022-04-22 08:45:00','2022-04-22 09:00:00',900,'Installata vpn su portatile casa Greta Solari',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-21 07:53:35','2022-04-22'),
(2075,3,1,79,'2022-04-22 09:00:00','2022-04-22 09:10:00',600,'Assistenza su pc client Elena',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-10 14:41:05','2022-04-22'),
(2076,3,1,79,'2022-04-22 12:35:00','2022-04-22 12:45:00',600,'Assistenza su pc client Roberto',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-10 14:41:06','2022-04-22'),
(2077,3,4,79,'2022-04-22 14:05:00','2022-04-22 15:05:00',3600,'Recupero video telecamera casa Andrea Parodi',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-10 14:41:06','2022-04-22'),
(2078,3,4,51,'2022-04-22 15:10:00','2022-04-22 16:10:00',3600,'Sostituzione batteria su portatile mac Burdese',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-06 13:41:18','2022-04-22'),
(2079,3,2,32,'2022-04-26 08:45:00','2022-04-26 10:15:00',5400,'Assistenza su PC client Sara Dante per possibili virus',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-06 13:27:22','2022-04-26'),
(2080,3,1,1,'2022-04-26 06:40:00','2022-04-26 06:55:00',900,'Assistenza per problemi server Windows spento',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-06 09:46:12','2022-04-26'),
(2081,3,1,10,'2022-04-26 06:55:00','2022-04-26 07:10:00',900,'Assistenza per problemi server Windows spento',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-09 14:08:49','2022-04-26'),
(2082,3,1,88,'2022-04-26 07:35:00','2022-04-26 07:45:00',600,'Assistenza su pc client per problemi certificato di posta',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-06 14:49:54','2022-04-26'),
(2083,3,1,50,'2022-04-26 12:40:00','2022-04-26 13:20:00',2400,'Assistenza su mac casa Gigio per configurazione posta su Thunderbird',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-10 09:45:45','2022-04-26'),
(2084,3,2,24,'2022-04-26 14:15:00','2022-04-26 15:05:00',3000,'Consegnata, installata e configurata nuova stampante Epson WF-3820\r\nAssistenza per rinnovo dominio su Aruba',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-02 07:51:38','2022-04-26'),
(2085,3,1,79,'2022-04-26 15:20:00','2022-04-26 15:30:00',600,'Configurata risposta automatica e inoltro su mail valentina.cassandro@parodinutra.com',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-10 14:41:08','2022-04-26'),
(2086,1,1,35,'2022-04-27 08:08:00','2022-04-27 09:56:00',6480,'configurazione nuovo firewall',81,NULL,45,1,'Europe/Rome',81,1,'work','2022-04-28 07:26:42','2022-04-27'),
(2087,3,2,50,'2022-04-27 12:45:00','2022-04-27 13:00:00',900,'Riconsegnato portatile reinstallato + vecchio portatile',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-10 09:45:42','2022-04-27'),
(2088,3,2,5,'2022-04-27 13:15:00','2022-04-27 13:30:00',900,'Verificato e ritirato pc client Taglio per assistenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-12 15:03:30','2022-04-27'),
(2089,1,1,9,'2022-04-27 15:55:00','2022-04-27 16:40:00',2700,'configurazione nuovo nas',33.75,NULL,45,1,'Europe/Rome',33.75,1,'work','2022-06-29 09:02:09','2022-04-27'),
(2090,1,1,29,'2022-04-27 12:40:00','2022-04-27 14:52:00',7920,'prove su nuovo server',99,NULL,45,1,'Europe/Rome',99,1,'work','2022-05-04 14:38:50','2022-04-27'),
(2091,1,1,35,'2022-04-27 15:03:00','2022-04-27 15:48:00',2700,'fine config firewall',33.75,NULL,45,1,'Europe/Rome',33.75,1,'work','2022-04-28 07:26:43','2022-04-27'),
(2092,1,1,35,'2022-04-26 12:53:00','2022-04-26 14:30:00',5820,'config firewall',72.75,NULL,45,1,'Europe/Rome',72.75,1,'work','2022-04-28 07:26:40','2022-04-26'),
(2093,3,1,96,'2022-04-27 07:35:00','2022-04-27 07:45:00',600,'Assistenza su pc client Federica per configurazione firma digitale',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-03 15:52:37','2022-04-27'),
(2094,3,1,64,'2022-04-27 07:50:00','2022-04-27 08:10:00',1200,'Assistenza su pc client Mirella per problema posta in arrivo',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-09 14:48:02','2022-04-27'),
(2095,3,4,50,'2022-04-27 08:30:00','2022-04-27 09:30:00',3600,'Reinstallazione ex portatile Gigio',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-10 09:45:39','2022-04-27'),
(2096,3,1,57,'2022-04-27 15:45:00','2022-04-27 16:00:00',900,'Assistenza su pc client probabilmente infetto da virus',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-05 09:50:49','2022-04-27'),
(2097,1,1,95,'2022-04-28 07:43:00','2022-04-28 07:47:00',240,'config pc mara collegamento share',3,NULL,45,1,'Europe/Rome',3,1,'work','2022-09-07 13:19:12','2022-04-28'),
(2098,3,2,41,'2022-04-28 10:00:00','2022-04-28 10:25:00',1500,'Sostituzione batteria su ups PC client Francesca e Ilaria, utilizzate 2 batterie ups',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-06-08 13:47:30','2022-04-28'),
(2099,3,2,55,'2022-04-28 13:45:00','2022-04-28 14:30:00',2700,'Assistenza su PC client Amazon, sostituzione alimentatore',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-09 15:55:50','2022-04-28'),
(2100,3,2,9,'2022-04-28 15:10:00','2022-04-28 17:00:00',6600,'Consegna e configurazione nuovo NAS QNAP\r\nConsegna e installazione 2 dischi da 4tb su vecchio NAS QNAP\r\nAssistenza su PC client per scansione di rete e plotter',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-06-29 09:02:10','2022-04-28'),
(2101,1,1,29,'2022-04-28 09:22:00','2022-04-28 10:30:00',4080,'config firewall su proxmox',51,NULL,45,1,'Europe/Rome',51,1,'work','2022-05-04 14:38:52','2022-04-28'),
(2102,1,1,29,'2022-04-28 12:44:00','2022-04-28 13:25:00',2460,'config firewall su proxmox',30.75,NULL,45,1,'Europe/Rome',30.75,1,'work','2022-05-04 14:38:52','2022-04-28'),
(2103,1,1,9,'2022-04-28 15:44:00','2022-04-28 16:20:00',2160,'config nuovo nas copia dati',27,NULL,45,1,'Europe/Rome',27,1,'work','2022-06-29 09:02:11','2022-04-28'),
(2104,1,1,50,'2022-04-28 13:40:00','2022-04-28 15:40:00',7200,'copia dati',90,NULL,45,1,'Europe/Rome',90,1,'work','2022-05-10 09:45:40','2022-04-28'),
(2105,3,1,57,'2022-04-28 07:00:00','2022-04-28 07:10:00',600,'Chiamata Simona per verificare risultato scansione antivirus su pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-05 09:50:50','2022-04-28'),
(2106,3,1,79,'2022-04-28 07:20:00','2022-04-28 07:30:00',600,'Assistenza su pc client Elena',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-10 14:41:09','2022-04-28'),
(2107,3,1,96,'2022-04-28 07:35:00','2022-04-28 07:45:00',600,'Assistenza su pc client Federica',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-03 15:52:38','2022-04-28'),
(2108,3,1,35,'2022-04-28 07:45:00','2022-04-28 08:00:00',900,'Contattata assistenza software Genius, creazione chiavi vpn su Wireguard',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-04-29 07:53:08','2022-04-28'),
(2109,3,1,96,'2022-04-28 08:50:00','2022-04-28 09:20:00',1800,'Assistenza su pc client Cristina per problemi con le stampanti',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-03 15:52:39','2022-04-28'),
(2110,3,1,18,'2022-04-28 12:35:00','2022-04-28 12:50:00',900,'Assistenza su pc client per problemi con posta PEC',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-07 07:19:16','2022-04-28'),
(2111,1,1,50,'2022-04-29 06:45:00','2022-04-29 08:15:00',5400,'mail fermarconsult di francesco',67.5,NULL,45,1,'Europe/Rome',67.5,1,'work','2022-05-10 09:45:42','2022-04-29'),
(2112,1,1,79,'2022-04-04 08:18:00','2022-04-04 10:20:00',7320,'verifiche post agg vm agg ssl',91.5,NULL,45,1,'Europe/Rome',91.5,1,'work','2022-05-10 14:41:00','2022-04-04'),
(2113,1,1,2,'2022-04-05 07:29:00','2022-04-05 08:30:00',3660,'agg vari',45.75,NULL,45,1,'Europe/Rome',45.75,1,'work','2022-07-08 10:16:50','2022-04-05'),
(2114,1,1,88,'2022-04-05 09:02:00','2022-04-05 10:30:00',5280,'agg 3cx e debian',66,NULL,45,1,'Europe/Rome',66,1,'work','2022-05-06 09:51:45','2022-04-05'),
(2115,1,3,112,'2022-04-05 06:47:00','2022-04-05 07:20:00',1980,NULL,24.75,NULL,45,1,'Europe/Rome',24.75,1,'work','2022-05-04 10:01:28','2022-04-05'),
(2116,1,1,103,'2022-04-05 12:43:00','2022-04-05 15:00:00',8220,'agg server',102.75,NULL,45,1,'Europe/Rome',102.75,1,'work','2022-05-05 09:50:00','2022-04-05'),
(2117,1,3,112,'2022-04-07 06:30:00','2022-04-07 07:15:00',2700,NULL,33.75,NULL,45,1,'Europe/Rome',33.75,1,'work','2022-05-04 10:01:29','2022-04-07'),
(2118,1,1,81,'2022-04-07 07:18:00','2022-04-07 08:00:00',2520,'agg server wireguard',31.5,NULL,45,1,'Europe/Rome',31.5,1,'work','2022-05-10 09:44:33','2022-04-07'),
(2119,1,1,96,'2022-04-07 08:07:00','2022-04-07 09:14:00',4020,'agg centralino',50.25,NULL,45,1,'Europe/Rome',50.25,1,'work','2022-05-03 15:08:13','2022-04-07'),
(2120,1,1,29,'2022-04-07 09:21:00','2022-04-07 10:30:00',4140,'agg nas',51.75,NULL,45,1,'Europe/Rome',51.75,1,'work','2022-05-04 14:38:48','2022-04-07'),
(2121,1,1,3,'2022-04-07 12:46:00','2022-04-07 14:46:00',7200,'test proxmox backup',90,NULL,45,1,'Europe/Rome',90,1,'work','2022-05-04 13:44:15','2022-04-07'),
(2122,1,1,41,'2022-04-13 14:00:00','2022-04-13 16:30:00',9000,'verifica funzionamento backup, coerenza dischi su controller non nostro, eliminazione vecchi dati non più necessari su share old',112.5,NULL,45,1,'Europe/Rome',112.5,1,'work','2022-06-08 13:47:31','2022-04-13'),
(2123,1,1,3,'2022-04-14 08:26:00','2022-04-14 10:24:00',7080,'problema nostri utenti con gmail',88.5,NULL,45,1,'Europe/Rome',88.5,1,'work','2022-05-04 13:44:33','2022-04-14'),
(2124,1,3,112,'2022-04-14 07:30:00','2022-04-14 08:17:00',2820,NULL,35.25,NULL,45,1,'Europe/Rome',35.25,1,'work','2022-05-04 10:01:31','2022-04-14'),
(2125,1,1,3,'2022-04-14 06:48:00','2022-04-14 07:27:00',2340,'agg wiki',29.25,NULL,45,1,'Europe/Rome',29.25,1,'work','2022-05-04 13:44:32','2022-04-14'),
(2126,1,1,9,'2022-04-29 09:46:00','2022-04-29 10:26:00',2400,'copia dati',30,NULL,45,1,'Europe/Rome',30,1,'work','2022-06-29 09:02:12','2022-04-29'),
(2127,1,1,3,'2022-04-29 12:31:00','2022-04-29 13:17:00',2760,'fogli',34.5,NULL,45,1,'Europe/Rome',34.5,1,'work','2022-05-04 13:44:54','2022-04-29'),
(2128,3,1,18,'2022-04-29 07:20:00','2022-04-29 07:35:00',900,'Assistenza su pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-07 07:19:15','2022-04-29'),
(2129,3,1,55,'2022-04-29 07:50:00','2022-04-29 08:00:00',600,'Verificato problema su pc client Amazon',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-09 15:09:30','2022-04-29'),
(2130,3,2,115,'2022-04-29 08:20:00','2022-04-29 09:50:00',5400,'Consegnato e configurato nuovo pc client, consegnata e configurata nuova stampante Brother\r\nVerificato lavori per ultimare nuovo sito web. Utilizzata 1 ciabatta elettrica + 1 cavo di rete da 2mt',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-08 10:57:27','2022-04-29'),
(2131,3,1,18,'2022-04-29 13:35:00','2022-04-29 13:55:00',1200,'Assistenza per rinnovo dominio su Aruba',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-07 07:19:06','2022-04-29'),
(2132,3,4,5,'2022-04-29 14:00:00','2022-04-29 16:00:00',7200,'Assistenza su ex pc client Michele per reinstallazione s.o + vm con Win 7 per utilizzo software Ariel\r\nAssistenza su pc client Taglio per verifica e reinstallazione s.o',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-12 15:03:29','2022-04-29'),
(2133,1,1,3,'2022-04-01 08:25:00','2022-04-01 10:15:00',6600,'test proxmox su vm migrata da 7 a 10',82.5,NULL,45,1,'Europe/Rome',82.5,1,'work','2022-05-04 13:43:51','2022-04-01'),
(2134,1,1,3,'2022-04-11 06:30:00','2022-04-11 07:00:00',1800,'problemi in lab vpn',22.5,NULL,45,1,'Europe/Rome',22.5,1,'work','2022-05-04 13:44:19','2022-04-11'),
(2135,1,1,96,'2022-04-11 12:36:00','2022-04-11 13:46:00',4200,'tentativo recupero dati cancellati',52.5,NULL,45,1,'Europe/Rome',52.5,1,'work','2022-05-03 15:52:30','2022-04-11'),
(2136,1,1,3,'2022-04-11 07:15:00','2022-04-11 09:32:00',8220,'wireguard e 2fa',102.75,NULL,45,1,'Europe/Rome',102.75,1,'work','2022-05-04 13:44:21','2022-04-11'),
(2137,1,1,2,'2022-04-11 10:30:00','2022-04-11 10:30:00',0,'agg server',0,NULL,45,1,'Europe/Rome',0,1,'work','2022-05-05 08:03:44','2022-04-11'),
(2138,1,1,2,'2022-04-11 14:00:00','2022-04-11 15:00:00',3600,'agg',45,NULL,45,1,'Europe/Rome',45,1,'work','2022-05-05 08:04:38','2022-04-11'),
(2139,1,1,75,'2022-04-11 15:06:00','2022-04-11 15:46:00',2400,'agg nas',30,NULL,45,1,'Europe/Rome',30,1,'work','2022-05-10 10:16:01','2022-04-11'),
(2140,1,1,5,'2022-04-11 16:00:00','2022-04-11 16:30:00',1800,'agg nas',22.5,NULL,45,1,'Europe/Rome',22.5,1,'work','2022-05-06 13:42:36','2022-04-11'),
(2141,1,1,50,'2022-04-29 13:18:00','2022-04-29 13:38:00',1200,'spostamento mail fermarcons',15,NULL,45,1,'Europe/Rome',15,1,'work','2022-05-10 09:45:41','2022-04-29'),
(2142,1,1,2,'2022-04-29 15:20:00','2022-04-29 15:30:00',600,'configurazione pc vpn francesca a casa',7.5,NULL,45,1,'Europe/Rome',7.5,1,'work','2022-07-08 10:17:08','2022-04-29'),
(2143,1,1,96,'2022-05-02 08:40:00','2022-05-02 09:53:00',4380,'sistemazione interni',54.75,NULL,45,1,'Europe/Rome',54.75,1,'work','2022-05-03 15:52:40','2022-05-02'),
(2144,1,1,3,'2022-05-02 06:30:00','2022-05-02 07:00:00',1800,'in lab',22.5,NULL,45,1,'Europe/Rome',22.5,1,'work','2022-05-04 13:44:57','2022-05-02'),
(2145,3,2,79,'2022-05-02 08:30:00','2022-05-02 09:30:00',3600,'Consegna 2 CD con video casa Andrea\r\nAssistenza su PC client Elena\r\nAssistenza su cellulare Paola\r\nRitiro ex PC client Valentina per reinstallazione s.o',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-10 14:41:10','2022-05-02'),
(2147,1,1,3,'2022-05-02 12:30:00','2022-05-02 14:00:00',5400,'backup  remoti\r\nrimane da risolvere ballerini artdesign',67.5,NULL,45,1,'Europe/Rome',67.5,1,'work','2022-05-04 13:45:01','2022-05-02'),
(2148,1,1,87,'2022-05-02 07:17:00','2022-05-02 08:33:00',4560,'problemi spam',57,NULL,45,1,'Europe/Rome',57,1,'work','2022-05-07 07:25:12','2022-05-02'),
(2149,1,1,87,'2022-05-02 10:06:00','2022-05-02 10:29:00',1380,'problemi spam',17.25,NULL,45,1,'Europe/Rome',17.25,1,'work','2022-05-07 07:25:13','2022-05-02'),
(2150,3,2,35,'2022-05-02 13:00:00','2022-05-02 14:20:00',4800,'Consegna e configurazione nuovo Firewall. \r\nVerificato funzionamento tutti pc client + genius\r\nUtilizzato: 2 cavi LAN da 2 mt',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-07 07:20:43','2022-05-02'),
(2151,3,1,12,'2022-05-02 14:40:00','2022-05-02 15:00:00',1200,'Installata e configurata VPN su nuovo portatile Valentina Maffei',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-21 07:53:37','2022-05-02'),
(2152,3,1,27,'2022-05-02 16:30:00','2022-05-02 16:50:00',1200,'Assistenza per spostamento sito conzieminetti.it',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-08 10:44:43','2022-05-02'),
(2153,1,1,35,'2022-05-03 08:04:00','2022-05-03 09:20:40',4600,'problemi stampa dopo installazione firewall',57.5,NULL,45,1,'Europe/Rome',57.5,1,'work','2022-05-07 07:20:43','2022-05-03'),
(2154,3,2,5,'2022-05-03 08:30:00','2022-05-03 09:30:00',3600,'Riconsegna 2 pc client dopo reinstallazione s.o\r\nConfigurazione PC client per utilizzo Ariel su IE\r\nAssistenza su portatile e pc client Alessandra',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-12 15:03:29','2022-05-03'),
(2155,1,1,95,'2022-05-03 09:51:00','2022-05-03 09:56:36',336,'problemi firma web',4.2,NULL,45,1,'Europe/Rome',4.2,1,'work','2022-09-07 13:18:06','2022-05-03'),
(2156,3,2,10,'2022-05-03 09:45:00','2022-05-03 10:20:00',2100,'OSostituzione 1 batteria su ups apc 700 collegato al server, assistenza su PC client ufficio e casa Carmen',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-09 14:08:51','2022-05-03'),
(2157,1,1,35,'2022-05-03 12:32:00','2022-05-03 13:32:00',3600,'problemi stampa dopo installazione firewall',45,NULL,45,1,'Europe/Rome',45,1,'work','2022-05-07 07:20:43','2022-05-03'),
(2158,3,1,10,'2022-05-03 12:55:00','2022-05-03 13:10:00',900,'Assistenza su pc client casa Carmen',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-09 14:08:50','2022-05-03'),
(2159,3,4,79,'2022-05-03 13:20:00','2022-05-03 14:20:00',3600,'Reinstallazione sistema operativo su ex pc client Valentina',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-10 14:41:11','2022-05-03'),
(2160,3,1,81,'2022-05-03 15:10:00','2022-05-03 15:35:00',1500,'Assistenza su pc client casa Pellini per problema posta',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-10 09:44:34','2022-05-03'),
(2161,3,1,95,'2022-05-04 07:00:00','2022-05-04 07:15:00',900,'Verificata configurazione pc client Silvia per upgrade hardware',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-10 08:46:30','2022-05-04'),
(2162,3,1,5,'2022-05-04 07:45:00','2022-05-04 09:15:00',5400,'Assistenza su pc client con VM Windows 7 per funzionamento software gestionale Ariel',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-12 15:03:32','2022-05-04'),
(2163,3,4,115,'2022-05-04 09:25:00','2022-05-04 09:45:00',1200,'Preparazione materiale per nuovo sito web www.liguriafumi.it',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-08 10:57:29','2022-05-04'),
(2164,3,1,55,'2022-05-04 09:50:00','2022-05-04 10:00:00',600,'Verificato risoluzione problema avvio pc client Amazon',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-09 15:09:31','2022-05-04'),
(2165,3,1,5,'2022-05-04 12:30:00','2022-05-04 12:45:00',900,'Assistenza su portatile casa Alessandra per problema collegamento in rdp a pc client ufficio',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-12 15:03:31','2022-05-04'),
(2166,3,1,67,'2022-05-04 12:45:00','2022-05-04 13:05:00',1200,'Configurata nuova casella di posta elettronica, inviata chiave attivazione licenza agg nod32',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-12 13:52:55','2022-05-04'),
(2167,3,1,17,'2022-05-04 14:10:00','2022-05-04 14:30:00',1200,'Configurata porta 873 su router, configurata rete wifi',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-14 07:29:19','2022-05-04'),
(2168,3,1,12,'2022-05-04 14:35:00','2022-05-04 15:00:00',1500,'Configurata porta 873 su router',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-21 07:53:40','2022-05-04'),
(2169,3,2,24,'2022-05-04 15:40:00','2022-05-04 15:50:00',600,'Verificato problema lentezza scanner di rete, da intervenire in loco per modificare configurazione',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-07 07:31:55','2022-05-04'),
(2170,3,4,115,'2022-05-04 16:00:00','2022-05-04 16:30:00',1800,'Lavorato su nuovo sito web www.liguriafumi.it',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-08 10:57:30','2022-05-04'),
(2171,3,2,79,'2022-05-05 08:50:00','2022-05-05 10:40:00',6600,'Spostata e configurata ex postazione client Valentina dopo reinstallazione sistema operativo, assistenza su PC client Silvia, assistenza su Iphone Matteo \r\n, consegna toner compatibili Brother',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-10 14:41:12','2022-05-05'),
(2172,3,2,24,'2022-05-05 12:40:00','2022-05-05 13:00:00',1200,'Assistenza su PC client Monica e scansione di rete',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-07 13:00:18','2022-05-05'),
(2173,3,2,96,'2022-05-05 13:45:00','2022-05-05 15:15:00',5400,'Assistenza su PC client Cristina per problema con stampante HP, montato hhd su PC client Federica con dati recuperati da PC Antonella, riconfigurato ex telefono voip Valeria, sistemato problema dispositivo dhcp',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-08 16:26:50','2022-05-05'),
(2174,3,2,5,'2022-05-06 13:10:00','2022-05-06 13:20:00',600,'Ritirato vecchio PC client per installazione Windows 7 e utilizzo software Ariel',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-06 13:43:18','2022-05-06'),
(2175,1,2,55,'2022-05-06 09:10:00','2022-05-06 11:30:00',8400,'inziaito da remoto poi andato dal cliente, problemi di rete provocati da ponte fatto su switch dal pc di stefano dalla valle',105,NULL,45,1,'Europe/Rome',105,1,'work','2022-05-09 15:55:51','2022-05-06'),
(2176,1,1,55,'2022-05-06 13:00:00','2022-05-06 15:03:14',7394,'agg server windows e vm',92.43,NULL,45,1,'Europe/Rome',92.43,1,'work','2022-05-09 15:55:52','2022-05-06'),
(2177,1,1,57,'2022-05-06 15:04:00','2022-05-06 15:34:15',1815,'mepa',22.69,NULL,45,1,'Europe/Rome',22.69,1,'work','2022-09-14 13:47:49','2022-05-06'),
(2178,3,2,2,'2022-05-06 14:30:00','2022-05-06 15:00:00',1800,'Ritirato vecchio server Windows',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-08 09:30:20','2022-05-06'),
(2179,1,1,55,'2022-05-06 15:43:00','2022-05-06 16:24:00',2460,'agg server windows e vm',30.75,NULL,45,1,'Europe/Rome',30.75,1,'work','2022-05-09 15:55:54','2022-05-06'),
(2180,3,1,5,'2022-05-06 07:20:00','2022-05-06 07:35:00',900,'Assistenza su pc client con VM Windows 7',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-12 15:03:31','2022-05-06'),
(2181,3,2,104,'2022-05-06 08:45:00','2022-05-06 09:15:00',1800,'Assistenza su pc client Veronica, assistenza su stampante Brother, installate 4 licenze nod32 Aggiornamento',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-13 07:59:08','2022-05-06'),
(2182,3,2,59,'2022-05-06 09:30:00','2022-05-06 09:40:00',600,'Consegnato toner compatibile Samsung',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-06-09 08:02:34','2022-05-06'),
(2183,1,1,103,'2022-05-09 06:45:00','2022-05-09 07:15:00',1800,'connessione a host vm non riuscita',22.5,NULL,45,1,'Europe/Rome',22.5,1,'work','2022-12-15 10:23:00','2022-05-09'),
(2184,1,1,2,'2022-05-09 07:30:00','2022-05-09 10:28:00',10680,'problema connessione a share e nas spento, installazione debian su vecchio server, aggionrmaneot bios su vecchio server aggiornamento ipmi su vecchio server',133.5,NULL,45,1,'Europe/Rome',133.5,1,'work','2022-07-08 10:17:00','2022-05-09'),
(2185,3,2,103,'2022-05-09 08:30:00','2022-05-09 09:00:00',1800,'Recuperata password IPMI Server Windows \r\nAssistenza su PC client Collaudo2',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-12-15 10:23:07','2022-05-09'),
(2186,3,2,115,'2022-05-09 09:35:00','2022-05-09 09:50:00',900,'Riconfigurato wifi dopo reset router',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-08 10:57:31','2022-05-09'),
(2187,1,1,35,'2022-05-09 12:45:00','2022-05-09 14:12:54',5274,'studio cambio ip backuppc\r\nconfigurazione backuppc',65.93,NULL,45,1,'Europe/Rome',65.93,1,'work','2022-07-11 08:28:03','2022-05-09'),
(2188,3,1,75,'2022-05-09 07:20:00','2022-05-09 07:45:00',1500,'Assistenza su pc client casa Federico per problemi segnalati via mail',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-10 10:16:02','2022-05-09'),
(2189,3,1,104,'2022-05-09 10:15:00','2022-05-09 10:35:00',1200,'Assistenza per rimozione ip da blacklist',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-13 07:59:27','2022-05-09'),
(2190,3,4,5,'2022-05-09 12:30:00','2022-05-09 13:30:00',3600,'Installazione Windows 7 su pc client per utilizzo software Ariel',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-12 15:03:34','2022-05-09'),
(2191,3,1,75,'2022-05-09 13:40:00','2022-05-09 14:10:00',1800,'Assistenza su pc client Casa Federico',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-10 10:16:03','2022-05-09'),
(2192,3,1,18,'2022-05-09 14:25:00','2022-05-09 14:50:00',1500,'Assistenza su pc client per problemi posta',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-08 17:04:15','2022-05-09'),
(2193,3,1,22,'2022-05-09 15:45:00','2022-05-09 15:55:00',600,'Assistenza per problemi su webcam, da sostituire',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-10-04 16:13:12','2022-05-09'),
(2194,1,1,35,'2022-05-10 06:50:00','2022-05-10 08:00:00',4200,'fine config backup, alla fine salvati vecchi backup e configurati nuovi host',52.5,NULL,45,1,'Europe/Rome',52.5,1,'work','2022-07-11 08:28:04','2022-05-10'),
(2195,1,1,96,'2022-05-10 08:25:00','2022-05-10 08:54:00',1740,'fede li non funge telefono nuovo, configurato',21.75,NULL,45,1,'Europe/Rome',21.75,1,'work','2022-07-08 16:26:44','2022-05-10'),
(2196,3,2,96,'2022-05-10 08:00:00','2022-05-10 09:20:00',4800,'Consegna e configurazione nuovo telefono voip per Roberta, assistenza su PC client Roberta e assistenza su PC client Maria',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-08 16:26:22','2022-05-10'),
(2197,3,2,10,'2022-05-10 13:35:00','2022-05-10 14:05:00',1800,'Assistenza per verifiche sul segnale wifi stanza corsi',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-22 09:40:25','2022-05-10'),
(2198,3,2,12,'2022-05-10 14:25:00','2022-05-10 14:50:00',1500,'Assistenza su ipad Claudio per problemi collegamento al server',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-21 07:53:42','2022-05-10'),
(2199,1,3,112,'2022-05-10 09:10:00','2022-05-10 10:30:00',4800,NULL,60,NULL,45,1,'Europe/Rome',60,1,'work','2022-07-08 10:59:14','2022-05-10'),
(2200,1,3,112,'2022-05-10 12:30:00','2022-05-10 12:50:00',1200,NULL,15,NULL,45,1,'Europe/Rome',15,1,'work','2022-07-08 10:59:14','2022-05-10'),
(2201,1,1,3,'2022-05-10 12:55:00','2022-05-10 15:00:00',7500,'problema ora su windows server ad',93.75,NULL,45,1,'Europe/Rome',93.75,1,'work','2022-07-08 12:40:55','2022-05-10'),
(2202,3,1,81,'2022-05-10 15:40:00','2022-05-10 15:50:00',600,'Assistenza su pc client Pellini per problemi di stampa',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-06-28 09:55:58','2022-05-10'),
(2203,1,1,100,'2022-05-10 15:13:00','2022-05-10 16:30:00',4620,'problema spam, config dmarc spf per verifica',57.75,NULL,45,1,'Europe/Rome',57.75,1,'work','2022-07-11 09:36:18','2022-05-10'),
(2204,1,1,32,'2022-05-11 13:17:00','2022-05-11 13:33:22',982,'problema software successioni',12.28,NULL,45,1,'Europe/Rome',12.28,1,'work','2023-01-23 16:45:18','2022-05-11'),
(2205,1,1,29,'2022-05-11 12:50:00','2022-05-11 13:09:00',1140,'per contatto xdent per installazione di domani',14.25,NULL,45,1,'Europe/Rome',14.25,1,'work','2022-05-12 15:03:58','2022-05-11'),
(2206,1,1,100,'2022-05-09 14:33:00','2022-05-09 16:23:00',6600,'problemi spam',82.5,NULL,45,1,'Europe/Rome',82.5,1,'work','2022-07-11 09:36:16','2022-05-09'),
(2207,1,1,29,'2022-05-06 06:49:00','2022-05-06 09:00:00',7860,'server nuovo wireguard, e test backup',98.25,NULL,45,1,'Europe/Rome',98.25,1,'work','2022-05-12 15:03:57','2022-05-06'),
(2208,3,2,5,'2022-05-11 13:35:00','2022-05-11 14:50:00',4500,'Riconsegna pc client con Windows 7 per utilizzo gestionale Ariel, configurato e testato software ariel',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-12 15:03:33','2022-05-11'),
(2209,3,2,95,'2022-05-11 15:50:00','2022-05-11 16:00:00',600,'Ritirato pc client Silvia per upgrade hw',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-16 14:12:38','2022-05-11'),
(2210,3,1,67,'2022-05-11 07:10:00','2022-05-11 07:25:00',900,'Assistenza su pc client per configurazione mail',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-14 10:26:32','2022-05-11'),
(2211,3,1,41,'2022-05-11 08:25:00','2022-05-11 08:35:00',600,'Installata 1 licenza nod32 aggiornamento su 2 pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-06-08 10:07:02','2022-05-11'),
(2212,3,1,50,'2022-05-11 08:45:00','2022-05-11 08:55:00',600,'Installata 1 licenza nod32 aggiornamento su 2 pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-06-08 09:38:56','2022-05-11'),
(2213,3,1,4,'2022-05-11 09:35:00','2022-05-11 10:15:00',2400,'Assistenza su mac portatile Giorgio per problema collegamento server con vpn, da verificare se risolto',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-23 15:57:33','2022-05-11'),
(2214,3,1,32,'2022-05-11 10:20:00','2022-05-11 10:35:00',900,'Assistenza su pc client Luca per problemi con Java, finisce cla nel pomeriggio',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-01-23 16:45:17','2022-05-11'),
(2215,3,1,75,'2022-05-11 10:35:00','2022-05-11 10:45:00',600,'Assistenza su pc casa Federico che non trovava il modo di collegarsi alla vpn',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-21 14:06:45','2022-05-11'),
(2216,1,1,3,'2022-05-12 06:30:00','2022-05-12 08:30:00',7200,'aiutato fede per preparazione consegna server toi,\r\nsistemato pc anna con ssd clonato\r\nabvolt problema vpn parlato al tel',90,NULL,45,1,'Europe/Rome',90,1,'work','2022-07-08 12:41:06','2022-05-12'),
(2217,1,1,29,'2022-05-12 09:00:00','2022-05-12 11:00:00',7200,'Configurazione server nuovo, fede li per montaggio e configurazione server nuovo e client',90,NULL,45,1,'Europe/Rome',90,1,'work','2022-05-12 15:04:00','2022-05-12'),
(2218,3,2,95,'2022-05-12 12:45:00','2022-05-12 13:10:00',1500,'Riconsegnato e configurato pc client Silvia dopo upgrade hw e clonazione s.o',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-12 13:57:43','2022-05-12'),
(2219,1,1,29,'2022-05-12 12:43:00','2022-05-12 16:15:00',12720,'Configurazione Backup, copia dati da vecchio server a nuovo, sistemazione configurazioni di rete e compilazione scheda cliente su kimai',159,NULL,45,1,'Europe/Rome',159,1,'work','2022-07-01 09:03:19','2022-05-12'),
(2220,3,2,29,'2022-05-12 07:55:00','2022-05-12 11:15:00',12000,'Consegnato e configurato nuovo server linux e nuovo ups apc, verificato funzionamento di tutti i dispositivi client dopo cambio server',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-01 09:03:17','2022-05-12'),
(2221,3,4,95,'2022-05-12 06:30:00','2022-05-12 07:30:00',3600,'Assistenza su pc client Silvia per upgrade hw e clonazione s.o\r\nUtilizzato: ssd 480gb + 8gb ddr3',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-16 14:12:36','2022-05-12'),
(2222,3,1,100,'2022-05-12 13:35:00','2022-05-12 13:45:00',600,'Assistenza su pc client Veronica per problema posta',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-11 09:36:19','2022-05-12'),
(2223,3,1,67,'2022-05-12 13:50:00','2022-05-12 14:20:00',1800,'Recuperato dati mail attive e spazio occupato e inviato ad Andrea',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-14 10:26:33','2022-05-12'),
(2224,3,2,18,'2022-05-13 12:35:00','2022-05-13 13:15:00',2400,'Assistenza su stampante Brother \r\nAssistenza su PC client',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-08 17:04:09','2022-05-13'),
(2225,1,1,90,'2022-05-13 06:48:00','2022-05-13 07:30:00',2520,'iniziato agg server',31.5,NULL,45,1,'Europe/Rome',31.5,1,'work','2022-07-12 15:55:45','2022-05-13'),
(2226,1,1,90,'2022-05-13 09:40:00','2022-05-13 10:20:00',2400,'agg server',30,NULL,45,1,'Europe/Rome',30,1,'work','2022-07-12 15:55:47','2022-05-13'),
(2227,1,1,50,'2022-05-13 12:45:00','2022-05-13 14:08:00',4980,'problema mail spam',62.25,NULL,45,1,'Europe/Rome',62.25,1,'work','2022-06-08 09:38:58','2022-05-13'),
(2228,3,2,96,'2022-05-13 14:15:00','2022-05-13 15:15:00',3600,'Ricollegato postazioni client dopo spostamento postazione Federica e Roberta, assistenza per configurazione interni telefoni\r\nUtilizzato switch 8 porte',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-08 16:26:51','2022-05-13'),
(2229,3,2,17,'2022-05-16 07:55:00','2022-05-16 08:35:00',2400,'Assistenza su firewall per problemi durante l\'avvio',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-08 13:09:17','2022-05-16'),
(2230,3,2,64,'2022-05-16 09:15:00','2022-05-16 09:40:00',1500,'Assistenza per problemi e recupero password Wifi',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-20 15:32:08','2022-05-16'),
(2231,1,1,55,'2022-05-16 06:37:00','2022-05-16 06:50:00',780,'problemi connettività',9.75,NULL,45,1,'Europe/Rome',9.75,1,'work','2022-07-08 15:29:56','2022-05-16'),
(2232,1,1,17,'2022-05-16 07:00:00','2022-05-16 07:10:00',600,'problma collegamento firewall',7.5,NULL,45,1,'Europe/Rome',7.5,1,'work','2022-07-08 13:09:20','2022-05-16'),
(2233,1,2,55,'2022-05-16 07:50:00','2022-05-16 08:10:00',1200,'controllo per mancanza connettività, firewall spento\r\nritirato vecchio server per trasformarlo in firewall',15,NULL,45,1,'Europe/Rome',15,1,'work','2022-07-08 15:29:57','2022-05-16'),
(2234,1,1,55,'2022-05-16 08:36:00','2022-05-16 10:27:00',6660,'reinstallazione firewall',83.25,NULL,45,1,'Europe/Rome',83.25,1,'work','2022-07-08 15:29:57','2022-05-16'),
(2235,1,4,3,'2022-05-16 12:30:00','2022-05-16 14:23:00',6780,'sostituzione dischi su server libro e reinstallazione',84.75,NULL,45,1,'Europe/Rome',84.75,1,'work','2022-07-08 12:59:45','2022-05-16'),
(2236,1,1,55,'2022-05-16 14:47:00','2022-05-16 16:16:00',5340,'installazione debian su nuovo server aggiornamento firmware e  bios',66.75,NULL,45,1,'Europe/Rome',66.75,1,'work','2022-07-08 15:29:58','2022-05-16'),
(2237,3,1,41,'2022-05-16 13:15:00','2022-05-16 13:30:00',900,'Installata 1 licenza nod32 completa su 2 pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-06-08 10:06:56','2022-05-16'),
(2238,3,2,91,'2022-05-17 09:00:00','2022-05-17 09:15:00',900,'Consegna e installazione nuovo fotoconduttore stampante Epson, consegna toner compatibile',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-29 13:33:44','2022-05-17'),
(2239,3,2,10,'2022-05-17 09:25:00','2022-05-17 10:35:00',4200,'Verificato e configurato portatile per arrivo nuova dipendente, assistenza su cellulare aziendale',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-13 09:22:08','2022-05-17'),
(2240,3,2,24,'2022-05-17 12:30:00','2022-05-17 12:40:00',600,'Consegnate 2 cartucce nere originali per stampanti Epson',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-07 12:53:00','2022-05-17'),
(2241,1,1,75,'2022-05-17 12:58:00','2022-05-17 13:10:34',754,'problòema vpn commercialista',9.43,NULL,45,1,'Europe/Rome',9.43,1,'work','2022-09-21 14:06:46','2022-05-17'),
(2242,1,1,101,'2022-05-17 14:25:00','2022-05-17 16:22:00',7020,'problemi di spam in uscita dal loro dominio',87.75,NULL,45,1,'Europe/Rome',87.75,1,'work','2022-07-11 07:54:55','2022-05-17'),
(2243,3,1,10,'2022-05-17 12:45:00','2022-05-17 13:00:00',900,'Assistenza su pc client Francesca',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-13 09:22:09','2022-05-17'),
(2244,3,1,96,'2022-05-17 13:05:00','2022-05-17 13:25:00',1200,'Assistenza su pc client Federica',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-08 16:26:29','2022-05-17'),
(2245,3,1,18,'2022-05-17 16:20:00','2022-05-17 16:40:00',1200,'Assistenza su pc client per problema pec',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-08 17:04:21','2022-05-17'),
(2246,1,3,112,'2022-05-17 12:30:00','2022-05-17 12:50:00',1200,NULL,15,NULL,45,1,'Europe/Rome',15,1,'work','2022-07-08 10:59:21','2022-05-17'),
(2247,1,1,2,'2022-05-17 06:46:00','2022-05-17 10:21:00',12900,'migrazione firewall',161.25,NULL,45,1,'Europe/Rome',161.25,1,'work','2022-07-08 10:17:10','2022-05-17'),
(2248,1,3,112,'2022-05-13 07:40:00','2022-05-13 09:30:00',6600,NULL,82.5,NULL,45,1,'Europe/Rome',82.5,1,'work','2022-07-08 10:59:20','2022-05-13'),
(2249,1,1,2,'2022-05-18 06:38:00','2022-05-18 07:47:00',4140,'migrazione firewall',51.75,NULL,45,1,'Europe/Rome',51.75,1,'work','2022-07-08 10:17:11','2022-05-18'),
(2250,1,6,55,'2022-05-18 08:03:00','2022-05-18 08:49:00',2760,'con bazacco per collegamento autonomo a server lybro e ultimi test su firewall migrato',34.5,NULL,45,1,'Europe/Rome',34.5,1,'work','2022-07-08 15:29:58','2022-05-18'),
(2251,1,1,55,'2022-05-18 10:08:00','2022-05-18 11:13:00',3900,'fede li a riconsegnare firewall configurazioni finali',48.75,NULL,45,1,'Europe/Rome',48.75,1,'work','2022-07-08 15:29:59','2022-05-18'),
(2252,1,1,9,'2022-05-18 14:45:00','2022-05-18 16:15:00',5400,'migrazione nas',67.5,NULL,45,1,'Europe/Rome',67.5,1,'work','2022-06-29 09:02:13','2022-05-18'),
(2253,3,2,55,'2022-05-18 09:30:00','2022-05-18 11:15:00',6300,'Consegnato, installato e configurato nuovo Firewall\r\nUtilizzato ripiano per armadio rack',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-08 15:30:04','2022-05-18'),
(2254,3,1,24,'2022-05-18 14:25:00','2022-05-18 14:45:00',1200,'Assistenza su pc client Gommista per problemi posta',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-07 13:00:19','2022-05-18'),
(2255,1,1,2,'2022-05-19 06:33:00','2022-05-19 07:29:44',3404,'Laura probabile virus ricevuto via mail',42.55,NULL,45,1,'Europe/Rome',42.55,1,'work','2022-09-21 15:45:21','2022-05-19'),
(2256,1,1,55,'2022-05-19 09:09:00','2022-05-19 09:42:40',2020,'problemi stampa otto\r\nconnessione remota bazacco su server lybro',25.25,NULL,45,1,'Europe/Rome',25.25,1,'work','2022-07-08 15:29:59','2022-05-19'),
(2257,1,1,2,'2022-05-19 07:53:00','2022-05-19 08:52:00',3540,'firewall nuovo',44.25,NULL,45,1,'Europe/Rome',44.25,1,'work','2022-09-21 15:46:44','2022-05-19'),
(2258,1,1,9,'2022-05-19 07:40:00','2022-05-19 07:50:00',600,'Configurazione pc elena',7.5,NULL,45,1,'Europe/Rome',7.5,1,'work','2022-06-29 09:02:14','2022-05-19'),
(2259,1,1,2,'2022-05-18 12:47:00','2022-05-18 14:30:00',6180,'firewall nuovo',77.25,NULL,45,1,'Europe/Rome',77.25,1,'work','2022-07-08 10:17:14','2022-05-18'),
(2260,1,1,9,'2022-05-19 09:45:00','2022-05-19 10:10:00',1500,'configurazione pc walter su nuovo nas',18.75,NULL,45,1,'Europe/Rome',18.75,1,'work','2022-06-29 09:02:15','2022-05-19'),
(2261,1,1,29,'2022-05-19 12:50:00','2022-05-19 16:19:00',12540,'fine config server nuovo',156.75,NULL,45,1,'Europe/Rome',156.75,1,'work','2022-07-01 09:03:21','2022-05-19'),
(2262,3,1,96,'2022-05-19 07:30:00','2022-05-19 07:45:00',900,'Assistenza su pc client Cristina per installazione Entratel',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-08 16:26:23','2022-05-19'),
(2263,3,1,96,'2022-05-19 09:30:00','2022-05-19 09:45:00',900,'Assistenza su pc client Cristina per problemi Desktop Telematico e scansione di rete',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-08 16:26:27','2022-05-19'),
(2264,3,1,18,'2022-05-19 14:05:00','2022-05-19 14:20:00',900,'Assistenza su pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-08 17:04:16','2022-05-19'),
(2265,1,3,112,'2022-05-20 06:30:00','2022-05-20 08:50:00',8400,NULL,105,NULL,45,1,'Europe/Rome',105,1,'work','2022-07-08 10:59:16','2022-05-20'),
(2266,1,1,96,'2022-05-20 09:10:00','2022-05-20 09:52:00',2520,'creazione account temp su nostro nextcloud per trasferimento cartella da pc su server gandolfo',31.5,NULL,45,1,'Europe/Rome',31.5,1,'work','2022-07-08 16:26:27','2022-05-20'),
(2267,3,2,29,'2022-05-20 07:45:00','2022-05-20 10:30:00',9900,'Configurazione nuovo PC client studio Blu + installazione e configurazione Xdent, ritirato ups da rigenerare, pulizia periodica pc client e server, collegato nuovo server a nuovo ups via usb',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-01 09:03:51','2022-05-20'),
(2268,1,1,29,'2022-05-20 14:33:00','2022-05-20 16:30:00',7020,'configurazione backup remoti proxmox',87.75,NULL,45,1,'Europe/Rome',87.75,1,'work','2022-07-01 09:03:41','2022-05-20'),
(2269,3,2,96,'2022-05-20 13:00:00','2022-05-20 15:00:00',7200,'Assistenza su PC client Cristina per problemi con software Agenzia delle Entrate',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-08 16:26:39','2022-05-20'),
(2270,1,1,96,'2022-05-23 08:00:00','2022-05-23 09:39:00',5940,'nuovo share e import dati',74.25,NULL,45,1,'Europe/Rome',74.25,1,'work','2022-07-08 16:26:53','2022-05-23'),
(2271,3,2,96,'2022-05-23 08:45:00','2022-05-23 10:45:00',7200,'Messo in rete e configurato PC client vecchio ufficio Cristina Musso, assistenza per problemi telefoni e internet, configurato e copiato dati su nuovo share\r\nUtilizzato 1 cavo di rete da 2mt',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-08 16:26:29','2022-05-23'),
(2272,1,1,114,'2022-05-23 13:31:00','2022-05-23 14:08:00',2220,'verifiche problemi linea',27.75,NULL,45,1,'Europe/Rome',27.75,1,'work','2022-07-05 14:38:52','2022-05-23'),
(2273,1,1,29,'2022-05-23 14:31:00','2022-05-23 16:30:00',7140,'migrazione server',89.25,NULL,45,1,'Europe/Rome',89.25,1,'work','2022-07-01 09:03:44','2022-05-23'),
(2274,3,1,96,'2022-05-23 12:40:00','2022-05-23 13:10:00',1800,'Ultimato lavoro passaggio dati da pc Cristina Musso in corso Europa a server Studio Gandolfo',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-08 16:26:43','2022-05-23'),
(2275,3,1,26,'2022-05-23 15:00:00','2022-05-23 15:10:00',600,'Installata 1 licenza aggiornamento nod32 su pc client Dott. Sola',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-05-25 13:06:34','2022-05-23'),
(2276,1,1,29,'2022-05-24 06:20:00','2022-05-24 06:50:00',1800,'migrazione server',22.5,NULL,45,1,'Europe/Rome',22.5,1,'work','2022-07-01 09:03:48','2022-05-24'),
(2277,1,1,2,'2022-05-24 06:50:00','2022-05-24 10:31:50',13310,'problemi mail fra\r\nagg roundcube mail su firewall\r\nsincro dati fireall vecchi nuovo',166.38,NULL,45,1,'Europe/Rome',166.38,1,'work','2022-09-21 15:46:20','2022-05-24'),
(2278,3,2,83,'2022-05-24 10:20:00','2022-05-24 10:30:00',600,'Installata 1 licenza nod32 aggiornamento su 2 PC client',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-10-04 15:46:06','2022-05-24'),
(2279,3,1,96,'2022-05-24 07:25:00','2022-05-24 07:35:00',600,'Assistenza su pc client Federica',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-08 16:26:54','2022-05-24'),
(2280,1,1,2,'2022-05-24 12:45:00','2022-05-24 16:24:00',13140,'problemi mail fra\r\nagg roundcube mail su firewall\r\nsincro dati fireall vecchi nuovo',164.25,NULL,45,1,'Europe/Rome',164.25,1,'work','2022-09-21 15:46:21','2022-05-24'),
(2281,3,1,96,'2022-05-24 12:50:00','2022-05-24 13:05:00',900,'Assistenza su pc client Cristina',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-08 16:26:55','2022-05-24'),
(2282,3,1,96,'2022-05-24 15:20:00','2022-05-24 15:40:00',1200,'Assistenza su pc client Cristina',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-08 16:26:26','2022-05-24'),
(2283,1,1,29,'2022-05-25 06:30:00','2022-05-25 10:27:00',14220,'server inchiodato per colpa di backup remoto',177.75,NULL,45,1,'Europe/Rome',177.75,1,'work','2022-07-01 09:04:03','2022-05-25'),
(2284,3,2,96,'2022-05-25 07:30:00','2022-05-25 09:10:00',6000,'Sostituzione batteria su ups apc, assistenza su PC client Maria, Marilena, Cristina e Martina\r\nUtilizzato 1 batteria ups',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-08 16:26:40','2022-05-25'),
(2285,3,2,26,'2022-05-25 14:10:00','2022-05-25 14:30:00',1200,'Consegna toner compatibili stampante Brother \r\nVerificato sta.stampante Brother',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-06-29 09:07:14','2022-05-25'),
(2286,1,1,87,'2022-05-25 14:30:00','2022-05-25 15:51:00',4860,'problemi vecchiio server e backup\r\nconfigurazione dhcp',60.75,NULL,45,1,'Europe/Rome',60.75,1,'work','2022-06-08 10:05:00','2022-05-25'),
(2287,3,1,67,'2022-05-25 15:05:00','2022-05-25 15:15:00',600,'Cambiata password su indirizzo mail massimo.serra@mediaphone.it',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-14 10:26:34','2022-05-25'),
(2288,3,2,87,'2022-05-26 08:50:00','2022-05-26 09:20:00',1800,'Risolto problema su PC cliet che non si avviava',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-06-08 10:05:02','2022-05-26'),
(2289,1,1,29,'2022-05-26 06:45:00','2022-05-26 10:21:00',12960,'backup su nas e sistemazione altri',162,NULL,45,1,'Europe/Rome',162,1,'work','2022-07-01 09:04:16','2022-05-26'),
(2290,1,1,96,'2022-05-26 12:49:00','2022-05-26 13:20:00',1860,'problemi spazio duisco',23.25,NULL,45,1,'Europe/Rome',23.25,1,'work','2022-07-08 16:26:34','2022-05-26'),
(2291,1,1,29,'2022-05-25 12:44:00','2022-05-25 14:17:00',5580,'problemi backup e raggiugnbilità nas\r\nproblemi martian soruce',69.75,NULL,45,1,'Europe/Rome',69.75,1,'work','2022-07-01 09:04:07','2022-05-25'),
(2292,1,1,29,'2022-05-25 16:00:00','2022-05-25 16:28:00',1680,'problemi martian soruce con alex element',21,NULL,45,1,'Europe/Rome',21,1,'work','2022-07-01 09:04:12','2022-05-25'),
(2293,1,1,114,'2022-05-26 13:40:00','2022-05-26 15:00:25',4825,'test di velocità vpn',60.31,NULL,45,1,'Europe/Rome',60.31,1,'work','2022-07-05 14:38:53','2022-05-26'),
(2294,1,1,96,'2022-05-26 15:15:00','2022-05-26 16:27:00',4320,'problemi spazio',54,NULL,45,1,'Europe/Rome',54,1,'work','2022-07-08 16:26:34','2022-05-26'),
(2295,3,1,96,'2022-05-27 08:50:00','2022-05-27 09:20:00',1800,'Assistenza su pc client Cristina Musso in corso Europa per installazione vpn e collegamento in rdp',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-08 16:26:30','2022-05-27'),
(2296,3,1,79,'2022-05-27 13:45:00','2022-05-27 14:00:00',900,'Assistenza su pc client Paola per problema con Word',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-06 15:33:25','2022-05-27'),
(2297,1,1,29,'2022-05-28 06:30:00','2022-05-28 07:10:00',2400,'server inchiodato per colpa di nas inchiodato',30,NULL,45,1,'Europe/Rome',30,1,'work','2022-07-01 09:04:17','2022-05-28'),
(2298,3,2,108,'2022-05-30 13:40:00','2022-05-30 14:00:00',1200,'Verificato e ritirato pc client Biglietteria',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-10-04 14:15:09','2022-05-30'),
(2299,3,1,5,'2022-05-30 07:20:00','2022-05-30 07:40:00',1200,'Assistenza su pc client Paola per problema con Microsoft SilverLight',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-01-17 17:22:20','2022-05-30'),
(2300,3,1,95,'2022-05-30 09:05:00','2022-05-30 09:15:00',600,'Assistenza su pc client Anna per problemi posta',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-07 14:19:10','2022-05-30'),
(2301,3,1,88,'2022-05-30 09:15:00','2022-05-30 09:30:00',900,'Assistenza per problema funzionamento 3cx',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-06 14:41:31','2022-05-30'),
(2302,3,1,79,'2022-05-30 12:45:00','2022-05-30 13:15:00',1800,'Creata e configurata nuova casella di posta su pc client nuova dipendente',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-06 15:33:26','2022-05-30'),
(2303,3,1,88,'2022-05-30 14:30:00','2022-05-30 14:50:00',1200,'Assistenza su server per problemi ricezione posta',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-06 14:49:53','2022-05-30'),
(2304,3,1,26,'2022-05-30 15:00:00','2022-05-30 15:30:00',1800,'Assistenza su pc client Banci per problemi con Word e Outlook',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-10-07 15:45:02','2022-05-30'),
(2305,3,1,84,'2022-05-30 15:45:00','2022-05-30 16:00:00',900,'Assistenza per problemi wifi a casa, da verificare in loco',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-13 10:08:26','2022-05-30'),
(2306,1,4,3,'2022-05-30 13:29:00','2022-05-30 14:17:00',2880,'problemi mac',36,NULL,45,1,'Europe/Rome',36,1,'work','2022-07-08 12:59:47','2022-05-30'),
(2307,1,1,3,'2022-05-30 14:52:00','2022-05-30 15:47:00',3300,'mac disco rotto',41.25,NULL,45,1,'Europe/Rome',41.25,1,'work','2022-07-08 12:59:51','2022-05-30'),
(2308,1,1,29,'2022-05-30 06:50:00','2022-05-30 10:21:00',12660,'proxmox problemi backup',158.25,NULL,45,1,'Europe/Rome',158.25,1,'work','2022-07-01 09:04:18','2022-05-30'),
(2309,1,1,29,'2022-05-30 12:47:00','2022-05-30 13:19:00',1920,'proxmox problemi backup',24,NULL,45,1,'Europe/Rome',24,1,'work','2022-07-01 09:04:19','2022-05-30'),
(2310,1,1,108,'2022-05-31 07:52:00','2022-05-31 07:53:50',110,'problemi connettività',1.38,NULL,45,1,'Europe/Rome',1.38,1,'work','2022-10-04 14:08:34','2022-05-31'),
(2311,1,1,55,'2022-05-31 09:09:00','2022-05-31 10:32:27',5007,'pc riccardo perso profilo',62.59,NULL,45,1,'Europe/Rome',62.59,1,'work','2022-07-08 15:30:00','2022-05-31'),
(2312,3,2,41,'2022-05-31 09:35:00','2022-05-31 10:00:00',1500,'Verificato e ritirato ups apc 700 difettoso\r\nInstallato nuovo ups apc 500',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-06-08 13:47:46','2022-05-31'),
(2313,3,2,108,'2022-05-31 10:05:00','2022-05-31 10:45:00',2400,'Riconsegnato pc client Biglietteria dopo assistenza \r\nInstallato nuovo mouse usb\r\nAssistenza su server per problemi navigazione',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-10-04 14:15:22','2022-05-31'),
(2314,1,1,55,'2022-05-31 12:30:00','2022-05-31 13:12:00',2520,'pc riccardo perso profilo\r\nripristino pc fisso (da sostituire)\r\ntentativo di recupero dati da server (annullato tentativo dati non utili)\r\nproblema vm riccardo (rientrato da solo probabilmente procedura di collegamento errata)',31.5,NULL,45,1,'Europe/Rome',31.5,1,'work','2022-07-08 15:30:07','2022-05-31'),
(2315,3,2,84,'2022-05-31 15:30:00','2022-05-31 16:40:00',4200,'Assistenza su portatili per problemi con wifi\r\nOrdinare 2 extender wifi',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-13 10:08:27','2022-05-31'),
(2316,1,1,3,'2022-06-01 06:38:00','2022-06-01 06:51:00',780,'sidoti o Salani privato  con rpoblema stampante dopo che gli abbiamo riparato pc',9.75,NULL,45,1,'Europe/Rome',9.75,1,'work','2022-07-08 13:00:24','2022-06-01'),
(2317,3,4,108,'2022-05-31 07:00:00','2022-05-31 08:00:00',3600,'Assistenza su pc client Biglietteria ritirato',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-10-04 14:15:10','2022-05-31'),
(2318,3,1,95,'2022-05-31 08:45:00','2022-05-31 08:55:00',600,'Assistenza su pc client Anna',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-07 14:19:12','2022-05-31'),
(2319,3,1,55,'2022-05-31 08:55:00','2022-05-31 09:10:00',900,'Assistenza su pc client Dellavalle',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-08 15:30:05','2022-05-31'),
(2320,3,1,27,'2022-05-31 13:00:00','2022-05-31 13:30:00',1800,'Assistenza su siti web',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-08 10:44:45','2022-05-31'),
(2321,1,1,67,'2022-05-02 14:17:00','2022-05-02 16:20:00',7380,'problemi spam',92.25,NULL,45,1,'Europe/Rome',92.25,1,'work','2022-09-14 10:26:31','2022-05-02'),
(2322,1,1,41,'2022-05-03 06:46:00','2022-05-03 07:47:00',3660,'controllo server',45.75,NULL,45,1,'Europe/Rome',45.75,1,'work','2022-06-08 13:47:29','2022-05-03'),
(2323,1,1,3,'2022-05-03 14:00:00','2022-05-03 16:30:00',9000,'proxmox e container',112.5,NULL,45,1,'Europe/Rome',112.5,1,'work','2022-07-08 12:40:39','2022-05-03'),
(2324,1,1,96,'2022-05-04 06:53:00','2022-05-04 07:18:00',1500,'copia dati recuperati',18.75,NULL,45,1,'Europe/Rome',18.75,1,'work','2022-07-08 16:26:21','2022-05-04'),
(2325,1,1,3,'2022-05-04 07:24:00','2022-05-04 08:58:00',5640,'sistemazione mail di backup vari clienti',70.5,NULL,45,1,'Europe/Rome',70.5,1,'work','2022-07-08 12:40:40','2022-05-04'),
(2326,1,1,50,'2022-05-04 09:18:00','2022-05-04 10:21:00',3780,'problema allegati',47.25,NULL,45,1,'Europe/Rome',47.25,1,'work','2022-06-08 09:38:54','2022-05-04'),
(2327,1,1,50,'2022-05-04 12:48:00','2022-05-04 14:40:00',6720,'problema mail spam test clamav',84,NULL,45,1,'Europe/Rome',84,1,'work','2022-06-08 09:38:55','2022-05-04'),
(2328,1,1,3,'2022-05-04 14:50:00','2022-05-04 16:30:00',6000,'test implementazione sanesecurity su server linux con rspamd clamv',75,NULL,45,1,'Europe/Rome',75,1,'work','2022-07-08 12:40:46','2022-05-04'),
(2329,1,4,3,'2022-05-05 06:30:00','2022-05-05 07:00:00',1800,'in lab',22.5,NULL,45,1,'Europe/Rome',22.5,1,'work','2022-07-08 12:40:48','2022-05-05'),
(2330,1,1,3,'2022-05-05 07:20:00','2022-05-05 08:49:00',5340,'sanesecurity clamab',66.75,NULL,45,1,'Europe/Rome',66.75,1,'work','2022-07-08 12:40:49','2022-05-05'),
(2331,1,1,10,'2022-05-05 09:00:00','2022-05-05 10:29:00',5340,'agg antispam antivirus server posta',66.75,NULL,45,1,'Europe/Rome',66.75,1,'work','2022-09-22 09:38:41','2022-05-05'),
(2332,1,1,1,'2022-05-05 12:43:00','2022-05-05 14:36:00',6780,'agg server e 3cx',84.75,NULL,45,1,'Europe/Rome',84.75,1,'work','2022-07-11 10:20:08','2022-05-05'),
(2333,1,1,3,'2022-05-05 15:01:00','2022-05-05 16:22:00',4860,'test per agg proxmox da 6.4 a ver 7',60.75,NULL,45,1,'Europe/Rome',60.75,1,'work','2022-07-08 12:40:50','2022-05-05'),
(2334,1,1,3,'2022-05-11 13:34:00','2022-05-11 16:30:00',10560,'varie proxmox e ufficio',132,NULL,45,1,'Europe/Rome',132,1,'work','2022-07-08 12:40:56','2022-05-11'),
(2335,1,1,5,'2022-05-11 06:45:00','2022-05-11 09:00:00',8100,'agg server',101.25,NULL,45,1,'Europe/Rome',101.25,1,'work','2022-07-05 15:20:53','2022-05-11'),
(2336,1,1,2,'2022-05-11 09:11:00','2022-05-11 10:30:00',4740,'agg server',59.25,NULL,45,1,'Europe/Rome',59.25,1,'work','2022-07-08 09:30:41','2022-05-11'),
(2337,1,3,112,'2022-05-13 14:10:00','2022-05-13 16:30:00',8400,NULL,105,NULL,45,1,'Europe/Rome',105,1,'work','2022-07-08 10:59:24','2022-05-13'),
(2338,1,4,3,'2022-05-20 12:30:00','2022-05-20 14:30:00',7200,'vari lab',90,NULL,45,1,'Europe/Rome',90,1,'work','2022-07-08 12:59:46','2022-05-20'),
(2339,1,1,79,'2022-05-23 06:47:00','2022-05-23 07:58:00',4260,'agg vm e tentativo agg postfixadmin',53.25,NULL,45,1,'Europe/Rome',53.25,1,'work','2022-07-06 15:33:24','2022-05-23'),
(2340,1,1,79,'2022-05-23 09:49:00','2022-05-23 10:30:00',2460,'tentativo agg postfixadmin',30.75,NULL,45,1,'Europe/Rome',30.75,1,'work','2022-07-06 15:33:25','2022-05-23'),
(2341,1,1,3,'2022-05-31 14:45:00','2022-05-31 16:30:00',6300,'in lab mac ecc',78.75,NULL,45,1,'Europe/Rome',78.75,1,'work','2022-07-08 13:00:23','2022-05-31'),
(2342,1,1,29,'2022-05-31 13:23:00','2022-05-31 14:43:00',4800,'test backup proxmox',60,NULL,45,1,'Europe/Rome',60,1,'work','2022-07-01 09:04:22','2022-05-31'),
(2343,1,1,108,'2022-06-01 09:57:00','2022-06-01 10:20:00',1380,'problema software dymo',17.25,NULL,45,1,'Europe/Rome',17.25,1,'work','2022-10-04 14:24:31','2022-06-01'),
(2344,1,3,112,'2022-05-23 12:30:00','2022-05-23 13:20:00',3000,NULL,37.5,NULL,45,1,'Europe/Rome',37.5,1,'work','2022-07-08 10:59:19','2022-05-23'),
(2345,1,1,3,'2022-05-31 06:30:00','2022-05-31 07:40:00',4200,'proxmox backup',52.5,NULL,45,1,'Europe/Rome',52.5,1,'work','2022-07-08 13:00:35','2022-05-31'),
(2346,1,1,3,'2022-06-01 08:41:00','2022-06-01 09:51:00',4200,'fogli',52.5,NULL,45,1,'Europe/Rome',52.5,1,'work','2022-07-08 13:00:22','2022-06-01'),
(2347,1,1,108,'2022-06-01 12:47:00','2022-06-01 15:16:00',8940,'problema software dymo',111.75,NULL,45,1,'Europe/Rome',111.75,1,'work','2022-10-04 14:24:32','2022-06-01'),
(2348,3,1,96,'2022-06-01 07:00:00','2022-06-01 07:30:00',1800,'Assistenza su pc client Cristina per collegamento al pc di Corso Europa',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-08 16:26:30','2022-06-01'),
(2349,3,1,55,'2022-06-01 08:10:00','2022-06-01 08:20:00',600,'Installata 1 licenza nod32 aggiornamento su 2 pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-08 15:30:01','2022-06-01'),
(2350,3,1,79,'2022-06-01 13:00:00','2022-06-01 13:10:00',600,'Assistenza su pc client Paola Agnoletto',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-06 15:33:26','2022-06-01'),
(2351,3,1,18,'2022-06-01 13:40:00','2022-06-01 14:00:00',1200,'Assistenza su pc client per problema con software fatturazione elettronica',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-08 17:04:16','2022-06-01'),
(2352,3,1,96,'2022-06-01 14:10:00','2022-06-01 14:20:00',600,'Registrato messaggio segreteria per ponte 2 giugno',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-06-16 09:34:40','2022-06-01'),
(2353,3,1,10,'2022-06-01 15:00:00','2022-06-01 15:10:00',600,'Assistenza su pc client Francesca',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-13 09:22:20','2022-06-01'),
(2354,3,1,95,'2022-06-01 15:10:00','2022-06-01 15:20:00',600,'Assistenza su pc client Anna',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-07 14:19:13','2022-06-01'),
(2355,3,4,115,'2022-06-01 15:45:00','2022-06-01 16:15:00',1800,'Modifiche sito web',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-08 10:57:32','2022-06-01'),
(2356,1,1,101,'2022-06-03 08:09:00','2022-06-03 08:23:43',883,'problemi connessione vpn',11.04,NULL,45,1,'Europe/Rome',11.04,1,'work','2022-07-11 07:54:57','2022-06-03'),
(2357,1,1,101,'2022-06-03 08:37:00','2022-06-03 09:03:00',1560,'problemi connessione vpn',19.5,NULL,45,1,'Europe/Rome',19.5,1,'work','2022-07-11 07:54:59','2022-06-03'),
(2358,1,1,67,'2022-06-03 07:50:00','2022-06-03 08:07:00',1020,'verifiche per cambio linea',12.75,NULL,45,1,'Europe/Rome',12.75,1,'work','2022-09-14 10:26:36','2022-06-03'),
(2359,1,1,67,'2022-06-03 08:24:00','2022-06-03 08:36:00',720,'verifiche per cambio linea',9,NULL,45,1,'Europe/Rome',9,1,'work','2022-09-14 10:26:38','2022-06-03'),
(2360,3,1,64,'2022-06-06 09:30:00','2022-06-06 09:40:00',600,'Installata 1 licenza nod32 aggiornamento su 2 pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-06-08 13:58:44','2022-06-06'),
(2361,3,1,41,'2022-06-06 13:20:00','2022-06-06 13:35:00',900,'Installate 2 licenze nod32 aggiornamento su 4 pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-06-08 13:47:28','2022-06-06'),
(2362,3,1,79,'2022-06-06 14:10:00','2022-06-06 14:25:00',900,'Assistenza su pc client Logistica',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-06 15:33:33','2022-06-06'),
(2363,3,1,87,'2022-06-06 15:10:00','2022-06-06 15:20:00',600,'Installata 1 licenza nod32 aggiornamento su 2 pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-06-08 10:05:03','2022-06-06'),
(2364,3,1,50,'2022-06-06 15:25:00','2022-06-06 15:35:00',600,'Installata 1 licenza nod32 aggiornamento su 1 pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-06-08 09:38:59','2022-06-06'),
(2365,1,4,3,'2022-06-06 12:30:00','2022-06-06 14:14:00',6240,'mac guasto',78,NULL,45,1,'Europe/Rome',78,1,'work','2022-07-08 13:00:18','2022-06-06'),
(2366,1,1,29,'2022-06-07 08:37:00','2022-06-07 10:28:00',6660,'backup remoto',83.25,NULL,45,1,'Europe/Rome',83.25,1,'work','2022-07-01 09:04:23','2022-06-07'),
(2367,1,1,29,'2022-06-07 12:38:00','2022-06-07 13:31:00',3180,'backup remoto',39.75,NULL,45,1,'Europe/Rome',39.75,1,'work','2022-07-01 09:04:24','2022-06-07'),
(2368,1,1,3,'2022-06-07 13:42:00','2022-06-07 17:00:00',11880,'mepa',148.5,NULL,45,1,'Europe/Rome',148.5,1,'work','2022-07-08 13:00:10','2022-06-07'),
(2369,3,1,79,'2022-06-07 06:45:00','2022-06-07 07:00:00',900,'Assistenza su pc client Logistica',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-06 15:33:29','2022-06-07'),
(2370,3,1,90,'2022-06-07 07:05:00','2022-06-07 07:25:00',1200,'Assistenza su server Windows per problemi accesso ad Ufficius',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-12 15:55:48','2022-06-07'),
(2371,3,1,90,'2022-06-07 07:55:00','2022-06-07 08:05:00',600,'Assistenza per problemi ricenzione posta elettronica',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-12 15:55:49','2022-06-07'),
(2372,3,1,10,'2022-06-07 10:35:00','2022-06-07 10:50:00',900,'Assistenza su pc client Francesca',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-13 09:22:44','2022-06-07'),
(2373,1,1,29,'2022-06-08 06:50:00','2022-06-08 08:09:00',4740,'backup remoto',59.25,NULL,45,1,'Europe/Rome',59.25,1,'work','2022-07-01 09:04:25','2022-06-08'),
(2374,1,1,3,'2022-06-08 12:40:00','2022-06-08 13:50:00',4200,'mepa',52.5,NULL,45,1,'Europe/Rome',52.5,1,'work','2022-07-08 13:00:01','2022-06-08'),
(2375,3,1,35,'2022-06-08 07:10:00','2022-06-08 08:10:00',3600,'Assistenza su pc client per problemi con indirizzo Gmail configurato su Outlook',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-22 16:00:02','2022-06-08'),
(2376,3,1,26,'2022-06-08 09:20:00','2022-06-08 09:35:00',900,'Assistenza su pc client Banci per aggiornamento firmware stampante',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-10-07 15:45:03','2022-06-08'),
(2377,3,1,59,'2022-06-08 10:10:00','2022-06-08 10:20:00',600,'Installata 1 licenza nod32 aggiornamento su 2 pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-06-09 08:16:17','2022-06-08'),
(2378,3,1,79,'2022-06-08 13:10:00','2022-06-08 13:30:00',1200,'Configurato indirizzo mail logistica@parodinutra.com su pc client Paolo, Elena e Paola',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-06 15:33:34','2022-06-08'),
(2379,3,1,96,'2022-06-08 15:30:00','2022-06-08 15:40:00',600,'Assistenza per collegamento pc client Cristina diretto alla corrente causa ups guasto',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-08 16:26:35','2022-06-08'),
(2380,3,2,41,'2022-06-09 07:50:00','2022-06-09 08:10:00',1200,'Verificato e ritirato ups apc 700 danneggiato',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-07 12:43:51','2022-06-09'),
(2381,3,2,96,'2022-06-09 09:10:00','2022-06-09 09:40:00',1800,'Assistenza su ups apc postazione Cristina\r\nAssistenza su PC client',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-08 16:26:38','2022-06-09'),
(2382,1,1,85,'2022-06-09 12:30:00','2022-06-09 13:46:09',4569,'problema spazio mail giacomo, ripulita casella\r\nCreata utenza amministrativa su gestore mail per i dominio rellecati.com e refassicurazioni.it\r\ninsegnato a giacomo come loggare via webmail e come cancellare le mail su roundcube',57.11,NULL,45,1,'Europe/Rome',57.11,1,'work','2022-09-16 16:24:50','2022-06-09'),
(2383,1,3,112,'2022-06-09 07:20:00','2022-06-09 10:30:00',11400,'recita matteo',142.5,NULL,45,1,'Europe/Rome',142.5,1,'work','2022-07-08 10:59:19','2022-06-09'),
(2384,1,1,3,'2022-06-09 13:50:00','2022-06-09 15:16:00',5160,'mepa modificat dati e rigenerati file per firma',64.5,NULL,45,1,'Europe/Rome',64.5,1,'work','2022-07-08 13:00:08','2022-06-09'),
(2385,3,1,50,'2022-06-09 10:20:00','2022-06-09 10:30:00',600,'Installata 1 licenza aggiornamento nod32 su 2 pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-06-13 10:34:23','2022-06-09'),
(2386,3,1,96,'2022-06-09 14:45:00','2022-06-09 15:15:00',1800,'Configurata mail Antonella su 3 pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-08 16:26:31','2022-06-09'),
(2387,1,3,112,'2022-06-10 07:00:00','2022-06-10 08:15:00',4500,NULL,56.25,NULL,45,1,'Europe/Rome',56.25,1,'work','2022-07-08 10:59:30','2022-06-10'),
(2388,1,1,79,'2022-06-10 08:30:00','2022-06-10 10:30:00',7200,'problemi invio mail da gestionale',90,NULL,45,1,'Europe/Rome',90,1,'work','2022-07-06 15:33:29','2022-06-10'),
(2389,3,2,10,'2022-06-10 12:45:00','2022-06-10 12:55:00',600,'Ritirato portatile per verificare upgrade hw',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-13 09:22:54','2022-06-10'),
(2390,1,6,9,'2022-06-10 13:15:00','2022-06-10 13:30:00',900,'problemi excel',11.25,NULL,45,1,'Europe/Rome',11.25,1,'work','2022-06-29 09:02:16','2022-06-10'),
(2391,1,6,9,'2022-06-10 14:22:00','2022-06-10 14:33:00',660,'problemi excel',8.25,NULL,45,1,'Europe/Rome',8.25,1,'work','2022-06-29 09:02:16','2022-06-10'),
(2392,3,2,53,'2022-06-10 13:05:00','2022-06-10 14:35:00',5400,'Passato cavo di rete nelle canaline per collegamento stampante + installazione, utilizzato cavo lan da 10 m\r\nAssistenza su PC client Tino\r\nConfigurazione extender wifi',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-11 08:21:56','2022-06-10'),
(2393,3,2,84,'2022-06-10 14:55:00','2022-06-10 15:25:00',1800,'Consegnati e configurati 2 nuovi extender tplink 43799',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-13 10:08:28','2022-06-10'),
(2394,3,2,50,'2022-06-10 15:45:00','2022-06-10 15:55:00',600,'Consegna 2 tamburi originali per stampanti Brother',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-06-13 10:34:24','2022-06-10'),
(2395,1,1,3,'2022-06-10 14:45:00','2022-06-10 16:30:00',6300,'test agg win srv',78.75,NULL,45,1,'Europe/Rome',78.75,1,'work','2022-07-08 13:00:18','2022-06-10'),
(2396,1,1,3,'2022-06-10 12:44:00','2022-06-10 13:13:00',1740,'test agg win srv',21.75,NULL,45,1,'Europe/Rome',21.75,1,'work','2022-07-08 13:00:02','2022-06-10'),
(2397,1,1,103,'2022-06-13 08:05:00','2022-06-13 09:48:00',6180,'3cx',77.25,NULL,45,1,'Europe/Rome',77.25,1,'work','2022-12-15 10:39:55','2022-06-13'),
(2398,3,2,96,'2022-06-13 07:45:00','2022-06-13 08:20:00',2100,'Risolto problema dispositivo spenti nell\'armadio rack',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-08 16:26:31','2022-06-13'),
(2399,3,2,88,'2022-06-13 08:50:00','2022-06-13 09:20:00',1800,'Verificato e ritirato ups apc armadio rack\r\nAssistenza su PC client Stefania',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-06 14:49:39','2022-06-13'),
(2400,1,1,9,'2022-06-13 10:00:00','2022-06-13 10:26:00',1560,'call con sistemista microsoft e elena per problemi nell\'uso di office 365',19.5,NULL,45,1,'Europe/Rome',19.5,1,'work','2022-06-29 09:02:17','2022-06-13'),
(2401,1,1,96,'2022-06-13 15:00:00','2022-06-13 15:55:41',3341,'fede li aiutato con ultimi casini',41.76,NULL,45,1,'Europe/Rome',41.76,1,'work','2022-06-16 09:33:56','2022-06-13'),
(2402,1,1,3,'2022-06-13 12:31:00','2022-06-13 13:00:00',1740,NULL,21.75,NULL,45,1,'Europe/Rome',21.75,1,'work','2022-07-08 13:00:11','2022-06-13'),
(2403,3,2,96,'2022-06-13 10:15:00','2022-06-13 16:30:00',22500,'Assistenza per problemi navigazione, scollegato dalla rete il server Gandolfo2 che da problemi allo switch\r\nAssistenza su pc client\r\nUtilizzato: sk di rete gigabit',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-08 16:26:38','2022-06-13'),
(2404,3,1,88,'2022-06-10 07:40:00','2022-06-10 07:55:00',900,'Assistenza su portatile casa Stefania',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-06 14:50:04','2022-06-10'),
(2405,3,1,115,'2022-06-10 08:50:00','2022-06-10 09:20:00',1800,'Finite modifiche su sito web',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-08 10:57:34','2022-06-10'),
(2406,1,1,96,'2022-06-14 09:37:00','2022-06-14 09:52:00',900,'problemi posta',11.25,NULL,45,1,'Europe/Rome',11.25,1,'work','2022-07-08 15:32:52','2022-06-14'),
(2407,1,1,3,'2022-06-14 12:40:00','2022-06-14 13:00:43',1243,'sito web online liguria fumi',15.54,NULL,45,1,'Europe/Rome',15.54,1,'work','2022-07-08 13:00:06','2022-06-14'),
(2408,1,1,3,'2022-06-14 13:02:00','2022-06-14 14:31:44',5384,'mepa',67.3,NULL,45,1,'Europe/Rome',67.3,1,'work','2022-07-08 13:00:37','2022-06-14'),
(2409,1,1,3,'2022-06-14 07:34:00','2022-06-14 09:20:00',6360,'mepa',79.5,NULL,45,1,'Europe/Rome',79.5,1,'work','2022-07-08 13:00:07','2022-06-14'),
(2410,1,1,3,'2022-06-14 10:00:00','2022-06-14 10:28:00',1680,'mepa',21,NULL,45,1,'Europe/Rome',21,1,'work','2022-07-08 13:00:03','2022-06-14'),
(2411,1,1,29,'2022-06-14 06:44:00','2022-06-14 07:12:00',1680,'verifica backup',21,NULL,45,1,'Europe/Rome',21,1,'work','2022-07-01 09:04:26','2022-06-14'),
(2412,3,1,6,'2022-06-14 07:45:00','2022-06-14 08:30:00',2700,'Assistenza su pc client Amministrazione per problemi con account gmail configurato su Outlook 2013',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-21 09:32:21','2022-06-14'),
(2413,3,1,96,'2022-06-14 08:35:00','2022-06-14 09:35:00',3600,'Assistenza su server di posta per problema ricezione mail',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-08 16:26:35','2022-06-14'),
(2414,3,1,79,'2022-06-14 09:50:00','2022-06-14 10:00:00',600,'Assistenza su pc client Matteo Parodi',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-06 15:33:27','2022-06-14'),
(2415,3,1,79,'2022-06-14 10:05:00','2022-06-14 10:15:00',600,'Assistenza su pc client Paola Colladon per problemi scansione di rete',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-06 15:33:36','2022-06-14'),
(2416,3,1,96,'2022-06-14 10:20:00','2022-06-14 10:30:00',600,'Assistenza su pc client Gandolfo per problema posta',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-08 16:26:37','2022-06-14'),
(2417,3,1,115,'2022-06-14 12:40:00','2022-06-14 13:40:00',3600,'Ultimate modifiche per mettere online il sito',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-08 10:57:34','2022-06-14'),
(2418,3,1,22,'2022-06-14 14:15:00','2022-06-14 14:45:00',1800,'Assistenza su pc client papà Stefano',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-10-04 16:13:14','2022-06-14'),
(2419,1,1,81,'2022-06-15 14:12:00','2022-06-15 16:18:36',7596,'problemi pc Ilaria',94.95,NULL,45,1,'Europe/Rome',94.95,1,'work','2022-06-28 09:56:00','2022-06-15'),
(2420,3,1,5,'2022-06-15 06:45:00','2022-06-15 06:55:00',600,'Assistenza su portatile Alessandra per problemi navigazione',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-01-17 17:22:21','2022-06-15'),
(2421,3,1,24,'2022-06-15 07:10:00','2022-06-15 07:40:00',1800,'Assistenza su pc client Gommista per problemi su Outlook 2019',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-07 13:00:20','2022-06-15'),
(2422,3,1,96,'2022-06-15 07:45:00','2022-06-15 08:05:00',1200,'Assistenza su pc client Cristina per problemi collegamento pc in corso Europa',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-08 16:26:40','2022-06-15'),
(2423,3,1,10,'2022-06-15 08:30:00','2022-06-15 09:00:00',1800,'Assistenza per configurazione port forwording su nuova Vodafone Station',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-13 09:23:12','2022-06-15'),
(2424,3,1,79,'2022-06-15 12:30:00','2022-06-15 12:40:00',600,'Assistenza su pc client Paolo',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-06 15:33:31','2022-06-15'),
(2425,3,1,10,'2022-06-15 13:00:00','2022-06-15 13:25:00',1500,'Assistenza su pc client Francesca per problema ricezione mail',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-13 09:23:13','2022-06-15'),
(2426,3,1,115,'2022-06-15 14:00:00','2022-06-15 15:00:00',3600,'Ultime modifiche e messa online sito web',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-08 10:57:35','2022-06-15'),
(2427,1,1,2,'2022-06-16 06:51:00','2022-06-16 07:40:00',2940,'problema mail francesca',36.75,NULL,45,1,'Europe/Rome',36.75,1,'work','2022-09-21 15:46:33','2022-06-16'),
(2428,1,3,112,'2022-06-16 07:41:00','2022-06-16 09:20:00',5940,NULL,74.25,NULL,45,1,'Europe/Rome',74.25,1,'work','2022-07-08 10:59:17','2022-06-16'),
(2429,1,1,81,'2022-06-16 09:23:00','2022-06-16 10:30:00',4020,'casini server',50.25,NULL,45,1,'Europe/Rome',50.25,1,'work','2022-06-28 13:36:31','2022-06-16'),
(2430,3,2,81,'2022-06-16 10:15:00','2022-06-16 11:15:00',3600,'Verificato e ritirato server Windows',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-06-28 13:36:33','2022-06-16'),
(2431,1,1,81,'2022-06-16 12:43:00','2022-06-16 14:09:00',5160,'casini server (server da me',64.5,NULL,45,1,'Europe/Rome',64.5,1,'work','2022-06-28 13:36:33','2022-06-16'),
(2432,3,2,81,'2022-06-16 15:00:00','2022-06-16 15:20:00',1200,'Riconsegnato server Windows dopo assistenza \r\nRitirato pc client Ilaria per upgrade hw',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-06-28 13:36:35','2022-06-16'),
(2433,3,2,81,'2022-06-16 16:05:00','2022-06-16 16:45:00',2400,'Assistenza su server Windows bloccato, sostituzione switch con 435820',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-06-28 13:36:34','2022-06-16'),
(2434,3,2,104,'2022-06-16 08:40:00','2022-06-16 09:10:00',1800,'Assistenza su stampante Sandro e stampante Alice',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-04 08:54:13','2022-06-16'),
(2435,1,1,81,'2022-06-16 20:00:00','2022-06-16 20:38:00',2280,'casini server',28.5,NULL,45,1,'Europe/Rome',28.5,1,'work','2022-06-28 13:36:41','2022-06-16'),
(2436,1,1,81,'2022-06-17 06:45:00','2022-06-17 07:05:00',1200,'casini server',15,NULL,45,1,'Europe/Rome',15,1,'work','2022-06-28 13:36:36','2022-06-17'),
(2437,1,6,18,'2022-06-17 07:19:00','2022-06-17 07:29:00',600,NULL,7.5,NULL,45,1,'Europe/Rome',7.5,1,'work','2022-07-08 16:47:13','2022-06-17'),
(2438,1,1,29,'2022-06-17 08:27:00','2022-06-17 09:00:00',1980,'ver dopo agg',24.75,NULL,45,1,'Europe/Rome',24.75,1,'work','2022-07-01 09:04:28','2022-06-17'),
(2439,1,1,18,'2022-06-17 07:50:00','2022-06-17 08:12:00',1320,'tentativo di andare ha richiamato per annullare',16.5,NULL,45,1,'Europe/Rome',16.5,1,'work','2022-07-08 17:04:10','2022-06-17'),
(2440,1,1,96,'2022-06-17 09:53:00','2022-06-17 10:20:00',1620,'problema con documenti da inviare',20.25,NULL,45,1,'Europe/Rome',20.25,1,'work','2022-07-08 16:26:35','2022-06-17'),
(2441,1,4,103,'2022-06-20 06:48:00','2022-06-20 08:10:00',4920,'configurazione 3cx',61.5,NULL,45,1,'Europe/Rome',61.5,1,'work','2022-12-15 10:39:56','2022-06-20'),
(2442,1,1,59,'2022-06-20 08:25:00','2022-06-20 08:52:42',1662,'problema pc guidetti',20.78,NULL,45,1,'Europe/Rome',20.78,1,'work','2023-02-03 08:39:46','2022-06-20'),
(2443,3,2,81,'2022-06-20 08:20:00','2022-06-20 10:10:00',6600,'Riconsegnato pc client Ilaria dopo upgrade hw e clonazione s.o + assistenza, attivato svm mode su server Windows',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-06-28 13:36:45','2022-06-20'),
(2444,1,1,81,'2022-06-20 08:53:00','2022-06-20 09:57:00',3840,'install debian su vbox per diventare server wireguard\r\nconfigurazione wireguard-ui e client pellini',48,NULL,45,1,'Europe/Rome',48,1,'work','2022-06-28 13:36:40','2022-06-20'),
(2445,1,1,81,'2022-06-20 10:00:00','2022-06-20 10:35:00',2100,'problema stampanti su pc ilaria',26.25,NULL,45,1,'Europe/Rome',26.25,1,'work','2022-06-28 13:36:40','2022-06-20'),
(2446,1,1,103,'2022-06-20 12:45:00','2022-06-20 14:32:00',6420,'3cx su vm lxc\r\nsistemato phpmyadmi\r\nsistemata webmail',80.25,NULL,45,1,'Europe/Rome',80.25,1,'work','2022-12-12 16:41:20','2022-06-20'),
(2447,1,1,29,'2022-06-20 14:43:00','2022-06-20 14:59:54',1014,'problema su 1 pc',12.68,NULL,45,1,'Europe/Rome',12.68,1,'work','2022-07-01 09:04:30','2022-06-20'),
(2448,3,1,6,'2022-06-20 14:30:00','2022-06-20 14:50:00',1200,'Assistenza su portatile Paolo per problema Gmail su Outlook 2016',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-21 09:32:22','2022-06-20'),
(2449,1,1,81,'2022-06-21 07:34:00','2022-06-21 08:27:23',3203,'problemi suo pc ufficio',40.04,NULL,45,1,'Europe/Rome',40.04,1,'work','2022-06-28 13:36:37','2022-06-21'),
(2450,3,2,116,'2022-06-21 07:50:00','2022-06-21 10:10:00',8400,'Consegna e configurazione nuovo portatile HP + mouse usb',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-11 08:11:14','2022-06-21'),
(2451,3,2,10,'2022-06-21 11:05:00','2022-06-21 11:35:00',1800,'Riconsegnato e configurato portatile dopo upgrade hw e reinstallazione sistema operativo',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-13 09:23:25','2022-06-21'),
(2452,1,3,112,'2022-06-21 10:00:00','2022-06-21 10:30:00',1800,NULL,22.5,NULL,45,1,'Europe/Rome',22.5,1,'work','2022-07-08 10:59:22','2022-06-21'),
(2453,1,1,55,'2022-06-21 12:44:00','2022-06-21 13:42:00',3480,'problemi perdita dati pc riccardo',43.5,NULL,45,1,'Europe/Rome',43.5,1,'work','2022-07-08 15:30:02','2022-06-21'),
(2454,1,1,55,'2022-06-21 14:11:00','2022-06-21 14:39:00',1680,'problemi perdita dati pc riccardo',21,NULL,45,1,'Europe/Rome',21,1,'work','2022-07-08 15:30:08','2022-06-21'),
(2455,1,1,96,'2022-06-21 14:43:00','2022-06-21 15:41:20',3500,'prob pc conferenze',43.75,NULL,45,1,'Europe/Rome',43.75,1,'work','2022-07-08 16:26:37','2022-06-21'),
(2456,1,1,3,'2022-06-21 15:43:00','2022-06-21 16:18:00',2100,'cognata ciro',26.25,NULL,45,1,'Europe/Rome',26.25,1,'work','2022-07-08 13:00:12','2022-06-21'),
(2457,1,1,51,'2022-06-22 12:44:00','2022-06-22 14:51:00',7620,'problemi mail e mac che si sconnette\r\nverifiche server',95.25,NULL,45,1,'Europe/Rome',95.25,1,'work','2022-09-01 13:54:51','2022-06-22'),
(2458,1,1,3,'2022-06-22 07:26:00','2022-06-22 10:21:00',10500,'mepa',131.25,NULL,45,1,'Europe/Rome',131.25,1,'work','2022-07-08 13:00:13','2022-06-22'),
(2459,3,2,117,'2022-06-22 08:00:00','2022-06-22 08:30:00',1800,'Assitenza su 2 pc client per problemi di rete',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-01 09:45:48','2022-06-22'),
(2460,3,2,81,'2022-06-22 08:45:00','2022-06-22 08:55:00',600,'Ritirato pc client Pellini per assistenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-07 09:47:19','2022-06-22'),
(2461,3,2,96,'2022-06-22 09:25:00','2022-06-22 09:45:00',1200,'Ritirato mini pc video Conferenze + assistenza su pc client Marilena',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-08 16:26:37','2022-06-22'),
(2462,3,1,26,'2022-06-22 09:50:00','2022-06-22 10:30:00',2400,'Riavviato server dopo aggiornamenti per installazione nuovo sito in Drupal 9',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-10-07 15:45:04','2022-06-22'),
(2463,1,1,81,'2022-06-22 06:43:00','2022-06-22 07:18:00',2100,'sistemazione avvio automatico vm vbox per wireguard',26.25,NULL,45,1,'Europe/Rome',26.25,1,'work','2022-06-28 13:36:37','2022-06-22'),
(2464,1,1,10,'2022-06-22 15:02:00','2022-06-22 16:25:00',4980,'ricofngi firewall per cambio ip',62.25,NULL,45,1,'Europe/Rome',62.25,1,'work','2022-07-13 09:28:13','2022-06-22'),
(2465,3,2,104,'2022-06-22 14:10:00','2022-06-22 14:35:00',1500,'Consegnato tamburo, consegnata e installata nuova stampante Brother',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-04 08:54:12','2022-06-22'),
(2466,3,1,10,'2022-06-22 14:50:00','2022-06-22 15:20:00',1800,'Assistenza su pc casa Carmen per problema di collegamento al pc in ufficio',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-13 09:28:12','2022-06-22'),
(2467,3,4,81,'2022-06-22 13:00:00','2022-06-22 14:00:00',3600,'Assistenza su pc client Pellini, installato ssd 1tb + clonazione s.o',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-06-28 13:36:45','2022-06-22'),
(2468,3,4,96,'2022-06-22 15:30:00','2022-06-22 16:30:00',3600,'Assistenza su mini pc video conferenze, installato ssd 480gb + 4gb sodim ddr3 + clonazione s.o',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-08 16:26:41','2022-06-22'),
(2469,3,2,103,'2022-06-23 13:40:00','2022-06-23 14:10:00',1800,'Consegnato e collegato dispositivo beronet, utilizzato cavo di rete da 3mt',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-12-15 10:30:56','2022-06-23'),
(2470,3,2,96,'2022-06-23 14:45:00','2022-06-23 15:15:00',1800,'Riconsegna mini PC client video conferenze dopo upgrade hw, assistenza su Iphone Gandolfo',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-08 16:26:46','2022-06-23'),
(2471,3,2,88,'2022-06-23 15:30:00','2022-06-23 16:00:00',1800,'Riconsegnato ups apc 3000 dopo sostituzione pacco batterie, collegato al server utilizzando cavo usb 2 mt',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-06 14:49:35','2022-06-23'),
(2472,3,2,88,'2022-06-27 07:50:00','2022-06-27 08:25:00',2100,'Assistenza su server Linux per problemi navigazione, utilizzata sk rete gigabit',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-06 15:01:55','2022-06-27'),
(2473,3,2,52,'2022-06-27 08:40:00','2022-06-27 09:10:00',1800,'Verificato e ritirato ups apc 700\r\nAssistenza su centralino per problemi di avvio',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-06-28 15:17:48','2022-06-27'),
(2474,1,1,1,'2022-06-27 09:00:00','2022-06-27 09:45:00',2700,'problema spamhaus',33.75,NULL,45,1,'Europe/Rome',33.75,1,'work','2022-07-11 10:20:11','2022-06-27'),
(2475,1,1,88,'2022-06-27 07:00:00','2022-06-27 07:15:00',900,'problema server irraggiungibile',11.25,NULL,45,1,'Europe/Rome',11.25,1,'work','2022-07-06 14:49:31','2022-06-27'),
(2476,1,1,81,'2022-06-27 06:44:00','2022-06-27 07:00:00',960,'chiusura pc',12,NULL,45,1,'Europe/Rome',12,1,'work','2022-06-28 13:36:38','2022-06-27'),
(2477,1,1,96,'2022-06-27 07:20:00','2022-06-27 07:34:00',840,'firewall non funge',10.5,NULL,45,1,'Europe/Rome',10.5,1,'work','2022-07-08 15:33:15','2022-06-27'),
(2478,3,2,96,'2022-06-27 09:25:00','2022-06-27 10:05:00',2400,'Assistenza per problemi navigazione, risolto problema su firewall, ups apc 2200 da sostituire pacco batterie\r\nAssistenza su PC client e cellulare Cristina',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-08 16:26:42','2022-06-27'),
(2479,3,4,81,'2022-06-27 10:25:00','2022-06-27 10:40:00',900,'Riconsegna pc client Pelleni dopo upgrade hw',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-06-28 13:36:44','2022-06-27'),
(2480,3,2,41,'2022-06-27 14:15:00','2022-06-27 15:00:00',2700,'Assistenza su server Lenovo per problema ventole rumorose, fatta pulizia server, batterie per ups apc 2200 da ordinare',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-07 12:43:52','2022-06-27'),
(2481,3,2,18,'2022-06-27 15:10:00','2022-06-27 15:30:00',1200,'Assistenza su PC client per problemi navigazione',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-08 17:04:20','2022-06-27'),
(2482,1,3,112,'2022-06-27 10:02:00','2022-06-27 10:30:00',1680,NULL,21,NULL,45,1,'Europe/Rome',21,1,'work','2022-07-08 10:59:22','2022-06-27'),
(2483,1,1,50,'2022-06-27 12:09:00','2022-06-27 16:30:00',15660,'problemi vm in pausa, aggiornamento windows, inizio per migrazione proxmox 7.2',195.75,NULL,45,1,'Europe/Rome',195.75,1,'work','2022-07-08 13:03:34','2022-06-27'),
(2484,1,1,81,'2022-06-23 14:33:00','2022-06-23 16:30:00',7020,'suo pc dopo clone non parte più',87.75,NULL,45,1,'Europe/Rome',87.75,1,'work','2022-06-28 13:36:38','2022-06-23'),
(2485,1,1,81,'2022-06-23 19:34:00','2022-06-23 20:15:00',2460,'suo pc  dopo clone no9n parte più',30.75,NULL,45,1,'Europe/Rome',30.75,1,'work','2022-06-28 13:36:44','2022-06-23'),
(2486,1,3,112,'2022-06-23 09:30:00','2022-06-23 10:30:00',3600,NULL,45,NULL,45,1,'Europe/Rome',45,1,'work','2022-07-08 10:59:18','2022-06-23'),
(2487,1,1,3,'2022-06-23 12:47:00','2022-06-23 14:17:00',5400,'portatile lenovo con bitlocker attivo',67.5,NULL,45,1,'Europe/Rome',67.5,1,'work','2022-07-08 13:00:41','2022-06-23'),
(2488,3,2,64,'2022-06-27 06:55:00','2022-06-27 07:05:00',600,'Assistenza su pc client Valentina',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-20 15:32:09','2022-06-27'),
(2489,3,1,116,'2022-06-27 13:15:00','2022-06-27 13:30:00',900,'Assistenza su nuovo portatile per configurazione nuovo account di posta',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-11 08:11:15','2022-06-27'),
(2490,3,2,104,'2022-06-27 13:40:00','2022-06-27 13:50:00',600,'Consegna toner + reset tamburo stampante Brother',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-04 08:54:11','2022-06-27'),
(2491,3,1,18,'2022-06-27 16:00:00','2022-06-27 16:20:00',1200,'Assistenza su scansione e accesso a indirizzo pec',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-08 17:04:23','2022-06-27'),
(2492,3,2,24,'2022-06-28 09:05:00','2022-06-28 09:15:00',600,'Consegna cartucce stampante Canon',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-07 12:52:20','2022-06-28'),
(2493,1,1,3,'2022-06-28 12:44:00','2022-06-28 13:20:00',2160,'problema dominio liguriafumi',27,NULL,45,1,'Europe/Rome',27,1,'work','2022-07-08 13:00:21','2022-06-28'),
(2494,1,1,50,'2022-06-28 06:44:00','2022-06-28 10:22:00',13080,'conversione vm lxc su proxmox',163.5,NULL,45,1,'Europe/Rome',163.5,1,'work','2022-07-08 13:03:35','2022-06-28'),
(2495,3,2,26,'2022-06-28 13:30:00','2022-06-28 14:00:00',1800,'Consegnate cartucce originali stampante HP\r\nVerificato e ritirato pc client Simona per assistenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-10-07 15:45:04','2022-06-28'),
(2496,3,2,52,'2022-06-28 14:20:00','2022-06-28 14:35:00',900,'Riconsegnato e collegato ups apc 700 dopo sostituzione batteria',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-08 17:03:09','2022-06-28'),
(2497,1,1,50,'2022-06-28 13:40:00','2022-06-28 16:23:00',9780,'migrazione centralino e unifi su proxmox vm',122.25,NULL,45,1,'Europe/Rome',122.25,1,'work','2022-07-08 13:03:40','2022-06-28'),
(2498,3,1,18,'2022-06-28 07:25:00','2022-06-28 07:35:00',600,'Assistenza su pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-08 17:04:19','2022-06-28'),
(2499,3,1,79,'2022-06-28 08:05:00','2022-06-28 08:15:00',600,'Assistenza su pc client Paola Agnoletto',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-06 15:33:34','2022-06-28'),
(2500,3,2,29,'2022-06-29 08:10:00','2022-06-29 08:30:00',1200,'Verificato problema batterie su ups apc\r\nRitirato nas qnap per assistenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-08-31 15:28:38','2022-06-29'),
(2501,1,1,50,'2022-06-29 06:48:00','2022-06-29 07:05:00',1020,'problema telefoni registrati male',12.75,NULL,45,1,'Europe/Rome',12.75,1,'work','2022-07-08 13:03:41','2022-06-29'),
(2502,1,1,29,'2022-06-29 07:15:00','2022-06-29 08:00:00',2700,'problemi ups dopo mancanza corrente',33.75,NULL,45,1,'Europe/Rome',33.75,1,'work','2022-07-01 09:04:37','2022-06-29'),
(2503,1,1,50,'2022-06-29 08:14:00','2022-06-29 09:43:00',5340,'problema telefoni registrati male',66.75,NULL,45,1,'Europe/Rome',66.75,1,'work','2022-07-08 13:03:36','2022-06-29'),
(2504,1,1,81,'2022-06-29 10:01:00','2022-06-29 10:30:00',1740,'problema al rinnovo certificato, configurazione hmail per restart notturno',21.75,NULL,45,1,'Europe/Rome',21.75,1,'work','2022-07-07 09:52:58','2022-06-29'),
(2505,1,1,50,'2022-06-29 12:01:00','2022-06-29 14:38:00',9420,'problema telefoni registrati male\r\nmigrazione',117.75,NULL,45,1,'Europe/Rome',117.75,1,'work','2022-07-08 13:03:36','2022-06-29'),
(2506,3,2,2,'2022-06-29 12:50:00','2022-06-29 14:20:00',5400,'Consegna e collegamento nuovo firewall \r\nSpostata postazione client Alessia\r\nConsegna e configurazione PC client reinstallato\r\nAssistenza su PC client Andrea',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-21 15:46:33','2022-06-29'),
(2507,1,1,81,'2022-06-29 14:41:00','2022-06-29 16:28:27',6447,'suo pc viareggio bruciato, fatte fare prove e configurazione portatile per uso remoto',80.59,NULL,45,1,'Europe/Rome',80.59,1,'work','2022-07-07 09:52:59','2022-06-29'),
(2508,1,1,81,'2022-06-30 09:23:08','2022-06-30 09:46:52',1424,'suo pc viareggio bruciato, fatte fare prove e configurazione portatile per uso remoto',17.8,NULL,45,1,'Europe/Rome',17.8,1,'work','2022-07-07 09:53:00','2022-06-30'),
(2509,3,2,114,'2022-06-30 11:15:00','2022-06-30 11:55:00',2400,'Assistenza per problemi di rete in sede, consegna e installazione nuovo switch 24 porte gigabit managed',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-05 14:38:59','2022-06-30'),
(2510,3,2,55,'2022-06-30 12:30:00','2022-06-30 15:30:00',10800,'Consegnato e configurato nuovo PC client per Riccardo Dallavalle, ritirato vecchio PC client da verificare',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-08 15:30:01','2022-06-30'),
(2511,1,1,2,'2022-06-30 06:46:00','2022-06-30 08:48:00',7320,'agg server e nas',91.5,NULL,45,1,'Europe/Rome',91.5,1,'work','2022-09-21 14:52:53','2022-06-30'),
(2512,1,1,50,'2022-06-30 08:54:00','2022-06-30 09:19:00',1500,'migrazioen container e vm',18.75,NULL,45,1,'Europe/Rome',18.75,1,'work','2022-07-08 13:03:36','2022-06-30'),
(2513,1,1,50,'2022-06-30 12:43:00','2022-06-30 15:12:39',8979,'migrazioen container e vm',112.24,NULL,45,1,'Europe/Rome',112.24,1,'work','2022-07-08 13:03:37','2022-06-30'),
(2514,1,1,55,'2022-06-30 15:13:00','2022-06-30 15:46:00',1980,'ripristino backup pc riccardo fede andato via',24.75,NULL,45,1,'Europe/Rome',24.75,1,'work','2022-07-08 15:30:10','2022-06-30'),
(2515,1,1,79,'2022-06-30 15:48:00','2022-06-30 16:49:00',3660,'problema hack sito web',45.75,NULL,45,1,'Europe/Rome',45.75,1,'work','2022-07-06 15:33:40','2022-06-30'),
(2516,3,1,38,'2022-06-29 06:40:00','2022-06-29 07:00:00',1200,'Assistenza su server Mac per problemi sugli aggiornamenti',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-10 14:34:15','2022-06-29'),
(2517,3,1,26,'2022-06-29 09:10:00','2022-06-29 09:20:00',600,'Assistenza su portatile Simona per problemi su stampanti',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-10-07 15:45:05','2022-06-29'),
(2518,3,1,81,'2022-06-29 09:20:00','2022-06-29 09:30:00',600,'Assistenza su pc client Pellini per problema posta in ricezione',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-07 09:47:20','2022-06-29'),
(2519,3,4,26,'2022-06-29 15:00:00','2022-06-29 16:00:00',3600,'Assistenza su pc client Simona',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-10-07 15:45:06','2022-06-29'),
(2520,3,1,114,'2022-06-30 07:15:00','2022-06-30 07:35:00',1200,'Assistenza per problema navigazione in sede',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-05 14:38:55','2022-06-30'),
(2521,3,1,114,'2022-06-30 09:15:00','2022-06-30 09:45:00',1800,'Assistenza per problemi navigazione in sede, switch da sostituire',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-05 14:38:57','2022-06-30'),
(2522,3,1,10,'2022-06-30 08:45:00','2022-06-30 09:05:00',1200,'Assistenza su portatile per problema collegamento al server, modificata password wifi',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-13 09:28:14','2022-06-30'),
(2523,1,1,79,'2022-07-01 06:49:00','2022-07-01 08:24:00',5700,'problema hack sito web',71.25,NULL,45,1,'Europe/Rome',71.25,1,'work','2022-07-06 15:33:31','2022-07-01'),
(2524,1,1,3,'2022-07-01 08:32:00','2022-07-01 09:45:00',4380,'fogli',54.75,NULL,45,1,'Europe/Rome',54.75,1,'work','2022-07-08 13:00:29','2022-07-01'),
(2525,1,1,2,'2022-06-01 07:10:00','2022-06-01 08:28:00',4680,'problema hyper backup vm',58.5,NULL,45,1,'Europe/Rome',58.5,1,'work','2022-09-21 15:46:21','2022-06-01'),
(2526,1,1,79,'2022-06-01 15:30:00','2022-06-01 16:27:00',3420,'backup vm mail per test agg postfixadmin',42.75,NULL,45,1,'Europe/Rome',42.75,1,'work','2022-07-06 15:33:30','2022-06-01'),
(2527,1,1,3,'2022-06-03 06:40:00','2022-06-03 07:40:00',3600,'verifiche clienti messagenet',45,NULL,45,1,'Europe/Rome',45,1,'work','2022-07-08 13:00:26','2022-06-03'),
(2528,1,4,3,'2022-06-03 09:05:00','2022-06-03 10:30:00',5100,'in lab',63.75,NULL,45,1,'Europe/Rome',63.75,1,'work','2022-07-08 13:00:01','2022-06-03'),
(2529,1,1,51,'2022-06-03 12:40:00','2022-06-03 14:50:00',7800,'agg server',97.5,NULL,45,1,'Europe/Rome',97.5,1,'work','2022-09-01 13:54:51','2022-06-03'),
(2530,1,1,5,'2022-06-03 15:07:00','2022-06-03 16:27:00',4800,'agg server',60,NULL,45,1,'Europe/Rome',60,1,'work','2022-07-05 15:20:55','2022-06-03'),
(2532,1,1,3,'2022-06-06 06:44:00','2022-06-06 09:40:00',10560,'vari backup remoti',132,NULL,45,1,'Europe/Rome',132,1,'work','2022-07-08 13:00:01','2022-06-06'),
(2533,1,1,41,'2022-06-06 09:58:00','2022-06-06 10:30:00',1920,'agg server',24,NULL,45,1,'Europe/Rome',24,1,'work','2022-07-07 12:43:49','2022-06-06'),
(2534,1,1,41,'2022-06-06 14:44:00','2022-06-06 16:22:00',5880,'agg seerver',73.5,NULL,45,1,'Europe/Rome',73.5,1,'work','2022-07-07 12:43:50','2022-06-06'),
(2535,1,6,29,'2022-06-07 06:40:00','2022-06-07 07:00:00',1200,NULL,15,NULL,45,1,'Europe/Rome',15,1,'work','2022-08-31 15:28:34','2022-06-07'),
(2536,1,1,79,'2022-06-07 07:10:00','2022-06-07 08:20:00',4200,'problema certificati',52.5,NULL,45,1,'Europe/Rome',52.5,1,'work','2022-07-06 15:33:39','2022-06-07'),
(2537,1,1,1,'2022-06-08 08:26:00','2022-06-08 10:25:00',7140,'agg server',89.25,NULL,45,1,'Europe/Rome',89.25,1,'work','2022-07-11 10:20:10','2022-06-08'),
(2538,1,1,4,'2022-06-08 14:10:00','2022-06-08 15:00:00',3000,'agg vm',37.5,NULL,45,1,'Europe/Rome',37.5,1,'work','2022-09-23 15:55:10','2022-06-08'),
(2539,1,1,24,'2022-06-08 15:12:00','2022-06-08 16:30:00',4680,'agg 3cx firmware tel',58.5,NULL,45,1,'Europe/Rome',58.5,1,'work','2022-07-07 12:52:28','2022-06-08'),
(2540,1,1,3,'2022-06-09 06:43:00','2022-06-09 07:13:00',1800,'mepa',22.5,NULL,45,1,'Europe/Rome',22.5,1,'work','2022-07-08 13:00:02','2022-06-09'),
(2541,1,1,3,'2022-06-09 15:23:00','2022-06-09 16:28:00',3900,'test su vm per agg proxmox 7.2',48.75,NULL,45,1,'Europe/Rome',48.75,1,'work','2022-07-08 13:00:02','2022-06-09'),
(2542,1,1,3,'2022-06-10 13:41:00','2022-06-10 14:11:00',1800,'test agg win',22.5,NULL,45,1,'Europe/Rome',22.5,1,'work','2022-07-08 13:00:08','2022-06-10'),
(2544,1,1,3,'2022-06-13 06:48:00','2022-06-13 07:53:00',3900,'mepa',48.75,NULL,45,1,'Europe/Rome',48.75,1,'work','2022-07-08 13:00:07','2022-06-13'),
(2545,1,1,2,'2022-06-13 13:11:00','2022-06-13 14:50:00',5940,'agg server',74.25,NULL,45,1,'Europe/Rome',74.25,1,'work','2022-07-08 09:30:57','2022-06-13'),
(2546,1,1,3,'2022-06-15 06:45:00','2022-06-15 07:14:00',1740,'teantitvo inserimento mepa',21.75,NULL,45,1,'Europe/Rome',21.75,1,'work','2022-07-08 13:00:39','2022-06-15'),
(2547,1,1,50,'2022-06-15 07:28:00','2022-06-15 09:24:00',6960,'agg 3cx e reimpostazione firmware telefoni su 3cx',87,NULL,45,1,'Europe/Rome',87,1,'work','2022-07-08 13:03:33','2022-06-15'),
(2548,1,1,3,'2022-06-15 09:52:00','2022-06-15 10:21:00',1740,'tentativo inserimento mepa',21.75,NULL,45,1,'Europe/Rome',21.75,1,'work','2022-07-08 13:00:04','2022-06-15'),
(2549,1,1,5,'2022-06-15 12:55:00','2022-06-15 13:47:00',3120,'agg nas',39,NULL,45,1,'Europe/Rome',39,1,'work','2022-07-05 15:20:57','2022-06-15'),
(2550,1,1,3,'2022-06-16 14:28:00','2022-06-16 16:30:00',7320,'test agg proxmox',91.5,NULL,45,1,'Europe/Rome',91.5,1,'work','2022-07-08 13:00:12','2022-06-16'),
(2551,1,1,3,'2022-06-17 12:30:00','2022-06-17 16:30:00',14400,'vari lab',180,NULL,45,1,'Europe/Rome',180,1,'work','2022-07-08 13:00:16','2022-06-17'),
(2552,1,1,95,'2022-06-20 15:05:00','2022-06-20 16:30:00',5100,'agg server',63.75,NULL,45,1,'Europe/Rome',63.75,1,'work','2022-07-08 10:24:48','2022-06-20'),
(2553,1,1,96,'2022-06-21 08:45:00','2022-06-21 10:00:00',4500,'problemi minipc',56.25,NULL,45,1,'Europe/Rome',56.25,1,'work','2022-07-08 16:26:37','2022-06-21'),
(2554,1,1,3,'2022-06-21 06:44:00','2022-06-21 07:16:00',1920,'proxmox agg',24,NULL,45,1,'Europe/Rome',24,1,'work','2022-07-08 13:00:05','2022-06-21'),
(2555,1,1,3,'2022-06-23 06:30:00','2022-06-23 07:00:00',1800,'in lab',22.5,NULL,45,1,'Europe/Rome',22.5,1,'work','2022-07-08 13:00:13','2022-06-23'),
(2556,1,1,3,'2022-06-23 07:20:00','2022-06-23 09:13:00',6780,'agg proxmox',84.75,NULL,45,1,'Europe/Rome',84.75,1,'work','2022-07-08 13:00:28','2022-06-23'),
(2557,1,1,3,'2022-06-27 07:46:00','2022-06-27 08:50:00',3840,'2fa su wireguard',48,NULL,45,1,'Europe/Rome',48,1,'work','2022-07-08 13:00:16','2022-06-27'),
(2558,1,1,50,'2022-06-30 10:02:00','2022-06-30 10:28:00',1560,'migrazione',19.5,NULL,45,1,'Europe/Rome',19.5,1,'work','2022-07-08 13:03:37','2022-06-30'),
(2559,3,1,32,'2022-07-01 07:30:00','2022-07-01 07:45:00',900,'Assistenza su pc client Luca per installazione software',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-01-23 16:45:19','2022-07-01'),
(2560,3,1,10,'2022-07-01 07:45:00','2022-07-01 07:55:00',600,'Recuperata cartella server cancellata da Carmen',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-13 09:28:15','2022-07-01'),
(2561,3,2,104,'2022-07-01 11:30:00','2022-07-01 11:40:00',600,'Consegnato tamburo stampante Brother, riconsegnato portatile agente Grosso dopo installazione ssd 480 gb + reinstallazione s.o',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-04 08:52:53','2022-07-01'),
(2562,3,2,104,'2022-07-01 14:25:00','2022-07-01 14:35:00',600,'Riconsegnato portatile agente Milite dopo installazione sd 128 gb + assistenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-04 08:52:52','2022-07-01'),
(2563,3,2,81,'2022-07-04 07:30:00','2022-07-04 07:40:00',600,'Ritirato pc client per assistenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-07 09:46:49','2022-07-04'),
(2564,3,2,26,'2022-07-04 07:45:00','2022-07-04 08:05:00',1200,'Riconsegnato pc client Simona dopo assistenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-10-07 14:51:18','2022-07-04'),
(2565,3,2,9,'2022-07-04 08:20:00','2022-07-04 08:30:00',600,'Ritirato pc client per assistenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-03 08:41:19','2022-07-04'),
(2566,3,2,50,'2022-07-04 08:40:00','2022-07-04 08:50:00',600,'Consegna toner Xerox',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-08 13:03:42','2022-07-04'),
(2567,3,2,81,'2022-07-04 15:15:00','2022-07-04 15:25:00',600,'Riconsegnato pc client dopo assistenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-07 09:46:52','2022-07-04'),
(2568,3,2,91,'2022-07-04 15:40:00','2022-07-04 16:00:00',1200,'Assistenza su PC client Arnera per problemi audio',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-29 13:33:45','2022-07-04'),
(2569,3,1,51,'2022-07-04 09:20:00','2022-07-04 09:35:00',900,'Installate 2 licenze nod32 aggiornamento su 4 pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-01 13:54:50','2022-07-04'),
(2570,3,1,10,'2022-07-04 12:40:00','2022-07-04 12:50:00',600,'Assistenza su pc casa Francesca per collegamento in ufficio',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-13 09:28:16','2022-07-04'),
(2571,3,4,81,'2022-07-04 13:00:00','2022-07-04 14:00:00',3600,'Assistenza su pc client utilizzato da Pellini fuori sede\r\nUtilizzato alim cm 500w + dissipatore amd',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-07 09:46:50','2022-07-04'),
(2572,3,1,24,'2022-07-05 07:05:00','2022-07-05 07:30:00',1500,'Assistenza su pc client Monica per problemi collegamento agli share',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-07 13:00:21','2022-07-05'),
(2573,3,2,104,'2022-07-05 07:55:00','2022-07-05 08:10:00',900,'Consegnato nuovo portatatile per agente, ritirata vecchia stampante da smaltire',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-06 15:02:08','2022-07-05'),
(2574,3,1,22,'2022-07-05 09:35:00','2022-07-05 10:05:00',1800,'Assistenza su Nas per problemi di spazio sui dischi',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-10-04 16:13:15','2022-07-05'),
(2575,1,4,9,'2022-07-05 14:10:00','2022-07-05 15:20:00',4200,'pc amw in riparazione',52.5,NULL,45,1,'Europe/Rome',52.5,1,'work','2022-07-07 08:05:12','2022-07-05'),
(2576,1,4,9,'2022-07-06 06:45:00','2022-07-06 07:10:00',1500,'pc in riparazione',18.75,NULL,45,1,'Europe/Rome',18.75,1,'work','2022-07-07 08:05:12','2022-07-06'),
(2577,1,4,9,'2022-07-06 07:48:00','2022-07-06 08:30:00',2520,'pc in riparazione',31.5,NULL,45,1,'Europe/Rome',31.5,1,'work','2022-07-07 08:05:12','2022-07-06'),
(2578,1,1,26,'2022-07-06 08:50:00','2022-07-06 10:23:00',5580,'per sito test locale per problemi php',69.75,NULL,45,1,'Europe/Rome',69.75,1,'work','2022-10-07 15:45:08','2022-07-06'),
(2579,3,2,90,'2022-07-06 09:10:00','2022-07-06 12:40:00',12600,'Consegnato e configurato nuovo PC client Giulia\r\nConsegna e installazione 2 licenze Office 2021\r\nUtilizzati: 1 mouse + 1 tastiera USB + webcam usb',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-12 15:55:50','2022-07-06'),
(2580,1,1,79,'2022-07-06 07:26:00','2022-07-06 07:42:00',960,'agg password aruba',12,NULL,45,1,'Europe/Rome',12,1,'work','2022-07-06 15:33:35','2022-07-06'),
(2581,1,1,79,'2022-07-04 06:50:00','2022-07-04 08:02:00',4320,'problema hack sito web',54,NULL,45,1,'Europe/Rome',54,1,'work','2022-07-06 15:33:31','2022-07-04'),
(2582,3,1,50,'2022-07-06 13:35:00','2022-07-06 14:05:00',1800,'Configurato account underwriting su pc client Pietro, verificata stampante Xerox (da passare in loco)',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-08 13:03:37','2022-07-06'),
(2583,1,1,90,'2022-07-05 15:21:00','2022-07-05 16:30:00',4140,'prep nuovo pc',51.75,NULL,45,1,'Europe/Rome',51.75,1,'work','2022-07-12 14:00:31','2022-07-05'),
(2584,3,2,18,'2022-07-07 06:35:00','2022-07-07 07:05:00',1800,'Assistenza su PC client',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-08 17:04:17','2022-07-07'),
(2585,3,2,41,'2022-07-07 08:15:00','2022-07-07 08:35:00',1200,'Consegnato e installato nuovo ups apc su pc client Roberto',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-16 16:09:27','2022-07-07'),
(2586,1,1,90,'2022-07-07 09:33:00','2022-07-07 10:23:00',3000,'fine config pc giulia',37.5,NULL,45,1,'Europe/Rome',37.5,1,'work','2022-07-12 15:55:52','2022-07-07'),
(2587,3,2,9,'2022-07-07 09:20:00','2022-07-07 09:35:00',900,'Riconsegna e collegamento PC client dopo sostituzione ssd e reinstallazione s.o',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-03 08:41:19','2022-07-07'),
(2588,3,2,50,'2022-07-07 09:50:00','2022-07-07 10:05:00',900,'Verificato pezzo da sostituire su stampante Xerox di Pietro',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-08 13:03:38','2022-07-07'),
(2589,3,2,24,'2022-07-07 12:30:00','2022-07-07 12:50:00',1200,'Consegnate cartucce Epson originali 63204\r\nConsegnate e installate tastiera e mouse usb\r\nVerificata temperatura server',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-07 14:42:56','2022-07-07'),
(2590,3,1,18,'2022-07-07 08:50:00','2022-07-07 09:00:00',600,'Assistenza su pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-08 17:04:18','2022-07-07'),
(2591,3,1,18,'2022-07-07 13:45:00','2022-07-07 13:55:00',600,'Assistenza su pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-08 17:04:12','2022-07-07'),
(2592,1,1,90,'2022-07-07 12:46:00','2022-07-07 14:10:00',5040,'fine config pc giulia',63,NULL,45,1,'Europe/Rome',63,1,'work','2022-07-12 15:55:53','2022-07-07'),
(2593,1,1,50,'2022-07-07 06:48:00','2022-07-07 08:10:00',4920,'vm per gestionale',61.5,NULL,45,1,'Europe/Rome',61.5,1,'work','2022-07-08 13:03:38','2022-07-07'),
(2594,1,1,26,'2022-07-07 08:20:00','2022-07-07 09:11:00',3060,'prob php',38.25,NULL,45,1,'Europe/Rome',38.25,1,'work','2022-10-07 15:45:09','2022-07-07'),
(2595,3,1,83,'2022-07-07 14:00:00','2022-07-07 14:10:00',600,'Assistenza su pc client Roberta',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-10-04 15:46:07','2022-07-07'),
(2596,3,1,115,'2022-07-07 14:10:00','2022-07-07 14:20:00',600,'Assistenza per installazione software scansione stampante Brother',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-08 10:57:37','2022-07-07'),
(2597,1,1,50,'2022-07-07 14:23:00','2022-07-07 16:00:00',5820,'vm gestionale temporanea',72.75,NULL,45,1,'Europe/Rome',72.75,1,'work','2022-07-08 13:03:44','2022-07-07'),
(2598,1,1,96,'2022-07-08 06:39:00','2022-07-08 07:08:00',1740,'problema connessione vpn anna mochi',21.75,NULL,45,1,'Europe/Rome',21.75,1,'work','2022-07-08 16:26:45','2022-07-08'),
(2599,3,2,18,'2022-07-08 08:40:00','2022-07-08 09:10:00',1800,'Assistenza su PC client per problemi di rete\r\nUtilizzato: sk di rete gigabit + cavo LAN 2mt',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-08 17:04:12','2022-07-08'),
(2600,3,1,12,'2022-07-08 09:30:00','2022-07-08 09:40:00',600,'Assistenza su pc client casa Greta Solari',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-21 07:53:44','2022-07-08'),
(2601,3,1,17,'2022-07-08 10:00:00','2022-07-08 10:15:00',900,'Riavvio server linux dopo aggiornamenti',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-14 07:11:45','2022-07-08'),
(2602,3,1,29,'2022-07-08 14:00:00','2022-07-08 14:10:00',600,'Assistenza per beep su ups apc collegato al server',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-08-31 15:28:55','2022-07-08'),
(2603,1,1,29,'2022-07-11 07:12:00','2022-07-11 07:46:00',2040,'server spento',25.5,NULL,45,1,'Europe/Rome',25.5,1,'work','2022-08-31 15:28:56','2022-07-11'),
(2604,1,4,90,'2022-07-11 08:03:00','2022-07-11 09:33:00',5400,'connessione remota giulia brina agg server\r\nsospeso da riprendere nel pomeriggio',67.5,NULL,45,1,'Europe/Rome',67.5,1,'work','2022-07-12 15:55:54','2022-07-11'),
(2605,3,2,29,'2022-07-11 08:25:00','2022-07-11 08:45:00',1200,'Assistenza per problemi avvio server',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-08-31 15:28:59','2022-07-11'),
(2606,1,1,103,'2022-07-01 09:56:00','2022-07-01 10:29:00',1980,'conf beronet',24.75,NULL,45,1,'Europe/Rome',24.75,1,'work','2022-12-15 10:39:57','2022-07-01'),
(2607,1,1,103,'2022-07-01 12:39:00','2022-07-01 14:22:00',6180,'conf beronet',77.25,NULL,45,1,'Europe/Rome',77.25,1,'work','2022-12-15 10:39:59','2022-07-01'),
(2608,1,1,50,'2022-07-01 14:48:00','2022-07-01 16:22:00',5640,'vm temp',70.5,NULL,45,1,'Europe/Rome',70.5,1,'work','2022-07-14 07:22:44','2022-07-01'),
(2609,1,1,3,'2022-07-04 08:19:00','2022-07-04 10:30:00',7860,'test agg windows server su vm dominio per distribuzione sui server dei clienti',98.25,NULL,45,1,'Europe/Rome',98.25,1,'work','2022-09-15 09:26:22','2022-07-04'),
(2610,1,4,3,'2022-07-04 12:50:00','2022-07-04 13:56:00',3960,'test agg windows server su vm dominio per distribuzione sui server dei clienti',49.5,NULL,45,1,'Europe/Rome',49.5,1,'work','2022-09-15 09:26:31','2022-07-04'),
(2611,1,4,103,'2022-07-04 14:14:00','2022-07-04 16:13:00',7140,'fine test su beronet',89.25,NULL,45,1,'Europe/Rome',89.25,1,'work','2022-12-15 10:23:34','2022-07-04'),
(2613,1,1,2,'2022-07-05 06:46:00','2022-07-05 09:21:00',9300,'agg server e nas',116.25,NULL,45,1,'Europe/Rome',116.25,1,'work','2022-09-21 15:46:32','2022-07-05'),
(2614,1,1,26,'2022-07-05 09:46:00','2022-07-05 10:26:00',2400,'problemi sito nuovo',30,NULL,45,1,'Europe/Rome',30,1,'work','2022-10-07 15:45:07','2022-07-05'),
(2615,1,1,79,'2022-07-05 12:54:00','2022-07-05 13:44:00',3000,'agg vm',37.5,NULL,45,1,'Europe/Rome',37.5,1,'work','2022-09-16 09:24:20','2022-07-05'),
(2616,1,1,26,'2022-07-06 12:49:00','2022-07-06 13:31:00',2520,'test locale per problemi sito php',31.5,NULL,45,1,'Europe/Rome',31.5,1,'work','2022-10-07 15:45:08','2022-07-06'),
(2617,1,1,17,'2022-07-06 13:57:00','2022-07-06 14:38:00',2460,'agg nas',30.75,NULL,45,1,'Europe/Rome',30.75,1,'work','2022-09-14 07:29:20','2022-07-06'),
(2618,1,1,51,'2022-07-06 14:46:00','2022-07-06 16:22:00',5760,'agg server',72,NULL,45,1,'Europe/Rome',72,1,'work','2022-09-01 13:54:49','2022-07-06'),
(2619,3,2,50,'2022-07-11 09:40:00','2022-07-11 09:55:00',900,'Consegna e installazione fusore stampante Xerox \r\nRitirato portatile figlio Francesco per assistenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-08-29 15:08:50','2022-07-11'),
(2620,1,4,29,'2022-07-11 09:45:00','2022-07-11 10:30:00',2700,'controllo server dopo problemi di stamane e blocco',33.75,NULL,45,1,'Europe/Rome',33.75,1,'work','2022-08-31 15:29:04','2022-07-11'),
(2621,1,1,26,'2022-07-11 06:45:00','2022-07-11 07:00:00',900,'verifica sito nuovo',11.25,NULL,45,1,'Europe/Rome',11.25,1,'work','2022-10-07 15:45:10','2022-07-11'),
(2622,1,4,90,'2022-07-11 13:26:00','2022-07-11 13:38:00',720,'connessione remota giulia brina agg server\r\nsospeso da riprendere nel pomeriggio',9,NULL,45,1,'Europe/Rome',9,1,'work','2022-07-12 15:55:55','2022-07-11'),
(2623,3,1,79,'2022-07-11 12:35:00','2022-07-11 13:10:00',2100,'Assistenza su pc client Elena per problemi spazio disco e Excel\r\nInstallata 1 licenza aggiornamento su 2 pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-16 09:24:20','2022-07-11'),
(2624,3,4,115,'2022-07-11 13:40:00','2022-07-11 14:00:00',1200,'Assistenza su sito web + creazione utente Wordpress',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-16 16:00:06','2022-07-11'),
(2625,3,1,24,'2022-07-11 15:15:00','2022-07-11 15:25:00',600,'Installata 1 licenza aggiornamento nod32 su 2 pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-07 14:30:57','2022-07-11'),
(2626,3,2,96,'2022-07-12 10:10:00','2022-07-12 10:35:00',1500,'Consegna toner originale stampante Brother \r\nAssistenza su PC client Roberta e Cristina',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-14 06:57:52','2022-07-12'),
(2627,1,1,50,'2022-07-12 12:46:00','2022-07-12 13:10:00',1440,'config postgree per connessione neido',18,NULL,45,1,'Europe/Rome',18,1,'work','2022-08-29 15:08:57','2022-07-12'),
(2628,1,3,112,'2022-07-12 06:30:00','2022-07-12 09:40:00',11400,NULL,142.5,NULL,45,1,'Europe/Rome',142.5,1,'work','2022-09-15 09:25:22','2022-07-12'),
(2629,1,1,41,'2022-07-12 09:45:00','2022-07-12 11:00:00',4500,'per consegna password',56.25,NULL,45,1,'Europe/Rome',56.25,1,'work','2022-09-16 16:06:34','2022-07-12'),
(2630,3,2,50,'2022-07-12 15:20:00','2022-07-12 15:30:00',600,'Riconsegna portatile figlio Francesco dopo assistenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-08-29 15:08:57','2022-07-12'),
(2631,3,1,5,'2022-07-12 06:50:00','2022-07-12 07:10:00',1200,'Assistenza su pc client Alessandra per problemi su Outlook',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-01-17 17:22:23','2022-07-12'),
(2632,3,1,38,'2022-07-12 07:35:00','2022-07-12 07:45:00',600,'Assistenza per problemi collegamento Wifi sul server',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-10 14:34:17','2022-07-12'),
(2633,3,4,115,'2022-07-12 07:50:00','2022-07-12 08:10:00',1200,'Assistenza su sito web',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-16 16:00:07','2022-07-12'),
(2634,3,1,100,'2022-07-12 08:10:00','2022-07-12 08:20:00',600,'Assistenza per problemi invio posta elettronica',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-11-21 14:18:41','2022-07-12'),
(2635,3,2,73,'2022-07-12 08:25:00','2022-07-12 08:35:00',600,'Installata 1 licenza aggiornamento nod32 su 2 pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-03 08:50:56','2022-07-12'),
(2636,3,4,50,'2022-07-12 12:30:00','2022-07-12 13:30:00',3600,'Reinstallato sistema operativo su portatile figlio Francesco\r\nUtilizzato: ssd 480gb Kioxa + 4 gb ddr3L usata',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-08-29 15:08:52','2022-07-12'),
(2637,3,1,95,'2022-07-13 07:20:00','2022-07-13 07:55:00',2100,'Assistenza su pc client Anna per problemi collegamento sito buste paga',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-07 14:19:14','2022-07-13'),
(2638,3,1,51,'2022-07-13 08:00:00','2022-07-13 08:10:00',600,'Assistenza su portatile casa Elisabetta per problemi collegamento in ufficio',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-01 14:09:55','2022-07-13'),
(2639,3,1,79,'2022-07-13 08:15:00','2022-07-13 08:35:00',1200,'Creata firma gif animata per mail più configurazione',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-16 09:24:20','2022-07-13'),
(2640,3,4,115,'2022-07-13 08:40:00','2022-07-13 09:40:00',3600,'Assistenza su sito web',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-16 16:00:08','2022-07-13'),
(2641,3,4,115,'2022-07-13 13:00:00','2022-07-13 14:00:00',3600,'Assistenza su sito web',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-16 16:00:09','2022-07-13'),
(2642,3,1,79,'2022-07-13 12:30:00','2022-07-13 12:50:00',1200,'Assistenza su pc client Elena per problemi spazio disco',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-16 09:22:48','2022-07-13'),
(2643,1,1,67,'2022-07-13 16:00:00','2022-07-13 16:50:00',3000,'problemi posta',37.5,NULL,45,1,'Europe/Rome',37.5,1,'work','2022-09-14 10:26:39','2022-07-13'),
(2644,1,2,2,'2022-07-13 12:00:00','2022-07-13 15:15:00',11700,'sistemazione armadio\r\n1 pacco batterie\r\nc\'eri anche tu',146.25,NULL,45,1,'Europe/Rome',146.25,1,'work','2022-09-21 15:46:26','2022-07-13'),
(2645,1,1,2,'2022-07-13 15:40:00','2022-07-13 16:00:00',1200,'problemi infovision',15,NULL,45,1,'Europe/Rome',15,1,'work','2022-09-21 15:46:24','2022-07-13'),
(2646,1,1,2,'2022-07-14 06:37:00','2022-07-14 07:04:37',1657,'problemi stampante stefanino',20.71,NULL,45,1,'Europe/Rome',20.71,1,'work','2022-09-21 15:46:45','2022-07-14'),
(2647,1,1,5,'2022-07-12 13:27:00','2022-07-12 15:00:00',5580,'agg server',69.75,NULL,45,1,'Europe/Rome',69.75,1,'work','2022-10-05 08:58:37','2022-07-12'),
(2648,1,1,2,'2022-07-12 15:14:00','2022-07-12 17:00:00',6360,'agg server e vm',79.5,NULL,45,1,'Europe/Rome',79.5,1,'work','2022-09-21 14:52:58','2022-07-12'),
(2649,1,1,2,'2022-07-12 19:10:00','2022-07-12 20:00:00',3000,'sgg server e nas',37.5,NULL,45,1,'Europe/Rome',37.5,1,'work','2022-09-21 15:46:36','2022-07-12'),
(2650,1,1,2,'2022-07-13 09:05:00','2022-07-13 10:30:00',5100,'sincro firewall',63.75,NULL,45,1,'Europe/Rome',63.75,1,'work','2022-09-21 15:46:22','2022-07-13'),
(2651,1,1,55,'2022-07-13 06:45:00','2022-07-13 08:43:00',7080,'agg server da completare',88.5,NULL,45,1,'Europe/Rome',88.5,1,'work','2022-09-16 08:18:11','2022-07-13'),
(2652,1,1,67,'2022-07-14 09:25:00','2022-07-14 10:30:00',3900,'problema antispam',48.75,NULL,45,1,'Europe/Rome',48.75,1,'work','2022-09-14 10:26:40','2022-07-14'),
(2653,3,2,41,'2022-07-14 15:30:00','2022-07-14 16:00:00',1800,'Consegnato e montato pacco batterie ups apc nella sede di via Wagner',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-16 16:09:28','2022-07-14'),
(2654,1,1,96,'2022-07-14 14:36:00','2022-07-14 15:10:00',2040,'saltata corrente firewall bloccato provato a guidare fede',25.5,NULL,45,1,'Europe/Rome',25.5,1,'work','2022-09-13 09:12:17','2022-07-14'),
(2655,1,1,2,'2022-07-14 15:20:00','2022-07-14 16:26:00',3960,'sistemazione openvpn server',49.5,NULL,45,1,'Europe/Rome',49.5,1,'work','2022-09-21 14:53:24','2022-07-14'),
(2656,1,1,2,'2022-07-14 12:48:00','2022-07-14 14:00:00',4320,'problema mail duplicate laura dopo scambio server',54,NULL,45,1,'Europe/Rome',54,1,'work','2022-09-21 15:46:31','2022-07-14'),
(2657,1,1,55,'2022-07-14 07:19:00','2022-07-14 09:10:00',6660,'fine aggiornamenti server',83.25,NULL,45,1,'Europe/Rome',83.25,1,'work','2022-09-16 16:23:40','2022-07-14'),
(2658,3,2,96,'2022-07-14 16:30:00','2022-07-14 16:45:00',900,'Assistenza per problemi navigazione causa firewall bloccato',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-14 06:57:54','2022-07-14'),
(2659,1,1,22,'2022-07-15 08:05:00','2022-07-15 09:08:00',3780,'problema thunderbird',47.25,NULL,45,1,'Europe/Rome',47.25,1,'work','2022-10-04 16:13:14','2022-07-15'),
(2660,3,2,6,'2022-07-15 07:25:00','2022-07-15 09:15:00',6600,'Assistenza per installazione e configurazione nuovo portatile, verificato e ritirato portatile scocca rotta, assistenza per problemi accessi account su PC client',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-21 09:32:23','2022-07-15'),
(2661,3,2,96,'2022-07-15 10:15:00','2022-07-15 11:45:00',5400,'Assistenza per problemi avvio servizi dopo che è mancata la corrente, sostituzione batteria bios su PC firewall',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-14 06:57:55','2022-07-15'),
(2662,1,1,110,'2022-07-15 13:00:00','2022-07-15 13:55:00',3300,'analisi mail',41.25,NULL,45,1,'Europe/Rome',41.25,1,'work','2022-09-16 15:20:19','2022-07-15'),
(2663,1,1,103,'2022-07-15 06:43:00','2022-07-15 08:00:00',4620,'agg server',57.75,NULL,45,1,'Europe/Rome',57.75,1,'work','2022-12-08 12:03:32','2022-07-15'),
(2664,1,1,103,'2022-07-15 09:23:00','2022-07-15 10:30:00',4020,'agg server',50.25,NULL,45,1,'Europe/Rome',50.25,1,'work','2022-12-08 12:03:35','2022-07-15'),
(2665,1,1,50,'2022-07-15 14:00:00','2022-07-15 14:44:00',2640,'liberato spazio fino al 90%',33,NULL,45,1,'Europe/Rome',33,1,'work','2022-08-29 15:09:01','2022-07-15'),
(2666,1,1,96,'2022-07-15 14:45:00','2022-07-15 15:39:00',3240,'problemi 3cx reinstallato centralino',40.5,NULL,45,1,'Europe/Rome',40.5,1,'work','2022-09-14 06:57:57','2022-07-15'),
(2667,3,1,79,'2022-07-14 06:50:00','2022-07-14 07:00:00',600,'Assistenza su pc client Elena',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-16 09:23:11','2022-07-14'),
(2668,3,4,27,'2022-07-14 13:00:00','2022-07-14 13:30:00',1800,'Assistenza per problemi visualizzazione dancinkcavalierking.com',0,NULL,0,0,'Europe/Rome',0,1,'work','2022-07-15 15:17:36','2022-07-14'),
(2669,3,1,41,'2022-07-15 12:10:00','2022-07-15 12:35:00',1500,'Assistenza per problemi stampa dal software gestionale WinToLip',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-16 16:22:31','2022-07-15'),
(2670,3,1,10,'2022-07-15 12:40:00','2022-07-15 13:05:00',1500,'Assistenza su pc client Francesca per problemi su Outlook e recupero file perso',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-22 09:46:33','2022-07-15'),
(2671,3,1,76,'2022-07-15 13:55:00','2022-07-15 14:05:00',600,'Verificata configurazione pc client per upgrade hardware',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-08-30 08:34:20','2022-07-15'),
(2672,3,1,96,'2022-07-15 14:10:00','2022-07-15 14:40:00',1800,'Assistenza per problemi su Centralino',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-14 06:57:56','2022-07-15'),
(2673,3,1,26,'2022-07-15 15:15:00','2022-07-15 15:30:00',900,'Assistenza per problemi reidirect sito in http',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-10-07 15:45:11','2022-07-15'),
(2674,1,1,26,'2022-07-18 14:42:00','2022-07-18 16:19:00',5820,'redirect http su https',72.75,NULL,45,1,'Europe/Rome',72.75,1,'work','2022-10-07 15:45:12','2022-07-18'),
(2675,3,6,96,'2022-07-18 06:50:00','2022-07-18 07:00:00',600,'Assistenza per avvio servizi dopo intervento elettrico',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-07-21 15:10:19','2022-07-18'),
(2676,3,2,95,'2022-07-18 07:20:00','2022-07-18 07:55:00',2100,'Assistenza su ups pc client Anna, assistenza su pc client Silvia per problemi su Google Chrome',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-07 14:19:15','2022-07-18'),
(2677,3,1,96,'2022-07-18 08:05:00','2022-07-18 08:15:00',600,'Assistenza su pc client Cristina per collegamento con pc ufficio Corso Europa',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-14 06:57:58','2022-07-18'),
(2678,3,1,75,'2022-07-18 08:40:00','2022-07-18 08:55:00',900,'Assistenza su pc client Stoehr per problemi stampa fronte-retro',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-21 14:07:05','2022-07-18'),
(2679,3,1,51,'2022-07-18 13:00:00','2022-07-18 13:10:00',600,'Assistenza su portatile Elisabetta',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-01 14:09:54','2022-07-18'),
(2680,3,2,24,'2022-07-18 14:25:00','2022-07-18 15:05:00',2400,'Assistenza per problemi su 2 telefoni dal Gommista, utilizzato nuovo alimentatore per telefono Snom\r\nAssistenza su 2 pc client Gommista per problemi su posta elettronica',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-07 14:42:59','2022-07-18'),
(2681,1,1,115,'2022-07-19 08:23:00','2022-07-19 10:30:36',7656,'problemi sito https',95.7,NULL,45,1,'Europe/Rome',95.7,1,'work','2022-09-16 16:00:12','2022-07-19'),
(2682,3,2,79,'2022-07-19 11:50:00','2022-07-19 12:05:00',900,'Consegna tamburo brother, materiale sbagliato',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-16 08:27:04','2022-07-19'),
(2683,1,1,3,'2022-07-19 06:48:00','2022-07-19 08:12:00',5040,'test da postfix a postfixadmin',63,NULL,45,1,'Europe/Rome',63,1,'work','2022-09-15 09:26:25','2022-07-19'),
(2684,1,1,3,'2022-07-19 13:20:00','2022-07-19 14:00:00',2400,'test da postfix a postfixadmin',30,NULL,45,1,'Europe/Rome',30,1,'work','2022-09-15 09:26:28','2022-07-19'),
(2685,1,1,90,'2022-07-19 14:09:00','2022-07-19 15:20:41',4301,'attivazione nuova licenza leica',53.76,NULL,45,1,'Europe/Rome',53.76,1,'work','2022-09-22 15:48:21','2022-07-19'),
(2686,1,1,103,'2022-07-19 12:40:00','2022-07-19 13:17:00',2220,'1 agg con problemi su vm',27.75,NULL,45,1,'Europe/Rome',27.75,1,'work','2022-12-08 12:03:41','2022-07-19'),
(2687,3,4,115,'2022-07-19 07:30:00','2022-07-19 08:30:00',3600,'Assistenza su sito web',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-16 16:00:11','2022-07-19'),
(2688,3,1,95,'2022-07-19 09:20:00','2022-07-19 09:35:00',900,'Assistenza su pc client Mara',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-07 14:19:16','2022-07-19'),
(2689,3,1,64,'2022-07-19 09:40:00','2022-07-19 09:50:00',600,'Recuperata password wifi',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-20 15:32:09','2022-07-19'),
(2690,1,1,79,'2022-07-20 06:48:00','2022-07-20 08:12:00',5040,'problemi spam',63,NULL,45,1,'Europe/Rome',63,1,'work','2022-09-16 09:25:12','2022-07-20'),
(2691,1,1,118,'2022-07-20 08:16:00','2022-07-20 08:56:00',2400,'test su disco battistini guasto',30,NULL,45,1,'Europe/Rome',30,1,'work','2022-09-16 15:19:39','2022-07-20'),
(2692,1,1,29,'2022-07-20 09:11:00','2022-07-20 10:30:00',4740,'cambio config vpn wireguard per configurazione da fare in serata',59.25,NULL,45,1,'Europe/Rome',59.25,1,'work','2022-08-31 15:29:16','2022-07-20'),
(2693,1,1,118,'2022-07-20 12:44:00','2022-07-20 13:44:00',3600,'test su disco battistini guasto',45,NULL,45,1,'Europe/Rome',45,1,'work','2022-09-16 15:19:41','2022-07-20'),
(2694,1,1,29,'2022-07-20 13:54:00','2022-07-20 15:21:00',5220,'cambio config vpn wireguard per configurazione da fare in serata\r\naggiornamento server wireguard e windows',65.25,NULL,45,1,'Europe/Rome',65.25,1,'work','2022-08-31 15:29:17','2022-07-20'),
(2695,1,1,118,'2022-07-20 15:32:00','2022-07-20 16:30:00',3480,'reinstallazione windows su nuovo ssd\r\n1 ssd s3 480 gb',43.5,NULL,45,1,'Europe/Rome',43.5,1,'work','2022-09-16 15:19:44','2022-07-20'),
(2696,3,2,45,'2022-07-21 07:35:00','2022-07-21 07:55:00',1200,'Sostituzione alimentatore su PC client Segreteria',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-14 10:00:48','2022-07-21'),
(2697,3,2,96,'2022-07-21 08:15:00','2022-07-21 09:40:00',5100,'Sostituzione pacco batterie su ups apc 2200, assistenza su telefoni Maria e Marilena, assistenza su PC client Gandolfo e Cristina',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-14 06:57:59','2022-07-21'),
(2698,3,2,76,'2022-07-21 10:00:00','2022-07-21 10:20:00',1200,'Installazione 2 banchi di ram da 8gb ddr3 cod. 350422',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-08-30 08:34:22','2022-07-21'),
(2699,3,2,79,'2022-07-21 12:45:00','2022-07-21 13:45:00',3600,'Consegna e installazione tamburi originali per stampante Brother + assistenza su PC client Paola e Elena',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-16 09:24:20','2022-07-21'),
(2700,1,1,29,'2022-07-21 15:40:00','2022-07-21 16:13:14',1994,'config vpn su mac di toi',24.93,NULL,45,1,'Europe/Rome',24.93,1,'work','2022-08-31 15:29:20','2022-07-21'),
(2701,1,1,115,'2022-07-21 12:44:00','2022-07-21 15:24:00',9600,'problemi sito',120,NULL,45,1,'Europe/Rome',120,1,'work','2022-09-16 16:00:13','2022-07-21'),
(2702,1,1,115,'2022-07-21 09:02:00','2022-07-21 10:20:00',4680,'problemi sito',58.5,NULL,45,1,'Europe/Rome',58.5,1,'work','2022-09-16 16:00:12','2022-07-21'),
(2703,1,1,115,'2022-07-21 16:22:00','2022-07-21 17:10:00',2880,'problemi sito\r\nrisolto colpa di cloudflare',36,NULL,45,1,'Europe/Rome',36,1,'work','2022-09-16 16:00:14','2022-07-21'),
(2704,1,1,1,'2022-07-21 06:47:00','2022-07-21 08:52:00',7500,'agg hmail e spam',93.75,NULL,45,1,'Europe/Rome',93.75,1,'work','2022-09-16 15:18:46','2022-07-21'),
(2705,1,1,29,'2022-07-22 08:00:00','2022-07-22 08:12:00',720,'config vpn su mac di francesca',9,NULL,45,1,'Europe/Rome',9,1,'work','2022-08-31 15:29:22','2022-07-22'),
(2706,1,1,2,'2022-07-22 08:13:00','2022-07-22 08:38:00',1500,'gestione utenti di dominio nuovi creati da fede li per installazione nuovo client',18.75,NULL,45,1,'Europe/Rome',18.75,1,'work','2022-09-21 15:46:45','2022-07-22'),
(2707,1,1,3,'2022-07-22 08:48:00','2022-07-22 09:06:00',1080,'privato dove abbiamo sistemato una stampante 1 mesetto fà con di nuovo problemi di stampa, provato a sistemare al volo ma non riuscito.',13.5,NULL,45,1,'Europe/Rome',13.5,1,'work','2022-09-15 09:26:28','2022-07-22'),
(2708,1,1,51,'2022-07-22 09:21:00','2022-07-22 09:25:06',246,'problemi office sig zamparo',3.08,NULL,45,1,'Europe/Rome',3.08,1,'work','2022-09-01 14:09:54','2022-07-22'),
(2709,1,1,103,'2022-07-22 09:26:00','2022-07-22 09:39:00',780,'creazione nuovo spazio web per nuovo sito wordpress',9.75,NULL,45,1,'Europe/Rome',9.75,1,'work','2022-12-15 10:40:00','2022-07-22'),
(2710,3,2,2,'2022-07-22 07:35:00','2022-07-22 09:35:00',7200,'Spostamento e configurazione postazione client per nuovo dipendente, assistenza pc client Andrea',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-21 15:46:35','2022-07-22'),
(2711,1,1,103,'2022-07-22 09:53:00','2022-07-22 10:31:19',2299,'creazione nuovo spazio web per nuovo sito wordpress',28.74,NULL,45,1,'Europe/Rome',28.74,1,'work','2022-12-15 10:40:01','2022-07-22'),
(2712,1,1,3,'2022-07-22 06:30:00','2022-07-22 08:00:00',5400,NULL,67.5,NULL,45,1,'Europe/Rome',67.5,1,'work','2022-09-15 09:26:25','2022-07-22'),
(2713,1,4,3,'2022-07-22 09:40:00','2022-07-22 09:52:00',720,NULL,9,NULL,45,1,'Europe/Rome',9,1,'work','2022-09-15 09:26:25','2022-07-22'),
(2714,1,1,51,'2022-07-22 13:13:00','2022-07-22 13:44:15',1875,'problemi office sig zamparo',23.44,NULL,45,1,'Europe/Rome',23.44,1,'work','2022-09-01 14:09:53','2022-07-22'),
(2715,1,1,51,'2022-07-22 14:48:00','2022-07-22 15:26:56',2336,'Petrilli installazione office e nod32\r\n\r\n1 office 2021\r\n1 nod32',29.2,NULL,45,1,'Europe/Rome',29.2,1,'work','2022-09-01 14:09:52','2022-07-22'),
(2716,1,1,103,'2022-07-22 12:35:00','2022-07-22 13:12:00',2220,'creazione nuovo spazio web per nuovo sito wordpress',27.75,NULL,45,1,'Europe/Rome',27.75,1,'work','2022-12-15 10:40:02','2022-07-22'),
(2717,1,1,103,'2022-07-22 15:27:00','2022-07-22 15:53:00',1560,'creazione nuovo spazio web per nuovo sito wordpress',19.5,NULL,45,1,'Europe/Rome',19.5,1,'work','2022-12-15 10:40:03','2022-07-22'),
(2718,1,1,3,'2022-07-22 15:54:00','2022-07-22 16:05:00',660,'file pdf per gdpr',8.25,NULL,45,1,'Europe/Rome',8.25,1,'work','2022-09-15 09:26:28','2022-07-22'),
(2719,1,1,103,'2022-07-22 16:06:00','2022-07-22 16:45:00',2340,'creazione nuovo spazio web per nuovo sito wordpress',29.25,NULL,45,1,'Europe/Rome',29.25,1,'work','2022-12-15 10:40:17','2022-07-22'),
(2720,3,1,10,'2022-07-22 10:15:00','2022-07-22 10:35:00',1200,'Assistenza su pc client per rinnovo certificato di posta + recupero file cancellato da Carmen',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-22 09:46:35','2022-07-22'),
(2721,3,1,79,'2022-07-22 12:30:00','2022-07-22 12:40:00',600,'Assistenza per organizzazione indirizzi mail',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-16 09:23:22','2022-07-22'),
(2722,3,1,96,'2022-07-22 12:45:00','2022-07-22 13:15:00',1800,'Assistenza su pc client Federica e Cristina',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-14 06:58:00','2022-07-22'),
(2723,3,1,115,'2022-07-22 14:35:00','2022-07-22 14:50:00',900,'Verificato sito web dopo risoluzione problemi https',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-16 16:00:15','2022-07-22'),
(2724,1,1,96,'2022-07-25 06:32:00','2022-07-25 06:56:38',1478,'problemi stanza non naviga',18.48,NULL,45,1,'Europe/Rome',18.48,1,'work','2022-09-14 06:58:01','2022-07-25'),
(2725,3,2,96,'2022-07-25 07:40:00','2022-07-25 08:15:00',2100,'Sostituzione switch 8 porte gigabit nella stanza di Maria (435820), utilizzata prolunga usb su postazione Cristina, assistenza su PC client Cristina',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-14 06:58:02','2022-07-25'),
(2726,1,1,50,'2022-07-25 08:40:00','2022-07-25 10:35:18',6918,'spazio disco server',86.48,NULL,45,1,'Europe/Rome',86.48,1,'work','2022-08-29 15:09:02','2022-07-25'),
(2727,1,1,5,'2022-07-25 15:38:00','2022-07-25 16:18:00',2400,'prob connessione vecchio server softmore',30,NULL,45,1,'Europe/Rome',30,1,'work','2023-01-17 17:22:22','2022-07-25'),
(2728,1,1,3,'2022-07-25 07:08:00','2022-07-25 08:33:00',5100,'gdpr',63.75,NULL,45,1,'Europe/Rome',63.75,1,'work','2022-09-15 09:26:25','2022-07-25'),
(2729,1,1,3,'2022-07-25 12:40:00','2022-07-25 15:23:00',9780,'gdpr',122.25,NULL,45,1,'Europe/Rome',122.25,1,'work','2022-09-15 09:26:27','2022-07-25'),
(2730,3,1,26,'2022-07-25 09:20:00','2022-07-25 09:45:00',1500,'Assistenza su pc client Claudio Banci',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-10-07 15:45:19','2022-07-25'),
(2731,3,1,88,'2022-07-25 15:20:00','2022-07-25 15:30:00',600,'Modificata password mail direzione@softability.it',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-16 14:12:29','2022-07-25'),
(2732,3,2,2,'2022-07-26 14:40:00','2022-07-26 15:15:00',2100,'Sostituzione batteria ups su postazione client Laura\r\nAssistenza su PC client Valeria \r\nAssistenza su telecamera Magazzino',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-21 15:46:31','2022-07-26'),
(2733,1,1,3,'2022-07-26 06:46:00','2022-07-26 10:26:00',13200,'gdpr',165,NULL,45,1,'Europe/Rome',165,1,'work','2022-09-15 09:26:27','2022-07-26'),
(2734,1,1,22,'2022-07-26 13:41:00','2022-07-26 14:23:00',2520,'problemi vpn dopo cambio operatore ci sta lavorando federico',31.5,NULL,45,1,'Europe/Rome',31.5,1,'work','2022-10-04 16:04:33','2022-07-26'),
(2735,1,1,3,'2022-07-26 12:47:00','2022-07-26 13:37:00',3000,'gdpr',37.5,NULL,45,1,'Europe/Rome',37.5,1,'work','2022-09-15 09:26:27','2022-07-26'),
(2736,1,1,50,'2022-07-26 14:35:00','2022-07-26 15:30:00',3300,'spostamento we4borker',41.25,NULL,45,1,'Europe/Rome',41.25,1,'work','2022-08-29 15:09:02','2022-07-26'),
(2737,1,1,96,'2022-07-26 15:59:00','2022-07-26 16:20:41',1301,'problema invio mail',16.26,NULL,45,1,'Europe/Rome',16.26,1,'work','2022-09-14 06:58:03','2022-07-26'),
(2738,3,1,55,'2022-07-26 08:00:00','2022-07-26 08:15:00',900,'Assistenza su pc client Otto per problemi stampante',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-16 16:23:39','2022-07-26'),
(2739,3,1,41,'2022-07-26 08:45:00','2022-07-26 09:10:00',1500,'Installate 3 licenze nod32 aggiornamento su 5 pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-16 16:22:32','2022-07-26'),
(2740,3,1,90,'2022-07-26 09:35:00','2022-07-26 09:45:00',600,'Assistenza su pc client Giulia',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-22 15:48:22','2022-07-26'),
(2741,3,1,88,'2022-07-26 10:15:00','2022-07-26 10:35:00',1200,'Assistenza su pc client Piazza per problemi con mail direzione',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-16 15:06:49','2022-07-26'),
(2742,3,1,2,'2022-07-26 13:00:00','2022-07-26 13:10:00',600,'Assistenza su pc client Laura per rinnovo password Windows',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-21 15:46:29','2022-07-26'),
(2743,3,1,22,'2022-07-26 13:15:00','2022-07-26 13:45:00',1800,'Assistenza per prblemi collegamento vpn dopo cambio operatore internet, da verificare in loco',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-10-04 16:05:16','2022-07-26'),
(2744,1,1,110,'2022-07-27 06:33:00','2022-07-27 07:38:00',3900,'raccolta dati per incontro in loro ufficioi',48.75,NULL,45,1,'Europe/Rome',48.75,1,'work','2022-09-16 15:20:20','2022-07-27'),
(2745,1,2,110,'2022-07-27 08:24:00','2022-07-27 11:35:00',11460,'Incontro per stabilire i lavori da effettuare sui loro server\r\n30 min per il ritorno',143.25,NULL,45,1,'Europe/Rome',143.25,1,'work','2022-09-16 15:20:22','2022-07-27'),
(2746,3,1,2,'2022-07-27 09:15:00','2022-07-27 09:50:00',2100,'Installata e configurata nuova licenza office 2021 Home&Business su pc client Valentina\r\nCreata e configurata mail amministrazione su pc client Valentina, Laura e Cevasco',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-21 15:46:24','2022-07-27'),
(2747,3,1,10,'2022-07-27 12:40:00','2022-07-27 12:50:00',600,'Assistenza su pc client Francesca',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-22 09:46:34','2022-07-27'),
(2748,1,4,3,'2022-07-08 08:17:00','2022-07-08 09:40:00',4980,'in lab',62.25,NULL,45,1,'Europe/Rome',62.25,1,'work','2022-09-15 09:26:31','2022-07-08'),
(2749,1,1,50,'2022-07-08 09:57:00','2022-07-08 10:29:00',1920,'gestionale',24,NULL,45,1,'Europe/Rome',24,1,'work','2022-08-29 15:08:44','2022-07-08'),
(2750,1,1,50,'2022-07-08 12:46:00','2022-07-08 14:46:00',7200,'gestionale e pulizia disco',90,NULL,45,1,'Europe/Rome',90,1,'work','2022-08-29 15:08:49','2022-07-08'),
(2751,1,1,75,'2022-07-08 15:05:00','2022-07-08 16:08:00',3780,'agg nas',47.25,NULL,45,1,'Europe/Rome',47.25,1,'work','2022-09-21 14:06:47','2022-07-08'),
(2752,1,1,3,'2022-07-08 16:10:00','2022-07-08 16:28:00',1080,'fogli',13.5,NULL,45,1,'Europe/Rome',13.5,1,'work','2022-09-15 09:26:50','2022-07-08'),
(2753,1,4,3,'2022-07-11 07:47:00','2022-07-11 08:02:00',900,'in lab',11.25,NULL,45,1,'Europe/Rome',11.25,1,'work','2022-09-15 09:26:30','2022-07-11'),
(2754,1,1,29,'2022-07-11 12:40:00','2022-07-11 13:22:00',2520,'verifica software ups nuovo',31.5,NULL,45,1,'Europe/Rome',31.5,1,'work','2022-08-31 15:29:08','2022-07-11'),
(2755,1,1,90,'2022-07-11 14:01:00','2022-07-11 16:23:00',8520,'agg vari',106.5,NULL,45,1,'Europe/Rome',106.5,1,'work','2022-09-22 15:48:20','2022-07-11'),
(2756,1,1,26,'2022-07-15 15:49:00','2022-07-15 16:30:00',2460,'prob sito nuovo',30.75,NULL,45,1,'Europe/Rome',30.75,1,'work','2022-10-07 15:45:12','2022-07-15'),
(2757,1,1,3,'2022-07-19 15:32:00','2022-07-19 16:26:00',3240,'test postfixa dmin',40.5,NULL,45,1,'Europe/Rome',40.5,1,'work','2022-09-15 09:26:44','2022-07-19'),
(2758,1,1,103,'2022-07-18 06:45:00','2022-07-18 09:00:00',8100,'prob agg 1 vm',101.25,NULL,45,1,'Europe/Rome',101.25,1,'work','2022-12-08 12:03:38','2022-07-18'),
(2759,1,1,115,'2022-07-18 09:12:00','2022-07-18 10:27:00',4500,'problema sito',56.25,NULL,45,1,'Europe/Rome',56.25,1,'work','2022-09-16 16:00:09','2022-07-18'),
(2760,1,1,115,'2022-07-18 12:42:00','2022-07-18 14:22:00',6000,'problema sito web',75,NULL,45,1,'Europe/Rome',75,1,'work','2022-09-16 16:00:10','2022-07-18'),
(2761,1,1,110,'2022-07-27 12:46:00','2022-07-27 17:00:00',15240,'varie per lavori da effettuare sopratutto nextcloud',190.5,NULL,45,1,'Europe/Rome',190.5,1,'work','2022-09-16 15:20:23','2022-07-27'),
(2762,1,1,3,'2022-07-28 06:46:00','2022-07-28 07:28:00',2520,'fogli',31.5,NULL,45,1,'Europe/Rome',31.5,1,'work','2022-09-15 09:26:27','2022-07-28'),
(2763,1,1,96,'2022-07-28 12:42:00','2022-07-28 13:14:00',1920,'problema mail cristina musso',24,NULL,45,1,'Europe/Rome',24,1,'work','2022-09-14 06:57:51','2022-07-28'),
(2764,1,1,75,'2022-07-28 13:15:00','2022-07-28 13:32:00',1020,'problema invio mail SMTPUTF8',12.75,NULL,45,1,'Europe/Rome',12.75,1,'work','2022-09-21 14:06:52','2022-07-28'),
(2765,1,3,112,'2022-07-28 09:30:00','2022-07-28 10:30:00',3600,NULL,45,NULL,45,1,'Europe/Rome',45,1,'work','2022-09-15 09:25:24','2022-07-28'),
(2766,3,2,6,'2022-07-28 13:40:00','2022-07-28 13:55:00',900,'Riconsegnato portatile Acer dopo assistenza su scocche',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-21 09:32:24','2022-07-28'),
(2767,1,1,76,'2022-07-28 14:22:00','2022-07-28 14:43:15',1275,'portatile problema lentezza',15.94,NULL,45,1,'Europe/Rome',15.94,1,'work','2022-08-30 08:34:23','2022-07-28'),
(2768,1,1,110,'2022-07-28 13:48:00','2022-07-28 14:10:00',1320,'riepilogo per preventivo',16.5,NULL,45,1,'Europe/Rome',16.5,1,'work','2022-09-16 15:20:24','2022-07-28'),
(2769,3,2,26,'2022-07-28 14:05:00','2022-07-28 14:45:00',2400,'Consegna cartuccia Epson originale e toner Brother compatibile, assistenza su PC client Sola, assistenza su wifi per problemi collegamento',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-10-07 15:45:13','2022-07-28'),
(2770,3,2,2,'2022-07-28 15:05:00','2022-07-28 15:45:00',2400,'Sostituzione switch 10/100 con switch gigabit 8porte 435820, spostamento dischi di backup da vecchio a nuovo server, assistenza su PC client stefano per problemi su monitor secondario',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-21 15:46:35','2022-07-28'),
(2771,1,1,2,'2022-07-28 20:30:00','2022-07-28 21:45:00',4500,'configurazione backuppc sui dischi di backup firewall nuovo',56.25,NULL,45,1,'Europe/Rome',56.25,1,'work','2022-09-21 15:46:30','2022-07-28'),
(2772,1,1,3,'2022-07-28 14:50:00','2022-07-28 17:00:00',7800,'varie xplored aiuto fede da cristallina e punto sui lavori da chiudere',97.5,NULL,45,1,'Europe/Rome',97.5,1,'work','2022-09-15 09:26:30','2022-07-28'),
(2773,3,2,22,'2022-07-29 07:20:00','2022-07-29 09:10:00',6600,'Assistenza per problemi su vpn dopo cambio operatore internet',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-10-04 16:13:16','2022-07-29'),
(2774,1,1,64,'2022-07-29 09:09:00','2022-07-29 10:13:03',3843,'problema ricezione mail',48.04,NULL,45,1,'Europe/Rome',48.04,1,'work','2022-09-20 15:32:11','2022-07-29'),
(2775,3,2,79,'2022-07-29 09:20:00','2022-07-29 09:30:00',600,'Consegna toner compatibili Brother',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-16 09:23:40','2022-07-29'),
(2776,3,2,24,'2022-07-29 09:40:00','2022-07-29 09:50:00',600,'Consegna cartuccia originale Epson',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-07 14:43:01','2022-07-29'),
(2777,3,2,76,'2022-07-29 10:00:00','2022-07-29 10:15:00',900,'Verificato e ritirato portatile Dell per assistenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-08-30 08:34:24','2022-07-29'),
(2778,1,1,3,'2022-07-29 06:31:00','2022-07-29 09:00:00',8940,'varie laboratorio',111.75,NULL,45,1,'Europe/Rome',111.75,1,'work','2022-09-15 09:26:51','2022-07-29'),
(2779,1,1,87,'2022-07-29 12:51:00','2022-07-29 13:07:00',960,'verifica per pos di rete',12,NULL,45,1,'Europe/Rome',12,1,'work','2022-09-29 15:50:57','2022-07-29'),
(2780,1,1,22,'2022-07-29 13:46:00','2022-07-29 14:44:00',3480,'problemi vpn dopo cambio router',43.5,NULL,45,1,'Europe/Rome',43.5,1,'work','2022-10-04 16:13:16','2022-07-29'),
(2781,1,1,3,'2022-07-29 12:30:00','2022-07-29 12:50:00',1200,'zabbix',15,NULL,45,1,'Europe/Rome',15,1,'work','2022-09-15 09:26:51','2022-07-29'),
(2782,1,1,3,'2022-07-29 13:15:00','2022-07-29 13:44:00',1740,'zabbix',21.75,NULL,45,1,'Europe/Rome',21.75,1,'work','2022-09-15 09:26:36','2022-07-29'),
(2783,1,1,3,'2022-07-29 14:53:00','2022-07-29 16:30:00',5820,'zabbix',72.75,NULL,45,1,'Europe/Rome',72.75,1,'work','2022-09-15 09:26:35','2022-07-29'),
(2784,3,1,96,'2022-07-28 09:40:00','2022-07-28 10:20:00',2400,'Assistenza su pc client Cristina per problemi posta',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-14 06:58:04','2022-07-28'),
(2785,3,1,79,'2022-07-28 10:25:00','2022-07-28 10:35:00',600,'Assistenza su pc client Paola C per problemi con OneDrive',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-16 09:25:13','2022-07-28'),
(2786,3,1,96,'2022-07-29 13:20:00','2022-07-29 13:35:00',900,'Assistenza pc client Federica per Desktop Telematico\r\nRegistrato mess segreteria ferie',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-14 06:57:50','2022-07-29'),
(2787,3,2,87,'2022-08-01 09:25:00','2022-08-01 10:10:00',2700,'Assistenza per configurare pos nexi, devono intervenire i loro tecnici \r\nFare offerta per nuovo PC client Danila + Office + tastiera e mouse',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-29 15:50:55','2022-08-01'),
(2788,3,4,76,'2022-08-01 06:30:00','2022-08-01 07:30:00',3600,'Assistenza su portatile ritirato: clonazione s.o su ssd 480 S3+ + aggiunta 4 gb ddr4 sodim',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-08-30 08:34:25','2022-08-01'),
(2789,3,1,79,'2022-08-01 07:40:00','2022-08-01 07:50:00',600,'Assistenza su pc client Andrea',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-16 09:23:53','2022-08-01'),
(2790,3,1,114,'2022-08-01 13:00:00','2022-08-01 13:45:00',2700,'Assistenza su pc client Joshua per problemi con vpn WireGuard',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-16 09:37:19','2022-08-01'),
(2791,3,1,90,'2022-08-01 13:50:00','2022-08-01 14:00:00',600,'Assistenza su pc client Campodoni',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-22 15:48:23','2022-08-01'),
(2792,3,1,41,'2022-08-01 15:00:00','2022-08-01 15:15:00',900,'Recuperati tutti codici attivazione nod32 per i pc client che verranno reinstallati',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-16 16:22:33','2022-08-01'),
(2793,3,2,76,'2022-08-02 08:45:00','2022-08-02 09:00:00',900,'Riconsegnato portatile dopo assistenza e  upgrade hw',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-08-30 08:34:27','2022-08-02'),
(2794,3,2,50,'2022-08-02 09:25:00','2022-08-02 10:10:00',2700,'Assistenza per rete internet instabile, nessun problema rilevato. Installata licenza nod32 completa su PC personale Pietro',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-14 13:43:47','2022-08-02'),
(2795,3,2,2,'2022-08-02 15:30:00','2022-08-02 16:00:00',1800,'Sostituzione alimentatore cm 500w su PC client Andrea',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-21 15:46:40','2022-08-02'),
(2796,3,1,75,'2022-08-02 13:10:00','2022-08-02 13:25:00',900,'Assistenza su pc client Stoehr',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-21 14:06:56','2022-08-02'),
(2797,3,1,22,'2022-08-02 13:30:00','2022-08-02 13:40:00',600,'Assistenza su pc client Stefano per problemi con casse bluetooth',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-10-04 16:13:17','2022-08-02'),
(2798,3,1,26,'2022-08-02 14:50:00','2022-08-02 15:00:00',600,'Contattato Zanetti di GMG Net per problemi su sito Confindistria Liguria',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-11-10 15:31:43','2022-08-02'),
(2799,3,1,75,'2022-08-03 13:40:00','2022-08-03 14:15:00',2100,'Assistenza su pc casa erika per problemi collegamento in vpn',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-21 14:06:52','2022-08-03'),
(2800,3,1,79,'2022-08-03 14:20:00','2022-08-03 14:35:00',900,'Assistenza per reidirect pec su mail personale Roberto, andare in loco per configurare pec su cellulare',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-16 09:25:14','2022-08-03'),
(2801,3,1,50,'2022-08-03 14:50:00','2022-08-03 15:50:00',3600,'Assistenza per problemi su posta causa ip listato in blacklist, comunicato a Francesco di liberare spazio su server causa limite arrivato al 91%',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-14 13:43:49','2022-08-03'),
(2802,1,1,29,'2022-08-04 06:55:00','2022-08-04 07:18:00',1380,'problema backup xdent si è autospostato sul desktop saturando il disco c del server, pulito disco c spostato backup e interrotto backup per far riprendere il lavoro al cliente',17.25,NULL,45,1,'Europe/Rome',17.25,1,'work','2022-08-31 15:29:30','2022-08-04'),
(2803,3,2,79,'2022-08-04 09:00:00','2022-08-04 10:00:00',3600,'Assistenza e configurazione 3 account mail su cellulare Roberto e Andrea, assistenza su PC client Paolo, ordinare tamburo per Brother HL - L8260CDW',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-16 09:23:31','2022-08-04'),
(2804,3,1,95,'2022-08-04 16:10:00','2022-08-04 16:30:00',1200,'Installata e configurata vpn su PC casa Mara',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-07 14:19:18','2022-08-04'),
(2805,3,1,41,'2022-08-05 13:45:00','2022-08-05 14:00:00',900,'Assistenza a Roberto per reinstallazione nod32 su pc client Gulli',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-16 16:22:33','2022-08-05'),
(2806,3,1,79,'2022-08-05 14:05:00','2022-08-05 14:15:00',600,'Assistenza a Paola C. per messaggio posta fuori ufficio su Aruba',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-16 09:25:15','2022-08-05'),
(2807,3,1,26,'2022-08-05 15:45:00','2022-08-05 16:00:00',900,'Assistenza su pc client Banci',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-10-07 15:45:20','2022-08-05'),
(2808,3,1,95,'2022-08-05 16:10:00','2022-08-05 16:30:00',1200,'Installata e configurata vpn su pc casa Anna',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-07 14:19:19','2022-08-05'),
(2809,1,1,29,'2022-08-08 07:16:00','2022-08-08 07:34:00',1080,'problema backup xdent si è autospostato sul desktop saturando il disco c del server, pulito disco c spostato backup e interrotto backup per far riprendere il lavoro al cliente',13.5,NULL,45,1,'Europe/Rome',13.5,1,'work','2022-08-31 15:29:31','2022-08-08'),
(2810,3,2,96,'2022-08-08 07:00:00','2022-08-08 09:00:00',7200,'Assistenza per problemi funzionamento AGO dopo aggiornamento kernel su server',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-13 09:58:26','2022-08-08'),
(2811,3,1,50,'2022-08-08 12:50:00','2022-08-08 13:15:00',1500,'Assistenza su PC client Giuseppe per problemi di posta',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-14 13:43:50','2022-08-08'),
(2812,3,2,50,'2022-08-09 13:00:00','2022-08-09 14:30:00',5400,'Assistenza su portatile Giuseppe per problemi su Thunderbird',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-14 13:43:52','2022-08-09'),
(2813,3,1,101,'2022-08-10 08:00:00','2022-08-10 08:15:00',900,'Assistenza su un pc client di casa per problemi collegamento con VPN',0,NULL,0,0,'Europe/Rome',0,1,'work','2022-08-10 08:14:47','2022-08-10'),
(2814,3,1,87,'2022-08-10 08:20:00','2022-08-10 08:30:00',600,'Assistenza per problemi ricezione posta, riavviati servizi di posta',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-29 15:50:55','2022-08-10'),
(2815,3,2,87,'2022-08-10 12:30:00','2022-08-10 13:10:00',2400,'Assistenza per problema su posta elettronica',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-29 15:53:16','2022-08-10'),
(2816,3,2,45,'2022-08-10 13:15:00','2022-08-10 13:40:00',1500,'Sostituzione 1 batteria su ups apc 900 collegato al server',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-14 10:00:50','2022-08-10'),
(2817,3,1,100,'2022-08-10 16:15:00','2022-08-10 16:30:00',900,'Assistenza per problemi posta elettronica',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-11-21 14:18:42','2022-08-10'),
(2818,1,1,104,'2022-08-16 07:12:00','2022-08-16 07:29:53',1073,'problema mail certrificato',13.41,NULL,45,1,'Europe/Rome',13.41,1,'work','2022-10-27 13:31:02','2022-08-16'),
(2819,1,1,50,'2022-08-16 07:57:00','2022-08-16 08:04:25',445,'cambio config centralino per girare chiamate su numero di elisabetta',5.56,NULL,45,1,'Europe/Rome',5.56,1,'work','2022-09-14 13:43:52','2022-08-16'),
(2820,1,6,5,'2022-08-22 10:50:00','2022-08-22 11:03:13',793,'problema connessione pc officina',9.91,NULL,45,1,'Europe/Rome',9.91,1,'work','2023-01-17 17:01:50','2022-08-22'),
(2821,1,1,79,'2022-08-26 07:26:00','2022-08-26 07:45:37',1177,'prob posta paola',14.71,NULL,45,1,'Europe/Rome',14.71,1,'work','2022-09-16 09:23:39','2022-08-26'),
(2822,3,2,95,'2022-08-29 08:20:00','2022-08-29 08:30:00',600,'Consegnata e installata tastiera usb su PC client Mara',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-07 14:19:20','2022-08-29'),
(2823,3,2,29,'2022-08-29 09:00:00','2022-08-29 09:25:00',1500,'Verificato e ritirato pc client per assistenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-08-31 15:37:51','2022-08-29'),
(2824,3,2,79,'2022-08-29 13:00:00','2022-08-29 13:20:00',1200,'Consegna e installazione tamburo per stampante Brother (67353) + pulizia stampante',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-16 09:25:16','2022-08-29'),
(2825,3,2,103,'2022-08-29 14:15:00','2022-08-29 14:35:00',1200,'Assistenza su ups apc 900 dopo mancata corrente negli uffici, ritirato telefono voip per test configurazione',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-12-15 10:40:18','2022-08-29'),
(2826,3,1,64,'2022-08-29 07:30:00','2022-08-29 07:50:00',1200,'Assistenza su pc client Mirella e Valentina',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-20 15:32:10','2022-08-29'),
(2827,1,4,3,'2022-08-29 06:30:00','2022-08-29 07:00:00',1800,'in lab',22.5,NULL,45,1,'Europe/Rome',22.5,1,'work','2022-09-15 09:26:41','2022-08-29'),
(2828,1,1,2,'2022-08-29 07:23:00','2022-08-29 09:40:00',8220,'verifica config e sistemazione certbot',102.75,NULL,45,1,'Europe/Rome',102.75,1,'work','2022-09-21 15:46:47','2022-08-29'),
(2829,1,1,3,'2022-08-29 09:51:00','2022-08-29 10:28:00',2220,'punto situzione lavori da chiudere per tutti i clienti',27.75,NULL,45,1,'Europe/Rome',27.75,1,'work','2022-09-15 09:26:35','2022-08-29'),
(2830,1,1,3,'2022-08-29 12:45:00','2022-08-29 15:38:00',10380,'punto situzione lavori da chiudere per tutti i clienti',129.75,NULL,45,1,'Europe/Rome',129.75,1,'work','2022-09-15 09:26:35','2022-08-29'),
(2831,1,1,26,'2022-08-29 15:44:00','2022-08-29 16:18:00',2040,'verifica per problemi mail',25.5,NULL,45,1,'Europe/Rome',25.5,1,'work','2022-10-07 15:45:22','2022-08-29'),
(2832,1,1,3,'2022-08-29 16:19:00','2022-08-29 16:29:00',600,'punto situzione lavori da chiudere per tutti i clienti',7.5,NULL,45,1,'Europe/Rome',7.5,1,'work','2022-09-15 09:26:33','2022-08-29'),
(2833,1,1,79,'2022-08-30 12:46:00','2022-08-30 14:26:47',6047,'problemi dopo salto corrente',75.59,NULL,45,1,'Europe/Rome',75.59,1,'work','2022-09-16 09:25:18','2022-08-30'),
(2834,3,4,29,'2022-08-30 08:00:00','2022-08-30 09:00:00',3600,'Reinstallazione sistema operativo su pc client ritirato\r\nUtilizzato ssd 480gb S3+',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-08-31 15:37:52','2022-08-30'),
(2835,3,2,29,'2022-08-31 08:50:00','2022-08-31 11:00:00',7800,'Riconsegna e configurazione PC client postazione viola, da finire di risolvere remotamente problema su xdent + riconsegna ups dopo sostituzione batteria',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-08-31 15:37:53','2022-08-31'),
(2836,1,1,50,'2022-08-31 08:03:00','2022-08-31 10:30:00',8820,'pulizia server',110.25,NULL,45,1,'Europe/Rome',110.25,1,'work','2022-09-14 13:43:54','2022-08-31'),
(2837,1,1,3,'2022-08-31 06:45:00','2022-08-31 07:49:00',3840,'backup remoti libro',48,NULL,45,1,'Europe/Rome',48,1,'work','2022-09-15 09:26:34','2022-08-31'),
(2838,1,1,2,'2022-08-30 06:46:00','2022-08-30 09:00:00',8040,'agg server',100.5,NULL,45,1,'Europe/Rome',100.5,1,'work','2022-09-21 14:54:52','2022-08-30'),
(2839,1,1,90,'2022-08-30 10:00:00','2022-08-30 10:25:00',1500,'agg server',18.75,NULL,45,1,'Europe/Rome',18.75,1,'work','2022-09-22 15:48:24','2022-08-30'),
(2840,1,1,90,'2022-08-30 14:37:00','2022-08-30 16:26:00',6540,'agg server',81.75,NULL,45,1,'Europe/Rome',81.75,1,'work','2022-09-22 15:48:24','2022-08-30'),
(2841,3,2,4,'2022-08-31 14:55:00','2022-08-31 15:05:00',600,'Ritirare pc client per possibile upgrade hw',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-23 15:55:49','2022-08-31'),
(2842,1,1,26,'2022-08-30 09:03:00','2022-08-30 09:45:00',2520,'probemi gmail',31.5,NULL,45,1,'Europe/Rome',31.5,1,'work','2022-10-07 15:45:14','2022-08-30'),
(2843,3,1,79,'2022-08-31 06:45:00','2022-08-31 07:15:00',1800,'Assistenza su pc client Matteo',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-16 09:24:20','2022-08-31'),
(2844,3,1,51,'2022-08-31 07:40:00','2022-08-31 07:55:00',900,'Assistenza su pc client Gallamini per reinstallazione nod32 su nuovo pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-01 14:09:52','2022-08-31'),
(2845,3,1,29,'2022-08-31 12:40:00','2022-08-31 12:55:00',900,'Risolto problema con CGMXRay su pc client riconsegnato',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-01 13:11:09','2022-08-31'),
(2846,1,1,3,'2022-08-31 15:10:00','2022-08-31 16:28:00',4680,'problemi 3cx',58.5,NULL,45,1,'Europe/Rome',58.5,1,'work','2022-09-15 09:26:34','2022-08-31'),
(2847,1,1,50,'2022-08-31 12:42:00','2022-08-31 14:07:00',5100,'we4broker',63.75,NULL,45,1,'Europe/Rome',63.75,1,'work','2022-09-14 13:43:55','2022-08-31'),
(2848,1,1,9,'2022-08-31 14:22:00','2022-08-31 15:00:00',2280,'inizio verifiche per migrazione posta',28.5,NULL,45,1,'Europe/Rome',28.5,1,'work','2023-02-03 08:46:38','2022-08-31'),
(2849,1,1,88,'2022-09-01 09:43:00','2022-09-01 10:33:00',3000,'problemi posta su un client',37.5,NULL,45,1,'Europe/Rome',37.5,1,'work','2022-09-16 15:06:50','2022-09-01'),
(2850,1,1,88,'2022-09-01 12:37:00','2022-09-01 13:11:00',2040,'problemi posta su un client',25.5,NULL,45,1,'Europe/Rome',25.5,1,'work','2022-09-16 15:06:51','2022-09-01'),
(2851,1,2,3,'2022-09-01 07:01:00','2022-09-01 09:00:00',7140,'Soprauogo da acli nuovo cliente con te',89.25,NULL,45,1,'Europe/Rome',89.25,1,'work','2022-09-15 09:26:34','2022-09-01'),
(2852,1,1,3,'2022-09-01 13:12:00','2022-09-01 13:16:00',240,'foglio roari',3,NULL,45,1,'Europe/Rome',3,1,'work','2022-09-15 09:26:42','2022-09-01'),
(2853,1,1,57,'2022-09-01 13:27:00','2022-09-01 16:34:33',11253,'problema backup locale\r\nproblema invio mail backup',140.66,NULL,45,1,'Europe/Rome',140.66,1,'work','2022-09-14 13:47:49','2022-09-01'),
(2854,1,1,57,'2022-09-01 20:01:00','2022-09-01 20:46:00',2700,'problema backup locale\r\nproblema invio mail backup',33.75,NULL,45,1,'Europe/Rome',33.75,1,'work','2022-09-14 13:47:51','2022-09-01'),
(2855,3,1,26,'2022-09-01 08:10:00','2022-09-01 08:50:00',2400,'Assistenza su pc client Simona',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-10-07 15:45:15','2022-09-01'),
(2856,1,1,88,'2022-09-02 07:35:00','2022-09-02 07:54:59',1199,'problemi mail cirimele',14.99,NULL,45,1,'Europe/Rome',14.99,1,'work','2022-09-16 15:06:52','2022-09-02'),
(2857,1,1,79,'2022-09-02 06:49:00','2022-09-02 07:20:00',1860,'problemi backuppc su vm onda',23.25,NULL,45,1,'Europe/Rome',23.25,1,'work','2022-09-16 09:24:20','2022-09-02'),
(2858,1,1,79,'2022-09-02 08:07:00','2022-09-02 10:27:00',8400,'risoluzione problemi invio mail backuppc',105,NULL,45,1,'Europe/Rome',105,1,'work','2022-09-16 09:05:01','2022-09-02'),
(2859,3,1,75,'2022-09-02 14:10:00','2022-09-02 14:35:00',1500,'Assistenza su pc client Luca Bagnasco',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-21 14:06:54','2022-09-02'),
(2860,1,1,4,'2022-09-05 07:05:00','2022-09-05 10:25:00',12000,'confgi vpn su mac\r\nproblmi a raggiungere server via nostra vpn, segnalato ad alex',150,NULL,45,1,'Europe/Rome',150,1,'work','2022-09-23 15:55:26','2022-09-05'),
(2861,1,1,26,'2022-09-05 13:26:00','2022-09-05 14:00:00',2040,'problemi collegamento sito gmg net',25.5,NULL,45,1,'Europe/Rome',25.5,1,'work','2022-10-07 15:45:16','2022-09-05'),
(2862,1,1,50,'2022-09-05 12:39:00','2022-09-05 13:19:00',2400,'per nuovo server we4boker',30,NULL,45,1,'Europe/Rome',30,1,'work','2022-09-14 13:43:56','2022-09-05'),
(2863,3,1,4,'2022-09-05 06:50:00','2022-09-05 07:10:00',1200,'Assistenza su portatile Alessandra per collegamento Server e installazione stampante',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-10-07 16:44:39','2022-09-05'),
(2864,3,1,79,'2022-09-05 07:40:00','2022-09-05 08:00:00',1200,'Assistenza su pc client Paola Colladon per problemi accesso a One Drive',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-16 09:24:07','2022-09-05'),
(2865,3,1,26,'2022-09-05 13:15:00','2022-09-05 14:25:00',4200,'Risolto problema download file su pc client Simona',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-10-07 15:45:15','2022-09-05'),
(2866,3,2,95,'2022-09-06 07:20:00','2022-09-06 08:00:00',2400,'Assistenza su PC client Silvia, da consegnare nuovo monitor 22\".\r\nAssistenza su PC client Porcile',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-07 14:19:20','2022-09-06'),
(2867,3,2,95,'2022-09-06 12:30:00','2022-09-06 12:50:00',1200,'Consegna e installazione nuovo monitor su postazione client Silvia',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-07 14:19:22','2022-09-06'),
(2868,1,2,47,'2022-09-06 08:06:00','2022-09-06 09:22:00',4560,'con te da fbsteeel per preventivo',57,NULL,45,1,'Europe/Rome',57,1,'work','2022-09-15 10:31:30','2022-09-06'),
(2869,1,1,79,'2022-09-06 09:46:00','2022-09-06 11:00:00',4440,'wordpress su container',55.5,NULL,45,1,'Europe/Rome',55.5,1,'work','2022-09-16 09:24:22','2022-09-06'),
(2870,1,1,79,'2022-09-06 12:04:00','2022-09-06 13:27:00',4980,'wordpress su container',62.25,NULL,45,1,'Europe/Rome',62.25,1,'work','2022-09-16 09:24:23','2022-09-06'),
(2871,1,1,114,'2022-09-06 07:42:00','2022-09-06 08:00:00',1080,'creazione e test nuove chiavi vpn richieste',13.5,NULL,45,1,'Europe/Rome',13.5,1,'work','2022-09-16 09:37:29','2022-09-06'),
(2872,1,1,4,'2022-09-05 14:18:00','2022-09-05 16:30:00',7920,'problemi openvpn abvolt',99,NULL,45,1,'Europe/Rome',99,1,'work','2022-09-23 15:55:29','2022-09-05'),
(2873,1,1,3,'2022-09-06 06:36:00','2022-09-06 07:28:00',3120,'problemi martian su proxmox',39,NULL,45,1,'Europe/Rome',39,1,'work','2022-09-15 09:26:40','2022-09-06'),
(2874,3,2,79,'2022-09-06 13:10:00','2022-09-06 14:30:00',4800,'Risolto problema accesso Office su PC client Paola Agnoletto, risolto problema scansione sporca su stampante Magazzino. Verificate tutte le postazioni per Qualità, verificati dispositivinon sotto ups nell\'armadio rack, da aggiungere ciabatta ups',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-16 09:24:28','2022-09-06'),
(2875,3,2,41,'2022-09-06 15:00:00','2022-09-06 16:00:00',3600,'Assistenza su server in via Wagner per problema ventole rumorose',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-16 16:22:34','2022-09-06'),
(2876,1,1,3,'2022-09-07 06:47:00','2022-09-07 09:00:00',7980,'problemi martian su proxmox',99.75,NULL,45,1,'Europe/Rome',99.75,1,'work','2022-09-15 09:26:42','2022-09-07'),
(2877,1,1,3,'2022-09-06 13:48:00','2022-09-06 16:22:00',9240,'problemi martian su proxmox',115.5,NULL,45,1,'Europe/Rome',115.5,1,'work','2022-09-15 09:26:37','2022-09-06'),
(2878,1,1,51,'2022-09-07 10:06:00','2022-09-07 10:22:00',960,'aiutato fede config samba',12,NULL,45,1,'Europe/Rome',12,1,'work','2022-09-22 09:47:10','2022-09-07'),
(2879,1,1,50,'2022-09-07 09:12:00','2022-09-07 09:58:00',2760,'spazio disco',34.5,NULL,45,1,'Europe/Rome',34.5,1,'work','2022-09-14 13:43:58','2022-09-07'),
(2880,1,4,3,'2022-09-02 12:35:00','2022-09-02 16:30:00',14100,'risolto problemi vari durante controlli fede',176.25,NULL,45,1,'Europe/Rome',176.25,1,'work','2022-09-15 09:26:41','2022-09-02'),
(2881,3,1,75,'2022-09-07 07:05:00','2022-09-07 07:20:00',900,'Assistenza per avvio NAS dopo che è mancata la corrente',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-21 14:06:51','2022-09-07'),
(2882,3,1,79,'2022-09-07 07:25:00','2022-09-07 07:40:00',900,'Assistenza per problemi su posta elettronica',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-16 09:25:19','2022-09-07'),
(2883,3,1,17,'2022-09-07 07:55:00','2022-09-07 08:05:00',600,'Assistenza per problemi lentezza navigazione',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-14 07:29:22','2022-09-07'),
(2884,3,1,79,'2022-09-07 08:50:00','2022-09-07 09:10:00',1200,'Assistenza su pc client Paola Agnoletto per problemi condivisione file su OneDrive',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-16 09:24:44','2022-09-07'),
(2885,3,1,51,'2022-09-07 09:20:00','2022-09-07 10:00:00',2400,'Assistenza su pc client Michele Gallamini e Massimo Saccardi\r\nUtilizzata 1 licenza nod32 completa',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-07 10:33:26','2022-09-07'),
(2886,3,2,24,'2022-09-07 12:50:00','2022-09-07 13:05:00',900,'Consegnata cartuccia Epson originale + pulizia testine stampante',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-07 14:43:02','2022-09-07'),
(2887,3,1,22,'2022-09-07 13:30:00','2022-09-07 14:00:00',1800,'Assistenza su pc client  padre, da agg. a Windows 10',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-10-04 16:13:18','2022-09-07'),
(2888,3,4,79,'2022-09-07 14:10:00','2022-09-07 14:20:00',600,'Aggiornato ed inviato documento infrastruttura infoirmatica',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-16 09:24:44','2022-09-07'),
(2889,1,1,4,'2022-09-08 07:28:00','2022-09-08 09:07:21',5961,'configurazione mac vpn',74.51,NULL,45,1,'Europe/Rome',74.51,1,'work','2022-10-07 16:44:40','2022-09-08'),
(2890,1,1,81,'2022-09-07 12:45:00','2022-09-07 14:00:00',4500,'agg server',56.25,NULL,45,1,'Europe/Rome',56.25,1,'work','2022-09-16 09:30:02','2022-09-07'),
(2891,1,1,29,'2022-09-07 14:17:00','2022-09-07 16:28:00',7860,'agg server e sistemazione martian',98.25,NULL,45,1,'Europe/Rome',98.25,1,'work','2023-01-16 10:44:43','2022-09-07'),
(2892,1,1,5,'2022-09-08 06:44:00','2022-09-08 07:20:00',2160,'agg server',27,NULL,45,1,'Europe/Rome',27,1,'work','2022-10-05 08:58:47','2022-09-08'),
(2893,1,1,5,'2022-09-08 09:15:00','2022-09-08 10:28:00',4380,'agg server',54.75,NULL,45,1,'Europe/Rome',54.75,1,'work','2022-10-05 08:58:49','2022-09-08'),
(2894,3,1,18,'2022-09-08 08:15:00','2022-09-08 08:30:00',900,'Assistenza su pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-15 10:00:41','2022-09-08'),
(2895,3,1,26,'2022-09-08 14:00:00','2022-09-08 14:10:00',600,'Assistenza su pc client Simona',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-10-07 15:45:17','2022-09-08'),
(2896,3,2,22,'2022-09-08 15:50:00','2022-09-08 16:05:00',900,'Assistenza su pc casa Boccaleri Pietro',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-10-04 16:13:19','2022-09-08'),
(2897,3,2,41,'2022-09-09 13:55:00','2022-09-09 14:25:00',1800,'Verificato e ritirato ups per sostituzione batteria, offrire nuovo ups per pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-16 16:22:36','2022-09-09'),
(2898,1,4,3,'2022-09-08 12:30:00','2022-09-08 13:18:00',2880,'in lab\r\nzabbix',36,NULL,45,1,'Europe/Rome',36,1,'work','2022-09-15 09:26:37','2022-09-08'),
(2899,1,1,3,'2022-09-08 13:35:00','2022-09-08 16:27:00',10320,'zabbix',129,NULL,45,1,'Europe/Rome',129,1,'work','2022-09-15 09:26:52','2022-09-08'),
(2900,1,1,3,'2022-09-09 06:44:00','2022-09-09 08:32:00',6480,'backup remoti libro e acier steel non funzionanti',81,NULL,45,1,'Europe/Rome',81,1,'work','2022-09-15 09:26:46','2022-09-09'),
(2901,1,1,103,'2022-09-09 08:48:00','2022-09-09 10:28:00',6000,'agg server',75,NULL,45,1,'Europe/Rome',75,1,'work','2022-12-08 12:04:14','2022-09-09'),
(2902,1,1,6,'2022-09-09 12:39:00','2022-09-09 13:26:00',2820,'agg nas',35.25,NULL,45,1,'Europe/Rome',35.25,1,'work','2022-09-21 09:32:26','2022-09-09'),
(2903,1,1,5,'2022-09-09 13:39:00','2022-09-09 14:31:00',3120,'agg nas',39,NULL,45,1,'Europe/Rome',39,1,'work','2022-10-05 08:58:50','2022-09-09'),
(2904,1,1,2,'2022-09-09 14:48:00','2022-09-09 16:27:00',5940,'agg nas',74.25,NULL,45,1,'Europe/Rome',74.25,1,'work','2022-09-21 15:46:37','2022-09-09'),
(2905,3,2,18,'2022-09-12 07:40:00','2022-09-12 08:20:00',2400,'Assistenza su PC client e stampante Brother',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-15 10:00:42','2022-09-12'),
(2906,1,1,3,'2022-09-12 09:08:00','2022-09-12 10:27:00',4740,'backup remoti',59.25,NULL,45,1,'Europe/Rome',59.25,1,'work','2022-09-15 09:26:54','2022-09-12'),
(2907,1,1,50,'2022-09-12 06:47:00','2022-09-12 08:46:00',7140,'tentativo di liberare spazio su sertver\r\nsistemazione share su vm lxc',89.25,NULL,45,1,'Europe/Rome',89.25,1,'work','2022-09-14 13:43:59','2022-09-12'),
(2908,1,1,2,'2022-09-12 12:50:00','2022-09-12 14:07:00',4620,'per proxy monitor su navigazione web',57.75,NULL,45,1,'Europe/Rome',57.75,1,'work','2022-09-21 15:46:36','2022-09-12'),
(2909,1,1,90,'2022-09-12 14:21:00','2022-09-12 15:27:00',3960,'problema licenze leica',49.5,NULL,45,1,'Europe/Rome',49.5,1,'work','2022-09-22 15:48:25','2022-09-12'),
(2910,3,2,50,'2022-09-12 12:55:00','2022-09-12 15:20:00',8700,'Assistenza su PC client Loretta per verifica spazio posta elettronica, assistenza su mac Gigio per problemi alla vpn. Spostata e ricablata postazione client Elisabetta. Montata e configurata nuova postazione client Stefano\r\nUtilizzato: 1 cavo rete 2mt, 1 cavo hdmi e 1 cavo alim. Ups',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-14 13:44:00','2022-09-12'),
(2911,3,1,75,'2022-09-12 06:55:00','2022-09-12 07:05:00',600,'Assistenza per problemi mancanza linea internet',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-21 14:06:54','2022-09-12'),
(2912,3,1,6,'2022-09-12 10:10:00','2022-09-12 10:30:00',1200,'Assistenza su portatile per problemi di lentezza',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-21 09:32:27','2022-09-12'),
(2913,1,1,90,'2022-09-13 06:49:00','2022-09-13 08:53:00',7440,'problema licenze cloudworks',93,NULL,45,1,'Europe/Rome',93,1,'work','2022-09-22 15:48:26','2022-09-13'),
(2914,1,1,50,'2022-09-13 09:01:00','2022-09-13 12:03:00',10920,'sistemazione gestionale apache e rallentamenti su vm windows',136.5,NULL,45,1,'Europe/Rome',136.5,1,'work','2022-09-14 13:44:03','2022-09-13'),
(2915,1,1,50,'2022-09-12 15:45:00','2022-09-12 16:25:00',2400,'problemi spazio',30,NULL,45,1,'Europe/Rome',30,1,'work','2022-09-14 13:44:02','2022-09-12'),
(2916,1,1,95,'2022-09-13 14:46:00','2022-09-13 15:24:44',2324,'problemi mail',29.05,NULL,45,1,'Europe/Rome',29.05,1,'work','2022-12-28 11:10:25','2022-09-13'),
(2917,3,1,79,'2022-09-13 06:45:00','2022-09-13 07:00:00',900,'Assistenza su pc client Silvia per problema mail spam',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-16 09:24:45','2022-09-13'),
(2918,3,1,18,'2022-09-13 07:05:00','2022-09-13 07:20:00',900,'Assistenza su pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-15 10:00:44','2022-09-13'),
(2919,3,1,84,'2022-09-13 08:45:00','2022-09-13 08:55:00',600,'Assistenza per problema accesso a Teams',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-06-22 08:18:18','2022-09-13'),
(2920,3,1,75,'2022-09-13 09:40:00','2022-09-13 09:55:00',900,'Assistenza su pc client Federico',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-21 14:06:51','2022-09-13'),
(2921,3,1,96,'2022-09-13 10:10:00','2022-09-13 10:20:00',600,'Assistenza su pc client Cristina per problemi ricezione posta',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-10-14 14:46:46','2022-09-13'),
(2922,3,1,96,'2022-09-13 14:00:00','2022-09-13 14:30:00',1800,'Modificata password account posta Anna Mochi, creato e configurato nuovo account posta Luca Gallotti',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-10-14 14:46:47','2022-09-13'),
(2923,1,1,50,'2022-09-13 12:47:00','2022-09-13 14:24:00',5820,'sistemazione gestionale apache e rallentamenti su vm windows',72.75,NULL,45,1,'Europe/Rome',72.75,1,'work','2022-09-14 13:44:05','2022-09-13'),
(2924,1,6,26,'2022-09-14 07:06:00','2022-09-14 07:16:00',600,'per wifi',7.5,NULL,45,1,'Europe/Rome',7.5,1,'work','2022-10-07 15:45:18','2022-09-14'),
(2925,1,3,112,'2022-09-14 06:30:00','2022-09-14 07:00:00',1800,NULL,22.5,NULL,45,1,'Europe/Rome',22.5,1,'work','2022-09-15 09:25:26','2022-09-14'),
(2926,1,1,2,'2022-09-13 15:46:00','2022-09-13 16:30:00',2640,'problema dipendente perde tempo su internet',33,NULL,45,1,'Europe/Rome',33,1,'work','2022-09-21 15:46:39','2022-09-13'),
(2927,1,1,2,'2022-09-14 07:23:00','2022-09-14 10:29:00',11160,'problema dipendente perde tempo su internet',139.5,NULL,45,1,'Europe/Rome',139.5,1,'work','2023-02-07 14:45:55','2022-09-14'),
(2928,1,1,3,'2022-09-14 14:00:00','2022-09-14 15:25:00',5100,'valutazione offerta explored con alex \r\nzabbix',63.75,NULL,45,1,'Europe/Rome',63.75,1,'work','2022-09-15 09:26:39','2022-09-14'),
(2929,1,1,50,'2022-09-14 15:28:00','2022-09-14 16:58:39',5439,'ripristino connessione esterna a vecchio gestionale',67.99,NULL,45,1,'Europe/Rome',67.99,1,'work','2022-09-15 09:24:23','2022-09-14'),
(2930,3,1,108,'2022-09-14 07:35:00','2022-09-14 07:45:00',600,'Assistenza su pc client Biglietteria',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-10-04 14:24:33','2022-09-14'),
(2931,3,1,24,'2022-09-14 07:50:00','2022-09-14 08:00:00',600,'Installata 1 licenza nod32 aggiornamento su 2 pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-21 14:41:27','2022-09-14'),
(2932,3,1,61,'2022-09-14 08:00:00','2022-09-14 08:10:00',600,'Installata 1 licenza nod32 aggiornamento su 1 pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-21 14:35:00','2022-09-14'),
(2933,3,1,51,'2022-09-14 08:15:00','2022-09-14 08:40:00',1500,'Installate 2 licenze nod32 aggiornamento su 4 pc client + assistenza su pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-16 16:42:58','2022-09-14'),
(2934,3,1,79,'2022-09-14 09:10:00','2022-09-14 09:25:00',900,'Installata 1 licenza nod32 aggiornamento su 2 pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-16 09:24:45','2022-09-14'),
(2935,3,1,50,'2022-09-14 09:40:00','2022-09-14 10:10:00',1800,'Installato Office 2021 su Mac Gigio',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-15 09:24:21','2022-09-14'),
(2936,3,1,45,'2022-09-14 12:45:00','2022-09-14 13:05:00',1200,'Installate 2 licenze nod32 aggiornamento su 4 pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-15 08:54:35','2022-09-14'),
(2937,3,1,24,'2022-09-14 14:50:00','2022-09-14 15:00:00',600,'Assistenza su pc client Monica',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-12-01 10:49:06','2022-09-14'),
(2938,3,1,18,'2022-09-14 15:00:00','2022-09-14 15:10:00',600,'Assistenza su pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-15 10:00:45','2022-09-14'),
(2939,1,1,96,'2022-09-15 07:25:00','2022-09-15 08:25:00',3600,'problemi posta',45,NULL,45,1,'Europe/Rome',45,1,'work','2022-10-14 14:46:48','2022-09-15'),
(2940,1,1,50,'2022-09-15 06:45:00','2022-09-15 07:12:00',1620,'ripristino connessione esterna a vecchio gestionale',20.25,NULL,45,1,'Europe/Rome',20.25,1,'work','2022-09-15 09:24:26','2022-09-15'),
(2941,1,1,50,'2022-09-14 19:30:00','2022-09-14 21:40:00',7800,'problema lentezza server',97.5,NULL,45,1,'Europe/Rome',97.5,1,'work','2022-09-15 09:24:25','2022-09-14'),
(2942,3,2,108,'2022-09-15 10:10:00','2022-09-15 10:40:00',1800,'Assistenza su PC client Biglietteria \r\nUtilizzato cavo usb 3mt',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-10-04 14:24:34','2022-09-15'),
(2943,1,1,50,'2022-09-15 08:37:00','2022-09-15 10:30:00',6780,'problema lentezza server',84.75,NULL,45,1,'Europe/Rome',84.75,1,'work','2022-09-16 08:21:36','2022-09-15'),
(2944,1,1,110,'2022-09-15 15:10:00','2022-09-15 16:05:00',3300,'per preventivo',41.25,NULL,45,1,'Europe/Rome',41.25,1,'work','2022-09-16 15:20:27','2022-09-15'),
(2945,1,1,3,'2022-09-15 12:45:00','2022-09-15 15:00:00',8100,'autoresponse postfixadmin',101.25,NULL,45,1,'Europe/Rome',101.25,1,'work','2022-09-16 08:20:13','2022-09-15'),
(2946,3,1,108,'2022-09-15 06:50:00','2022-09-15 07:05:00',900,'Assistenza su pc client Biglietteria',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-10-04 14:24:34','2022-09-15'),
(2947,3,1,96,'2022-09-15 09:10:00','2022-09-15 09:20:00',600,'Assistenza su pc client Cristina',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-10-14 14:46:49','2022-09-15'),
(2948,3,1,75,'2022-09-15 14:45:00','2022-09-15 14:55:00',600,'Assistenza su pc client Federico',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-21 14:06:49','2022-09-15'),
(2949,1,1,3,'2022-09-15 16:15:41','2022-09-15 17:01:06',2725,'autoresponse postfixadmin',34.06,NULL,45,1,'Europe/Rome',34.06,1,'work','2022-09-16 08:20:14','2022-09-15'),
(2950,1,1,3,'2022-09-15 20:08:00','2022-09-15 21:25:00',4620,'autoresponse postfixadmin',57.75,NULL,45,1,'Europe/Rome',57.75,1,'work','2022-09-16 08:20:16','2022-09-15'),
(2951,1,1,75,'2022-09-16 10:02:00','2022-09-16 10:50:00',2880,'problemi connettività',36,NULL,45,1,'Europe/Rome',36,1,'work','2022-09-21 14:06:50','2022-09-16'),
(2952,1,1,75,'2022-09-16 12:30:00','2022-09-16 14:59:00',8940,'problemi connettività, configurato server vpn wireguard su nas per oviare ai problemi di openvpn e permettere ai gestori del centralino di collegarsi',111.75,NULL,45,1,'Europe/Rome',111.75,1,'work','2022-09-21 14:06:49','2022-09-16'),
(2953,1,1,3,'2022-09-16 06:48:00','2022-09-16 09:45:00',10620,'autorespond su postfixadmin',132.75,NULL,45,1,'Europe/Rome',132.75,1,'work','2022-09-22 16:00:25','2022-09-16'),
(2954,1,1,3,'2022-09-16 15:17:00','2022-09-16 16:27:00',4200,'autorespond su postfixadmin',52.5,NULL,45,1,'Europe/Rome',52.5,1,'work','2022-09-22 16:00:24','2022-09-16'),
(2955,3,4,4,'2022-09-16 06:40:00','2022-09-16 07:40:00',3600,'Reinstallato e configurato pc client\r\nUtilizzato ssd 480gb s3 + 16 gb tam ddr4',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-23 15:57:39','2022-09-16'),
(2956,3,1,75,'2022-09-16 07:50:00','2022-09-16 08:00:00',600,'Assieme su PC client Erika per problemi con la stampante',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-21 14:06:55','2022-09-16'),
(2957,3,4,22,'2022-09-16 13:00:00','2022-09-16 14:00:00',3600,'Reinstallazione sistema operativo su portatile Stefano',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-10-04 16:13:20','2022-09-16'),
(2958,3,1,18,'2022-09-16 15:45:00','2022-09-16 16:00:00',900,'Assistenza su PC client',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-03 08:59:23','2022-09-16'),
(2959,3,2,91,'2022-09-19 08:50:00','2022-09-19 09:25:00',2100,'Assistenza su stampante Samsung Arnera, da dare preventivo per gruppo ottico, assistenza su PC client Segretaria',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-29 13:33:45','2022-09-19'),
(2960,1,1,110,'2022-09-19 13:36:00','2022-09-19 14:22:00',2760,'prep agg nextcloud',34.5,NULL,45,1,'Europe/Rome',34.5,1,'work','2023-02-03 09:05:12','2022-09-19'),
(2961,1,1,3,'2022-09-19 14:28:00','2022-09-19 15:45:00',4620,'smontata mia cpu e portata in lab per agg piastre nuove',57.75,NULL,45,1,'Europe/Rome',57.75,1,'work','2022-09-22 16:00:23','2022-09-19'),
(2962,1,1,110,'2022-09-19 16:00:00','2022-09-19 17:00:00',3600,'prep agg nextcloud',45,NULL,45,1,'Europe/Rome',45,1,'work','2023-02-03 09:05:24','2022-09-19'),
(2963,1,1,110,'2022-09-19 19:11:00','2022-09-19 20:56:00',6300,'prep agg nextcloud',78.75,NULL,45,1,'Europe/Rome',78.75,1,'work','2023-02-03 09:05:05','2022-09-19'),
(2964,1,1,108,'2022-09-19 06:47:00','2022-09-19 08:00:00',4380,'pulizia vm',54.75,NULL,45,1,'Europe/Rome',54.75,1,'work','2022-10-04 14:24:35','2022-09-19'),
(2965,1,1,79,'2022-09-19 08:15:00','2022-09-19 10:30:00',8100,'sistmazione proxmox',101.25,NULL,45,1,'Europe/Rome',101.25,1,'work','2023-02-03 10:56:23','2022-09-19'),
(2966,1,1,2,'2022-09-19 12:39:00','2022-09-19 13:27:00',2880,'agg nas e telecamere',36,NULL,45,1,'Europe/Rome',36,1,'work','2023-02-07 14:45:42','2022-09-19'),
(2967,1,1,110,'2022-09-20 06:54:00','2022-09-20 10:30:00',12960,'ultimo avanzamento di versione\r\nattivazione logging per problemi mysql',162,NULL,45,1,'Europe/Rome',162,1,'work','2023-02-03 09:05:01','2022-09-20'),
(2968,1,1,110,'2022-09-20 12:50:00','2022-09-20 15:23:00',9180,'risoluzioni problemi post aggiornamento',114.75,NULL,45,1,'Europe/Rome',114.75,1,'work','2023-02-03 09:05:05','2022-09-20'),
(2969,1,1,24,'2022-09-21 07:17:00','2022-09-21 07:46:13',1753,'problemi centralino dopo salto di corrente',21.91,NULL,45,1,'Europe/Rome',21.91,1,'work','2022-12-01 09:17:59','2022-09-21'),
(2970,3,2,4,'2022-09-21 07:30:00','2022-09-21 09:30:00',7200,'Consegna e configurazione nuovo PC client Alessandra, consegna e configurazione nel magazzino del PC client reinstallato (da ultimare in un secondo momento), assistenza su PC client Segretaria\r\nUtilizzato: 2 cavi LAN da 3 mt, 2 cavi alim.',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-10-07 16:44:41','2022-09-21'),
(2971,1,1,87,'2022-09-21 08:05:00','2022-09-21 10:21:00',8160,'ancora problemi invio mail',102,NULL,45,1,'Europe/Rome',102,1,'work','2022-09-29 15:51:51','2022-09-21'),
(2972,1,6,9,'2022-09-21 06:48:00','2022-09-21 07:00:00',720,'segnalati problemi adsl',9,NULL,45,1,'Europe/Rome',9,1,'work','2023-02-03 08:41:33','2022-09-21'),
(2973,3,2,26,'2022-09-21 09:45:00','2022-09-21 09:55:00',600,'Consegna 4 toner compatibili per stampante Brother',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-26 14:35:59','2022-09-21'),
(2974,1,1,75,'2022-09-21 14:28:00','2022-09-21 15:13:45',2745,'configurazione wireguard pc erika casa\r\naggiornamento pc erika necessario ferma a windows 10 1803',34.31,NULL,45,1,'Europe/Rome',34.31,1,'work','2022-10-04 14:39:50','2022-09-21'),
(2975,1,1,50,'2022-09-21 12:45:00','2022-09-21 14:16:00',5460,'verifica velocità dopo lavori',68.25,NULL,45,1,'Europe/Rome',68.25,1,'work','2023-02-03 09:17:42','2022-09-21'),
(2976,1,1,55,'2022-09-21 15:14:00','2022-09-21 16:36:31',4951,'verifica per rallentamenti segnalati',61.89,NULL,45,1,'Europe/Rome',61.89,1,'work','2023-02-03 08:31:21','2022-09-21'),
(2977,1,1,1,'2022-09-20 15:34:00','2022-09-20 16:28:00',3240,'agg antispam e mail',40.5,NULL,45,1,'Europe/Rome',40.5,1,'work','2023-01-27 12:57:46','2022-09-20'),
(2978,1,1,22,'2022-09-22 07:45:00','2022-09-22 08:13:00',1680,'config wifi su router zyxel',21,NULL,45,1,'Europe/Rome',21,1,'work','2022-10-04 16:13:21','2022-09-22'),
(2979,1,1,75,'2022-09-22 08:21:00','2022-09-22 08:53:00',1920,'configurazione wireguard pcmarisa',24,NULL,45,1,'Europe/Rome',24,1,'work','2022-10-04 14:39:52','2022-09-22'),
(2980,1,1,75,'2022-09-22 09:10:00','2022-09-22 09:37:00',1620,'configurazione wireguard pcmarisa di casa',20.25,NULL,45,1,'Europe/Rome',20.25,1,'work','2022-10-04 14:39:53','2022-09-22'),
(2981,1,1,75,'2022-09-22 12:52:00','2022-09-22 14:07:41',4541,'configurazione wireguard pc federico figari di casa',56.76,NULL,45,1,'Europe/Rome',56.76,1,'work','2022-10-04 14:39:54','2022-09-22'),
(2982,3,2,87,'2022-09-22 09:25:00','2022-09-22 13:00:00',12900,'Consegnato e configurato nuovo PC client Danila',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-29 15:54:47','2022-09-22'),
(2983,3,2,91,'2022-09-22 13:40:00','2022-09-22 13:55:00',900,'Verificato e ritirato pc client arnera per problemi audio',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-29 13:33:47','2022-09-22'),
(2984,3,4,75,'2022-09-22 06:50:00','2022-09-22 07:50:00',3600,'Recupero dati vecchio pc client Bagnasco + configurazione nuovo pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-10-04 14:39:51','2022-09-22'),
(2985,1,1,2,'2022-09-22 14:21:00','2022-09-22 16:45:00',8640,'laura pc con virus\r\n1 Aggiornamento nod32 antivirus',108,NULL,45,1,'Europe/Rome',108,1,'work','2023-02-07 14:45:30','2022-09-22'),
(2986,3,1,108,'2022-09-20 08:05:00','2022-09-20 08:20:00',900,'Assistenza su pc client Biglietteria per problemi stampa etichette',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-10-04 14:24:36','2022-09-20'),
(2987,3,1,96,'2022-09-20 09:00:00','2022-09-20 09:15:00',900,'Assistenza su pc client Maria per problemi posta',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-10-14 14:46:50','2022-09-20'),
(2988,3,1,26,'2022-09-20 14:00:00','2022-09-20 14:10:00',600,'Assistenza su pc client Simona',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-10-07 15:45:18','2022-09-20'),
(2989,3,2,75,'2022-09-21 13:10:00','2022-09-21 14:50:00',6000,'Consegna e configurazione nuovo pc client, riportato in ufficio per lentezza nella copia dati',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-10-04 14:39:49','2022-09-21'),
(2990,3,2,62,'2022-09-22 15:00:00','2022-09-22 15:10:00',600,'Ritirato pc client per assistenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-10-04 14:59:10','2022-09-22'),
(2991,1,1,55,'2022-09-22 06:45:00','2022-09-22 07:37:00',3120,'verifica per rallentamenti segnalati',39,NULL,45,1,'Europe/Rome',39,1,'work','2023-02-03 08:31:22','2022-09-22'),
(2992,3,2,75,'2022-09-23 07:40:00','2022-09-23 09:30:00',6600,'Consegna e configurazione nuovo PC client Bagnasco \r\nAssistenza su PC client Federico \r\nContattato Fastweb per problemi sul router',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-10-04 14:39:55','2022-09-23'),
(2993,3,2,9,'2022-09-23 10:15:00','2022-09-23 11:15:00',3600,'Consegna e configurazione nuovo router tplink \r\nAssistenza su PC client per problemi scansione di rete',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-03 08:49:38','2022-09-23'),
(2994,1,1,119,'2022-09-23 12:41:00','2022-09-23 13:23:53',2573,'problemi spazio disco su portatile',32.16,NULL,45,1,'Europe/Rome',32.16,1,'work','2023-03-10 16:01:06','2022-09-23'),
(2995,1,1,62,'2022-09-23 07:09:00','2022-09-23 10:26:00',11820,'suo pc con hdd rotto',147.75,NULL,45,1,'Europe/Rome',147.75,1,'work','2022-10-04 14:59:11','2022-09-23'),
(2996,1,1,3,'2022-09-23 06:30:00','2022-09-23 07:05:00',2100,'con fede in lab spiegato interventi',26.25,NULL,45,1,'Europe/Rome',26.25,1,'work','2022-10-04 14:59:37','2022-09-23'),
(2997,3,1,22,'2022-09-23 13:00:00','2022-09-23 13:10:00',600,'Assistenza su pc client padre',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-10-04 16:13:22','2022-09-23'),
(2998,1,1,75,'2022-09-23 15:52:00','2022-09-23 16:23:00',1860,'problemi posta su pc nuovo',23.25,NULL,45,1,'Europe/Rome',23.25,1,'work','2022-10-04 14:39:56','2022-09-23'),
(2999,3,2,91,'2022-09-26 08:15:00','2022-09-26 08:40:00',1500,'Riconsegna pc client arnera dopo risoluzione problema audio, consegna e installazione gruppo ottico samsung\r\nUtilizzato adattatore jack usb',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-09-29 13:33:46','2022-09-26'),
(3000,1,1,90,'2022-09-26 13:05:00','2022-09-26 14:48:00',6180,'problema certificati ssl da concludere e cambiare config',77.25,NULL,45,1,'Europe/Rome',77.25,1,'work','2023-01-23 10:14:52','2022-09-26'),
(3001,1,1,103,'2022-09-23 13:42:00','2022-09-23 15:38:00',6960,'agg server e test su telefono',87,NULL,45,1,'Europe/Rome',87,1,'work','2022-12-15 10:24:03','2022-09-23'),
(3002,1,1,62,'2022-09-26 06:48:00','2022-09-26 10:28:00',13200,'pc molto vecchio problema disco',165,NULL,45,1,'Europe/Rome',165,1,'work','2022-10-04 14:59:12','2022-09-26'),
(3003,1,1,62,'2022-09-26 12:38:00','2022-09-26 13:00:00',1320,'pc molto vecchio problema disco',16.5,NULL,45,1,'Europe/Rome',16.5,1,'work','2022-10-04 14:59:13','2022-09-26'),
(3004,1,1,62,'2022-09-26 14:56:00','2022-09-26 15:23:00',1620,'pc molto vecchio problema disco',20.25,NULL,45,1,'Europe/Rome',20.25,1,'work','2022-10-04 14:59:14','2022-09-26'),
(3005,3,2,41,'2022-09-26 14:55:00','2022-09-26 15:15:00',1200,'Riconsegna e installazione ups dopo sostituzione batteria, consegna e installazione nuovo ups apc 500',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-10-04 15:57:58','2022-09-26'),
(3006,1,1,3,'2022-09-26 15:39:00','2022-09-26 16:28:00',2940,'per backup server proxmox',36.75,NULL,45,1,'Europe/Rome',36.75,1,'work','2022-10-04 14:59:37','2022-09-26'),
(3007,1,1,96,'2022-09-27 07:24:00','2022-09-27 07:27:00',180,'Pc marilena non scarica posta',2.25,NULL,45,1,'Europe/Rome',2.25,1,'work','2022-10-14 14:46:50','2022-09-27'),
(3008,3,1,100,'2022-09-26 07:00:00','2022-09-26 07:10:00',600,'Riavviati servizi di posta per problemi su certificato',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-11-21 09:35:46','2022-09-26'),
(3009,3,1,59,'2022-09-26 09:20:00','2022-09-26 09:30:00',600,'Verificata configurazione hw per upgrade',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-10-07 16:13:35','2022-09-26'),
(3010,3,1,90,'2022-09-26 13:05:00','2022-09-26 13:45:00',2400,'Assistenza su pc client Campodoni per problemi sulla posta',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-01-23 10:14:53','2022-09-26'),
(3011,3,2,83,'2022-09-27 09:20:00','2022-09-27 10:00:00',2400,'Verificato e ritirato pc client Luigi che non avvia s.o \r\nConfigurato pc client provvisorio nella postazione di Luigi',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-10-04 15:46:08','2022-09-27'),
(3012,1,6,79,'2022-09-27 12:50:00','2022-09-27 12:55:43',343,'problema chiavetta certificati',4.29,NULL,45,1,'Europe/Rome',4.29,1,'work','2023-02-03 10:19:31','2022-09-27'),
(3013,1,3,112,'2022-09-27 14:40:00','2022-09-27 15:53:00',4380,NULL,54.75,NULL,45,1,'Europe/Rome',54.75,1,'work','2022-12-20 16:13:16','2022-09-27'),
(3014,1,1,110,'2022-09-27 06:43:00','2022-09-27 07:15:00',1920,'postfixadmin',24,NULL,45,1,'Europe/Rome',24,1,'work','2023-02-03 09:05:18','2022-09-27'),
(3015,1,1,110,'2022-09-27 07:46:00','2022-09-27 10:30:00',9840,'postfixadmin',123,NULL,45,1,'Europe/Rome',123,1,'work','2023-02-03 09:05:12','2022-09-27'),
(3016,1,1,90,'2022-09-27 13:00:00','2022-09-27 14:07:00',4020,'sistemazione certificati ssl (noh riuscito) temp su mio pc',50.25,NULL,45,1,'Europe/Rome',50.25,1,'work','2023-01-23 10:15:02','2022-09-27'),
(3017,1,1,110,'2022-09-27 14:19:00','2022-09-27 14:39:00',1200,'postfixadmin',15,NULL,45,1,'Europe/Rome',15,1,'work','2023-02-03 09:05:12','2022-09-27'),
(3018,1,1,110,'2022-09-27 15:56:00','2022-09-27 17:01:21',3921,'postfixadmin',49.01,NULL,45,1,'Europe/Rome',49.01,1,'work','2023-02-03 09:05:18','2022-09-27'),
(3019,1,1,59,'2022-09-27 19:22:00','2022-09-27 21:42:00',8400,'problema ripristino pc dopo sostituzione disco fatta da fede su ssd',105,NULL,45,1,'Europe/Rome',105,1,'work','2022-10-07 16:13:28','2022-09-27'),
(3020,3,1,51,'2022-09-27 08:00:00','2022-09-27 08:40:00',2400,'Assistenza su pc client Massimo per problemi avvio Thunderbird',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-07 10:33:27','2022-09-27'),
(3021,3,1,59,'2022-09-27 12:35:00','2022-09-27 13:10:00',2100,'Assistenza su pc client Grafica per problemi spazio disco',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-10-07 16:13:33','2022-09-27'),
(3022,3,1,18,'2022-09-27 13:20:00','2022-09-27 13:30:00',600,'Assistenza su pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-03 08:59:24','2022-09-27'),
(3023,3,1,90,'2022-09-27 14:05:00','2022-09-27 14:25:00',1200,'Assistenza su server Windows per problemi su Ufficius',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-01-23 10:15:09','2022-09-27'),
(3024,3,4,83,'2022-09-27 14:30:00','2022-09-27 15:30:00',3600,'Assistenza su pc client Luigi, clonato sistema operativo\r\nUtilizzato: ssd 480gb S3+ + 4 gb ram ddr3L sodim',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-10-04 15:46:09','2022-09-27'),
(3025,3,4,59,'2022-09-27 15:30:00','2022-09-27 18:00:00',9000,'Clonato sistema pc client Andrea, lavorato per sistemare avvio s.o dopo clonazione.\r\nUtilizzato: ssd 480gb s3+ + 8 gb ddr3 ram',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-10-07 16:11:13','2022-09-27'),
(3026,1,3,112,'2022-09-28 06:30:00','2022-09-28 08:40:00',7800,NULL,97.5,NULL,45,1,'Europe/Rome',97.5,1,'work','2022-12-20 16:13:16','2022-09-28'),
(3027,1,1,110,'2022-09-28 08:50:00','2022-09-28 09:38:00',2880,'problemi su interno 119 3cx',36,NULL,45,1,'Europe/Rome',36,1,'work','2023-02-03 09:05:07','2022-09-28'),
(3028,3,2,83,'2022-09-28 09:40:00','2022-09-28 10:40:00',3600,'Riconsegna pc client luigi dopo assistenza \r\nAssistenza per problemi su wifi irideos',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-10-04 15:46:09','2022-09-28'),
(3029,1,1,83,'2022-09-28 12:48:00','2022-09-28 14:55:06',7626,'problemi navigazione',95.33,NULL,45,1,'Europe/Rome',95.33,1,'work','2022-10-04 15:46:11','2022-09-28'),
(3030,3,1,59,'2022-09-28 08:10:00','2022-09-28 08:30:00',1200,'Assistenza su pc client Andrea dopo upgrade hardware',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-03 08:37:31','2022-09-28'),
(3031,3,1,104,'2022-09-28 08:35:00','2022-09-28 08:45:00',600,'Assistenza su pc client Daniele',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-10-27 13:31:03','2022-09-28'),
(3032,3,1,75,'2022-09-28 09:00:00','2022-09-28 09:20:00',1200,'Assistenza su pc client Luca Bagnasco',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-10-04 14:39:57','2022-09-28'),
(3033,3,1,83,'2022-09-28 12:35:00','2022-09-28 13:05:00',1800,'Assistenza per problema rete a singhiozzo + agg NAS',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-10-04 15:46:10','2022-09-28'),
(3034,3,1,4,'2022-09-28 14:10:00','2022-09-28 14:25:00',900,'Assistenza su pc client Magazzino per collegamento in vpn',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-10-07 16:44:43','2022-09-28'),
(3035,3,1,75,'2022-09-28 15:00:00','2022-09-28 15:10:00',600,'Installato Norton Antivirus su pc client Luca Bagnasco',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-10-04 14:39:57','2022-09-28'),
(3036,1,1,110,'2022-09-28 15:08:00','2022-09-28 16:30:00',4920,'server mail nuovo',61.5,NULL,45,1,'Europe/Rome',61.5,1,'work','2023-02-03 09:05:15','2022-09-28'),
(3037,1,1,110,'2022-09-28 09:48:00','2022-09-28 10:29:00',2460,'server mail nuovo',30.75,NULL,45,1,'Europe/Rome',30.75,1,'work','2023-02-03 09:05:02','2022-09-28'),
(3038,1,1,110,'2022-09-28 20:25:00','2022-09-28 21:50:00',5100,'server mail nuovo',63.75,NULL,45,1,'Europe/Rome',63.75,1,'work','2023-02-03 09:05:04','2022-09-28'),
(3039,1,1,1,'2022-09-29 08:10:00','2022-09-29 09:00:00',3000,'problemi 3cx chiamate esterne\r\naggiornato 3cx e fatte verifiche firmware patton',37.5,NULL,45,1,'Europe/Rome',37.5,1,'work','2023-01-27 07:59:24','2022-09-29'),
(3040,3,2,9,'2022-09-29 09:55:00','2022-09-29 10:20:00',1500,'Ritiro router provvisorio + ripristino vecchio router\r\nAssistenza su PC client per problemi stampa plotter',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-03 08:49:39','2022-09-29'),
(3041,3,1,1,'2022-09-29 07:35:00','2022-09-29 08:15:00',2400,'Assistenza per problemi sulla linea telefonica',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-01-27 12:58:05','2022-09-29'),
(3042,3,1,108,'2022-09-29 08:15:00','2022-09-29 08:25:00',600,'Assistenza per problemi navigazione',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-10-04 14:24:37','2022-09-29'),
(3043,3,2,24,'2022-09-29 12:30:00','2022-09-29 12:40:00',600,'Consegna cartuccia nera originale per Epson WF3820',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-10-04 13:53:29','2022-09-29'),
(3044,1,1,110,'2022-09-29 13:45:00','2022-09-29 17:00:00',11700,'fine server posta\r\nproblemi clamav\r\ntest rspamd\r\ntest config client\r\ntest invio virus',146.25,NULL,45,1,'Europe/Rome',146.25,1,'work','2023-02-03 09:05:15','2022-09-29'),
(3045,1,1,110,'2022-09-29 06:47:00','2022-09-29 08:02:00',4500,'fine server posta',56.25,NULL,45,1,'Europe/Rome',56.25,1,'work','2023-02-03 09:05:03','2022-09-29'),
(3046,1,1,3,'2022-09-29 09:10:00','2022-09-29 10:28:00',4680,'per backup proxmox',58.5,NULL,45,1,'Europe/Rome',58.5,1,'work','2022-10-04 14:59:36','2022-09-29'),
(3047,1,1,3,'2022-09-29 12:37:00','2022-09-29 13:40:00',3780,'per backup proxmox',47.25,NULL,45,1,'Europe/Rome',47.25,1,'work','2022-10-04 14:59:36','2022-09-29'),
(3048,1,3,112,'2022-09-30 15:00:00','2022-09-30 15:15:00',900,NULL,11.25,NULL,45,1,'Europe/Rome',11.25,1,'work','2022-12-20 16:13:23','2022-09-30'),
(3049,3,1,79,'2022-09-30 06:30:00','2022-09-30 06:50:00',1200,'Assistenza per avvio server dopo che è mancata la corrente',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-03 10:56:32','2022-09-30'),
(3050,3,1,4,'2022-09-30 09:40:00','2022-09-30 10:00:00',1200,'Finito lavoro vpn su pc client Magazzino',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-10-07 16:44:44','2022-09-30'),
(3051,1,1,3,'2022-09-30 06:47:00','2022-09-30 09:00:00',7980,'proxmox backup host',99.75,NULL,45,1,'Europe/Rome',99.75,1,'work','2022-10-04 14:59:35','2022-09-30'),
(3052,1,1,110,'2022-09-30 09:14:00','2022-09-30 10:50:00',5760,'lavori sui server \r\npiù sentito dario per le varie pass e configurazioni',72,NULL,45,1,'Europe/Rome',72,1,'work','2023-02-03 09:05:25','2022-09-30'),
(3053,1,1,110,'2022-09-30 12:44:00','2022-09-30 14:53:00',7740,'lavori sui server \r\npiù sentito dario per le varie pass e configurazioni',96.75,NULL,45,1,'Europe/Rome',96.75,1,'work','2023-02-03 09:05:11','2022-09-30'),
(3054,1,1,110,'2022-09-30 15:20:00','2022-09-30 16:52:45',5565,'lavori sui server \r\npiù sentito dario per le varie pass e configurazioni',69.56,NULL,45,1,'Europe/Rome',69.56,1,'work','2023-02-03 09:05:06','2022-09-30'),
(3055,1,2,113,'2022-10-03 06:10:00','2022-10-03 09:10:00',10800,'Per preventivi server',135,NULL,45,1,'Europe/Rome',135,1,'work','2023-01-27 13:08:31','2022-10-03'),
(3056,3,1,43,'2022-10-03 08:10:00','2022-10-03 08:20:00',600,'Installata 1 licenza aggiornamento nod32 su 2 pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-03 08:33:12','2022-10-03'),
(3057,3,1,2,'2022-10-03 08:20:00','2022-10-03 08:30:00',600,'Installata 1 licenza aggiornamento nod32 su 2 pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-10-04 13:43:51','2022-10-03'),
(3058,3,1,41,'2022-10-03 08:30:00','2022-10-03 08:45:00',900,'Assistenza per probabile virus su pc client Paola',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-11-08 20:51:28','2022-10-03'),
(3059,3,1,96,'2022-10-03 09:40:00','2022-10-03 09:50:00',600,'Assistenza per problema microfono su pc VideoConferenze',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-10-14 14:46:51','2022-10-03'),
(3060,1,1,110,'2022-10-03 19:30:00','2022-10-03 22:20:00',10200,'migrazione posta\r\nconfigurazione vacation',127.5,NULL,45,1,'Europe/Rome',127.5,1,'work','2023-02-03 09:05:06','2022-10-03'),
(3061,1,1,110,'2022-10-03 14:38:00','2022-10-03 16:30:00',6720,'preparazione switch server di posta 1H 20 min\r\nmodifiche su centralino 32 min',84,NULL,45,1,'Europe/Rome',84,1,'work','2023-02-03 09:05:15','2022-10-03'),
(3062,1,1,113,'2022-10-03 09:14:00','2022-10-03 10:23:00',4140,'studio stato attuale',51.75,NULL,45,1,'Europe/Rome',51.75,1,'work','2023-01-27 13:08:32','2022-10-03'),
(3063,1,1,2,'2022-10-03 12:46:00','2022-10-03 14:29:00',6180,'risoluzione problemi nas per backup server',77.25,NULL,45,1,'Europe/Rome',77.25,1,'work','2023-02-07 14:45:46','2022-10-03'),
(3064,1,1,3,'2022-10-04 06:34:00','2022-10-04 07:03:00',1740,'relazione installlazione vacation alex',21.75,NULL,45,1,'Europe/Rome',21.75,1,'work','2022-10-04 14:59:35','2022-10-04'),
(3065,3,2,108,'2022-10-04 07:20:00','2022-10-04 07:50:00',1800,'Consegna e installazione nuovo monitor',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-10-04 14:24:38','2022-10-04'),
(3066,1,3,112,'2022-10-04 09:12:00','2022-10-04 10:30:00',4680,NULL,58.5,NULL,45,1,'Europe/Rome',58.5,1,'work','2022-12-22 15:13:19','2022-10-04'),
(3067,1,3,112,'2022-10-04 12:30:00','2022-10-04 13:20:00',3000,NULL,37.5,NULL,45,1,'Europe/Rome',37.5,1,'work','2022-12-20 16:13:17','2022-10-04'),
(3068,1,1,110,'2022-10-04 07:10:00','2022-10-04 09:10:00',7200,'problemi dopo migrazione posta',90,NULL,45,1,'Europe/Rome',90,1,'work','2023-02-03 09:05:07','2022-10-04'),
(3069,3,1,50,'2022-10-04 08:20:00','2022-10-04 08:35:00',900,'Assistenza su pc client Filippo per problemi con Thunderbird',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-03 09:17:44','2022-10-04'),
(3070,3,1,110,'2022-10-04 09:00:00','2022-10-04 09:20:00',1200,'Contattato Tim per modifiche su reverse DNS',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-03 09:05:15','2022-10-04'),
(3071,3,1,10,'2022-10-04 13:05:00','2022-10-04 13:25:00',1200,'Assistenza su pc client Francesca per tagliare video',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-24 17:01:38','2022-10-04'),
(3072,3,2,104,'2022-10-04 13:55:00','2022-10-04 14:10:00',900,'Consegnato e installato tamburo su stampante Brother',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-10-14 14:49:02','2022-10-04'),
(3073,1,3,112,'2022-10-04 15:20:00','2022-10-04 16:30:00',4200,NULL,52.5,NULL,45,1,'Europe/Rome',52.5,1,'work','2022-12-20 16:13:18','2022-10-04'),
(3074,1,1,110,'2022-10-04 19:45:00','2022-10-04 22:10:00',8700,'analisi nextcloud e fine setup posta',108.75,NULL,45,1,'Europe/Rome',108.75,1,'work','2023-02-03 09:05:16','2022-10-04'),
(3075,1,1,90,'2022-10-04 14:30:00','2022-10-04 15:15:00',2700,'prove di sistemazione ssl',33.75,NULL,45,1,'Europe/Rome',33.75,1,'work','2023-01-23 10:15:10','2022-10-04'),
(3076,1,1,110,'2022-10-04 13:20:00','2022-10-04 14:27:00',4020,'problemi dopo migrazione posta',50.25,NULL,45,1,'Europe/Rome',50.25,1,'work','2023-02-03 09:05:13','2022-10-04'),
(3077,3,2,10,'2022-10-05 08:00:00','2022-10-05 09:00:00',3600,'Verificato e ritirato pc client Carmen per problemi avvio sistema operativo, configurato portatile per far lavorare Carmen provvisoriamente',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-24 17:01:57','2022-10-05'),
(3078,1,6,108,'2022-10-05 08:36:00','2022-10-05 08:46:00',600,'server inchiodato, provato a far eseguire operazioni per il riavvio senza risultato\r\nups con batterie andate.',7.5,NULL,45,1,'Europe/Rome',7.5,1,'work','2023-03-17 09:27:50','2022-10-05'),
(3079,1,2,108,'2022-10-05 08:57:00','2022-10-05 09:42:00',2700,'ripristino boot del server, ups ok',33.75,NULL,45,1,'Europe/Rome',33.75,1,'work','2023-03-17 09:52:03','2022-10-05'),
(3080,3,2,18,'2022-10-05 09:25:00','2022-10-05 09:50:00',1500,'Assistenza su PC client per problemi stampa da Thunderbird',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-03 08:59:25','2022-10-05'),
(3081,1,1,110,'2022-10-05 06:53:00','2022-10-05 08:30:00',5820,'verifiche dopo sistemazione e cambi config posta',72.75,NULL,45,1,'Europe/Rome',72.75,1,'work','2023-02-03 09:05:09','2022-10-05'),
(3082,1,2,3,'2022-10-05 12:30:00','2022-10-05 15:00:00',9000,'da cliente nuovoo con te',112.5,NULL,45,1,'Europe/Rome',112.5,1,'work','2023-01-27 13:04:26','2022-10-05'),
(3083,1,1,110,'2022-10-05 09:55:00','2022-10-05 10:30:00',2100,'verifiche dopo sistemazione e cambi config posta',26.25,NULL,45,1,'Europe/Rome',26.25,1,'work','2023-02-03 09:05:14','2022-10-05'),
(3084,3,1,88,'2022-10-05 12:30:00','2022-10-05 12:40:00',600,'Recupero file sovrascritto su server',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-11-10 16:37:36','2022-10-05'),
(3085,1,1,10,'2022-10-05 15:08:00','2022-10-05 16:29:00',4860,'ransomware su pc carmen analisi virus',60.75,NULL,45,1,'Europe/Rome',60.75,1,'work','2023-02-24 17:01:51','2022-10-05'),
(3086,1,3,112,'2022-09-14 12:30:00','2022-09-14 13:50:00',4800,NULL,60,NULL,45,1,'Europe/Rome',60,1,'work','2022-12-20 16:13:14','2022-09-14'),
(3087,1,1,55,'2022-09-22 09:49:00','2022-09-22 10:30:00',2460,'verifica per rallentamenti segnalati',30.75,NULL,45,1,'Europe/Rome',30.75,1,'work','2023-02-03 08:31:23','2022-09-22'),
(3088,1,1,10,'2022-10-06 06:30:00','2022-10-06 07:00:00',1800,'pc carmen ransomware',22.5,NULL,45,1,'Europe/Rome',22.5,1,'work','2023-02-24 17:01:46','2022-10-06'),
(3089,1,2,108,'2022-10-06 07:00:00','2022-10-06 08:00:00',3600,'con te per presentare nuovo preventivo',45,NULL,45,1,'Europe/Rome',45,1,'work','2023-03-09 16:51:03','2022-10-06'),
(3090,1,1,110,'2022-10-06 08:28:00','2022-10-06 10:30:00',7320,'cercato di sistemare vacation',91.5,NULL,45,1,'Europe/Rome',91.5,1,'work','2023-02-03 09:05:10','2022-10-06'),
(3091,1,1,3,'2022-10-06 14:39:00','2022-10-06 15:04:00',1500,'fogli',18.75,NULL,45,1,'Europe/Rome',18.75,1,'work','2023-01-27 13:04:16','2022-10-06'),
(3092,3,1,51,'2022-10-06 13:55:00','2022-10-06 14:30:00',2100,'Assistenza su pc Andrea Zamparo per riconfigurazione posta su Outlook',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-07 10:33:27','2022-10-06'),
(3093,3,4,10,'2022-10-06 14:30:00','2022-10-06 16:30:00',7200,'Assistenza su pc client Carmen infetto da virus Venus, reinstallato sistema operativo.\r\nUtilizzato ssd 1tb',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-24 17:01:48','2022-10-06'),
(3094,1,1,10,'2022-10-06 15:10:00','2022-10-06 16:30:00',4800,'fede problemi a riconfigurare posta verifiche\r\ntentativo recpero ransowmare',60,NULL,45,1,'Europe/Rome',60,1,'work','2023-02-24 17:01:40','2022-10-06'),
(3095,1,1,110,'2022-10-06 12:46:00','2022-10-06 14:00:00',4440,'problemi vacation',55.5,NULL,45,1,'Europe/Rome',55.5,1,'work','2023-02-03 09:05:20','2022-10-06'),
(3096,1,6,108,'2022-10-06 14:10:00','2022-10-06 14:22:00',720,'provato contatto hjalley per vm',9,NULL,45,1,'Europe/Rome',9,1,'work','2023-03-17 09:51:54','2022-10-06'),
(3097,1,1,90,'2022-10-07 06:33:00','2022-10-07 08:45:00',7920,'assemblaggio e prima installazione nuovo server',99,NULL,45,1,'Europe/Rome',99,1,'work','2023-01-20 16:17:37','2022-10-07'),
(3098,1,1,10,'2022-10-07 08:50:00','2022-10-07 10:46:03',6963,'tentativo di recupero dati ransomware',87.04,NULL,45,1,'Europe/Rome',87.04,1,'work','2023-02-24 17:01:45','2022-10-07'),
(3099,3,2,10,'2022-10-07 07:15:00','2022-10-07 11:00:00',13500,'Riconsegna e configurazione PC client  Carmen dopo reinstallazione sistema operativo, impossibile recuperare dati software contabilità Arca',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-24 17:01:48','2022-10-07'),
(3100,3,1,10,'2022-10-07 12:40:00','2022-10-07 14:00:00',4800,'Assistenza su pc client Carmen per recupero funzionalità Outlook',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-24 17:01:45','2022-10-07'),
(3101,3,1,75,'2022-10-07 15:15:00','2022-10-07 15:25:00',600,'Assistenza su pc client Federico',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-08 10:42:16','2022-10-07'),
(3102,1,1,10,'2022-10-07 12:47:00','2022-10-07 15:00:00',7980,'tentativo di recupero dati ransomware',99.75,NULL,45,1,'Europe/Rome',99.75,1,'work','2023-02-24 17:01:45','2022-10-07'),
(3103,1,1,3,'2022-10-07 15:05:00','2022-10-07 16:50:00',6300,'verifica software dpm per backup hyperv',78.75,NULL,45,1,'Europe/Rome',78.75,1,'work','2023-01-27 13:03:54','2022-10-07'),
(3104,1,1,110,'2022-10-10 08:16:00','2022-10-10 09:28:00',4320,'configurazione e test rete ospiti wifi\r\nAttività esterna agli accordi presi da fatturare',54,NULL,45,1,'Europe/Rome',54,1,'work','2023-02-03 09:05:14','2022-10-10'),
(3105,1,4,3,'2022-10-10 06:30:00','2022-10-10 07:30:00',3600,'aggiornamento bios piastre incompatibili con cpu ryzen',45,NULL,45,1,'Europe/Rome',45,1,'work','2023-01-27 13:04:04','2022-10-10'),
(3106,1,1,10,'2022-10-10 13:24:00','2022-10-10 13:59:18',2118,'sistemazione posta pc carmen',26.48,NULL,45,1,'Europe/Rome',26.48,1,'work','2023-02-24 17:01:44','2022-10-10'),
(3107,1,1,10,'2022-10-10 14:48:53','2022-10-10 15:00:42',709,'sistemazione posta pc carmen',8.86,NULL,45,1,'Europe/Rome',8.86,1,'work','2023-02-24 17:01:49','2022-10-10'),
(3108,3,1,100,'2022-10-10 07:35:00','2022-10-10 07:55:00',1200,'Assistenza su pc client per creazione e collegamento nuovo utente Server',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-11-21 14:18:43','2022-10-10'),
(3109,3,1,10,'2022-10-10 09:35:00','2022-10-10 09:45:00',600,'Assistenza su pc client Carmen',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-24 17:01:52','2022-10-10'),
(3110,3,1,10,'2022-10-10 12:45:00','2022-10-10 13:45:00',3600,'Assistenza su pc client Carmen per problema rubrica Outlook',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-24 17:01:44','2022-10-10'),
(3111,3,1,10,'2022-10-10 14:25:00','2022-10-10 14:55:00',1800,'Assistenza su pc client Carmen per problema su Outlook',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-24 17:01:43','2022-10-10'),
(3112,3,1,50,'2022-10-10 14:00:00','2022-10-10 14:15:00',900,'Assistenza su pc client Filippo per problemi su Thunderbird',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-03 09:17:45','2022-10-10'),
(3113,3,1,24,'2022-10-10 15:10:00','2022-10-10 15:30:00',1200,'Assistenza per problemi su account google business',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-12-01 10:49:07','2022-10-10'),
(3114,3,1,53,'2022-10-10 15:30:00','2022-10-10 16:00:00',1800,'Assistenza su pc client Simona per problemi con Outlook, devono contattare chi gestisce la posta',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-09 11:22:23','2022-10-10'),
(3115,3,1,10,'2022-10-11 13:15:00','2022-10-11 13:45:00',1800,'Assistenza su pc client Carmen per problemi con Outlook',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-24 17:01:42','2022-10-11'),
(3116,3,1,97,'2022-10-11 14:10:00','2022-10-11 14:25:00',900,'Passaggio sito da HTTP a HTTPS',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-11-10 15:09:56','2022-10-11'),
(3117,1,2,3,'2022-10-11 12:20:00','2022-10-11 15:00:00',9600,'con te da salsi e first per preventivi',120,NULL,45,1,'Europe/Rome',120,1,'work','2023-01-27 13:04:04','2022-10-11'),
(3118,1,1,50,'2022-10-11 06:41:00','2022-10-11 10:15:00',12840,'problemi import container lxc su proxmox',160.5,NULL,45,1,'Europe/Rome',160.5,1,'work','2023-02-03 09:17:47','2022-10-11'),
(3119,1,1,3,'2022-10-10 09:42:00','2022-10-10 10:30:00',2880,'software backup remoto',36,NULL,45,1,'Europe/Rome',36,1,'work','2023-01-27 13:04:04','2022-10-10'),
(3120,1,1,3,'2022-10-10 12:43:00','2022-10-10 13:20:00',2220,'software backup remoto',27.75,NULL,45,1,'Europe/Rome',27.75,1,'work','2023-01-27 13:03:54','2022-10-10'),
(3121,1,1,3,'2022-10-10 15:08:00','2022-10-10 16:30:00',4920,'software backup remoto',61.5,NULL,45,1,'Europe/Rome',61.5,1,'work','2023-01-27 13:04:04','2022-10-10'),
(3122,1,3,112,'2022-10-11 10:15:00','2022-10-11 10:30:00',900,NULL,11.25,NULL,45,1,'Europe/Rome',11.25,1,'work','2022-12-20 16:13:18','2022-10-11'),
(3123,1,1,3,'2022-10-11 15:20:00','2022-10-11 16:30:00',4200,'software backup remoto',52.5,NULL,45,1,'Europe/Rome',52.5,1,'work','2023-01-27 13:04:03','2022-10-11'),
(3124,3,1,55,'2022-10-12 06:55:00','2022-10-12 07:10:00',900,'Assistenza per problemi posta, riavviata vm che gestisce la posta',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-03 08:31:24','2022-10-12'),
(3125,3,1,104,'2022-10-12 07:25:00','2022-10-12 07:35:00',600,'Assistenza per problemi ricezione posta, riavviati servizi di posta',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-10-14 14:49:05','2022-10-12'),
(3126,3,1,50,'2022-10-12 07:55:00','2022-10-12 08:20:00',1500,'Assistenza su Mac Elisabetta per problemi funzionamento Thunderbird dopo aggiornamento',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-03 09:17:48','2022-10-12'),
(3127,3,1,5,'2022-10-12 08:25:00','2022-10-12 09:00:00',2100,'Assistenza su pc casa Miriam per collegamento remoto al pc dell\'uffico',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-01-17 17:22:24','2022-10-12'),
(3128,3,1,10,'2022-10-12 09:40:00','2022-10-12 10:20:00',2400,'Assistenza su pc client Carmen per problemi mancanza posta inviata, tentato recupero posta da dischi infetti',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-24 17:01:50','2022-10-12'),
(3129,3,2,104,'2022-10-12 12:30:00','2022-10-12 12:55:00',1500,'Verificato materiali stampanti da ordinare, assistenza su cellulare Daniele per problemi con telecamere',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-10-27 13:31:04','2022-10-12'),
(3130,3,1,53,'2022-10-12 13:05:00','2022-10-12 14:05:00',3600,'Assistenza su pc client Simona per problemi con account Exchange, hanno aperto ticket con chi gestisce il loro account di posta',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-09 11:22:24','2022-10-12'),
(3131,3,1,75,'2022-10-12 14:10:00','2022-10-12 14:20:00',600,'Assistenza su pc client Federico per problemi su Thunderbird dopo aggiornamento',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-08 10:42:16','2022-10-12'),
(3132,3,1,51,'2022-10-12 14:30:00','2022-10-12 14:55:00',1500,'Assistenza su Tablet Burdese per installazione app, da verificare in loco',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-07 10:33:34','2022-10-12'),
(3133,1,1,103,'2022-10-13 06:49:00','2022-10-13 08:11:00',4920,'config tel che abbiamo noi con 3cx',61.5,NULL,45,1,'Europe/Rome',61.5,1,'work','2022-12-15 10:40:05','2022-10-13'),
(3134,1,1,3,'2022-10-12 06:52:00','2022-10-12 10:30:00',13080,'proxmxo container',163.5,NULL,45,1,'Europe/Rome',163.5,1,'work','2023-01-27 13:03:49','2022-10-12'),
(3135,1,1,50,'2022-10-12 12:49:00','2022-10-12 16:27:00',13080,'config posta su postfixadmin',163.5,NULL,45,1,'Europe/Rome',163.5,1,'work','2023-02-03 09:17:49','2022-10-12'),
(3136,3,2,103,'2022-10-13 09:00:00','2022-10-13 10:00:00',3600,'Riconsegna telefono voip e fatto prove in vista del cambio linea',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-12-15 10:40:06','2022-10-13'),
(3137,1,1,103,'2022-10-13 12:00:00','2022-10-13 13:39:00',5940,'config tel che abbiamo noi con 3cx',74.25,NULL,45,1,'Europe/Rome',74.25,1,'work','2022-12-15 10:40:08','2022-10-13'),
(3138,1,1,103,'2022-10-13 09:39:00','2022-10-13 11:00:00',4860,'config tel che abbiamo noi con 3cx',60.75,NULL,45,1,'Europe/Rome',60.75,1,'work','2022-12-15 10:40:07','2022-10-13'),
(3139,1,1,75,'2022-10-13 13:40:00','2022-10-13 13:48:00',480,'Commercialista problemi connessione',6,NULL,45,1,'Europe/Rome',6,1,'work','2023-02-08 10:42:22','2022-10-13'),
(3140,1,1,50,'2022-10-13 08:24:00','2022-10-13 09:29:00',3900,'config posta su postfixadmin',48.75,NULL,45,1,'Europe/Rome',48.75,1,'work','2023-02-03 09:17:50','2022-10-13'),
(3141,3,1,18,'2022-10-13 07:00:00','2022-10-13 07:15:00',900,'Assistenza su pc client per problemi con Thunderbird',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-03 08:59:26','2022-10-13'),
(3142,3,1,1,'2022-10-13 15:05:00','2022-10-13 15:20:00',900,'Assistenza su pc client per problemi con Thunderbird',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-01-27 12:58:01','2022-10-13'),
(3143,3,4,87,'2022-10-13 15:45:00','2022-10-13 16:00:00',900,'Sostituzione batteria su UPS APC',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-01-17 10:15:05','2022-10-13'),
(3144,1,1,75,'2022-10-14 07:01:00','2022-10-14 07:05:29',269,'problemi thunderbird aggiornamento',3.36,NULL,45,1,'Europe/Rome',3.36,1,'work','2023-02-08 10:42:17','2022-10-14'),
(3145,1,1,114,'2022-10-14 08:20:00','2022-10-14 10:02:25',6145,'problemi vpn',76.81,NULL,45,1,'Europe/Rome',76.81,1,'work','2023-02-09 16:58:29','2022-10-14'),
(3146,3,2,67,'2022-10-14 07:40:00','2022-10-14 09:40:00',7200,'Verificato e ritirato pc client Alessandra per passaggio a Windows 10 e upgrade hw',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-12-20 16:11:27','2022-10-14'),
(3147,1,3,112,'2022-10-14 10:03:00','2022-10-14 10:30:00',1620,NULL,20.25,NULL,45,1,'Europe/Rome',20.25,1,'work','2022-12-20 16:13:19','2022-10-14'),
(3148,3,2,96,'2022-10-14 09:50:00','2022-10-14 10:30:00',2400,'Assistenza su telefono voip Gandolfo \r\nAssistenza su PC client Cristina per problema casse audio, assistenza su postazione videocall',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-10-14 14:46:52','2022-10-14'),
(3149,3,2,26,'2022-10-14 10:40:00','2022-10-14 11:20:00',2400,'Assistenza su PC client Simona per problemi riavvio, nessun problema riscontrato dopo test disco, agg win e verifica file sistema',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-11-10 16:32:12','2022-10-14'),
(3150,1,1,103,'2022-10-14 12:00:00','2022-10-14 12:30:00',1800,'chiarimenti per nuova linea al tel, ricercati modelli di telefono da offrire e sentita tiziana per discorso nextcloud con hypertac',22.5,NULL,45,1,'Europe/Rome',22.5,1,'work','2022-12-15 10:24:35','2022-10-14'),
(3151,1,1,2,'2022-10-14 06:48:00','2022-10-14 07:00:00',720,'problemi mail',9,NULL,45,1,'Europe/Rome',9,1,'work','2023-02-07 14:45:57','2022-10-14'),
(3152,1,1,2,'2022-10-14 07:13:00','2022-10-14 08:15:00',3720,'problemi mail',46.5,NULL,45,1,'Europe/Rome',46.5,1,'work','2023-02-07 14:45:36','2022-10-14'),
(3153,1,1,2,'2022-10-14 12:43:00','2022-10-14 15:04:00',8460,'migrazione vm windows 2008 su hyperv',105.75,NULL,45,1,'Europe/Rome',105.75,1,'work','2023-02-07 14:45:46','2022-10-14'),
(3154,1,1,114,'2022-10-14 15:24:00','2022-10-14 16:00:00',2160,'problemi vpn',27,NULL,45,1,'Europe/Rome',27,1,'work','2023-02-09 16:58:29','2022-10-14'),
(3155,3,4,67,'2022-10-14 13:00:00','2022-10-14 14:00:00',3600,'Installati si pc client Alessandra 1 ssd s3+ da 1 tb + 8gb ddr3, installato windows 10 + configurazione',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-12-20 16:11:35','2022-10-14'),
(3156,1,1,3,'2022-10-14 16:10:00','2022-10-14 16:45:00',2100,'preventivo baglietto',26.25,NULL,45,1,'Europe/Rome',26.25,1,'work','2023-01-27 13:03:49','2022-10-14'),
(3157,1,2,113,'2022-10-17 06:30:00','2022-10-17 09:55:00',12300,'per preventivo server',153.75,NULL,45,1,'Europe/Rome',153.75,1,'work','2023-01-27 13:08:33','2022-10-17'),
(3158,3,2,67,'2022-10-17 12:55:00','2022-10-17 14:05:00',4200,'Riconsegnato e configurato pc clint Alessandra dopo agg s.o e hw, ritirato pc client Cristina per agg s.o e hw, sostituzione disco di sistema da 2 tb WD su server',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-12-20 16:11:35','2022-10-17'),
(3159,3,2,87,'2022-10-17 14:10:00','2022-10-17 14:25:00',900,'Riconsegnato e collegato ups apc rigenerato',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-01-17 10:15:01','2022-10-17'),
(3160,1,1,114,'2022-10-17 15:14:00','2022-10-17 17:04:23',6623,'problemi connesisone vpn',82.79,NULL,45,1,'Europe/Rome',82.79,1,'work','2023-02-09 16:58:33','2022-10-17'),
(3161,1,1,103,'2022-10-17 13:10:00','2022-10-17 15:13:00',7380,'insrtallazione nextcloud su server',92.25,NULL,45,1,'Europe/Rome',92.25,1,'work','2022-12-15 10:40:09','2022-10-17'),
(3162,1,1,2,'2022-10-17 12:32:00','2022-10-17 13:05:00',1980,'agg nas',24.75,NULL,45,1,'Europe/Rome',24.75,1,'work','2023-02-07 14:45:41','2022-10-17'),
(3163,3,2,26,'2022-10-17 14:25:00','2022-10-17 14:55:00',1800,'Ritirato pc client Simona per assistenza\r\nAssistenza su portatile Simona',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-11-10 16:32:13','2022-10-17'),
(3164,1,1,90,'2022-10-18 06:39:00','2022-10-18 08:27:00',6480,'problema posta rilevato disco rotto, finito server nuovo così fede lo consegna mentre cambia il disco',81,NULL,45,1,'Europe/Rome',81,1,'work','2023-01-23 10:15:05','2022-10-18'),
(3165,1,1,103,'2022-10-18 08:45:00','2022-10-18 10:17:00',5520,'insrtallazione nextcloud su server',69,NULL,45,1,'Europe/Rome',69,1,'work','2022-12-15 10:40:10','2022-10-18'),
(3166,3,2,90,'2022-10-18 09:45:00','2022-10-18 11:00:00',4500,'Consegnato e montato nuovo server nell\'armadio rack\r\nConsegnato e montato nuovo ups nell\'armadio rack \r\nSostituzione disco wd di sistema da 2tb su server win',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-01-23 10:14:56','2022-10-18'),
(3167,1,1,55,'2022-10-18 10:18:00','2022-10-18 10:38:00',1200,'problemi di raggiungibilità server',15,NULL,45,1,'Europe/Rome',15,1,'work','2023-02-03 08:31:24','2022-10-18'),
(3168,1,2,55,'2022-10-18 10:53:00','2022-10-18 11:20:00',1620,'problemi raggiungibiità server',20.25,NULL,45,1,'Europe/Rome',20.25,1,'work','2023-02-03 08:31:26','2022-10-18'),
(3169,1,1,114,'2022-10-18 12:31:00','2022-10-18 14:06:00',5700,'problemi connesisone vpn',71.25,NULL,45,1,'Europe/Rome',71.25,1,'work','2023-02-09 16:58:38','2022-10-18'),
(3170,3,1,114,'2022-10-18 13:15:00','2022-10-18 13:35:00',1200,'Verificata configurazione router TIM sede per problemi lentazza vpn in succursale',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-09 16:24:23','2022-10-18'),
(3171,3,1,50,'2022-10-18 14:25:00','2022-10-18 14:40:00',900,'Censimento utenti che utilizzano i vari indirizzi di posta elettronica',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-03 09:17:51','2022-10-18'),
(3172,3,2,51,'2022-10-19 12:50:00','2022-10-19 13:30:00',2400,'Risolto problema installazione app su tablet android \r\nAssistenza su PC client Andrea',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-07 10:33:32','2022-10-19'),
(3173,1,1,90,'2022-10-18 14:17:00','2022-10-18 16:27:00',7800,'server nuovo installato da fede',97.5,NULL,45,1,'Europe/Rome',97.5,1,'work','2023-01-20 16:17:42','2022-10-18'),
(3174,1,1,103,'2022-10-19 06:45:00','2022-10-19 09:00:00',8100,'ricerca su nextcloud',101.25,NULL,45,1,'Europe/Rome',101.25,1,'work','2022-12-15 10:40:11','2022-10-19'),
(3175,1,1,90,'2022-10-19 09:16:00','2022-10-19 10:30:00',4440,'server nuovo',55.5,NULL,45,1,'Europe/Rome',55.5,1,'work','2023-01-20 16:17:43','2022-10-19'),
(3176,1,1,103,'2022-10-19 12:44:00','2022-10-19 14:26:00',6120,'ricerca su nextcloud',76.5,NULL,45,1,'Europe/Rome',76.5,1,'work','2022-12-15 10:40:12','2022-10-19'),
(3177,1,1,90,'2022-10-19 14:37:00','2022-10-19 14:56:00',1140,'server nuovo',14.25,NULL,45,1,'Europe/Rome',14.25,1,'work','2023-01-20 16:17:45','2022-10-19'),
(3178,1,1,45,'2022-10-19 15:03:00','2022-10-19 15:09:28',388,'problema openvpn',4.85,NULL,45,1,'Europe/Rome',4.85,1,'work','2023-03-16 17:03:46','2022-10-19'),
(3179,3,1,1,'2022-10-19 07:45:00','2022-10-19 07:55:00',600,'Assistenza su pc client Francesco',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-01-27 12:58:00','2022-10-19'),
(3180,3,1,79,'2022-10-19 09:00:00','2022-10-19 09:20:00',1200,'Assistenza su pc client Matteo per modifica firma posta\r\nInstallata 1 licenza nod32 aggiornamento su 2 pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-03 10:56:31','2022-10-19'),
(3181,3,1,75,'2022-10-19 09:20:00','2022-10-19 09:30:00',600,'Assistenza su pc  client per problema Thunderbird dopo aggiornamento',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-08 10:42:21','2022-10-19'),
(3182,3,1,45,'2022-10-19 14:15:00','2022-10-19 15:00:00',2700,'Assistenza per problemi collegamento vpn dopo reset router Fastweb',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-16 17:01:57','2022-10-19'),
(3183,3,2,64,'2022-10-20 07:40:00','2022-10-20 07:50:00',600,'Consegnato portatile + 2 mouse e lettore DVD esterno Mirella',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-05 10:02:08','2022-10-20'),
(3184,3,2,50,'2022-10-20 09:40:00','2022-10-20 10:25:00',2700,'Consegna e installazione 3 nuovi ssd di su server\r\nConsegna portatile figlio Francesco, censimento mail\r\nAssistenza su PC client Stefano Chieregato',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-03 09:17:52','2022-10-20'),
(3185,1,1,2,'2022-10-19 15:18:00','2022-10-19 16:28:00',4200,'agg server',52.5,NULL,45,1,'Europe/Rome',52.5,1,'work','2023-02-07 14:45:31','2022-10-19'),
(3186,1,1,2,'2022-10-20 09:01:00','2022-10-20 10:10:00',4140,'agg server',51.75,NULL,45,1,'Europe/Rome',51.75,1,'work','2023-02-07 14:45:27','2022-10-20'),
(3187,1,1,103,'2022-10-20 06:49:00','2022-10-20 08:46:00',7020,'fine verifiche dopo install di elasticshearch per hypertac',87.75,NULL,45,1,'Europe/Rome',87.75,1,'work','2022-12-15 10:40:13','2022-10-20'),
(3188,1,1,50,'2022-10-20 10:11:00','2022-10-20 10:28:00',1020,'fede li per installare dischi ssd nuovi',12.75,NULL,45,1,'Europe/Rome',12.75,1,'work','2023-02-03 09:18:04','2022-10-20'),
(3189,1,1,50,'2022-10-20 13:48:00','2022-10-20 16:30:00',9720,'preparazione sistema per aggiornamento proxmox',121.5,NULL,45,1,'Europe/Rome',121.5,1,'work','2023-02-03 09:19:42','2022-10-20'),
(3190,1,1,2,'2022-10-20 12:50:00','2022-10-20 13:32:00',2520,'agg server',31.5,NULL,45,1,'Europe/Rome',31.5,1,'work','2023-02-07 14:45:35','2022-10-20'),
(3191,3,4,67,'2022-10-20 12:30:00','2022-10-20 13:30:00',3600,'Installato Windows 10 su pc client Cristina + configurazione, utilizzato ssd 1tb + 8 gb ddr3 ram',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-12-20 16:11:28','2022-10-20'),
(3192,3,1,45,'2022-10-20 14:10:00','2022-10-20 14:40:00',1800,'Assistenza su router Fastweb per problemi collegtamento vpn\r\nInstallata 1 licenza nod32 aggiornamento',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-16 17:04:04','2022-10-20'),
(3193,3,2,90,'2022-10-21 07:40:00','2022-10-21 08:05:00',1500,'Assistenza per problemi navigazione plotter\r\nInstallate 2 licenze nod32 aggiornamento',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-01-23 10:15:00','2022-10-21'),
(3194,1,1,112,'2022-10-21 06:30:00','2022-10-21 06:45:00',900,NULL,11.25,NULL,45,1,'Europe/Rome',11.25,1,'work','2022-12-20 16:13:24','2022-10-21'),
(3195,1,1,50,'2022-10-21 07:03:00','2022-10-21 08:20:00',4620,'sistemazione apache2 su server dopo riavvio di ieri',57.75,NULL,45,1,'Europe/Rome',57.75,1,'work','2023-02-03 09:18:03','2022-10-21'),
(3196,3,2,96,'2022-10-21 08:20:00','2022-10-21 08:30:00',600,'Consegna toner originale stampante Brother',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-11-08 22:12:20','2022-10-21'),
(3197,1,1,3,'2022-10-21 08:32:00','2022-10-21 10:21:00',6540,'problema stampante cliente privato\r\ntest su pc non si isntalla windows',81.75,NULL,45,1,'Europe/Rome',81.75,1,'work','2023-01-27 13:03:53','2022-10-21'),
(3198,3,2,104,'2022-10-21 09:30:00','2022-10-21 10:45:00',4500,'Consegna Tamburo e fusore per stampanti brother, ritirato stampante Brother per problemi dopo sostituzione fusore',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-10-27 13:31:05','2022-10-21'),
(3199,1,6,88,'2022-10-21 13:34:00','2022-10-21 13:54:00',1200,'spiegato funzionamento postfixadmin',15,NULL,45,1,'Europe/Rome',15,1,'work','2022-11-10 16:37:37','2022-10-21'),
(3200,1,4,3,'2022-10-21 12:39:00','2022-10-21 13:10:00',1860,'aiutato fede con stampante trado',23.25,NULL,45,1,'Europe/Rome',23.25,1,'work','2023-01-27 13:03:56','2022-10-21'),
(3201,1,1,67,'2022-10-21 14:00:00','2022-10-21 15:41:40',6100,'configurazione dominio su office 365',76.25,NULL,45,1,'Europe/Rome',76.25,1,'work','2022-12-20 16:11:34','2022-10-21'),
(3202,3,2,67,'2022-10-21 14:15:00','2022-10-21 15:00:00',2700,'Consegnato pc client dopo reinstallazione sistema + configurazione, Consegnato nuovo PC client pino + allineamento a suo PC attuale per passaggio dati',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-12-20 16:11:34','2022-10-21'),
(3203,1,1,50,'2022-10-21 20:09:00','2022-10-21 23:19:07',11407,'preparazione sistema per aggiornamento proxmox',142.59,NULL,45,1,'Europe/Rome',142.59,1,'work','2023-02-03 09:17:54','2022-10-21'),
(3204,1,1,2,'2022-10-24 06:40:00','2022-10-24 07:21:00',2460,'problemi doppio monitor stefanino',30.75,NULL,45,1,'Europe/Rome',30.75,1,'work','2023-02-07 14:45:34','2022-10-24'),
(3205,1,1,67,'2022-10-21 15:56:00','2022-10-21 16:30:00',2040,'configurazione dominio su office 365',25.5,NULL,45,1,'Europe/Rome',25.5,1,'work','2022-12-20 16:11:34','2022-10-21'),
(3206,1,1,50,'2022-10-24 07:30:00','2022-10-24 08:21:00',3060,'preparazione sistema per aggiornamento proxmox',38.25,NULL,45,1,'Europe/Rome',38.25,1,'work','2023-02-03 09:18:28','2022-10-24'),
(3207,1,3,112,'2022-10-24 08:22:00','2022-10-24 09:40:00',4680,NULL,58.5,NULL,45,1,'Europe/Rome',58.5,1,'work','2022-12-20 16:13:20','2022-10-24'),
(3208,3,2,104,'2022-10-24 08:40:00','2022-10-24 09:00:00',1200,'Verificato e ritirato pc client  Sandro',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-10-27 13:31:06','2022-10-24'),
(3209,3,4,104,'2022-10-24 09:20:00','2022-10-24 09:40:00',1200,'Assistenza su pc client Sandro, sostituzione ram difettosa con 1 banco da 4gb DDR3 usata',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-10-27 13:31:08','2022-10-24'),
(3210,3,1,50,'2022-10-24 10:15:00','2022-10-24 10:35:00',1200,'Assistenza su Mac Stefano Chieregato per problemi su Outlook, lavoro da finire',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-03 09:19:44','2022-10-24'),
(3211,3,2,104,'2022-10-24 13:50:00','2022-10-24 14:00:00',600,'Riconsegnato pc client Sandro',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-10-27 13:31:11','2022-10-24'),
(3212,3,4,2,'2022-10-24 14:00:00','2022-10-24 14:10:00',600,'Sostituzione batteria su UPS APC 700',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-07 14:45:49','2022-10-24'),
(3213,1,1,2,'2022-10-24 09:50:00','2022-10-24 10:10:00',1200,'problemi doppio monitor stefanino',15,NULL,45,1,'Europe/Rome',15,1,'work','2023-02-07 14:45:29','2022-10-24'),
(3214,1,1,2,'2022-10-24 10:45:00','2022-10-24 11:30:00',2700,'consegna pc nuovo stefanino e installazione fisica su postazione temporanea, copia dati da server per migrazione su vm',33.75,NULL,45,1,'Europe/Rome',33.75,1,'work','2023-02-07 14:45:46','2022-10-24'),
(3215,1,1,3,'2022-10-24 11:45:00','2022-10-24 11:50:00',300,'portato in lab ups cristallina',3.75,NULL,45,1,'Europe/Rome',3.75,1,'work','2023-01-27 13:03:53','2022-10-24'),
(3216,1,1,2,'2022-10-24 12:30:00','2022-10-24 16:00:00',12600,'configurazione e copia dati pc stefanino su nuovo, migraizone vecchios erver su vm',157.5,NULL,45,1,'Europe/Rome',157.5,1,'work','2023-02-07 14:45:40','2022-10-24'),
(3217,3,2,2,'2022-10-25 08:35:00','2022-10-25 10:15:00',6000,'Riconsegna ups apc 700 rigenerato\r\nAssistenza su vecchio server Windows \r\nConfigurato nuovo PC client Stefano',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-07 14:45:40','2022-10-25'),
(3218,1,1,50,'2022-10-25 14:33:00','2022-10-25 15:29:42',3402,'problema mail stefano outlook',42.53,NULL,45,1,'Europe/Rome',42.53,1,'work','2023-02-03 09:18:02','2022-10-25'),
(3219,1,1,50,'2022-10-25 13:19:00','2022-10-25 14:26:00',4020,'nuovo server posta',50.25,NULL,45,1,'Europe/Rome',50.25,1,'work','2023-02-03 09:19:43','2022-10-25'),
(3220,1,1,67,'2022-10-25 12:30:00','2022-10-25 13:07:00',2220,'fede li config account ms',27.75,NULL,45,1,'Europe/Rome',27.75,1,'work','2022-12-15 10:41:24','2022-10-25'),
(3221,1,1,50,'2022-10-25 09:00:00','2022-10-25 10:27:00',5220,'nuovo server posta',65.25,NULL,45,1,'Europe/Rome',65.25,1,'work','2023-02-03 09:18:02','2022-10-25'),
(3222,1,1,2,'2022-10-25 06:50:00','2022-10-25 08:44:00',6840,'virtuaizzaizone vecchio server',85.5,NULL,45,1,'Europe/Rome',85.5,1,'work','2023-02-07 14:45:29','2022-10-25'),
(3223,1,1,50,'2022-10-25 15:31:44','2022-10-25 16:48:16',4592,'nuovo server posta',57.4,NULL,45,1,'Europe/Rome',57.4,1,'work','2023-02-03 09:17:57','2022-10-25'),
(3224,3,2,67,'2022-10-25 12:50:00','2022-10-25 15:40:00',10200,'Finita configurazione nuovo PC client Pino più installazione office 365 e configurazione mail\r\nInstallato office 365 + configurazione mail su PC client Sabrina Torlo. Fatto il punto con Andrea su tutti i PC client in cui va installato e configurato office 365',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-12-20 16:11:29','2022-10-25'),
(3225,3,1,67,'2022-10-25 16:30:00','2022-10-25 16:40:00',600,'Cambiata password su account mail',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-12-20 16:11:33','2022-10-25'),
(3226,1,1,3,'2022-10-25 06:30:00','2022-10-25 06:40:00',600,'portato adattatore hdmi vga per cristallina',7.5,NULL,45,1,'Europe/Rome',7.5,1,'work','2023-01-27 13:03:52','2022-10-25'),
(3227,3,2,79,'2022-10-26 10:30:00','2022-10-26 10:40:00',600,'Consegna 2 kit toner compatibili per Brother',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-03 10:20:09','2022-10-26'),
(3228,1,3,112,'2022-10-26 13:30:00','2022-10-26 15:40:00',7800,NULL,97.5,NULL,45,1,'Europe/Rome',97.5,1,'work','2022-12-20 16:13:23','2022-10-26'),
(3229,3,2,56,'2022-10-26 16:05:00','2022-10-26 16:15:00',600,'Ritirato pc client per verifica possibili virus',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-13 15:07:29','2022-10-26'),
(3230,3,1,56,'2022-10-26 13:40:00','2022-10-26 14:10:00',1800,'Assistenza su pc client Imperiale, da ritirare per verificare presenza virus',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-13 15:07:29','2022-10-26'),
(3231,1,1,50,'2022-10-26 08:46:00','2022-10-26 10:28:00',6120,'server posta nuovo',76.5,NULL,45,1,'Europe/Rome',76.5,1,'work','2023-02-03 09:18:02','2022-10-26'),
(3232,1,1,2,'2022-10-26 06:45:00','2022-10-26 08:37:00',6720,'vm server vecchio, problmi pc nuovo stefanino \r\nprobabile switch ciocca',84,NULL,45,1,'Europe/Rome',84,1,'work','2023-02-07 14:45:36','2022-10-26'),
(3233,1,1,50,'2022-10-26 12:30:00','2022-10-26 13:23:00',3180,'server mail nuovo',39.75,NULL,45,1,'Europe/Rome',39.75,1,'work','2023-02-03 09:17:58','2022-10-26'),
(3234,1,1,50,'2022-10-26 15:47:00','2022-10-26 17:00:00',4380,'server mail niovo',54.75,NULL,45,1,'Europe/Rome',54.75,1,'work','2023-02-03 09:17:58','2022-10-26'),
(3235,3,2,24,'2022-10-27 09:00:00','2022-10-27 09:20:00',1200,'Assistenza su PC client Gommista\r\nConsegna e installazione alimentatore telefono voip',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-12-01 10:49:08','2022-10-27'),
(3236,1,1,108,'2022-10-27 09:00:00','2022-10-27 09:10:00',600,'reset password maill',7.5,NULL,45,1,'Europe/Rome',7.5,1,'work','2023-03-17 09:12:25','2022-10-27'),
(3237,1,1,2,'2022-10-27 06:48:00','2022-10-27 08:48:00',7200,'server vecchio vm',90,NULL,45,1,'Europe/Rome',90,1,'work','2023-02-07 14:45:39','2022-10-27'),
(3238,1,1,2,'2022-10-27 12:38:00','2022-10-27 14:56:38',8318,'pulizia desktop Stefano Cevasco',103.98,NULL,45,1,'Europe/Rome',103.98,1,'work','2023-02-07 14:45:56','2022-10-27'),
(3239,3,2,41,'2022-10-27 15:00:00','2022-10-27 15:15:00',900,'Sostituzione disco di bk da 4tb WD Red Pro su NAS Buffalo in via Wagner',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-11-08 20:51:29','2022-10-27'),
(3240,3,1,26,'2022-10-27 08:45:00','2022-10-27 08:55:00',600,'Assistenza su pc client Simona per problemi su rubrica Thunderbird',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-11-10 16:32:15','2022-10-27'),
(3241,3,4,56,'2022-10-27 13:00:00','2022-10-27 14:00:00',3600,'Assistenza su pc client Imperiale ritirato',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-13 15:07:32','2022-10-27'),
(3242,3,2,56,'2022-10-28 08:00:00','2022-10-28 08:20:00',1200,'Riconsegna pc client Imperiale dopo assistenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-13 15:07:29','2022-10-28'),
(3243,3,2,6,'2022-10-28 08:35:00','2022-10-28 09:20:00',2700,'Assistenza su PC client per problemi sincronizzazione utente',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-07 10:56:30','2022-10-28'),
(3244,3,2,117,'2022-10-28 09:20:00','2022-10-28 09:30:00',600,'Ritirati 2 pc client per upgrade hw e sw',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-01-31 11:03:58','2022-10-28'),
(3245,1,3,112,'2022-10-28 08:35:00','2022-10-28 10:20:00',6300,NULL,78.75,NULL,45,1,'Europe/Rome',78.75,1,'work','2022-12-20 16:13:26','2022-10-28'),
(3246,1,1,50,'2022-10-28 06:46:00','2022-10-28 08:33:00',6420,'server mail nuovo fine config backup',80.25,NULL,45,1,'Europe/Rome',80.25,1,'work','2023-02-03 09:18:14','2022-10-28'),
(3247,1,1,2,'2022-10-28 10:20:00','2022-10-28 10:30:00',600,'pc nuovo stefanino rallenta la velocità della scheda di rete a 10 mb',7.5,NULL,45,1,'Europe/Rome',7.5,1,'work','2023-02-07 14:45:49','2022-10-28'),
(3248,1,1,50,'2022-10-27 15:09:00','2022-10-27 16:50:00',6060,'server mail nuovo fine config backup',75.75,NULL,45,1,'Europe/Rome',75.75,1,'work','2023-02-03 09:17:58','2022-10-27'),
(3249,1,1,1,'2022-10-28 10:33:00','2022-10-28 11:55:48',4968,'messaggio assenza e agg server',62.1,NULL,45,1,'Europe/Rome',62.1,1,'work','2023-01-27 12:57:55','2022-10-28'),
(3250,3,2,12,'2022-10-28 09:45:00','2022-10-28 10:45:00',3600,'Assistenza su 2 Ipad per problemi collegamento al server in vpn',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-03 14:36:29','2022-10-28'),
(3251,1,1,51,'2022-10-28 13:47:00','2022-10-28 14:18:00',1860,'risposta per gdpr',23.25,NULL,45,1,'Europe/Rome',23.25,1,'work','2023-02-07 09:38:55','2022-10-28'),
(3252,3,1,22,'2022-10-28 12:45:00','2022-10-28 13:05:00',1200,'Assistenza su pc client Stefano per unire  le partizioni C e D',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-09 11:00:48','2022-10-28'),
(3253,3,2,55,'2022-10-31 10:50:00','2022-10-31 11:15:00',1500,'Sostituzione mb, cpu e ram su PC client \"Amazon\"\r\nRiconsegnato vecchio PC client Dallavalle',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-12-28 11:11:38','2022-10-31'),
(3254,1,1,50,'2022-10-28 12:00:00','2022-10-28 13:32:00',5520,'server mail',69,NULL,45,1,'Europe/Rome',69,1,'work','2023-02-03 09:18:12','2022-10-28'),
(3255,1,1,90,'2022-10-28 14:38:00','2022-10-28 16:26:00',6480,'nuov server',81,NULL,45,1,'Europe/Rome',81,1,'work','2023-01-20 16:17:48','2022-10-28'),
(3256,1,1,2,'2022-10-31 07:48:00','2022-10-31 10:00:00',7920,'cercato di mettere sotto sforzo gli switch per i problemi segnalati',99,NULL,45,1,'Europe/Rome',99,1,'work','2023-02-07 14:45:37','2022-10-31'),
(3257,1,1,87,'2022-10-31 10:16:00','2022-10-31 11:28:00',4320,'problema mail gmail',54,NULL,45,1,'Europe/Rome',54,1,'work','2023-01-17 10:01:13','2022-10-31'),
(3258,1,1,90,'2022-10-31 13:45:00','2022-10-31 17:20:00',12900,'pulizia server linux quasi a tappo\r\ndalle 14:45 alle 16:30 su server nuovo',161.25,NULL,45,1,'Europe/Rome',161.25,1,'work','2023-01-23 09:03:17','2022-10-31'),
(3259,3,1,97,'2022-10-31 13:55:00','2022-10-31 14:05:00',600,'Verificate mail arrivate al dottore dopo modifiche sito',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-11-10 15:09:57','2022-10-31'),
(3260,3,4,117,'2022-10-31 14:10:00','2022-10-31 17:10:00',10800,'Assistenza, test e verifiche per upgrade hw su 2 pc client ritirati',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-01-31 10:45:33','2022-10-31'),
(3261,1,1,50,'2022-11-01 08:15:00','2022-11-01 09:10:00',3300,'problema mail server',41.25,NULL,45,1,'Europe/Rome',41.25,1,'work','2023-02-03 09:19:44','2022-11-01'),
(3262,3,2,64,'2022-11-02 07:55:00','2022-11-02 08:10:00',900,'Sostituzione 2 batterie su ups apc 1400 collegato al server',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-05 10:09:39','2022-11-02'),
(3263,3,2,76,'2022-11-02 08:55:00','2022-11-02 09:15:00',1200,'Assistenza su PC client collegato alla fresa, ci fa sapere per possibile upgrade hw e sw',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-12-20 15:37:00','2022-11-02'),
(3264,3,2,12,'2022-11-02 09:35:00','2022-11-02 09:45:00',600,'Ritirato ipad Vella per assistenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-03 14:36:30','2022-11-02'),
(3265,1,3,112,'2022-11-02 09:17:00','2022-11-02 10:10:00',3180,NULL,39.75,NULL,45,1,'Europe/Rome',39.75,1,'work','2023-03-08 17:14:56','2022-11-02'),
(3266,1,1,50,'2022-11-02 07:52:00','2022-11-02 09:10:00',4680,'sincro mail per migrazione',58.5,NULL,45,1,'Europe/Rome',58.5,1,'work','2023-02-03 09:18:10','2022-11-02'),
(3267,1,1,64,'2022-11-02 07:30:00','2022-11-02 07:43:00',780,'problema ups',9.75,NULL,45,1,'Europe/Rome',9.75,1,'work','2023-04-05 10:09:38','2022-11-02'),
(3268,1,1,114,'2022-11-02 10:11:00','2022-11-02 10:40:00',1740,'problema di navigazione',21.75,NULL,45,1,'Europe/Rome',21.75,1,'work','2023-02-09 16:58:35','2022-11-02'),
(3269,3,2,1,'2022-11-02 10:10:00','2022-11-02 10:40:00',1800,'Risistemato rete LAN e port mapping nella sede di Borzoli dopo cambio operatore linea dati',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-01-27 12:57:47','2022-11-02'),
(3270,1,1,50,'2022-11-02 11:17:00','2022-11-02 17:14:00',21420,'cambio configurazione client su tutti i pc per nuovo server di posta',267.75,NULL,45,1,'Europe/Rome',267.75,1,'work','2023-02-03 09:19:47','2022-11-02'),
(3271,3,2,12,'2022-11-02 13:50:00','2022-11-02 14:05:00',900,'Riconsegnato ipad Vella dopo aver risolto problema collegamento al server in vpn',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-03 14:36:35','2022-11-02'),
(3272,3,2,114,'2022-11-02 14:35:00','2022-11-02 15:10:00',2100,'Assistenza per problemi di rete dovuti a switch difettoso',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-09 16:58:35','2022-11-02'),
(3273,1,1,50,'2022-11-02 17:32:00','2022-11-02 18:30:00',3480,'cambio configurazione client su tutti i pc per nuovo server di posta',43.5,NULL,45,1,'Europe/Rome',43.5,1,'work','2023-02-03 09:18:09','2022-11-02'),
(3274,1,1,6,'2022-11-03 11:16:00','2022-11-03 11:45:00',1740,'problemi disco fede li',21.75,NULL,45,1,'Europe/Rome',21.75,1,'work','2023-02-07 10:56:33','2022-11-03'),
(3275,1,1,6,'2022-11-03 13:40:00','2022-11-03 14:23:00',2580,'config backup e notifiche',32.25,NULL,45,1,'Europe/Rome',32.25,1,'work','2023-02-07 10:56:34','2022-11-03'),
(3276,1,1,50,'2022-11-03 07:50:00','2022-11-03 09:45:00',6900,'sistemazione backup e client che mancavano',86.25,NULL,45,1,'Europe/Rome',86.25,1,'work','2023-02-03 09:18:04','2022-11-03'),
(3277,1,1,103,'2022-11-03 09:53:00','2022-11-03 11:11:00',4680,'tizi fastweb li prove con centralino\r\nfine config 3cx',58.5,NULL,45,1,'Europe/Rome',58.5,1,'work','2023-02-28 08:29:37','2022-11-03'),
(3278,1,1,50,'2022-11-03 14:33:00','2022-11-03 17:35:00',10920,'config filippo\r\nriorganizzazione mail filippo per problemi di connessione random su thunderbird',136.5,NULL,45,1,'Europe/Rome',136.5,1,'work','2023-02-03 09:18:08','2022-11-03'),
(3279,3,1,103,'2022-11-03 08:10:00','2022-11-03 08:30:00',1200,'Assistenza telefonica con tecnico Fastweb che installava nuova linea dati/telefonica',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-28 08:29:35','2022-11-03'),
(3280,3,2,6,'2022-11-03 10:45:00','2022-11-03 12:00:00',4500,'Assistenza su pc client Amministrazione per problemi collegamento al NAS dovuti ad un danno fatto alla linea elettrica',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-07 10:56:31','2022-11-03'),
(3281,3,1,41,'2022-11-03 14:05:00','2022-11-03 14:20:00',900,'Installate 2 licenze nod32 aggiornamento su 4 pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-11-08 20:51:30','2022-11-03'),
(3282,3,1,22,'2022-11-03 14:45:00','2022-11-03 15:45:00',3600,'Assistenza su pc client Stefano per problemi funzionamento software IDMCadLite2022 dopo modifica partizioni PC. Interveto da finere dopo che ci risponderà l\'assistenza tecnica del software',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-09 11:00:55','2022-11-03'),
(3283,3,2,120,'2022-11-03 09:45:00','2022-11-03 10:30:00',2700,'Consegna e installazione UPS APC 500, consegna e installazione switch 8 porte gigabit, assistenza su pc client Marisa.\r\nRitirato portatile Marisa per assistenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-11-23 17:10:47','2022-11-03'),
(3284,1,1,3,'2022-10-13 14:06:00','2022-10-13 16:27:00',8460,'proxmox',105.75,NULL,45,1,'Europe/Rome',105.75,1,'work','2023-01-27 13:03:49','2022-10-13'),
(3285,1,1,2,'2022-10-27 09:16:00','2022-10-27 10:30:00',4440,'vm vecchio server',55.5,NULL,45,1,'Europe/Rome',55.5,1,'work','2023-02-07 14:45:42','2022-10-27'),
(3286,1,1,3,'2022-11-04 07:20:00','2022-11-04 09:20:00',7200,'montato server temp proxmox per test first',90,NULL,45,1,'Europe/Rome',90,1,'work','2023-01-27 13:03:52','2022-11-04'),
(3287,1,1,3,'2022-11-04 09:24:00','2022-11-04 09:44:00',1200,'orari',15,NULL,45,1,'Europe/Rome',15,1,'work','2023-01-27 13:04:03','2022-11-04'),
(3288,3,2,26,'2022-11-04 11:10:00','2022-11-04 12:10:00',3600,'Consegnato e configurato nuovo PC client Simona',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-11-10 16:32:13','2022-11-04'),
(3289,1,1,3,'2022-11-04 10:02:00','2022-11-04 11:50:00',6480,'test proxmox su migrazione su zfs con areca',81,NULL,45,1,'Europe/Rome',81,1,'work','2023-01-27 13:04:28','2022-11-04'),
(3290,1,1,3,'2022-11-04 13:39:00','2022-11-04 17:00:00',12060,'test proxmox su migrazione su zfs con areca',150.75,NULL,45,1,'Europe/Rome',150.75,1,'work','2023-01-27 13:03:52','2022-11-04'),
(3291,1,1,50,'2022-11-04 17:03:00','2022-11-04 17:51:06',2886,'problemi pc filippo thunderbird si disconnette dal server o si chiude a random',36.08,NULL,45,1,'Europe/Rome',36.08,1,'work','2023-02-03 09:18:05','2022-11-04'),
(3292,3,1,22,'2022-11-04 09:20:00','2022-11-04 10:20:00',3600,'Assistenza su pc client Stefano per problemi funzionamento software IDMCadLite2022 dopo modifica partizioni PC. Interveto da finere dopo che ci risponderà l\'assistenza tecnica del software',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-09 11:01:03','2022-11-04'),
(3293,1,1,50,'2022-11-04 20:39:00','2022-11-04 20:55:01',961,'configurazione nuove mail su pc francesco casa',12.01,NULL,45,1,'Europe/Rome',12.01,1,'work','2023-02-03 09:18:07','2022-11-04'),
(3294,1,1,50,'2022-11-07 09:10:00','2022-11-07 09:31:00',1260,'configurazione mail su pc elisabetta casa',15.75,NULL,45,1,'Europe/Rome',15.75,1,'work','2023-02-03 09:18:12','2022-11-07'),
(3295,1,2,104,'2022-11-07 07:19:00','2022-11-07 07:36:00',1020,'problemi dopo aggiornamento server non si accende',12.75,NULL,45,1,'Europe/Rome',12.75,1,'work','2023-01-13 08:35:44','2022-11-07'),
(3296,3,2,9,'2022-11-07 15:00:00','2022-11-07 15:20:00',1200,'Riconfigurazione router dopo reset fatto da operatore',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-03 08:49:40','2022-11-07'),
(3297,1,1,79,'2022-11-07 15:30:00','2022-11-07 19:02:12',12732,'nuovo sito web',159.15,NULL,45,1,'Europe/Rome',159.15,1,'work','2023-02-03 10:56:22','2022-11-07'),
(3298,1,1,3,'2022-11-07 08:12:00','2022-11-07 09:05:00',3180,'proxmox backup studio',39.75,NULL,45,1,'Europe/Rome',39.75,1,'work','2023-01-27 13:04:27','2022-11-07'),
(3299,1,1,3,'2022-11-07 09:45:00','2022-11-07 11:25:00',6000,'proxmox backup studio',75,NULL,45,1,'Europe/Rome',75,1,'work','2023-01-27 13:04:20','2022-11-07'),
(3300,1,1,50,'2022-11-07 13:44:00','2022-11-07 15:18:00',5640,'preparazione per migrazione file system',70.5,NULL,45,1,'Europe/Rome',70.5,1,'work','2023-02-03 09:18:14','2022-11-07'),
(3301,1,1,79,'2022-11-07 20:29:00','2022-11-07 22:30:00',7260,'manutenzione varie aggiornamenti\r\nspostamento gestione certificati ssl \r\nspostamento roundcube webmail\r\npunti di montaggio con host per vm mail e vm web',90.75,NULL,45,1,'Europe/Rome',90.75,1,'work','2023-02-03 10:56:23','2022-11-07'),
(3302,3,1,55,'2022-11-07 09:20:00','2022-11-07 09:50:00',1800,'Assistenza su pc client Otto per problemi con le stampanti',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-03 08:31:26','2022-11-07'),
(3303,3,1,26,'2022-11-07 10:20:00','2022-11-07 10:40:00',1200,'Assistenza su pc client Simona per problemi con Thunderbird',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-11-10 16:32:14','2022-11-07'),
(3304,3,1,96,'2022-11-07 15:55:00','2022-11-07 16:20:00',1500,'Assistenza su pc client Federica per problemi con Smart Card, installata 1 licenza nod32 aggiornamento',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-11-08 22:14:23','2022-11-07'),
(3305,3,2,96,'2022-11-08 12:25:00','2022-11-08 12:55:00',1800,'Assistenza su server per problemi avvio dopo aggiornamenti, assistenza su PC client Cristina',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-11-08 22:14:25','2022-11-08'),
(3306,3,1,26,'2022-11-08 12:55:00','2022-11-08 13:05:00',600,'Riavvio server dopo aggiornamenti',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-11-10 15:30:38','2022-11-08'),
(3307,3,1,101,'2022-01-14 13:05:00','2022-01-14 13:15:00',600,'Riavvio server dopo aggiornamenti',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-11-10 16:32:52','2022-01-14'),
(3308,3,2,1,'2022-11-08 13:25:00','2022-11-08 13:50:00',1500,'Assistenza su PC client Roberta per problemi collegamento al server',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-01-27 12:58:00','2022-11-08'),
(3309,1,1,4,'2022-11-08 11:00:00','2022-11-08 11:26:00',1560,'test su mail non ricevute',19.5,NULL,45,1,'Europe/Rome',19.5,1,'work','2023-04-06 07:57:22','2022-11-08'),
(3310,1,1,79,'2022-11-08 09:11:00','2022-11-08 10:50:00',5940,'config varie per nuovo sito (interne per vedere sito)\r\nroundcube con php8.1',74.25,NULL,45,1,'Europe/Rome',74.25,1,'work','2023-02-03 10:56:22','2022-11-08'),
(3311,1,1,2,'2022-11-08 07:44:00','2022-11-08 09:00:00',4560,'agg server',57,NULL,45,1,'Europe/Rome',57,1,'work','2023-02-07 14:45:45','2022-11-08'),
(3312,1,3,112,'2022-11-08 13:50:00','2022-11-08 14:00:00',600,NULL,7.5,NULL,45,1,'Europe/Rome',7.5,1,'work','2022-12-22 15:13:27','2022-11-08'),
(3313,1,1,1,'2022-11-08 13:30:00','2022-11-08 13:47:00',1020,'verifiche server dopo salto corrente',12.75,NULL,45,1,'Europe/Rome',12.75,1,'work','2023-01-27 12:57:49','2022-11-08'),
(3314,3,2,103,'2022-11-08 14:10:00','2022-11-08 15:55:00',6300,'Passaggio linea dati da Vodafone a Fastweb, test su telefoni voip',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-28 08:29:37','2022-11-08'),
(3315,1,1,90,'2022-11-08 16:00:00','2022-11-08 18:02:09',7329,'certificati ssl\r\nserver nuovo',91.61,NULL,45,1,'Europe/Rome',91.61,1,'work','2023-01-23 09:03:28','2022-11-08'),
(3316,1,1,103,'2022-11-08 14:10:00','2022-11-08 15:50:00',6000,'fede li reset beronet\r\nriconfig 3cx test chiamate\r\nriconfigurata wan con fastweb e test di funzionamento',75,NULL,45,1,'Europe/Rome',75,1,'work','2023-02-28 08:29:38','2022-11-08'),
(3317,3,2,95,'2022-11-08 16:30:00','2022-11-08 17:30:00',3600,'Assistenza su PC client Porcile per possibile virus\r\nRiavvio server dopo aggiornamenti',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-12-28 11:10:26','2022-11-08'),
(3318,1,1,50,'2022-11-08 20:00:00','2022-11-08 20:20:00',1200,'pulizia dischi sistema per migrazione zfs',15,NULL,45,1,'Europe/Rome',15,1,'work','2023-02-03 09:18:27','2022-11-08'),
(3319,3,4,117,'2022-11-08 07:50:00','2022-11-08 09:20:00',5400,'Reinstallato Windows 11 su 2 pc client , utilizzati 2 ssd 480gb S3+ e 4 gb di ram ddr3 usata',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-01-31 11:03:59','2022-11-08'),
(3320,3,1,108,'2022-11-08 08:55:00','2022-11-08 09:05:00',600,'Assistenza su pc client Biglietteria per problemi accesso posta',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-17 09:51:54','2022-11-08'),
(3321,3,1,79,'2022-11-08 10:20:00','2022-11-08 10:40:00',1200,'Assistenza per problemi visualizzazione nuovo sito dalla rete locale',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-03 10:56:31','2022-11-08'),
(3322,3,1,2,'2022-11-08 11:20:00','2022-11-08 11:30:00',600,'Assistenza su pc client Andrea',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-07 14:45:38','2022-11-08'),
(3323,1,3,112,'2022-11-09 11:15:00','2022-11-09 11:30:00',900,NULL,11.25,NULL,45,1,'Europe/Rome',11.25,1,'work','2022-12-22 15:13:21','2022-11-09'),
(3324,1,1,103,'2022-11-09 14:08:00','2022-11-09 14:52:26',2666,'rimozione blacklist varie spamlist',33.33,NULL,45,1,'Europe/Rome',33.33,1,'work','2023-02-28 08:29:38','2022-11-09'),
(3325,1,1,50,'2022-11-09 07:42:00','2022-11-09 09:13:00',5460,'server bloccato per backup lento',68.25,NULL,45,1,'Europe/Rome',68.25,1,'work','2023-02-03 09:18:27','2022-11-09'),
(3326,1,1,3,'2022-11-09 09:14:00','2022-11-09 11:12:00',7080,'varie prove su proxmox',88.5,NULL,45,1,'Europe/Rome',88.5,1,'work','2023-01-27 13:04:28','2022-11-09'),
(3327,1,1,2,'2022-11-09 22:24:00','2022-11-09 23:12:40',2920,'agg server',36.5,NULL,45,1,'Europe/Rome',36.5,1,'work','2023-02-07 14:45:43','2022-11-09'),
(3328,1,1,50,'2022-11-09 21:40:00','2022-11-09 22:22:00',2520,'spostamento vm su altro ssd temporaneo',31.5,NULL,45,1,'Europe/Rome',31.5,1,'work','2023-02-03 09:18:26','2022-11-09'),
(3329,1,1,3,'2022-11-09 15:00:00','2022-11-09 18:00:00',10800,'studio proxmox per conversione array in zfs',135,NULL,45,1,'Europe/Rome',135,1,'work','2023-01-27 13:03:56','2022-11-09'),
(3330,1,1,3,'2022-11-09 13:35:00','2022-11-09 14:00:00',1500,'studio proxmox per spostamento zfs',18.75,NULL,45,1,'Europe/Rome',18.75,1,'work','2023-01-27 13:03:56','2022-11-09'),
(3331,1,1,90,'2022-11-09 23:13:00','2022-11-10 00:10:54',3474,'server nuovo',43.43,NULL,45,1,'Europe/Rome',43.43,1,'work','2023-01-20 16:17:50','2022-11-10'),
(3332,1,1,50,'2022-11-10 00:11:05','2022-11-10 00:57:09',2764,'spostamento vm su altro ssd temporaneo',34.55,NULL,45,1,'Europe/Rome',34.55,1,'work','2023-02-03 09:18:26','2022-11-10'),
(3333,3,1,85,'2022-11-09 08:25:00','2022-11-09 08:40:00',900,'Assistenza per liberare spazio su posta Giacomo',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-30 15:13:03','2022-11-09'),
(3334,3,1,79,'2022-11-09 10:15:00','2022-11-09 10:25:00',600,'Assistenza su pc client Andrea per problemi visualizzazione sito',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-03 10:56:31','2022-11-09'),
(3335,3,1,67,'2022-11-09 10:35:00','2022-11-09 10:45:00',600,'Fatte modifiche su posta richieste da Andrea Lombardo',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-12-20 16:11:36','2022-11-09'),
(3336,3,1,67,'2022-11-09 11:15:00','2022-11-09 12:15:00',3600,'Installato office 365 + configurazione posta su Outlook su pc client Simona Ganzarolli',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-12-20 16:11:33','2022-11-09'),
(3337,3,1,2,'2022-11-09 13:55:00','2022-11-09 14:05:00',600,'Riavvio server debian dopo aggiornamenti',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-07 14:45:49','2022-11-09'),
(3338,3,1,59,'2022-11-09 14:55:00','2022-11-09 15:05:00',600,'Installata 1 licenza aggiornamento su 2 pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-03 08:36:45','2022-11-09'),
(3339,3,1,76,'2022-11-09 15:05:00','2022-11-09 15:40:00',2100,'Assistenza per problemi verifica in 2 passaggi su account Google, intervento da ultimare',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-12-20 15:37:01','2022-11-09'),
(3340,1,3,112,'2022-11-10 08:30:00','2022-11-10 10:30:00',7200,NULL,90,NULL,45,1,'Europe/Rome',90,1,'work','2022-12-22 15:13:21','2022-11-10'),
(3341,1,1,50,'2022-11-10 07:10:00','2022-11-10 08:30:00',4800,'problemi snapshot per mount point',60,NULL,45,1,'Europe/Rome',60,1,'work','2023-02-03 09:18:25','2022-11-10'),
(3342,1,1,50,'2022-11-10 10:33:00','2022-11-10 11:54:55',4915,'problemi snapshot per mount point\r\nproblemi mail in uscita elisabetta',61.44,NULL,45,1,'Europe/Rome',61.44,1,'work','2023-02-03 09:18:25','2022-11-10'),
(3343,3,2,117,'2022-11-10 11:00:00','2022-11-10 12:10:00',4200,'Riconsegna 2 pc client dopo upgrade hw e sw\r\nInstallata 1 licenza completa nod32 su 2 PC client\r\nOrdinare 4 switch gigabit 5 porte\r\nRitirati 2 PC client per upgrade hw e sw',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-01-31 11:04:12','2022-11-10'),
(3344,3,2,100,'2022-11-10 12:30:00','2022-11-10 14:15:00',6300,'Ordinare switch 8 porte giga per sost. switch 10/100\r\nOrdinare ups apc per sost. APC 650 difettoso collegato al server\r\nVerificato mac Riccardo per problemi lentezza \r\nAssistenza su altri mac, stampanti e plotter',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-11-21 14:18:44','2022-11-10'),
(3345,3,1,108,'2022-11-10 07:45:00','2022-11-10 07:55:00',600,'Assistenza su pc client Biglietteria',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-17 09:52:13','2022-11-10'),
(3346,3,1,67,'2022-11-10 08:35:00','2022-11-10 08:45:00',600,'Modificate impostazione posta richieste da Andrea Lombardo',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-12-20 16:11:32','2022-11-10'),
(3347,3,1,26,'2022-11-10 08:55:00','2022-11-10 09:10:00',900,'Assistenza per problemi visualizzazione sito dopo riavvio server',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-12-15 10:08:24','2022-11-10'),
(3348,3,1,97,'2022-11-10 15:25:00','2022-11-10 15:45:00',1200,'Assistenza per problemi invio posta verso account gmail',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-10 16:18:06','2022-11-10'),
(3349,3,1,22,'2022-11-10 17:00:00','2022-11-10 17:10:00',600,'Assistenza su pc client Boccaleri padre per svuotare casella pec',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-09 11:00:50','2022-11-10'),
(3350,3,2,108,'2022-11-11 08:45:00','2022-11-11 09:45:00',3600,'Assistenza su server che non si avviava, sostituzione alimentatore con CM 750W. Verificati raid che davano problemi dopo riavvio server',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-17 09:52:02','2022-11-11'),
(3351,1,1,50,'2022-11-11 13:45:00','2022-11-11 16:00:00',8100,'problemi snapshot per mount point\r\nproblemi mail in uscita elisabetta',101.25,NULL,45,1,'Europe/Rome',101.25,1,'work','2023-02-03 09:18:25','2022-11-11'),
(3352,3,1,1,'2022-11-11 10:30:00','2022-11-11 11:10:00',2400,'Creata nuovo indirizzo posta e configurato su 5 pc client, assistenza su firma posta',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-01-27 12:57:51','2022-11-11'),
(3353,3,1,76,'2022-11-11 14:35:00','2022-11-11 15:35:00',3600,'Assistenza per problemi verifica in 2 passaggi su account google, problema non risolto',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-12-20 15:37:02','2022-11-11'),
(3354,3,1,22,'2022-11-11 16:25:00','2022-11-11 16:45:00',1200,'Assistenza su pc client Boccaleri padre',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-09 11:00:55','2022-11-11'),
(3355,1,1,50,'2022-11-14 07:41:00','2022-11-14 09:35:00',6840,'problemi snapshot',85.5,NULL,45,1,'Europe/Rome',85.5,1,'work','2023-02-03 09:19:46','2022-11-14'),
(3357,1,1,50,'2022-11-14 13:44:00','2022-11-14 17:47:14',14594,'problemi proxmox backup server non parte\r\nfine configurazione mirror zfs su ssd da 4 tb',182.43,NULL,45,1,'Europe/Rome',182.43,1,'work','2023-02-03 09:18:20','2022-11-14'),
(3358,3,1,79,'2022-11-14 07:45:00','2022-11-14 07:55:00',600,'Recuperata password mail Paola Agnoletto e Paola Colladon',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-03 10:56:24','2022-11-14'),
(3359,3,1,22,'2022-11-14 09:15:00','2022-11-14 09:50:00',2100,'Risolto problema reinstallazione software IDECAD2022 su pc client Stefano',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-09 11:00:50','2022-11-14'),
(3360,3,1,1,'2022-11-14 09:50:00','2022-11-14 10:05:00',900,'Assistenza su pc client nella sede di Borzoli per problemi visualizzazione firma posta',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-01-27 12:57:51','2022-11-14'),
(3361,3,1,97,'2022-11-14 10:05:00','2022-11-14 10:15:00',600,'Verificato risoluzione problema posta inviata verso gmail che tornava indietro',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-10 16:18:07','2022-11-14'),
(3362,3,1,24,'2022-11-14 10:25:00','2022-11-14 10:35:00',600,'Assistenza su pc client Gommista per problema posta dopo agg certificato',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-12-01 10:49:09','2022-11-14'),
(3363,3,1,50,'2022-11-14 10:50:00','2022-11-14 11:00:00',600,'Spiegato a Filippo come creare ed utilizzare maillist su Thunderbird',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-03 09:18:23','2022-11-14'),
(3364,3,1,55,'2022-11-14 13:50:00','2022-11-14 14:00:00',600,'Installata 1 licenza nod32 aggiornamento su 2 pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-03 08:31:27','2022-11-14'),
(3365,3,1,12,'2022-11-14 14:05:00','2022-11-14 14:20:00',900,'Installata e configurata vpn sul portatile della moglie di Claudio',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-03 14:36:30','2022-11-14'),
(3366,3,1,75,'2022-11-14 14:50:00','2022-11-14 15:00:00',600,'Chiamata Fastweb per problemi riavvio router',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-08 10:42:17','2022-11-14'),
(3367,3,2,100,'2022-11-15 12:20:00','2022-11-15 12:50:00',1800,'Consegnato e installato switch 8 porte gigabit \r\nConsegnato e installato ups apc 650 al server',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-11-21 14:18:45','2022-11-15'),
(3368,3,2,26,'2022-11-15 13:00:00','2022-11-15 13:10:00',600,'Consegna toner compatibile per stampante Brother',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-12-15 10:08:18','2022-11-15'),
(3369,3,2,120,'2022-11-15 13:30:00','2022-11-15 14:45:00',4500,'Consegnato e configurato nuovo portatile Marisa',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-11-23 17:10:49','2022-11-15'),
(3370,1,1,22,'2022-11-15 14:58:00','2022-11-15 15:10:43',763,'problemi con mail pec',9.54,NULL,45,1,'Europe/Rome',9.54,1,'work','2023-03-09 11:00:54','2022-11-15'),
(3371,1,1,50,'2022-11-15 07:40:00','2022-11-15 09:50:00',7800,'spostamento vm su nuovi dischi zfs, e riconfigurazione backup',97.5,NULL,45,1,'Europe/Rome',97.5,1,'work','2023-02-03 09:18:23','2022-11-15'),
(3372,1,1,90,'2022-11-15 13:36:00','2022-11-15 14:45:00',4140,'nuovo server',51.75,NULL,45,1,'Europe/Rome',51.75,1,'work','2023-01-20 16:17:52','2022-11-15'),
(3373,3,1,1,'2022-11-15 09:50:00','2022-11-15 10:20:00',1800,'Assistenza per problemi navigazione causa Firewall spento',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-01-27 12:57:59','2022-11-15'),
(3374,1,3,112,'2022-11-16 11:00:00','2022-11-16 11:30:00',1800,NULL,22.5,NULL,45,1,'Europe/Rome',22.5,1,'work','2022-12-22 15:13:28','2022-11-16'),
(3375,1,1,50,'2022-11-16 07:39:00','2022-11-16 10:00:00',8460,'verifica stato backup dopo vari lavori, tentativo forzare movimento dischi vm ancora su disco singolo',105.75,NULL,45,1,'Europe/Rome',105.75,1,'work','2023-02-03 09:18:22','2022-11-16'),
(3376,3,1,50,'2022-11-16 08:00:00','2022-11-16 08:10:00',600,'Assistenza su pc client Giuseppe per problema su Thunderbird',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-03 09:19:00','2022-11-16'),
(3377,3,4,117,'2022-11-16 08:20:00','2022-11-16 11:20:00',10800,'Upgrade hw e sw su 2 pc client ritirati, utilizzati 2 ssd da 480gb S3+ e 1 banco di ram DDR4 sodim da 4gb.\r\nInstallata 1 licenza nod32 completa su 2 pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-01-31 11:04:06','2022-11-16'),
(3378,3,1,1,'2022-11-16 10:50:00','2022-11-16 11:00:00',600,'Verifica per problemi linea telefonica sede Borzoli',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-01-27 12:57:52','2022-11-16'),
(3379,3,2,24,'2022-11-16 13:05:00','2022-11-16 13:15:00',600,'Consegnata e installata tastiera e mouse usb',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-12-01 10:42:49','2022-11-16'),
(3380,3,1,50,'2022-11-16 14:15:00','2022-11-16 14:30:00',900,'Assistenza su pc client Federica per problemi lettura usb firma digitale, da verificare in loco',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-03 09:19:03','2022-11-16'),
(3381,3,1,67,'2022-11-16 14:30:00','2022-11-16 15:00:00',1800,'Installato e configurato Office365 su pc client Alessandro Gualco',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-12-20 16:11:29','2022-11-16'),
(3382,3,1,120,'2022-11-16 15:20:00','2022-11-16 15:40:00',1200,'Assistenza su nuovo portatile Marisa per problemi collegamento pc ufficio e gestionale',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-11-23 17:10:50','2022-11-16'),
(3383,3,1,50,'2022-11-16 16:10:00','2022-11-16 16:50:00',2400,'Assistenza su pc client Giuseppe per problemi visualizzazione posta su Thunderbird',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-03 09:19:11','2022-11-16'),
(3384,3,2,96,'2022-11-17 12:15:00','2022-11-17 12:40:00',1500,'Assistenza su PC client Federica per problemi con usb firma digitale, utilizzato Hub usb 438753\r\nAssistenza su telefono voip',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-17 09:57:40','2022-11-17'),
(3385,3,2,75,'2022-11-17 13:10:00','2022-11-17 13:30:00',1200,'Verificato problema linea dati Fastweb, collegato router a ups',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-08 10:42:23','2022-11-17'),
(3386,1,1,50,'2022-11-17 13:42:00','2022-11-17 14:40:00',3480,'configurazione mail alberto',43.5,NULL,45,1,'Europe/Rome',43.5,1,'work','2023-02-03 09:19:19','2022-11-17'),
(3387,1,1,103,'2022-11-16 13:51:00','2022-11-16 16:16:00',8700,'aggiornamenti server',108.75,NULL,45,1,'Europe/Rome',108.75,1,'work','2022-12-12 16:43:37','2022-11-16'),
(3388,1,1,2,'2022-11-16 16:21:00','2022-11-16 17:45:00',5040,'agg server',63,NULL,45,1,'Europe/Rome',63,1,'work','2023-02-07 14:45:53','2022-11-16'),
(3389,1,1,50,'2022-11-17 07:53:00','2022-11-17 09:45:00',6720,'varie dopo migrazione su dischi',84,NULL,45,1,'Europe/Rome',84,1,'work','2023-02-03 09:19:11','2022-11-17'),
(3390,3,2,103,'2022-11-17 15:55:00','2022-11-17 16:15:00',1200,'Assistenza in loco per problemi server nuovo in corto',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-01-23 16:56:07','2022-11-17'),
(3391,3,1,4,'2022-11-17 09:00:00','2022-11-17 09:25:00',1500,'Assistenza per configurazione Port mapping su Vodafone Station',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-06 07:57:26','2022-11-17'),
(3392,1,1,3,'2022-11-17 15:00:00','2022-11-17 17:30:00',9000,'con tuo fratello per limiti proxmox backup',112.5,NULL,45,1,'Europe/Rome',112.5,1,'work','2023-01-27 13:04:15','2022-11-17'),
(3393,1,1,55,'2022-11-18 09:16:00','2022-11-18 10:36:00',4800,'segnalato arrivo anomalo di spam',60,NULL,45,1,'Europe/Rome',60,1,'work','2023-02-03 08:31:28','2022-11-18'),
(3394,1,1,103,'2022-11-18 10:40:00','2022-11-18 13:45:00',11100,'fede li che lavora sui telefoni, \r\nio su problemi mago dopo riavvio server',138.75,NULL,45,1,'Europe/Rome',138.75,1,'work','2023-02-28 08:29:40','2022-11-18'),
(3395,3,2,103,'2022-11-18 09:15:00','2022-11-18 12:55:00',13200,'Assistenza per problemi su alimentatore server debian, sostituzione con cm 500w \r\nAssistenza per configurazione telefoni dopo passaggio linea, assistenza per problemi avvio Mago dopo riavvio server (da finire)',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-28 08:29:47','2022-11-18'),
(3396,3,2,41,'2022-11-18 13:10:00','2022-11-18 13:30:00',1200,'Sostituzione batteria su ups apc\r\nRitirato ups apc da verificare',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-12-08 11:16:32','2022-11-18'),
(3397,1,1,90,'2022-11-18 14:01:00','2022-11-18 16:22:00',8460,'problemi con samba per backup e ssl',105.75,NULL,45,1,'Europe/Rome',105.75,1,'work','2023-01-23 10:14:58','2022-11-18'),
(3398,1,1,50,'2022-11-18 07:45:00','2022-11-18 08:38:00',3180,'preparazione per lavori che fede effettuerà in serata',39.75,NULL,45,1,'Europe/Rome',39.75,1,'work','2023-02-03 09:19:20','2022-11-18'),
(3399,1,1,50,'2022-11-18 16:40:00','2022-11-18 17:30:00',3000,'fede li problemi dopo pulizia',37.5,NULL,45,1,'Europe/Rome',37.5,1,'work','2023-02-03 09:19:21','2022-11-18'),
(3400,1,2,50,'2022-11-18 17:50:00','2022-11-18 22:00:00',15000,'dopo pulizia server problema sui dischi e sulle schede di rete',187.5,NULL,45,1,'Europe/Rome',187.5,1,'work','2023-02-03 09:19:46','2022-11-18'),
(3401,1,4,75,'2022-11-17 09:58:00','2022-11-17 11:30:00',5520,'agg nas',69,NULL,45,1,'Europe/Rome',69,1,'work','2023-02-08 10:42:21','2022-11-17'),
(3402,1,1,79,'2022-11-21 07:51:00','2022-11-21 09:01:44',4244,'problema sito record mancante',53.05,NULL,45,1,'Europe/Rome',53.05,1,'work','2023-02-03 10:56:36','2022-11-21'),
(3403,1,1,90,'2022-11-21 09:05:00','2022-11-21 09:40:00',2100,'pc flavio disco pieno',26.25,NULL,45,1,'Europe/Rome',26.25,1,'work','2023-01-23 10:14:58','2022-11-21'),
(3404,1,1,103,'2022-11-21 09:42:00','2022-11-21 11:25:00',6180,'problemi mago',77.25,NULL,45,1,'Europe/Rome',77.25,1,'work','2023-02-28 08:29:42','2022-11-21'),
(3405,1,1,103,'2022-11-21 13:41:00','2022-11-21 16:30:00',10140,'problemi mago, individuato problema nella gestione dell\'ora per questo connessione smb non funziona, cercata soluzione ma problema hyperivsor',126.75,NULL,45,1,'Europe/Rome',126.75,1,'work','2023-02-28 08:29:44','2022-11-21'),
(3406,1,6,51,'2022-11-21 16:50:00','2022-11-21 17:22:00',1920,'problemi spazio su disco pc Palermo',24,NULL,45,1,'Europe/Rome',24,1,'work','2023-02-07 10:33:30','2022-11-21'),
(3407,1,4,51,'2022-11-22 07:50:00','2022-11-22 08:10:00',1200,'problemi pc palermo disco pieno',15,NULL,45,1,'Europe/Rome',15,1,'work','2023-02-07 10:33:28','2022-11-22'),
(3408,1,1,108,'2022-11-22 10:22:00','2022-11-22 10:41:12',1152,'problemi varie pc biglietteria',14.4,NULL,45,1,'Europe/Rome',14.4,1,'work','2023-03-17 09:52:07','2022-11-22'),
(3409,1,1,79,'2022-11-22 09:56:00','2022-11-22 10:03:00',420,'modifica firma mail',5.25,NULL,45,1,'Europe/Rome',5.25,1,'work','2023-02-03 10:56:24','2022-11-22'),
(3410,1,1,1,'2022-11-22 14:40:00','2022-11-22 14:50:00',600,'configurazione mail borzoli',7.5,NULL,45,1,'Europe/Rome',7.5,1,'work','2023-01-27 12:57:49','2022-11-22'),
(3411,1,1,50,'2022-11-22 16:00:00','2022-11-22 17:20:00',4800,'configurazione mail chiergato stefano',60,NULL,45,1,'Europe/Rome',60,1,'work','2023-02-03 09:19:20','2022-11-22'),
(3412,1,4,3,'2022-11-22 08:20:00','2022-11-22 09:54:00',5640,'assemblaggio nuovo pc mb \r\nsaldato batteria tampone pc portatile in riparazione\r\npc fisso di boccaleri segnala random blocco all\'avvio',70.5,NULL,45,1,'Europe/Rome',70.5,1,'work','2023-01-27 13:04:20','2022-11-22'),
(3413,1,4,3,'2022-11-22 10:50:00','2022-11-22 11:30:00',2400,'assemblaggio nuovo pc mb \r\nsaldato batteria tampone pc portatile in riparazione\r\npc fisso di boccaleri segnala random blocco all\'avvio',30,NULL,45,1,'Europe/Rome',30,1,'work','2023-01-27 13:04:06','2022-11-22'),
(3414,1,1,55,'2022-11-22 13:40:00','2022-11-22 14:33:00',3180,'agg server',39.75,NULL,45,1,'Europe/Rome',39.75,1,'work','2023-02-03 08:31:29','2022-11-22'),
(3415,1,1,55,'2022-11-22 15:07:00','2022-11-22 15:53:00',2760,'agg server',34.5,NULL,45,1,'Europe/Rome',34.5,1,'work','2023-02-03 08:31:30','2022-11-22'),
(3416,1,3,112,'2022-11-23 14:28:00','2022-11-23 15:42:39',4479,NULL,55.99,NULL,45,1,'Europe/Rome',55.99,1,'work','2022-12-22 15:13:29','2022-11-23'),
(3417,1,1,58,'2022-11-23 13:47:00','2022-11-23 14:25:00',2280,'aggiornamento 3cx',28.5,NULL,45,1,'Europe/Rome',28.5,1,'work','2023-05-26 07:55:21','2022-11-23'),
(3418,1,1,3,'2022-11-23 07:30:00','2022-11-23 11:30:00',14400,'rimontaggio pc  papà ........\r\npc portatile dove è stata sostituita la batteria verifiche di funzionamento\r\nsistemazione vecchio pc mb con nuova cpu mainboard e ram\r\npc portatile sostitutito hd con ssd',180,NULL,45,1,'Europe/Rome',180,1,'work','2023-01-27 13:04:22','2022-11-23'),
(3419,1,1,58,'2022-11-23 15:52:00','2022-11-23 17:23:00',5460,'agg 3cx',68.25,NULL,45,1,'Europe/Rome',68.25,1,'work','2023-05-26 07:55:22','2022-11-23'),
(3420,1,1,103,'2022-11-24 08:15:00','2022-11-24 10:19:00',7440,'problemi vari martina\r\ntiziana problemi connessione suo pc via vpn',93,NULL,45,1,'Europe/Rome',93,1,'work','2023-02-28 08:29:45','2022-11-24'),
(3421,3,2,79,'2022-11-24 08:10:00','2022-11-24 09:10:00',3600,'Assistenza su PC client Andrea per problemi di rete\r\nAssistenza su PC Andrea e Matteo per modifica firma\r\nAssistenza su telefono Paola agnoletto e colladon per problemi posta, assistenza su PC client Paolo per visualizzare XML. Ordinare ssd da 1 tb per PC client Andrea',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-03 10:56:34','2022-11-24'),
(3422,1,3,112,'2022-11-24 10:26:00','2022-11-24 11:30:00',3840,NULL,48,NULL,45,1,'Europe/Rome',48,1,'work','2022-12-22 15:13:30','2022-11-24'),
(3423,1,1,58,'2022-11-24 07:43:00','2022-11-24 08:05:00',1320,'verifiche dopo agg 3cx',16.5,NULL,45,1,'Europe/Rome',16.5,1,'work','2023-05-26 07:55:23','2022-11-24'),
(3424,1,1,87,'2022-11-24 13:02:00','2022-11-24 15:15:30',8010,'problema gmail su bbmail',100.13,NULL,45,1,'Europe/Rome',100.13,1,'work','2023-01-17 10:01:15','2022-11-24'),
(3425,3,2,117,'2022-11-24 13:55:00','2022-11-24 14:35:00',2400,'Riconsegnati 2 pc client dopo aggiornamenti hw e sw\r\nInstallati 4 switch 5 porte gigabit \r\nRitirati 2 pc client per aggiornamenti hw e sw',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-01-31 11:04:00','2022-11-24'),
(3426,3,2,6,'2022-11-24 14:35:00','2022-11-24 14:55:00',1200,'Assistenza su PC client per problemi scansione di rete',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-07 10:56:35','2022-11-24'),
(3427,1,1,5,'2022-11-24 15:36:00','2022-11-24 15:56:02',1202,'problema stampa dwg pc miriam',15.03,NULL,45,1,'Europe/Rome',15.03,1,'work','2023-01-17 17:22:25','2022-11-24'),
(3428,3,2,96,'2022-11-24 15:15:00','2022-11-24 15:35:00',1200,'Assistenza per problemi su wifi',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-06 09:28:56','2022-11-24'),
(3429,3,4,2,'2022-11-24 15:55:00','2022-11-24 16:05:00',600,'Consegna ventole per Stefano Botta',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-07 14:45:47','2022-11-24'),
(3430,1,1,5,'2022-11-24 16:06:00','2022-11-24 16:22:16',976,'aggiornamento server',12.2,NULL,45,1,'Europe/Rome',12.2,1,'work','2023-01-17 17:02:04','2022-11-24'),
(3431,1,1,79,'2022-11-24 16:23:00','2022-11-24 17:27:00',3840,'problema spf mail',48,NULL,45,1,'Europe/Rome',48,1,'work','2023-02-03 10:56:30','2022-11-24'),
(3432,1,1,51,'2022-11-25 08:09:00','2022-11-25 09:47:49',5929,'problemi spazio disco mac Palermo',74.11,NULL,45,1,'Europe/Rome',74.11,1,'work','2023-02-07 10:33:28','2022-11-25'),
(3433,1,1,75,'2022-11-25 10:00:00','2022-11-25 11:30:00',5400,'problemi invio posta dal loro server e da tau',67.5,NULL,45,1,'Europe/Rome',67.5,1,'work','2023-02-03 10:59:32','2022-11-25'),
(3434,3,2,45,'2022-11-25 12:00:00','2022-11-25 12:20:00',1200,'Assistenza su PC client per problemi avvio',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-16 17:12:49','2022-11-25'),
(3435,3,2,96,'2022-11-25 12:40:00','2022-11-25 13:15:00',2100,'Assistenza su PC client Federica per problemi riavvio servizi tomcat',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-06 09:28:49','2022-11-25'),
(3436,1,1,75,'2022-11-25 13:10:00','2022-11-25 14:00:00',3000,'problemi invio posta dal loro server e da tau\r\nconfigurazione spf e check',37.5,NULL,45,1,'Europe/Rome',37.5,1,'work','2023-02-03 10:59:28','2022-11-25'),
(3437,1,1,29,'2022-11-25 14:45:00','2022-11-25 15:44:00',3540,'problema stampante',44.25,NULL,45,1,'Europe/Rome',44.25,1,'work','2023-01-16 15:05:41','2022-11-25'),
(3438,1,1,29,'2022-11-25 16:00:00','2022-11-25 16:52:03',3123,'aggiornamenti server',39.04,NULL,45,1,'Europe/Rome',39.04,1,'work','2023-01-16 10:44:48','2022-11-25'),
(3439,3,1,22,'2022-11-25 08:50:00','2022-11-25 09:10:00',1200,'Assistenza su pc client padre per problemi ricezione notifiche mail PEC',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-09 11:00:51','2022-11-25'),
(3440,3,1,79,'2022-11-25 09:20:00','2022-11-25 09:30:00',600,'Assistenza su pc client Paola Agnoletto',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-03 10:56:32','2022-11-25'),
(3441,3,1,75,'2022-11-25 09:35:00','2022-11-25 10:35:00',3600,'Assistenza per problemi invio posta elettronica',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-08 10:42:21','2022-11-25'),
(3442,3,1,85,'2022-11-25 14:00:00','2022-11-25 14:20:00',1200,'Aumentato spazio casella posta giacomo@rellecati.com da 2048 a 3072',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-30 10:25:49','2022-11-25'),
(3443,3,1,100,'2022-11-25 14:25:00','2022-11-25 14:40:00',900,'Comunicati dati per accedere in FTP e modificare sito web',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-06 08:28:07','2022-11-25'),
(3444,3,2,96,'2022-11-28 08:35:00','2022-11-28 09:10:00',2100,'Assistenza per problemi navigazione, il problema riguarda fastweb, fatta aprire richiesta di assistenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-06 09:28:50','2022-11-28'),
(3445,3,2,79,'2022-11-28 10:00:00','2022-11-28 11:30:00',5400,'Sostituzione ssd 480gb con ssd 960gb S3+ su PC client Andrea + clonazione s.o \r\nAssistenza su PC client Michele per problemi posta \r\nAssistenza su tutti PC client per visualizzazione nuovo sito',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-03 10:56:20','2022-11-28'),
(3446,1,3,112,'2022-11-28 10:30:00','2022-11-28 11:30:00',3600,NULL,45,NULL,45,1,'Europe/Rome',45,1,'work','2022-12-22 15:13:22','2022-11-28'),
(3447,1,1,3,'2022-11-25 14:10:00','2022-11-25 14:40:00',1800,'problemi invio posta generali bbmail',22.5,NULL,45,1,'Europe/Rome',22.5,1,'work','2023-01-27 13:04:01','2022-11-25'),
(3448,1,1,3,'2022-11-25 17:01:00','2022-11-25 17:27:00',1560,'problemi invio posta generali bbmail',19.5,NULL,45,1,'Europe/Rome',19.5,1,'work','2023-01-27 13:04:00','2022-11-25'),
(3449,1,1,55,'2022-11-28 07:46:00','2022-11-28 09:41:00',6900,'agg server',86.25,NULL,45,1,'Europe/Rome',86.25,1,'work','2023-02-03 08:31:31','2022-11-28'),
(3450,1,1,1,'2022-11-28 09:42:00','2022-11-28 10:20:00',2280,'verifiche server per lamentele lentezza gestionale',28.5,NULL,45,1,'Europe/Rome',28.5,1,'work','2023-01-27 12:57:56','2022-11-28'),
(3451,1,1,1,'2022-11-28 12:30:00','2022-11-28 14:42:00',7920,'problemi lentezza server e aggiornamenti\r\nfede li per problemi provisioning smartphone su 3cx',99,NULL,45,1,'Europe/Rome',99,1,'work','2023-01-27 12:57:59','2022-11-28'),
(3452,1,3,112,'2022-11-28 14:42:52','2022-11-28 15:44:55',3723,NULL,46.54,NULL,45,1,'Europe/Rome',46.54,1,'work','2022-12-22 15:13:26','2022-11-28'),
(3453,3,2,1,'2022-11-28 14:15:00','2022-11-28 14:45:00',1800,'Assistenza su nuovo cellulare per configurazione app 3cx',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-01-27 12:57:54','2022-11-28'),
(3454,3,2,12,'2022-11-28 15:10:00','2022-11-28 15:40:00',1800,'Configurata vpn e collegamenti al server su nuovo portatile Claudio',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-03 14:36:48','2022-11-28'),
(3455,1,1,90,'2022-11-28 17:06:00','2022-11-28 18:10:00',3840,'server new',48,NULL,45,1,'Europe/Rome',48,1,'work','2023-01-20 16:17:54','2022-11-28'),
(3456,1,1,1,'2022-11-28 15:49:00','2022-11-28 17:00:00',4260,'problemi spazio su disco c insufficente su server pulizia',53.25,NULL,45,1,'Europe/Rome',53.25,1,'work','2023-01-27 12:57:58','2022-11-28'),
(3457,1,1,103,'2022-11-29 11:08:00','2022-11-29 11:28:46',1246,'fede li per problemi 3cx e per cambio alim\r\nseguito nei problemi 3cx',15.58,NULL,45,1,'Europe/Rome',15.58,1,'work','2023-01-23 16:56:54','2022-11-29'),
(3458,1,1,5,'2022-11-29 07:45:00','2022-11-29 08:27:00',2520,'agg nas e backup',31.5,NULL,45,1,'Europe/Rome',31.5,1,'work','2023-01-17 17:02:07','2022-11-29'),
(3459,1,1,17,'2022-11-29 08:43:00','2022-11-29 09:30:00',2820,'agg nas e backup',35.25,NULL,45,1,'Europe/Rome',35.25,1,'work','2023-03-06 19:02:52','2022-11-29'),
(3460,1,1,2,'2022-11-29 09:40:00','2022-11-29 10:54:00',4440,'agg app nas e hyper data protect per backup vm',55.5,NULL,45,1,'Europe/Rome',55.5,1,'work','2023-02-07 14:45:47','2022-11-29'),
(3461,1,1,35,'2022-11-29 11:30:00','2022-11-29 12:25:33',3333,'agg nas backup',41.66,NULL,45,1,'Europe/Rome',41.66,1,'work','2023-03-10 16:51:23','2022-11-29'),
(3462,1,1,29,'2022-11-29 13:45:00','2022-11-29 15:26:00',6060,'agg server e vm',75.75,NULL,45,1,'Europe/Rome',75.75,1,'work','2023-01-16 15:05:42','2022-11-29'),
(3463,1,1,32,'2022-11-29 15:39:00','2022-11-29 16:00:00',1260,'agg server',15.75,NULL,45,1,'Europe/Rome',15.75,1,'work','2023-01-23 16:45:21','2022-11-29'),
(3464,1,1,24,'2022-11-29 16:06:00','2022-11-29 16:30:01',1441,'agg vm centralino',18.01,NULL,45,1,'Europe/Rome',18.01,1,'work','2022-12-01 09:17:19','2022-11-29'),
(3465,3,1,26,'2022-11-29 08:30:00','2022-11-29 08:45:00',900,'Assistenza su pc client Simona per problemi con  software firma digitale',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-22 10:36:50','2022-11-29'),
(3466,3,1,97,'2022-11-29 09:30:00','2022-11-29 09:45:00',900,'Assistenza su pc client per problemi invio posta',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-10 16:18:09','2022-11-29'),
(3467,3,2,103,'2022-11-29 10:30:00','2022-11-29 11:30:00',3600,'Installato nuovo alimentatore 1000 su server debian, risolto problema app 3cx su cellulare Martina',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-28 08:29:33','2022-11-29'),
(3468,1,1,3,'2022-11-30 07:41:00','2022-11-30 08:34:44',3224,'verifica ultimi centralini, avvisati lanzi che prova ad aggiornarselo da solo\r\navvisato piazza che è senza internet se non ripristinano nel pomeriggio bisogna andare e collegare telefono + sim per farli navigare',40.3,NULL,45,1,'Europe/Rome',40.3,1,'work','2023-01-27 13:04:22','2022-11-30'),
(3469,1,1,110,'2022-11-30 09:02:00','2022-11-30 11:28:00',8760,'problema mail',109.5,NULL,45,1,'Europe/Rome',109.5,1,'work','2023-02-03 09:05:21','2022-11-30'),
(3470,3,4,117,'2022-11-30 07:50:00','2022-11-30 10:50:00',10800,'Assistenza e reinstallazione win 11 su 2 pc client ritirati, utilizzato 2 ssd 480gb S3+, 4gb DDR3 RAM usata e 1 licenza nod32 completa',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-01-31 11:04:00','2022-11-30'),
(3471,3,1,29,'2022-11-30 10:20:00','2022-11-30 10:40:00',1200,'Installate 3 licenze nod32 aggiornamento su 5 pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-01-16 15:05:43','2022-11-30'),
(3472,3,1,79,'2022-11-30 14:15:00','2022-11-30 14:55:00',2400,'Assistenza per problemi invio mail da nuovo sito, chi ha fatto il sito deve provare a cambiare form contatti',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-03 10:56:40','2022-11-30'),
(3473,1,2,88,'2022-11-30 15:52:00','2022-11-30 17:45:00',6780,'connessione del server attraverso smartphone per mancanza di linea fissa',84.75,NULL,45,1,'Europe/Rome',84.75,1,'work','2023-04-06 09:19:17','2022-11-30'),
(3474,1,1,90,'2022-11-30 13:45:00','2022-11-30 15:34:00',6540,'preparazione per migrazione server mail',81.75,NULL,45,1,'Europe/Rome',81.75,1,'work','2023-01-20 16:18:00','2022-11-30'),
(3475,1,1,90,'2022-11-30 20:37:00','2022-11-30 21:50:00',4380,'migrazione server di posta stegeo sul nuovo server, configurazione client',54.75,NULL,45,1,'Europe/Rome',54.75,1,'work','2023-01-23 09:03:54','2022-11-30'),
(3476,1,1,60,'2022-12-01 10:03:00','2022-12-01 10:13:00',600,'agg centralino',7.5,NULL,45,0,'Europe/Rome',7.5,1,'work','2022-12-01 11:11:39','2022-12-01'),
(3477,3,2,103,'2022-12-01 10:10:00','2022-12-01 10:35:00',1500,'Risolto problema scansione stampante HP\r\nAssistenza per problemi su telefoni voip, ci lavora cla da remoto',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-08 16:35:36','2022-12-01'),
(3478,1,1,103,'2022-12-01 10:14:00','2022-12-01 11:10:00',3360,'problemi di chiamate verso i numeri fissi',42,NULL,45,1,'Europe/Rome',42,1,'work','2023-03-02 09:59:54','2022-12-01'),
(3479,1,1,60,'2022-12-01 11:12:00','2022-12-01 11:26:00',840,'agg centralino',10.5,NULL,45,0,'Europe/Rome',10.5,1,'work','2022-12-01 13:47:53','2022-12-01'),
(3480,1,1,114,'2022-12-01 15:17:00','2022-12-01 15:33:06',966,'salvataggio mail su mac per cambio dominio',12.08,NULL,45,1,'Europe/Rome',12.08,1,'work','2023-02-09 16:58:30','2022-12-01'),
(3481,1,1,90,'2022-12-01 07:39:00','2022-12-01 08:22:00',2580,'verifica dopo migrazione posta',32.25,NULL,45,1,'Europe/Rome',32.25,1,'work','2023-01-23 09:03:57','2022-12-01'),
(3482,1,1,2,'2022-12-01 08:39:00','2022-12-01 09:48:00',4140,'prove di boot vm win 2008',51.75,NULL,45,1,'Europe/Rome',51.75,1,'work','2023-02-07 14:45:58','2022-12-01'),
(3483,1,1,29,'2022-12-01 13:44:00','2022-12-01 14:22:00',2280,'prep agg host proxmox da fare in serata',28.5,NULL,45,1,'Europe/Rome',28.5,1,'work','2023-01-16 10:42:42','2022-12-01'),
(3484,1,1,79,'2022-12-01 14:32:00','2022-12-01 15:13:00',2460,'prep agg proxmox da fare in serata',30.75,NULL,45,1,'Europe/Rome',30.75,1,'work','2023-02-03 10:56:25','2022-12-01'),
(3485,3,1,103,'2022-12-01 08:15:00','2022-12-01 08:35:00',1200,'Assistenza su pc client Collaudo1 per problemi con la scansione, da verificare in loco',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-08 16:35:39','2022-12-01'),
(3486,3,1,50,'2022-12-01 09:25:00','2022-12-01 09:35:00',600,'Configurata stampante su portatile figlio Francesco',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-03 09:19:12','2022-12-01'),
(3487,1,3,112,'2022-12-02 09:00:00','2022-12-02 09:33:00',1980,NULL,24.75,NULL,45,1,'Europe/Rome',24.75,1,'work','2023-03-08 17:14:42','2022-12-02'),
(3488,1,2,88,'2022-12-02 08:05:00','2022-12-02 08:20:00',900,'riconfigurazione server per connessione fastweb',11.25,NULL,45,1,'Europe/Rome',11.25,1,'work','2023-04-06 09:23:05','2022-12-02'),
(3489,1,1,88,'2022-12-02 09:35:00','2022-12-02 09:54:00',1140,'sistemazione posta',14.25,NULL,45,1,'Europe/Rome',14.25,1,'work','2023-04-06 09:19:20','2022-12-02'),
(3490,1,1,29,'2022-12-01 19:30:00','2022-12-01 20:00:00',1800,'agg proxmox',22.5,NULL,45,1,'Europe/Rome',22.5,1,'work','2023-01-16 10:42:44','2022-12-01'),
(3492,3,1,79,'2022-12-02 09:10:00','2022-12-02 09:20:00',600,'Assistenza su pc client Andrea per modifica firma posta',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-03 10:56:29','2022-12-02'),
(3493,3,1,67,'2022-12-02 09:20:00','2022-12-02 09:40:00',1200,'Installato e configurato Office 365 su pc client Simone De Paoli',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-12-20 16:11:32','2022-12-02'),
(3494,1,1,3,'2022-11-10 13:00:00','2022-11-10 15:30:00',9000,'proxmox backup\r\nsu first e test con alex',112.5,NULL,45,1,'Europe/Rome',112.5,1,'work','2023-01-27 13:04:02','2022-11-10'),
(3495,1,1,3,'2022-12-05 07:46:00','2022-12-05 08:20:00',2040,'fogli',25.5,NULL,45,1,'Europe/Rome',25.5,1,'work','2023-01-27 13:04:07','2022-12-05'),
(3496,1,1,103,'2022-12-05 08:36:00','2022-12-05 11:28:00',10320,'problema spam',129,NULL,45,1,'Europe/Rome',129,1,'work','2023-03-08 16:35:32','2022-12-05'),
(3497,1,1,3,'2022-12-01 15:45:00','2022-12-01 17:30:00',6300,'agg proxmox test su vm',78.75,NULL,45,1,'Europe/Rome',78.75,1,'work','2023-01-27 13:04:00','2022-12-01'),
(3498,1,1,3,'2022-12-02 10:01:00','2022-12-02 11:23:00',4920,'verifica domini per invio mail in caso di problemi, da modificare tutti abilitare spf e configurare correttamente',61.5,NULL,45,1,'Europe/Rome',61.5,1,'work','2023-01-27 13:03:58','2022-12-02'),
(3499,1,1,3,'2022-12-02 13:41:00','2022-12-02 15:48:00',7620,'lista clienti posta da ottimizzare',95.25,NULL,45,1,'Europe/Rome',95.25,1,'work','2023-01-27 13:03:58','2022-12-02'),
(3500,3,2,41,'2022-12-05 08:50:00','2022-12-05 09:00:00',600,'Ritirato UPS APC 1400 nella sede di Ceranesi per assistenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-12-08 11:16:33','2022-12-05'),
(3501,3,1,90,'2022-12-05 13:40:00','2022-12-05 14:10:00',1800,'Assistenza per problemi posta e lentezza server, da verificare in loco problema plotter',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-01-23 10:15:05','2022-12-05'),
(3502,3,1,75,'2022-12-05 14:30:00','2022-12-05 14:40:00',600,'Assistenza su pc client Bagnasco per problemi visualizzazione posta',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-08 10:42:20','2022-12-05'),
(3503,3,1,12,'2022-12-05 16:30:00','2022-12-05 16:40:00',600,'Assistenza per problemi a disinstallare IDECAD22 su portatile Vella',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-03 14:36:44','2022-12-05'),
(3504,1,1,29,'2022-12-06 08:40:00','2022-12-06 08:44:09',249,'problema stampante',3.11,NULL,45,1,'Europe/Rome',3.11,1,'work','2023-01-16 10:34:13','2022-12-06'),
(3505,3,2,117,'2022-12-06 09:05:00','2022-12-06 09:55:00',3000,'Riconsegnati e configurati 2 pc client dopo aggiornamenti hw e sw, ritirati 3 pc client per aggiornamenti hw e sw',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-01-31 11:04:04','2022-12-06'),
(3506,3,2,90,'2022-12-06 10:05:00','2022-12-06 11:15:00',4200,'Assistenza per problemi plotter hp offline, da verificare stampa quando sostituiscono cartuccia',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-01-23 10:15:04','2022-12-06'),
(3507,1,1,29,'2022-12-06 07:40:00','2022-12-06 08:30:00',3000,'riconfigurazione array zfs e configurazione disco spare',37.5,NULL,45,1,'Europe/Rome',37.5,1,'work','2023-01-16 10:42:50','2022-12-06'),
(3508,1,3,112,'2022-12-06 13:30:00','2022-12-06 14:10:00',2400,NULL,30,NULL,45,1,'Europe/Rome',30,1,'work','2023-03-08 17:14:50','2022-12-06'),
(3509,1,2,108,'2022-12-07 08:40:00','2022-12-07 10:40:00',7200,'per preventivo wifi',90,NULL,45,1,'Europe/Rome',90,1,'work','2023-03-09 16:51:37','2022-12-07'),
(3510,1,1,2,'2022-12-09 09:00:00','2022-12-09 11:30:00',9000,'problema lentezza pc laura',112.5,NULL,45,1,'Europe/Rome',112.5,1,'work','2023-04-06 08:43:42','2022-12-09'),
(3511,3,1,67,'2022-12-09 09:15:00','2022-12-09 09:45:00',1800,'Installato e configurato Office365 su pc client Nicolò Corrado',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-12-20 16:11:31','2022-12-09'),
(3512,3,1,67,'2022-12-09 10:10:00','2022-12-09 10:55:00',2700,'Installato e configurato Office365 su pc client Federico Locirio',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-12-20 16:11:50','2022-12-09'),
(3513,3,1,67,'2022-12-09 13:40:00','2022-12-09 14:10:00',1800,'Installato e configurato Office365 su pc client Andrea Barbieri',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-12-20 16:11:37','2022-12-09'),
(3514,3,1,96,'2022-12-09 11:15:00','2022-12-09 11:30:00',900,'Assistenza su pc casa Cristina Musso',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-06 09:28:50','2022-12-09'),
(3515,3,1,83,'2022-12-09 16:10:00','2022-12-09 16:25:00',900,'Verificato problema lentezza su pc client Orietta, da verificare',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-09 10:47:22','2022-12-09'),
(3516,1,1,2,'2022-12-09 13:47:00','2022-12-09 16:41:00',10440,'sistemazione backup server problemi di lentezza segnalati',130.5,NULL,45,1,'Europe/Rome',130.5,1,'work','2023-04-06 08:43:05','2022-12-09'),
(3517,1,1,3,'2022-12-09 16:52:00','2022-12-09 17:14:00',1320,'visto nas con fede',16.5,NULL,45,1,'Europe/Rome',16.5,1,'work','2023-01-27 13:04:14','2022-12-09'),
(3518,1,1,1,'2022-12-12 14:19:00','2022-12-12 16:14:00',6900,'problema telefono roberta',86.25,NULL,45,1,'Europe/Rome',86.25,1,'work','2023-01-27 12:57:57','2022-12-12'),
(3519,3,2,76,'2022-12-12 14:20:00','2022-12-12 15:00:00',2400,'Verificato e ritirato portatile Dell per assistenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-12-20 15:37:03','2022-12-12'),
(3520,1,1,108,'2022-12-12 16:37:00','2022-12-12 16:39:39',159,'problemi agg chrome su pc biglietteria',1.99,NULL,45,1,'Europe/Rome',1.99,1,'work','2023-03-17 09:52:06','2022-12-12'),
(3521,3,1,104,'2022-12-12 08:10:00','2022-12-12 08:20:00',600,'Riavvio certificato posta per problemi ricezione/invio posta',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-01-13 08:35:52','2022-12-12'),
(3522,3,1,100,'2022-12-12 08:55:00','2022-12-12 09:25:00',1800,'Installata e configurata vpn su nuovo Mac casa Veronica',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-06 08:28:10','2022-12-12'),
(3523,3,4,117,'2022-12-12 09:30:00','2022-12-12 12:30:00',10800,'Upgrade hardware e software su 2 pc client ritirati, utilizzato: 2 ssd 480gb S3+ e 1 licenza nod32 antivirus completa',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-01-31 11:04:07','2022-12-12'),
(3524,3,4,117,'2022-12-12 16:00:00','2022-12-12 17:30:00',5400,'Upgrade hardware e software su 1 pc client ritirato, utilizzato: 1 ssd 480gb S3+ , 1 ram da 4gb DDR4 SODIM e 1 licenza nod32 antivirus completa',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-01-31 11:04:04','2022-12-12'),
(3525,1,1,3,'2022-12-02 16:04:00','2022-12-02 17:25:00',4860,'agg proxmox',60.75,NULL,45,1,'Europe/Rome',60.75,1,'work','2023-01-27 13:03:59','2022-12-02'),
(3526,1,1,90,'2022-12-05 13:42:00','2022-12-05 15:36:00',6840,'server nuovo',85.5,NULL,45,1,'Europe/Rome',85.5,1,'work','2023-01-20 16:18:15','2022-12-05'),
(3527,1,1,103,'2022-12-05 16:01:00','2022-12-05 17:00:00',3540,'spam',44.25,NULL,45,1,'Europe/Rome',44.25,1,'work','2023-03-08 16:35:33','2022-12-05'),
(3528,1,1,51,'2022-12-05 17:08:00','2022-12-05 17:26:00',1080,'verifica agg server',13.5,NULL,45,1,'Europe/Rome',13.5,1,'work','2023-02-07 10:33:30','2022-12-05'),
(3529,1,1,108,'2022-12-07 11:00:00','2022-12-07 11:29:00',1740,'verifica access point da offrire',21.75,NULL,45,1,'Europe/Rome',21.75,1,'work','2023-03-09 16:51:41','2022-12-07'),
(3530,1,1,108,'2022-12-07 13:46:00','2022-12-07 14:42:00',3360,'verifica access point da offrire',42,NULL,45,1,'Europe/Rome',42,1,'work','2023-03-09 16:51:44','2022-12-07'),
(3531,1,1,90,'2022-12-07 15:01:00','2022-12-07 17:27:00',8760,'server nuovo',109.5,NULL,45,1,'Europe/Rome',109.5,1,'work','2023-01-20 16:18:18','2022-12-07'),
(3532,1,1,50,'2022-12-09 07:47:00','2022-12-09 08:46:00',3540,'agg cent e proxmox',44.25,NULL,45,1,'Europe/Rome',44.25,1,'work','2023-02-03 09:19:13','2022-12-09'),
(3533,1,1,50,'2022-12-12 07:48:00','2022-12-12 09:14:00',5160,'agg proxmox e 3cx',64.5,NULL,45,1,'Europe/Rome',64.5,1,'work','2023-02-03 09:19:13','2022-12-12'),
(3534,1,1,90,'2022-12-12 09:31:00','2022-12-12 11:26:00',6900,'server nuovo',86.25,NULL,45,1,'Europe/Rome',86.25,1,'work','2023-01-20 16:18:21','2022-12-12'),
(3535,3,2,117,'2022-12-13 09:40:00','2022-12-13 10:40:00',3600,'Riconsegnati e configurati 3 pc client dopo aggiornamenti hw e sw',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-01-31 11:04:03','2022-12-13'),
(3536,3,1,18,'2022-12-13 08:10:00','2022-12-13 08:20:00',600,'Assistenza su pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-03 08:59:27','2022-12-13'),
(3537,3,2,41,'2022-12-14 09:20:00','2022-12-14 09:30:00',600,'Consegna ups apc 1600, ups apc 500, ups rigenerato e printer server',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-06 09:21:29','2022-12-14'),
(3538,1,1,90,'2022-12-14 07:49:00','2022-12-14 08:30:00',2460,'problemi posta in uscita\r\nverifiche varie',30.75,NULL,45,1,'Europe/Rome',30.75,1,'work','2023-01-23 10:14:58','2022-12-14'),
(3539,1,1,90,'2022-12-14 09:50:00','2022-12-14 11:28:00',5880,'problema pc donatella lento',73.5,NULL,45,1,'Europe/Rome',73.5,1,'work','2023-01-23 10:14:59','2022-12-14'),
(3540,3,2,76,'2022-12-14 13:40:00','2022-12-14 14:25:00',2700,'Riconsegnato e configurato portatile Dell',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-12-20 15:37:05','2022-12-14'),
(3541,3,2,26,'2022-12-14 14:45:00','2022-12-14 15:10:00',1500,'Consegna toner compatibili giallo e nero Brother \r\nAssistenza su PC client Banci',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-22 10:36:50','2022-12-14'),
(3542,3,2,117,'2022-12-14 15:40:00','2022-12-14 15:50:00',600,'Ritirato pc client sede via Tanini per assistenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-01-31 11:04:01','2022-12-14'),
(3543,1,1,90,'2022-12-14 14:13:00','2022-12-14 16:10:00',7020,'pc donatella problemi gestionale',87.75,NULL,45,1,'Europe/Rome',87.75,1,'work','2023-01-23 10:15:02','2022-12-14'),
(3544,1,2,3,'2022-12-14 16:22:00','2022-12-14 17:45:00',4980,'da porcile e trado per preventivi',62.25,NULL,45,1,'Europe/Rome',62.25,1,'work','2023-01-27 13:04:17','2022-12-14'),
(3545,3,1,43,'2022-12-14 08:20:00','2022-12-14 08:40:00',1200,'Assistenza su pc client Romina per problemi invio posta a determinati clienti, deve sentire chi gestisce la posta',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-03 08:34:50','2022-12-14'),
(3546,3,4,76,'2022-12-14 09:40:00','2022-12-14 10:40:00',3600,'Reinstallazione sistema operativo su portatile ritirato + copia bk (circa 100gb), sostituzione ssd s3+ 480gb in garanzia',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-12-20 15:37:04','2022-12-14'),
(3547,3,1,96,'2022-12-14 16:50:00','2022-12-14 17:05:00',900,'Assistenza su pc client Federica per problemi ricezione posta da determinato cliente, lavoro da finire quando ci forniscono messaggio d\'errore',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-06 09:28:58','2022-12-14'),
(3548,3,1,18,'2022-12-14 17:20:00','2022-12-14 17:30:00',600,'Assistenza su pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-03 08:59:28','2022-12-14'),
(3549,1,1,114,'2022-12-15 10:50:00','2022-12-15 11:28:00',2280,'varie per preventivi er problemi vpn gabriele',28.5,NULL,45,1,'Europe/Rome',28.5,1,'work','2023-02-09 16:25:11','2022-12-15'),
(3550,1,1,108,'2022-12-15 15:10:00','2022-12-15 15:39:13',1753,'per preventivo wifi',21.91,NULL,45,1,'Europe/Rome',21.91,1,'work','2023-03-09 16:51:47','2022-12-15'),
(3551,1,1,26,'2022-12-15 15:43:00','2022-12-15 16:20:27',2247,'creazione mail e discusso di come eseguire determinati lavori',28.09,NULL,45,1,'Europe/Rome',28.09,1,'work','2023-02-22 10:36:57','2022-12-15'),
(3552,3,1,29,'2022-12-15 09:25:00','2022-12-15 09:40:00',900,'Assistenza per problemi sulla stampante della segreteria',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-01-16 10:37:06','2022-12-15'),
(3553,3,4,117,'2022-12-15 10:00:00','2022-12-15 11:30:00',5400,'Reinstallato sistema operativo su pc client ritirato + upgrade hw, utilizzato ssd s3+ da 480gb',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-01-31 11:04:03','2022-12-15'),
(3554,3,1,18,'2022-12-15 13:50:00','2022-12-15 14:00:00',600,'Assistenza su pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-03 08:59:29','2022-12-15'),
(3555,1,1,26,'2022-12-15 16:35:00','2022-12-15 17:00:00',1500,'creazione mail',18.75,NULL,45,1,'Europe/Rome',18.75,1,'work','2023-02-22 10:36:51','2022-12-15'),
(3556,1,1,26,'2022-12-15 17:04:00','2022-12-15 17:30:00',1560,'problemi roundcube',19.5,NULL,45,1,'Europe/Rome',19.5,1,'work','2023-02-22 09:14:08','2022-12-15'),
(3557,1,1,90,'2022-12-16 08:08:00','2022-12-16 09:18:00',4200,'problema factum',52.5,NULL,45,1,'Europe/Rome',52.5,1,'work','2023-01-23 10:14:59','2022-12-16'),
(3558,3,2,76,'2022-12-16 10:25:00','2022-12-16 10:35:00',600,'Consegnato HHD da 1 tb 340265',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-12-20 15:37:07','2022-12-16'),
(3559,1,1,3,'2022-12-16 13:48:00','2022-12-16 15:02:00',4440,'telefono alex',55.5,NULL,45,1,'Europe/Rome',55.5,1,'work','2023-01-27 13:04:18','2022-12-16'),
(3560,1,1,2,'2022-12-16 15:13:00','2022-12-16 17:27:48',8088,'agg vari',101.1,NULL,45,1,'Europe/Rome',101.1,1,'work','2023-04-06 08:43:10','2022-12-16'),
(3561,1,1,103,'2022-12-16 07:40:00','2022-12-16 08:00:00',1200,'agg vari',15,NULL,45,1,'Europe/Rome',15,1,'work','2023-03-02 10:02:02','2022-12-16'),
(3562,1,1,103,'2022-12-16 09:35:00','2022-12-16 11:23:00',6480,'agg vari',81,NULL,45,1,'Europe/Rome',81,1,'work','2023-03-02 10:02:17','2022-12-16'),
(3563,1,1,3,'2022-12-14 08:40:00','2022-12-14 09:40:00',3600,'proxmox host backup',45,NULL,45,1,'Europe/Rome',45,1,'work','2023-01-27 13:04:08','2022-12-14'),
(3564,1,1,3,'2022-12-12 16:54:00','2022-12-12 17:30:00',2160,'proxmox backup host',27,NULL,45,1,'Europe/Rome',27,1,'work','2023-01-27 13:04:13','2022-12-12'),
(3565,1,1,3,'2022-12-13 07:44:00','2022-12-13 09:52:00',7680,'promxox backup host',96,NULL,45,1,'Europe/Rome',96,1,'work','2023-01-27 13:04:19','2022-12-13'),
(3566,1,1,41,'2022-12-13 09:57:00','2022-12-13 11:26:00',5340,'creazione chiavi ssl per roberto, aggiunta chiavi sui firewall \r\n*****NON SCRIVERE IN REPORT**** modifiche ai firewall per evitare comandi dati a muzzo',66.75,NULL,45,1,'Europe/Rome',66.75,1,'work','2023-04-06 09:21:59','2022-12-13'),
(3567,1,1,3,'2022-12-13 13:47:00','2022-12-13 17:23:00',12960,'proxmox backup hosts',162,NULL,45,1,'Europe/Rome',162,1,'work','2023-01-27 13:04:12','2022-12-13'),
(3568,3,4,83,'2022-12-16 08:00:00','2022-12-16 09:00:00',3600,'Assistenza su pc client Orietta ritirato',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-09 10:47:23','2022-12-16'),
(3569,3,2,121,'2022-12-16 10:45:00','2022-12-16 11:15:00',1800,'Sostituzione alimentatore cm 500w su pc client + pulizia polvere',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-12-16 17:28:27','2022-12-16'),
(3570,3,2,83,'2022-12-16 14:50:00','2022-12-16 15:50:00',3600,'Riconsegnato pc client Orietta dopo assistenza, spostamento postazioni client Luigi e Andrea nel nuovo ufficio',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-09 10:47:25','2022-12-16'),
(3571,1,1,50,'2022-12-19 10:40:00','2022-12-19 11:50:00',4200,'problemi spam,',52.5,NULL,45,1,'Europe/Rome',52.5,1,'work','2023-02-03 09:19:13','2022-12-19'),
(3572,1,6,81,'2022-12-19 10:28:00','2022-12-19 10:35:00',420,'problema stampa colori',5.25,NULL,45,1,'Europe/Rome',5.25,1,'work','2023-03-02 15:19:34','2022-12-19'),
(3573,3,2,79,'2022-12-19 11:10:00','2022-12-19 11:50:00',2400,'Verificati problemi toner su stampante Brother DCP L3550CDW, da ordinare toner compatibili \r\nAssistenza su PC client Paola Agnoletto \r\nAssistenza su PC client Roberto',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-03 10:56:25','2022-12-19'),
(3574,1,1,50,'2022-12-19 13:45:00','2022-12-19 17:10:00',12300,'problemi spam, e configurazione aggiornamento pc sala conferenze',153.75,NULL,45,1,'Europe/Rome',153.75,1,'work','2023-02-03 09:19:20','2022-12-19'),
(3575,3,1,96,'2022-12-19 13:40:00','2022-12-19 13:50:00',600,'Assistenza su pc client Segreteria',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-06 09:28:51','2022-12-19'),
(3576,3,1,96,'2022-12-19 14:30:00','2022-12-19 15:30:00',3600,'Assistenza su portatile casa Gandolfo + installazione e configurazione vpn',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-06 09:28:51','2022-12-19'),
(3577,3,1,26,'2022-12-19 15:40:00','2022-12-19 16:20:00',2400,'Assistenza su pc client Banci per problemi sincronizzazione Outlook',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-22 10:37:01','2022-12-19'),
(3578,1,1,4,'2022-12-20 09:05:00','2022-12-20 09:45:00',2400,'problema backup',30,NULL,45,1,'Europe/Rome',30,1,'work','2023-03-16 17:14:40','2022-12-20'),
(3579,1,1,2,'2022-12-20 09:50:00','2022-12-20 10:25:00',2100,'problemi nvr steffano cevasco',26.25,NULL,45,1,'Europe/Rome',26.25,1,'work','2023-04-06 08:43:09','2022-12-20'),
(3580,3,1,26,'2022-12-20 14:40:00','2022-12-20 14:55:00',900,'Creato nuovo indirizzo mail per Paola Ferrando',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-22 10:36:51','2022-12-20'),
(3581,3,2,117,'2022-12-21 10:20:00','2022-12-21 10:45:00',1500,'Riconsegnato e configurato pc client nella sede di via Tanini',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-01-31 11:04:08','2022-12-21'),
(3582,3,1,96,'2022-12-21 08:20:00','2022-12-21 08:30:00',600,'Disabilitate chiavi vpn Anna Mochi per il collegamento remoto',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-06 09:28:57','2022-12-21'),
(3583,3,1,96,'2022-12-21 13:40:00','2022-12-21 13:55:00',900,'Assistenza su portatile casa Cristina per collegamento in rdp al pc dell\'ufficio',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-06 09:29:00','2022-12-21'),
(3584,3,1,96,'2022-12-21 15:00:00','2022-12-21 15:15:00',900,'Assistenza su portatile casa Gandolfo per utilizzo di Teams',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-06 09:28:52','2022-12-21'),
(3585,3,2,104,'2022-12-21 15:20:00','2022-12-21 15:50:00',1800,'Assistenza su pc client Daniele per liberare spazio su disco',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-01-26 15:01:56','2022-12-21'),
(3586,1,1,66,'2022-12-22 10:30:00','2022-12-22 11:03:46',2026,'aiutato fede li problemi raggiungibilità nas',25.33,NULL,45,1,'Europe/Rome',25.33,1,'work','2023-03-02 15:19:11','2022-12-22'),
(3587,3,2,66,'2022-12-22 09:30:00','2022-12-22 11:30:00',7200,'Assistenza e aggiornamenti su stampante Epson per problemi configurazione , verifica impostazioni Norton, assistenza su NAS per modifiche configurazione backuppc',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-02 15:19:09','2022-12-22'),
(3588,1,1,67,'2022-12-22 14:35:00','2022-12-22 15:57:53',4973,'risoluzione problemi doppio account per office 365',62.16,NULL,45,1,'Europe/Rome',62.16,1,'work','2023-02-03 10:10:08','2022-12-22'),
(3589,3,2,79,'2022-12-22 15:10:00','2022-12-22 15:50:00',2400,'Consegnati toner compatibili Brother LCD 3550 CDW\r\nOrdinare toner originali per  Brother LCD 3550 CDW\r\nAssistenza su stampante Brother',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-03 10:56:33','2022-12-22'),
(3590,3,1,96,'2022-12-22 13:35:00','2022-12-22 13:45:00',600,'Riabilitate chiavi vpn di Anna Mochi per collegamento remoto',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-06 09:28:57','2022-12-22'),
(3591,3,1,96,'2022-12-22 13:50:00','2022-12-22 14:15:00',1500,'Assistenza su portatile casa Cristina Musso per problemi collegamento alla vpn',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-06 09:28:59','2022-12-22'),
(3592,3,1,29,'2022-12-22 16:25:00','2022-12-22 16:40:00',900,'Assistenza su pc client Segreteria per problemi collegamento con la stampante',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-01-16 15:05:44','2022-12-22'),
(3593,1,1,97,'2022-12-23 10:31:00','2022-12-23 11:01:19',1819,'problemi cloudflare',22.74,NULL,45,1,'Europe/Rome',22.74,1,'work','2023-03-10 16:12:40','2022-12-23'),
(3594,3,1,90,'2022-12-23 09:30:00','2022-12-23 09:50:00',1200,'Assistenza su pc casa Manuela per problemi collegamento in ufficio',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-01-23 10:14:54','2022-12-23'),
(3595,3,1,97,'2022-12-23 13:40:00','2022-12-23 14:10:00',1800,'Fatte modifiche richieste su sito',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-10 16:13:25','2022-12-23'),
(3596,3,1,95,'2022-12-23 14:35:00','2022-12-23 15:00:00',1500,'Installato e configurato Office 2021 Plus su pc client Porcile',0,NULL,0,1,'Europe/Rome',0,1,'work','2022-12-28 11:10:27','2022-12-23'),
(3597,3,1,114,'2022-12-23 15:20:00','2022-12-23 15:50:00',1800,'Installata e configurata vpn su mac Marco Muià, da verificare perchè ci sono problemi di collegamento al NAS',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-09 16:58:32','2022-12-23'),
(3598,1,1,1,'2022-12-27 10:02:00','2022-12-27 11:19:00',4620,'config autorsiposta\r\nproblemi non funziona sistemato',57.75,NULL,45,1,'Europe/Rome',57.75,1,'work','2023-01-27 12:57:53','2022-12-27'),
(3599,1,1,57,'2022-12-27 07:43:00','2022-12-27 08:37:00',3240,'problemi di connessione su server',40.5,NULL,45,1,'Europe/Rome',40.5,1,'work','2023-02-24 11:12:05','2022-12-27'),
(3600,3,1,26,'2022-12-27 14:50:00','2022-12-27 15:05:00',900,'Assistenza su portatile casa Banci per problema sincronizzazione Outlook',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-22 10:36:57','2022-12-27'),
(3601,1,1,90,'2022-12-06 14:30:00','2022-12-06 17:15:00',9900,'server nuovo',123.75,NULL,45,1,'Europe/Rome',123.75,1,'work','2023-01-20 16:18:16','2022-12-06'),
(3602,1,1,2,'2022-12-06 09:03:00','2022-12-06 11:27:00',8640,'problemi posta',108,NULL,45,1,'Europe/Rome',108,1,'work','2023-04-06 08:43:05','2022-12-06'),
(3603,1,3,112,'2022-12-15 07:30:00','2022-12-15 08:40:00',4200,NULL,52.5,NULL,45,1,'Europe/Rome',52.5,1,'work','2023-03-08 17:14:46','2022-12-15'),
(3604,1,1,79,'2022-12-15 08:42:00','2022-12-15 10:46:00',7440,'agg vm',93,NULL,45,1,'Europe/Rome',93,1,'work','2023-02-03 10:56:43','2022-12-15'),
(3605,1,1,2,'2022-12-19 09:10:00','2022-12-19 10:18:00',4080,'sistemazione array su server infovision',51,NULL,45,1,'Europe/Rome',51,1,'work','2023-04-06 08:43:43','2022-12-19'),
(3606,1,1,67,'2022-12-19 07:49:00','2022-12-19 08:58:00',4140,'controllo dominio per verifiche office 365',51.75,NULL,45,1,'Europe/Rome',51.75,1,'work','2023-02-03 10:10:07','2022-12-19'),
(3607,1,1,3,'2022-12-27 16:53:00','2022-12-27 17:30:00',2220,'fogli',27.75,NULL,45,1,'Europe/Rome',27.75,1,'work','2023-01-27 13:04:12','2022-12-27'),
(3608,1,1,57,'2022-12-27 13:40:00','2022-12-27 15:45:00',7500,'problemi server e verifiche dopo agg',93.75,NULL,45,1,'Europe/Rome',93.75,1,'work','2023-02-24 11:12:06','2022-12-27'),
(3609,1,1,3,'2022-12-27 09:00:00','2022-12-27 10:00:00',3600,'backup remoti',45,NULL,45,1,'Europe/Rome',45,1,'work','2023-01-27 13:04:29','2022-12-27'),
(3610,3,2,29,'2022-12-28 09:25:00','2022-12-28 10:55:00',5400,'Pulizia e aggiornamenti su tutti i PC client\r\nPulizia e aggiornamenti su server Linux',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-01-16 15:05:45','2022-12-28'),
(3611,1,4,3,'2022-12-28 13:30:00','2022-12-28 14:00:00',1800,'in lab',22.5,NULL,45,1,'Europe/Rome',22.5,1,'work','2023-01-27 13:04:11','2022-12-28'),
(3612,1,1,29,'2022-12-28 09:54:00','2022-12-28 11:30:00',5760,'fede li agg server e riavii',72,NULL,45,1,'Europe/Rome',72,1,'work','2023-01-16 10:47:51','2022-12-28'),
(3613,1,3,112,'2022-12-28 14:42:00','2022-12-28 17:30:00',10080,NULL,126,NULL,45,1,'Europe/Rome',126,1,'work','2023-03-08 17:14:42','2022-12-28'),
(3614,3,6,120,'2022-12-29 08:20:00','2022-12-29 08:30:00',600,'Assistenza telefonica per ricollegare ups che è stato staccato dalla corrente',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-02 14:57:13','2022-12-29'),
(3615,3,2,55,'2022-12-29 08:45:00','2022-12-29 09:40:00',3300,'Sostituzione pacco batterie su ups apc armadio rack\r\nInstallata 1 licenza nod32 aggiornamento su PC client Marika, assistenza per problemi su vm Lybro',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-03 08:20:48','2022-12-29'),
(3616,1,1,55,'2022-12-29 09:13:00','2022-12-29 09:34:00',1260,'fede li problemi dopo riaccensione su vm lybro',15.75,NULL,45,1,'Europe/Rome',15.75,1,'work','2023-02-03 08:31:31','2022-12-29'),
(3617,3,2,57,'2022-12-29 10:10:00','2022-12-29 10:35:00',1500,'Sostituzione disco di sistema su server con WD gold da 2tb',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-24 15:23:47','2022-12-29'),
(3618,3,2,50,'2022-12-29 10:55:00','2022-12-29 11:05:00',600,'Consegnata tastiera usb',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-03 09:19:27','2022-12-29'),
(3619,1,4,3,'2022-12-29 07:30:00','2022-12-29 09:00:00',5400,'assemblaggio nuovi server',67.5,NULL,45,1,'Europe/Rome',67.5,1,'work','2023-01-27 13:04:10','2022-12-29'),
(3620,1,4,3,'2022-12-29 09:41:00','2022-12-29 10:28:00',2820,'assemblaggio nuovi server',35.25,NULL,45,1,'Europe/Rome',35.25,1,'work','2023-01-27 13:04:18','2022-12-29'),
(3621,1,4,87,'2022-12-29 10:45:00','2022-12-29 11:30:00',2700,'server nuovo',33.75,NULL,45,1,'Europe/Rome',33.75,1,'work','2023-01-17 10:01:24','2022-12-29'),
(3622,1,4,87,'2022-12-29 12:45:00','2022-12-29 13:36:00',3060,'server nuovo',38.25,NULL,45,1,'Europe/Rome',38.25,1,'work','2023-01-17 10:01:17','2022-12-29'),
(3623,3,1,114,'2022-12-29 14:40:00','2022-12-29 14:55:00',900,'Sistemato problema vpn su mac casa Marco Muia',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-09 16:58:41','2022-12-29'),
(3624,1,1,87,'2022-12-29 14:16:00','2022-12-29 17:27:00',11460,'server nuiovo',143.25,NULL,45,1,'Europe/Rome',143.25,1,'work','2023-01-17 10:01:25','2022-12-29'),
(3625,1,1,87,'2022-12-30 07:48:00','2022-12-30 08:23:00',2100,'server nuovo',26.25,NULL,45,1,'Europe/Rome',26.25,1,'work','2023-01-17 10:01:18','2022-12-30'),
(3626,1,1,95,'2022-12-30 08:34:00','2022-12-30 12:14:00',13200,'server nuovo',165,NULL,45,1,'Europe/Rome',165,1,'work','2023-02-28 10:37:40','2022-12-30'),
(3627,1,3,112,'2022-12-30 13:30:00','2022-12-30 17:30:00',14400,NULL,180,NULL,45,1,'Europe/Rome',180,1,'work','2023-03-08 17:14:49','2022-12-30'),
(3628,1,1,2,'2023-01-03 09:10:00','2023-01-03 09:20:00',600,'config mail valentina maga',7.5,NULL,45,1,'Europe/Rome',7.5,1,'work','2023-04-06 08:43:12','2023-01-03'),
(3629,1,1,95,'2023-01-04 17:09:00','2023-01-04 17:18:18',558,'anna problemi pc',6.98,NULL,45,1,'Europe/Rome',6.98,1,'work','2023-01-13 15:38:05','2023-01-04'),
(3630,1,1,122,'2023-01-05 14:00:00','2023-01-05 15:24:45',5085,'copia suoi dati da gandolfo',63.56,NULL,45,1,'Europe/Rome',63.56,1,'work','2023-02-09 17:22:42','2023-01-05'),
(3631,1,1,103,'2023-01-09 09:07:00','2023-01-09 09:27:37',1237,'creazionee config mail',15.46,NULL,45,1,'Europe/Rome',15.46,1,'work','2023-03-02 09:59:44','2023-01-09'),
(3632,1,6,26,'2023-01-09 10:17:00','2023-01-09 10:40:00',1380,'con laura al tel per vari lavori da effettuare',17.25,NULL,45,1,'Europe/Rome',17.25,1,'work','2023-01-16 16:52:25','2023-01-09'),
(3633,1,1,56,'2023-01-09 14:08:00','2023-01-09 14:21:08',788,'valutazione pc da aggiornare',9.85,NULL,45,1,'Europe/Rome',9.85,1,'work','2023-01-19 09:15:12','2023-01-09'),
(3634,1,4,3,'2023-01-09 07:30:00','2023-01-09 09:00:00',5400,NULL,67.5,NULL,45,1,'Europe/Rome',67.5,1,'work','2023-01-27 13:00:41','2023-01-09'),
(3635,1,4,3,'2023-01-09 09:30:00','2023-01-09 10:15:00',2700,NULL,33.75,NULL,45,1,'Europe/Rome',33.75,1,'work','2023-01-27 13:00:43','2023-01-09'),
(3636,1,4,3,'2023-01-09 10:40:00','2023-01-09 11:30:00',3000,NULL,37.5,NULL,45,1,'Europe/Rome',37.5,1,'work','2023-01-27 13:00:43','2023-01-09'),
(3637,1,4,3,'2023-01-09 13:30:00','2023-01-09 14:00:00',1800,NULL,22.5,NULL,45,1,'Europe/Rome',22.5,1,'work','2023-01-27 13:00:49','2023-01-09'),
(3638,1,4,3,'2023-01-09 14:22:00','2023-01-09 15:00:00',2280,NULL,28.5,NULL,45,1,'Europe/Rome',28.5,1,'work','2023-01-27 13:00:52','2023-01-09'),
(3639,1,1,87,'2023-01-09 15:02:00','2023-01-09 15:38:00',2160,'server nuovo',27,NULL,45,1,'Europe/Rome',27,1,'work','2023-01-17 10:01:20','2023-01-09'),
(3640,1,1,87,'2023-01-09 16:00:00','2023-01-09 18:00:00',7200,'server nuovo',90,NULL,45,1,'Europe/Rome',90,1,'work','2023-01-17 10:01:21','2023-01-09'),
(3641,1,4,3,'2023-01-10 07:30:00','2023-01-10 08:00:00',1800,NULL,22.5,NULL,45,1,'Europe/Rome',22.5,1,'work','2023-01-27 13:00:48','2023-01-10'),
(3642,1,1,122,'2023-01-10 08:20:00','2023-01-10 08:41:00',1260,'pulizia pc',15.75,NULL,45,1,'Europe/Rome',15.75,1,'work','2023-02-09 17:22:43','2023-01-10'),
(3643,3,2,67,'2023-01-10 08:20:00','2023-01-10 08:55:00',2100,'Sostituzione 2 batterie su ups apc 1400',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-03 10:10:09','2023-01-10'),
(3644,1,1,122,'2023-01-10 09:28:00','2023-01-10 09:38:00',600,'configurazione nextcloud su client',7.5,NULL,45,1,'Europe/Rome',7.5,1,'work','2023-02-09 17:22:45','2023-01-10'),
(3645,3,2,79,'2023-01-10 10:05:00','2023-01-10 11:45:00',6000,'Consegna multipack toner originali 67399 per stampante Brother + assistenza su stampante',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-03 10:56:26','2023-01-10'),
(3646,3,1,18,'2023-01-09 15:35:00','2023-01-09 15:55:00',1200,'Assistenza su pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-03 08:59:30','2023-01-09'),
(3647,1,1,122,'2023-01-10 14:18:11','2023-01-10 14:36:57',1126,'configurazione nextcloud su client',14.08,NULL,45,1,'Europe/Rome',14.08,1,'work','2023-02-09 17:22:44','2023-01-10'),
(3648,1,1,29,'2023-01-10 15:05:00','2023-01-10 15:24:01',1141,'ups bippa',14.26,NULL,45,1,'Europe/Rome',14.26,1,'work','2023-01-16 14:50:10','2023-01-10'),
(3649,1,1,67,'2023-01-10 13:42:00','2023-01-10 14:14:00',1920,'problemi lentezza mail segnalati',24,NULL,45,1,'Europe/Rome',24,1,'work','2023-02-03 10:10:10','2023-01-10'),
(3650,1,1,67,'2023-01-10 14:40:00','2023-01-10 15:00:00',1200,'problemi lentezza mail segnalati',15,NULL,45,1,'Europe/Rome',15,1,'work','2023-02-03 10:10:11','2023-01-10'),
(3651,1,1,67,'2023-01-10 15:41:00','2023-01-10 16:11:00',1800,'problemi lentezza mail segnalati',22.5,NULL,45,1,'Europe/Rome',22.5,1,'work','2023-02-03 10:10:12','2023-01-10'),
(3652,1,1,95,'2023-01-10 08:49:00','2023-01-10 09:25:00',2160,'server nuovo',27,NULL,45,1,'Europe/Rome',27,1,'work','2023-02-28 10:37:41','2023-01-10'),
(3653,1,1,95,'2023-01-10 09:49:00','2023-01-10 11:27:00',5880,'server nuovo',73.5,NULL,45,1,'Europe/Rome',73.5,1,'work','2023-02-28 10:37:44','2023-01-10'),
(3654,1,1,95,'2023-01-10 16:18:00','2023-01-10 17:33:15',4515,'server nuovo',56.44,NULL,45,1,'Europe/Rome',56.44,1,'work','2023-02-28 10:37:46','2023-01-10'),
(3655,3,1,79,'2023-01-10 13:40:00','2023-01-10 14:15:00',2100,'Creata nuova cartella condivisa su server dedicata ad Andrea Parodi + configurazione su suo pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-03 10:56:26','2023-01-10'),
(3656,3,1,90,'2023-01-10 15:15:00','2023-01-10 15:30:00',900,'Installate 2 licenze nod32 su 4 pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-01-23 10:14:59','2023-01-10'),
(3657,3,1,91,'2023-01-10 15:40:00','2023-01-10 15:50:00',600,'Installata 1 licenza nod32 su 2 pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-01-17 10:33:48','2023-01-10'),
(3658,3,1,83,'2023-01-10 16:40:00','2023-01-10 16:50:00',600,'Assistenza su pc client Roberta',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-09 10:47:26','2023-01-10'),
(3659,1,2,26,'2023-01-11 08:05:00','2023-01-11 10:40:00',9300,'per evoluzione rete e cambio linea dati',116.25,NULL,45,1,'Europe/Rome',116.25,1,'work','2023-01-16 16:52:24','2023-01-11'),
(3660,1,1,75,'2023-01-11 11:10:00','2023-01-11 11:26:00',960,'port forwardin fastweb',12,NULL,45,1,'Europe/Rome',12,1,'work','2023-02-08 10:42:18','2023-01-11'),
(3661,1,2,3,'2023-01-11 14:00:00','2023-01-11 16:15:00',8100,'con te da cliente nuovo',101.25,NULL,45,1,'Europe/Rome',101.25,1,'work','2023-01-27 13:00:50','2023-01-11'),
(3662,3,1,67,'2023-01-11 07:40:00','2023-01-11 07:55:00',900,'Assistenza per problemi ricezione mail',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-03 10:10:12','2023-01-11'),
(3663,3,1,103,'2023-01-11 08:15:00','2023-01-11 08:30:00',900,'Installate 3 licenze nod32 aggiornamento su 6 pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-02 10:01:17','2023-01-11'),
(3664,3,1,32,'2023-01-11 08:45:00','2023-01-11 08:55:00',600,'Installata 1 licenza nod32 aggiornamento su 2 pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-01-23 16:36:42','2023-01-11'),
(3665,3,1,90,'2023-01-11 09:30:00','2023-01-11 09:45:00',900,'Assistenza su pc client Campodoni per problemi con Thunderbird',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-01-23 10:15:04','2023-01-11'),
(3666,3,1,96,'2023-01-11 13:50:00','2023-01-11 14:05:00',900,'Assistenza per riavvio servizi tomcat dopo aggiornamenti AGO e MIP',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-17 09:57:41','2023-01-11'),
(3667,3,1,75,'2023-01-11 15:20:00','2023-01-11 16:00:00',2400,'Configurato collegamento al server su pc client Contabilità + creazione e configurazione nuovo indirizzo di posta',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-08 10:42:20','2023-01-11'),
(3668,1,3,112,'2023-01-12 07:30:00','2023-01-12 08:30:00',3600,NULL,45,NULL,45,1,'Europe/Rome',45,1,'work','2023-03-08 17:14:52','2023-01-12'),
(3669,1,1,87,'2023-01-12 10:28:00','2023-01-12 11:20:00',3120,'server nuovo',39,NULL,45,1,'Europe/Rome',39,1,'work','2023-01-17 10:01:22','2023-01-12'),
(3670,1,1,50,'2023-01-12 11:22:00','2023-01-12 11:45:00',1380,'disco pieno segnalato',17.25,NULL,45,1,'Europe/Rome',17.25,1,'work','2023-02-03 09:19:26','2023-01-12'),
(3671,1,1,87,'2023-01-12 14:40:00','2023-01-12 16:45:00',7500,'fede cosnegna server nuovo \r\nsync di tutto\r\nproblemi ricezione posta',93.75,NULL,45,1,'Europe/Rome',93.75,1,'work','2023-01-17 10:12:51','2023-01-12'),
(3672,3,2,87,'2023-01-12 14:10:00','2023-01-12 17:00:00',10200,'Consegna più configurazione nuovo server proxmox\r\nConsegna e installazione ups apc 1500\r\nRitirati 2 ups apc da rigenerare\r\nRitirato vecchio server Linux',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-01-17 10:15:00','2023-01-12'),
(3673,1,1,87,'2023-01-13 07:47:00','2023-01-13 08:30:00',2580,'verifica funzionamento\r\nconfigurazione ups e backup',32.25,NULL,45,1,'Europe/Rome',32.25,1,'work','2023-01-17 10:12:44','2023-01-13'),
(3674,1,1,95,'2023-01-13 08:47:00','2023-01-13 11:22:00',9300,'studio confgi dkim con alex',116.25,NULL,45,1,'Europe/Rome',116.25,1,'work','2023-02-28 10:37:48','2023-01-13'),
(3675,1,1,105,'2023-01-13 14:22:00','2023-01-13 14:46:27',1467,'problema profilo',18.34,NULL,45,1,'Europe/Rome',18.34,1,'work','2023-01-17 10:28:30','2023-01-13'),
(3676,1,1,2,'2023-01-13 15:47:00','2023-01-13 16:13:00',1560,'abilitazione whatsapp web pc andrea',19.5,NULL,45,1,'Europe/Rome',19.5,1,'work','2023-04-06 08:43:16','2023-01-13'),
(3677,1,1,2,'2023-01-13 13:44:00','2023-01-13 14:17:00',1980,'abilitazione whatsapp web pc andrea',24.75,NULL,45,1,'Europe/Rome',24.75,1,'work','2023-04-06 08:43:16','2023-01-13'),
(3678,1,6,3,'2023-01-13 16:30:00','2023-01-13 17:12:00',2520,'telefono con ciro a sparare cazzate',31.5,NULL,45,1,'Europe/Rome',31.5,1,'work','2023-01-27 13:00:44','2023-01-13'),
(3679,3,1,1,'2023-01-13 08:30:00','2023-01-13 08:40:00',600,'Assistenza su portatile Roberta',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-01-27 12:57:53','2023-01-13'),
(3680,3,1,105,'2023-01-13 08:45:00','2023-01-13 08:55:00',600,'Installata 1 licenza nod32 aggiornamento su 2 pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-01-17 10:28:21','2023-01-13'),
(3681,3,1,96,'2023-01-13 09:10:00','2023-01-13 09:40:00',1800,'Installata e configurata vpn su pc client Marianna Confessore + collegamenti ad AGO e MIP\r\nAssistenza per problemi rete Fastweb',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-06 09:29:01','2023-01-13'),
(3682,3,2,104,'2023-01-13 13:30:00','2023-01-13 13:50:00',1200,'Consegna toner compatibili + configurata nuova mail su pc client Giulia Parise',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-01-26 16:03:39','2023-01-13'),
(3683,3,1,87,'2023-01-13 13:55:00','2023-01-13 14:05:00',600,'Assistenza su pc client Telematico per modifiche posta dopo cambio server',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-01-17 10:12:37','2023-01-13'),
(3684,3,6,97,'2023-01-13 14:05:00','2023-01-13 14:15:00',600,'Assistenza per problemi rete Vodafone',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-10 16:18:10','2023-01-13'),
(3685,3,6,75,'2023-01-13 14:15:00','2023-01-13 14:25:00',600,'Chiamato Fastweb per apertura porta su router',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-08 10:42:20','2023-01-13'),
(3686,1,1,87,'2023-01-16 07:40:00','2023-01-16 08:30:00',3000,'pronblemi backup remoteo e vpn',37.5,NULL,45,1,'Europe/Rome',37.5,1,'work','2023-01-17 10:01:05','2023-01-16'),
(3687,1,1,122,'2023-01-16 13:44:00','2023-01-16 15:48:54',7494,'config pc nextcloud',93.68,NULL,45,1,'Europe/Rome',93.68,1,'work','2023-02-09 17:22:46','2023-01-16'),
(3688,3,2,56,'2023-01-16 13:55:00','2023-01-16 14:15:00',1200,'Verificato e ritirato pc client Federica',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-01-19 09:15:14','2023-01-16'),
(3689,3,2,26,'2023-01-16 14:25:00','2023-01-16 14:45:00',1200,'Ritirato portatili Banci e Simona per assistenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-01-16 16:52:22','2023-01-16'),
(3690,1,1,85,'2023-01-16 16:02:00','2023-01-16 16:15:38',818,'problemi thunderbird',10.23,NULL,45,1,'Europe/Rome',10.23,1,'work','2023-03-30 15:13:05','2023-01-16'),
(3691,3,1,1,'2023-01-16 10:15:00','2023-01-16 10:25:00',600,'Assistenza su pc client Roberta',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-01-27 12:58:06','2023-01-16'),
(3692,3,4,26,'2023-01-16 15:30:00','2023-01-16 16:30:00',3600,'Aggiornata versione Windows da Home a Pro su portatile Banci e Simona',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-01-18 09:54:12','2023-01-16'),
(3693,3,4,87,'2023-01-16 17:10:00','2023-01-16 17:40:00',1800,'Sostituzione 2 batterie su 2 UPS APC 400',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-01-17 10:14:57','2023-01-16'),
(3694,1,1,67,'2023-01-17 07:50:00','2023-01-17 11:09:00',11940,'config mail e dominio',149.25,NULL,45,1,'Europe/Rome',149.25,1,'work','2023-02-03 10:10:14','2023-01-17'),
(3695,1,1,104,'2023-01-17 11:11:00','2023-01-17 11:29:00',1080,'problema pc milena',13.5,NULL,45,1,'Europe/Rome',13.5,1,'work','2023-01-26 16:03:40','2023-01-17'),
(3696,1,1,26,'2023-01-17 11:35:00','2023-01-17 11:50:00',900,'aiutato fede li per problemi vpn',11.25,NULL,45,1,'Europe/Rome',11.25,1,'work','2023-02-17 11:23:01','2023-01-17'),
(3697,3,2,26,'2023-01-17 11:10:00','2023-01-17 12:10:00',3600,'Riconsegnati portatili Banci e Simona\r\nTest per funzionamento vpn Confindustria Liguria negli uffici di Confindustria Genova, da verificare',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-22 10:36:56','2023-01-17'),
(3698,1,1,67,'2023-01-17 12:17:37','2023-01-17 12:40:49',1392,'config mail e dominio',17.4,NULL,45,1,'Europe/Rome',17.4,1,'work','2023-02-03 10:10:15','2023-01-17'),
(3699,3,2,117,'2023-01-17 12:30:00','2023-01-17 12:45:00',900,'Verificato e ritirato pc client per upgrade hw e sw',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-01-31 11:04:03','2023-01-17'),
(3700,1,1,67,'2023-01-17 13:52:00','2023-01-17 17:06:36',11676,'config mail e dominio',145.95,NULL,45,1,'Europe/Rome',145.95,1,'work','2023-02-03 10:10:16','2023-01-17'),
(3701,3,2,56,'2023-01-17 14:00:00','2023-01-17 16:30:00',9000,'Consegna e configurazione nuovo PC client Federica\r\nDa finire ripristino posta elettronica',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-01-19 09:15:15','2023-01-17'),
(3702,3,2,87,'2023-01-17 16:45:00','2023-01-17 17:00:00',900,'Riconsegnati e collegati 2 ups apc 400 rigenerati',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-01 14:50:45','2023-01-17'),
(3703,3,1,50,'2023-01-17 08:55:00','2023-01-17 09:25:00',1800,'Assistenza su pc client Loretta per problemi navigazione, configurata posta su portatile mac Gigio',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-03 09:19:14','2023-01-17'),
(3704,1,1,67,'2023-01-18 08:30:00','2023-01-18 08:49:00',1140,'config mail e dominio simona ganzarolli',14.25,NULL,45,1,'Europe/Rome',14.25,1,'work','2023-02-03 10:10:16','2023-01-18'),
(3705,1,1,26,'2023-01-18 08:53:00','2023-01-18 09:03:45',645,'config vpn prove',8.06,NULL,45,1,'Europe/Rome',8.06,1,'work','2023-02-22 10:36:52','2023-01-18'),
(3706,1,1,26,'2023-01-18 07:48:00','2023-01-18 08:21:00',1980,'prove vpn per configurazione che avverrà in mattinata',24.75,NULL,45,1,'Europe/Rome',24.75,1,'work','2023-02-22 10:37:00','2023-01-18'),
(3707,3,2,111,'2023-01-18 10:45:00','2023-01-18 11:15:00',1800,'Assistenza su PC client',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-17 11:14:03','2023-01-18'),
(3708,1,1,56,'2023-01-18 11:22:00','2023-01-18 11:47:21',1521,'ripristino file',19.01,NULL,45,1,'Europe/Rome',19.01,1,'work','2023-01-19 09:15:16','2023-01-18'),
(3709,1,1,104,'2023-01-18 15:34:00','2023-01-18 15:48:00',840,'problema pc gabriele milite',10.5,NULL,45,1,'Europe/Rome',10.5,1,'work','2023-01-26 16:03:41','2023-01-18'),
(3710,1,1,3,'2023-01-18 13:30:00','2023-01-18 14:00:00',1800,'disassemblaggio pc',22.5,NULL,45,1,'Europe/Rome',22.5,1,'work','2023-01-27 13:00:47','2023-01-18'),
(3711,1,1,43,'2023-01-18 16:05:00','2023-01-18 16:17:00',720,'problema pc romina agosti su stampe',9,NULL,45,1,'Europe/Rome',9,1,'work','2023-02-03 08:34:51','2023-01-18'),
(3712,3,4,123,'2023-01-16 09:00:00','2023-01-16 10:00:00',3600,'Assistenza e reinstallazione sistema operativo su portatile ritirato',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-01-25 17:11:41','2023-01-16'),
(3713,3,1,56,'2023-01-18 07:50:00','2023-01-18 09:20:00',5400,'Assistenza su nuovo pc client per configurazione e copia vecchie mail',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-01-19 09:15:16','2023-01-18'),
(3714,3,1,64,'2023-01-18 09:25:00','2023-01-18 09:35:00',600,'Assistenza su pc client Mirella',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-05 10:09:41','2023-01-18'),
(3715,3,1,56,'2023-01-18 13:40:00','2023-01-18 14:10:00',1800,'Assistenza su nuovo pc client per riconfigurazione posta in pop e recupero archivio vecchie mail e contatti',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-01-19 09:15:17','2023-01-18'),
(3716,1,1,67,'2023-01-19 09:33:00','2023-01-19 11:46:32',8012,'problema outlook massimo',100.15,NULL,45,1,'Europe/Rome',100.15,1,'work','2023-02-03 10:10:17','2023-01-19'),
(3717,3,2,96,'2023-01-19 09:45:00','2023-01-19 10:50:00',3900,'Spostamento e cablaggio 2 postazioni client \r\nAssistenza su PC client',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-06 09:29:02','2023-01-19'),
(3718,3,2,75,'2023-01-19 11:10:00','2023-01-19 12:10:00',3600,'Assistenza su PC client per problemi con scansione di rete, assistenza su telefono voip',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-08 10:42:19','2023-01-19'),
(3719,1,1,67,'2023-01-19 13:44:00','2023-01-19 16:50:00',11160,'problema outlook massimo',139.5,NULL,45,1,'Europe/Rome',139.5,1,'work','2023-02-03 10:10:18','2023-01-19'),
(3720,3,2,1,'2023-01-19 14:20:00','2023-01-19 14:50:00',1800,'Assistenza su stampante HP + installazione stampante su PC ingresso nella sede di Borzoli',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-01-27 12:58:02','2023-01-19'),
(3721,1,1,104,'2023-01-19 16:58:00','2023-01-19 17:06:19',499,'problema pc Flavoni Tino',6.24,NULL,45,1,'Europe/Rome',6.24,1,'work','2023-01-26 16:03:42','2023-01-19'),
(3722,1,1,5,'2023-01-19 17:12:00','2023-01-19 17:26:00',840,'pulizia backup vecchi backup remoti oltre i 400 gb',10.5,NULL,45,1,'Europe/Rome',10.5,1,'work','2023-04-06 09:26:31','2023-01-19'),
(3723,1,1,5,'2023-01-19 07:41:00','2023-01-19 09:16:00',5700,'agg server',71.25,NULL,45,1,'Europe/Rome',71.25,1,'work','2023-04-06 09:26:29','2023-01-19'),
(3724,1,1,3,'2023-01-18 14:18:00','2023-01-18 15:24:00',3960,'test su rustdesk',49.5,NULL,45,1,'Europe/Rome',49.5,1,'work','2023-01-27 13:00:45','2023-01-18'),
(3725,1,1,3,'2023-01-18 09:11:00','2023-01-18 11:07:00',6960,'test su rustdesk',87,NULL,45,1,'Europe/Rome',87,1,'work','2023-01-27 13:00:44','2023-01-18'),
(3726,1,1,3,'2023-01-18 16:29:00','2023-01-18 17:29:00',3600,'test su rustdesk',45,NULL,45,1,'Europe/Rome',45,1,'work','2023-01-27 13:00:45','2023-01-18'),
(3727,3,1,79,'2023-01-19 08:20:00','2023-01-19 08:40:00',1200,'Assistenza su pc client Andrea e Matteo per problemi di navigazione',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-03 10:56:27','2023-01-19'),
(3728,3,1,56,'2023-01-19 08:40:00','2023-01-19 09:00:00',1200,'Assistenza su nuovo pc client Federica',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-13 15:07:31','2023-01-19'),
(3729,3,1,79,'2023-01-19 13:35:00','2023-01-19 13:45:00',600,'Assistenza su pc client Elena per problemi sul mouse',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-03 10:56:27','2023-01-19'),
(3730,3,1,45,'2023-01-19 16:50:00','2023-01-19 17:15:00',1500,'Configurata vpn su portatile Laura per utilizzo software gestionale esterno Winper',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-16 17:12:49','2023-01-19'),
(3731,1,1,104,'2023-01-20 07:55:00','2023-01-20 08:06:11',671,'problema pc Fidati Tino',8.39,NULL,45,1,'Europe/Rome',8.39,1,'work','2023-01-26 16:03:43','2023-01-20'),
(3732,3,2,123,'2023-01-20 09:50:00','2023-01-20 11:00:00',4200,'Consegnato e configurato portatile Cristina reinstallato, utilizzato: 1 switch 5 porte gigabit, 2 cavi LAN da mt, 1 cavo HMDI',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-01-25 17:11:42','2023-01-20'),
(3733,1,3,112,'2023-01-20 11:10:00','2023-01-20 11:30:00',1200,NULL,15,NULL,45,1,'Europe/Rome',15,1,'work','2023-03-08 17:14:43','2023-01-20'),
(3734,1,2,124,'2023-01-20 13:39:00','2023-01-20 14:37:00',3480,'Sopraluogo per valutare lavori da fare,\r\nritirato nas per reset password',43.5,NULL,45,1,'Europe/Rome',43.5,1,'work','2023-02-24 16:44:44','2023-01-20'),
(3735,3,1,12,'2023-01-20 08:20:00','2023-01-20 08:35:00',900,'Installata e configurata vpn su mac Margherita Massilin + collegamento a server',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-03 14:36:51','2023-01-20'),
(3736,3,1,96,'2023-01-20 08:40:00','2023-01-20 08:50:00',600,'Configurata nuova mail consulenza su pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-06 09:29:03','2023-01-20'),
(3737,3,2,95,'2023-01-20 15:30:00','2023-01-20 17:10:00',6000,'Consegna e configurazione nuovo server proxmox + installato nuovo ups apc 1400',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-28 10:41:09','2023-01-20'),
(3738,1,1,95,'2023-01-20 15:42:00','2023-01-20 18:00:00',8280,'server nuovo',103.5,NULL,45,1,'Europe/Rome',103.5,1,'work','2023-02-28 10:41:11','2023-01-20'),
(3739,1,1,95,'2023-01-20 20:20:00','2023-01-20 22:15:00',6900,'server nuovo config client\r\nproblemi con dns internetbs',86.25,NULL,45,1,'Europe/Rome',86.25,1,'work','2023-02-28 10:41:17','2023-01-20'),
(3740,1,4,3,'2023-01-20 14:45:00','2023-01-20 14:55:00',600,'in lab',7.5,NULL,45,1,'Europe/Rome',7.5,1,'work','2023-01-27 13:00:45','2023-01-20'),
(3741,1,1,3,'2023-01-23 07:30:00','2023-01-23 08:06:00',2160,'aiutato alex per rustdesk',27,NULL,45,1,'Europe/Rome',27,1,'work','2023-01-27 13:00:45','2023-01-23'),
(3742,1,1,95,'2023-01-23 09:50:00','2023-01-23 10:00:19',619,'prob anna',7.74,NULL,45,1,'Europe/Rome',7.74,1,'work','2023-02-28 10:41:22','2023-01-23'),
(3743,1,1,90,'2023-01-23 08:19:00','2023-01-23 09:45:00',5160,'problemi lentezza donatella',64.5,NULL,45,1,'Europe/Rome',64.5,1,'work','2023-01-23 10:15:14','2023-01-23'),
(3744,3,2,95,'2023-01-23 10:30:00','2023-01-23 11:05:00',2100,'Verificato problema ram su nuovo server',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-28 10:38:44','2023-01-23'),
(3745,3,2,41,'2023-01-23 11:20:00','2023-01-23 11:30:00',600,'Consegna stampante Brother nella sede di via Wagner',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-06 09:21:29','2023-01-23'),
(3746,1,1,90,'2023-01-23 13:43:00','2023-01-23 14:20:43',2263,'problemi lentezza donatella',28.29,NULL,45,1,'Europe/Rome',28.29,1,'work','2023-04-06 09:39:07','2023-01-23'),
(3747,1,1,2,'2023-01-23 15:45:00','2023-01-23 17:42:49',7069,'problemi vari pc stefano',88.36,NULL,45,1,'Europe/Rome',88.36,1,'work','2023-04-06 08:43:06','2023-01-23'),
(3748,1,2,95,'2023-01-23 14:42:00','2023-01-23 15:15:00',1980,'sopraluogo sistemazione armadio',24.75,NULL,45,1,'Europe/Rome',24.75,1,'work','2023-02-28 10:38:37','2023-01-23'),
(3749,3,1,79,'2023-01-23 08:05:00','2023-01-23 08:15:00',600,'Assistenza su pc client per modifica firma posta',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-03 10:56:28','2023-01-23'),
(3750,3,1,50,'2023-01-23 08:40:00','2023-01-23 08:50:00',600,'Assistenza su portatile FIlippo',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-03 09:19:25','2023-01-23'),
(3751,3,1,45,'2023-01-23 13:40:00','2023-01-23 13:55:00',900,'Installata vpn e collegamento al server per utilizzo software WinPer',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-16 17:12:56','2023-01-23'),
(3752,3,4,117,'2023-01-23 14:30:00','2023-01-23 16:30:00',7200,'Clonato sistema operativo + assistenza, utilizzato ssd 480gb',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-01-31 11:04:02','2023-01-23'),
(3753,3,1,5,'2023-01-23 17:00:00','2023-01-23 17:30:00',1800,'Assistenza per ripristino servizi dopo spostamento nei vecchi uffici',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-06-26 16:24:50','2023-01-23'),
(3754,1,3,112,'2023-01-24 07:30:00','2023-01-24 08:00:00',1800,NULL,22.5,NULL,45,1,'Europe/Rome',22.5,1,'work','2023-03-08 17:14:43','2023-01-24'),
(3755,1,1,2,'2023-01-24 09:05:00','2023-01-24 11:16:00',7860,'aggiornamenti server\r\nconnessione remota stefanino',98.25,NULL,45,1,'Europe/Rome',98.25,1,'work','2023-04-06 08:43:44','2023-01-24'),
(3756,3,2,108,'2023-01-24 14:10:00','2023-01-24 14:40:00',1800,'Sostituzione disco sul server con segate da 2tb',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-17 09:51:55','2023-01-24'),
(3757,1,1,3,'2023-01-24 13:33:00','2023-01-24 17:30:00',14220,'servizio sync ora sui server windows',177.75,NULL,45,1,'Europe/Rome',177.75,1,'work','2023-01-27 13:00:52','2023-01-24'),
(3758,1,1,55,'2023-01-24 08:07:00','2023-01-24 09:00:00',3180,'agg server',39.75,NULL,45,1,'Europe/Rome',39.75,1,'work','2023-02-03 08:31:33','2023-01-24'),
(3759,1,1,55,'2023-01-23 10:07:00','2023-01-23 11:24:00',4620,'agg server',57.75,NULL,45,1,'Europe/Rome',57.75,1,'work','2023-02-03 08:31:32','2023-01-23'),
(3760,3,1,100,'2023-01-24 07:40:00','2023-01-24 07:50:00',600,'Riavvio servizi di posta per problemi su iPhone',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-06 08:28:10','2023-01-24'),
(3761,3,1,104,'2023-01-24 08:10:00','2023-01-24 08:25:00',900,'Configurata nuova sim Fastweb per navigazione su portile agente',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-01-26 16:03:44','2023-01-24'),
(3762,3,1,43,'2023-01-24 08:25:00','2023-01-24 08:35:00',600,'Assistenza su pc client Romina per problemi di stampa',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-03 08:34:52','2023-01-24'),
(3763,3,1,5,'2023-01-24 08:40:00','2023-01-24 09:10:00',1800,'Assistenza per ripristino servizio vpn e configurazione port forwarding dopo spostamento server e cambio router',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-06-26 16:24:51','2023-01-24'),
(3764,3,1,56,'2023-01-24 15:45:00','2023-01-24 16:45:00',3600,'Assistenza su pc client Federica per ripristino stampante Adobe, problema da risolvere',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-13 15:07:30','2023-01-24'),
(3765,3,1,22,'2023-01-24 17:00:00','2023-01-24 17:40:00',2400,'Assistenza per recupero password firewall Zyxel + apertura porte per download torrent',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-09 11:00:57','2023-01-24'),
(3766,1,4,3,'2023-01-25 10:12:00','2023-01-25 10:44:00',1920,'portatile non bootta',24,NULL,45,1,'Europe/Rome',24,1,'work','2023-01-27 13:00:47','2023-01-25'),
(3767,3,2,117,'2023-01-25 10:10:00','2023-01-25 10:45:00',2100,'Riconsegnato e configurato pc client + installazione switch zyxel 8 porte gigabit, assistenza su PC client nell\'ufficio di Simona',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-01-31 11:04:14','2023-01-25'),
(3768,1,1,96,'2023-01-25 14:37:00','2023-01-25 14:56:42',1182,'problema tomcat',14.78,NULL,45,1,'Europe/Rome',14.78,1,'work','2023-02-06 09:28:55','2023-01-25'),
(3769,1,4,3,'2023-01-25 13:24:00','2023-01-25 14:00:00',2160,'portatile non bootta',27,NULL,45,1,'Europe/Rome',27,1,'work','2023-01-27 13:00:46','2023-01-25'),
(3770,1,1,26,'2023-01-25 15:52:00','2023-01-25 15:56:00',240,'problemi invio mail dott sola',3,NULL,45,1,'Europe/Rome',3,1,'work','2023-02-22 10:37:00','2023-01-25'),
(3771,1,1,2,'2023-01-12 08:40:00','2023-01-12 10:14:00',5640,'agg varie',70.5,NULL,45,1,'Europe/Rome',70.5,1,'work','2023-04-06 08:43:17','2023-01-12'),
(3772,1,1,50,'2023-01-12 13:40:00','2023-01-12 14:28:00',2880,'verifca spazio disco dopo puilizia',36,NULL,45,1,'Europe/Rome',36,1,'work','2023-02-03 09:19:25','2023-01-12'),
(3773,1,1,50,'2023-01-12 16:53:00','2023-01-12 17:28:00',2100,'agg proxmox',26.25,NULL,45,1,'Europe/Rome',26.25,1,'work','2023-02-03 09:19:45','2023-01-12'),
(3774,1,1,2,'2023-01-13 15:00:00','2023-01-13 15:36:00',2160,'verifica proxy per abilitazione whatsapp',27,NULL,45,1,'Europe/Rome',27,1,'work','2023-04-06 08:43:24','2023-01-13'),
(3775,1,1,67,'2023-01-16 08:46:00','2023-01-16 11:21:00',9300,'verifica stato per import mail',116.25,NULL,45,1,'Europe/Rome',116.25,1,'work','2023-02-03 10:10:13','2023-01-16'),
(3776,1,1,103,'2023-01-20 08:28:00','2023-01-20 11:00:00',9120,'agg server',114,NULL,45,1,'Europe/Rome',114,1,'work','2023-02-28 08:29:09','2023-01-20'),
(3777,1,1,95,'2023-01-20 15:00:00','2023-01-20 15:31:00',1860,'prep server vecchio a spegnimenjto',23.25,NULL,45,1,'Europe/Rome',23.25,1,'work','2023-02-28 10:37:51','2023-01-20'),
(3778,3,2,29,'2023-01-26 10:30:00','2023-01-26 10:50:00',1200,'Sostituzione batteria bios su PC client studio verde',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-22 10:06:32','2023-01-26'),
(3779,1,1,90,'2023-01-26 11:12:00','2023-01-26 11:34:41',1361,'config ufficius',17.01,NULL,45,1,'Europe/Rome',17.01,1,'work','2023-04-06 09:39:06','2023-01-26'),
(3780,3,2,1,'2023-01-26 11:25:00','2023-01-26 11:35:00',600,'Verificati collegamenti telefonici nella sede di Borzoli',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-01-27 11:30:50','2023-01-26'),
(3781,3,2,24,'2023-01-26 13:30:00','2023-01-26 13:40:00',600,'Consegnate 2 cartucce originali nere per stampanti Epson',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-01-26 14:58:10','2023-01-26'),
(3782,3,1,108,'2023-01-26 14:10:00','2023-01-26 14:30:00',1200,'Create 2 nuove mail, chiuse 2 vecchi indirizzi di posta',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-17 09:52:05','2023-01-26'),
(3783,3,2,104,'2023-01-26 15:10:00','2023-01-26 15:20:00',600,'Consegnato alimentatore originale portatile Daniele',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-09 14:11:13','2023-01-26'),
(3784,1,2,95,'2023-01-26 15:28:00','2023-01-26 18:00:00',9120,'Sistemazione armadio ocn fede',114,NULL,45,1,'Europe/Rome',114,1,'work','2023-03-14 15:47:39','2023-01-26'),
(3785,1,1,95,'2023-01-27 09:48:00','2023-01-27 11:28:00',6000,'problemi ora e profili',75,NULL,45,1,'Europe/Rome',75,1,'work','2023-02-28 10:48:12','2023-01-27'),
(3786,1,1,95,'2023-01-27 13:43:00','2023-01-27 15:46:00',7380,'problemi ora e profili',92.25,NULL,45,1,'Europe/Rome',92.25,1,'work','2023-02-28 10:48:13','2023-01-27'),
(3787,3,2,95,'2023-01-27 07:30:00','2023-01-27 08:00:00',1800,'Assistenza in loco per problemi di navigazione',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-14 15:47:39','2023-01-27'),
(3788,3,1,50,'2023-01-27 14:15:00','2023-01-27 14:55:00',2400,'Assistenza su portatile casa Loretta per problemi con stampante HP',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-03 09:19:23','2023-01-27'),
(3789,3,1,53,'2023-01-27 15:55:00','2023-01-27 16:40:00',2700,'Assistenza su pc client Simona e Tino per problemisincronizzazione Google Drive',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-09 11:22:25','2023-01-27'),
(3790,1,3,112,'2023-01-27 15:48:00','2023-01-27 17:30:00',6120,NULL,76.5,NULL,45,1,'Europe/Rome',76.5,1,'work','2023-03-08 17:14:45','2023-01-27'),
(3791,1,1,95,'2023-01-30 09:03:00','2023-01-30 09:45:00',2520,'problemi ora e profili',31.5,NULL,45,1,'Europe/Rome',31.5,1,'work','2023-02-28 10:48:14','2023-01-30'),
(3792,1,1,124,'2023-01-27 07:46:00','2023-01-27 09:30:00',6240,'reset nas loro, copia backup e verifica accesso ai dati',78,NULL,45,1,'Europe/Rome',78,1,'work','2023-02-24 16:44:46','2023-01-27'),
(3793,3,1,53,'2023-01-30 08:00:00','2023-01-30 08:20:00',1200,'Risolto problema sincronizzazione Google Drive su pc client Simona',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-09 11:22:26','2023-01-30'),
(3794,3,1,2,'2023-01-30 10:40:00','2023-01-30 10:55:00',900,'Installate 2 licenze nod32 su 4 pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-03 08:56:25','2023-01-30'),
(3795,3,1,87,'2023-01-30 10:55:00','2023-01-30 11:05:00',600,'Installata 1 licenza nod32 su 2 pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-01 16:31:05','2023-01-30'),
(3796,3,1,50,'2023-01-30 11:05:00','2023-01-30 11:20:00',900,'Installate 2 licenze nod32 su 3 pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-03 09:19:15','2023-01-30'),
(3797,3,1,96,'2023-01-30 13:35:00','2023-01-30 13:45:00',600,'Assistenza su pc client Maria per problemi audio',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-06 09:29:07','2023-01-30'),
(3798,3,1,43,'2023-01-30 15:20:00','2023-01-30 15:30:00',600,'Installato file .bat su pc client Romina per ripulire spool di stampa',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-03 08:34:53','2023-01-30'),
(3799,1,1,2,'2023-01-30 07:46:00','2023-01-30 09:00:00',4440,'win2008 su hyperv',55.5,NULL,45,1,'Europe/Rome',55.5,1,'work','2023-04-06 08:43:07','2023-01-30'),
(3800,1,1,2,'2023-01-30 10:04:00','2023-01-30 11:29:00',5100,'win2008 su hyperv',63.75,NULL,45,1,'Europe/Rome',63.75,1,'work','2023-04-06 08:43:28','2023-01-30'),
(3801,1,1,95,'2023-01-31 09:50:00','2023-01-31 10:47:00',3420,'problemi ora e profili',42.75,NULL,45,1,'Europe/Rome',42.75,1,'work','2023-02-28 10:48:15','2023-01-31'),
(3802,1,1,26,'2023-01-31 10:50:00','2023-01-31 11:29:00',2340,'problemi posta banci',29.25,NULL,45,1,'Europe/Rome',29.25,1,'work','2023-02-22 10:36:58','2023-01-31'),
(3803,3,2,51,'2023-01-31 11:00:00','2023-01-31 11:25:00',1500,'Verificato e ritirato tablet e dispositivo per ecografia',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-07 10:33:34','2023-01-31'),
(3804,1,1,114,'2022-12-15 13:48:00','2022-12-15 14:57:00',4140,'varie per preventivi er problemi vpn gabriele',51.75,NULL,45,1,'Europe/Rome',51.75,1,'work','2023-02-09 16:58:36','2022-12-15'),
(3805,1,1,57,'2022-12-28 07:48:00','2022-12-28 09:35:00',6420,'problemi su raid',80.25,NULL,45,1,'Europe/Rome',80.25,1,'work','2023-02-24 11:12:07','2022-12-28'),
(3806,3,2,79,'2023-01-31 14:35:00','2023-01-31 15:50:00',4500,'Assistenza su stampante Brother magazzino \r\nSpostata postazione client Paola Colladon',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-03 10:56:33','2023-01-31'),
(3807,1,1,26,'2023-01-31 14:50:00','2023-01-31 18:30:00',13200,'problemi posta banci',165,NULL,45,1,'Europe/Rome',165,1,'work','2023-02-22 10:37:01','2023-01-31'),
(3808,1,1,2,'2023-01-31 07:49:00','2023-01-31 09:39:00',6600,'win2008 hyper v',82.5,NULL,45,1,'Europe/Rome',82.5,1,'work','2023-04-06 08:43:07','2023-01-31'),
(3809,1,1,51,'2023-01-31 13:45:00','2023-01-31 14:40:00',3300,'test dispositivo con tablet connessione wifi',41.25,NULL,45,1,'Europe/Rome',41.25,1,'work','2023-02-07 10:33:34','2023-01-31'),
(3810,3,1,79,'2023-01-31 07:40:00','2023-01-31 09:00:00',4800,'Assistenza su pc client Elena per problema file pst corrotto su Outlook',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-03 10:56:37','2023-01-31'),
(3811,3,1,56,'2023-01-31 09:00:00','2023-01-31 09:30:00',1800,'Assistenza su pc client Federica per configurare attività pianificata su MailStore + stampante PDF',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-13 15:07:30','2023-01-31'),
(3812,3,1,55,'2023-01-31 09:30:00','2023-01-31 09:45:00',900,'Installate 2 licenze nod32 aggiornamento su 4 pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-03 08:31:34','2023-01-31'),
(3813,3,1,26,'2023-01-31 10:00:00','2023-01-31 10:10:00',600,'Assistenza su pc casa Sola',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-22 10:36:58','2023-01-31'),
(3814,3,1,79,'2023-01-31 13:45:00','2023-01-31 14:15:00',1800,'Assistenza su pc client Magazzino per problemi stampante Brother, da verificare in loco',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-03 10:22:23','2023-01-31'),
(3815,1,4,3,'2023-02-01 07:30:00','2023-02-01 07:45:00',900,'riportato tablet e sonda fremslife',11.25,NULL,45,1,'Europe/Rome',11.25,1,'work','2023-02-09 17:23:15','2023-02-01'),
(3816,1,1,2,'2023-02-01 07:58:00','2023-02-01 08:30:00',1920,'win2008 su hyperv non funziona',24,NULL,45,1,'Europe/Rome',24,1,'work','2023-04-06 08:43:34','2023-02-01'),
(3817,1,6,26,'2023-02-01 08:33:00','2023-02-01 08:45:00',720,'punto situazione migrazione',9,NULL,45,1,'Europe/Rome',9,1,'work','2023-02-17 11:23:21','2023-02-01'),
(3818,1,1,2,'2023-01-16 16:23:00','2023-01-16 17:27:00',3840,'agg nas, problema telecameree powerpoint',48,NULL,45,1,'Europe/Rome',48,1,'work','2023-04-06 08:43:29','2023-01-16'),
(3819,1,3,112,'2023-01-25 07:30:00','2023-01-25 10:10:00',9600,'donato sangue',120,NULL,45,1,'Europe/Rome',120,1,'work','2023-03-08 17:14:43','2023-01-25'),
(3820,1,1,96,'2023-01-25 16:08:00','2023-01-25 17:30:00',4920,'problemi tomcat',61.5,NULL,45,1,'Europe/Rome',61.5,1,'work','2023-02-06 09:29:05','2023-01-25'),
(3821,1,1,95,'2023-01-26 07:48:00','2023-01-26 09:33:00',6300,'preparazione vm a export su nuovo server',78.75,NULL,45,1,'Europe/Rome',78.75,1,'work','2023-02-28 10:41:27','2023-01-26'),
(3822,1,1,1,'2023-01-26 09:53:00','2023-01-26 10:58:00',3900,'agg server',48.75,NULL,45,1,'Europe/Rome',48.75,1,'work','2023-03-17 10:59:08','2023-01-26'),
(3823,1,1,2,'2023-01-26 13:43:00','2023-01-26 15:05:00',4920,'test su win2k8 su vm',61.5,NULL,45,1,'Europe/Rome',61.5,1,'work','2023-04-06 08:43:15','2023-01-26'),
(3824,1,1,2,'2023-02-01 14:20:00','2023-02-01 14:37:58',1078,'config mail tel francesca',13.48,NULL,45,1,'Europe/Rome',13.48,1,'work','2023-04-06 08:43:28','2023-02-01'),
(3825,1,1,26,'2023-02-01 09:00:00','2023-02-01 11:28:00',8880,'posta banci',111,NULL,45,1,'Europe/Rome',111,1,'work','2023-02-22 10:36:53','2023-02-01'),
(3826,3,1,24,'2023-02-01 08:35:00','2023-02-01 09:15:00',2400,'Assistenza su posta per problema invio mail ad indirizzi gmail',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-06 18:15:55','2023-02-01'),
(3827,3,2,59,'2023-02-01 09:40:00','2023-02-01 09:50:00',600,'Ritirato pc client per possibile upgrade hw e sw',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-07-20 16:02:54','2023-02-01'),
(3828,3,1,45,'2023-02-01 10:05:00','2023-02-01 10:20:00',900,'Installata e configurata vpn + collegamento rdp per lavorare con WinPer su portatile casa Claudio Rossi',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-16 17:12:52','2023-02-01'),
(3829,3,1,75,'2023-02-01 10:20:00','2023-02-01 10:40:00',1200,'Assistenza su pc client Federico per problemi stampante + configurazione mail',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-08 10:42:24','2023-02-01'),
(3830,1,1,26,'2023-02-01 14:40:00','2023-02-01 17:23:00',9780,'posta banci',122.25,NULL,45,1,'Europe/Rome',122.25,1,'work','2023-02-22 10:36:55','2023-02-01'),
(3831,3,1,50,'2023-02-01 10:40:00','2023-02-01 10:50:00',600,'Assistenza su pc client Filippo per problemi formattazione quando scrive mail',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-03 09:19:24','2023-02-01'),
(3832,3,1,108,'2023-02-01 15:45:00','2023-02-01 15:55:00',600,'Assistenza su pc client Biglietteria',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-17 09:52:07','2023-02-01'),
(3833,1,2,3,'2023-02-02 08:47:00','2023-02-02 09:20:00',1980,'Studio Legale F&L nuovo cliente passato da inkout incontro per vedere problemi che ha e come risolverli',24.75,NULL,45,1,'Europe/Rome',24.75,1,'work','2023-02-09 17:23:16','2023-02-02'),
(3834,1,2,114,'2023-02-02 09:45:00','2023-02-02 10:20:00',2100,'Incontro per discutere di varie problematiche e di come risolverle',26.25,NULL,45,1,'Europe/Rome',26.25,1,'work','2023-02-09 16:25:27','2023-02-02'),
(3835,1,4,3,'2023-02-02 07:30:00','2023-02-02 08:00:00',1800,'fatto vedere a fede come funziona dkim spf dmarc',22.5,NULL,45,1,'Europe/Rome',22.5,1,'work','2023-02-09 17:23:15','2023-02-02'),
(3836,1,1,2,'2023-02-02 13:49:00','2023-02-02 14:23:00',2040,'vpn su portatile francesca, non è possibile configurare perchè l\'utente non è amministratore',25.5,NULL,45,1,'Europe/Rome',25.5,1,'work','2023-04-06 08:43:11','2023-02-02'),
(3837,3,2,59,'2023-02-02 15:45:00','2023-02-02 16:00:00',900,'Consegnato e ricollegato pc client dopo assistenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-07-20 16:02:59','2023-02-02'),
(3838,3,2,124,'2023-02-02 16:10:00','2023-02-02 16:50:00',2400,'Riconsegnato e configurato pc client dopo aggiornamenti hw e sw',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-24 16:44:49','2023-02-02'),
(3839,3,1,96,'2023-02-02 08:15:00','2023-02-02 08:30:00',900,'Assistenza per problemi ad accedere ad AGO e MIP',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-17 11:08:44','2023-02-02'),
(3840,3,1,22,'2023-02-02 08:30:00','2023-02-02 09:00:00',1800,'Assistenza su pc casa padre per problemi collegamento in vpn',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-09 11:00:54','2023-02-02'),
(3841,3,2,124,'2023-02-02 09:15:00','2023-02-02 09:40:00',1500,'Ritirato pc client per aggiornamenti hw e sw',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-24 16:44:45','2023-02-02'),
(3842,3,4,124,'2023-02-02 10:00:00','2023-02-02 11:00:00',3600,'Assistenza su pc client ritirato, installato ssd PNY da 1 tb + 8gb ram ddr3 usata. Clonato s.o su nuovo ssd + agg. a Windows 11',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-24 16:44:47','2023-02-02'),
(3843,3,1,108,'2023-02-02 11:25:00','2023-02-02 11:40:00',900,'Assistenza su pc client Consuelo per problemi posta + configurazione 2 nuovi indirizzi mail',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-17 09:52:04','2023-02-02'),
(3844,3,4,59,'2023-02-02 13:30:00','2023-02-02 14:30:00',3600,'Assistenza su pc client con Windows XP, montata 1gb ram DDR usata',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-07-20 16:02:55','2023-02-02'),
(3845,3,2,24,'2023-02-03 13:30:00','2023-02-03 13:40:00',600,'Consegnate cartucce originali stampanti Epson',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-07 09:08:40','2023-02-03'),
(3846,1,1,2,'2023-02-06 07:50:00','2023-02-06 08:12:00',1320,'problemi connessione vpn fra su nuovo portatile',16.5,NULL,45,1,'Europe/Rome',16.5,1,'work','2023-04-06 08:43:22','2023-02-06'),
(3847,1,1,95,'2023-02-06 08:29:00','2023-02-06 08:32:29',209,'problema mara vpn',2.61,NULL,45,1,'Europe/Rome',2.61,1,'work','2023-03-14 10:29:18','2023-02-06'),
(3848,1,1,26,'2023-02-06 14:09:00','2023-02-06 17:25:00',11760,'per problemi vpn fortigate\r\nRiconfigurazione samba e creazione nuovi share.',147,NULL,45,1,'Europe/Rome',147,1,'work','2023-02-22 10:36:58','2023-02-06'),
(3849,1,1,26,'2023-02-07 07:49:00','2023-02-07 09:33:32',6272,'configurazione pc simone per autenticazione samba\r\ntest utenti nuovi su samba',78.4,NULL,45,1,'Europe/Rome',78.4,1,'work','2023-02-22 10:36:54','2023-02-07'),
(3851,1,1,1,'2023-02-07 13:52:00','2023-02-07 17:23:05',12665,'configurazione snom e patton borzoli fede li',158.31,NULL,45,1,'Europe/Rome',158.31,1,'work','2023-02-09 17:08:15','2023-02-07'),
(3852,3,2,1,'2023-02-07 13:40:00','2023-02-07 16:20:00',9600,'Consegna, installazione e configurazione Patton SmartNode 4112 usato + cordless e telefono scommesse\r\nUtilizzati: 2 cavi alim. Ups + 1 cavo LAN da 2mt',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-09 17:08:14','2023-02-07'),
(3853,3,1,51,'2023-02-07 11:05:00','2023-02-07 11:20:00',900,'Assistenza su pc client Zamparo per problemi su Outlook',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-05-19 13:55:07','2023-02-07'),
(3854,3,1,57,'2023-02-07 11:20:00','2023-02-07 11:40:00',1200,'Configurata vpn su nuovo portatile, da finire in loco',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-24 15:23:48','2023-02-07'),
(3855,3,2,66,'2023-02-08 08:30:00','2023-02-08 08:50:00',1200,'Sostituzione 2 batterie su UPS APC 1400',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-10 16:05:55','2023-02-08'),
(3856,1,1,1,'2023-02-08 07:20:00','2023-02-08 09:03:00',6180,'problema 3cx non risponde, aggiornamento vbox, aggiornamento vboxservices, aggiornamento server windows',77.25,NULL,45,1,'Europe/Rome',77.25,1,'work','2023-03-17 10:38:38','2023-02-08'),
(3857,1,1,26,'2023-02-08 09:04:00','2023-02-08 10:00:15',3375,'problemi accesso share marco',42.19,NULL,45,1,'Europe/Rome',42.19,1,'work','2023-02-22 10:36:55','2023-02-08'),
(3858,3,2,57,'2023-02-08 09:15:00','2023-02-08 11:00:00',6300,'Installata e configurata vpn su nuovi portatili Mac\r\nAssistenza su Mac Client',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-24 15:23:49','2023-02-08'),
(3859,3,2,114,'2023-02-08 11:10:00','2023-02-08 11:25:00',900,'Ritirato raspberry per prove',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-10 14:14:52','2023-02-08'),
(3860,1,2,108,'2023-02-08 10:46:00','2023-02-08 11:49:00',3780,'problemi pc consuelo non naviga, parlato per l\'acquisto del server nuovo',47.25,NULL,45,1,'Europe/Rome',47.25,1,'work','2023-03-17 09:13:18','2023-02-08'),
(3861,1,1,108,'2023-02-08 13:48:00','2023-02-08 15:28:00',6000,'problemi pc eventi',75,NULL,45,1,'Europe/Rome',75,1,'work','2023-03-17 09:51:57','2023-02-08'),
(3862,1,1,3,'2023-02-08 15:35:00','2023-02-08 16:23:51',2931,'problemi navigazione in lab',36.64,NULL,45,1,'Europe/Rome',36.64,1,'work','2023-02-09 17:23:18','2023-02-08'),
(3863,1,1,3,'2023-02-08 16:25:00','2023-02-08 16:44:00',1140,'fogli',14.25,NULL,45,1,'Europe/Rome',14.25,1,'work','2023-02-09 17:23:19','2023-02-08'),
(3864,1,1,114,'2023-02-09 07:46:00','2023-02-09 09:33:00',6420,'studio raspberry  e totem',80.25,NULL,45,1,'Europe/Rome',80.25,1,'work','2023-03-10 14:14:52','2023-02-09'),
(3865,1,1,114,'2023-02-09 13:44:00','2023-02-09 14:20:00',2160,'studio raspberry  e totem',27,NULL,45,1,'Europe/Rome',27,1,'work','2023-03-10 14:14:56','2023-02-09'),
(3866,1,1,95,'2023-02-09 09:46:00','2023-02-09 11:00:00',4440,'problemi uso ram server',55.5,NULL,45,1,'Europe/Rome',55.5,1,'work','2023-02-28 10:48:08','2023-02-09'),
(3867,3,2,41,'2023-02-09 10:05:00','2023-02-09 10:15:00',600,'Consegnati 5 ssd da 480gb S3+ e supporti ssd',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-06 09:21:34','2023-02-09'),
(3868,3,1,95,'2023-02-09 10:20:00','2023-02-09 10:30:00',600,'Assistenza su pc client Anna per cancellare cache Chrome e Java',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-14 15:47:42','2023-02-09'),
(3869,3,1,96,'2023-02-09 14:20:00','2023-02-09 14:30:00',600,'Riavviati servizi tomcat per aggiornamenti AGO e MIP',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-17 11:08:45','2023-02-09'),
(3870,3,6,108,'2023-02-09 16:15:00','2023-02-09 16:25:00',600,'Il client ha annullato l\'intervento mentre stavo arrivando lì',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-17 09:52:04','2023-02-09'),
(3871,3,1,117,'2023-02-08 14:00:00','2023-02-08 14:15:00',900,'Assistenza su pc client Raffaella per installare stampante e scanner',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-23 10:41:34','2023-02-08'),
(3872,3,1,51,'2023-02-08 14:20:00','2023-02-08 15:40:00',4800,'Assistenza su pc client Andrea Zamparo per problemi sulla ricerca di Outlook',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-05-19 13:55:08','2023-02-08'),
(3873,3,1,50,'2023-02-09 15:45:00','2023-02-09 16:05:00',1200,'Assistenza su portatile Loretta per problemi navigazione',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-15 11:00:03','2023-02-09'),
(3874,1,6,104,'2023-02-09 11:10:00','2023-02-09 11:23:00',780,NULL,9.75,NULL,45,1,'Europe/Rome',9.75,1,'work','2023-03-22 10:16:05','2023-02-09'),
(3875,1,1,95,'2023-02-09 16:08:00','2023-02-09 17:27:00',4740,'problemi uso ram server',59.25,NULL,45,1,'Europe/Rome',59.25,1,'work','2023-02-28 10:48:04','2023-02-09'),
(3876,1,1,1,'2023-02-10 09:30:00','2023-02-10 11:24:00',6840,'problemi 3cx su cel e su app',85.5,NULL,45,1,'Europe/Rome',85.5,1,'work','2023-03-17 10:37:07','2023-02-10'),
(3877,1,1,1,'2023-02-10 13:35:00','2023-02-10 14:03:00',1680,'problemi 3cx su cel e su app',21,NULL,45,1,'Europe/Rome',21,1,'work','2023-03-17 10:37:08','2023-02-10'),
(3878,1,1,50,'2023-02-10 14:10:00','2023-02-10 14:48:00',2280,'agg 3cx e firmware teelfoni',28.5,NULL,45,1,'Europe/Rome',28.5,1,'work','2023-02-15 11:00:04','2023-02-10'),
(3879,1,1,24,'2023-02-10 14:50:00','2023-02-10 15:26:00',2160,'agg 3cx e firmware telefoni',27,NULL,45,1,'Europe/Rome',27,1,'work','2023-03-06 18:06:46','2023-02-10'),
(3880,1,1,88,'2023-02-10 15:40:00','2023-02-10 16:23:00',2580,'agg 3cx e firmware teelfoni',32.25,NULL,45,1,'Europe/Rome',32.25,1,'work','2023-04-06 08:47:26','2023-02-10'),
(3881,1,1,96,'2023-02-10 16:30:00','2023-02-10 17:10:00',2400,'agg 3cx e firmware telefoni',30,NULL,45,1,'Europe/Rome',30,1,'work','2023-02-17 09:55:59','2023-02-10'),
(3882,1,1,110,'2023-02-09 14:41:00','2023-02-09 15:20:00',2340,'agg 3cx',29.25,NULL,45,1,'Europe/Rome',29.25,1,'work','2023-04-06 16:19:38','2023-02-09'),
(3883,1,1,3,'2023-02-09 15:28:00','2023-02-09 16:05:00',2220,'agg 3cx',27.75,NULL,45,1,'Europe/Rome',27.75,1,'work','2023-03-15 16:22:29','2023-02-09'),
(3884,3,1,1,'2023-02-10 08:35:00','2023-02-10 09:35:00',3600,'Assistenza per problemi su 3cx',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-17 10:37:05','2023-02-10'),
(3885,3,1,22,'2023-02-10 13:55:00','2023-02-10 14:10:00',900,'Assistenza su pc client padre',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-09 11:00:56','2023-02-10'),
(3886,3,1,50,'2023-02-10 16:30:00','2023-02-10 16:40:00',600,'Assistenza su pc client Loretta',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-15 11:00:05','2023-02-10'),
(3887,1,1,17,'2023-02-10 07:44:00','2023-02-10 08:17:00',1980,'agg nas',24.75,NULL,45,1,'Europe/Rome',24.75,1,'work','2023-03-06 19:02:56','2023-02-10'),
(3888,1,1,3,'2023-02-10 08:24:00','2023-02-10 08:54:00',1800,'agg nas nostro',22.5,NULL,45,1,'Europe/Rome',22.5,1,'work','2023-03-15 16:22:31','2023-02-10'),
(3889,1,4,75,'2023-02-10 08:55:00','2023-02-10 09:29:00',2040,'agg nas',25.5,NULL,45,1,'Europe/Rome',25.5,1,'work','2023-04-06 16:18:35','2023-02-10'),
(3890,3,2,96,'2023-02-13 09:10:00','2023-02-13 10:10:00',3600,'Verificato e ritirato pc client Maria per assistenza \r\nPulizia pc client da polvere, ritirato ups per assistenza \r\nConsegna toner Brother originale',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-17 11:08:46','2023-02-13'),
(3891,3,2,2,'2023-02-13 10:30:00','2023-02-13 10:50:00',1200,'Verificato e ritirato ups apc 700 pc client Andrea \r\nRitirato vecchio PC client Botta da verificare',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-06 08:43:25','2023-02-13'),
(3892,3,1,75,'2023-02-13 13:40:00','2023-02-13 13:50:00',600,'Assistenza su pc client Federico per pulizia coda di stampa',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-06 16:18:39','2023-02-13'),
(3893,3,1,26,'2023-02-13 13:55:00','2023-02-13 14:20:00',1500,'Assistenza su pc client Simona per configurazione firma su mail presidenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-22 10:36:55','2023-02-13'),
(3894,3,1,67,'2023-02-13 16:30:00','2023-02-13 17:30:00',3600,'Assistenza su pc client Massimo Serra per riconfigurazione posta, da finire recupero mail indirizzo massimo.serra@mediamaxtlc.it',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-10 16:39:48','2023-02-13'),
(3895,3,1,67,'2023-02-14 07:30:00','2023-02-14 08:30:00',3600,'Finito lavoro configurazione e recupero mail su pc client Massimo Serra',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-10 16:39:48','2023-02-14'),
(3896,3,2,104,'2023-02-14 08:50:00','2023-02-14 09:05:00',900,'Assistenza su iPad e iPhone per problemi ricezione posta',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-22 11:08:33','2023-02-14'),
(3897,3,4,96,'2023-02-14 09:30:00','2023-02-14 10:30:00',3600,'Assistenza su pc client Maria',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-17 11:08:47','2023-02-14'),
(3898,3,1,95,'2023-02-14 13:50:00','2023-02-14 14:20:00',1800,'Verificati problemi lentezza e spazio su server, lavoro da chiudere',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-28 10:48:00','2023-02-14'),
(3899,3,2,79,'2023-02-14 14:40:00','2023-02-14 14:50:00',600,'Consegna toner Brother originali TN243',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-17 09:39:52','2023-02-14'),
(3900,3,1,24,'2023-02-14 15:05:00','2023-02-14 16:05:00',3600,'Assistenza su pc client Monica per problemi con creeazione xml da pdf',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-06 18:15:56','2023-02-14'),
(3901,3,1,125,'2023-02-14 16:40:00','2023-02-14 17:30:00',3000,'Assistenza per problemi posta dopo migrazione dominio',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-23 15:54:45','2023-02-14'),
(3902,3,1,22,'2023-02-15 10:00:00','2023-02-15 10:10:00',600,'Assistenza su pc client padre',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-09 11:00:51','2023-02-15'),
(3903,3,1,85,'2023-02-15 15:15:00','2023-02-15 15:30:00',900,'Assistenza per problemi mail che tornano indietro',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-30 15:13:04','2023-02-15'),
(3904,3,1,67,'2023-02-15 15:30:00','2023-02-15 15:40:00',600,'Assistenza per problema dominio sotto blacklist',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-10 16:39:49','2023-02-15'),
(3905,3,1,96,'2023-02-15 15:40:00','2023-02-15 15:55:00',900,'Assistenza su pc client Maria provvisorio per coonfigurazione posta',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-17 11:08:48','2023-02-15'),
(3906,3,2,96,'2023-02-16 11:15:00','2023-02-16 13:45:00',9000,'Risistemate postazioni client Maria e Marilena\r\nConsegnato e configurato pc client Maria dopo assistenza, riconsegnato ups apc dopo assistenza \r\nAssistenza su PC client Ingresso e Federica',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-17 11:08:50','2023-02-16'),
(3907,3,1,96,'2023-02-16 16:30:00','2023-02-16 16:40:00',600,'Assistenza su pc client Irene per creazione utente Desktop Telematico',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-17 11:08:51','2023-02-16'),
(3908,1,1,125,'2023-02-17 13:44:00','2023-02-17 14:50:00',3960,'cliente casanuda per problemi domini',49.5,NULL,45,1,'Europe/Rome',49.5,1,'work','2023-02-23 15:54:46','2023-02-17'),
(3909,3,2,79,'2023-02-20 08:25:00','2023-02-20 10:00:00',5700,'Consegna, installazione e configurazione nuova stampante Brother MFC L8900CDW, spostata stampante Brother DCP L3550CDW da Contabilità a Magazzino + configurazione, ritirato stampante Brother DCP L3550CDW per conto vendita',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-04 08:29:44','2023-02-20'),
(3910,3,1,26,'2023-02-20 10:30:00','2023-02-20 11:05:00',2100,'Configurate e inviate nuove chiavi vpn',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-22 09:15:24','2023-02-20'),
(3911,3,2,67,'2023-02-20 14:30:00','2023-02-20 18:10:00',13200,'Collegato e configurato nuovo Firewall + nuova configurazione su nostro vecchio firewall',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-10 16:39:50','2023-02-20'),
(3912,1,1,95,'2023-02-15 19:30:00','2023-02-15 21:00:00',5400,'lamentano lentezza accesso share pulizia e ottimizzazione vm',67.5,NULL,45,1,'Europe/Rome',67.5,1,'work','2023-02-28 10:47:56','2023-02-15'),
(3913,1,3,112,'2023-02-17 07:30:00','2023-02-17 11:30:00',14400,'rientro da sardegna ferie',180,NULL,45,1,'Europe/Rome',180,1,'work','2023-03-08 17:14:48','2023-02-17'),
(3914,1,1,90,'2023-02-17 15:04:00','2023-02-17 18:00:00',10560,'migrazione share',132,NULL,45,1,'Europe/Rome',132,1,'work','2023-05-03 10:03:26','2023-02-17'),
(3915,1,1,90,'2023-02-20 07:52:00','2023-02-20 10:29:00',9420,'migrazione share',117.75,NULL,45,1,'Europe/Rome',117.75,1,'work','2023-05-03 10:03:27','2023-02-20'),
(3916,1,1,125,'2023-02-20 15:50:00','2023-02-20 17:30:00',6000,'casanuda problemi dominio',75,NULL,45,1,'Europe/Rome',75,1,'work','2023-02-23 15:54:47','2023-02-20'),
(3917,1,1,67,'2023-02-20 13:49:00','2023-02-20 14:40:00',3060,'fede li aiutato nella migrazione firwall',38.25,NULL,45,1,'Europe/Rome',38.25,1,'work','2023-03-10 16:39:51','2023-02-20'),
(3918,1,1,88,'2023-02-20 14:50:00','2023-02-20 15:43:00',3180,'segnalati problemi posta dall\'esterno',39.75,NULL,45,1,'Europe/Rome',39.75,1,'work','2023-04-06 09:19:22','2023-02-20'),
(3919,1,1,90,'2023-02-21 07:55:00','2023-02-21 08:14:00',1140,'problemi vm luciano accesso nuovo server',14.25,NULL,45,1,'Europe/Rome',14.25,1,'work','2023-05-03 10:03:03','2023-02-21'),
(3920,3,2,12,'2023-02-21 09:10:00','2023-02-21 09:45:00',2100,'Verificati e ritirati 2 pc client per assistenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-03 14:36:34','2023-02-21'),
(3921,3,6,79,'2023-02-21 09:45:00','2023-02-21 09:55:00',600,'Assistenza a Silvia per scansione su nuova stampante Brother',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-04 07:29:39','2023-02-21'),
(3922,1,1,95,'2023-02-21 08:22:00','2023-02-21 09:45:00',4980,'problema lentezza client',62.25,NULL,45,1,'Europe/Rome',62.25,1,'work','2023-03-14 10:37:38','2023-02-21'),
(3923,1,1,1,'2023-02-21 10:00:00','2023-02-21 10:33:54',2034,'problema stampante succursale',25.43,NULL,45,1,'Europe/Rome',25.43,1,'work','2023-03-17 10:37:56','2023-02-21'),
(3924,3,2,96,'2023-02-21 10:10:00','2023-02-21 11:10:00',3600,'Assistenza su PC client Irene per problemi su Desktop Telematico, Assistenza su PC client Anna Mochi',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-24 09:40:18','2023-02-21'),
(3925,1,1,125,'2023-02-21 13:47:00','2023-02-21 14:38:00',3060,'riconfigurazione dns su host sito posta funzionante',38.25,NULL,45,1,'Europe/Rome',38.25,1,'work','2023-02-23 15:54:48','2023-02-21'),
(3926,3,2,1,'2023-02-21 14:40:00','2023-02-21 14:55:00',900,'Assistenza su stampante HP per carta inceppata, sede Borzoli',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-17 10:59:16','2023-02-21'),
(3927,3,2,50,'2023-02-21 15:10:00','2023-02-21 15:20:00',600,'Consegna tamburo Brother originale DR3400',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-21 16:06:54','2023-02-21'),
(3928,3,1,67,'2023-02-21 07:55:00','2023-02-21 08:10:00',900,'Assistenza per problema invio email scansioni stampante dopo cambio Firewall',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-10 16:39:57','2023-02-21'),
(3929,3,1,67,'2023-02-21 13:45:00','2023-02-21 13:55:00',600,'Assistenza su pc client Massimo Serra per problemi posta dopo cambio Firewall',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-10 16:39:52','2023-02-21'),
(3930,3,4,2,'2023-02-21 16:00:00','2023-02-21 17:00:00',3600,'Reinstallato vecchio pc client Botta da riutillizzare',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-06 08:43:14','2023-02-21'),
(3931,3,2,4,'2023-02-22 08:45:00','2023-02-22 09:15:00',1800,'Assistenza su PC client Magazzino',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-06 07:57:31','2023-02-22'),
(3932,1,1,79,'2023-02-22 14:52:00','2023-02-22 16:41:18',6558,'problema posta',81.98,NULL,45,1,'Europe/Rome',81.98,1,'work','2023-04-04 08:29:30','2023-02-22'),
(3933,3,1,123,'2023-02-22 07:50:00','2023-02-22 08:05:00',900,'Collegato a pc client e Server per verifica scadenza nod32',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-24 08:51:51','2023-02-22'),
(3934,3,1,79,'2023-02-22 14:30:00','2023-02-22 14:50:00',1200,'Assistenza per problemi ricezione posta',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-04 08:29:39','2023-02-22'),
(3935,1,6,90,'2023-02-23 08:56:00','2023-02-23 09:07:00',660,'spiegato per rinominare file troppo lunghi',8.25,NULL,45,1,'Europe/Rome',8.25,1,'work','2023-05-03 10:03:12','2023-02-23'),
(3936,1,1,3,'2023-02-23 07:44:00','2023-02-23 08:46:00',3720,'verifiche 3cx per cambio mail',46.5,NULL,45,1,'Europe/Rome',46.5,1,'work','2023-03-15 16:22:19','2023-02-23'),
(3937,3,2,96,'2023-02-23 08:35:00','2023-02-23 11:10:00',9300,'Assistenza su portatile casa Maria\r\nAssistenza su PC client Maria\r\nAssistenza su PC client Marilena\r\nAssistenza su PC client Irene',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-24 09:40:20','2023-02-23'),
(3938,1,1,114,'2023-02-23 10:41:00','2023-02-23 10:46:53',353,'problema posta pop',4.41,NULL,45,1,'Europe/Rome',4.41,1,'work','2023-03-10 14:14:58','2023-02-23'),
(3939,1,1,87,'2023-02-23 09:46:00','2023-02-23 10:39:00',3180,'problema posta in uscita',39.75,NULL,45,1,'Europe/Rome',39.75,1,'work','2023-06-16 14:41:19','2023-02-23'),
(3940,1,1,95,'2023-02-23 09:08:00','2023-02-23 09:42:00',2040,'problemi posta zerocartacaf.org',25.5,NULL,45,1,'Europe/Rome',25.5,1,'work','2023-07-11 13:50:39','2023-02-23'),
(3941,1,1,3,'2023-02-22 07:48:00','2023-02-22 11:30:00',13320,'test antivirus su windows server',166.5,NULL,45,1,'Europe/Rome',166.5,1,'work','2023-03-15 16:22:23','2023-02-22'),
(3942,1,1,3,'2023-02-22 13:40:00','2023-02-22 14:36:00',3360,'test antivirus su windows server',42,NULL,45,1,'Europe/Rome',42,1,'work','2023-03-15 16:22:36','2023-02-22'),
(3943,1,1,3,'2023-02-22 16:54:00','2023-02-22 17:30:00',2160,'test antivirus su windows server',27,NULL,45,1,'Europe/Rome',27,1,'work','2023-03-15 16:22:27','2023-02-22'),
(3944,1,1,87,'2023-02-23 15:40:00','2023-02-23 16:21:21',2481,'problema mouse pc chiara',31.01,NULL,45,1,'Europe/Rome',31.01,1,'work','2023-06-20 09:26:18','2023-02-23'),
(3945,3,2,95,'2023-02-23 13:30:00','2023-02-23 13:40:00',600,'Ritirato pc client Mara per assistenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-14 15:47:42','2023-02-23'),
(3946,3,2,90,'2023-02-23 15:00:00','2023-02-23 17:10:00',7800,'Consegnato e configurato nuovo pc client, box con disco da 8tb e NAS\r\nSpostati 2 dischi da 8tb da vecchio a nuovo Server\r\nSpostata e configurata postazione client',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-05-03 10:03:13','2023-02-23'),
(3947,1,1,50,'2023-02-24 08:22:00','2023-02-24 10:59:17',9437,'autorespond',117.96,NULL,45,1,'Europe/Rome',117.96,1,'work','2023-03-10 16:00:21','2023-02-24'),
(3948,1,1,3,'2023-02-24 13:47:00','2023-02-24 14:35:00',2880,'guida postfixadmin su wiki',36,NULL,45,1,'Europe/Rome',36,1,'work','2023-03-15 16:22:23','2023-02-24'),
(3949,3,2,124,'2023-02-24 14:40:00','2023-02-24 16:40:00',7200,'Riconsegnato NAS Lenovo dopo recupero dati\r\nRipristino posta su portatile reinstallato\r\nRiconfigurazione backup periodici su 2 pc',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-24 17:04:08','2023-02-24'),
(3950,1,1,26,'2023-02-24 16:57:00','2023-02-24 17:39:29',2549,'problema share banci',31.86,NULL,45,1,'Europe/Rome',31.86,1,'work','2023-04-07 09:32:48','2023-02-24'),
(3951,1,1,90,'2023-02-24 07:45:00','2023-02-24 08:10:00',1500,'verifica stato backup',18.75,NULL,45,1,'Europe/Rome',18.75,1,'work','2023-05-03 10:03:13','2023-02-24'),
(3952,1,1,90,'2023-02-24 11:11:00','2023-02-24 11:29:00',1080,'verifica stato backup',13.5,NULL,45,1,'Europe/Rome',13.5,1,'work','2023-05-03 10:03:04','2023-02-24'),
(3953,1,1,90,'2023-02-24 14:51:00','2023-02-24 15:29:00',2280,'tentativo di connessione nas',28.5,NULL,45,1,'Europe/Rome',28.5,1,'work','2023-05-03 10:03:19','2023-02-24'),
(3954,3,2,124,'2023-02-24 16:40:00','2023-02-24 17:40:00',3600,'Assistenza su pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-27 09:24:05','2023-02-24'),
(3955,3,1,123,'2023-02-24 08:15:00','2023-02-24 08:35:00',1200,'Installate 3 licenze complete nod32 su 5 pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-07-11 14:10:47','2023-02-24'),
(3956,3,1,96,'2023-02-24 08:50:00','2023-02-24 09:05:00',900,'Installate 3 licenze nod32 aggiornamento su 5 pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-29 16:11:29','2023-02-24'),
(3957,3,1,55,'2023-02-24 10:00:00','2023-02-24 10:15:00',900,'Installate 2 licenze nod32 aggiornamento su 4 pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-28 16:14:03','2023-02-24'),
(3958,3,2,114,'2023-02-24 11:10:00','2023-02-24 11:20:00',600,'Ritirato mini pc per assistenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-10 14:14:53','2023-02-24'),
(3959,3,1,96,'2023-02-24 13:55:00','2023-02-24 14:05:00',600,'Riavviati servizi tomcat dopo aggiornamenti AGO e MIP',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-29 16:11:29','2023-02-24'),
(3960,3,2,103,'2023-02-27 08:40:00','2023-02-27 09:10:00',1800,'Verificato e ritirato pc client Tiziana per assistenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-08 16:39:59','2023-02-27'),
(3961,1,1,90,'2023-02-27 08:43:00','2023-02-27 09:22:00',2340,'test e compilazione chiavi vpn',29.25,NULL,45,1,'Europe/Rome',29.25,1,'work','2023-05-03 10:03:18','2023-02-27'),
(3962,1,1,26,'2023-02-27 07:38:00','2023-02-27 08:28:00',3000,'test e compilazione chiavi vpn caricate a simona e banci',37.5,NULL,45,1,'Europe/Rome',37.5,1,'work','2023-04-07 09:32:37','2023-02-27'),
(3963,1,1,114,'2023-02-27 09:38:00','2023-02-27 11:22:00',6240,'preparazione ambiente per test su minipc',78,NULL,45,1,'Europe/Rome',78,1,'work','2023-03-10 14:14:53','2023-02-27'),
(3964,1,1,1,'2023-02-27 15:13:00','2023-02-27 17:23:00',7800,'problemi chiamate in entrata numeri borzoli\r\nproblemi spam',97.5,NULL,45,1,'Europe/Rome',97.5,1,'work','2023-03-17 10:59:12','2023-02-27'),
(3965,1,1,114,'2023-02-27 13:42:00','2023-02-27 15:08:00',5160,'preparazione ambiente per test su minipc',64.5,NULL,45,1,'Europe/Rome',64.5,1,'work','2023-03-10 14:14:56','2023-02-27'),
(3966,3,2,95,'2023-02-27 15:50:00','2023-02-27 17:30:00',6000,'Riconsegnato e configurato pc client Mara dopo reinstallazione s.o, assistenza su PC client Porcile',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-14 15:47:41','2023-02-27'),
(3967,3,1,4,'2023-02-27 10:00:00','2023-02-27 10:15:00',900,'Assistenza su pc client Alessandra',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-06 07:57:25','2023-02-27'),
(3968,3,1,79,'2023-02-27 10:30:00','2023-02-27 10:40:00',600,'Assistenza su pc client Paola Colladon',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-04 08:29:40','2023-02-27'),
(3969,3,4,103,'2023-02-27 10:40:00','2023-02-27 11:40:00',3600,'Reinstallato s.o su pc client Tiziana che non vedeva + il disco, utilizzato ssd 1tb S3+',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-08 16:39:58','2023-02-27'),
(3970,3,4,95,'2023-02-27 13:30:00','2023-02-27 14:30:00',3600,'Reinstallato s.o su pc client Mara, utilizzato ssd PNY da 1 tb + 8 gb ddr3 ram',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-14 15:47:43','2023-02-27'),
(3971,3,2,103,'2023-02-28 08:15:00','2023-02-28 10:15:00',7200,'Riconsegna e configurazione PC client Tiziana',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-08 16:39:58','2023-02-28'),
(3972,1,3,112,'2023-02-28 10:31:00','2023-02-28 11:30:00',3540,NULL,44.25,NULL,45,1,'Europe/Rome',44.25,1,'work','2023-03-08 17:14:48','2023-02-28'),
(3973,1,1,90,'2023-02-28 07:45:00','2023-02-28 08:20:00',2100,'vpn odone non funge neanche dopo cambio chiavi',26.25,NULL,45,1,'Europe/Rome',26.25,1,'work','2023-05-03 10:03:19','2023-02-28'),
(3974,1,1,1,'2023-02-28 08:26:00','2023-02-28 09:47:00',4860,'problemi spam',60.75,NULL,45,1,'Europe/Rome',60.75,1,'work','2023-03-17 10:59:09','2023-02-28'),
(3975,3,2,95,'2023-01-26 15:30:00','2023-01-26 18:00:00',9000,'Assistenza per sistemazione armadio rack',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-14 15:47:49','2023-01-26'),
(3976,1,1,22,'2023-02-28 13:04:00','2023-02-28 14:18:00',4440,'problemi vpn e port forwarding emule',55.5,NULL,45,1,'Europe/Rome',55.5,1,'work','2023-03-09 11:00:59','2023-02-28'),
(3977,1,1,114,'2023-02-28 14:21:00','2023-02-28 17:30:00',11340,'backup mail\r\nconfigurazione minipc per totem',141.75,NULL,45,1,'Europe/Rome',141.75,1,'work','2023-03-10 14:14:55','2023-02-28'),
(3978,3,1,76,'2023-02-28 14:10:00','2023-02-28 14:25:00',900,'Installate 2 licenze nod32 aggiornamento su 4 pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-02-28 17:09:01','2023-02-28'),
(3979,3,1,22,'2023-02-28 11:00:00','2023-02-28 11:35:00',2100,'Assistenza per liberare spazio su NAS, assistenza su pc client Piero per problema collegamento VPN',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-09 11:00:53','2023-02-28'),
(3980,3,1,103,'2023-02-28 13:30:00','2023-02-28 14:00:00',1800,'Assistenza su pc client Tiziana per recupero rubrica Thunderbird dopo reinstallazione s.o',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-08 16:39:57','2023-02-28'),
(3981,3,1,22,'2023-02-28 14:45:00','2023-02-28 14:55:00',600,'Assistenza su pc client Piero per modifica task backup quotidiano',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-09 11:00:52','2023-02-28'),
(3982,3,1,1,'2023-02-28 16:10:00','2023-02-28 16:20:00',600,'Assistenza su pc client Francesco sede Borzoli',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-17 10:59:17','2023-02-28'),
(3983,3,1,75,'2023-02-28 16:25:00','2023-02-28 16:35:00',600,'Assistenza su pc casa Federico per configurazione stampante in HP',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-06 16:18:39','2023-02-28'),
(3984,1,2,114,'2023-03-01 09:22:00','2023-03-01 11:15:00',6780,'Consegna e installazione minipc',84.75,NULL,45,1,'Europe/Rome',84.75,1,'work','2023-03-10 14:15:02','2023-03-01'),
(3985,3,2,12,'2023-03-01 14:40:00','2023-03-01 15:10:00',1800,'Riconsegnati 2 pc client dopo assistenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-03 14:36:40','2023-03-01'),
(3986,3,2,50,'2023-03-01 15:25:00','2023-03-01 15:35:00',600,'Consegna 2 toner originali Xerox',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-10 16:00:22','2023-03-01'),
(3987,3,1,95,'2023-03-01 08:50:00','2023-03-01 09:00:00',600,'Assistenza su pc client Mara',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-14 15:47:40','2023-03-01'),
(3988,3,1,4,'2023-03-01 09:20:00','2023-03-01 09:30:00',600,'Assistenza su pc client Alessandra',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-06 07:57:27','2023-03-01'),
(3989,3,1,90,'2023-03-01 09:45:00','2023-03-01 10:00:00',900,'Installato nuovo file configurazione vpn su portatile casa Campodoni',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-05-03 10:03:05','2023-03-01'),
(3990,1,1,3,'2023-02-01 13:45:00','2023-02-01 14:18:00',1980,NULL,24.75,NULL,45,1,'Europe/Rome',24.75,1,'work','2023-03-15 16:22:14','2023-02-01'),
(3991,1,4,3,'2023-02-02 10:42:00','2023-02-02 11:00:00',1080,'in lab',13.5,NULL,45,1,'Europe/Rome',13.5,1,'work','2023-03-15 16:22:15','2023-02-02'),
(3992,1,1,90,'2023-02-02 14:35:00','2023-02-02 16:29:00',6840,'pulizia server backup',85.5,NULL,45,1,'Europe/Rome',85.5,1,'work','2023-04-06 09:39:05','2023-02-02'),
(3993,1,1,3,'2023-02-02 16:38:00','2023-02-02 17:24:00',2760,'proxmox backup',34.5,NULL,45,1,'Europe/Rome',34.5,1,'work','2023-03-15 16:22:24','2023-02-02'),
(3994,1,1,5,'2023-02-03 07:45:00','2023-02-03 10:41:00',10560,'agg server e vm , server di posta filtri antispam',132,NULL,45,1,'Europe/Rome',132,1,'work','2023-04-06 09:26:19','2023-02-03'),
(3995,1,1,3,'2023-02-03 10:55:00','2023-02-03 11:30:00',2100,'proxmox backup',26.25,NULL,45,1,'Europe/Rome',26.25,1,'work','2023-03-15 16:22:30','2023-02-03'),
(3996,1,1,3,'2023-02-03 13:47:00','2023-02-03 15:48:00',7260,'proxmox',90.75,NULL,45,1,'Europe/Rome',90.75,1,'work','2023-03-15 16:22:28','2023-02-03'),
(3997,1,1,75,'2023-02-03 15:50:00','2023-02-03 16:18:00',1680,'agg nas urge',21,NULL,45,1,'Europe/Rome',21,1,'work','2023-04-06 16:18:48','2023-02-03'),
(3998,1,1,2,'2023-02-03 16:28:00','2023-02-03 17:00:00',1920,'agg nas urge',24,NULL,45,1,'Europe/Rome',24,1,'work','2023-04-06 08:43:28','2023-02-03'),
(3999,1,1,17,'2023-02-03 17:00:00','2023-02-03 17:28:00',1680,'agg nas urge',21,NULL,45,1,'Europe/Rome',21,1,'work','2023-03-06 19:02:55','2023-02-03'),
(4000,1,1,5,'2023-02-06 08:44:00','2023-02-06 09:15:00',1860,'agg nas urge',23.25,NULL,45,1,'Europe/Rome',23.25,1,'work','2023-04-06 09:26:15','2023-02-06'),
(4001,1,1,6,'2023-02-06 09:34:00','2023-02-06 10:00:00',1560,'agg nas',19.5,NULL,45,1,'Europe/Rome',19.5,1,'work','2023-06-26 16:32:47','2023-02-06'),
(4002,1,1,103,'2023-02-06 10:04:00','2023-02-06 11:30:00',5160,'agg variu',64.5,NULL,45,1,'Europe/Rome',64.5,1,'work','2023-03-02 10:02:19','2023-02-06'),
(4003,1,1,103,'2023-02-06 13:41:00','2023-02-06 14:00:00',1140,'agg vari',14.25,NULL,45,1,'Europe/Rome',14.25,1,'work','2023-03-02 10:02:20','2023-02-06'),
(4004,1,1,3,'2023-02-07 09:42:00','2023-02-07 11:27:00',6300,'proxmox segnalazione guasti e bnackup',78.75,NULL,45,1,'Europe/Rome',78.75,1,'work','2023-03-15 16:22:22','2023-02-07'),
(4005,1,1,3,'2023-02-10 17:17:00','2023-02-10 17:30:00',780,NULL,9.75,NULL,45,1,'Europe/Rome',9.75,1,'work','2023-03-15 16:22:27','2023-02-10'),
(4006,1,3,112,'2023-02-13 09:47:00','2023-02-13 17:30:00',27780,'ferie',347.25,NULL,45,1,'Europe/Rome',347.25,1,'work','2023-03-08 17:14:44','2023-02-13'),
(4007,1,3,112,'2023-02-14 07:48:00','2023-02-14 17:00:00',33120,'lutto',414,NULL,45,1,'Europe/Rome',414,1,'work','2023-03-08 17:14:47','2023-02-14'),
(4008,1,3,112,'2023-02-15 07:48:00','2023-02-15 17:00:00',33120,'lutto',414,NULL,45,1,'Europe/Rome',414,1,'work','2023-03-08 17:14:47','2023-02-15'),
(4009,1,3,112,'2023-02-16 07:49:00','2023-02-16 17:00:00',33060,'lutto',413.25,NULL,45,1,'Europe/Rome',413.25,1,'work','2023-03-08 17:14:45','2023-02-16'),
(4010,1,1,67,'2023-02-20 10:46:00','2023-02-20 11:28:00',2520,'preparato per migrazione firewall',31.5,NULL,45,1,'Europe/Rome',31.5,1,'work','2023-03-10 16:39:56','2023-02-20'),
(4011,1,1,4,'2023-02-21 10:49:00','2023-02-21 11:24:00',2100,'agg server win, verifica vpn wireguard da sentire per capire se server ancora la vm windows',26.25,NULL,45,1,'Europe/Rome',26.25,1,'work','2023-03-16 17:20:45','2023-02-21'),
(4012,1,1,2,'2023-02-21 15:01:00','2023-02-21 17:24:00',8580,'agg vari nas e server',107.25,NULL,45,1,'Europe/Rome',107.25,1,'work','2023-04-06 08:43:22','2023-02-21'),
(4013,1,1,87,'2023-02-23 11:02:00','2023-02-23 11:25:00',1380,'problema spam in uscita',17.25,NULL,45,1,'Europe/Rome',17.25,1,'work','2023-06-16 14:41:20','2023-02-23'),
(4014,1,1,87,'2023-02-23 13:51:00','2023-02-23 15:30:00',5940,'problema spam in uscita',74.25,NULL,45,1,'Europe/Rome',74.25,1,'work','2023-06-16 14:41:21','2023-02-23'),
(4015,1,1,3,'2023-02-24 15:40:00','2023-02-24 16:47:00',4020,'proxmox',50.25,NULL,45,1,'Europe/Rome',50.25,1,'work','2023-03-15 16:22:37','2023-02-24'),
(4016,1,1,114,'2023-02-28 10:05:00','2023-02-28 10:29:00',1440,'test totam su vm',18,NULL,45,1,'Europe/Rome',18,1,'work','2023-03-10 14:14:55','2023-02-28'),
(4017,1,1,114,'2023-03-01 13:52:00','2023-03-01 15:42:00',6600,'varie su windows kiosk',82.5,NULL,45,1,'Europe/Rome',82.5,1,'work','2023-03-10 14:14:54','2023-03-01'),
(4018,1,1,2,'2023-03-01 15:57:00','2023-03-01 17:30:00',5580,'ottimizzazione share ancora su vecchioi sever',69.75,NULL,45,1,'Europe/Rome',69.75,1,'work','2023-04-06 08:43:22','2023-03-01'),
(4019,1,1,35,'2023-02-13 07:32:00','2023-02-13 08:00:00',1680,'agg nas',21,NULL,45,1,'Europe/Rome',21,1,'work','2023-03-10 16:51:24','2023-02-13'),
(4020,1,1,75,'2023-02-13 08:08:00','2023-02-13 08:45:00',2220,'agg nas',27.75,NULL,45,1,'Europe/Rome',27.75,1,'work','2023-04-06 16:18:40','2023-02-13'),
(4021,1,1,83,'2023-02-13 08:48:00','2023-02-13 09:44:00',3360,'agg nas e nasbackup',42,NULL,45,1,'Europe/Rome',42,1,'work','2023-03-09 10:47:28','2023-02-13'),
(4022,1,1,90,'2023-03-02 07:36:00','2023-03-02 07:38:11',131,'vpn pc donatella',1.64,NULL,45,1,'Europe/Rome',1.64,1,'work','2023-05-03 10:03:05','2023-03-02'),
(4023,1,1,90,'2023-03-02 07:51:00','2023-03-02 08:06:00',900,'vpn pc donatella',11.25,NULL,45,1,'Europe/Rome',11.25,1,'work','2023-05-03 10:03:18','2023-03-02'),
(4024,1,1,89,'2023-03-02 10:58:00','2023-03-02 11:05:00',420,'configurazione smtp su gestionale',5.25,NULL,45,1,'Europe/Rome',5.25,1,'work','2023-09-22 10:06:28','2023-03-02'),
(4025,3,2,32,'2023-03-02 09:45:00','2023-03-02 11:10:00',5100,'Assistenza su PC client Daniela per problemi su certificati firma digitale e Desktop Telematico',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-14 15:59:36','2023-03-02'),
(4026,1,1,50,'2023-03-02 09:30:00','2023-03-02 10:49:00',4740,'problema alcune mail archiviate illeggibili',59.25,NULL,45,1,'Europe/Rome',59.25,1,'work','2023-03-10 16:00:22','2023-03-02'),
(4027,1,1,89,'2023-03-02 14:00:00','2023-03-02 14:18:56',1136,'configurazione smtp su gestionale',14.2,NULL,45,1,'Europe/Rome',14.2,1,'work','2023-09-22 10:06:30','2023-03-02'),
(4028,1,2,3,'2023-03-02 15:20:00','2023-03-02 16:20:00',3600,'taxi',45,NULL,45,1,'Europe/Rome',45,1,'work','2023-03-15 16:22:18','2023-03-02'),
(4029,3,1,79,'2023-03-02 07:45:00','2023-03-02 08:00:00',900,'Assistenza su pc client Paola A. per problemi accesso One Drive',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-04 08:29:30','2023-03-02'),
(4030,3,1,79,'2023-03-02 14:05:00','2023-03-02 14:20:00',900,'Assistenza su pc client Roberto per problemi su stampante Brother',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-04 08:29:33','2023-03-02'),
(4031,3,1,96,'2023-03-02 16:35:00','2023-03-02 16:55:00',1200,'Assistenza su portatile Maria Confessore per installazione vpn e share',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-29 16:11:42','2023-03-02'),
(4032,3,2,32,'2023-03-03 08:50:00','2023-03-03 09:40:00',3000,'Assistenza su PC client Daniela',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-14 15:59:38','2023-03-03'),
(4033,1,1,79,'2023-03-03 09:00:00','2023-03-03 09:56:04',3364,'problema stampa pdf su nuova stampante',42.05,NULL,45,1,'Europe/Rome',42.05,1,'work','2023-04-04 08:29:32','2023-03-03'),
(4034,1,1,50,'2023-03-03 08:15:00','2023-03-03 08:52:00',2220,'problema mail archiviate',27.75,NULL,45,1,'Europe/Rome',27.75,1,'work','2023-03-10 16:00:25','2023-03-03'),
(4035,1,1,50,'2023-03-02 16:31:00','2023-03-02 17:30:00',3540,'problema mail archiviate',44.25,NULL,45,1,'Europe/Rome',44.25,1,'work','2023-03-10 16:00:24','2023-03-02'),
(4036,1,1,50,'2023-03-02 11:13:00','2023-03-02 11:30:00',1020,'problema mail archiviate',12.75,NULL,45,1,'Europe/Rome',12.75,1,'work','2023-03-10 16:00:23','2023-03-02'),
(4037,3,1,79,'2023-03-03 08:10:00','2023-03-03 08:20:00',600,'Assistenza pc client Paola C per problema accesso One Drive',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-04 08:29:45','2023-03-03'),
(4038,3,1,108,'2023-03-03 10:05:00','2023-03-03 10:15:00',600,'Modificata password mail eventi@villaserra.it',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-17 09:52:00','2023-03-03'),
(4039,1,6,104,'2023-03-06 09:35:00','2023-03-06 09:47:00',720,'per cambio operatore',9,NULL,45,1,'Europe/Rome',9,1,'work','2023-03-22 11:08:34','2023-03-06'),
(4040,1,1,114,'2023-03-06 13:45:00','2023-03-06 14:18:54',2034,'varie su windows kiosk',25.43,NULL,45,1,'Europe/Rome',25.43,1,'work','2023-03-10 14:15:03','2023-03-06'),
(4041,3,1,50,'2023-03-06 09:35:00','2023-03-06 09:45:00',600,'Assistenza su pc client Filippo per problemi spazio pc',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-10 16:00:26','2023-03-06'),
(4042,3,1,26,'2023-03-06 09:50:00','2023-03-06 10:10:00',1200,'Assistenza su pc client Banci per problema collegamento vpn',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-07 09:32:44','2023-03-06'),
(4043,3,1,32,'2023-03-06 10:30:00','2023-03-06 11:00:00',1800,'Assistenza per problemi avvio vm dopo che è mancata la corrente',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-14 15:56:47','2023-03-06'),
(4044,3,2,108,'2023-03-07 09:50:00','2023-03-07 10:50:00',3600,'Consegna e installazione nuovo monitor, verificato e ritirato portatile Consuelo per reinstallazione sistema operativo',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-17 09:52:14','2023-03-07'),
(4045,1,1,90,'2023-03-07 16:45:00','2023-03-07 17:40:00',3300,'problema leonardo luciano',41.25,NULL,45,1,'Europe/Rome',41.25,1,'work','2023-05-03 10:03:15','2023-03-07'),
(4046,3,4,2,'2023-02-21 17:00:00','2023-02-21 17:10:00',600,'Sostituita batteria UPS APC Pc client Andrea',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-06 08:43:34','2023-02-21'),
(4047,1,2,2,'2023-03-08 09:00:00','2023-03-08 10:40:00',6000,'sopraluogo per telecamere e varie',75,NULL,45,1,'Europe/Rome',75,1,'work','2023-04-06 08:40:17','2023-03-08'),
(4048,1,1,90,'2023-03-08 07:44:00','2023-03-08 08:10:00',1560,'problema leonardo luciano',19.5,NULL,45,1,'Europe/Rome',19.5,1,'work','2023-05-03 10:03:21','2023-03-08'),
(4049,1,1,90,'2023-03-08 11:00:00','2023-03-08 11:30:00',1800,'problema leonardo luciano',22.5,NULL,45,1,'Europe/Rome',22.5,1,'work','2023-05-03 10:03:06','2023-03-08'),
(4050,1,1,2,'2023-03-08 13:46:00','2023-03-08 15:30:58',6298,'pc alessia nuvoo',78.73,NULL,45,1,'Europe/Rome',78.73,1,'work','2023-04-06 08:43:20','2023-03-08'),
(4051,1,1,90,'2023-03-08 15:31:00','2023-03-08 17:55:00',8640,'problema leonardo luciano\r\nagg 1h',108,NULL,45,1,'Europe/Rome',108,1,'work','2023-05-03 10:03:17','2023-03-08'),
(4052,3,1,50,'2023-03-08 08:30:00','2023-03-08 09:00:00',1800,'Assistenza su portatile casa Filippo per problemi su Thunderbird',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-10 16:00:27','2023-03-08'),
(4053,3,1,26,'2023-03-08 10:55:00','2023-03-08 11:10:00',900,'Rinviati file vpn corretti',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-17 09:53:37','2023-03-08'),
(4054,3,1,26,'2023-03-08 14:10:00','2023-03-08 14:20:00',600,'Assistenza su pc client Simona Bertetto',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-07 09:32:44','2023-03-08'),
(4055,3,4,108,'2023-03-08 14:30:00','2023-03-08 15:30:00',3600,'Reinstallato sistema operativo + configurazione su portatile Consuelo ritirato',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-17 09:51:57','2023-03-08'),
(4056,1,1,95,'2023-03-09 09:00:00','2023-03-09 09:40:00',2400,'configurazione wireguard per scadenza chiavi vpn',30,NULL,45,1,'Europe/Rome',30,1,'work','2023-03-14 15:47:44','2023-03-09'),
(4057,3,2,108,'2023-03-09 09:50:00','2023-03-09 10:20:00',1800,'Riconsegnato e configurato portatile Consuelo dopo reinstallazione',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-17 09:52:00','2023-03-09'),
(4058,3,1,12,'2023-03-09 08:20:00','2023-03-09 09:00:00',2400,'Configurati nuovi file vpn su pc client dopo rinnovo certificato',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-03 14:36:40','2023-03-09'),
(4059,3,1,12,'2023-03-09 11:05:00','2023-03-09 11:25:00',1200,'Configurati nuovi file vpn su pc client dopo rinnovo certificato',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-03 14:36:44','2023-03-09'),
(4060,3,1,45,'2023-03-09 14:00:00','2023-03-09 14:15:00',900,'Configurati nuovi file vpn su pc client dopo rinnovo certificato',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-16 17:12:51','2023-03-09'),
(4061,3,1,17,'2023-03-09 14:20:00','2023-03-09 14:30:00',600,'Configurati nuovi file vpn su pc client dopo rinnovo certificato',0,NULL,0,1,'Europe/Rome',0,1,'work','2024-01-31 15:06:49','2023-03-09'),
(4062,3,1,56,'2023-03-09 09:00:00','2023-03-09 09:10:00',600,'Assistenza per avvio Firewall dopo che era mancata la corrente nella notte',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-04 09:48:13','2023-03-09'),
(4063,3,1,75,'2023-03-09 10:45:00','2023-03-09 11:05:00',1200,'Assistenza per problemi su stampante, devo contattare assistenza Ricoh',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-06 15:52:52','2023-03-09'),
(4064,3,1,55,'2023-03-09 13:35:00','2023-03-09 13:55:00',1200,'Assistenza su pc client Severino per problemi collegamento a Condivisi',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-28 16:14:03','2023-03-09'),
(4065,3,1,75,'2023-03-09 14:40:00','2023-03-09 15:10:00',1800,'Assistenza per problemi collegamento BC Studio al pc della contabilità, da finire di verificare',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-06 16:18:39','2023-03-09'),
(4066,1,1,50,'2023-03-10 09:34:00','2023-03-10 11:32:16',7096,'problema vacation e mail scomparse',88.7,NULL,45,1,'Europe/Rome',88.7,1,'work','2023-03-10 16:00:30','2023-03-10'),
(4067,3,2,114,'2023-03-10 10:45:00','2023-03-10 11:15:00',1800,'Riconsegnato 1 mini PC dopo configurazione + cavo usb da 3mt 2.0, Fare offerta per extender wifi',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-10 14:15:04','2023-03-10'),
(4068,3,1,100,'2023-03-10 11:20:00','2023-03-10 11:30:00',600,'Riavviato server dopo aggiornamento a debian 11',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-17 11:12:52','2023-03-10'),
(4069,1,1,55,'2023-03-10 08:10:00','2023-03-10 08:50:00',2400,'problema posta marika',30,NULL,45,1,'Europe/Rome',30,1,'work','2023-03-28 16:14:06','2023-03-10'),
(4070,1,1,55,'2023-03-10 11:41:00','2023-03-10 12:00:00',1140,'problema posta marika',14.25,NULL,45,1,'Europe/Rome',14.25,1,'work','2023-03-28 16:14:08','2023-03-10'),
(4071,3,2,100,'2023-03-10 13:00:00','2023-03-10 13:50:00',3000,'Assistenza per problemi avvio server dopo aggiornamenti',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-17 11:12:56','2023-03-10'),
(4072,1,1,114,'2023-03-09 15:13:00','2023-03-09 17:24:00',7860,'varie su windows kiosk',98.25,NULL,45,1,'Europe/Rome',98.25,1,'work','2023-03-14 10:28:26','2023-03-09'),
(4073,1,1,114,'2023-03-10 09:04:00','2023-03-10 09:29:00',1500,'varie su windows kiosk',18.75,NULL,45,1,'Europe/Rome',18.75,1,'work','2023-03-14 10:28:27','2023-03-10'),
(4074,1,1,50,'2023-03-09 07:48:00','2023-03-09 08:50:00',3720,'probvlema mail mancante filippo',46.5,NULL,45,1,'Europe/Rome',46.5,1,'work','2023-03-10 16:00:27','2023-03-09'),
(4075,1,1,50,'2023-03-09 10:00:00','2023-03-09 11:30:00',5400,'probvlema mail mancante filippo',67.5,NULL,45,1,'Europe/Rome',67.5,1,'work','2023-03-10 16:00:29','2023-03-09'),
(4076,1,1,2,'2023-03-09 13:43:00','2023-03-09 14:52:00',4140,'pc nuovo alessia',51.75,NULL,45,1,'Europe/Rome',51.75,1,'work','2023-04-06 08:43:19','2023-03-09'),
(4077,3,1,117,'2023-03-10 07:55:00','2023-03-10 08:10:00',900,'Assistenza su pc client sede Sampierdarena per problemi stampa lenta, pc da ritirare per upgrade hw e sw',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-23 10:41:34','2023-03-10'),
(4078,3,1,103,'2023-03-10 08:25:00','2023-03-10 08:35:00',600,'Assistenza su pc client Martina per problemi visualizzazione Thunderbird',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-14 15:48:48','2023-03-10'),
(4079,3,1,12,'2023-03-10 08:45:00','2023-03-10 09:05:00',1200,'Configurati nuovi file vpn su pc client dopo rinnovo certificato',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-03 14:36:37','2023-03-10'),
(4080,3,1,12,'2023-03-10 14:25:00','2023-03-10 14:35:00',600,'Configurati nuovi file vpn su pc client dopo rinnovo certificato',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-03 14:36:39','2023-03-10'),
(4081,3,1,75,'2023-03-10 09:25:00','2023-03-10 09:55:00',1800,'Assistenza per problemi collegamento vpn dopo che è stata montata linea di bk da Fastebweb',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-06 16:18:44','2023-03-10'),
(4082,3,1,22,'2023-03-10 14:40:00','2023-03-10 14:55:00',900,'Assistenza su pc client padre per problemi vpn',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-06-20 09:30:55','2023-03-10'),
(4083,3,1,45,'2023-03-10 16:40:00','2023-03-10 16:50:00',600,'Configurati nuovi file vpn su pc client dopo rinnovo certificato',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-16 17:12:53','2023-03-10'),
(4084,1,1,114,'2023-03-11 14:35:00','2023-03-11 17:45:00',11400,'varie su windows kiosk\r\nproblema bordi riconfigurati pc',142.5,NULL,45,1,'Europe/Rome',142.5,1,'work','2023-03-14 10:28:28','2023-03-11'),
(4085,1,1,114,'2023-03-13 07:41:00','2023-03-13 09:36:58',6958,'varie su windows kiosk\r\nproblema bordi riconfigurati pc',86.98,NULL,45,1,'Europe/Rome',86.98,1,'work','2023-03-14 10:28:29','2023-03-13'),
(4086,1,1,75,'2023-03-10 13:47:00','2023-03-10 15:12:00',5100,'problemi vpn dopo intervento fastweb',63.75,NULL,45,1,'Europe/Rome',63.75,1,'work','2023-04-06 16:18:38','2023-03-10'),
(4087,1,1,108,'2023-03-10 15:28:00','2023-03-10 17:27:00',7140,'server nuovo',89.25,NULL,45,1,'Europe/Rome',89.25,1,'work','2023-03-17 09:14:08','2023-03-10'),
(4088,1,4,108,'2023-03-07 13:57:00','2023-03-07 16:36:00',9540,'installato proxmox su ssd in raid',119.25,NULL,45,1,'Europe/Rome',119.25,1,'work','2023-03-17 09:13:57','2023-03-07'),
(4089,1,1,3,'2023-03-07 10:03:00','2023-03-07 11:30:00',5220,'varie per acluni clienti con vpnm scadute',65.25,NULL,45,1,'Europe/Rome',65.25,1,'work','2023-03-15 16:22:38','2023-03-07'),
(4090,1,1,2,'2023-03-07 07:48:00','2023-03-07 09:52:00',7440,'aggiornamenti server',93,NULL,45,1,'Europe/Rome',93,1,'work','2023-04-06 08:43:21','2023-03-07'),
(4091,1,1,32,'2023-03-06 10:45:00','2023-03-06 11:20:00',2100,'segnalati problemi fede per riavvio dopo salto corrente',26.25,NULL,45,1,'Europe/Rome',26.25,1,'work','2023-03-14 15:56:47','2023-03-06'),
(4092,1,1,103,'2023-03-06 07:46:00','2023-03-06 09:22:00',5760,'agg server',72,NULL,45,1,'Europe/Rome',72,1,'work','2023-03-14 15:48:47','2023-03-06'),
(4093,1,1,5,'2023-03-06 14:45:00','2023-03-06 17:22:00',9420,'aghg server',117.75,NULL,45,1,'Europe/Rome',117.75,1,'work','2023-04-06 09:26:09','2023-03-06'),
(4094,1,1,50,'2023-03-03 10:10:00','2023-03-03 11:30:00',4800,'problema mail archiviate',60,NULL,45,1,'Europe/Rome',60,1,'work','2023-03-14 15:59:58','2023-03-03'),
(4095,1,1,50,'2023-03-03 13:49:00','2023-03-03 16:00:00',7860,'problema mail archiviate',98.25,NULL,45,1,'Europe/Rome',98.25,1,'work','2023-03-14 15:59:59','2023-03-03'),
(4096,1,1,26,'2023-03-03 07:52:00','2023-03-03 08:08:00',960,'pc vecchio banci',12,NULL,45,1,'Europe/Rome',12,1,'work','2023-04-07 09:32:41','2023-03-03'),
(4097,1,1,26,'2023-03-03 16:13:00','2023-03-03 17:29:00',4560,'pc vecchio banci estrazione posta inviata',57,NULL,45,1,'Europe/Rome',57,1,'work','2023-04-07 09:32:40','2023-03-03'),
(4098,3,2,114,'2023-03-13 10:55:00','2023-03-13 11:35:00',2400,'Riconsegna mini PC dopo configurazione, consegna 4 cavi usb 2.0 da 3 mt, consegnato e configurato extender wifi 521804. Assistenza su mac per problemi indicizzazione Outlook',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-14 10:28:30','2023-03-13'),
(4099,1,1,2,'2023-03-13 09:48:00','2023-03-13 11:29:00',6060,'compilazione modulo gdpr e cambio config backup e registrazione telecamere',75.75,NULL,45,1,'Europe/Rome',75.75,1,'work','2023-04-06 08:43:27','2023-03-13'),
(4100,1,1,2,'2023-03-13 13:48:00','2023-03-13 14:41:00',3180,'compilazione modulo gdpr e cambio config backup e registrazione telecamere',39.75,NULL,45,1,'Europe/Rome',39.75,1,'work','2023-04-06 08:43:38','2023-03-13'),
(4101,1,1,79,'2023-03-13 14:55:00','2023-03-13 15:29:00',2040,'modulo gdpr',25.5,NULL,45,1,'Europe/Rome',25.5,1,'work','2023-03-17 11:06:11','2023-03-13'),
(4102,3,1,75,'2023-03-13 08:45:00','2023-03-13 09:05:00',1200,'Contattato Fastweb per problemi collegamento vpn con la linea di backup che hanno installato',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-06 16:18:43','2023-03-13'),
(4103,3,1,75,'2023-03-13 16:50:00','2023-03-13 17:10:00',1200,'Contattato Fastweb per problemi collegamento vpn con la linea di backup che hanno installato',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-06 16:18:40','2023-03-13'),
(4104,3,1,12,'2023-03-13 09:50:00','2023-03-13 10:00:00',600,'Configurato nuovo file vpn su pc casa Caterina Ippolito',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-03 14:36:54','2023-03-13'),
(4105,3,1,4,'2023-03-13 13:35:00','2023-03-13 13:45:00',600,'Apertura porte su Vodafone Station',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-06 07:57:24','2023-03-13'),
(4106,3,1,1,'2023-03-13 13:55:00','2023-03-13 14:25:00',1800,'Assistenza per problemi sulla vpn dopo aggiornamenti',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-17 10:59:10','2023-03-13'),
(4107,3,1,96,'2023-03-13 14:45:00','2023-03-13 15:10:00',1500,'Assistenza su pc casa Anna Mochi per ripristino Omnia',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-29 16:11:33','2023-03-13'),
(4108,3,1,108,'2023-03-13 15:40:00','2023-03-13 16:05:00',1500,'Assistenza su portatile casa Consuelo per configurazione vpn, da modificare file config su altro portatile',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-17 09:51:56','2023-03-13'),
(4109,3,1,50,'2023-03-13 17:30:00','2023-03-13 17:40:00',600,'Configurato messaggio \"Fuori ufficio\" su indirizzo mail Loretta Mennone',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-14 16:00:00','2023-03-13'),
(4110,1,1,2,'2023-03-14 10:30:00','2023-03-14 11:06:00',2160,'vpn francesca',27,NULL,45,1,'Europe/Rome',27,1,'work','2023-04-06 08:43:26','2023-03-14'),
(4111,1,1,29,'2023-03-14 11:09:00','2023-03-14 11:19:39',639,'vpn francesca',7.99,NULL,45,1,'Europe/Rome',7.99,1,'work','2023-03-22 10:06:33','2023-03-14'),
(4112,3,2,103,'2023-03-14 11:00:00','2023-03-14 11:15:00',900,'Ritirato pc client per possibile upgrade hw e sw\r\nRiavvio firewall per problemi accesso al controller',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-14 15:48:49','2023-03-14'),
(4113,3,1,100,'2023-03-14 08:20:00','2023-03-14 08:55:00',2100,'Assistenza su nuovo mac Riccardo per configurazione posta',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-06 08:28:12','2023-03-14'),
(4114,3,1,96,'2023-03-14 09:20:00','2023-03-14 09:40:00',1200,'Assistenza su pc client Anna Mochi casa',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-29 16:11:33','2023-03-14'),
(4115,3,1,50,'2023-03-14 17:00:00','2023-03-14 17:10:00',600,'Assistenza su mac Gigio per modifica firma posta',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-03 16:03:44','2023-03-14'),
(4116,3,2,64,'2023-03-15 08:25:00','2023-03-15 09:15:00',3000,'Consegna, installata e configurata nuova stampante Brother su tutti pc client, assistenza su 2 PC client',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-05 10:09:42','2023-03-15'),
(4117,1,1,12,'2023-03-15 11:50:00','2023-03-15 12:01:38',698,'probelama vpn vella',8.73,NULL,45,1,'Europe/Rome',8.73,1,'work','2023-04-03 14:36:32','2023-03-15'),
(4118,1,1,114,'2023-03-15 09:34:00','2023-03-15 11:47:00',7980,'config totem su mio minipc',99.75,NULL,45,1,'Europe/Rome',99.75,1,'work','2023-04-11 15:52:49','2023-03-15'),
(4119,1,1,90,'2023-03-15 07:51:00','2023-03-15 09:17:00',5160,'pulizia disco flavio pc',64.5,NULL,45,1,'Europe/Rome',64.5,1,'work','2023-05-03 10:03:22','2023-03-15'),
(4120,3,2,96,'2023-03-15 14:30:00','2023-03-15 16:20:00',6600,'Consegnato e installato monitor su postazione client Gandolfo + webcam, utilizzato cavo hdmi\r\nAssistenza su PC client Irene, Maria, Marilena',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-29 16:11:30','2023-03-15'),
(4121,3,2,88,'2023-03-15 16:40:00','2023-03-15 16:50:00',600,'Ritirato pc client per assistenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-06 09:07:32','2023-03-15'),
(4122,1,1,2,'2023-03-15 16:40:00','2023-03-15 17:00:00',1200,'pulizia backup remoti',15,NULL,45,1,'Europe/Rome',15,1,'work','2023-04-06 08:43:26','2023-03-15'),
(4123,1,1,96,'2023-03-15 16:00:00','2023-03-15 16:10:00',600,'icona posta e uso 2 monitor',7.5,NULL,45,1,'Europe/Rome',7.5,1,'work','2023-03-29 16:11:31','2023-03-15'),
(4124,3,1,24,'2023-03-15 09:35:00','2023-03-15 09:45:00',600,'Riavviati servizi posta per problemi mail su iPhone',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-05-05 09:41:52','2023-03-15'),
(4125,3,4,103,'2023-03-15 09:50:00','2023-03-15 10:50:00',3600,'Assistenza su pc client Edilio, utilizzato 4 gb ram ddr3 usata + ssd s3+ da 1 tb',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-16 16:40:19','2023-03-15'),
(4126,3,1,108,'2023-03-15 17:40:00','2023-03-15 17:55:00',900,'Assistenza su portatile per problemi con VPN',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-17 09:52:01','2023-03-15'),
(4127,3,2,75,'2023-03-16 09:00:00','2023-03-16 12:00:00',10800,'Assistenza congiunta con tecnico fastweb per risoluzione problema servizi esterni con linea di backup',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-06 16:18:43','2023-03-16'),
(4128,3,1,96,'2023-03-16 12:00:00','2023-03-16 12:15:00',900,'Assistenza su PC client Federica più riavvio servizi tomcat',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-29 16:11:35','2023-03-16'),
(4129,1,1,95,'2023-03-16 14:01:00','2023-03-16 14:08:00',420,'vpn anna',5.25,NULL,45,1,'Europe/Rome',5.25,1,'work','2023-07-11 14:06:27','2023-03-16'),
(4130,1,6,75,'2023-03-16 14:08:00','2023-03-16 14:44:57',2217,'con damiano per spiegazioni',27.71,NULL,45,1,'Europe/Rome',27.71,1,'work','2023-04-06 15:34:47','2023-03-16'),
(4131,1,1,50,'2023-03-16 13:41:00','2023-03-16 14:00:00',1140,'pulizia log proxmox backup',14.25,NULL,45,1,'Europe/Rome',14.25,1,'work','2023-04-03 16:03:45','2023-03-16'),
(4132,1,1,108,'2023-03-15 13:48:00','2023-03-15 15:27:00',5940,'server nuovo',74.25,NULL,45,1,'Europe/Rome',74.25,1,'work','2023-03-17 09:14:14','2023-03-15'),
(4133,1,1,108,'2023-03-15 17:11:00','2023-03-15 17:36:00',1500,'server nuovo\r\ne aiutato fede per problema vpn su portatile consuelo',18.75,NULL,45,1,'Europe/Rome',18.75,1,'work','2023-03-17 09:14:19','2023-03-15'),
(4134,1,1,108,'2023-03-14 13:51:00','2023-03-14 16:47:00',10560,'server nuovo',132,NULL,45,1,'Europe/Rome',132,1,'work','2023-03-17 09:14:11','2023-03-14'),
(4135,3,2,103,'2023-03-16 14:40:00','2023-03-16 15:00:00',1200,'Riconsegnato pc client Edilio dopo aggiornamento hw e sw',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-16 16:20:06','2023-03-16'),
(4136,3,1,26,'2023-03-16 16:10:00','2023-03-16 16:25:00',900,'Assistenza su pc client Sola per verifica dati da copiare su hd esterno',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-07 09:32:38','2023-03-16'),
(4137,3,1,75,'2023-03-16 16:40:00','2023-03-16 17:00:00',1200,'Assistenza su pc client Marisa per problemi collegamento vpn, deve verificare Fastweb',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-06 16:18:49','2023-03-16'),
(4138,3,2,108,'2023-03-17 08:20:00','2023-03-17 11:20:00',10800,'Consegnato e configurato nuovo server Linux, utilizzato una tastiera usb, assistenza e configurazione su PC client e stampanti di rete dopo cambio server',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-07 09:44:41','2023-03-17'),
(4139,1,1,95,'2023-03-14 07:53:00','2023-03-14 10:15:00',8520,'problema consumo ram server nuovo\r\nlimitato uso ram a zfs',106.5,NULL,45,1,'Europe/Rome',106.5,1,'work','2023-04-06 16:20:54','2023-03-14'),
(4140,3,2,104,'2023-03-17 14:10:00','2023-03-17 14:30:00',1200,'Verificato impostazioni nuovo router fastweb',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-22 11:08:35','2023-03-17'),
(4141,1,1,108,'2023-03-17 08:31:00','2023-03-17 11:30:00',10740,'fede li consegna server, fine sincro configurazioni varie e test',134.25,NULL,45,1,'Europe/Rome',134.25,1,'work','2023-04-07 09:44:50','2023-03-17'),
(4142,1,1,108,'2023-03-17 15:00:00','2023-03-17 17:45:49',9949,'import vbox vm su proxmox',124.36,NULL,45,1,'Europe/Rome',124.36,1,'work','2023-04-07 09:44:57','2023-03-17'),
(4143,1,1,3,'2023-03-17 07:30:00','2023-03-17 08:15:00',2700,'ion lab spiegato a fede lavoro da fare da villa',33.75,NULL,45,1,'Europe/Rome',33.75,1,'work','2023-04-05 21:02:58','2023-03-17'),
(4144,1,3,112,'2023-03-17 13:30:00','2023-03-17 13:50:00',1200,NULL,15,NULL,45,1,'Europe/Rome',15,1,'work','2023-04-05 20:56:11','2023-03-17'),
(4145,1,1,3,'2023-03-17 13:55:00','2023-03-17 14:34:00',2340,'fede da trado verifica ip',29.25,NULL,45,1,'Europe/Rome',29.25,1,'work','2023-04-05 21:03:06','2023-03-17'),
(4146,3,4,88,'2023-03-17 14:40:00','2023-03-17 16:10:00',5400,'Assistenza su pc client ritirato, reinstallato sistema operativo. Utilizzato ssd M2 Nmve da 500gb',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-06 09:19:19','2023-03-17'),
(4147,1,1,114,'2023-03-20 08:59:00','2023-03-20 11:30:00',9060,'problemi outlook ludovica\r\nproblemi nas',113.25,NULL,45,1,'Europe/Rome',113.25,1,'work','2023-07-12 09:06:21','2023-03-20'),
(4148,3,2,88,'2023-03-20 08:50:00','2023-03-20 09:10:00',1200,'Riconsegnato e configurato pc client Vincenzo',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-06 09:19:21','2023-03-20'),
(4149,1,1,51,'2023-03-20 07:50:00','2023-03-20 08:26:00',2160,'problemi backup remoti, rilevati problemi di connettività',27,NULL,45,1,'Europe/Rome',27,1,'work','2023-05-19 13:55:12','2023-03-20'),
(4150,3,2,117,'2023-03-20 09:30:00','2023-03-20 10:15:00',2700,'Assistenza si pc client \r\nRitirato pc client per assistenza + alim scanner',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-23 10:41:33','2023-03-20'),
(4151,3,2,117,'2023-03-20 10:40:00','2023-03-20 10:50:00',600,'Ritirato pc client sede Sampierdarena per assistenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-23 10:41:33','2023-03-20'),
(4152,1,1,22,'2023-03-20 13:36:00','2023-03-20 13:49:38',818,'problemi port mapping casa',10.23,NULL,45,1,'Europe/Rome',10.23,1,'work','2023-06-20 09:31:02','2023-03-20'),
(4153,3,1,84,'2023-03-20 16:10:00','2023-03-20 16:25:00',900,'Assistenza su pc client per problemi con webcam',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-06-22 08:18:19','2023-03-20'),
(4154,1,1,2,'2023-03-20 14:02:00','2023-03-20 15:30:00',5280,'agg server',66,NULL,45,1,'Europe/Rome',66,1,'work','2023-07-12 09:22:14','2023-03-20'),
(4155,1,1,50,'2023-03-20 15:39:00','2023-03-20 16:47:00',4080,'problemi mail strane filippo',51,NULL,45,1,'Europe/Rome',51,1,'work','2023-04-03 16:03:46','2023-03-20'),
(4156,1,1,2,'2023-03-20 17:00:00','2023-03-20 17:29:00',1740,'agg server',21.75,NULL,45,1,'Europe/Rome',21.75,1,'work','2023-07-12 09:22:16','2023-03-20'),
(4157,1,1,67,'2023-03-21 07:52:00','2023-03-21 08:26:00',2040,'punto situazione migrazioen mail',25.5,NULL,45,1,'Europe/Rome',25.5,1,'work','2023-04-03 20:55:12','2023-03-21'),
(4158,1,1,2,'2023-03-21 08:40:00','2023-03-21 09:18:00',2280,'agg server',28.5,NULL,45,1,'Europe/Rome',28.5,1,'work','2023-07-12 09:22:18','2023-03-21'),
(4159,1,1,5,'2023-03-21 09:26:00','2023-03-21 10:30:00',3840,'agg server',48,NULL,45,1,'Europe/Rome',48,1,'work','2023-04-06 09:26:11','2023-03-21'),
(4160,1,1,67,'2023-03-21 12:36:00','2023-03-21 13:08:00',1920,'sistemati certificati',24,NULL,45,1,'Europe/Rome',24,1,'work','2023-04-03 21:04:16','2023-03-21'),
(4161,1,1,55,'2023-03-21 13:16:00','2023-03-21 17:00:00',13440,'agg server, configurazione firewall per backup server windows',168,NULL,45,1,'Europe/Rome',168,1,'work','2023-03-28 16:14:07','2023-03-21'),
(4162,1,1,55,'2023-03-16 17:03:00','2023-03-16 17:35:00',1920,'da fatturare a coedit per backup aggiortnamento db e apertura nuovo anno',24,NULL,45,1,'Europe/Rome',24,1,'work','2023-03-27 09:44:04','2023-03-16'),
(4163,3,2,50,'2023-03-21 15:25:00','2023-03-21 17:25:00',7200,'Spostamento dati e configurazione nuovo telefono Francesco',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-03 16:03:47','2023-03-21'),
(4164,3,4,117,'2023-03-21 07:40:00','2023-03-21 08:40:00',3600,'Assistenza su pc client sede Sampierdarena, upgrade hw e sw utillizzato ssd 480 gb Kioxa + 8 gb ddr3 + 1 licenza nod32 completa',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-27 09:28:53','2023-03-21'),
(4165,3,1,67,'2023-03-21 08:40:00','2023-03-21 09:20:00',2400,'Assistenza per problemi ricezione / invio posta',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-03 21:04:16','2023-03-21'),
(4166,3,1,79,'2023-03-21 09:25:00','2023-03-21 09:55:00',1800,'Assistenza su pc client Silvia per problemi ricezione spam, da verificare se pc client hanno virus',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-04 08:29:35','2023-03-21'),
(4167,3,1,108,'2023-03-21 10:20:00','2023-03-21 10:45:00',1500,'Assistenza su portatile Consuelo per problemi accesso webmail da rete locale',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-07 09:45:18','2023-03-21'),
(4169,1,1,55,'2023-03-21 20:00:00','2023-03-21 20:30:00',1800,'agg server, aggiornamento antispam e antivirus di posta',22.5,NULL,45,1,'Europe/Rome',22.5,1,'work','2023-03-28 16:14:09','2023-03-21'),
(4170,1,1,67,'2023-03-22 08:03:00','2023-03-22 11:29:00',12360,'migrazione\r\nproblema mail torlo sta seguendo fede',154.5,NULL,45,1,'Europe/Rome',154.5,1,'work','2023-04-03 20:55:17','2023-03-22'),
(4171,3,2,26,'2023-03-22 10:25:00','2023-03-22 11:45:00',4800,'Consegnato hhd esterno da 1 tb + copia dati pc client Sola, ripulito pc.client sola, assistenza su iPad dott Sola',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-07 09:32:42','2023-03-22'),
(4172,3,1,67,'2023-03-22 08:10:00','2023-03-22 09:10:00',3600,'Assistenza su pc client Sabrina Torlo per problemi posta su Outlook',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-03 21:04:20','2023-03-22'),
(4173,3,1,79,'2023-03-22 09:10:00','2023-03-22 09:20:00',600,'Assistenza su pc client Andrea',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-04 08:29:32','2023-03-22'),
(4174,3,1,96,'2023-03-22 09:35:00','2023-03-22 09:50:00',900,'Assistenza su pc client Irene',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-29 16:11:33','2023-03-22'),
(4175,3,1,55,'2023-03-22 13:35:00','2023-03-22 14:05:00',1800,'Installati nuovi file config vpn su portatile Riccardo Dallavalle',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-28 16:14:04','2023-03-22'),
(4176,3,1,4,'2023-03-22 14:10:00','2023-03-22 14:30:00',1200,'Aggiunta regola Firewall per software gestionale esterno',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-06 07:20:47','2023-03-22'),
(4177,3,2,104,'2023-03-22 15:20:00','2023-03-22 15:45:00',1500,'Consegna toner compatibili + chiamato Fastweb per passaggio linea dati',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-31 13:44:54','2023-03-22'),
(4178,3,1,108,'2023-03-22 16:10:00','2023-03-22 16:30:00',1200,'Riconfigurata posta su portatile Consuelo dopo cambio server',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-07 09:45:19','2023-03-22'),
(4179,1,1,67,'2023-03-22 14:00:00','2023-03-22 17:30:00',12600,'migrazione\r\nproblema mail torlo sta seguendo fede',157.5,NULL,45,1,'Europe/Rome',157.5,1,'work','2023-04-03 20:55:13','2023-03-22'),
(4180,1,1,67,'2023-03-22 21:13:00','2023-03-22 21:57:00',2640,'migrazione\r\nconfigurazione stampanti e pc di cristina',33,NULL,45,1,'Europe/Rome',33,1,'work','2023-04-03 21:04:15','2023-03-22'),
(4181,3,2,117,'2023-03-23 08:20:00','2023-03-23 10:20:00',7200,'Riconsegnato e configurato pc client sede Sampierdarena dopo upgrade hw e sw\r\nAssistenza su altri pc client presente',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-27 09:28:54','2023-03-23'),
(4182,3,2,12,'2023-03-23 10:40:00','2023-03-23 11:00:00',1200,'Configurati nuovi file vpn su iPad Vella e Francesca',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-03 14:36:50','2023-03-23'),
(4183,1,2,2,'2023-03-23 14:00:00','2023-03-23 14:30:00',1800,'sopraluogo con battistini poer cablaggio telecamere',22.5,NULL,45,1,'Europe/Rome',22.5,1,'work','2023-07-12 09:14:55','2023-03-23'),
(4184,1,1,81,'2023-03-23 15:28:00','2023-03-23 15:47:00',1140,'problema vpn',14.25,NULL,45,1,'Europe/Rome',14.25,1,'work','2023-07-12 10:20:12','2023-03-23'),
(4185,3,2,29,'2023-03-23 15:55:00','2023-03-23 16:10:00',900,'Consegnato nuovo portatile Francesca',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-07 09:35:38','2023-03-23'),
(4186,3,1,75,'2023-03-23 13:35:00','2023-03-23 14:20:00',2700,'Configurato mac casa Laura Stoehr per collegamento a pc ufficio di suo padre, lavoro da finire',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-06 16:18:42','2023-03-23'),
(4187,3,1,81,'2023-03-23 14:35:00','2023-03-23 14:55:00',1200,'Assistenza su pc Pellini per problema collegamento da remoto',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-07-12 10:20:10','2023-03-23'),
(4188,1,1,2,'2023-03-24 05:01:00','2023-03-24 06:10:00',4140,'problemi dopo scollegamento vecchio server',51.75,NULL,45,1,'Europe/Rome',51.75,1,'work','2023-07-12 09:24:57','2023-03-24'),
(4189,1,1,2,'2023-03-24 07:15:00','2023-03-24 08:58:00',6180,'problemi dopo scollegamento vecchio server',77.25,NULL,45,1,'Europe/Rome',77.25,1,'work','2023-07-12 09:25:26','2023-03-24'),
(4190,1,1,67,'2023-03-24 08:59:00','2023-03-24 09:15:34',994,'simone de paoli problema allegati',12.43,NULL,45,1,'Europe/Rome',12.43,1,'work','2023-04-03 20:55:20','2023-03-24'),
(4191,1,1,2,'2023-03-24 09:17:00','2023-03-24 10:26:00',4140,'problemi dopo scollegamento vecchio server',51.75,NULL,45,1,'Europe/Rome',51.75,1,'work','2023-07-12 09:25:26','2023-03-24'),
(4192,1,3,112,'2023-03-24 10:30:00','2023-03-24 11:30:00',3600,NULL,45,NULL,45,1,'Europe/Rome',45,1,'work','2023-04-05 20:56:13','2023-03-24'),
(4193,1,3,112,'2023-03-24 13:30:00','2023-03-24 14:18:00',2880,NULL,36,NULL,45,1,'Europe/Rome',36,1,'work','2023-04-05 20:56:14','2023-03-24'),
(4194,1,1,90,'2023-03-24 15:00:00','2023-03-24 15:35:00',2100,'pulizia nas',26.25,NULL,45,1,'Europe/Rome',26.25,1,'work','2023-05-03 10:03:07','2023-03-24'),
(4195,1,1,2,'2023-03-24 14:19:00','2023-03-24 14:56:00',2220,'risoluzione problema infovision',27.75,NULL,45,1,'Europe/Rome',27.75,1,'work','2023-07-12 09:25:03','2023-03-24'),
(4196,1,1,75,'2023-03-24 15:46:00','2023-03-24 16:09:00',1380,'aiutato fede con problemi wireguard',17.25,NULL,45,1,'Europe/Rome',17.25,1,'work','2023-04-06 15:35:08','2023-03-24'),
(4197,3,1,79,'2023-03-24 08:05:00','2023-03-24 08:55:00',3000,'Sostituzione password office@parodinutra.com per problema invio spam, da ritirare pc Silvia e Roberto per verifica presenza virus',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-04 08:29:46','2023-03-24'),
(4198,3,1,90,'2023-03-24 10:20:00','2023-03-24 11:20:00',3600,'Assistenza su 2 pc client per problemi con webcam e audio, copiati dati vecchio pc su NAS',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-05-03 10:03:16','2023-03-24'),
(4199,3,1,75,'2023-03-24 13:40:00','2023-03-24 14:30:00',3000,'Assistenza su Mac Laura Stoehr per collegamento remoto su pc ufficio padre',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-06 16:18:37','2023-03-24'),
(4200,3,1,75,'2023-03-24 15:20:00','2023-03-24 15:50:00',1800,'Assistenza su Mac Laura Stoehr per collegamento remoto su pc ufficio padre',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-06 16:18:45','2023-03-24'),
(4201,3,1,96,'2023-03-24 14:35:00','2023-03-24 14:55:00',1200,'Assistenza per collegamento a videocall',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-29 16:11:37','2023-03-24'),
(4202,3,2,104,'2023-03-24 16:30:00','2023-03-24 17:40:00',4200,'Assistenza e configurazione per passaggio linea dati da Vodafone a Fastweb',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-31 13:44:57','2023-03-24'),
(4203,1,1,2,'2023-03-24 16:15:00','2023-03-24 18:20:00',7500,'risoluzione problema infovision',93.75,NULL,45,1,'Europe/Rome',93.75,1,'work','2023-07-12 09:25:02','2023-03-24'),
(4204,1,1,95,'2023-03-27 06:56:00','2023-03-27 07:40:12',2652,'vpn patronato',33.15,NULL,45,1,'Europe/Rome',33.15,1,'work','2023-07-11 14:06:30','2023-03-27'),
(4205,3,2,104,'2023-03-27 06:45:00','2023-03-27 07:45:00',3600,'Assistenza per problemi su telefoni e collegamento a gemini dopo cambio operatore',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-31 13:44:55','2023-03-27'),
(4206,1,1,104,'2023-03-27 13:10:00','2023-03-27 14:35:57',5157,'p[ulizia ip fastweb',64.46,NULL,45,1,'Europe/Rome',64.46,1,'work','2023-03-31 13:44:56','2023-03-27'),
(4207,1,1,95,'2023-03-27 12:48:00','2023-03-27 13:00:00',720,'dominio studioemmege.it',9,NULL,45,1,'Europe/Rome',9,1,'work','2023-07-11 14:06:27','2023-03-27'),
(4208,1,1,95,'2023-03-27 14:35:59','2023-03-27 15:38:48',3769,'dominio studioemmege.it',47.11,NULL,45,1,'Europe/Rome',47.11,1,'work','2023-07-11 14:06:30','2023-03-27'),
(4209,1,1,2,'2023-03-27 08:00:00','2023-03-27 09:22:00',4920,'consolidamento configurazione server 2008 virtuale, configurazione mensile backup vm 2008',61.5,NULL,45,1,'Europe/Rome',61.5,1,'work','2023-07-12 09:25:11','2023-03-27'),
(4210,1,1,50,'2023-03-27 09:36:00','2023-03-27 10:30:00',3240,'agg 3cx',40.5,NULL,45,1,'Europe/Rome',40.5,1,'work','2023-04-03 16:03:48','2023-03-27'),
(4211,3,2,55,'2023-03-27 13:40:00','2023-03-27 15:00:00',4800,'Consegnato e configurato nuovo portatile GLD',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-28 16:15:18','2023-03-27'),
(4212,1,1,114,'2023-03-27 15:39:00','2023-03-27 15:55:58',1018,'config wifi fede liu',12.73,NULL,45,1,'Europe/Rome',12.73,1,'work','2023-04-11 15:52:52','2023-03-27'),
(4213,3,2,114,'2023-03-27 15:30:00','2023-03-27 15:50:00',1200,'Configurazione unifi nell\'ufficio provvisorio',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-11 15:52:51','2023-03-27'),
(4214,1,1,95,'2023-03-27 15:56:00','2023-03-27 16:55:57',3597,'dominio studioemmege.it\r\nmara problema stampante\r\nsilvia separazione mail su domini diversi',44.96,NULL,45,1,'Europe/Rome',44.96,1,'work','2023-07-11 14:06:27','2023-03-27'),
(4215,3,1,96,'2023-03-27 08:00:00','2023-03-27 08:10:00',600,'Assistenza su pc client Marilena',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-29 16:11:31','2023-03-27'),
(4216,3,1,38,'2023-03-27 08:10:00','2023-03-27 08:25:00',900,'Verificato pc client con problemi disco, fissato intervernto in loco',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-14 15:21:10','2023-03-27'),
(4217,3,2,104,'2023-03-27 09:25:00','2023-03-27 10:00:00',2100,'Assistenza su portatile e iPhone Daniele dopo cambio operatore',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-31 13:44:58','2023-03-27'),
(4218,1,1,95,'2023-03-27 19:48:00','2023-03-27 20:38:00',3000,'dominio studioemmege.it\r\nsilvia separazione mail su domini diversi',37.5,NULL,45,1,'Europe/Rome',37.5,1,'work','2023-07-11 14:06:28','2023-03-27'),
(4219,1,1,4,'2023-03-28 15:16:00','2023-03-28 15:22:11',371,'probleme strazione foto da programma',4.64,NULL,45,1,'Europe/Rome',4.64,1,'work','2023-04-06 07:57:24','2023-03-28'),
(4220,3,1,100,'2023-03-28 08:30:00','2023-03-28 08:40:00',600,'Assistenza su nuovo mac Riccardo per problemi risoluzione schermo',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-06 08:28:17','2023-03-28'),
(4221,3,1,108,'2023-03-28 09:35:00','2023-03-28 09:45:00',600,'Attivato reverse DNS su mail.villaserra.it',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-07 09:45:20','2023-03-28'),
(4222,1,1,88,'2023-03-28 15:33:00','2023-03-28 15:58:00',1500,'per verifica installazione vm',18.75,NULL,45,1,'Europe/Rome',18.75,1,'work','2023-04-06 08:55:53','2023-03-28'),
(4223,1,1,5,'2023-03-28 06:47:00','2023-03-28 08:27:00',6000,'agg server \r\nagg nas',75,NULL,45,1,'Europe/Rome',75,1,'work','2023-04-06 09:26:13','2023-03-28'),
(4224,1,1,103,'2023-03-28 08:42:00','2023-03-28 10:28:00',6360,'agg server\r\nagg 3cx',79.5,NULL,45,1,'Europe/Rome',79.5,1,'work','2023-04-07 07:39:19','2023-03-28'),
(4225,1,1,103,'2023-03-28 12:43:00','2023-03-28 13:48:00',3900,'agg server\r\nagg 3cx',48.75,NULL,45,1,'Europe/Rome',48.75,1,'work','2023-04-07 07:39:20','2023-03-28'),
(4226,1,1,1,'2023-03-28 14:00:00','2023-03-28 15:00:00',3600,'agg server posta e 3cx',45,NULL,45,1,'Europe/Rome',45,1,'work','2023-05-09 09:45:06','2023-03-28'),
(4227,1,1,1,'2023-03-28 16:00:00','2023-03-28 16:52:00',3120,'agg server posta e 3cx',39,NULL,45,1,'Europe/Rome',39,1,'work','2023-05-09 09:28:42','2023-03-28'),
(4228,1,1,50,'2023-03-28 19:00:00','2023-03-28 19:33:00',1980,'agg 3cx',24.75,NULL,45,1,'Europe/Rome',24.75,1,'work','2023-04-03 16:03:49','2023-03-28'),
(4229,1,1,110,'2023-03-28 19:35:00','2023-03-28 20:03:00',1680,'agg 3cx',21,NULL,45,1,'Europe/Rome',21,1,'work','2023-04-06 16:19:41','2023-03-28'),
(4230,1,1,24,'2023-03-28 20:10:00','2023-03-28 20:37:00',1620,'agg 3cx',20.25,NULL,45,1,'Europe/Rome',20.25,1,'work','2023-05-05 09:37:23','2023-03-28'),
(4231,1,1,90,'2023-03-29 06:31:00','2023-03-29 08:37:00',7560,'problema server bloccato in riavvio dopo aggiornamento',94.5,NULL,45,1,'Europe/Rome',94.5,1,'work','2023-05-03 10:03:17','2023-03-29'),
(4232,1,1,22,'2023-03-29 08:38:00','2023-03-29 08:55:41',1061,'cambio ip pubblico',13.26,NULL,45,1,'Europe/Rome',13.26,1,'work','2023-06-20 09:30:56','2023-03-29'),
(4233,1,1,2,'2023-03-29 09:35:00','2023-03-29 09:42:41',461,'problema office pc rappresentante',5.76,NULL,45,1,'Europe/Rome',5.76,1,'work','2023-07-12 09:25:02','2023-03-29'),
(4234,1,1,2,'2023-03-29 09:47:00','2023-03-29 09:54:00',420,'problema office pc rappresentante',5.25,NULL,45,1,'Europe/Rome',5.25,1,'work','2023-07-12 09:25:26','2023-03-29'),
(4235,3,2,38,'2023-03-29 08:00:00','2023-03-29 11:50:00',13800,'Assistenza su PC client per problemi su file system, ritirato pc client per blocco durante verifiche',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-14 15:25:30','2023-03-29'),
(4236,1,1,55,'2023-03-29 12:46:00','2023-03-29 13:10:00',1440,'problema coedit',18,NULL,45,1,'Europe/Rome',18,1,'work','2023-06-09 08:34:40','2023-03-29'),
(4237,1,1,96,'2023-03-29 14:43:00','2023-03-29 15:13:56',1856,'aiutato fede con config 3cx',23.2,NULL,45,1,'Europe/Rome',23.2,1,'work','2023-03-29 16:11:43','2023-03-29'),
(4238,1,1,29,'2023-03-29 13:14:00','2023-03-29 14:40:00',5160,'agg server',64.5,NULL,45,1,'Europe/Rome',64.5,1,'work','2023-04-11 15:41:00','2023-03-29'),
(4239,1,1,29,'2023-03-29 15:14:00','2023-03-29 17:00:00',6360,'agg server',79.5,NULL,45,1,'Europe/Rome',79.5,1,'work','2023-04-11 15:41:01','2023-03-29'),
(4240,3,2,96,'2023-03-29 13:35:00','2023-03-29 15:05:00',5400,'Assistenza su vari pc client e telefoni voip',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-03-30 08:53:52','2023-03-29'),
(4241,3,2,100,'2023-03-29 15:10:00','2023-03-29 15:50:00',2400,'Aggiornato sistema operativo su vecchio Mac Riccardo',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-06 08:28:14','2023-03-29'),
(4242,1,1,2,'2023-03-30 08:33:00','2023-03-30 09:00:06',1626,'problemi scanner',20.33,NULL,45,1,'Europe/Rome',20.33,1,'work','2023-07-12 09:24:58','2023-03-30'),
(4243,1,1,26,'2023-03-30 09:04:00','2023-03-30 09:15:36',696,'importa posta inviata banci',8.7,NULL,45,1,'Europe/Rome',8.7,1,'work','2023-04-07 09:32:39','2023-03-30'),
(4244,1,1,95,'2023-03-30 09:16:00','2023-03-30 10:33:03',4623,'config nuovo dominio silcedge.it',57.79,NULL,45,1,'Europe/Rome',57.79,1,'work','2023-07-11 13:51:03','2023-03-30'),
(4245,1,1,26,'2023-03-30 13:10:00','2023-03-30 15:10:00',7200,'importa posta inviata banci',90,NULL,45,1,'Europe/Rome',90,1,'work','2023-04-07 09:32:43','2023-03-30'),
(4246,1,1,2,'2023-03-30 12:35:00','2023-03-30 13:00:00',1500,'qnap inchiodato',18.75,NULL,45,1,'Europe/Rome',18.75,1,'work','2023-07-12 09:25:10','2023-03-30'),
(4247,3,2,38,'2023-03-30 14:45:00','2023-03-30 15:00:00',900,'Riconsegnato pc client dopo assistenza, configurazione da finire remotamente',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-14 15:21:23','2023-03-30'),
(4248,1,1,2,'2023-03-30 15:12:00','2023-03-30 18:05:00',10380,'qnap inchiodato\r\nriconfigurazione backup su qnap e su server',129.75,NULL,45,1,'Europe/Rome',129.75,1,'work','2023-07-12 09:25:34','2023-03-30'),
(4249,3,1,75,'2023-03-30 07:15:00','2023-03-30 07:30:00',900,'Assistenza su pc client G. Figari per problemi con stampante Ricoh',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-06 16:18:41','2023-03-30'),
(4250,3,1,100,'2023-03-30 07:45:00','2023-03-30 08:05:00',1200,'Terminati aggiornamenti dopo upgrade s.o da macOs High Sierra a Catalina',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-06 08:28:10','2023-03-30'),
(4251,3,1,1,'2023-03-30 08:20:00','2023-03-30 08:35:00',900,'Assistenza su pc client Francesco per problemi con account posta sales@aldorapallo.it',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-05-09 09:44:55','2023-03-30'),
(4252,3,4,38,'2023-03-30 09:00:00','2023-03-30 10:00:00',3600,'Reinstallato sistema operativo su pc client ritirato, utilizzato ssd 980gb S3+',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-14 15:25:30','2023-03-30'),
(4253,1,1,2,'2023-03-31 06:49:00','2023-03-31 07:36:00',2820,'problemi stampa fra\r\nagg firmware stampanti',35.25,NULL,45,1,'Europe/Rome',35.25,1,'work','2023-07-12 09:24:59','2023-03-31'),
(4254,1,1,3,'2023-03-31 08:45:00','2023-03-31 09:09:00',1440,'macbook privata',18,NULL,45,1,'Europe/Rome',18,1,'work','2023-04-05 21:02:57','2023-03-31'),
(4255,1,1,4,'2023-03-31 09:10:00','2023-03-31 09:15:30',330,'problema port forwarding',4.13,NULL,45,1,'Europe/Rome',4.13,1,'work','2023-04-06 07:57:26','2023-03-31'),
(4256,1,1,88,'2023-03-31 09:17:00','2023-03-31 09:29:00',720,'config vpn posta e 3cx su nuovo portatile giorgio piazza',9,NULL,45,1,'Europe/Rome',9,1,'work','2023-04-06 09:19:18','2023-03-31'),
(4257,1,1,2,'2023-03-31 09:38:00','2023-03-31 09:52:07',847,'server irraggiungibile',10.59,NULL,45,1,'Europe/Rome',10.59,1,'work','2023-07-12 09:22:27','2023-03-31'),
(4258,1,1,3,'2023-03-31 09:52:20','2023-03-31 10:25:15',1975,'macbook privata',24.69,NULL,45,1,'Europe/Rome',24.69,1,'work','2023-04-05 21:02:56','2023-03-31'),
(4259,1,1,3,'2023-03-31 12:43:00','2023-03-31 14:01:00',4680,'macbook privata',58.5,NULL,45,1,'Europe/Rome',58.5,1,'work','2023-04-05 21:02:56','2023-03-31'),
(4260,1,1,87,'2023-03-31 14:54:00','2023-03-31 15:08:22',862,'problema key firma digitale',10.78,NULL,45,1,'Europe/Rome',10.78,1,'work','2023-06-20 09:26:19','2023-03-31'),
(4261,3,2,100,'2023-03-31 14:45:00','2023-03-31 16:10:00',5100,'Assistenza su mac e iphone Sirotti, utilizzato 2 cavi LAN da 1 mt',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-06 08:28:11','2023-03-31'),
(4262,3,2,104,'2023-03-31 09:40:00','2023-03-31 10:10:00',1800,'Assistenza per problemi accesso a Gemini \r\nAssistenza su stampante Samsung',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-03 16:03:28','2023-03-31'),
(4263,1,1,95,'2023-04-03 08:31:00','2023-04-03 08:43:18',738,'configurazione mail',9.23,NULL,45,1,'Europe/Rome',9.23,1,'work','2023-07-11 14:06:28','2023-04-03'),
(4264,1,1,2,'2023-04-03 07:18:00','2023-04-03 07:33:00',900,'problema indici mail pc francesca',11.25,NULL,45,1,'Europe/Rome',11.25,1,'work','2023-07-12 09:24:59','2023-04-03'),
(4265,3,2,117,'2023-04-03 09:40:00','2023-04-03 10:05:00',1500,'Verificato e ritirato scanner verticale per sostituzione alimentatore',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-07-12 14:31:30','2023-04-03'),
(4266,3,2,50,'2023-04-03 10:35:00','2023-04-03 10:45:00',600,'Ritirato portatile figlia Gigio per assistenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-03 16:03:50','2023-04-03'),
(4267,1,1,67,'2023-04-03 13:25:00','2023-04-03 15:15:00',6600,'problema citrix su pc cristina',82.5,NULL,45,1,'Europe/Rome',82.5,1,'work','2023-04-03 21:04:14','2023-04-03'),
(4268,1,1,67,'2023-04-03 16:01:00','2023-04-03 17:30:46',5386,'spostamento posta simona ganzarolli',67.33,NULL,45,1,'Europe/Rome',67.33,1,'work','2023-04-03 20:55:15','2023-04-03'),
(4269,3,1,26,'2023-04-03 07:15:00','2023-04-03 07:25:00',600,'Assistenza su pc client Banci per mail spam ricevuta',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-07 09:32:39','2023-04-03'),
(4270,3,2,104,'2023-04-03 07:45:00','2023-04-03 08:25:00',2400,'Assistenza su iPhone Daniele per problemi visualizzazione telecamere, da risolvere problema posta fuori ufficio (aspettiamo risposta da Fastweb)',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-05-09 14:11:14','2023-04-03'),
(4271,3,1,38,'2023-04-03 08:40:00','2023-04-03 09:00:00',1200,'Assistenza su pc client reinstallato per ultimare la confiugrazione, manca da reinstallare un software',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-14 15:25:32','2023-04-03'),
(4272,3,4,104,'2023-04-03 14:00:00','2023-04-03 14:15:00',900,'Sostituzione batteria su portatile Acer Agente',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-05-09 14:11:15','2023-04-03'),
(4273,3,1,96,'2023-04-03 14:20:00','2023-04-03 14:30:00',600,'Assistenza su pc client Irene',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-05-19 07:00:16','2023-04-03'),
(4274,3,1,96,'2023-04-03 15:25:00','2023-04-03 15:40:00',900,'Disinstallata app Desktop 3cx su tutti pc client per problemi di sicurezza',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-05-19 07:00:17','2023-04-03'),
(4275,3,2,50,'2023-04-03 15:50:00','2023-04-03 16:00:00',600,'Disinstallata app Desktop 3cx su pc client Loretta e Pietro per problemi di sicurezza',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-04 06:13:37','2023-04-03'),
(4276,1,1,96,'2023-04-03 12:49:00','2023-04-03 13:16:00',1620,'agg app 3cx su server',20.25,NULL,45,1,'Europe/Rome',20.25,1,'work','2023-05-12 09:54:37','2023-04-03'),
(4277,1,1,50,'2023-04-03 15:33:00','2023-04-03 16:00:00',1620,'agg app 3cx su server',20.25,NULL,45,1,'Europe/Rome',20.25,1,'work','2023-04-04 06:13:36','2023-04-03'),
(4278,1,3,112,'2023-04-04 06:30:00','2023-04-04 07:45:00',4500,NULL,56.25,NULL,45,1,'Europe/Rome',56.25,1,'work','2023-07-12 10:20:51','2023-04-04'),
(4279,1,1,29,'2023-04-04 08:08:00','2023-04-04 08:17:23',563,'ferifica config notebook francesca per collegamento studio',7.04,NULL,45,1,'Europe/Rome',7.04,1,'work','2023-04-07 09:43:36','2023-04-04'),
(4280,1,1,67,'2023-04-04 08:30:00','2023-04-04 11:01:00',9060,'completamento spostamento posta simona ganzarolli\r\nstudio per gestione alias simile a come funzionava su nostro server',113.25,NULL,45,1,'Europe/Rome',113.25,1,'work','2023-05-05 15:03:30','2023-04-04'),
(4281,1,1,67,'2023-04-04 12:34:00','2023-04-04 12:45:00',660,'completamento spostamento posta simona ganzarolli problemi su servizio clienti risolti',8.25,NULL,45,1,'Europe/Rome',8.25,1,'work','2023-05-05 15:03:22','2023-04-04'),
(4282,1,1,2,'2023-04-04 12:59:00','2023-04-04 14:18:00',4740,'sistemazione stampanti pc francesca',59.25,NULL,45,1,'Europe/Rome',59.25,1,'work','2023-07-12 09:25:01','2023-04-04'),
(4283,1,4,3,'2023-03-01 07:30:00','2023-03-01 08:32:00',3720,NULL,46.5,NULL,45,1,'Europe/Rome',46.5,1,'work','2023-04-05 21:02:54','2023-03-01'),
(4284,1,1,50,'2023-03-06 09:53:00','2023-03-06 10:35:00',2520,'aggiornamenti vari',31.5,NULL,45,1,'Europe/Rome',31.5,1,'work','2023-04-11 14:54:15','2023-03-06'),
(4285,1,1,108,'2023-03-13 16:00:00','2023-03-13 17:18:00',4680,'server nuovo',58.5,NULL,45,1,'Europe/Rome',58.5,1,'work','2023-04-07 09:45:17','2023-03-13'),
(4286,1,1,50,'2023-03-16 07:49:00','2023-03-16 09:00:00',4260,'problemi log proxmox',53.25,NULL,45,1,'Europe/Rome',53.25,1,'work','2023-04-11 14:54:18','2023-03-16'),
(4287,1,1,29,'2023-03-16 09:19:00','2023-03-16 11:30:00',7860,'agg server windows',98.25,NULL,45,1,'Europe/Rome',98.25,1,'work','2023-04-11 15:40:59','2023-03-16'),
(4288,1,1,90,'2023-03-16 15:10:00','2023-03-16 16:48:00',5880,'problemi firewall pieno',73.5,NULL,45,1,'Europe/Rome',73.5,1,'work','2023-05-03 10:03:16','2023-03-16'),
(4289,1,3,112,'2023-03-21 10:30:00','2023-03-21 11:30:00',3600,NULL,45,NULL,45,1,'Europe/Rome',45,1,'work','2023-04-05 20:56:12','2023-03-21'),
(4290,1,3,112,'2023-03-21 17:00:00','2023-03-21 17:30:00',1800,NULL,22.5,NULL,45,1,'Europe/Rome',22.5,1,'work','2023-04-05 20:56:12','2023-03-21'),
(4291,1,1,67,'2023-03-23 07:55:00','2023-03-23 09:37:00',6120,'migrazione posta',76.5,NULL,45,1,'Europe/Rome',76.5,1,'work','2023-05-05 14:29:19','2023-03-23'),
(4292,1,1,2,'2023-03-23 10:00:00','2023-03-23 11:26:00',5160,'preparazione per spegnimento vecchio server',64.5,NULL,45,1,'Europe/Rome',64.5,1,'work','2023-07-12 09:24:57','2023-03-23'),
(4293,1,1,3,'2023-03-30 06:46:00','2023-03-30 08:19:00',5580,'test agg cumulativo windows server',69.75,NULL,45,1,'Europe/Rome',69.75,1,'work','2023-04-05 21:02:57','2023-03-30'),
(4294,1,1,3,'2023-03-31 15:14:00','2023-03-31 15:47:00',1980,'macbook privata',24.75,NULL,45,1,'Europe/Rome',24.75,1,'work','2023-04-05 21:03:02','2023-03-31'),
(4295,1,1,3,'2023-03-31 16:00:00','2023-03-31 16:30:00',1800,'test agg windows server',22.5,NULL,45,1,'Europe/Rome',22.5,1,'work','2023-04-05 21:03:07','2023-03-31'),
(4296,1,1,3,'2023-03-31 14:14:00','2023-03-31 14:49:00',2100,'test agg windows server',26.25,NULL,45,1,'Europe/Rome',26.25,1,'work','2023-04-05 21:03:01','2023-03-31'),
(4297,1,1,3,'2023-04-04 15:33:00','2023-04-04 16:27:00',3240,'fogli',40.5,NULL,45,1,'Europe/Rome',40.5,1,'work','2023-07-11 14:08:11','2023-04-04'),
(4298,3,1,1,'2023-04-04 06:50:00','2023-04-04 07:10:00',1200,'Disinstallata app Desktop 3cx su tutti pc client per problemi di sicurezza',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-05-09 09:45:02','2023-04-04'),
(4299,3,1,103,'2023-04-04 07:10:00','2023-04-04 07:25:00',900,'Disinstallata app Desktop 3cx su tutti pc client per problemi di sicurezza',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-07 07:39:21','2023-04-04'),
(4300,3,1,24,'2023-04-04 07:50:00','2023-04-04 08:05:00',900,'Disinstallata app Desktop 3cx su tutti pc client per problemi di sicurezza',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-05-05 09:41:54','2023-04-04'),
(4301,3,1,88,'2023-04-04 08:20:00','2023-04-04 08:45:00',1500,'Disinstallata app Desktop 3cx su tutti pc client per problemi di sicurezza',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-06 09:19:18','2023-04-04'),
(4302,3,1,50,'2023-04-04 09:00:00','2023-04-04 09:10:00',600,'Disinstallata app Desktop 3cx su pc client Elisabetta e Francesco per problemi di sicurezza',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-11 14:54:20','2023-04-04'),
(4303,3,4,50,'2023-04-04 09:20:00','2023-04-04 10:20:00',3600,'Reinstallato s.o su portatile HP figlia Gigio + alim usato HP',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-11 14:54:23','2023-04-04'),
(4304,1,1,67,'2023-04-05 08:26:00','2023-04-05 10:30:00',7440,'configurazione mail pier thoux su secondo notebook\r\nproblemi servizio clienti',93,NULL,45,1,'Europe/Rome',93,1,'work','2023-05-05 15:03:22','2023-04-05'),
(4305,1,1,3,'2023-04-05 08:01:00','2023-04-05 08:22:00',1260,'stabilito con alex funzionamento backup remoto per gandolfo',15.75,NULL,45,1,'Europe/Rome',15.75,1,'work','2023-07-11 14:08:11','2023-04-05'),
(4306,1,1,67,'2023-04-05 06:49:00','2023-04-05 08:00:00',4260,'problema alias',53.25,NULL,45,1,'Europe/Rome',53.25,1,'work','2023-05-05 15:03:22','2023-04-05'),
(4307,1,1,67,'2023-04-04 14:27:00','2023-04-04 15:17:00',3000,'problema alias',37.5,NULL,45,1,'Europe/Rome',37.5,1,'work','2023-05-05 15:03:25','2023-04-04'),
(4308,3,2,117,'2023-04-05 13:45:00','2023-04-05 14:30:00',2700,'Riconsegnato e configurato scanner verticale \r\nAssistenza su PC client, ritirato pc client per assistenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-07-12 14:31:31','2023-04-05'),
(4309,3,2,50,'2023-04-05 14:45:00','2023-04-05 16:10:00',5100,'Riconsegnato portatile HP figlia Gigio dopo assistenza, assistenza su server dopo aggiornamenti sistema e riavvio\r\nAssistenza su PC client Loretta',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-11 14:54:29','2023-04-05'),
(4310,1,1,2,'2023-04-06 09:27:00','2023-04-06 10:27:00',3600,'lamentano lentezza bollicine',45,NULL,45,1,'Europe/Rome',45,1,'work','2023-07-12 09:25:30','2023-04-06'),
(4311,1,1,67,'2023-04-05 12:49:00','2023-04-05 16:01:00',11520,'servizio clienti studio alias',144,NULL,45,1,'Europe/Rome',144,1,'work','2023-05-05 15:03:22','2023-04-05'),
(4312,1,1,95,'2023-04-06 08:18:00','2023-04-06 09:14:00',3360,'problema certificati ssl non si aggiornano, dopo aggiornamento altra cartella con certificati, riconfigurati postfix e dovecot per nuovo percorso',42,NULL,45,1,'Europe/Rome',42,1,'work','2023-04-07 07:43:51','2023-04-06'),
(4313,1,1,50,'2023-04-05 16:05:00','2023-04-05 16:25:00',1200,'configurazione script pulizia log',15,NULL,45,1,'Europe/Rome',15,1,'work','2023-04-11 14:54:32','2023-04-05'),
(4314,3,1,55,'2023-04-06 07:20:00','2023-04-06 08:20:00',3600,'Assistenza su pc cliente Floriana per problemi con Thunderbird, da finire (segue Cla)',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-06-09 08:32:55','2023-04-06'),
(4315,3,1,45,'2023-04-06 08:55:00','2023-04-06 09:05:00',600,'Verificata possibilità upgrade hw su pc client Claudio Rossi',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-06-09 08:36:19','2023-04-06'),
(4316,3,4,117,'2023-04-06 09:20:00','2023-04-06 10:20:00',3600,'Spostato ssd e ram da pc client non riparabile a pc client ritirato per assistenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-07-12 14:31:32','2023-04-06'),
(4317,3,2,79,'2023-04-06 15:20:00','2023-04-06 15:30:00',600,'Consegnati toner compatibili per stampante Brother',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-07-12 14:43:27','2023-04-06'),
(4318,1,1,67,'2023-04-06 14:45:00','2023-04-06 16:00:00',4500,'servizio clienti studio alias',56.25,NULL,45,1,'Europe/Rome',56.25,1,'work','2023-05-05 15:03:31','2023-04-06'),
(4319,1,2,95,'2023-04-06 14:02:00','2023-04-06 14:35:00',1980,'per cose nostre',24.75,NULL,45,1,'Europe/Rome',24.75,1,'work','2023-04-07 10:15:15','2023-04-06'),
(4320,1,1,67,'2023-04-06 12:57:00','2023-04-06 14:00:00',3780,'servizio clienti studio alias',47.25,NULL,45,1,'Europe/Rome',47.25,1,'work','2023-05-05 15:03:23','2023-04-06'),
(4321,1,1,67,'2023-04-07 09:00:00','2023-04-07 09:29:00',1740,'servizio clienti sistemato, pc sabrina',21.75,NULL,45,1,'Europe/Rome',21.75,1,'work','2023-05-05 15:03:18','2023-04-07'),
(4322,1,1,55,'2023-04-06 16:11:00','2023-04-06 17:00:00',2940,'problema mail floriana',36.75,NULL,45,1,'Europe/Rome',36.75,1,'work','2023-06-13 10:10:40','2023-04-06'),
(4323,1,1,55,'2023-04-07 06:46:00','2023-04-07 07:06:00',1200,'problema mail floriana',15,NULL,45,1,'Europe/Rome',15,1,'work','2023-06-13 10:10:41','2023-04-07'),
(4324,1,1,55,'2023-04-07 10:07:00','2023-04-07 10:29:00',1320,'problema mail floriana',16.5,NULL,45,1,'Europe/Rome',16.5,1,'work','2023-06-13 10:10:57','2023-04-07'),
(4325,1,1,95,'2023-04-07 14:46:00','2023-04-07 16:25:00',5940,'sistemazione gestionale\r\n e verifica funzionamento backup raggiungibilità e ssl certbot',74.25,NULL,45,1,'Europe/Rome',74.25,1,'work','2023-06-27 08:35:43','2023-04-07'),
(4326,3,1,79,'2023-04-07 06:45:00','2023-04-07 07:00:00',900,'Assistenza su pc client Paola Agnoletto per problemi accesso su OneDrive',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-07-12 15:31:16','2023-04-07'),
(4327,3,2,104,'2023-04-07 07:05:00','2023-04-07 07:20:00',900,'Assistenza su server dopo riavvio per aggiornamenti',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-17 10:04:03','2023-04-07'),
(4328,3,1,104,'2023-04-07 07:30:00','2023-04-07 07:45:00',900,'Chiamato Fastweb per apertura porte su router',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-05-09 14:11:17','2023-04-07'),
(4329,3,1,38,'2023-04-07 08:20:00','2023-04-07 09:00:00',2400,'Finita configurazione pc client riconsegnato dopo assistenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-14 15:25:36','2023-04-07'),
(4330,3,2,104,'2023-04-07 12:30:00','2023-04-07 13:00:00',1800,'Configurata vpn su portatile Daniele Repetto',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-05-09 14:11:18','2023-04-07'),
(4331,3,1,1,'2023-04-07 13:40:00','2023-04-07 13:50:00',600,'Configurata risposta automatica su account Andrea Bodrato',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-05-09 09:45:07','2023-04-07'),
(4332,3,2,50,'2023-04-11 08:15:00','2023-04-11 08:25:00',600,'Consegna cartucce Epson originali \r\nRitirato portatile Gigio per assistenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-11 14:54:38','2023-04-11'),
(4333,1,1,114,'2023-04-11 09:55:00','2023-04-11 10:30:00',2100,'agg nas e sistemazione per ban ip',26.25,NULL,45,1,'Europe/Rome',26.25,1,'work','2023-04-11 15:52:54','2023-04-11'),
(4334,1,1,51,'2023-04-11 12:45:00','2023-04-11 14:20:00',5700,'aggiornmaneto unifi conteoller dopo che hanno lamentato problemi al wifi\r\naggiornamento firmware access point',71.25,NULL,45,1,'Europe/Rome',71.25,1,'work','2023-05-19 13:55:11','2023-04-11'),
(4335,3,1,96,'2023-04-11 09:30:00','2023-04-11 10:10:00',2400,'Assistenza su pc client Gandolfo per problemi con Outlook 2013\r\nAssistenza su pc client cliente Gandolfo per problema invio file p7m',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-05-19 07:00:18','2023-04-11'),
(4336,3,4,50,'2023-04-11 13:30:00','2023-04-11 14:30:00',3600,'Reinstallato portatile Gigio + assistenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-05-05 09:36:17','2023-04-11'),
(4337,1,1,95,'2023-04-11 14:40:00','2023-04-11 16:22:00',6120,'problema ora su server',76.5,NULL,45,1,'Europe/Rome',76.5,1,'work','2023-06-26 16:35:16','2023-04-11'),
(4338,1,1,67,'2023-04-12 09:28:00','2023-04-12 10:21:00',3180,'servizio clienti simona\r\ne preparazione pst per import su altri client',39.75,NULL,45,1,'Europe/Rome',39.75,1,'work','2023-05-05 15:03:24','2023-04-12'),
(4339,1,1,67,'2023-04-12 12:52:00','2023-04-12 13:35:53',2633,'servizio clienti simona\r\ne preparazione pst per import su altri client',32.91,NULL,45,1,'Europe/Rome',32.91,1,'work','2023-05-05 15:03:18','2023-04-12'),
(4340,1,1,61,'2023-04-12 13:36:00','2023-04-12 14:01:02',1502,'problema lentezza pc',18.78,NULL,45,1,'Europe/Rome',18.78,1,'work','2023-06-09 14:52:38','2023-04-12'),
(4341,3,2,117,'2023-04-12 13:35:00','2023-04-12 14:05:00',1800,'Riconsegnato e configurato pc client dopo assistenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-07-12 14:31:33','2023-04-12'),
(4342,1,1,83,'2023-04-12 14:03:00','2023-04-12 14:13:03',603,'problema stampa',7.54,NULL,45,1,'Europe/Rome',7.54,1,'work','2023-07-12 16:23:27','2023-04-12'),
(4343,1,1,67,'2023-04-12 14:29:28','2023-04-12 15:19:25',2997,'servizio clienti simona\r\ne preparazione pst per import su altri client',37.46,NULL,45,1,'Europe/Rome',37.46,1,'work','2023-05-05 15:03:19','2023-04-12'),
(4344,1,1,95,'2023-04-12 15:35:43','2023-04-12 16:56:25',4842,'problema ora su server',60.53,NULL,45,1,'Europe/Rome',60.53,1,'work','2023-06-26 16:35:20','2023-04-12'),
(4345,3,1,1,'2023-04-12 07:55:00','2023-04-12 08:05:00',600,'Verificato possibile problema ricezione mail, il problema riguardava il mittente',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-05-09 09:44:59','2023-04-12'),
(4346,3,1,38,'2023-04-12 12:30:00','2023-04-12 12:55:00',1500,'Completata configurazione su pc client riconsegnato dopo reinstallazione',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-04-14 15:25:32','2023-04-12'),
(4347,1,1,81,'2023-04-13 07:34:00','2023-04-13 08:13:54',2394,'problema vpn',29.93,NULL,45,1,'Europe/Rome',29.93,1,'work','2023-07-12 10:20:21','2023-04-13'),
(4348,1,1,95,'2023-04-13 08:31:00','2023-04-13 09:25:00',3240,'ancora problema ora e delucidazioni a porcile su spazio disco',40.5,NULL,45,1,'Europe/Rome',40.5,1,'work','2023-06-26 16:35:27','2023-04-13'),
(4349,1,3,112,'2023-04-13 09:30:00','2023-04-13 10:30:00',3600,NULL,45,NULL,45,1,'Europe/Rome',45,1,'work','2023-07-12 10:20:52','2023-04-13'),
(4350,3,2,96,'2023-04-13 13:20:00','2023-04-13 13:45:00',1500,'Assistenza su PC client Irene',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-05-19 07:00:20','2023-04-13'),
(4351,1,1,95,'2023-04-13 12:40:00','2023-04-13 13:27:00',2820,'ancora problema ora e delucidazioni a porcile su spazio disco',35.25,NULL,45,1,'Europe/Rome',35.25,1,'work','2023-06-26 16:35:29','2023-04-13'),
(4352,3,2,50,'2023-04-13 14:10:00','2023-04-13 14:20:00',600,'Riconsegnato portatile Gigio dopo assistenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-05-05 09:36:16','2023-04-13'),
(4353,1,6,3,'2023-04-13 14:02:00','2023-04-13 14:27:00',1500,'con benedetta per preventivo',18.75,NULL,45,1,'Europe/Rome',18.75,1,'work','2023-07-11 14:08:15','2023-04-13'),
(4354,3,2,108,'2023-04-13 15:05:00','2023-04-13 15:25:00',1200,'Assistenza per problemi linea internet, apertura ticket con IRIDEOS',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-07-11 13:34:21','2023-04-13'),
(4355,1,1,67,'2023-04-13 15:00:00','2023-04-13 16:03:00',3780,'mail nuove e config servizio clienti',47.25,NULL,45,1,'Europe/Rome',47.25,1,'work','2023-05-05 15:03:19','2023-04-13'),
(4356,3,1,96,'2023-04-13 07:15:00','2023-04-13 08:30:00',4500,'Assistenza su pc client Marilena per problemi con Thunderbird, ho dovuto reinstallare e configurare da zero la posta elettronica',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-05-19 07:00:19','2023-04-13'),
(4357,3,1,83,'2023-04-13 09:40:00','2023-04-13 09:50:00',600,'Installata una licenza nod32 aggiornamento su pc client Luigi',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-07-12 16:23:30','2023-04-13'),
(4358,1,6,108,'2023-04-13 14:37:00','2023-04-13 14:52:00',900,'problemi connettività',11.25,NULL,45,1,'Europe/Rome',11.25,1,'work','2023-07-11 13:17:42','2023-04-13'),
(4359,1,1,110,'2023-04-13 16:04:00','2023-04-13 16:18:27',867,'creazione utenti nextcloud',10.84,NULL,45,0,'Europe/Rome',10.84,1,'work','2023-04-13 16:18:27','2023-04-13'),
(4360,1,1,50,'2023-04-14 08:22:00','2023-04-14 08:52:29',1829,'problemi teams',22.86,NULL,45,1,'Europe/Rome',22.86,1,'work','2023-05-05 09:36:12','2023-04-14'),
(4361,3,2,91,'2023-04-14 08:25:00','2023-04-14 08:35:00',600,'Consegna toner originali',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-07-12 16:23:55','2023-04-14'),
(4362,1,4,122,'2023-04-14 08:59:00','2023-04-14 09:01:17',137,'ripristino icona nextcloud',1.71,NULL,45,1,'Europe/Rome',1.71,1,'work','2023-07-12 16:27:14','2023-04-14'),
(4363,1,1,3,'2023-04-13 06:46:00','2023-04-13 07:17:00',1860,'freepbx',23.25,NULL,45,1,'Europe/Rome',23.25,1,'work','2023-07-11 14:08:16','2023-04-13'),
(4364,1,1,3,'2023-04-13 13:30:00','2023-04-13 14:00:00',1800,'freepbx',22.5,NULL,45,1,'Europe/Rome',22.5,1,'work','2023-07-11 14:08:13','2023-04-13'),
(4365,1,1,3,'2023-04-14 06:48:00','2023-04-14 08:10:00',4920,'freepbx',61.5,NULL,45,1,'Europe/Rome',61.5,1,'work','2023-07-11 14:08:12','2023-04-14'),
(4366,3,2,50,'2023-04-14 08:50:00','2023-04-14 09:40:00',3000,'Installato Autocad 2024 su portatile figlia Gigio\r\nAssistenza per problemi microfono durante videoconferenza, ritirato mac da ripulire',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-05-05 09:36:12','2023-04-14'),
(4367,1,3,112,'2023-04-14 10:20:00','2023-04-14 10:30:00',600,NULL,7.5,NULL,45,1,'Europe/Rome',7.5,1,'work','2023-07-12 10:21:14','2023-04-14'),
(4368,1,3,112,'2023-04-14 12:30:00','2023-04-14 13:15:00',2700,NULL,33.75,NULL,45,1,'Europe/Rome',33.75,1,'work','2023-07-12 10:21:16','2023-04-14'),
(4369,3,2,79,'2023-04-14 13:20:00','2023-04-14 13:55:00',2100,'Assistenza su PC client Andrea per problemi Thunderbird, consegnato e installato powerline FritzBox',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-07-12 15:31:22','2023-04-14'),
(4370,3,1,88,'2023-04-14 12:40:00','2023-04-14 13:00:00',1200,'Installata vpn su portatile di Giorgio Piazza',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-07-04 09:45:32','2023-04-14'),
(4371,1,1,67,'2023-04-14 13:20:00','2023-04-14 16:30:00',11400,'import posta pino',142.5,NULL,45,1,'Europe/Rome',142.5,1,'work','2023-05-05 15:03:19','2023-04-14'),
(4372,1,1,67,'2023-04-14 19:00:00','2023-04-14 21:00:00',7200,'import posta pino',90,NULL,45,1,'Europe/Rome',90,1,'work','2023-05-05 15:03:21','2023-04-14'),
(4373,3,2,51,'2023-04-17 07:40:00','2023-04-17 08:50:00',4200,'Assistenza su server Linux e Windows per problemi avvio dopo che è stata tolta corrente, ritirato server Windows',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-05-19 13:55:13','2023-04-17'),
(4374,1,1,67,'2023-04-17 06:40:00','2023-04-17 07:00:00',1200,'import posta pino',15,NULL,45,1,'Europe/Rome',15,1,'work','2023-05-05 15:03:25','2023-04-17'),
(4375,1,1,51,'2023-04-17 07:00:00','2023-04-17 07:37:00',2220,'problema riaccensione server',27.75,NULL,45,1,'Europe/Rome',27.75,1,'work','2023-05-19 13:55:16','2023-04-17'),
(4376,1,3,112,'2023-04-17 09:05:00','2023-04-17 10:22:00',4620,NULL,57.75,NULL,45,1,'Europe/Rome',57.75,1,'work','2023-07-12 10:21:13','2023-04-17'),
(4377,1,1,51,'2023-04-17 10:25:00','2023-04-17 12:30:00',7500,'problemi server windows',93.75,NULL,45,1,'Europe/Rome',93.75,1,'work','2023-05-19 13:55:10','2023-04-17'),
(4378,1,1,51,'2023-04-17 08:00:00','2023-04-17 08:40:00',2400,'fede li aiutato nella riaccensione dei server',30,NULL,45,1,'Europe/Rome',30,1,'work','2023-05-19 13:32:17','2023-04-17'),
(4379,3,2,88,'2023-04-17 12:30:00','2023-04-17 12:50:00',1200,'Modificati permessi per accedere a cartelle condivise per utente giorgio.piazza2',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-07-04 09:45:39','2023-04-17'),
(4380,3,1,5,'2023-04-17 13:10:00','2023-04-17 13:20:00',600,'Assistenza per spegnimento server linux e windows',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-06-21 14:05:17','2023-04-17'),
(4381,3,2,104,'2023-04-17 13:30:00','2023-04-17 13:45:00',900,'Consegnati toner compatibili + assistenza su cellulare',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-06-22 14:08:03','2023-04-17'),
(4382,3,1,50,'2023-04-17 14:45:00','2023-04-17 14:55:00',600,'Assistenza su pc client Filippo',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-05-05 09:36:18','2023-04-17'),
(4383,3,2,83,'2023-04-18 10:20:00','2023-04-18 10:50:00',1800,'Risolto problema stampante ad aghi su PC client Roberta',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-07-12 16:23:28','2023-04-18'),
(4384,3,1,57,'2023-04-18 06:40:00','2023-04-18 07:10:00',1800,'Installati nuovi file configurazione vpn su pc client Simona Carlomagno e Mariella Dallachiesa',0,NULL,0,1,'Europe/Rome',0,1,'work','2024-05-20 09:22:25','2023-04-18'),
(4385,3,1,57,'2023-04-18 12:40:00','2023-04-18 13:00:00',1200,'Installati nuovi file configurazione vpn su pc client Emanuela Marcenaro e Silvia Pesce',0,NULL,0,1,'Europe/Rome',0,1,'work','2024-05-20 09:22:25','2023-04-18'),
(4386,3,4,50,'2023-04-18 07:30:00','2023-04-18 08:30:00',3600,'Assistenza e formattazione su mini mac ritirato',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-05-05 09:36:25','2023-04-18'),
(4387,3,1,83,'2023-04-18 08:35:00','2023-04-18 09:15:00',2400,'Assistenza su pc client Roberta per problemi su stampante ad aghi, da finire in loco',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-07-12 16:23:28','2023-04-18'),
(4388,3,2,51,'2023-04-19 09:30:00','2023-04-19 10:45:00',4500,'Riconsegnato e configurato server con proxmox e vm Windows, contattato assistenza Mexal per reinstallazione gestionale (ci aggiornano), assistenza su PC client, ritirato portatile per assistenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-06-21 16:29:19','2023-04-19'),
(4389,1,1,3,'2023-04-19 13:04:00','2023-04-19 15:10:00',7560,'cliente nuovo recco con te',94.5,NULL,45,1,'Europe/Rome',94.5,1,'work','2023-07-11 14:08:07','2023-04-19'),
(4390,1,1,108,'2023-04-19 15:15:00','2023-04-19 16:17:00',3720,'problemi port forwarding',46.5,NULL,45,1,'Europe/Rome',46.5,1,'work','2023-07-11 13:34:32','2023-04-19'),
(4391,3,1,57,'2023-04-19 07:25:00','2023-04-19 08:05:00',2400,'Installati nuovi file configurazione vpn su pc client Simona Sivori, Alessandra Dondero e Roberta Castriconi',0,NULL,0,1,'Europe/Rome',0,1,'work','2024-05-20 09:22:25','2023-04-19'),
(4392,3,1,108,'2023-04-19 12:30:00','2023-04-19 12:55:00',1500,'Assistenza per problemi posta dopo sostituzione router, contattato IRIDEOS',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-07-11 13:34:28','2023-04-19'),
(4393,3,1,108,'2023-04-19 14:30:00','2023-04-19 14:50:00',1200,'Assistenza per problemi posta dopo sostituzione router, contattato IRIDEOS',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-07-11 13:34:29','2023-04-19'),
(4394,3,1,108,'2023-04-19 13:35:00','2023-04-19 13:45:00',600,'Assistenza per problemi posta dopo sostituzione router, contattato IRIDEOS',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-07-11 13:34:21','2023-04-19'),
(4395,3,1,79,'2023-04-19 13:50:00','2023-04-19 14:00:00',600,'Assistenza su pc client Roberto',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-07-12 15:31:22','2023-04-19'),
(4396,1,1,51,'2023-04-17 13:00:00','2023-04-17 15:20:00',8400,'problemi server windows',105,NULL,45,1,'Europe/Rome',105,1,'work','2023-05-19 13:55:09','2023-04-17'),
(4397,1,1,51,'2023-04-17 20:11:00','2023-04-17 21:25:00',4440,'problemi server windows',55.5,NULL,45,1,'Europe/Rome',55.5,1,'work','2023-05-19 13:55:09','2023-04-17'),
(4399,1,1,51,'2023-04-18 06:47:00','2023-04-18 09:00:00',7980,'problemi server windows',99.75,NULL,45,1,'Europe/Rome',99.75,1,'work','2023-06-21 16:29:18','2023-04-18'),
(4400,1,1,67,'2023-04-18 09:12:00','2023-04-18 10:29:00',4620,'import posta pino',57.75,NULL,45,1,'Europe/Rome',57.75,1,'work','2023-05-05 15:03:32','2023-04-18'),
(4401,1,1,51,'2023-04-17 15:20:00','2023-04-17 19:40:00',15600,'problemi server windows',195,NULL,45,1,'Europe/Rome',195,1,'work','2023-05-19 13:55:09','2023-04-17'),
(4402,1,1,51,'2023-04-18 20:07:00','2023-04-18 21:47:00',6000,'problemi server windows',75,NULL,45,1,'Europe/Rome',75,1,'work','2023-06-21 16:29:19','2023-04-18'),
(4403,1,1,51,'2023-04-19 06:45:00','2023-04-19 09:50:00',11100,'problemi server windows',138.75,NULL,45,1,'Europe/Rome',138.75,1,'work','2023-06-21 16:29:31','2023-04-19'),
(4404,3,2,51,'2023-04-20 06:45:00','2023-04-20 07:45:00',3600,'Assistenza per problemi dopo aggiornamenti su Firewall, lavoro da finire nel pomeriggio',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-05-02 15:08:57','2023-04-20'),
(4405,3,2,79,'2023-04-20 08:30:00','2023-04-20 09:00:00',1800,'Sostituzione batteria su ups apc 500 PC client Michele',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-07-12 15:31:35','2023-04-20'),
(4406,3,1,45,'2023-04-19 16:20:00','2023-04-19 17:20:00',3600,'Ripristinata posta su pc client Claudio Rossi per problemi durante spostamento profilo',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-06-09 08:38:37','2023-04-19'),
(4407,3,2,1,'2023-04-20 14:25:00','2023-04-20 14:35:00',600,'Ritirato portatile Alessio Viacava sede Borzoli per assistenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-05-09 09:21:07','2023-04-20'),
(4408,1,3,112,'2023-04-20 15:05:00','2023-04-20 16:30:00',5100,NULL,63.75,NULL,45,1,'Europe/Rome',63.75,1,'work','2023-07-12 10:21:13','2023-04-20'),
(4409,3,2,51,'2023-04-20 14:50:00','2023-04-20 17:35:00',9900,'Assistenza per problemi dopo aggiornamenti Kernel su firewall linux',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-05-02 15:09:00','2023-04-20'),
(4410,3,1,108,'2023-04-20 09:45:00','2023-04-20 09:55:00',600,'Assistenza su pc client Biglietteria per problemi ricezione posta',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-07-11 13:34:29','2023-04-20'),
(4411,3,1,116,'2023-04-20 09:55:00','2023-04-20 10:15:00',1200,'Assistenza su pc client per recupero file excel con problemi',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-10-12 10:03:40','2023-04-20'),
(4412,3,1,5,'2023-04-20 12:30:00','2023-04-20 12:40:00',600,'Assistenza su pc client Paola per problemi con Nod32',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-06-26 16:24:51','2023-04-20'),
(4413,3,1,45,'2023-04-20 13:05:00','2023-04-20 13:15:00',600,'Assistenza su pc client Claudio Rossi per liberare spazio da disco C',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-06-09 08:38:38','2023-04-20'),
(4414,3,1,24,'2023-04-20 13:20:00','2023-04-20 14:00:00',2400,'Installata e configurata posta elettronica su portatile Monica, installati software base, da finire con configurazione VPN',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-05-05 09:41:53','2023-04-20'),
(4415,1,1,3,'2023-04-21 08:28:00','2023-04-21 09:11:22',2602,'per licenza 3cx',32.53,NULL,45,1,'Europe/Rome',32.53,1,'work','2023-07-11 14:08:05','2023-04-21'),
(4416,3,1,24,'2023-04-21 06:50:00','2023-04-21 07:10:00',1200,'COnfigurata vpn su portatile Monica + collegamento a cartelle condivise',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-05-05 09:41:54','2023-04-21'),
(4417,3,1,41,'2023-04-21 07:30:00','2023-04-21 07:40:00',600,'Installata 1 licenza nod32 su 2 pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-06-09 08:10:53','2023-04-21'),
(4418,3,1,90,'2023-04-21 07:40:00','2023-04-21 07:50:00',600,'Installata 1 licenza nod32 su 2 pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-05-03 10:03:08','2023-04-21'),
(4419,3,1,75,'2023-04-21 13:30:00','2023-04-21 14:00:00',1800,'Assistenza su pc client BC Studio per problemi collegamento alle cartelle condivise di Orion',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-07-06 16:28:48','2023-04-21'),
(4420,1,6,50,'2023-04-21 20:28:00','2023-04-21 21:52:00',5040,'con pietro al tel per problemi su server',63,NULL,45,1,'Europe/Rome',63,1,'work','2023-05-05 09:36:22','2023-04-21'),
(4421,1,1,2,'2023-04-21 06:52:00','2023-04-21 08:21:00',5340,'aggiornamenti server',66.75,NULL,45,1,'Europe/Rome',66.75,1,'work','2023-07-12 09:22:32','2023-04-21'),
(4422,1,1,5,'2023-04-21 09:21:00','2023-04-21 10:30:00',4140,'agg server',51.75,NULL,45,1,'Europe/Rome',51.75,1,'work','2023-06-20 09:52:23','2023-04-21'),
(4423,1,1,55,'2023-04-21 12:46:00','2023-04-21 14:28:00',6120,'agg server',76.5,NULL,45,1,'Europe/Rome',76.5,1,'work','2023-06-13 10:10:47','2023-04-21'),
(4424,1,1,2,'2023-04-21 14:47:00','2023-04-21 15:49:00',3720,'vm cevasco',46.5,NULL,45,1,'Europe/Rome',46.5,1,'work','2023-07-12 09:25:28','2023-04-21'),
(4425,1,1,4,'2023-04-21 16:01:00','2023-04-21 16:30:00',1740,'agg vm',21.75,NULL,45,1,'Europe/Rome',21.75,1,'work','2023-07-12 16:45:28','2023-04-21'),
(4426,3,1,50,'2023-04-24 08:45:00','2023-04-24 09:05:00',1200,'Assistenza per problemi collegamento al gestionale',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-05-05 09:36:25','2023-04-24'),
(4427,1,1,3,'2023-04-03 06:46:00','2023-04-03 07:15:00',1740,'test agg windows server',21.75,NULL,45,1,'Europe/Rome',21.75,1,'work','2023-07-11 14:08:14','2023-04-03'),
(4428,1,1,3,'2023-04-03 07:46:00','2023-04-03 08:28:00',2520,'test agg windows server',31.5,NULL,45,1,'Europe/Rome',31.5,1,'work','2023-07-11 14:08:14','2023-04-03'),
(4429,1,1,3,'2023-04-03 08:55:00','2023-04-03 10:25:00',5400,'test sagg windows server',67.5,NULL,45,1,'Europe/Rome',67.5,1,'work','2023-07-11 14:08:15','2023-04-03'),
(4430,1,1,50,'2023-04-06 06:50:00','2023-04-06 08:00:00',4200,'verifica pulizia, tentativo automount per apache ssl gestito da windows',52.5,NULL,45,1,'Europe/Rome',52.5,1,'work','2023-05-05 09:36:12','2023-04-06'),
(4431,1,1,3,'2023-04-07 07:23:00','2023-04-07 08:46:00',4980,'test migrazione hmail a nuova ver',62.25,NULL,45,1,'Europe/Rome',62.25,1,'work','2023-07-11 14:08:09','2023-04-07'),
(4432,1,1,3,'2023-04-07 12:54:00','2023-04-07 14:22:00',5280,'test migrazione hmail a nuova ver',66,NULL,45,1,'Europe/Rome',66,1,'work','2023-07-11 14:08:09','2023-04-07'),
(4433,1,1,26,'2023-04-11 06:55:00','2023-04-11 09:30:00',9300,'problemi share samba',116.25,NULL,45,1,'Europe/Rome',116.25,1,'work','2023-07-12 15:40:37','2023-04-11'),
(4434,1,1,3,'2023-04-12 06:33:00','2023-04-12 07:22:00',2940,'per telecamere da casa',36.75,NULL,45,1,'Europe/Rome',36.75,1,'work','2023-07-11 14:08:08','2023-04-12'),
(4435,1,4,3,'2023-04-12 07:36:00','2023-04-12 09:19:00',6180,'discusso per freppbx e iniziato a vedere preparazione vm',77.25,NULL,45,1,'Europe/Rome',77.25,1,'work','2023-07-11 14:08:17','2023-04-12'),
(4436,1,1,50,'2023-04-14 09:20:00','2023-04-14 10:15:00',3300,'cercato di capire differenze teams microsoft',41.25,NULL,45,1,'Europe/Rome',41.25,1,'work','2023-05-05 09:36:16','2023-04-14'),
(4437,1,1,3,'2023-04-20 06:36:00','2023-04-20 08:30:00',6840,'varie per wiki, controllo licenze 3cx',85.5,NULL,45,1,'Europe/Rome',85.5,1,'work','2023-07-11 14:08:06','2023-04-20'),
(4438,1,1,79,'2023-04-20 08:47:00','2023-04-20 10:30:00',6180,'fetchmail inchiodato',77.25,NULL,45,1,'Europe/Rome',77.25,1,'work','2023-07-12 15:31:21','2023-04-20'),
(4439,1,1,1,'2023-04-20 12:47:00','2023-04-20 15:00:00',7980,'agg critico effettuato backup e poi test agg',99.75,NULL,45,1,'Europe/Rome',99.75,1,'work','2023-05-09 09:44:58','2023-04-20'),
(4440,1,1,3,'2023-04-26 06:43:00','2023-04-26 07:25:00',2520,'fogli',31.5,NULL,45,1,'Europe/Rome',31.5,1,'work','2023-07-11 14:08:04','2023-04-26'),
(4441,1,1,3,'2023-03-02 08:10:00','2023-03-02 09:11:00',3660,'agg wind server test',45.75,NULL,45,1,'Europe/Rome',45.75,1,'work','2023-07-11 14:08:43','2023-03-02'),
(4442,1,1,67,'2023-03-23 16:05:00','2023-03-23 17:19:00',4440,'migrazione psota',55.5,NULL,45,1,'Europe/Rome',55.5,1,'work','2023-05-05 14:29:20','2023-03-23'),
(4443,3,2,124,'2023-04-26 09:00:00','2023-04-26 10:30:00',5400,'Assistenza su PC client per problemi lentezza, verificato stato ssd montato da noi e fatto fare aggiornamenti Windows. Al momento non ho riscontrato problemi di lentezza',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-07-13 07:49:34','2023-04-26'),
(4444,3,1,1,'2023-04-26 07:40:00','2023-04-26 07:55:00',900,'Assistenza su firewall per problemi navigazione',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-05-09 09:20:06','2023-04-26'),
(4445,3,1,88,'2023-04-26 08:10:00','2023-04-26 08:20:00',600,'Assistenza su pc client Mauro per problemi certificato posta',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-07-04 09:45:34','2023-04-26'),
(4446,3,1,53,'2023-04-26 12:45:00','2023-04-26 12:55:00',600,'Assistenza su pc client Marco per problema sincronizzazione Google Drive',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-09-23 07:00:36','2023-04-26'),
(4447,3,1,50,'2023-04-26 13:00:00','2023-04-26 13:20:00',1200,'Assistenza su pc client collaboratrice esterna per collegamento remoto a suo pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-05-05 09:36:15','2023-04-26'),
(4448,3,1,79,'2023-04-26 15:40:00','2023-04-26 15:50:00',600,'Impostata risposta automatica su indirizzo mail matteo.parodi@parodinutra.com',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-07-12 15:31:17','2023-04-26'),
(4449,3,1,2,'2023-04-27 07:45:00','2023-04-27 07:55:00',600,'Installato plugin Thunderbird DKIM Verifer su pc client Andrea',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-07-12 09:25:00','2023-04-27'),
(4450,3,1,123,'2023-04-27 12:40:00','2023-04-27 13:05:00',1500,'Messo sotto dominio portatile Cristina',0,NULL,0,1,'Europe/Rome',0,1,'work','2024-04-04 10:16:54','2023-04-27'),
(4451,3,1,96,'2023-04-27 14:55:00','2023-04-27 15:05:00',600,'Assistenza per problema webcam postazione Videoconferenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-05-19 07:00:30','2023-04-27'),
(4452,1,1,87,'2023-04-28 07:55:00','2023-04-28 09:07:00',4320,'verifica mail gmail',54,NULL,45,1,'Europe/Rome',54,1,'work','2023-06-20 09:26:20','2023-04-28'),
(4453,1,4,3,'2023-04-27 06:30:00','2023-04-27 08:00:00',5400,'per preventivi',67.5,NULL,45,1,'Europe/Rome',67.5,1,'work','2023-07-11 14:08:03','2023-04-27'),
(4454,1,1,3,'2023-04-27 08:17:00','2023-04-27 11:10:00',10380,'freepbx',129.75,NULL,45,1,'Europe/Rome',129.75,1,'work','2023-07-11 14:08:02','2023-04-27'),
(4455,1,1,3,'2023-04-27 12:45:00','2023-04-27 16:30:00',13500,'freepbx',168.75,NULL,45,1,'Europe/Rome',168.75,1,'work','2023-07-11 14:08:02','2023-04-27'),
(4456,1,1,2,'2023-04-26 07:40:00','2023-04-26 08:59:00',4740,'cambio mail sito, aggiornamenti sito',59.25,NULL,45,1,'Europe/Rome',59.25,1,'work','2023-07-12 09:25:09','2023-04-26'),
(4457,1,1,32,'2023-04-26 09:13:00','2023-04-26 10:29:00',4560,'agg server',57,NULL,45,1,'Europe/Rome',57,1,'work','2023-07-13 07:57:45','2023-04-26'),
(4458,1,1,3,'2023-04-26 12:49:00','2023-04-26 16:30:00',13260,'freepbx proxmox cluster',165.75,NULL,45,1,'Europe/Rome',165.75,1,'work','2023-07-11 14:08:04','2023-04-26'),
(4459,1,1,3,'2023-04-28 06:51:00','2023-04-28 07:36:00',2700,'proxmox cluster',33.75,NULL,45,1,'Europe/Rome',33.75,1,'work','2023-07-11 14:08:01','2023-04-28'),
(4460,1,1,2,'2023-04-28 09:20:00','2023-04-28 10:22:00',3720,'problemi scheda rete server nmon ha giga',46.5,NULL,45,1,'Europe/Rome',46.5,1,'work','2023-07-12 09:25:22','2023-04-28'),
(4461,1,1,2,'2023-04-28 12:49:00','2023-04-28 14:23:00',5640,'problemi scheda rete server nmon ha giga',70.5,NULL,45,1,'Europe/Rome',70.5,1,'work','2023-07-12 09:25:04','2023-04-28'),
(4462,1,1,3,'2023-04-28 14:43:00','2023-04-28 17:00:00',8220,'proxmox cluster e freepbx',102.75,NULL,45,1,'Europe/Rome',102.75,1,'work','2023-07-11 14:08:00','2023-04-28'),
(4463,1,3,112,'2023-05-02 06:30:00','2023-05-02 07:25:00',3300,NULL,41.25,NULL,45,1,'Europe/Rome',41.25,1,'work','2023-07-12 10:21:12','2023-05-02'),
(4464,1,1,51,'2023-05-02 07:41:00','2023-05-02 08:20:00',2340,'configurazione backup remoto su nostro server',29.25,NULL,45,1,'Europe/Rome',29.25,1,'work','2023-05-19 13:57:51','2023-05-02'),
(4465,3,2,51,'2023-05-02 14:20:00','2023-05-02 14:30:00',600,'Riconsegnato portatile HP dopo sostituzione batteria',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-05-02 15:13:27','2023-05-02'),
(4466,3,1,1,'2023-05-02 08:45:00','2023-05-02 09:10:00',1500,'Assistenza su pc client Roberta per problema virus, da ritirare per verifica approfondita',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-05-09 09:45:08','2023-05-02'),
(4467,3,4,51,'2023-05-02 09:30:00','2023-05-02 10:00:00',1800,'Sostituzione batteria su portatile HP',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-06-21 16:29:28','2023-05-02'),
(4468,3,1,51,'2023-05-02 10:20:00','2023-05-02 10:30:00',600,'Assistenza per problemi accesso a gestionale Mexal',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-06-21 16:29:23','2023-05-02'),
(4469,3,1,26,'2023-05-02 10:30:00','2023-05-02 10:40:00',600,'Assistenza su pc client Banci per problema ricezione mail spam',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-07-12 15:56:04','2023-05-02'),
(4470,1,1,3,'2023-05-02 08:28:00','2023-05-02 10:30:00',7320,'vari backup remoti con problemi, aldorap aciersteeel cristallina',91.5,NULL,45,1,'Europe/Rome',91.5,1,'work','2023-07-11 14:08:00','2023-05-02'),
(4471,1,1,51,'2023-05-03 06:52:00','2023-05-03 08:31:00',5940,'problema burdese outlook\r\nbackup remoto proxmox',74.25,NULL,45,1,'Europe/Rome',74.25,1,'work','2023-06-21 16:29:27','2023-05-03'),
(4472,3,2,1,'2023-05-03 07:50:00','2023-05-03 08:00:00',600,'Ritirato pc client Roberta per assistenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-05-09 09:21:25','2023-05-03'),
(4473,3,1,104,'2023-05-03 08:50:00','2023-05-03 09:20:00',1800,'Assistenza su pc client Sandro per problemi invio mail con più destinatari, intervento da completare',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-05-24 08:46:32','2023-05-03'),
(4474,3,1,96,'2023-05-03 09:30:00','2023-05-03 09:40:00',600,'Riavviati servizi di posta per problemi invio/ricezione',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-05-12 09:17:32','2023-05-03'),
(4475,3,4,1,'2023-05-03 13:30:00','2023-05-03 14:30:00',3600,'Assistenza su pc client Roberta per problemi virus',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-05-09 09:45:02','2023-05-03'),
(4476,3,2,1,'2023-05-04 09:20:00','2023-05-04 09:35:00',900,'Riconsegnato pc client Roberta dopo assistenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-05-09 09:21:30','2023-05-04'),
(4477,3,2,96,'2023-05-04 09:55:00','2023-05-04 10:55:00',3600,'Assistenza su postazione Videocall, da offrire microfono pulisci rumore, assistenza su PC client Gandolfo e Irene',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-05-19 07:00:45','2023-05-04'),
(4478,3,2,50,'2023-05-04 13:30:00','2023-05-04 13:45:00',900,'Riconsegnato mac mini a Giogio dopo reinstallazione s.o, ritirato pc client Filippo per upgrade hw, assistenza su portatile Filippo',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-05-05 09:36:15','2023-05-04'),
(4479,1,1,67,'2023-05-04 13:52:00','2023-05-04 15:07:00',4500,'problemi invio mail',56.25,NULL,45,1,'Europe/Rome',56.25,1,'work','2023-05-05 15:03:20','2023-05-04'),
(4480,3,2,84,'2023-05-04 14:00:00','2023-05-04 14:20:00',1200,'Ritirato portatile Dell marito rui + assistenza su altro portatile marito rui',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-06-22 08:18:20','2023-05-04'),
(4481,3,1,104,'2023-05-04 07:20:00','2023-05-04 07:30:00',600,'Completato intervento problema invio mail a più destinatari di posta',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-05-24 08:46:33','2023-05-04'),
(4482,3,1,12,'2023-05-04 14:50:00','2023-05-04 15:00:00',600,'Assistenza su mac Camilla Corsi per verifica vpn',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-09-28 09:35:10','2023-05-04'),
(4483,3,4,50,'2023-05-04 15:30:00','2023-05-04 16:30:00',3600,'Clonato sistema operativo pc client Filippo su nuovo disco ssd da 1 tb',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-05-05 09:36:27','2023-05-04'),
(4484,3,2,50,'2023-05-05 08:10:00','2023-05-05 08:25:00',900,'Riconsegnato e collegato pc client Filippo',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-05-05 09:36:28','2023-05-05'),
(4485,3,2,90,'2023-05-05 08:40:00','2023-05-05 09:00:00',1200,'Montato disco WD Gold 8tb su server Windows',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-07-13 09:41:36','2023-05-05'),
(4486,1,1,2,'2023-05-05 12:30:00','2023-05-05 12:50:00',1200,'share folder nicolò',15,NULL,45,1,'Europe/Rome',15,1,'work','2023-07-12 09:25:15','2023-05-05'),
(4487,1,1,87,'2023-05-05 12:57:00','2023-05-05 13:20:00',1380,'probl;ema firma',17.25,NULL,45,1,'Europe/Rome',17.25,1,'work','2023-06-20 09:26:21','2023-05-05'),
(4488,1,1,67,'2023-04-15 14:00:00','2023-04-15 16:56:00',10560,'migrazione posta (pino)',132,NULL,45,1,'Europe/Rome',132,1,'work','2023-05-05 15:03:21','2023-04-15'),
(4489,3,4,1,'2023-05-05 12:50:00','2023-05-05 13:50:00',3600,'Assistenza su portatile Alessio Viacava, reinstallato e configurato sistema operativo. Utilizzato: 1 ssd 480gb S3+, 1 ram da 8gb DDR L e sostituzione batteria',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-05-09 09:20:39','2023-05-05'),
(4490,1,1,90,'2023-05-08 12:53:00','2023-05-08 13:25:00',1920,'problemi giotto pc luciano',24,NULL,45,1,'Europe/Rome',24,1,'work','2023-07-13 09:41:25','2023-05-08'),
(4491,3,2,1,'2023-05-08 12:40:00','2023-05-08 13:20:00',2400,'Riconsegnato e configurato portatile Alessio Viacava\r\nApertura porta su router Wind\r\nAssistenza su telefono Franx',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-05-09 09:44:58','2023-05-08'),
(4492,1,1,1,'2023-05-08 13:30:00','2023-05-08 13:44:00',840,'problema dtmf su snom succursale',10.5,NULL,45,1,'Europe/Rome',10.5,1,'work','2023-05-09 09:45:01','2023-05-08'),
(4493,1,1,67,'2023-05-08 13:45:00','2023-05-08 16:29:00',9840,'inolto mail gualco su servizio clienti\r\nstudio per inoltro mail uscita',123,NULL,45,1,'Europe/Rome',123,1,'work','2023-07-13 09:55:05','2023-05-08'),
(4494,3,1,24,'2023-05-08 07:10:00','2023-05-08 07:30:00',1200,'Assistenza su pc client Monica',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-07-13 10:15:56','2023-05-08'),
(4495,3,2,24,'2023-05-08 13:45:00','2023-05-08 14:05:00',1200,'Consegnato multipack Epson (63209) + assistenza su altra stampante Epson',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-07-13 10:16:00','2023-05-08'),
(4496,1,1,90,'2023-05-09 05:00:00','2023-05-09 05:56:00',3360,'problemi irraggingibilità server',42,NULL,45,1,'Europe/Rome',42,1,'work','2023-07-13 09:41:29','2023-05-09'),
(4497,3,2,41,'2023-05-09 13:40:00','2023-05-09 13:50:00',600,'Consegnato: 6 ups apc, 3 switch 5 porta, 3 licenze nod32 complete, 3 licenze nod32 aggiornamento',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-06-09 08:10:57','2023-05-09'),
(4498,1,1,51,'2023-05-09 13:53:00','2023-05-09 15:09:58',4618,'problama posta massimo',57.73,NULL,45,1,'Europe/Rome',57.73,1,'work','2023-06-21 16:29:22','2023-05-09'),
(4499,1,1,3,'2023-05-09 12:30:00','2023-05-09 13:00:00',1800,'saldatura notebook',22.5,NULL,45,1,'Europe/Rome',22.5,1,'work','2023-07-11 14:07:55','2023-05-09'),
(4500,3,1,108,'2023-05-09 06:50:00','2023-05-09 07:00:00',600,'Assistenza su pc client Biglietteria',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-07-11 13:34:22','2023-05-09'),
(4501,3,4,84,'2023-05-09 07:10:00','2023-05-09 08:10:00',3600,'Assistenza su portatile marito, copiati 150gb di dati su HHD esterno WD da 1tb (da fatturare)',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-06-22 08:18:21','2023-05-09'),
(4502,3,1,75,'2023-05-09 08:10:00','2023-05-09 08:40:00',1800,'Copiata cartella softaware Gestionale Aladino su cartella NAS per  backup remoto giornaliero',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-07-06 16:28:57','2023-05-09'),
(4503,3,1,96,'2023-05-09 09:55:00','2023-05-09 10:10:00',900,'Creato indirizzo posta gmail e configurato su pc client Irene, Marilena e Maria',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-05-19 07:00:46','2023-05-09'),
(4504,1,1,3,'2023-05-08 12:30:00','2023-05-08 12:51:00',1260,'varie in lab, saldatura notebook',15.75,NULL,45,1,'Europe/Rome',15.75,1,'work','2023-07-11 14:07:56','2023-05-08'),
(4506,3,2,104,'2023-05-09 14:50:00','2023-05-09 15:00:00',600,'Consegnato tamburo originale per stampante Brother',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-05-24 08:46:16','2023-05-09'),
(4507,1,1,55,'2023-05-10 06:50:00','2023-05-10 07:08:00',1080,'agg firmware ups',13.5,NULL,45,1,'Europe/Rome',13.5,1,'work','2023-06-13 10:10:46','2023-05-10'),
(4508,3,2,96,'2023-05-10 08:50:00','2023-05-10 10:00:00',4200,'Consegnato, installato e testato microfono Jabra\r\nAssistenza su PC client',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-05-19 07:00:47','2023-05-10'),
(4509,3,2,84,'2023-05-10 10:10:00','2023-05-10 10:20:00',600,'Riconsegnato portatile non riparabile + hhd esterno con copia dati',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-06-22 08:18:22','2023-05-10'),
(4510,1,1,2,'2023-05-10 09:00:00','2023-05-10 10:30:00',5400,'fine config pc alessia',67.5,NULL,45,1,'Europe/Rome',67.5,1,'work','2023-07-12 09:25:09','2023-05-10'),
(4511,1,1,2,'2023-05-10 12:43:00','2023-05-10 16:37:00',14040,'sistemazione wifi non funzionante, aggiornamento firmware apparati e aggiornamento controller che non si collegava agli apparati, problemi stampante su pc nuovo alessia',175.5,NULL,45,1,'Europe/Rome',175.5,1,'work','2023-07-12 09:25:13','2023-05-10'),
(4512,1,3,112,'2023-05-11 06:30:00','2023-05-11 06:50:00',1200,NULL,15,NULL,45,1,'Europe/Rome',15,1,'work','2023-07-12 10:20:53','2023-05-11'),
(4513,1,1,55,'2023-05-11 14:23:00','2023-05-11 16:28:00',7500,'problemi pc tiziana\r\naggironamenti server',93.75,NULL,45,1,'Europe/Rome',93.75,1,'work','2023-06-13 10:10:50','2023-05-11'),
(4514,1,1,2,'2023-05-11 12:43:00','2023-05-11 14:19:00',5760,'desktop cevasco invaso da icone reset profilo roaming',72,NULL,45,1,'Europe/Rome',72,1,'work','2023-07-12 09:25:04','2023-05-11'),
(4515,3,1,79,'2023-05-11 13:20:00','2023-05-11 13:35:00',900,'Assistenza su pc client Matteo',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-07-12 15:31:27','2023-05-11'),
(4516,3,1,96,'2023-05-11 14:05:00','2023-05-11 14:45:00',2400,'Assistenza su pc client Confessore per problemi con certificati Desktop Telematico, problema da risolvere',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-05-19 07:00:50','2023-05-11'),
(4517,1,3,112,'2023-05-12 08:14:00','2023-05-12 09:40:00',5160,NULL,64.5,NULL,45,1,'Europe/Rome',64.5,1,'work','2023-07-12 10:21:17','2023-05-12'),
(4518,1,1,67,'2023-05-12 06:50:00','2023-05-12 08:10:00',4800,'problemi posta in uscita da microsoft',60,NULL,45,1,'Europe/Rome',60,1,'work','2023-07-13 09:55:01','2023-05-12'),
(4519,1,1,51,'2023-05-12 12:54:00','2023-05-12 12:59:00',300,'problema mail pop in entrata massimo saccardi\r\nmail piena',3.75,NULL,45,1,'Europe/Rome',3.75,1,'work','2023-06-21 16:29:26','2023-05-12'),
(4520,1,1,6,'2023-05-02 12:48:00','2023-05-02 14:00:00',4320,'agg nas',54,NULL,45,1,'Europe/Rome',54,1,'work','2023-06-26 16:34:13','2023-05-02'),
(4521,1,1,5,'2023-05-02 14:12:00','2023-05-02 16:29:00',8220,'agg nas e server',102.75,NULL,45,1,'Europe/Rome',102.75,1,'work','2023-06-20 09:52:21','2023-05-02'),
(4522,1,1,1,'2023-05-03 08:47:00','2023-05-03 10:30:00',6180,'agg server 1h\r\nagg 3cx rimanente',77.25,NULL,45,1,'Europe/Rome',77.25,1,'work','2023-07-13 08:32:54','2023-05-03'),
(4523,1,1,17,'2023-05-03 12:49:00','2023-05-03 15:00:00',7860,'agg qnap e backupc',98.25,NULL,45,1,'Europe/Rome',98.25,1,'work','2023-07-11 15:05:06','2023-05-03'),
(4524,1,1,24,'2023-05-03 15:18:00','2023-05-03 16:28:00',4200,'agg 3cx',52.5,NULL,45,1,'Europe/Rome',52.5,1,'work','2023-06-30 16:21:28','2023-05-03'),
(4525,1,1,3,'2023-05-04 06:30:00','2023-05-04 07:00:00',1800,'con te all\'iper riportato mac mini gigio',22.5,NULL,45,1,'Europe/Rome',22.5,1,'work','2023-07-11 14:08:33','2023-05-04'),
(4526,1,1,29,'2023-05-04 07:16:00','2023-05-04 09:00:00',6240,'agg server',78,NULL,45,1,'Europe/Rome',78,1,'work','2023-07-13 08:35:30','2023-05-04'),
(4527,1,1,95,'2023-05-04 09:14:00','2023-05-04 10:24:00',4200,'agg vari',52.5,NULL,45,1,'Europe/Rome',52.5,1,'work','2023-06-27 08:35:49','2023-05-04'),
(4528,1,1,95,'2023-05-04 12:43:00','2023-05-04 13:34:00',3060,'agg vari',38.25,NULL,45,1,'Europe/Rome',38.25,1,'work','2023-06-27 08:35:51','2023-05-04'),
(4529,1,1,96,'2023-05-04 15:24:00','2023-05-04 16:28:00',3840,'agg vm 3cx',48,NULL,45,1,'Europe/Rome',48,1,'work','2023-05-16 15:51:14','2023-05-04'),
(4530,1,4,3,'2023-05-05 06:30:00','2023-05-05 07:30:00',3600,'in lab',45,NULL,45,1,'Europe/Rome',45,1,'work','2023-07-11 14:07:58','2023-05-05'),
(4531,1,1,3,'2023-05-05 07:45:00','2023-05-05 10:28:00',9780,'test proxmox cluster',122.25,NULL,45,1,'Europe/Rome',122.25,1,'work','2023-07-11 14:07:57','2023-05-05'),
(4532,1,1,3,'2023-05-05 13:41:00','2023-05-05 16:27:00',9960,'test proxmox cluster',124.5,NULL,45,1,'Europe/Rome',124.5,1,'work','2023-07-11 14:07:57','2023-05-05'),
(4533,1,1,50,'2023-05-08 07:00:00','2023-05-08 09:00:00',7200,'agg vari firmware',90,NULL,45,1,'Europe/Rome',90,1,'work','2023-06-09 08:00:01','2023-05-08'),
(4534,1,1,79,'2023-05-08 09:18:00','2023-05-08 10:24:00',3960,'agg vm',49.5,NULL,45,1,'Europe/Rome',49.5,1,'work','2023-07-12 15:31:27','2023-05-08'),
(4535,1,1,90,'2023-05-09 06:46:00','2023-05-09 08:45:00',7140,'verifica blocco',89.25,NULL,45,1,'Europe/Rome',89.25,1,'work','2023-07-13 09:41:24','2023-05-09'),
(4536,1,1,1,'2023-05-09 09:12:00','2023-05-09 10:21:00',4140,'problema dtmf',51.75,NULL,45,1,'Europe/Rome',51.75,1,'work','2023-07-13 08:03:49','2023-05-09'),
(4537,1,1,3,'2023-05-09 15:16:00','2023-05-09 16:30:00',4440,'proxmox cluster',55.5,NULL,45,1,'Europe/Rome',55.5,1,'work','2023-07-11 14:07:55','2023-05-09'),
(4538,1,1,3,'2023-05-10 07:23:00','2023-05-10 08:53:00',5400,'proxmox  cluster',67.5,NULL,45,1,'Europe/Rome',67.5,1,'work','2023-07-11 14:07:54','2023-05-10'),
(4539,1,1,3,'2023-05-11 07:05:00','2023-05-11 10:28:00',12180,'proxmox cluster',152.25,NULL,45,1,'Europe/Rome',152.25,1,'work','2023-07-11 14:07:53','2023-05-11'),
(4540,3,1,64,'2023-05-12 08:15:00','2023-05-12 08:25:00',600,'Assistenza su pc client Mirella per cartella condivisa persa',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-06-09 07:59:27','2023-05-12'),
(4541,1,1,90,'2023-05-15 08:00:00','2023-05-15 08:23:00',1380,'problemi giotto',17.25,NULL,45,1,'Europe/Rome',17.25,1,'work','2023-07-13 09:41:25','2023-05-15'),
(4542,1,3,112,'2023-05-15 09:13:00','2023-05-15 10:30:00',4620,NULL,57.75,NULL,45,1,'Europe/Rome',57.75,1,'work','2023-07-12 10:21:03','2023-05-15'),
(4543,3,2,50,'2023-05-15 08:15:00','2023-05-15 10:15:00',7200,'Assistenza su PC client Filippo per problemi lentezza dopo aver clonato s.o su nuovo ssd, assistenza su stampante Epson Loretta, installata un licenza agg nod32 su 2 PC client',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-06-09 08:00:08','2023-05-15'),
(4544,1,2,9,'2023-05-15 12:22:00','2023-05-15 13:39:00',4620,'configurazione nuova linea fibra',57.75,NULL,45,1,'Europe/Rome',57.75,1,'work','2023-07-13 14:02:47','2023-05-15'),
(4545,1,3,112,'2023-05-15 14:20:00','2023-05-15 14:50:00',1800,NULL,22.5,NULL,45,1,'Europe/Rome',22.5,1,'work','2023-07-12 10:20:54','2023-05-15'),
(4546,3,4,104,'2023-05-15 07:00:00','2023-05-15 08:00:00',3600,'Reinstallato sistema operativo su portatile Chuwi Sandro',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-05-24 08:47:29','2023-05-15'),
(4547,3,1,96,'2023-05-15 12:30:00','2023-05-15 12:40:00',600,'Finita assistenza su pc client Maria Confessore',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-05-19 07:00:51','2023-05-15'),
(4548,3,1,50,'2023-05-15 12:40:00','2023-05-15 12:50:00',600,'Assistenza su pc client Loretta',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-06-09 08:00:13','2023-05-15'),
(4549,3,1,5,'2023-05-15 13:15:00','2023-05-15 13:25:00',600,'Installato plotter HP su pc client Miriam',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-06-26 16:24:56','2023-05-15'),
(4550,3,2,50,'2023-05-16 06:50:00','2023-05-16 07:00:00',600,'Ritirato pc client Filippo per assistenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-06-09 08:00:02','2023-05-16'),
(4551,3,2,96,'2023-05-16 08:05:00','2023-05-16 08:30:00',1500,'Assistenza per problemi su corrente elettrica, se ne deve occupare elettricista',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-05-19 07:00:52','2023-05-16'),
(4552,3,2,122,'2023-05-16 08:45:00','2023-05-16 09:10:00',1500,'Sopralluogo nuovi ufficio per cablaggio rete',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-07-12 16:28:10','2023-05-16'),
(4553,3,2,50,'2023-05-16 13:30:00','2023-05-16 13:50:00',1200,'Riconsegnato pc client Filippo dopo assistenza \r\nAssistenza su PC client Loretta',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-06-09 08:00:07','2023-05-16'),
(4554,3,2,5,'2023-05-16 14:10:00','2023-05-16 16:00:00',6600,'Risolto problema navigazione plotter di rete hp\r\nInstallato su tutti pc client, da risolvere problemi stampa sul PC di Miriam',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-06-26 16:24:52','2023-05-16'),
(4555,3,2,96,'2023-05-17 07:45:00','2023-05-17 08:30:00',2700,'Assistenza per problemi avvio servizi dopo che è mancata la corrente, ritirato mini PC firewall che non si avvia',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-09-22 09:55:56','2023-05-17'),
(4556,1,3,112,'2023-05-17 06:30:00','2023-05-17 10:30:00',14400,'banca e recita congedo parentale per tutto il giotrno',180,NULL,45,1,'Europe/Rome',180,1,'work','2023-07-12 10:20:55','2023-05-17'),
(4557,1,1,3,'2023-05-16 06:30:00','2023-05-16 07:21:00',3060,'in lab prima di appuntamento in centro',38.25,NULL,45,1,'Europe/Rome',38.25,1,'work','2023-07-11 14:07:50','2023-05-16'),
(4558,1,1,50,'2023-05-16 07:30:00','2023-05-16 08:30:00',3600,'pc filippo clonato ssd su m2 e sistemato problema posta',45,NULL,45,1,'Europe/Rome',45,1,'work','2023-06-09 08:00:07','2023-05-16'),
(4559,1,1,50,'2023-05-16 09:00:00','2023-05-16 10:24:00',5040,'sistemazione posta pc filippo',63,NULL,45,1,'Europe/Rome',63,1,'work','2023-06-09 08:00:07','2023-05-16'),
(4560,3,2,96,'2023-05-17 13:20:00','2023-05-17 15:10:00',6600,'Riconsegnato e configurato firewall dopo assistenza \r\nAssistenza su PC client + postazione videoconferenza',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-07-13 09:58:34','2023-05-17'),
(4561,3,1,5,'2023-05-17 06:45:00','2023-05-17 07:00:00',900,'Assistenza su pc client Miriam per problemi con spooler stampa',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-06-26 16:24:55','2023-05-17'),
(4562,1,1,83,'2023-05-18 07:18:00','2023-05-18 08:01:31',2611,'problema pc orietta lento',32.64,NULL,45,1,'Europe/Rome',32.64,1,'work','2023-07-12 16:23:32','2023-05-18'),
(4563,3,2,79,'2023-05-18 09:50:00','2023-05-18 10:20:00',1800,'Assistenza su stampante Brother per problemi con toner compatibili',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-07-12 15:31:17','2023-05-18'),
(4564,1,1,26,'2023-05-18 12:31:00','2023-05-18 12:37:58',418,'problema posta banci',5.23,NULL,45,1,'Europe/Rome',5.23,1,'work','2023-07-12 15:56:01','2023-05-18'),
(4565,1,1,90,'2023-05-18 20:00:00','2023-05-18 20:36:00',2160,'pulizia backuppc manuale',27,NULL,45,1,'Europe/Rome',27,1,'work','2023-07-13 09:41:37','2023-05-18'),
(4566,3,1,1,'2023-05-18 06:55:00','2023-05-18 07:15:00',1200,'Assistenza su portatile Borzoli per problemi con Thunderbird, lavoro da finire perchè il portatile si è spento e non avevano alimentatore',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-07-13 08:32:55','2023-05-18'),
(4567,3,1,96,'2023-05-18 12:30:00','2023-05-18 12:40:00',600,'Ripristinate chiavi vpn Anna Mochi',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-07-13 09:58:29','2023-05-18'),
(4568,1,1,2,'2023-05-19 12:57:00','2023-05-19 17:11:28',15268,'installazione pdf sam su pc alessia\r\nconfig vm per stefano da remoto\r\ntest su nextcloud',190.85,NULL,45,1,'Europe/Rome',190.85,1,'work','2023-07-12 09:25:19','2023-05-19'),
(4569,3,1,55,'2023-05-19 06:55:00','2023-05-19 07:10:00',900,'Preparate e inviate nuove chiavi vpn a Stefano per pc casa',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-06-13 10:10:58','2023-05-19'),
(4570,3,1,84,'2023-05-19 07:40:00','2023-05-19 07:55:00',900,'Assistenza su pc client',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-06-30 16:21:01','2023-05-19'),
(4571,3,1,1,'2023-05-19 13:20:00','2023-05-19 14:20:00',3600,'Assistenza su portatile Borzoli per problemi su Thunderbird',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-07-13 08:33:02','2023-05-19'),
(4572,3,1,100,'2023-05-19 14:45:00','2023-05-19 15:00:00',900,'Creati 2 nuovi indirizzi di posta',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-07-13 15:31:32','2023-05-19'),
(4573,3,2,124,'2023-05-22 14:05:00','2023-05-22 15:45:00',6000,'Assistenza su PC client per problemi lentezza software gestionale ADOHC, ritirato pc client per installazione s.o pulito',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-07-13 07:49:37','2023-05-22'),
(4574,1,1,3,'2023-05-12 09:45:00','2023-05-12 10:30:00',2700,'proxmox cluster',33.75,NULL,45,1,'Europe/Rome',33.75,1,'work','2023-07-11 14:07:53','2023-05-12'),
(4575,1,1,3,'2023-05-12 13:10:00','2023-05-12 16:25:00',11700,'proxmox cluster e freepbx',146.25,NULL,45,1,'Europe/Rome',146.25,1,'work','2023-07-11 14:07:52','2023-05-12'),
(4576,1,1,3,'2023-05-15 06:45:00','2023-05-15 07:55:00',4200,'proxmox cluster e frepbx',52.5,NULL,45,1,'Europe/Rome',52.5,1,'work','2023-07-11 14:07:51','2023-05-15'),
(4577,1,1,2,'2023-05-15 08:30:00','2023-05-15 09:10:00',2400,'vm cevasco',30,NULL,45,1,'Europe/Rome',30,1,'work','2023-07-12 09:25:08','2023-05-15'),
(4578,1,1,2,'2023-05-15 14:58:00','2023-05-15 16:29:00',5460,'vm cevasco',68.25,NULL,45,1,'Europe/Rome',68.25,1,'work','2023-07-12 09:25:18','2023-05-15'),
(4579,1,1,50,'2023-05-16 12:42:00','2023-05-16 13:55:00',4380,'posta filippo\r\nagg firmware tel e 3cx',54.75,NULL,45,1,'Europe/Rome',54.75,1,'work','2023-06-09 08:00:03','2023-05-16'),
(4580,1,1,3,'2023-05-16 14:10:00','2023-05-16 16:30:00',8400,'proxmox cluster',105,NULL,45,1,'Europe/Rome',105,1,'work','2023-07-11 14:07:34','2023-05-16'),
(4581,1,1,96,'2023-05-17 13:50:00','2023-05-17 14:05:00',900,'test teams fede li',11.25,NULL,45,1,'Europe/Rome',11.25,1,'work','2023-06-07 08:37:59','2023-05-17'),
(4582,1,1,3,'2023-05-17 12:45:00','2023-05-17 13:43:00',3480,'proxmox cluster',43.5,NULL,45,1,'Europe/Rome',43.5,1,'work','2023-07-11 14:08:21','2023-05-17'),
(4583,1,1,2,'2023-05-17 14:15:00','2023-05-17 17:00:00',9900,'risoluzione problemi profili roaming con installazione vm nextcloud',123.75,NULL,45,1,'Europe/Rome',123.75,1,'work','2023-07-12 09:25:07','2023-05-17'),
(4584,1,1,2,'2023-05-18 06:47:00','2023-05-18 07:10:00',1380,'risoluzione problemi profili roaming con installazione vm nextcloud',17.25,NULL,45,1,'Europe/Rome',17.25,1,'work','2023-07-12 09:25:35','2023-05-18'),
(4585,1,1,2,'2023-05-18 08:25:00','2023-05-18 10:30:00',7500,'risoluzione problemi profili roaming con installazione vm nextcloud',93.75,NULL,45,1,'Europe/Rome',93.75,1,'work','2023-07-12 09:25:06','2023-05-18'),
(4586,1,1,3,'2023-05-18 12:48:00','2023-05-18 16:30:00',13320,'proxmox cluster\r\nfreepbx',166.5,NULL,45,1,'Europe/Rome',166.5,1,'work','2023-07-11 14:07:49','2023-05-18'),
(4587,1,1,5,'2023-05-19 06:50:00','2023-05-19 09:00:00',7800,'agg server',97.5,NULL,45,1,'Europe/Rome',97.5,1,'work','2023-06-20 09:52:35','2023-05-19'),
(4588,1,1,79,'2023-05-19 09:18:00','2023-05-19 10:30:00',4320,'agg vm',54,NULL,45,1,'Europe/Rome',54,1,'work','2023-07-12 15:31:21','2023-05-19'),
(4589,1,1,79,'2023-05-23 06:48:00','2023-05-23 09:05:00',8220,'problema posta',102.75,NULL,45,1,'Europe/Rome',102.75,1,'work','2023-07-12 15:31:23','2023-05-23'),
(4590,1,1,2,'2023-05-22 15:26:00','2023-05-22 16:50:00',5040,'cevasco config connessione vpn su mac e rdp su vm preparata',63,NULL,45,1,'Europe/Rome',63,1,'work','2023-12-29 15:55:21','2023-05-22'),
(4591,1,1,1,'2023-05-22 06:57:00','2023-05-22 08:40:00',6180,'agg server posta e 3cx',77.25,NULL,45,1,'Europe/Rome',77.25,1,'work','2023-07-13 08:33:19','2023-05-22'),
(4592,1,1,95,'2023-05-22 09:00:00','2023-05-22 10:30:00',5400,'agg server',67.5,NULL,45,1,'Europe/Rome',67.5,1,'work','2023-06-27 08:35:52','2023-05-22'),
(4593,1,1,3,'2023-05-22 12:45:00','2023-05-22 15:15:00',9000,'freepbx e proxmox cluster',112.5,NULL,45,1,'Europe/Rome',112.5,1,'work','2023-07-11 14:07:48','2023-05-22'),
(4594,3,2,55,'2023-05-23 07:35:00','2023-05-23 08:10:00',2100,'Sostituzione 2 batterie su ups apc 1400\r\nInstallate 2 licenze nod32 aggiornamento',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-06-13 10:10:45','2023-05-23'),
(4595,1,3,112,'2023-05-23 09:10:00','2023-05-23 10:30:00',4800,'surroga',60,NULL,45,1,'Europe/Rome',60,1,'work','2023-07-12 10:21:02','2023-05-23'),
(4596,1,1,2,'2023-05-23 12:53:00','2023-05-23 14:42:00',6540,'creazione configurazione mail elisabetta@lacristallinawater.it 10 min\r\nproblemi permessi dopo creazione utente su nostro server',81.75,NULL,45,1,'Europe/Rome',81.75,1,'work','2023-12-29 15:55:21','2023-05-23'),
(4597,3,2,124,'2023-05-23 14:35:00','2023-05-23 15:20:00',2700,'Riconsegnato e configurato pc client dopo reinstallazione sistema operativo',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-07-13 07:49:36','2023-05-23'),
(4598,3,1,79,'2023-05-23 08:45:00','2023-05-23 09:00:00',900,'Assistenza su pc client Silvia per problemi accesso Account Microsoft',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-07-12 15:31:26','2023-05-23'),
(4599,3,1,75,'2023-05-23 09:00:00','2023-05-23 09:35:00',2100,'Assistenza su pc client Gianfranco Figari per problemi su Thunderbird',0,NULL,0,1,'Europe/Rome',0,1,'work','2023-07-06 16:28:53','2023-05-23'),
(4600,3,1,101,'2023-05-23 09:50:00','2023-05-23 1